/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.component.JNotificationFrame;
import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ElementArbre;
import fr.pgh.data.bdd.Intervention;
import fr.pgh.data.bdd.InterventionType;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.LMFileAttachment;
import transpo.system.ui.modele.LMSavableFile;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.PnlAttachment;
import transpo.system.ui.views.sync.SynchronizedOptionDialog;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;
import transpo.system.util.messaging.MessageSystemManager;

public class DialogIntervention
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlBtn = null;
    private JButton btnSave = null;
    private JButton btnCancel = null;
    private JPanel pnlContent = null;
    private JLabel lblVehicle = null;
    private JPanel pnlData = null;
    private JLabel lblDate = null;
    private JLabel lblKm = null;
    private JLabel lblPerformer = null;
    private JLabel lblCost = null;
    private JLabel lblType = null;
    private JTextField txtDate = null;
    private JTextField txtKm = null;
    private JTextField txtPerformer = null;
    private JTextField txtCost = null;
    private JComboBox cbType = null;
    private JTextField txtVehicle = null;
    private Vehicule selected = null;
    private Vector<VehicleUsed> ioList = null;
    private JTextField txtMo = null;
    private JLabel lblMo = null;
    private JLabel lblState = null;
    private JComboBox cbState = null;
    private Intervention toShow = null;
    private PnlAttachment pnlAttachment = null;

    public DialogIntervention(Frame owner) {
        super(owner);
        this.initialize();
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    private void initialize() {
        this.setSize(550, 290);
        this.setTitle(LanguageTranslator.getString("intervention.add.title"));
        this.setModal(true);
        this.setLocationRelativeTo(this.getParent());
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints3 = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(0, 2, 0, 2));
            GridBagConstraints gcbAttachment = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 1, -1, new Insets(0, 2, 0, 2));
            GridBagConstraints gridBagConstraints = Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 3, 13, new Insets(5, 5, 5, 5));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlContent(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getPnlBtn(), gridBagConstraints);
            this.jContentPane.add((Component)this.getPnlAttachment(), gcbAttachment);
        }
        return this.jContentPane;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 1);
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 0;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnSave(), gridBagConstraints1);
            this.pnlBtn.add((Component)this.getBtnCancel(), gridBagConstraints2);
        }
        return this.pnlBtn;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setPreferredSize(new Dimension(25, 25));
            this.btnSave.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_valid"))));
            this.btnSave.setToolTipText(LanguageTranslator.getString("button.valid"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogIntervention.this.add()) {
                        DialogIntervention.this.dispose();
                    }
                }
            });
        }
        return this.btnSave;
    }

    public boolean add() {
        boolean toReturn = false;
        if (!this.check()) {
            return false;
        }
        int vehicleId = this.selected.getCleVehicule();
        int interventionId = ((ComboBoxModel)this.getCbType().getModel()).getSelectedCle();
        Date day = ConversionTime.stringToDate(this.getTxtDate().getText(), "dd/MM/yyyy");
        int km = Integer.parseInt(this.getTxtKm().getText());
        Float moCost = Float.valueOf(Float.parseFloat(this.getTxtMo().getText()));
        Float cost = Float.valueOf(Float.parseFloat(this.getTxtCost().getText()));
        String attachment = "";
        Enumeration<?> tmp = ((LMFileAttachment)this.getPnlAttachment().getListAttachment().getModel()).getFiles();
        while (tmp.hasMoreElements()) {
            attachment = String.valueOf(attachment) + ";" + tmp.nextElement().toString();
        }
        if (this.toShow == null) {
            this.toShow = new Intervention();
        }
        BddTransport.getInstance().startTransaction();
        toReturn = this.toShow.compareAndUpdate(interventionId, vehicleId, day, km, this.getTxtPerformer().getText(), moCost.floatValue(), cost.floatValue(), this.getCbState().getSelectedIndex(), attachment.equals("") ? null : attachment.substring(1));
        if (!toReturn) {
            BddTransport.getInstance().rollback();
        } else {
            BddTransport.getInstance().commit();
        }
        return toReturn;
    }

    public boolean check() {
        boolean toReturn = true;
        if (this.selected == null) {
            this.getTxtVehicle().setBackground(new Color(255, 192, 203));
            this.getTxtVehicle().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtVehicle().setBackground(Color.white);
        }
        if (((ComboBoxModel)this.getCbType().getModel()).getSelectedCle() == 0) {
            this.getCbType().setBackground(new Color(255, 192, 203));
            this.getCbType().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        }
        if (this.getTxtKm().getText().equals("") || !Fonctions.isInt(this.getTxtKm().getText())) {
            this.getTxtKm().setBackground(new Color(255, 192, 203));
            this.getTxtKm().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtKm().setBackground(Color.white);
        }
        if (this.getTxtPerformer().getText().equals("")) {
            this.getTxtPerformer().setBackground(new Color(255, 192, 203));
            this.getTxtPerformer().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtPerformer().setBackground(Color.white);
        }
        if (this.getTxtDate().getText().equals("")) {
            this.getTxtDate().setBackground(new Color(255, 192, 203));
            this.getTxtDate().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtDate().setBackground(Color.white);
        }
        if (this.getTxtCost().getText().equals("") || !Fonctions.isFloat(this.getTxtCost().getText())) {
            this.getTxtCost().setBackground(new Color(255, 192, 203));
            this.getTxtCost().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtCost().setBackground(Color.white);
        }
        if (this.getCbState().getSelectedIndex() == 3) {
            this.getCbState().setBackground(new Color(255, 192, 203));
            this.getCbState().setToolTipText(LanguageTranslator.getString("message.state.suggestedError"));
            toReturn = false;
        } else {
            this.getCbState().setBackground(Color.white);
        }
        return toReturn;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setPreferredSize(new Dimension(25, 25));
            this.btnCancel.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_sup"))));
            this.btnCancel.setToolTipText(LanguageTranslator.getString("button.cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogIntervention.this.dispose();
                }
            });
        }
        return this.btnCancel;
    }

    private JPanel getPnlContent() {
        if (this.pnlContent == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints5.gridy = 1;
            this.pnlContent = new JPanel();
            this.pnlContent.setLayout(new GridBagLayout());
            this.pnlContent.add((Component)this.getPnlData(), gridBagConstraints5);
        }
        return this.pnlContent;
    }

    private JPanel getPnlData() {
        if (this.pnlData == null) {
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.fill = 1;
            gridBagConstraints21.gridy = 7;
            gridBagConstraints21.weightx = 1.0;
            gridBagConstraints21.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints21.gridx = 1;
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.gridx = 0;
            gridBagConstraints20.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints20.anchor = 17;
            gridBagConstraints20.gridy = 7;
            this.lblState = new JLabel();
            this.lblState.setText(LanguageTranslator.getString("generics.state"));
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints8.gridy = 6;
            this.lblMo = new JLabel();
            this.lblMo.setText(LanguageTranslator.getString("generics.moCost"));
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.gridy = 6;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.fill = 2;
            gridBagConstraints14.gridx = 1;
            gridBagConstraints14.gridy = 0;
            gridBagConstraints14.weightx = 2.0;
            gridBagConstraints14.weighty = 1.0;
            gridBagConstraints14.insets = new Insets(0, 0, 0, 5);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.insets = new Insets(0, 5, 0, 5);
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.fill = 1;
            gridBagConstraints19.gridy = 1;
            gridBagConstraints19.weightx = 1.0;
            gridBagConstraints19.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints19.gridx = 1;
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.fill = 1;
            gridBagConstraints18.gridy = 5;
            gridBagConstraints18.weightx = 1.0;
            gridBagConstraints18.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints18.gridx = 1;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.fill = 1;
            gridBagConstraints17.gridy = 4;
            gridBagConstraints17.weightx = 1.0;
            gridBagConstraints17.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints17.gridx = 1;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.fill = 1;
            gridBagConstraints16.gridy = 3;
            gridBagConstraints16.weightx = 1.0;
            gridBagConstraints16.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints16.gridx = 1;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.fill = 3;
            gridBagConstraints15.gridy = 2;
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints15.gridx = 1;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.anchor = 17;
            gridBagConstraints13.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints13.gridy = 1;
            this.lblType = new JLabel();
            this.lblType.setText(LanguageTranslator.getString("intervention.type"));
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.anchor = 17;
            gridBagConstraints12.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints12.gridy = 5;
            this.lblCost = new JLabel();
            this.lblCost.setText(LanguageTranslator.getString("generics.cost"));
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints11.gridy = 4;
            this.lblPerformer = new JLabel();
            this.lblPerformer.setText(LanguageTranslator.getString("intervention.performer"));
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.anchor = 17;
            gridBagConstraints10.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints10.gridy = 3;
            this.lblKm = new JLabel();
            this.lblKm.setText(LanguageTranslator.getString("generics.km"));
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints9.gridy = 2;
            this.lblVehicle = new JLabel();
            this.lblVehicle.setText(LanguageTranslator.getString("generics.vehicle"));
            this.lblDate = new JLabel();
            this.lblDate.setText(LanguageTranslator.getString("generics.date"));
            this.pnlData = new JPanel();
            this.pnlData.setLayout(new GridBagLayout());
            this.pnlData.add((Component)this.lblDate, gridBagConstraints9);
            this.pnlData.add((Component)this.lblKm, gridBagConstraints10);
            this.pnlData.add((Component)this.lblPerformer, gridBagConstraints11);
            this.pnlData.add((Component)this.lblCost, gridBagConstraints12);
            this.pnlData.add((Component)this.lblType, gridBagConstraints13);
            this.pnlData.add((Component)this.getTxtDate(), gridBagConstraints15);
            this.pnlData.add((Component)this.getTxtKm(), gridBagConstraints16);
            this.pnlData.add((Component)this.getTxtPerformer(), gridBagConstraints17);
            this.pnlData.add((Component)this.getTxtCost(), gridBagConstraints18);
            this.pnlData.add((Component)this.getCbType(), gridBagConstraints19);
            this.pnlData.add((Component)this.lblVehicle, gridBagConstraints4);
            this.pnlData.add((Component)this.getTxtVehicle(), gridBagConstraints6);
            this.pnlData.add((Component)this.getTxtMo(), gridBagConstraints7);
            this.pnlData.add((Component)this.lblMo, gridBagConstraints8);
            this.pnlData.add((Component)this.lblState, gridBagConstraints20);
            this.pnlData.add((Component)this.getCbState(), gridBagConstraints21);
        }
        return this.pnlData;
    }

    private JTextField getTxtDate() {
        if (this.txtDate == null) {
            this.txtDate = new JTextField();
            this.txtDate.setPreferredSize(new Dimension(70, 20));
            this.txtDate.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Fonctions.afficheCalendrier(DialogIntervention.this.getTxtDate())) {
                        DialogIntervention.this.getTxtDate().setBackground(Color.white);
                        int km = 0;
                        boolean found = false;
                        Date selectedDay = ConversionTime.stringToDate(DialogIntervention.this.getTxtDate().getText(), "dd/MM/yyyy");
                        for (VehicleUsed tmp : DialogIntervention.this.ioList) {
                            if (tmp.getDateDebut() == null || tmp.getDateFin() == null) continue;
                            Date end = tmp.getDateFin();
                            km = tmp.getKmDebut();
                            if (!selectedDay.before(end) || tmp.getLecteur() != 0 || tmp.getKmDebut() < 0 || tmp.getKmDebut() >= 16000000) continue;
                            TimsLogger.debug("#DialogIntervention.getTxtDate# before end " + tmp.getDateDebut() + " " + tmp.getDateFin() + " " + tmp.getKmDebut() + " " + tmp.getKmFin());
                            found = true;
                            break;
                        }
                        DialogIntervention.this.getTxtKm().setText(String.valueOf(km));
                        if (!found) {
                            DialogIntervention.this.getTxtKm().setBackground(new Color(250, 233, 145));
                            DialogIntervention.this.getTxtKm().setToolTipText(LanguageTranslator.getString("intervention.unreacheable"));
                        } else {
                            DialogIntervention.this.getTxtKm().setBackground(Color.white);
                            DialogIntervention.this.getTxtKm().setToolTipText(LanguageTranslator.getString("intervention.reacheable"));
                        }
                    }
                }
            });
        }
        return this.txtDate;
    }

    private JTextField getTxtKm() {
        if (this.txtKm == null) {
            this.txtKm = new JTextField();
            this.txtKm.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
        }
        return this.txtKm;
    }

    private JTextField getTxtPerformer() {
        if (this.txtPerformer == null) {
            this.txtPerformer = new JTextField();
        }
        return this.txtPerformer;
    }

    private JTextField getTxtCost() {
        if (this.txtCost == null) {
            this.txtCost = new JTextField();
        }
        return this.txtCost;
    }

    private JComboBox getCbType() {
        if (this.cbType == null) {
            this.cbType = new JComboBox();
            this.cbType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (DialogIntervention.this.getCbType().getSelectedIndex() == 0) {
                        return;
                    }
                    InterventionType tmp = (InterventionType)((ComboBoxModel)DialogIntervention.this.getCbType().getModel()).getObjectAt(DialogIntervention.this.getCbType().getSelectedIndex());
                    DialogIntervention.this.getTxtCost().setText(String.valueOf(tmp.getDefaultCost()));
                    DialogIntervention.this.getTxtMo().setText(String.valueOf(tmp.getMoCost()));
                }
            });
            ComboBoxModel tmp = new ComboBoxModel(InterventionType.loadList(false), true, LanguageTranslator.getString("generics.select"));
            this.cbType.setModel(tmp);
        }
        return this.cbType;
    }

    private JTextField getTxtVehicle() {
        if (this.txtVehicle == null) {
            this.txtVehicle = new JTextField();
            this.txtVehicle.setEnabled(false);
        }
        return this.txtVehicle;
    }

    private JTextField getTxtMo() {
        if (this.txtMo == null) {
            this.txtMo = new JTextField();
        }
        return this.txtMo;
    }

    private JComboBox getCbState() {
        if (this.cbState == null) {
            this.cbState = new JComboBox();
            this.cbState.addItem(LanguageTranslator.getString("generics.done"));
            this.cbState.addItem(LanguageTranslator.getString("generics.scheduled"));
            this.cbState.addItem(LanguageTranslator.getString("generics.cancelled"));
            this.cbState.addItem(LanguageTranslator.getString("generics.suggested"));
        }
        return this.cbState;
    }

    public void setSelectedVehicle(Vehicule vehicle) {
        this.selected = vehicle;
        this.getTxtVehicle().setText(this.selected.toString());
        ElementArbre elt = MainFrameTransport.getInstance().getTree().getSelected();
        this.ioList = elt instanceof Vehicule && MainFrameTransport.getInstance().getPnlIO().getIOList() != null ? MainFrameTransport.getInstance().getPnlIO().getIOList() : VehicleUsed.loadListVehicle(0, this.selected.getCleVehicule(), null, null);
        this.getPnlAttachment().getListAttachment().setModel(new LMFileAttachment());
    }

    public void setIntervention(Intervention toShow) {
        this.toShow = toShow;
        try {
            this.setSelectedVehicle(Vehicule.getVehicule(null, toShow.getVehicleId()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.getCbType().setSelectedItem(((ComboBoxModel)this.getCbType().getModel()).getLabel(toShow.getTypeId()));
        this.getTxtDate().setText(ConversionTime.dateToString(toShow.getDay(), "dd/MM/yyyy"));
        this.getTxtKm().setText(String.valueOf(toShow.getKm()));
        this.getTxtPerformer().setText(toShow.getPerformer());
        this.getTxtMo().setText(String.valueOf(toShow.getMoCost()));
        this.getTxtCost().setText(String.valueOf(toShow.getCost()));
        this.getCbState().setSelectedIndex(toShow.getState() >= 3 ? 3 : toShow.getState());
        this.getPnlAttachment().loadAttachment();
    }

    private PnlAttachment getPnlAttachment() {
        if (this.pnlAttachment == null) {
            this.pnlAttachment = new PnlAttachment(2){

                @Override
                public void loadAttachment() {
                    if (DialogIntervention.this.toShow.getAttachment() == null) {
                        this.getListAttachment().setModel(new LMFileAttachment());
                    } else {
                        this.getListAttachment().setModel(new LMFileAttachment(DialogIntervention.this.toShow.getAttachment().split(";")));
                    }
                }

                @Override
                public void deleteAttachment() {
                    SynchronizedOptionDialog tmp = new SynchronizedOptionDialog(LanguageTranslator.getString("message.delete.confirm"), LanguageTranslator.getString("generics.warning"));
                    tmp.run();
                    if (tmp.option == 0) {
                        int[] selected = this.getListAttachment().getSelectedIndices();
                        String file = selected.length == 1 ? ((LMFileAttachment)this.getListAttachment().getModel()).getName(selected[0]) : LanguageTranslator.getString("generics.files");
                        JNotificationFrame frame = JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT);
                        frame.addMessage(LanguageTranslator.getString("attachment.title"), new JLabel(LanguageTranslator.getString("attachment.deleted.content", file)), Fonctions.getSuccessStatusIcon());
                        int x = 0;
                        while (x < selected.length) {
                            ((LMFileAttachment)this.getListAttachment().getModel()).remove(selected[x]);
                            ++x;
                        }
                        frame.showNotification(6);
                    }
                }

                @Override
                public void addAttachment() {
                    new Thread(){

                        @Override
                        public void run() {
                            JFileChooser choix = new JFileChooser(".");
                            choix.setApproveButtonText(LanguageTranslator.getString("button.add"));
                            if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
                                String attached = null;
                                if (!Fonctions.checkFileSize(choix.getSelectedFile())) {
                                    return;
                                }
                                attached = FileManager.moveFile(DialogIntervention.this.selected, choix.getSelectedFile());
                                JNotificationFrame frame = JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT);
                                if (attached != null) {
                                    frame.addMessage(LanguageTranslator.getString("attachment.title"), new JLabel(LanguageTranslator.getString("attachment.added.content.intervention", choix.getSelectedFile().getName())), Fonctions.getSuccessStatusIcon());
                                    ((LMFileAttachment)this.getListAttachment().getModel()).addElement(attached);
                                }
                                frame.showNotification(6);
                            }
                        }
                    }.start();
                }
            };
            this.pnlAttachment.getBtnExportAttachment().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogIntervention.this.saveFile(DialogIntervention.this.pnlAttachment.getListAttachment(), true);
                }
            });
            this.pnlAttachment.getBtnShowAttachment().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogIntervention.this.showFile(DialogIntervention.this.pnlAttachment.getListAttachment());
                }
            });
        }
        return this.pnlAttachment;
    }

    private void saveFile(JList toSave, boolean open) {
        int[] selected = toSave.getSelectedIndices();
        JFileChooser choix = new JFileChooser(".");
        choix.setApproveButtonText("Sauvegarder les fichiers dans");
        choix.setFileSelectionMode(1);
        if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
            String cheminSave = choix.getSelectedFile().getAbsolutePath();
            int x = 0;
            while (x < selected.length) {
                String nomFichier = ((LMSavableFile)((Object)toSave.getModel())).getName(selected[x]);
                File fichier = FileManager.getFile(this.selected, nomFichier);
                if (fichier == null) {
                    try {
                        MessageSystemManager.error(null, LanguageTranslator.getString("generics.fileNotFound", nomFichier), LanguageTranslator.getString("generics.error"));
                    }
                    catch (Exception ex) {
                        TimsLogger.warn("#DialogIntervention.run# InterruptedException on invokeAndWait ");
                        if (Transport.debug >= 1) {
                            ex.printStackTrace();
                        }
                    }
                } else {
                    Fonctions.copyLocalFile(fichier, new File(cheminSave, nomFichier), System.getProperty("URL") != null);
                }
                ++x;
            }
        }
    }

    private void showFile(JList toShow) {
        int[] selected = toShow.getSelectedIndices();
        if (selected.length == 0) {
            return;
        }
        int x = 0;
        while (x < selected.length) {
            String nomFichier = ((LMSavableFile)((Object)toShow.getModel())).getName(selected[x]);
            File fichier = FileManager.getFile(this.selected, nomFichier);
            if (fichier == null) {
                MessageSystemManager.error(null, LanguageTranslator.getString("generics.fileNotFound", nomFichier), LanguageTranslator.getString("generics.error"));
            } else if (Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                try {
                    Desktop.getDesktop().open(fichier);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++x;
        }
    }
}

