/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.connexion.TimsSession;
import fr.pgh.data.bdd.InterventionType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.LMInterv;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogInterventionType
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlListe = null;
    private JPanel pnlDetail = null;
    private JScrollPane jpsListe = null;
    private JList listInterv = null;
    private JButton btnCreer = null;
    private JPanel pnlBtn = null;
    private JButton btnQuitter = null;
    private JButton btnArchive = null;
    private JButton btnEnregistrer = null;
    private JTextField txtDesignation = null;
    private JLabel lblDesignation = null;
    private JTextField txtCode = null;
    private JLabel lblCode = null;
    private JPanel pnlGeneralRules = null;
    private JCheckBox cbArchive = null;
    private JLabel lblCost = null;
    private JTextField txtCost = null;
    private JLabel lblMoCost = null;
    private JTextField txtMoCost = null;
    private JPanel pnlPeriod = null;
    private JLabel lblKm = null;
    private JTextField txtKm = null;
    private JLabel lblPeriod = null;
    private JTextField txtPeriod = null;
    private InterventionType current = null;
    private JPanel pnlExpiration = null;
    private JCheckBox cbPriority = null;
    private JButton btnLvlUp = null;
    private JButton btnLvlDown = null;
    private boolean priorityChanged = false;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogInterventionType.dispose()#");
        super.dispose();
    }

    public DialogInterventionType(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogInterventionType()#");
        this.initialize();
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    private void initialize() {
        this.setSize(570, 290);
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("intervention.type"));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.insets = new Insets(5, 0, 5, 5);
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlListe(), gridBagConstraints);
            this.jContentPane.add((Component)this.getPnlDetail(), gridBagConstraints1);
        }
        return this.jContentPane;
    }

    private JPanel getPnlListe() {
        if (this.pnlListe == null) {
            this.pnlListe = new JPanel();
            this.pnlListe.setLayout(new GridBagLayout());
            this.pnlListe.setPreferredSize(new Dimension(120, 0));
            this.pnlListe.add((Component)this.getCbPriority(), Fonctions.getGridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 1, -1, new Insets(0, 0, 5, 0)));
            this.pnlListe.add((Component)this.getJpsListe(), Fonctions.getGridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 1, -1, new Insets(0, 0, 5, 0)));
            this.pnlListe.add((Component)this.getBtnLvlUp(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 1, -1, new Insets(0, 0, 5, 0)));
            this.pnlListe.add((Component)this.getBtnLvlDown(), Fonctions.getGridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 1, -1, new Insets(0, 0, 5, 0)));
            this.pnlListe.add((Component)this.getCbArchive(), Fonctions.getGridBagConstraints(0, 2, 1, 2, 0.0, 0.0, -1, -1, new Insets(0, 0, 5, 0)));
            if (ConnexionSettings.getInstance().isAjoutable("INTERVENTION_TYPE")) {
                this.pnlListe.add((Component)this.getBtnCreer(), Fonctions.getGridBagConstraints(0, 3, 1, 2, 0.0, 0.0, -1, -1, null));
            }
        }
        return this.pnlListe;
    }

    private JPanel getPnlDetail() {
        if (this.pnlDetail == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.insets = new Insets(0, 3, 0, 0);
            gridBagConstraints7.gridy = 2;
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 1;
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.weighty = 0.0;
            gridBagConstraints15.fill = 2;
            gridBagConstraints15.gridy = 4;
            GridBagConstraints gridBagConstraints42 = new GridBagConstraints();
            gridBagConstraints42.gridx = 0;
            gridBagConstraints42.fill = 1;
            gridBagConstraints42.insets = new Insets(5, 0, 5, 0);
            gridBagConstraints42.weightx = 1.0;
            gridBagConstraints42.weighty = 0.0;
            gridBagConstraints42.gridwidth = 2;
            gridBagConstraints42.gridy = 2;
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.anchor = 17;
            gridBagConstraints41.gridx = 0;
            gridBagConstraints41.gridy = 6;
            gridBagConstraints41.insets = new Insets(0, 5, 0, 0);
            GridBagConstraints gridBagConstraints40 = new GridBagConstraints();
            gridBagConstraints40.gridx = 0;
            gridBagConstraints40.anchor = 17;
            gridBagConstraints40.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints40.gridy = 3;
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.gridy = 13;
            GridBagConstraints gridBagConstraints30 = new GridBagConstraints();
            gridBagConstraints30.gridx = 0;
            gridBagConstraints30.fill = 2;
            gridBagConstraints30.weightx = 1.0;
            gridBagConstraints30.weighty = 0.0;
            gridBagConstraints30.gridwidth = 2;
            gridBagConstraints30.gridy = 10;
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.gridx = 0;
            gridBagConstraints24.weightx = 1.0;
            gridBagConstraints24.weighty = 1.0;
            gridBagConstraints24.fill = 1;
            gridBagConstraints24.gridwidth = 2;
            gridBagConstraints24.insets = new Insets(2, 0, 0, 0);
            gridBagConstraints24.anchor = 15;
            gridBagConstraints24.gridy = 15;
            this.pnlDetail = new JPanel();
            this.pnlDetail.setLayout(new GridBagLayout());
            this.pnlDetail.add((Component)this.getPnlBtn(), gridBagConstraints24);
            this.pnlDetail.add((Component)this.getPnlGeneralRules(), gridBagConstraints42);
            this.pnlDetail.add((Component)this.getPnlExpiration(), gridBagConstraints15);
        }
        return this.pnlDetail;
    }

    private JScrollPane getJpsListe() {
        if (this.jpsListe == null) {
            this.jpsListe = new JScrollPane();
            this.jpsListe.setPreferredSize(new Dimension(0, 0));
            this.jpsListe.setViewportView(this.getListInterv());
        }
        return this.jpsListe;
    }

    private JList getListInterv() {
        if (this.listInterv == null) {
            this.listInterv = new JList();
            this.listInterv.setModel(new LMInterv(InterventionType.getList()));
            this.listInterv.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && DialogInterventionType.this.getListInterv().getSelectedIndex() != -1) {
                        LMInterv tmp = (LMInterv)DialogInterventionType.this.getListInterv().getModel();
                        DialogInterventionType.this.load(tmp.getInterventionAt(DialogInterventionType.this.getListInterv().getSelectedIndex()));
                    }
                }
            });
        }
        return this.listInterv;
    }

    private JButton getBtnLvlUp() {
        if (this.btnLvlUp == null) {
            this.btnLvlUp = new JButton();
            this.btnLvlUp.setIcon(Fonctions.getIcon("images/up.png"));
            this.btnLvlUp.setEnabled(false);
            this.btnLvlUp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
        }
        return this.btnLvlUp;
    }

    private JButton getBtnLvlDown() {
        if (this.btnLvlDown == null) {
            this.btnLvlDown = new JButton();
            this.btnLvlDown.setIcon(Fonctions.getIcon("images/down.png"));
            this.btnLvlDown.setEnabled(false);
            this.btnLvlDown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
        }
        return this.btnLvlDown;
    }

    private JButton getBtnCreer() {
        if (this.btnCreer == null) {
            this.btnCreer = new JButton();
            this.btnCreer.setText(LanguageTranslator.getString("button.new"));
            this.btnCreer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogInterventionType.this.load(new InterventionType());
                }
            });
        }
        return this.btnCreer;
    }

    private JTextField getTxtPeriod() {
        if (this.txtPeriod == null) {
            this.txtPeriod = new JTextField();
            this.txtPeriod.setPreferredSize(new Dimension(45, 20));
        }
        return this.txtPeriod;
    }

    private JTextField getTxtKm() {
        if (this.txtKm == null) {
            this.txtKm = new JTextField();
        }
        return this.txtKm;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.gridx = 1;
            gridBagConstraints27.anchor = 15;
            gridBagConstraints27.weighty = 1.0;
            gridBagConstraints27.weightx = 1.0;
            gridBagConstraints27.gridy = 0;
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.gridx = 0;
            gridBagConstraints26.anchor = 15;
            gridBagConstraints26.weighty = 1.0;
            gridBagConstraints26.weightx = 1.0;
            gridBagConstraints26.gridy = 0;
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.gridx = 2;
            gridBagConstraints25.anchor = 15;
            gridBagConstraints25.weighty = 1.0;
            gridBagConstraints25.weightx = 1.0;
            gridBagConstraints25.gridy = 0;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnQuitter(), gridBagConstraints25);
            if (ConnexionSettings.getInstance().isSupprimable("INTERVENTION_TYPE")) {
                this.pnlBtn.add((Component)this.getBtnArchive(), gridBagConstraints26);
            }
            if (ConnexionSettings.getInstance().isModifiable("INTERVENTION_TYPE")) {
                this.pnlBtn.add((Component)this.getBtnEnregistrer(), gridBagConstraints27);
            }
        }
        return this.pnlBtn;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogInterventionType.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JButton getBtnArchive() {
        if (this.btnArchive == null) {
            this.btnArchive = new JButton();
            this.btnArchive.setText(LanguageTranslator.getString("button.archive"));
            this.btnArchive.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogInterventionType.this.archive();
                }
            });
        }
        return this.btnArchive;
    }

    public void archive() {
        if (this.current != null && JOptionPane.showConfirmDialog(this, LanguageTranslator.getString("intervention.confirmArchive", this.current.getName()), LanguageTranslator.getString("button.archive"), 0, 2) == 0) {
            this.current.setArchived(true);
            this.current.update();
            this.updateList();
        }
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogInterventionType.this.current != null) {
                        DialogInterventionType.this.save();
                        InterventionType.setList(null);
                        DialogInterventionType.this.updateList();
                    }
                }
            });
        }
        return this.btnEnregistrer;
    }

    private JTextField getTxtDesignation() {
        if (this.txtDesignation == null) {
            this.txtDesignation = new JTextField();
        }
        return this.txtDesignation;
    }

    private JTextField getTxtCode() {
        if (this.txtCode == null) {
            this.txtCode = new JTextField();
        }
        return this.txtCode;
    }

    private JPanel getPnlGeneralRules() {
        if (this.pnlGeneralRules == null) {
            GridBagConstraints gcbLblDesignation = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtDesignation = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 1, 10, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblCode = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtCode = Fonctions.getGridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 1, 10, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblCost = Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtCost = Fonctions.getGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 3, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblMoCost = Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtMoCost = Fonctions.getGridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 3, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbPnlPeriod = Fonctions.getGridBagConstraints(0, 4, 1, 2, 1.0, 1.0, 1, 10, new Insets(5, 5, 5, 5));
            this.lblDesignation = new JLabel();
            this.lblDesignation.setText(LanguageTranslator.getString("generics.designation"));
            this.lblCode = new JLabel();
            this.lblCode.setText(LanguageTranslator.getString("generics.code"));
            this.lblCost = new JLabel();
            this.lblCost.setText(LanguageTranslator.getString("generics.cost"));
            this.lblMoCost = new JLabel();
            this.lblMoCost.setText(LanguageTranslator.getString("generics.moCost"));
            this.pnlGeneralRules = new JPanel();
            this.pnlGeneralRules.setLayout(new GridBagLayout());
            this.pnlGeneralRules.add((Component)this.lblDesignation, gcbLblDesignation);
            this.pnlGeneralRules.add((Component)this.getTxtDesignation(), gcbTxtDesignation);
            this.pnlGeneralRules.add((Component)this.lblCode, gcbLblCode);
            this.pnlGeneralRules.add((Component)this.getTxtCode(), gcbTxtCode);
            this.pnlGeneralRules.add((Component)this.lblCost, gcbLblCost);
            this.pnlGeneralRules.add((Component)this.getTxtCost(), gcbTxtCost);
            this.pnlGeneralRules.add((Component)this.lblMoCost, gcbLblMoCost);
            this.pnlGeneralRules.add((Component)this.getTxtMoCost(), gcbTxtMoCost);
            this.pnlGeneralRules.add((Component)this.getPnlPeriod(), gcbPnlPeriod);
        }
        return this.pnlGeneralRules;
    }

    private JPanel getPnlPeriod() {
        if (this.pnlPeriod == null) {
            GridBagConstraints gcbLblPeriod = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 10, new Insets(2, 5, 2, 5));
            GridBagConstraints gcbTxtPeriod = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 1, 10, new Insets(2, 5, 2, 5));
            GridBagConstraints gcbLblKm = Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, 10, new Insets(2, 5, 2, 5));
            GridBagConstraints gcbTxtKm = Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 1, 10, new Insets(2, 5, 2, 5));
            this.lblKm = new JLabel();
            this.lblKm.setText(LanguageTranslator.getString("intervention.kmBetween2"));
            this.lblPeriod = new JLabel();
            this.lblPeriod.setText(LanguageTranslator.getString("intervention.periodBetween2"));
            this.pnlPeriod = new JPanel();
            this.pnlPeriod.setLayout(new GridBagLayout());
            this.pnlPeriod.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.periodicity")));
            this.pnlPeriod.add((Component)this.lblPeriod, gcbLblPeriod);
            this.pnlPeriod.add((Component)this.getTxtPeriod(), gcbTxtPeriod);
            this.pnlPeriod.add((Component)this.lblKm, gcbLblKm);
            this.pnlPeriod.add((Component)this.getTxtKm(), gcbTxtKm);
        }
        return this.pnlPeriod;
    }

    private JCheckBox getCbArchive() {
        if (this.cbArchive == null) {
            this.cbArchive = new JCheckBox();
            this.cbArchive.setText(LanguageTranslator.getString("generics.seeArchive"));
            this.cbArchive.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean enable = DialogInterventionType.this.getCbArchive().isSelected();
                    DialogInterventionType.this.getListInterv().setModel(new LMInterv(enable ? InterventionType.loadList(enable) : InterventionType.getList()));
                    DialogInterventionType.this.getBtnEnregistrer().setEnabled(!enable);
                    DialogInterventionType.this.getBtnArchive().setEnabled(!enable);
                    DialogInterventionType.this.getBtnCreer().setEnabled(!enable);
                }
            });
        }
        return this.cbArchive;
    }

    private JCheckBox getCbPriority() {
        if (this.cbPriority == null) {
            this.cbPriority = new JCheckBox();
            this.cbPriority.setSelected(true);
            this.cbPriority.setText(LanguageTranslator.getString("generics.seePriority"));
            this.cbPriority.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (DialogInterventionType.this.getCbPriority().isSelected()) {
                        DialogInterventionType.this.getBtnLvlUp().setVisible(true);
                        DialogInterventionType.this.getBtnLvlDown().setVisible(true);
                    } else {
                        DialogInterventionType.this.getBtnLvlUp().setVisible(false);
                        DialogInterventionType.this.getBtnLvlDown().setVisible(false);
                    }
                    DialogInterventionType.this.getPnlListe().repaint();
                }
            });
        }
        return this.cbPriority;
    }

    private JTextField getTxtCost() {
        if (this.txtCost == null) {
            this.txtCost = new JTextField();
            this.txtCost.setPreferredSize(new Dimension(70, 20));
        }
        return this.txtCost;
    }

    private JTextField getTxtMoCost() {
        if (this.txtMoCost == null) {
            this.txtMoCost = new JTextField();
            this.txtMoCost.setPreferredSize(new Dimension(70, 20));
        }
        return this.txtMoCost;
    }

    private void load(InterventionType toLoad) {
        this.current = toLoad;
        this.getTxtDesignation().setText(this.current.getName());
        this.getTxtCode().setText(this.current.getCode());
        this.getTxtPeriod().setText(String.valueOf(this.current.getPeriodExpiration()));
        this.getTxtKm().setText(String.valueOf(this.current.getKmExpiration()));
        this.getTxtCost().setText(String.valueOf(this.current.getDefaultCost()));
        this.getTxtMoCost().setText(String.valueOf(this.current.getMoCost()));
    }

    private void save() {
        if (this.check() && this.current.compareAndUpdate(this.current.getId(), this.getTxtDesignation().getText(), this.getTxtCode().getText(), this.getTxtKm().getText().equals("") ? 0 : Integer.parseInt(this.getTxtKm().getText()), this.getTxtPeriod().getText().equals("") ? 0 : Integer.parseInt(this.getTxtPeriod().getText()), this.getTxtCost().getText().equals("") ? 0.0f : Float.parseFloat(this.getTxtCost().getText()), this.getTxtMoCost().getText().equals("") ? 0.0f : Float.parseFloat(this.getTxtMoCost().getText()), this.current.getSupplies(), this.current.isArchived())) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveSucceed"), LanguageTranslator.getString("message.done"), 1);
        }
    }

    private boolean check() {
        boolean toReturn = true;
        if (this.getTxtDesignation().getText().equals("")) {
            this.getTxtDesignation().setBackground(new Color(255, 192, 203));
            this.getTxtDesignation().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtDesignation().setBackground(Color.white);
        }
        if (this.getTxtCode().getText().equals("")) {
            this.getTxtCode().setBackground(new Color(255, 192, 203));
            this.getTxtCode().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtCode().setBackground(Color.white);
        }
        if (!Fonctions.isInt(this.getTxtKm().getText())) {
            this.getTxtKm().setBackground(new Color(255, 192, 203));
            this.getTxtKm().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtKm().setBackground(Color.white);
        }
        return toReturn;
    }

    public void updateList() {
        this.getListInterv().setModel(new LMInterv(this.getCbArchive().isSelected() ? InterventionType.loadList(true) : InterventionType.getList()));
        this.getListInterv().setSelectedValue(this.current.getName(), true);
    }

    private JPanel getPnlExpiration() {
        if (this.pnlExpiration == null) {
            this.pnlExpiration = new JPanel();
            this.pnlExpiration.setLayout(new GridBagLayout());
        }
        return this.pnlExpiration;
    }
}

