/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Pays;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class DialogPays
extends JDialog
implements ListSelectionListener {
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel6 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel4 = new JPanel();
    JPanel jPanel5 = new JPanel();
    JButton enregistrerButton = new JButton();
    JButton quitterButton = new JButton();
    JButton supprimerButton = new JButton();
    FlowLayout flowLayout1 = new FlowLayout();
    FlowLayout flowLayout2 = new FlowLayout();
    JLabel jLabel1 = new JLabel();
    JTextField paysName = new JTextField();
    FlowLayout flowLayout3 = new FlowLayout();
    JScrollPane jScrollPane2 = new JScrollPane();
    private BddTransport bddEco = null;
    private ListModelPays listModel;
    JList jListPays = new JList();

    @Override
    public void dispose() {
        TimsLogger.debug("#DialogPays.dispose()#");
        super.dispose();
    }

    public void setBddPays(BddTransport bdd) {
        this.bddEco = bdd;
        this.listModel = new ListModelPays(this.bddEco.getPays());
        this.jListPays.setModel(this.listModel);
    }

    public DialogPays(JFrame f) {
        super(f);
        TimsLogger.debug("#DialogPays()#");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DialogPays(JDialog f) {
        super(f);
        TimsLogger.debug("#DialogPays()#");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(LanguageTranslator.getString("generics.country"));
        this.setModal(true);
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel3.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(0);
        this.enregistrerButton.setText(LanguageTranslator.getString("button.save"));
        this.quitterButton.setText(LanguageTranslator.getString("generics.quit"));
        this.quitterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPays.this.dispose();
            }
        });
        this.jPanel5.setLayout(this.flowLayout1);
        this.jPanel4.setLayout(this.flowLayout2);
        this.jLabel1.setText("D\u00e9signation");
        this.paysName.setBorder(BorderFactory.createLoweredBevelBorder());
        this.paysName.setPreferredSize(new Dimension(180, 23));
        this.paysName.setText("");
        this.jPanel2.setLayout(this.flowLayout3);
        this.jScrollPane1.setPreferredSize(new Dimension(400, 450));
        this.jPanel1.setPreferredSize(new Dimension(396, 446));
        this.jScrollPane2.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jScrollPane2.setPreferredSize(new Dimension(200, 300));
        this.flowLayout3.setHgap(5);
        this.jPanel4.setPreferredSize(new Dimension(221, 50));
        this.jPanel5.setPreferredSize(new Dimension(169, 50));
        this.supprimerButton.setText("Supprimer");
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jScrollPane2, null);
        this.jListPays.setSelectionMode(0);
        this.jListPays.setSelectedIndex(0);
        this.jListPays.addListSelectionListener(this);
        this.jListPays.setVisibleRowCount(5);
        this.jScrollPane2.getViewport().add((Component)this.jListPays, null);
        EnregistrerListener enregistrerListener = new EnregistrerListener(this.enregistrerButton);
        this.enregistrerButton.setActionCommand("Enregistrer");
        this.enregistrerButton.addActionListener(enregistrerListener);
        this.enregistrerButton.setEnabled(false);
        this.supprimerButton.setActionCommand("Supprimer");
        this.supprimerButton.addActionListener(new SupprimerListener());
        this.paysName.addActionListener(enregistrerListener);
        this.paysName.getDocument().addDocumentListener(enregistrerListener);
        this.jPanel1.add((Component)this.jPanel3, "South");
        this.jPanel3.add((Component)this.jPanel4, null);
        this.jPanel4.add((Component)this.jLabel1, null);
        this.jPanel4.add((Component)this.paysName, null);
        this.jPanel3.add((Component)this.jPanel5, null);
        this.jPanel5.add((Component)this.enregistrerButton, null);
        this.jPanel5.add((Component)this.supprimerButton, null);
        this.jPanel5.add((Component)this.quitterButton, null);
        this.jPanel1.add((Component)this.jPanel6, "North");
        this.pack();
        this.setLocation(170, 90);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.jListPays.getSelectedIndex() == -1) {
                this.supprimerButton.setEnabled(false);
            } else {
                this.supprimerButton.setEnabled(true);
            }
        }
    }

    class EnregistrerListener
    implements ActionListener,
    DocumentListener {
        private boolean alreadyEnabled = false;
        private JButton button;

        public EnregistrerListener(JButton button) {
            this.button = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = DialogPays.this.paysName.getText();
            if (name.equals("") || this.alreadyInList(name)) {
                Toolkit.getDefaultToolkit().beep();
                DialogPays.this.paysName.requestFocusInWindow();
                DialogPays.this.paysName.selectAll();
                return;
            }
            int index = DialogPays.this.jListPays.getSelectedIndex();
            index = index == -1 ? 0 : ++index;
            DialogPays.this.listModel.insertElementAt(DialogPays.this.paysName.getText(), index);
            this.addPays(DialogPays.this.paysName.getText());
            DialogPays.this.paysName.requestFocusInWindow();
            DialogPays.this.paysName.setText("");
            DialogPays.this.jListPays.setSelectedIndex(index);
            DialogPays.this.jListPays.ensureIndexIsVisible(index);
        }

        private void addPays(String pays) {
            DialogPays.this.bddEco.addPays(pays);
        }

        protected boolean alreadyInList(String name) {
            return DialogPays.this.listModel.contains(name);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.enableButton();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleEmptyTextField(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (!this.handleEmptyTextField(e)) {
                this.enableButton();
            }
        }

        private void enableButton() {
            if (!this.alreadyEnabled) {
                this.button.setEnabled(true);
            }
        }

        private boolean handleEmptyTextField(DocumentEvent e) {
            if (e.getDocument().getLength() <= 0) {
                this.button.setEnabled(false);
                this.alreadyEnabled = false;
                return true;
            }
            return false;
        }
    }

    class ListModelPays
    extends DefaultListModel {
        public ListModelPays(Vector list) {
            this.setVector(list);
        }

        public void setVector(Vector list) {
            this.removeAllElements();
            for (Pays elt : list) {
                this.addElement(elt.getLibelle());
            }
        }
    }

    class SupprimerListener
    implements ActionListener {
        SupprimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = DialogPays.this.jListPays.getSelectedIndex();
            this.deletePays(DialogPays.this.jListPays.getSelectedValue());
            DialogPays.this.listModel.remove(index);
            int size = DialogPays.this.listModel.getSize();
            if (size == 0) {
                DialogPays.this.supprimerButton.setEnabled(false);
            } else {
                if (index == DialogPays.this.listModel.getSize()) {
                    --index;
                }
                DialogPays.this.jListPays.setSelectedIndex(index);
                DialogPays.this.jListPays.ensureIndexIsVisible(index);
            }
        }

        private void deletePays(Object objet) {
            String pays = (String)objet;
            DialogPays.this.bddEco.delPays(pays);
        }
    }
}

