/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.component.JFittedComboBox;
import fr.pgh.component.JMultiListBox;
import fr.pgh.component.model.MultiListBoxModel;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import transpo.system.LicenceManager;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.CheckBoxBorder;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transpo.system.user.UserPreferences;
import transpo.system.util.Fonctions;
import transport.report.MasterReport;

public class DialogRapport
extends JDialog
implements DataListener {
    private static final long serialVersionUID = 1L;
    private static final int MODE_CONDUCTEUR = 1;
    private static final int MODE_VEHICULE = 2;
    private static final int GEN_ERROR = 1;
    private static final int UNKNOW_ERROR = 2;
    private static final int UNFOUND = 3;
    private static final int UNKNOWN = 4;
    public static final String TASK_PDF = "pdf";
    public static final String TASK_HTML = "html";
    public static final String TASK_XLS = "xls";
    public static final String TASK_CSV = "csv";
    public static final String TASK_ECRAN = "\u00e9cran";
    public static final String TASK_IMPRESSION = "imprimer";
    private int modeRapport = 1;
    private BddTransport bdd = null;
    private JPanel jContentPane = null;
    private JPanel pnlConducteur = null;
    private JPanel pnlDate = null;
    private JPanel pnlRapport = null;
    private JPanel pnlDetailExport = null;
    private JLabel lblSociete = null;
    private JLabel lblDu = null;
    private JTextField txtDateDebut = null;
    private JLabel lblAu = null;
    private JTextField txtDateFin = null;
    private JCheckBox cbSemaine = null;
    private JCheckBox cbMois = null;
    private JComboBox cbRapport = null;
    private JLabel lblTypeExport = null;
    private JComboBox<String> cbTypeExport = null;
    private JButton btnQuitter = null;
    private JButton btnEnvoyer = null;
    public Preferences prefs = null;
    private JPanel pnlTemps = null;
    private JCheckBox cbMinute = null;
    private JCheckBox cbCentieme = null;
    private JPanel pnlMore = null;
    private JPanel pnlOffenceDetail = null;
    private JCheckBox cbRSE = null;
    private JCheckBox cbDF = null;
    private JCheckBox cbUev = null;
    private JCheckBox cbBrut = null;
    private JCheckBox cbModifie = null;
    private JCheckBox cbDetail = null;
    private JCheckBox rbConducteur = null;
    private JCheckBox rbVehicule = null;
    private JMultiListBox<Vehicule> mbVehicle = null;
    private JMultiListBox<Conducteur> mbDriver = null;
    private JMultiListBox<Agence> mbAgency = null;
    private JPanel pnlMoreExpenses = null;
    private JCheckBox cbAmount = null;
    private JCheckBox cbCount = null;
    private JPanel pnlTime = null;
    private JTextField txtBegin = null;
    private JTextField txtEnd = null;
    private JLabel lblBegin = null;
    private JLabel lblEnd = null;
    private JCheckBox cbManual = null;
    private JComboBox cbCase = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogRapport.dispose()#");
        super.dispose();
    }

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        if (dataEvent instanceof BddEvent) {
            BddEvent e = (BddEvent)dataEvent;
            if (e.getTable().equals("t_conducteur")) {
                this.setConducteur();
            } else if (e.getTable().equals("t_agence")) {
                this.setAgence();
            } else if (e.getTable().equals("t_vehicule")) {
                this.setVehicule();
            } else if (e.getTable().equals(Report.table)) {
                this.setReportList();
            }
        }
    }

    public DialogRapport(JFrame owner, BddTransport bdd) {
        super(owner);
        TimsLogger.verbose("#DialogRapport()#");
        this.setDB(bdd);
        this.initialize();
        this.setAgence();
        if (this.modeRapport == 1) {
            this.setConducteur();
        } else if (this.modeRapport == 2) {
            this.setVehicule();
        }
        this.setReportList();
        this.setVisible(true);
        Transport.bdd.addDataListener(this);
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    private void initialize() {
        this.setSize(700, 420);
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("report.name"));
        this.setContentPane(this.getJContentPane());
        this.prefs = Preferences.userRoot().node("TIMS");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gcbPnlConducteur = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, 10, new Insets(5, 5, 5, 5));
            GridBagConstraints gcbPnlDate = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 1, 10, new Insets(5, 5, 5, 5));
            GridBagConstraints gcbPnlRapport = Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 1, 10, new Insets(5, 5, 5, 5));
            GridBagConstraints gcbPnlDetailExport = Fonctions.getGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 1, 10, new Insets(5, 5, 5, 5));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlConducteur(), gcbPnlConducteur);
            this.jContentPane.add((Component)this.getPnlDate(), gcbPnlDate);
            this.jContentPane.add((Component)this.getPnlRapport(), gcbPnlRapport);
            this.jContentPane.add((Component)this.getPnlDetailExport(), gcbPnlDetailExport);
        }
        return this.jContentPane;
    }

    private JPanel getPnlConducteur() {
        if (this.pnlConducteur == null) {
            GridBagConstraints gcbLblAgence = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 2, 13, new Insets(0, 5, 0, 5));
            GridBagConstraints gcbMbAgency = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 2, 10, new Insets(0, 0, 0, 5));
            GridBagConstraints gcbRbConducteur = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 2, 13, new Insets(0, 5, 0, 5));
            GridBagConstraints gcbMbDriver = Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 2, 10, new Insets(0, 0, 0, 5));
            GridBagConstraints gcbRbVehicle = Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 2, 13, new Insets(0, 5, 0, 5));
            GridBagConstraints gcbMbVehicle = Fonctions.getGridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 2, 10, new Insets(0, 0, 0, 5));
            this.lblSociete = new JLabel();
            this.lblSociete.setText(LanguageTranslator.getString("generics.agency"));
            this.pnlConducteur = new JPanel();
            this.pnlConducteur.setMinimumSize(new Dimension(200, 0));
            this.pnlConducteur.setLayout(new GridBagLayout());
            this.pnlConducteur.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.filter"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlConducteur.add((Component)this.lblSociete, gcbLblAgence);
            this.pnlConducteur.add(this.getMbAgency(), gcbMbAgency);
            this.pnlConducteur.add((Component)this.getRbConducteur(), gcbRbConducteur);
            this.pnlConducteur.add(this.getMbDriver(), gcbMbDriver);
            this.pnlConducteur.add((Component)this.getRbVehicule(), gcbRbVehicle);
            this.pnlConducteur.add(this.getMbVehicle(), gcbMbVehicle);
        }
        return this.pnlConducteur;
    }

    private JPanel getPnlDate() {
        if (this.pnlDate == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 2;
            gridBagConstraints13.gridwidth = 2;
            gridBagConstraints13.fill = 2;
            gridBagConstraints13.gridy = 2;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.gridwidth = 2;
            gridBagConstraints12.fill = 2;
            gridBagConstraints12.gridy = 2;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.gridy = 0;
            gridBagConstraints11.weightx = 2.0;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints11.gridx = 3;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 2;
            gridBagConstraints10.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints10.gridy = 0;
            this.lblAu = new JLabel();
            this.lblAu.setText(LanguageTranslator.getString("generics.to"));
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.weightx = 2.0;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints9.gridx = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints8.gridy = 0;
            this.lblDu = new JLabel();
            this.lblDu.setText(LanguageTranslator.getString("generics.from"));
            this.pnlDate = new JPanel();
            this.pnlDate.setLayout(new GridBagLayout());
            this.pnlDate.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.date"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlDate.add((Component)this.lblDu, gridBagConstraints8);
            this.pnlDate.add((Component)this.getTxtDateDebut(), gridBagConstraints9);
            this.pnlDate.add((Component)this.lblAu, gridBagConstraints10);
            this.pnlDate.add((Component)this.getTxtDateFin(), gridBagConstraints11);
            this.pnlDate.add((Component)this.getCbSemaine(), gridBagConstraints12);
            this.pnlDate.add((Component)this.getCbMois(), gridBagConstraints13);
        }
        return this.pnlDate;
    }

    private JPanel getPnlRapport() {
        if (this.pnlRapport == null) {
            GridBagConstraints gbcCbR = new GridBagConstraints();
            gbcCbR.fill = 2;
            gbcCbR.gridy = 1;
            gbcCbR.weightx = 2.0;
            gbcCbR.weighty = 1.0;
            gbcCbR.gridwidth = 2;
            gbcCbR.gridx = 0;
            GridBagConstraints gbcPnlTemps = new GridBagConstraints();
            gbcPnlTemps.gridx = 0;
            gbcPnlTemps.weightx = 1.0;
            gbcPnlTemps.weighty = 1.0;
            gbcPnlTemps.fill = 1;
            gbcPnlTemps.gridwidth = 2;
            gbcPnlTemps.insets = new Insets(0, 2, 0, 2);
            gbcPnlTemps.gridy = 2;
            GridBagConstraints gbcPnlMore = new GridBagConstraints();
            gbcPnlMore.gridx = 0;
            gbcPnlMore.fill = 2;
            gbcPnlMore.weightx = 1.0;
            gbcPnlMore.weighty = 1.0;
            gbcPnlMore.gridwidth = 2;
            gbcPnlMore.gridheight = 1;
            gbcPnlMore.insets = new Insets(0, 2, 0, 2);
            gbcPnlMore.gridy = 3;
            GridBagConstraints gbcPnlOffence = new GridBagConstraints();
            gbcPnlOffence.gridx = 0;
            gbcPnlOffence.gridwidth = 2;
            gbcPnlOffence.fill = 2;
            gbcPnlOffence.insets = new Insets(0, 2, 0, 2);
            gbcPnlOffence.gridy = 4;
            this.pnlRapport = new JPanel();
            this.pnlRapport.setLayout(new GridBagLayout());
            this.pnlRapport.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("report.name"), 3, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlRapport.add((Component)this.getCbRapport(), gbcCbR);
            this.pnlRapport.add((Component)this.getPnlTemps(), gbcPnlTemps);
            this.pnlRapport.add((Component)this.getPnlMore(), gbcPnlMore);
            this.pnlRapport.add((Component)this.getPnlOffenceDetail(), gbcPnlOffence);
        }
        return this.pnlRapport;
    }

    private JPanel getPnlDetailExport() {
        if (this.pnlDetailExport == null) {
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.gridx = 1;
            gridBagConstraints23.weightx = 0.0;
            gridBagConstraints23.weighty = 0.0;
            gridBagConstraints23.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints23.gridy = 1;
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.gridx = 0;
            gridBagConstraints22.weightx = 0.0;
            gridBagConstraints22.weighty = 0.0;
            gridBagConstraints22.fill = 0;
            gridBagConstraints22.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints22.gridy = 1;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.fill = 2;
            gridBagConstraints21.gridy = 0;
            gridBagConstraints21.weightx = 1.0;
            gridBagConstraints21.weighty = 1.0;
            gridBagConstraints21.gridx = 1;
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.gridx = 0;
            gridBagConstraints20.weightx = 1.0;
            gridBagConstraints20.weighty = 1.0;
            gridBagConstraints20.fill = 2;
            gridBagConstraints20.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints20.gridy = 0;
            this.lblTypeExport = new JLabel();
            this.lblTypeExport.setText(LanguageTranslator.getString("report.exportType"));
            this.lblTypeExport.setPreferredSize(new Dimension(0, 16));
            this.lblTypeExport.setHorizontalTextPosition(0);
            this.lblTypeExport.setHorizontalAlignment(0);
            this.lblTypeExport.setDisplayedMnemonic(0);
            this.pnlDetailExport = new JPanel();
            this.pnlDetailExport.setLayout(new GridBagLayout());
            this.pnlDetailExport.add((Component)this.lblTypeExport, gridBagConstraints20);
            this.pnlDetailExport.add(this.getCbTypeExport(), gridBagConstraints21);
            this.pnlDetailExport.add((Component)this.getBtnQuitter(), gridBagConstraints22);
            this.pnlDetailExport.add((Component)this.getBtnEnvoyer(), gridBagConstraints23);
        }
        return this.pnlDetailExport;
    }

    private JMultiListBox<Conducteur> getMbDriver() {
        if (this.mbDriver == null) {
            this.mbDriver = new JMultiListBox();
            this.mbDriver.setPreferredSize(new Dimension(0, 25));
        }
        return this.mbDriver;
    }

    private JTextField getTxtDateDebut() {
        if (this.txtDateDebut == null) {
            this.txtDateDebut = new JTextField();
            this.txtDateDebut.setPreferredSize(new Dimension(0, 20));
            this.txtDateDebut.setEditable(false);
            this.txtDateDebut.setEnabled(true);
            this.txtDateDebut.setText(ConversionTime.dateToString(ConversionTime.getFirstDayOfPreviousMonth(null), "dd/MM/yyyy"));
            this.txtDateDebut.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogRapport.this.getTxtDateDebut());
                    if (DialogRapport.this.lblBegin != null) {
                        DialogRapport.this.lblBegin.setText(LanguageTranslator.getString("generics.fromHour", DialogRapport.this.getTxtDateDebut().getText()));
                    }
                }
            });
        }
        return this.txtDateDebut;
    }

    private JTextField getTxtDateFin() {
        if (this.txtDateFin == null) {
            this.txtDateFin = new JTextField();
            this.txtDateFin.setPreferredSize(new Dimension(0, 20));
            this.txtDateFin.setEditable(false);
            this.txtDateFin.setEnabled(true);
            this.txtDateFin.setText(ConversionTime.dateToString(ConversionTime.getLastDayOfPreviousMonth(null), "dd/MM/yyyy"));
            this.txtDateFin.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogRapport.this.getTxtDateFin());
                    if (DialogRapport.this.lblEnd != null) {
                        DialogRapport.this.lblEnd.setText(LanguageTranslator.getString("generics.toHour", DialogRapport.this.getTxtDateFin().getText()));
                    }
                }
            });
        }
        return this.txtDateFin;
    }

    private JCheckBox getCbSemaine() {
        if (this.cbSemaine == null) {
            this.cbSemaine = new JCheckBox(LanguageTranslator.getString("generics.week"));
            this.cbSemaine.setHorizontalAlignment(0);
            this.cbSemaine.setPreferredSize(new Dimension(0, 24));
            this.cbSemaine.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DialogRapport.this.cbMois.setSelected(false);
                        DialogRapport.this.txtDateFin.setText(ConversionTime.addDay(DialogRapport.this.txtDateDebut.getText(), "dd/MM/yyyy", 6));
                        if (DialogRapport.this.lblEnd != null) {
                            DialogRapport.this.lblEnd.setText(LanguageTranslator.getString("generics.toHour", DialogRapport.this.getTxtDateFin().getText()));
                        }
                    }
                }
            });
        }
        return this.cbSemaine;
    }

    private JCheckBox getCbMois() {
        if (this.cbMois == null) {
            this.cbMois = new JCheckBox(LanguageTranslator.getString("generics.month"));
            this.cbMois.setHorizontalAlignment(0);
            this.cbMois.setPreferredSize(new Dimension(0, 24));
            this.cbMois.setSelected(true);
            this.cbMois.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DialogRapport.this.cbSemaine.setSelected(false);
                        String sDateDebut = DialogRapport.this.txtDateDebut.getText();
                        GregorianCalendar calDateRapport = new GregorianCalendar();
                        calDateRapport.setTime(ConversionTime.stringToDate(sDateDebut, "dd/MM/yyyy"));
                        calDateRapport.add(2, 1);
                        calDateRapport.add(5, -1);
                        DialogRapport.this.txtDateFin.setText(ConversionTime.dateToString(calDateRapport.getTime(), "dd/MM/yyyy"));
                        if (DialogRapport.this.lblEnd != null) {
                            DialogRapport.this.lblEnd.setText(LanguageTranslator.getString("generics.toHour", DialogRapport.this.getTxtDateFin().getText()));
                        }
                    }
                }
            });
        }
        return this.cbMois;
    }

    private JComboBox getCbRapport() {
        if (this.cbRapport == null) {
            this.cbRapport = new JComboBox();
            this.cbRapport.setPreferredSize(new Dimension(0, 25));
            this.cbRapport.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getItem() != null && e.getStateChange() == 1) {
                        Fonctions.setEnabled(DialogRapport.this.getPnlOffenceDetail(), false);
                        Fonctions.setEnabled(DialogRapport.this.getPnlTime(), false);
                        DialogRapport.this.getCbAmount().setEnabled(false);
                        DialogRapport.this.getCbCount().setEnabled(false);
                        DialogRapport.this.getCbManual().setEnabled(false);
                        DialogRapport.this.getCbDetail().setSelected(false);
                        Report tmp = (Report)((ComboBoxModel)DialogRapport.this.getCbRapport().getModel()).getObjectAt(DialogRapport.this.getCbRapport().getSelectedIndex());
                        TimsLogger.debug("#DialogRapport.getCbRapport# itemStateChanged " + e.getItem() + "(" + tmp.getTranslationId() + ")");
                        if (tmp.getTranslationId().equals(Report.RAPPORT_INFRACTION) || tmp.getTranslationId().equals(Report.RAPPORT_COURRIER) || tmp.getTranslationId().equals(Report.SYNTHESE_INFRACTION)) {
                            Fonctions.setEnabled(DialogRapport.this.getPnlOffenceDetail(), true);
                            DialogRapport.this.getCbDetail().setSelected(true);
                        }
                        if (tmp.getTranslationId().equals(Report.RAPPORT_FRAIS) || tmp.getTranslationId().equals(Report.SYNTHESE_FRAIS)) {
                            DialogRapport.this.getCbAmount().setEnabled(true);
                            DialogRapport.this.getCbCount().setEnabled(true);
                        }
                        if (tmp.getTranslationId().equals(Report.RAPPORT_GLOBAL_ACTIVITE)) {
                            DialogRapport.this.getCbCount().setEnabled(true);
                        }
                        if (tmp.getTranslationId().equals(Report.RAPPORT_NON_ACT)) {
                            DialogRapport.this.getCbManual().setEnabled(true);
                        }
                        UserPreferences.setPreferences("preference.report", DialogRapport.this.cbRapport.getSelectedItem().toString());
                    }
                }
            });
        }
        return this.cbRapport;
    }

    private JComboBox<String> getCbTypeExport() {
        if (this.cbTypeExport == null) {
            this.cbTypeExport = new JComboBox();
            this.cbTypeExport.addItem(TASK_PDF);
            this.cbTypeExport.addItem(TASK_ECRAN);
            this.cbTypeExport.addItem(TASK_IMPRESSION);
            this.cbTypeExport.addItem(TASK_XLS);
            this.cbTypeExport.addItem(TASK_CSV);
            String reportOut = UserPreferences.getPreferences("preference.report.out");
            if (reportOut != null) {
                this.cbTypeExport.setSelectedItem(reportOut);
            }
        }
        return this.cbTypeExport;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.setPreferredSize(new Dimension(73, 26));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogRapport.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JButton getBtnEnvoyer() {
        if (this.btnEnvoyer == null) {
            this.btnEnvoyer = new JButton();
            this.btnEnvoyer.setText(LanguageTranslator.getString("button.valid"));
            this.btnEnvoyer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(){

                        @Override
                        public void run() {
                            DialogRapport.this.genererRapport();
                        }
                    }.start();
                }
            });
        }
        return this.btnEnvoyer;
    }

    public Map<String, Object> getParameters(Report report) {
        MainElement selected;
        TimsLogger.debug("#DialogRapports.loadParam# Agence : " + this.getMbAgency().getSelectionDetail());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (System.getProperty("URL") != null) {
            parameters.put("SERVEUR", System.getProperty("HOME_PATH"));
        } else {
            parameters.put("SERVEUR", "");
        }
        parameters.put("DATE_DEBUT", this.getTxtDateDebut().getText());
        parameters.put("DATE_FIN", this.getTxtDateFin().getText());
        parameters.put("DEBUT", ConversionTime.stringToDate2(this.getTxtDateDebut().getText(), "dd/MM/yyyy"));
        parameters.put("FIN", ConversionTime.stringToDate2(this.getTxtDateFin().getText(), "dd/MM/yyyy"));
        parameters.put("BEGIN", ConversionTime.stringToDate2(this.getTxtDateDebut().getText(), "dd/MM/yyyy"));
        parameters.put("END", ConversionTime.stringToDate2(this.getTxtDateFin().getText(), "dd/MM/yyyy"));
        parameters.put("RESOLUTION", this.getCbMinute().isSelected() ? 1 : 0);
        parameters.put("DETAIL", this.getCbDetail().isSelected());
        parameters.put("OUT", this.cbTypeExport.getSelectedItem().toString());
        if (!this.getMbAgency().getSelectionDetail().equals(LanguageTranslator.getString("generics.all"))) {
            if (this.getMbAgency().getSelectedItems().size() == 1) {
                selected = this.getMbAgency().getModel().getSelectedItems().get(0);
                parameters.put("AGENCE", ((Agence)selected).getDescription());
            }
        } else {
            parameters.put("AGENCE", LanguageTranslator.getString("generics.all"));
        }
        if (this.modeRapport == 1) {
            parameters.put("REPORT_TARGET", 1);
            if (this.getMbDriver().getSelectedItems().size() == 1) {
                selected = this.getMbDriver().getModel().getSelectedItems().get(0);
                TimsLogger.debug("#DialogRapports.loadParam# Cond. cle : " + ((Conducteur)selected).getCleConducteur());
                parameters.put("CLE_CH", String.valueOf(((Conducteur)selected).getCleConducteur()));
                parameters.put("NOM_CH", ((Conducteur)selected).getNom());
                parameters.put("PRENOM_CH", ((Conducteur)selected).getPrenom());
                parameters.put("AGENCE", Agence.find(null, ((Conducteur)selected).getCleAgence()).getDescription());
            }
        } else if (this.modeRapport == 2) {
            parameters.put("REPORT_TARGET", 2);
            if (this.getMbVehicle().getSelectedItems().size() == 1) {
                selected = this.getMbVehicle().getModel().getSelectedItems().get(0);
                TimsLogger.debug("#DialogRapports.loadParam# cleVehicule : " + ((Vehicule)selected).getCleVehicule());
                parameters.put("CLE_VEHICULE", String.valueOf(((Vehicule)selected).getCleVehicule()));
                parameters.put("VEHICLE_REGISTRATION", ((Vehicule)selected).getRegistrationNumber());
                parameters.put("AGENCE", Agence.find(null, ((Vehicule)selected).getAgencyId()).getDescription());
            }
        }
        parameters.put("BRUTE", this.getCbBrut().isSelected() ? "1" : "0");
        parameters.put("RSE_OFF", this.getCbRSE().isSelected() ? "1" : "0");
        parameters.put("DF_OFF", this.getCbDF().isSelected() ? "1" : "0");
        parameters.put("UEV_OFF", this.getCbUev().isSelected() ? "1" : "0");
        parameters.put("CUSTOM_SENTENCE", System.getProperty("custom_sentence", ""));
        parameters.put("Seuil_soir", System.getProperty("night.begin") != null ? new Integer(Integer.parseInt(System.getProperty("night.begin").toString())) : new Integer(1260));
        parameters.put("Seuil_matin", System.getProperty("night.end") != null ? new Integer(Integer.parseInt(System.getProperty("night.end").toString())) : new Integer(360));
        int seuilVert = 35;
        int seuilOrange = 43;
        if (this.getCbMois().isSelected()) {
            seuilVert = 152;
            seuilOrange = 169;
        }
        parameters.put("SEUIL_VERT", seuilVert);
        parameters.put("SEUIL_ORANGE", seuilOrange);
        parameters.put("SHOW_COUNT", this.getCbCount().isSelected() ? "1" : "0");
        parameters.put("SHOW_AMOUNT", this.getCbAmount().isSelected() ? "1" : "0");
        if (report.getTranslationId().equals("rf-cay")) {
            parameters.put("MONTHLY_PAID", 0);
        } else if (report.getTranslationId().equals("rf-cay-m")) {
            parameters.put("MONTHLY_PAID", 1);
        } else {
            parameters.put("MONTHLY_PAID", -1);
        }
        parameters.put("BEGIN_TIME", this.getTxtBegin().getText());
        parameters.put("END_TIME", this.getTxtEnd().getText());
        parameters.put("REASON", this.getLibelleAbsence(this.getCbCase().getSelectedItem().toString()));
        return parameters;
    }

    private String getLibelleAbsence(String selected) {
        if (selected.equals(LanguageTranslator.getString("attestation.mal"))) {
            return "maladie";
        }
        if (selected.equals(LanguageTranslator.getString("attestation.cp"))) {
            return "conges payes";
        }
        if (selected.equals(LanguageTranslator.getString("attestation.rep"))) {
            return "repos";
        }
        if (selected.equals(LanguageTranslator.getString("attestation.veh"))) {
            return "vehicule";
        }
        if (selected.equals(LanguageTranslator.getString("attestation.oth"))) {
            return "autre";
        }
        if (selected.equals(LanguageTranslator.getString("attestation.dis"))) {
            return "dispo";
        }
        return null;
    }

    private void genererRapport() {
        if (ConversionTime.stringToDate(this.getTxtDateFin().getText(), "dd/MM/yyyy").before(ConversionTime.stringToDate(this.getTxtDateDebut().getText(), "dd/MM/yyyy"))) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.inputError"), LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(6)) + 4), 2);
            return;
        }
        Report report = (Report)((ComboBoxModel)this.getCbRapport().getModel()).getObjectAt(this.getCbRapport().getSelectedIndex());
        ProgressBar pb = new ProgressBar(this, LanguageTranslator.getString("generics.loading"));
        pb.setVisible(true);
        UserPreferences.setPreferences("preference.report.out", this.getCbTypeExport().getSelectedItem().toString());
        if (report.getFileName().equals("unknown")) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("report.notFound", this.getCbRapport().getSelectedItem().toString()), LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(6)) + 4), 2);
            return;
        }
        Vector<Conducteur> driver = this.getMbDriver().getSelectedItems();
        Vector<Agence> agency = this.getMbAgency().getSelectedItems();
        Vector<Vehicule> vehicle = this.getMbVehicle().getModel() != null ? this.getMbVehicle().getSelectedItems() : null;
        try {
            TimsLogger.info("G\u00e9n\u00e9ration rapport " + report.getCustomizedName() + "(" + report.getClassToLoad() + ") sur " + agency.size() + " agences " + "(" + driver.size() + " conducteurs et " + vehicle.size() + " v\u00e9hicules) du " + this.getTxtDateDebut().getText() + " au " + this.getTxtDateFin().getText(), "DialogRapprt.generer");
            MasterReport mr = null;
            if (!report.getClassToLoad().equals("NONE")) {
                Class<?> c = Class.forName(report.getClassToLoad());
                mr = (MasterReport)c.newInstance();
            } else {
                mr = new MasterReport();
            }
            mr.setValues(pb, report, agency, driver, vehicle, this.getParameters(report));
            mr.process();
            pb.dispose();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            System.err.println("erreur de g\u00e9n\u00e9ration rapport " + ex.getMessage());
            JOptionPane.showMessageDialog(null, LanguageTranslator.getString("report.error", ex.getMessage() == null ? ex.toString() : ex.getMessage()), LanguageTranslator.getString("message.numberedError", String.valueOf(6)), 2);
            ex.printStackTrace();
        }
    }

    public String getExt() {
        if (this.getCbTypeExport().getSelectedItem().toString().equals(TASK_XLS)) {
            return ".xls";
        }
        if (this.getCbTypeExport().getSelectedItem().toString().equals(TASK_CSV)) {
            return ".csv";
        }
        if (this.getCbTypeExport().getSelectedItem().toString().equals(TASK_HTML)) {
            return ".html";
        }
        if (this.getCbTypeExport().getSelectedItem().toString().equals(TASK_PDF)) {
            return ".pdf";
        }
        return ".unk";
    }

    public void setConducteur() {
        Vector<Agence> filters = this.getMbAgency().getSelectedItems();
        Integer[] agenciesId = new Integer[filters.size()];
        int x = 0;
        TimsLogger.debug("#DialogRapport.setConducteur# charge les conducteurs de " + filters.size() + " agences : ");
        for (Agence agency : filters) {
            TimsLogger.debug(" ..." + agency.getDescription());
            agenciesId[x++] = agency.getCleAgence();
        }
        MultiListBoxModel<Conducteur> modeleConducteur = new MultiListBoxModel<Conducteur>(Conducteur.loadList(agenciesId), true);
        this.getMbDriver().setModel(modeleConducteur);
    }

    public void setVehicule() {
        Vector<Agence> filters = this.getMbAgency().getSelectedItems();
        Integer[] agenciesId = new Integer[filters.size()];
        int x = 0;
        for (Agence agency : filters) {
            agenciesId[x++] = agency.getCleAgence();
        }
        MultiListBoxModel<Vehicule> tmp = new MultiListBoxModel<Vehicule>(Vehicule.loadList(agenciesId), true);
        this.getMbVehicle().setModel(tmp);
    }

    public void setAgence() {
        Vector<Agence> list = Agence.getList();
        this.getMbAgency().setModel(new MultiListBoxModel<Agence>(list, true));
    }

    public void setReportList() {
        Vector toFilter = (Vector)ConnexionSettings.getInstance().getDroitRapport().clone();
        int x = 0;
        while (x < toFilter.size()) {
            Report tmp = (Report)toFilter.get(x);
            TimsLogger.debug("tmp.getModule() = " + tmp.getModule() + ", tmp.getType() = " + tmp.getType());
            TimsLogger.debug("tmp.getMinimumVersion() = " + tmp.getMinimumVersion() + ", tmp.getType() != modeRapport = " + (tmp.getType() != this.modeRapport));
            TimsLogger.debug("tmp.getMinimumVersion()>LicenceManager.level = " + (tmp.getMinimumVersion() > LicenceManager.getInstance().level));
            TimsLogger.debug("tmp.getModule()!=-1 && LicenceManager.isModuleEnable(tmp.getModule()) = " + (tmp.getModule() != -1 && LicenceManager.isModuleEnable(tmp.getModule())));
            if (tmp.getType() != this.modeRapport) {
                TimsLogger.debug("removing " + tmp.getCustomizedName());
                toFilter.remove(x);
                --x;
            } else {
                TimsLogger.debug(String.valueOf(tmp.getCustomizedName()) + " is ok" + tmp.getCustomizedName());
            }
            ++x;
        }
        this.getCbRapport().setModel(new ComboBoxModel(toFilter, true, null));
        String report = UserPreferences.getPreferences("preference.report");
        if (report != null) {
            this.cbRapport.setSelectedItem(report);
        }
    }

    public void setDB(BddTransport bddM) {
        this.bdd = bddM;
    }

    private JPanel getPnlTemps() {
        if (this.pnlTemps == null) {
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.gridx = 1;
            gridBagConstraints26.gridy = 0;
            gridBagConstraints26.weightx = 1.0;
            gridBagConstraints26.weighty = 1.0;
            gridBagConstraints26.fill = 1;
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.gridx = 0;
            gridBagConstraints25.gridy = 0;
            gridBagConstraints25.weightx = 1.0;
            gridBagConstraints25.weighty = 1.0;
            gridBagConstraints25.fill = 1;
            gridBagConstraints25.anchor = 10;
            this.pnlTemps = new JPanel();
            this.pnlTemps.setLayout(new GridBagLayout());
            this.pnlTemps.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.time"), 3, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlTemps.add((Component)this.getCbMinute(), gridBagConstraints25);
            this.pnlTemps.add((Component)this.getCbCentieme(), gridBagConstraints26);
        }
        return this.pnlTemps;
    }

    private JCheckBox getCbMinute() {
        if (this.cbMinute == null) {
            this.cbMinute = new JCheckBox(LanguageTranslator.getString("generics.minute"));
            String resolution = UserPreferences.getPreferences("preference.time");
            if (resolution == null || Integer.parseInt(resolution) == 1) {
                this.cbMinute.setSelected(true);
            }
            this.cbMinute.setPreferredSize(new Dimension(0, 21));
            this.cbMinute.setHorizontalAlignment(0);
            this.cbMinute.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DialogRapport.this.getCbCentieme().setSelected(!DialogRapport.this.getCbMinute().isSelected());
                    UserPreferences.setPreferences("preference.time", String.valueOf(1));
                }
            });
        }
        return this.cbMinute;
    }

    private JCheckBox getCbCentieme() {
        if (this.cbCentieme == null) {
            this.cbCentieme = new JCheckBox(LanguageTranslator.getString("generics.hundredth"));
            String resolution = UserPreferences.getPreferences("preference.time");
            if (resolution != null && Integer.parseInt(resolution) == 0) {
                this.cbCentieme.setSelected(true);
            }
            this.cbCentieme.setPreferredSize(new Dimension(0, 21));
            this.cbCentieme.setHorizontalAlignment(0);
            this.cbCentieme.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DialogRapport.this.getCbMinute().setSelected(!DialogRapport.this.getCbCentieme().isSelected());
                    UserPreferences.setPreferences("preference.time", String.valueOf(0));
                }
            });
        }
        return this.cbCentieme;
    }

    private JPanel getPnlMore() {
        if (this.pnlMore == null) {
            GridBagConstraints gcbTime = new GridBagConstraints();
            gcbTime.fill = 1;
            gcbTime.gridx = 1;
            gcbTime.gridy = 0;
            gcbTime.weightx = 1.0;
            gcbTime.weighty = 0.0;
            GridBagConstraints gcbDetail = new GridBagConstraints();
            gcbDetail.fill = 1;
            gcbDetail.gridx = 0;
            gcbDetail.gridy = 0;
            gcbDetail.weightx = 1.0;
            gcbDetail.weighty = 0.0;
            GridBagConstraints gcbCbDetail = new GridBagConstraints();
            gcbCbDetail.gridx = 0;
            gcbCbDetail.anchor = 17;
            gcbCbDetail.gridy = 0;
            GridBagConstraints gcbCbAmount = new GridBagConstraints();
            gcbCbAmount.fill = 0;
            gcbCbAmount.gridy = 1;
            gcbCbAmount.gridx = 0;
            GridBagConstraints gridCbCount = new GridBagConstraints();
            gridCbCount.fill = 0;
            gridCbCount.gridy = 2;
            gridCbCount.gridx = 0;
            JPanel detail = new JPanel();
            detail.setLayout(new GridBagLayout());
            detail.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.more"), 3, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            detail.add((Component)this.getCbDetail(), gcbCbDetail);
            detail.add((Component)this.getCbAmount(), gcbCbAmount);
            detail.add((Component)this.getCbCount(), gridCbCount);
            this.pnlMore = new JPanel();
            this.pnlMore.setLayout(new GridBagLayout());
            this.pnlMore.add((Component)detail, gcbDetail);
            this.pnlMore.add((Component)this.getPnlTime(), gcbTime);
        }
        return this.pnlMore;
    }

    private JPanel getPnlOffenceDetail() {
        if (this.pnlOffenceDetail == null) {
            GridBagConstraints gcbPnlVisibleOffence = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 1, 10, new Insets(1, 1, 1, 1));
            GridBagConstraints gcbPnlActOffence = Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 1, 10, new Insets(1, 1, 1, 1));
            GridBagConstraints gcbRSE = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 0, 17, new Insets(0, 2, 0, 2));
            GridBagConstraints gcbDF = Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 1, 10, new Insets(0, 2, 0, 2));
            GridBagConstraints gcbUev = Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 1, 10, new Insets(0, 2, 0, 2));
            GridBagConstraints gcbCbBrut = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, 17, new Insets(0, 2, 0, 2));
            GridBagConstraints gcbCbModifie = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 1, 10, new Insets(0, 2, 0, 2));
            JPanel pnlVisibleOffence = new JPanel();
            pnlVisibleOffence.setLayout(new GridBagLayout());
            pnlVisibleOffence.setBorder(new TitledBorder(LanguageTranslator.getString("offence.see")));
            JPanel pnlActOffence = new JPanel();
            pnlActOffence.setLayout(new GridBagLayout());
            pnlActOffence.setBorder(new TitledBorder(LanguageTranslator.getString("offence.activityType")));
            pnlVisibleOffence.add((Component)this.getCbRSE(), gcbRSE);
            pnlVisibleOffence.add((Component)this.getCbDF(), gcbDF);
            pnlVisibleOffence.add((Component)this.getCbUev(), gcbUev);
            pnlActOffence.add((Component)this.getCbBrut(), gcbCbBrut);
            pnlActOffence.add((Component)this.getCbModifie(), gcbCbModifie);
            this.pnlOffenceDetail = new JPanel();
            this.pnlOffenceDetail.setLayout(new GridBagLayout());
            this.pnlOffenceDetail.add((Component)pnlVisibleOffence, gcbPnlVisibleOffence);
            this.pnlOffenceDetail.add((Component)pnlActOffence, gcbPnlActOffence);
        }
        return this.pnlOffenceDetail;
    }

    private JCheckBox getCbRSE() {
        if (this.cbRSE == null) {
            this.cbRSE = new JCheckBox(LanguageTranslator.getString("offence.esc.title"));
            this.cbRSE.setSelected(true);
        }
        return this.cbRSE;
    }

    private JCheckBox getCbDF() {
        if (this.cbDF == null) {
            this.cbDF = new JCheckBox(LanguageTranslator.getString("offence.fr.title"));
        }
        return this.cbDF;
    }

    private JCheckBox getCbUev() {
        if (this.cbUev == null) {
            this.cbUev = new JCheckBox(LanguageTranslator.getString("offence.uev"));
        }
        return this.cbUev;
    }

    private JCheckBox getCbBrut() {
        if (this.cbBrut == null) {
            this.cbBrut = new JCheckBox(LanguageTranslator.getString("offence.calculation.original"));
            String modified = UserPreferences.getPreferences("preference.offence.type");
            if (modified == null || Integer.valueOf(modified) == 1) {
                this.cbBrut.setSelected(true);
            }
            this.cbBrut.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DialogRapport.this.getCbModifie().setSelected(!DialogRapport.this.getCbBrut().isSelected());
                }
            });
        }
        return this.cbBrut;
    }

    private JCheckBox getCbModifie() {
        if (this.cbModifie == null) {
            this.cbModifie = new JCheckBox(LanguageTranslator.getString("offence.calculation.updated"));
            String modified = UserPreferences.getPreferences("preference.offence.type");
            if (modified != null && Integer.valueOf(modified) == 0) {
                this.cbModifie.setSelected(true);
            }
            this.cbModifie.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DialogRapport.this.getCbBrut().setSelected(!DialogRapport.this.getCbModifie().isSelected());
                }
            });
        }
        return this.cbModifie;
    }

    private JCheckBox getCbDetail() {
        if (this.cbDetail == null) {
            this.cbDetail = new JCheckBox();
            this.cbDetail.setText(LanguageTranslator.getString("generics.detail"));
        }
        return this.cbDetail;
    }

    private JMultiListBox<Vehicule> getMbVehicle() {
        if (this.mbVehicle == null) {
            this.mbVehicle = new JMultiListBox();
            this.mbVehicle.setEnabled(false);
            this.mbVehicle.setPreferredSize(new Dimension(0, 25));
        }
        return this.mbVehicle;
    }

    private JCheckBox getRbConducteur() {
        if (this.rbConducteur == null) {
            this.rbConducteur = new JCheckBox();
            this.rbConducteur.setText(LanguageTranslator.getString("generics.driver"));
            this.rbConducteur.setSelected(true);
            this.rbConducteur.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DialogRapport.this.getRbVehicule().setSelected(!DialogRapport.this.getRbConducteur().isSelected());
                    if (DialogRapport.this.getRbConducteur().isSelected()) {
                        DialogRapport.this.modeRapport = 1;
                        DialogRapport.this.getMbDriver().setEnabled(true);
                        DialogRapport.this.getMbVehicle().setEnabled(false);
                        DialogRapport.this.setConducteur();
                        DialogRapport.this.setReportList();
                    }
                }
            });
        }
        return this.rbConducteur;
    }

    private JCheckBox getRbVehicule() {
        if (this.rbVehicule == null) {
            this.rbVehicule = new JCheckBox();
            this.rbVehicule.setText(LanguageTranslator.getString("generics.vehicle"));
            this.rbVehicule.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DialogRapport.this.getRbConducteur().setSelected(!DialogRapport.this.getRbVehicule().isSelected());
                    if (DialogRapport.this.getRbVehicule().isSelected()) {
                        DialogRapport.this.modeRapport = 2;
                        DialogRapport.this.getMbVehicle().setEnabled(true);
                        DialogRapport.this.getMbDriver().setEnabled(false);
                        DialogRapport.this.setVehicule();
                        DialogRapport.this.setReportList();
                    }
                }
            });
        }
        return this.rbVehicule;
    }

    private JMultiListBox<Agence> getMbAgency() {
        if (this.mbAgency == null) {
            this.mbAgency = new JMultiListBox();
            this.mbAgency.setPreferredSize(new Dimension(0, 25));
            this.mbAgency.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    TimsLogger.verbose("#DialogRapport.getMbAgency()# popup will be shadowed");
                    if (DialogRapport.this.modeRapport == 1) {
                        DialogRapport.this.setConducteur();
                    } else if (DialogRapport.this.modeRapport == 2) {
                        DialogRapport.this.setVehicule();
                    }
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
        return this.mbAgency;
    }

    private JCheckBox getCbAmount() {
        if (this.cbAmount == null) {
            this.cbAmount = new JCheckBox();
            this.cbAmount.setSelected(true);
            this.cbAmount.setText(LanguageTranslator.getString("report.showAmount"));
        }
        return this.cbAmount;
    }

    private JCheckBox getCbCount() {
        if (this.cbCount == null) {
            this.cbCount = new JCheckBox(LanguageTranslator.getString("report.showCount"));
            this.cbCount.setSelected(true);
            this.cbCount.setHorizontalAlignment(0);
        }
        return this.cbCount;
    }

    private JPanel getPnlTime() {
        if (this.pnlTime == null) {
            GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
            gridBagConstraints32.fill = 2;
            gridBagConstraints32.gridy = 2;
            gridBagConstraints32.weightx = 1.0;
            gridBagConstraints32.insets = new Insets(0, 3, 3, 3);
            gridBagConstraints32.gridwidth = 2;
            gridBagConstraints32.gridx = 0;
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.insets = new Insets(0, 3, 0, 0);
            gridBagConstraints31.anchor = 17;
            gridBagConstraints31.gridy = 1;
            this.lblEnd = new JLabel();
            this.lblEnd.setText(LanguageTranslator.getString("generics.toHour", this.getTxtDateFin().getText()));
            GridBagConstraints gridBagConstraints30 = new GridBagConstraints();
            gridBagConstraints30.gridx = 0;
            gridBagConstraints30.anchor = 17;
            gridBagConstraints30.insets = new Insets(0, 3, 0, 0);
            this.lblBegin = new JLabel();
            this.lblBegin.setText(LanguageTranslator.getString("generics.fromHour", this.getTxtDateDebut().getText()));
            GridBagConstraints gridBagConstraints29 = new GridBagConstraints();
            gridBagConstraints29.gridx = 1;
            gridBagConstraints29.gridy = 1;
            GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
            gridBagConstraints28.gridx = 1;
            this.pnlTime = new JPanel();
            this.pnlTime.setLayout(new GridBagLayout());
            CheckBoxBorder border = new CheckBoxBorder(this.getCbManual(), this.pnlTime, BorderFactory.createLineBorder(SystemColor.activeCaption, 1));
            this.pnlTime.setBorder(border);
            this.pnlTime.add((Component)this.getTxtBegin(), gridBagConstraints28);
            this.pnlTime.add((Component)this.getTxtEnd(), gridBagConstraints29);
            this.pnlTime.add((Component)this.lblBegin, gridBagConstraints30);
            this.pnlTime.add((Component)this.lblEnd, gridBagConstraints31);
            this.pnlTime.add(this.getCbCase(), gridBagConstraints32);
        }
        return this.pnlTime;
    }

    private JTextField getTxtBegin() {
        if (this.txtBegin == null) {
            this.txtBegin = new JTextField();
            this.txtBegin.setPreferredSize(new Dimension(40, 20));
        }
        return this.txtBegin;
    }

    private JTextField getTxtEnd() {
        if (this.txtEnd == null) {
            this.txtEnd = new JTextField();
            this.txtEnd.setPreferredSize(new Dimension(40, 20));
        }
        return this.txtEnd;
    }

    private JCheckBox getCbManual() {
        if (this.cbManual == null) {
            this.cbManual = new JCheckBox(LanguageTranslator.getString("generics.manual"));
            this.cbManual.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean enable = DialogRapport.this.getCbManual().isSelected();
                    Fonctions.setEnabled(DialogRapport.this.getPnlTime(), enable);
                    if (enable) {
                        DialogRapport.this.getTxtBegin().setText("00h00");
                        DialogRapport.this.getTxtEnd().setText("00h00");
                    } else {
                        DialogRapport.this.getTxtBegin().setText("");
                        DialogRapport.this.getTxtEnd().setText("");
                    }
                }
            });
        }
        return this.cbManual;
    }

    private JComboBox<String> getCbCase() {
        if (this.cbCase == null) {
            this.cbCase = new JFittedComboBox();
            this.cbCase.setPreferredSize(new Dimension(0, 25));
            this.cbCase.addItem(LanguageTranslator.getString("attestation.mal"));
            this.cbCase.addItem(LanguageTranslator.getString("attestation.cp"));
            this.cbCase.addItem(LanguageTranslator.getString("attestation.rep"));
            this.cbCase.addItem(LanguageTranslator.getString("attestation.veh"));
            this.cbCase.addItem(LanguageTranslator.getString("attestation.oth"));
            this.cbCase.addItem(LanguageTranslator.getString("attestation.dis"));
        }
        return this.cbCase;
    }

    class AL
    implements ActionListener {
        AL() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == DialogRapport.this.btnEnvoyer) {
                DialogRapport.this.genererRapport();
            }
            if (source == DialogRapport.this.btnQuitter) {
                DialogRapport.this.dispose();
            }
        }
    }

    class GetFile
    implements Runnable {
        private String cheminSave = null;

        GetFile() {
        }

        @Override
        public void run() {
            JFileChooser choix = new JFileChooser(DialogRapport.this.prefs.node("DIRECTORY").get("RAPPORT", System.getProperty("user.home")));
            choix.setDialogTitle("o\u00f9 desirez-vous sauvegarger le rapport ?");
            choix.setFileSelectionMode(1);
            if (choix.showSaveDialog(MainFrameTransport.getInstance()) != 0) {
                return;
            }
            this.cheminSave = choix.getSelectedFile().getAbsolutePath();
            DialogRapport.this.prefs.node("DIRECTORY").put("RAPPORT", this.cheminSave);
        }

        public String getCheminSave() {
            return this.cheminSave;
        }
    }
}

