/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.TypeActivite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import transpo.system.TimsLogger;
import transpo.system.ui.editor.ColorEditor;
import transpo.system.ui.modele.TMFullActivityType;
import transpo.system.ui.renderer.ColorRenderer;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;
import transpo.system.util.ModificationLevelType;

public class DialogTypeActivite
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane jspTable = null;
    private JTable tblType = null;
    private JPanel pnlBtn = null;
    private BddTransport database = null;
    private JButton btnSave = null;
    private JButton btnQuitter = null;
    private JButton btnAjouter = null;
    private JButton btnDelete = null;
    private JComboBox cbModification = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogTypeActivite.dispose()#");
        super.dispose();
    }

    public DialogTypeActivite(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogTypeActivite()#");
        this.initialize();
    }

    private void initialize() {
        this.setSize(650, 300);
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("activity.type.title"));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJspTable(), "Center");
            this.jContentPane.add((Component)this.getPnlBtn(), "South");
        }
        return this.jContentPane;
    }

    private JScrollPane getJspTable() {
        if (this.jspTable == null) {
            this.jspTable = new JScrollPane();
            this.jspTable.setViewportView(this.getTblType());
        }
        return this.jspTable;
    }

    private JTable getTblType() {
        if (this.tblType == null) {
            this.tblType = new JTable();
            Vector<TypeActivite> original = TypeActivite.getList();
            Vector<TypeActivite> clone = new Vector<TypeActivite>();
            for (TypeActivite originalta : original) {
                clone.add((TypeActivite)originalta.clone());
            }
            this.tblType.setModel(new TMFullActivityType(clone));
            this.tblType.setDefaultRenderer(Color.class, new ColorRenderer(true));
            this.tblType.setDefaultEditor(Color.class, new ColorEditor());
            this.tblType.setSelectionMode(0);
            this.tblType.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                        int row = lsm.getMinSelectionIndex();
                        if (!((TMFullActivityType)DialogTypeActivite.this.getTblType().getModel()).getRow(row).isUpdatable()) {
                            DialogTypeActivite.this.getBtnDelete().setEnabled(false);
                        } else {
                            DialogTypeActivite.this.getBtnDelete().setEnabled(true);
                        }
                    }
                }
            });
            this.cbModificationEditor(this.tblType.getColumnModel().getColumn(7));
        }
        return this.tblType;
    }

    private void cbModificationEditor(TableColumn col) {
        col.setCellEditor(new DefaultCellEditor(this.getCbModification()));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText("Selection");
        col.setCellRenderer(renderer);
    }

    private JComboBox getCbModification() {
        if (this.cbModification == null) {
            this.cbModification = Fonctions.getCustomizedCB();
            this.cbModification.addItem(new ModificationLevelType(LanguageTranslator.getString("activity.noUpdate"), 0));
            this.cbModification.addItem(new ModificationLevelType(LanguageTranslator.getString("activity.updateWithComment"), 1));
            this.cbModification.addItem(new ModificationLevelType(LanguageTranslator.getString("activity.allUpdate"), 2));
        }
        return this.cbModification;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 2;
            gridBagConstraints11.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 3;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            if (ConnexionSettings.getInstance().isModifiable("TYPE_ACTIVITE")) {
                this.pnlBtn.add((Component)this.getBtnSave(), new GridBagConstraints());
            }
            if (ConnexionSettings.getInstance().isAjoutable("TYPE_ACTIVITE")) {
                this.pnlBtn.add((Component)this.getBtnAjouter(), gridBagConstraints);
            }
            if (ConnexionSettings.getInstance().isSupprimable("TYPE_ACTIVITE")) {
                this.pnlBtn.add((Component)this.getBtnDelete(), gridBagConstraints11);
            }
            this.pnlBtn.add((Component)this.getBtnQuitter(), gridBagConstraints1);
        }
        return this.pnlBtn;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setText(LanguageTranslator.getString("button.save"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogTypeActivite.this.save();
                    DialogTypeActivite.this.dispose();
                }
            });
        }
        return this.btnSave;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogTypeActivite.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JButton getBtnAjouter() {
        if (this.btnAjouter == null) {
            this.btnAjouter = new JButton();
            this.btnAjouter.setText(LanguageTranslator.getString("button.new"));
            this.btnAjouter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogTypeActivite.this.newLine();
                }
            });
        }
        return this.btnAjouter;
    }

    private void commit() {
        int row = this.getTblType().getSelectedRow();
        int column = this.getTblType().getSelectedColumn();
        if (this.getTblType().isEditing()) {
            this.getTblType().getCellEditor(row, column).stopCellEditing();
        }
    }

    private void save() {
        this.commit();
        TMFullActivityType tmp = (TMFullActivityType)this.getTblType().getModel();
        int x = 0;
        int delx = 0;
        while (x < TypeActivite.getList().size()) {
            TypeActivite typeAct;
            TypeActivite typeActivite = typeAct = x - delx < tmp.getRowCount() ? tmp.getRow(x - delx) : null;
            if (typeAct == null || typeAct.getCle() != TypeActivite.getList().get(x).getCle()) {
                TypeActivite.getList().get(x).delete();
                ++delx;
            } else {
                TypeActivite.getList().get(x).compareAndUpdate(typeAct.getName(), typeAct.getCode(), typeAct.getColor(), typeAct.isHsGenerator(), typeAct.isRcGenerator(), typeAct.getPaidPercentage(), typeAct.isRest(), typeAct.getModificationLevel(), typeAct.isShowPaid());
            }
            ++x;
        }
        while (x - delx < tmp.getRowCount()) {
            tmp.getRow(x - delx).update();
            ++x;
        }
    }

    private void newLine() {
        ((TMFullActivityType)this.getTblType().getModel()).addRow(new TypeActivite());
    }

    private void deleteSelectedLine() {
        int row = this.getTblType().getSelectedRow();
        if (((TMFullActivityType)this.getTblType().getModel()).getRow(row).isUpdatable()) {
            return;
        }
        ((TMFullActivityType)this.getTblType().getModel()).removeRow(row);
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton(LanguageTranslator.getString("button.delete"));
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogTypeActivite.this.deleteSelectedLine();
                }
            });
        }
        return this.btnDelete;
    }
}

