/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.component.JMultiListBox;
import fr.pgh.component.JPanelButton;
import fr.pgh.component.JTextHour;
import fr.pgh.component.model.MultiListBoxModel;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.ExpensesAmount;
import fr.pgh.data.bdd.ExpensesType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.CheckBoxBorder;
import transpo.system.ui.modele.LMFrais;
import transpo.system.ui.modele.TMExpensesAmount;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;
import transpo.system.util.messaging.MessageSystemManager;
import transpo.ui.calendrier.JCalendrier;

public class DialogTypeFrais
extends JDialog
implements TableModelListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlListe = null;
    private JPanel pnlDetail = null;
    private JScrollPane jpsListe = null;
    private JList listeFrais = null;
    private JButton btnCreer = null;
    private JLabel lblDebut = null;
    private JLabel lblFin = null;
    private JLabel lblCumul = null;
    private JTextHour txtBeginBefore = null;
    private JTextHour txtEndAfter = null;
    private JTextHour txtBeginAfter = null;
    private JTextHour txtEndBefore = null;
    private JTextHour txtCumulService = null;
    private JTextHour txtCumulAvant = null;
    private JLabel lblAvant = null;
    private JTextHour txtCumulApres = null;
    private JLabel lblApres = null;
    private JPanel pnlDebut = null;
    private JPanel pnlFin = null;
    private JPanel pnlCumul = null;
    private JPanel pnlMontant = null;
    private JPanelButton pnlBtn = null;
    private JButton btnQuitter = null;
    private JButton btnArchive = null;
    private JButton btnEnregistrer = null;
    private JTextField txtDesignation = null;
    private JLabel lblDesignation = null;
    private ExpensesType current = null;
    private JCheckBox cbActif = null;
    private JPanel pnlDay = null;
    private JMultiListBox mbExclusion = null;
    private JLabel lblExcExp = null;
    private JLabel lblEmployeeType = null;
    private JComboBox<Constants.EMPLOYEE_TYPE> cbEmployeeType = null;
    private JLabel lblWorkedDay = null;
    private JMultiListBox mbDay = null;
    private JTextField txtCode = null;
    private JLabel lblCode = null;
    private JPanel pnlPeriod = null;
    private JCheckBox cbPeriod = null;
    private JCheckBox cbCumul = null;
    private JPanel pnlGeneralRules = null;
    private JPanel pnlAutomatic = null;
    private JCheckBox cbArchive = null;
    private JLabel lblHour = null;
    private JTextHour txtHour = null;
    private JCheckBox cbFastView = null;
    private JTable tblMontant = null;
    private JPanelButton pnlBtnAmount = null;
    private JButton btnAddExpenseAmount = null;
    private JPanel pnlPosition = null;
    private JCheckBox cbPosition = null;
    private JTextField txtMaxDistance = null;
    private JCheckBox cbHome = null;
    private JCheckBox cbAgency = null;
    private JCheckBox cbCompany = null;
    private Date amountDateChanged = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogTypeFrais.dispose()#");
        super.dispose();
    }

    public DialogTypeFrais(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogTypeFrais()#");
        this.initialize();
    }

    private void initialize() {
        this.setSize(650, 580);
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("expenses.type.title"));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.insets = new Insets(5, 0, 5, 5);
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlListe(), gridBagConstraints);
            this.jContentPane.add((Component)this.getPnlDetail(), gridBagConstraints1);
        }
        return this.jContentPane;
    }

    private JPanel getPnlListe() {
        if (this.pnlListe == null) {
            GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
            gridBagConstraints32.gridx = 0;
            gridBagConstraints32.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints32.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints2.gridx = 0;
            this.pnlListe = new JPanel();
            this.pnlListe.setLayout(new GridBagLayout());
            this.pnlListe.setPreferredSize(new Dimension(120, 0));
            this.pnlListe.add((Component)this.getJpsListe(), gridBagConstraints2);
            if (ConnexionSettings.getInstance().isAjoutable("FRAIS")) {
                this.pnlListe.add((Component)this.getBtnCreer(), gridBagConstraints3);
            }
            this.pnlListe.add((Component)this.getCbArchive(), gridBagConstraints32);
        }
        return this.pnlListe;
    }

    private JPanel getPnlDetail() {
        if (this.pnlDetail == null) {
            this.pnlDetail = new JPanel();
            this.pnlDetail.setLayout(new GridBagLayout());
            this.pnlDetail.add((Component)this.getPnlGeneralRules(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, -1, new Insets(5, 0, 5, 0)));
            this.pnlDetail.add((Component)this.getPnlMontant(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, -1, null));
            this.pnlDetail.add((Component)this.getPnlDay(), Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlDetail.add((Component)this.getPnlAutomatic(), Fonctions.getGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 2, -1, null));
            this.pnlDetail.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 0, 13, new Insets(2, 0, 0, 0)));
        }
        return this.pnlDetail;
    }

    private JScrollPane getJpsListe() {
        if (this.jpsListe == null) {
            this.jpsListe = new JScrollPane();
            this.jpsListe.setPreferredSize(new Dimension(0, 0));
            this.jpsListe.setViewportView(this.getListeFrais());
        }
        return this.jpsListe;
    }

    private JList getListeFrais() {
        if (this.listeFrais == null) {
            this.listeFrais = new JList();
            this.listeFrais.setModel(new LMFrais(ExpensesType.getList()));
            this.listeFrais.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && DialogTypeFrais.this.getListeFrais().getSelectedIndex() != -1) {
                        LMFrais tmp = (LMFrais)DialogTypeFrais.this.getListeFrais().getModel();
                        DialogTypeFrais.this.load(tmp.getFraisAt(DialogTypeFrais.this.getListeFrais().getSelectedIndex()));
                    }
                }
            });
        }
        return this.listeFrais;
    }

    private JButton getBtnCreer() {
        if (this.btnCreer == null) {
            this.btnCreer = new JButton();
            this.btnCreer.setText(LanguageTranslator.getString("button.new"));
            this.btnCreer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogTypeFrais.this.load(new ExpensesType());
                    ((TMExpensesAmount)DialogTypeFrais.this.getTblMontant().getModel()).addRow(new ExpensesAmount(0, DialogTypeFrais.this.current.getCle(), new Date(), DialogTypeFrais.this.current.getMontant(null, 0), DialogTypeFrais.this.current.getMontant(null, 1)));
                }
            });
        }
        return this.btnCreer;
    }

    private JTextHour getTxtBeginBefore() {
        if (this.txtBeginBefore == null) {
            this.txtBeginBefore = new JTextHour();
            this.txtBeginBefore.setPreferredSize(new Dimension(45, 20));
            this.txtBeginBefore.setEnabled(false);
        }
        return this.txtBeginBefore;
    }

    private JTextHour getTxtEndAfter() {
        if (this.txtEndAfter == null) {
            this.txtEndAfter = new JTextHour();
            this.txtEndAfter.setPreferredSize(new Dimension(45, 20));
            this.txtEndAfter.setEnabled(false);
        }
        return this.txtEndAfter;
    }

    private JTextHour getTxtCumulService() {
        if (this.txtCumulService == null) {
            this.txtCumulService = new JTextHour();
            this.txtCumulService.setEnabled(false);
            this.txtCumulService.setPreferredSize(new Dimension(45, 20));
        }
        return this.txtCumulService;
    }

    private JTextHour getTxtCumulAvant() {
        if (this.txtCumulAvant == null) {
            this.txtCumulAvant = new JTextHour();
            this.txtCumulAvant.setEnabled(false);
            this.txtCumulAvant.setPreferredSize(new Dimension(45, 20));
        }
        return this.txtCumulAvant;
    }

    private JTextHour getTxtCumulApres() {
        if (this.txtCumulApres == null) {
            this.txtCumulApres = new JTextHour();
            this.txtCumulApres.setEnabled(false);
            this.txtCumulApres.setPreferredSize(new Dimension(45, 20));
            this.txtCumulApres.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (DialogTypeFrais.this.current != null && DialogTypeFrais.this.getTxtCumulApres().getText().equals("") && DialogTypeFrais.this.getTxtCumulApres().isEditable()) {
                        DialogTypeFrais.this.getTxtCumulApres().setText("00h00");
                    }
                }
            });
        }
        return this.txtCumulApres;
    }

    private JPanel getPnlDebut() {
        if (this.pnlDebut == null) {
            this.lblFin = new JLabel();
            this.lblFin.setText(LanguageTranslator.getString("expenses.endLimit"));
            this.lblFin.setEnabled(false);
            this.lblDebut = new JLabel();
            this.lblDebut.setText(LanguageTranslator.getString("expenses.beginLimit"));
            this.lblDebut.setEnabled(false);
            this.pnlDebut = new JPanel();
            this.pnlDebut.setLayout(new GridBagLayout());
            this.pnlDebut.add((Component)this.lblDebut, Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlDebut.add((Component)this.getTxtBeginBefore(), Fonctions.getGridBagConstraints(2, 0, 1, 1, 1.0, 0.0, -1, -1, null));
            this.pnlDebut.add((Component)this.getTxtBeginAfter(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, -1, -1, null));
        }
        return this.pnlDebut;
    }

    private JPanel getPnlFin() {
        if (this.pnlFin == null) {
            this.pnlFin = new JPanel();
            this.pnlFin.setLayout(new GridBagLayout());
            this.pnlFin.add((Component)this.lblFin, Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlFin.add((Component)this.getTxtEndAfter(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, -1, -1, null));
            this.pnlFin.add((Component)this.getTxtEndBefore(), Fonctions.getGridBagConstraints(2, 0, 1, 1, 1.0, 0.0, -1, -1, null));
        }
        return this.pnlFin;
    }

    private JPanel getPnlCumul() {
        if (this.pnlCumul == null) {
            this.lblAvant = new JLabel();
            this.lblAvant.setText(LanguageTranslator.getString("generics.before"));
            this.lblAvant.setEnabled(false);
            this.lblApres = new JLabel();
            this.lblApres.setText(LanguageTranslator.getString("generics.after"));
            this.lblApres.setEnabled(false);
            this.lblCumul = new JLabel();
            this.lblCumul.setText(LanguageTranslator.getString("expenses.totalWorked"));
            this.lblCumul.setEnabled(false);
            this.pnlCumul = new JPanel();
            this.pnlCumul.setLayout(new GridBagLayout());
            CheckBoxBorder border = new CheckBoxBorder(this.getCbCumul(), this.pnlCumul, BorderFactory.createLineBorder(SystemColor.activeCaption, 1));
            this.pnlCumul.setBorder(border);
            this.pnlCumul.add((Component)this.lblCumul, Fonctions.getGridBagConstraints(0, 0, 2, 1, 0.0, 0.0, -1, -1, new Insets(0, 2, 0, 0)));
            this.pnlCumul.add((Component)this.getTxtCumulService(), Fonctions.getGridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 0, -1, null));
            this.pnlCumul.add((Component)this.lblApres, Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlCumul.add((Component)this.getTxtCumulAvant(), Fonctions.getGridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 3, -1, new Insets(0, 0, 0, 2)));
            this.pnlCumul.add((Component)this.getTxtCumulApres(), Fonctions.getGridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 3, -1, new Insets(0, 0, 0, 2)));
            this.pnlCumul.add((Component)this.lblAvant, Fonctions.getGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, -1, -1, null));
        }
        return this.pnlCumul;
    }

    private JPanel getPnlPosition() {
        if (this.pnlPosition == null) {
            this.pnlPosition = new JPanel();
            this.pnlPosition.setLayout(new GridBagLayout());
            CheckBoxBorder border = new CheckBoxBorder(this.getCbPosition(), this.pnlPosition, BorderFactory.createLineBorder(SystemColor.activeCaption, 1));
            this.pnlPosition.setBorder(border);
            JLabel lbl = new JLabel(LanguageTranslator.getString("expense.max.distance"));
            lbl.setEnabled(false);
            this.pnlPosition.add((Component)lbl, Fonctions.getGridBagConstraints(0, 0, 1, 2, 1.0, 0.0, 0, -1, null));
            this.pnlPosition.add((Component)this.getTxtMaxDistance(), Fonctions.getGridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 1, -1, null));
            this.pnlPosition.add((Component)this.getCbHome(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 0, -1, null));
            this.pnlPosition.add((Component)this.getCbAgency(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 0, -1, null));
        }
        return this.pnlPosition;
    }

    private JCheckBox getCbPosition() {
        if (this.cbPosition == null) {
            this.cbPosition = new JCheckBox();
            this.cbPosition.setText(LanguageTranslator.getString("expense.position"));
            this.cbPosition.setEnabled(false);
            this.cbPosition.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TimsLogger.debug("itemStateChange for cbPosition " + e.getStateChange());
                    boolean enable = DialogTypeFrais.this.getCbPosition().isSelected();
                    Fonctions.setEnabled(DialogTypeFrais.this.getPnlPosition(), enable);
                    if (enable) {
                        DialogTypeFrais.this.getCbPeriod().setSelected(false);
                        DialogTypeFrais.this.getCbCumul().setSelected(false);
                    }
                    DialogTypeFrais.this.getPnlPosition().repaint();
                }
            });
        }
        return this.cbPosition;
    }

    private JTextField getTxtMaxDistance() {
        if (this.txtMaxDistance == null) {
            this.txtMaxDistance = new JTextField();
            this.txtMaxDistance.setEnabled(false);
        }
        return this.txtMaxDistance;
    }

    private JCheckBox getCbHome() {
        if (this.cbHome == null) {
            this.cbHome = new JCheckBox();
            this.cbHome.setText(LanguageTranslator.getString("expense.from.home"));
            this.cbHome.setEnabled(false);
        }
        return this.cbHome;
    }

    private JCheckBox getCbAgency() {
        if (this.cbAgency == null) {
            this.cbAgency = new JCheckBox();
            this.cbAgency.setText(LanguageTranslator.getString("expense.from.agency"));
            this.cbAgency.setEnabled(false);
        }
        return this.cbAgency;
    }

    private JCheckBox getCbCompany() {
        if (this.cbCompany == null) {
            this.cbCompany = new JCheckBox();
            this.cbCompany.setText(LanguageTranslator.getString("expense.from.company"));
            this.cbCompany.setEnabled(false);
        }
        return this.cbCompany;
    }

    private JPanel getPnlMontant() {
        if (this.pnlMontant == null) {
            this.pnlMontant = new JPanel();
            this.pnlMontant.setLayout(new GridBagLayout());
            this.pnlMontant.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("expenses.amounts"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            JScrollPane jsp = new JScrollPane();
            jsp.setViewportView(this.getTblMontant());
            this.pnlMontant.add((Component)jsp, Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, null));
            this.pnlMontant.add((Component)this.getPnlBtnAmount(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 15, null));
        }
        return this.pnlMontant;
    }

    private JTable getTblMontant() {
        if (this.tblMontant == null) {
            this.tblMontant = new JTable();
            this.tblMontant.setModel(new TMExpensesAmount(null, this));
            this.tblMontant.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row = DialogTypeFrais.this.getTblMontant().getSelectedRow();
                    int column = DialogTypeFrais.this.getTblMontant().getSelectedColumn();
                    if (column == 0 && DialogTypeFrais.this.getTblMontant().isCellEditable(row, 0)) {
                        Point toShow = DialogTypeFrais.this.getTblMontant().getLocationOnScreen();
                        toShow.setLocation(toShow.getX() + (double)e.getX(), toShow.getY() + (double)e.getY());
                        JCalendrier.affiche(toShow);
                        if (JCalendrier.clicked()) {
                            Date old = ConversionTime.stringToDate(DialogTypeFrais.this.getTblMontant().getValueAt(row, 0).toString(), "dd/MM/yyyy");
                            if ((DialogTypeFrais.this.amountDateChanged == null || old.before(DialogTypeFrais.this.amountDateChanged)) && DialogTypeFrais.this.current.getId() != 0) {
                                DialogTypeFrais.this.amountDateChanged = old;
                                TimsLogger.debug("#DialogTypeFrais.tableChanged# amountDateChanged set to " + DialogTypeFrais.this.amountDateChanged);
                            }
                            DialogTypeFrais.this.getTblMontant().setValueAt(JCalendrier.getDate(), row, column);
                        }
                    }
                }
            });
        }
        return this.tblMontant;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        TimsLogger.debug(String.valueOf(e.getSource().toString()) + " " + e.getType() + " " + e.getFirstRow() + " " + e.getLastRow());
        if (e.getFirstRow() == -1) {
            return;
        }
        Date selected = ConversionTime.stringToDate(this.getTblMontant().getValueAt(e.getFirstRow(), 0).toString(), "dd/MM/yyyy");
        if ((this.amountDateChanged == null || selected.before(this.amountDateChanged)) && this.current.getId() != 0) {
            this.amountDateChanged = selected;
            TimsLogger.debug("#DialogTypeFrais.tableChanged# amountDateChanged set to " + this.amountDateChanged);
        }
    }

    private JPanel getPnlBtnAmount() {
        if (this.pnlBtnAmount == null) {
            this.pnlBtnAmount = new JPanelButton(3, this.getBtnAddExpenseAmount());
        }
        return this.pnlBtnAmount;
    }

    private JButton getBtnAddExpenseAmount() {
        if (this.btnAddExpenseAmount == null) {
            this.btnAddExpenseAmount = new JButton();
            this.btnAddExpenseAmount.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_cliq"))));
            this.btnAddExpenseAmount.setPreferredSize(new Dimension(25, 25));
            this.btnAddExpenseAmount.setToolTipText(LanguageTranslator.getString("button.add"));
            this.btnAddExpenseAmount.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Date date = new Date();
                    ((TMExpensesAmount)DialogTypeFrais.this.getTblMontant().getModel()).addRow(new ExpensesAmount(0, DialogTypeFrais.this.current.getCle(), date, DialogTypeFrais.this.current.getMontant(null, 0), DialogTypeFrais.this.current.getMontant(null, 1)));
                    DialogTypeFrais.this.getBtnAddExpenseAmount().setEnabled(false);
                }
            });
        }
        return this.btnAddExpenseAmount;
    }

    private JPanelButton getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanelButton(this.getBtnQuitter());
            if (ConnexionSettings.getInstance().isSupprimable("FRAIS")) {
                this.pnlBtn.addBtn(this.getBtnArchive());
            }
            if (ConnexionSettings.getInstance().isModifiable("FRAIS")) {
                this.pnlBtn.addBtn(this.getBtnEnregistrer());
            }
        }
        return this.pnlBtn;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogTypeFrais.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JButton getBtnArchive() {
        if (this.btnArchive == null) {
            this.btnArchive = new JButton();
            this.btnArchive.setText(LanguageTranslator.getString("button.archive"));
            this.btnArchive.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogTypeFrais.this.archive();
                }
            });
        }
        return this.btnArchive;
    }

    public void archive() {
        if (this.current != null && JOptionPane.showConfirmDialog(this, LanguageTranslator.getString("generics.confirmArchive", this.current.getDesignation()), LanguageTranslator.getString("button.archive"), 0, 2) == 0) {
            this.current.setArchived(true);
            this.current.update();
            this.updateList();
        }
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogTypeFrais.this.current != null) {
                        DialogTypeFrais.this.save();
                        DialogTypeFrais.this.updateList();
                    }
                }
            });
        }
        return this.btnEnregistrer;
    }

    private JTextField getTxtDesignation() {
        if (this.txtDesignation == null) {
            this.txtDesignation = new JTextField();
        }
        return this.txtDesignation;
    }

    private JCheckBox getCbActif() {
        if (this.cbActif == null) {
            this.cbActif = new JCheckBox();
            this.cbActif.setFocusPainted(false);
            this.cbActif.setText(LanguageTranslator.getString("expenses.automaticCalculation"));
            this.cbActif.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean enable = DialogTypeFrais.this.getCbActif().isSelected();
                    DialogTypeFrais.this.getCbPeriod().setSelected(false);
                    DialogTypeFrais.this.getCbPeriod().setEnabled(enable);
                    DialogTypeFrais.this.getCbCumul().setSelected(false);
                    DialogTypeFrais.this.getCbCumul().setEnabled(enable);
                    DialogTypeFrais.this.getCbPosition().setSelected(false);
                    DialogTypeFrais.this.getCbPosition().setEnabled(enable);
                    if (enable && DialogTypeFrais.this.current != null) {
                        if (DialogTypeFrais.this.current.getBeginBefore() != -1 || DialogTypeFrais.this.current.getBeginAfter() != -1 || DialogTypeFrais.this.current.getEndBefore() != -1 || DialogTypeFrais.this.current.getEndAfter() != -1) {
                            DialogTypeFrais.this.getCbPeriod().setSelected(true);
                            DialogTypeFrais.this.getTxtBeginBefore().setText(DialogTypeFrais.this.current.getBeginBefore() == -1 ? "" : ConversionTime.heureIntToString(DialogTypeFrais.this.current.getBeginBefore(), "h"));
                            DialogTypeFrais.this.getTxtBeginAfter().setText(DialogTypeFrais.this.current.getBeginAfter() == -1 ? "" : ConversionTime.heureIntToString(DialogTypeFrais.this.current.getBeginAfter(), "h"));
                            DialogTypeFrais.this.getTxtEndBefore().setText(DialogTypeFrais.this.current.getEndBefore() == -1 ? "" : ConversionTime.heureIntToString(DialogTypeFrais.this.current.getEndBefore(), "h"));
                            DialogTypeFrais.this.getTxtEndAfter().setText(DialogTypeFrais.this.current.getEndAfter() == -1 ? "" : ConversionTime.heureIntToString(DialogTypeFrais.this.current.getEndAfter(), "h"));
                        } else if (DialogTypeFrais.this.current.getCumulService() != 0) {
                            DialogTypeFrais.this.getCbCumul().setSelected(true);
                            DialogTypeFrais.this.getTxtCumulService().setText(ConversionTime.heureIntToString(DialogTypeFrais.this.current.getCumulService(), "h"));
                            DialogTypeFrais.this.getTxtCumulAvant().setText(ConversionTime.heureIntToString(DialogTypeFrais.this.current.getCumulAvant(), "h"));
                            DialogTypeFrais.this.getTxtCumulApres().setText(ConversionTime.heureIntToString(DialogTypeFrais.this.current.getCumulApres(), "h"));
                        }
                    }
                    DialogTypeFrais.this.getPnlAutomatic().repaint();
                }
            });
        }
        return this.cbActif;
    }

    private void load(ExpensesType toLoad) {
        Fonctions.commit(this.getTblMontant());
        this.getMbDay().clearSelection();
        this.getMbExclusion().clearSelection();
        this.current = toLoad;
        this.getTxtDesignation().setText(this.current.getDesignation());
        this.getTxtCode().setText(this.current.getCode());
        this.getTxtHour().setHourMinute(this.current.getHour());
        this.getCbActif().setSelected(this.current.isActif());
        this.getCbFastView().setSelected(this.current.isFastView());
        this.getBtnAddExpenseAmount().setEnabled(true);
        this.getPnlAutomatic().repaint();
        if (this.current.getBeginBefore() != -1 || this.current.getBeginAfter() != -1 || this.current.getEndBefore() != -1 || this.current.getEndAfter() != -1) {
            this.getCbPeriod().setSelected(true);
            this.getTxtBeginBefore().setText(this.current.getBeginBefore() == -1 ? "" : ConversionTime.heureIntToString(this.current.getBeginBefore(), "h"));
            this.getTxtBeginAfter().setText(this.current.getBeginAfter() == -1 ? "" : ConversionTime.heureIntToString(this.current.getBeginAfter(), "h"));
            this.getTxtEndBefore().setText(this.current.getEndBefore() == -1 ? "" : ConversionTime.heureIntToString(this.current.getEndBefore(), "h"));
            this.getTxtEndAfter().setText(this.current.getEndAfter() == -1 ? "" : ConversionTime.heureIntToString(this.current.getEndAfter(), "h"));
        } else {
            this.getCbPeriod().setSelected(false);
            this.getTxtBeginBefore().setText("");
            this.getTxtBeginAfter().setText("");
            this.getTxtEndBefore().setText("");
            this.getTxtEndAfter().setText("");
        }
        if (this.current.getCumulService() != 0) {
            this.getCbCumul().setSelected(true);
            this.getTxtCumulService().setText(ConversionTime.heureIntToString(this.current.getCumulService(), "h"));
            this.getTxtCumulAvant().setText(ConversionTime.heureIntToString(this.current.getCumulAvant(), "h"));
            this.getTxtCumulApres().setText(ConversionTime.heureIntToString(this.current.getCumulApres(), "h"));
        } else {
            this.getCbCumul().setSelected(false);
            this.getTxtCumulService().setText("");
            this.getTxtCumulAvant().setText("");
            this.getTxtCumulApres().setText("");
        }
        if (this.current.getMaxDistance() != -1) {
            this.getCbPosition().setSelected(true);
            this.getTxtMaxDistance().setText(String.valueOf(this.current.getMaxDistance()));
            this.getCbHome().setSelected(this.current.isFromHome());
            this.getCbCompany().setSelected(this.current.isFromCompany());
            this.getCbAgency().setSelected(this.current.isFromAgency());
        } else {
            this.getCbPosition().setSelected(false);
            this.getTxtMaxDistance().setText("");
            this.getCbHome().setSelected(false);
            this.getCbCompany().setSelected(false);
            this.getCbAgency().setSelected(false);
        }
        if (this.current.getEnabledDay() != null) {
            for (int index : this.current.getEnabledDay()) {
                this.getMbDay().addSelectedIndex(index);
            }
        }
        if (this.current.getQuencher() != null) {
            for (int id : this.current.getQuencher()) {
                this.getMbExclusion().addSelectedId(id);
            }
        }
        ArrayList<ExpensesAmount> clone = new ArrayList<ExpensesAmount>();
        if (this.current.getMontants() != null) {
            for (ExpensesAmount original : this.current.getMontants()) {
                clone.add((ExpensesAmount)original.clone());
            }
        }
        this.getCbEmployeeType().setSelectedItem((Object)Constants.EMPLOYEE_TYPE.valueOf(this.current.getEmployeeTypeId()));
        TimsLogger.debug(String.valueOf(clone.size()) + " frais \u00e0 charger");
        ((TMExpensesAmount)this.getTblMontant().getModel()).setData(clone);
        this.amountDateChanged = null;
    }

    private void save() {
        if (!this.check()) {
            return;
        }
        Fonctions.commit(this.getTblMontant());
        int beginBefore = this.getTxtBeginBefore().isFilled() ? ConversionTime.heureStringToInt(this.getTxtBeginBefore().getText(), "h") : -1;
        int beginAfter = this.getTxtBeginAfter().isFilled() ? ConversionTime.heureStringToInt(this.getTxtBeginAfter().getText(), "h") : -1;
        int endBefore = this.getTxtEndBefore().isFilled() ? ConversionTime.heureStringToInt(this.getTxtEndBefore().getText(), "h") : -1;
        int endAfter = this.getTxtEndAfter().isFilled() ? ConversionTime.heureStringToInt(this.getTxtEndAfter().getText(), "h") : -1;
        Vector selQuenchers = this.getMbExclusion().getSelectedItems();
        Vector<Integer> quenchers = new Vector<Integer>();
        for (Object quencher : selQuenchers) {
            quenchers.add(((ExpensesType)quencher).getCle());
        }
        Vector days = this.getMbDay().getSelectedItems();
        Vector<Integer> enableDays = new Vector<Integer>();
        for (Object day : days) {
            enableDays.add(this.getMbDay().getIndexOf(day));
        }
        int employeeTypeId = ((Constants.EMPLOYEE_TYPE)((Object)this.getCbEmployeeType().getModel().getElementAt(this.getCbEmployeeType().getSelectedIndex()))).getId();
        this.current.compareAndUpdate(this.getTxtDesignation().getText(), this.getTxtCode().getText(), this.getTxtHour().getMinuteHour(), beginBefore, beginAfter, endBefore, endAfter, this.getTxtCumulService().getMinuteHour(), this.getTxtCumulAvant().getMinuteHour(), this.getTxtCumulApres().getMinuteHour(), Integer.parseInt(this.getTxtMaxDistance().getText().equals("") ? "-1" : this.getTxtMaxDistance().getText()), this.getCbHome().isSelected(), this.getCbCompany().isSelected(), this.getCbAgency().isSelected(), this.getCbFastView().isSelected(), this.current.getBeginView(), this.current.getEndView(), this.getCbActif().isSelected(), quenchers, enableDays, employeeTypeId, this.current.getExport(), this.current.isArchived(), ((TMExpensesAmount)this.getTblMontant().getModel()).getData());
        ExpensesType.setList(null);
        if (this.amountDateChanged != null) {
            if (MessageSystemManager.showConfirm(this, LanguageTranslator.getString("expense.updateAmount", this.current.getDesignation(), ConversionTime.dateToString(this.amountDateChanged, "dd/MM/yyyy")), LanguageTranslator.getString("message.done")) == 0) {
                DriverExpenses.updateAmount(this.current, this.amountDateChanged);
            }
            this.amountDateChanged = null;
        }
        MessageSystemManager.information((Component)this, LanguageTranslator.getString("message.saveSucceed"), LanguageTranslator.getString("message.done"));
    }

    private boolean check() {
        boolean toReturn = true;
        if (this.getCbPosition().isSelected()) {
            if (this.getTxtMaxDistance().getText().equals("") || !this.getTxtMaxDistance().getText().matches("\\d+")) {
                this.getTxtMaxDistance().setBackground(new Color(255, 192, 203));
                this.getTxtMaxDistance().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
                toReturn = false;
            } else {
                this.getTxtMaxDistance().setBackground(Color.white);
            }
        }
        return toReturn;
    }

    public void updateList() {
        this.getListeFrais().setModel(new LMFrais(ExpensesType.getList()));
        this.getListeFrais().setSelectedValue(this.current.getDesignation(), true);
        this.getMbExclusion().setModel(new MultiListBoxModel<ExpensesType>(ExpensesType.getList(), false));
    }

    private JPanel getPnlDay() {
        if (this.pnlDay == null) {
            this.pnlDay = new JPanel();
            this.pnlDay.setLayout(new GridBagLayout());
        }
        return this.pnlDay;
    }

    private JMultiListBox getMbExclusion() {
        if (this.mbExclusion == null) {
            this.mbExclusion = new JMultiListBox<ExpensesType>(ExpensesType.getList(), false);
        }
        return this.mbExclusion;
    }

    private JMultiListBox getMbDay() {
        if (this.mbDay == null) {
            Vector<String> day = new Vector<String>();
            day.add(LanguageTranslator.getString("generics.monday"));
            day.add(LanguageTranslator.getString("generics.tuesday"));
            day.add(LanguageTranslator.getString("generics.wednesday"));
            day.add(LanguageTranslator.getString("generics.thursday"));
            day.add(LanguageTranslator.getString("generics.friday"));
            day.add(LanguageTranslator.getString("generics.saturday"));
            day.add(LanguageTranslator.getString("generics.sunday"));
            this.mbDay = new JMultiListBox(day, false);
        }
        return this.mbDay;
    }

    private JTextField getTxtCode() {
        if (this.txtCode == null) {
            this.txtCode = new JTextField();
        }
        return this.txtCode;
    }

    private JPanel getPnlPeriod() {
        if (this.pnlPeriod == null) {
            this.pnlPeriod = new JPanel();
            this.pnlPeriod.setLayout(new GridBagLayout());
            this.pnlPeriod.setBorder(new CheckBoxBorder(this.getCbPeriod(), this.pnlPeriod, BorderFactory.createLineBorder(SystemColor.activeCaption, 1)));
            this.pnlPeriod.add((Component)this.getPnlDebut(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 2, -1, new Insets(2, 2, 2, 6)));
            this.pnlPeriod.add((Component)this.getPnlFin(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 2, -1, new Insets(2, 5, 2, 2)));
        }
        return this.pnlPeriod;
    }

    private JCheckBox getCbPeriod() {
        if (this.cbPeriod == null) {
            this.cbPeriod = new JCheckBox();
            this.cbPeriod.setEnabled(false);
            this.cbPeriod.setText(LanguageTranslator.getString("expenses.period"));
            this.cbPeriod.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TimsLogger.debug("itemStateChange for cbPeriod " + e.getStateChange());
                    boolean enable = DialogTypeFrais.this.getCbPeriod().isSelected();
                    Fonctions.setEnabled(DialogTypeFrais.this.getPnlPeriod(), enable);
                    if (enable) {
                        DialogTypeFrais.this.getCbPosition().setSelected(false);
                        DialogTypeFrais.this.getCbCumul().setSelected(false);
                    }
                    DialogTypeFrais.this.getPnlPeriod().repaint();
                }
            });
        }
        return this.cbPeriod;
    }

    private JCheckBox getCbCumul() {
        if (this.cbCumul == null) {
            this.cbCumul = new JCheckBox();
            this.cbCumul.setText(LanguageTranslator.getString("expenses.total"));
            this.cbCumul.setEnabled(false);
            this.cbCumul.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TimsLogger.debug("itemStateChange for cbCumul " + e.getStateChange());
                    boolean enable = DialogTypeFrais.this.getCbCumul().isSelected();
                    Fonctions.setEnabled(DialogTypeFrais.this.getPnlCumul(), enable);
                    if (enable) {
                        DialogTypeFrais.this.getCbPosition().setSelected(false);
                        DialogTypeFrais.this.getCbPeriod().setSelected(false);
                    }
                    DialogTypeFrais.this.getPnlCumul().repaint();
                }
            });
        }
        return this.cbCumul;
    }

    private JTextHour getTxtBeginAfter() {
        if (this.txtBeginAfter == null) {
            this.txtBeginAfter = new JTextHour();
            this.txtBeginAfter.setPreferredSize(new Dimension(45, 20));
            this.txtBeginAfter.setEnabled(false);
        }
        return this.txtBeginAfter;
    }

    private JTextHour getTxtHour() {
        if (this.txtHour == null) {
            this.txtHour = new JTextHour();
            this.txtHour.setPreferredSize(new Dimension(45, 20));
        }
        return this.txtHour;
    }

    private JCheckBox getCbFastView() {
        if (this.cbFastView == null) {
            this.cbFastView = new JCheckBox();
            this.cbFastView.setToolTipText(LanguageTranslator.getString("expenses.fastView"));
        }
        return this.cbFastView;
    }

    private JTextHour getTxtEndBefore() {
        if (this.txtEndBefore == null) {
            this.txtEndBefore = new JTextHour();
            this.txtEndBefore.setPreferredSize(new Dimension(45, 20));
            this.txtEndBefore.setEnabled(false);
        }
        return this.txtEndBefore;
    }

    private JPanel getPnlGeneralRules() {
        if (this.pnlGeneralRules == null) {
            this.lblCode = new JLabel();
            this.lblCode.setText(LanguageTranslator.getString("generics.code"));
            this.lblDesignation = new JLabel();
            this.lblDesignation.setText(LanguageTranslator.getString("generics.designation"));
            this.lblHour = new JLabel();
            this.lblHour.setText(LanguageTranslator.getString("expenses.hour"));
            this.pnlGeneralRules = new JPanel();
            this.pnlGeneralRules.setLayout(new GridBagLayout());
            this.pnlGeneralRules.add((Component)this.lblDesignation, Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, -1, null));
            this.pnlGeneralRules.add((Component)this.getTxtDesignation(), Fonctions.getGridBagConstraints(1, 0, 1, 4, 1.0, 0.0, 1, -1, null));
            this.pnlGeneralRules.add((Component)this.lblCode, Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, -1, new Insets(5, 0, 0, 0)));
            this.pnlGeneralRules.add((Component)this.getTxtCode(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 1, -1, new Insets(5, 0, 0, 0)));
            this.pnlGeneralRules.add((Component)this.lblHour, Fonctions.getGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, -1, new Insets(5, 0, 0, 0)));
            this.pnlGeneralRules.add((Component)this.getTxtHour(), Fonctions.getGridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 0, 0, 0)));
            this.pnlGeneralRules.add((Component)this.getCbFastView(), Fonctions.getGridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 0, 0, 0)));
        }
        return this.pnlGeneralRules;
    }

    private JPanel getPnlAutomatic() {
        if (this.pnlAutomatic == null) {
            this.pnlAutomatic = new JPanel();
            this.pnlAutomatic.setLayout(new GridBagLayout());
            this.lblWorkedDay = new JLabel();
            this.lblWorkedDay.setText(LanguageTranslator.getString("expenses.enabledDay"));
            this.lblExcExp = new JLabel();
            this.lblExcExp.setText(LanguageTranslator.getString("expenses.quencher"));
            this.lblEmployeeType = new JLabel();
            this.lblEmployeeType.setText(LanguageTranslator.getString("generics.employee"));
            CheckBoxBorder border = new CheckBoxBorder(this.getCbActif(), this.pnlAutomatic, BorderFactory.createLineBorder(SystemColor.activeCaption, 1));
            this.pnlAutomatic.setBorder(border);
            this.pnlAutomatic.add((Component)this.getPnlPeriod(), Fonctions.getGridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 1, -1, new Insets(0, 5, 10, 5)));
            this.pnlAutomatic.add((Component)this.getPnlCumul(), Fonctions.getGridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 1, -1, new Insets(0, 5, 10, 5)));
            this.pnlAutomatic.add((Component)this.getPnlPosition(), Fonctions.getGridBagConstraints(0, 2, 1, 2, 1.0, 1.0, 1, -1, new Insets(0, 5, 10, 5)));
            this.pnlAutomatic.add((Component)this.lblWorkedDay, Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, -1, new Insets(5, 0, 0, 0)));
            this.pnlAutomatic.add((Component)this.getMbDay(), Fonctions.getGridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 1, -1, new Insets(5, 0, 0, 0)));
            this.pnlAutomatic.add((Component)this.lblExcExp, Fonctions.getGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, -1, new Insets(5, 0, 0, 0)));
            this.pnlAutomatic.add((Component)this.getMbExclusion(), Fonctions.getGridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 1, -1, new Insets(5, 0, 0, 0)));
            this.pnlAutomatic.add((Component)this.lblEmployeeType, Fonctions.getGridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, -1, new Insets(5, 0, 0, 0)));
            this.pnlAutomatic.add(this.getCbEmployeeType(), Fonctions.getGridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 1, -1, new Insets(5, 0, 0, 0)));
        }
        return this.pnlAutomatic;
    }

    private JComboBox<Constants.EMPLOYEE_TYPE> getCbEmployeeType() {
        if (this.cbEmployeeType == null) {
            this.cbEmployeeType = new JComboBox<Constants.EMPLOYEE_TYPE>(Constants.EMPLOYEE_TYPE.values());
        }
        return this.cbEmployeeType;
    }

    private JCheckBox getCbArchive() {
        if (this.cbArchive == null) {
            this.cbArchive = new JCheckBox();
            this.cbArchive.setText(LanguageTranslator.getString("generics.seeArchive"));
            this.cbArchive.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean enable = DialogTypeFrais.this.getCbArchive().isSelected();
                    if (enable) {
                        DialogTypeFrais.this.getListeFrais().setModel(new LMFrais(ExpensesType.loadListWithAmount(true)));
                        DialogTypeFrais.this.getBtnEnregistrer().setEnabled(false);
                        DialogTypeFrais.this.getBtnArchive().setEnabled(false);
                        DialogTypeFrais.this.getBtnCreer().setEnabled(false);
                    } else {
                        DialogTypeFrais.this.getListeFrais().setModel(new LMFrais(ExpensesType.getList()));
                        DialogTypeFrais.this.getBtnEnregistrer().setEnabled(true);
                        DialogTypeFrais.this.getBtnArchive().setEnabled(true);
                        DialogTypeFrais.this.getBtnCreer().setEnabled(true);
                    }
                }
            });
        }
        return this.cbArchive;
    }
}

