/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class GraphJour
extends JPanel
implements MouseMotionListener,
MouseWheelListener,
Printable {
    private static final long serialVersionUID = 1L;
    public float minuteWidth = 0.0f;
    public int dayHeight = 0;
    Vector<ActiviteConducteur> v1 = new Vector();
    Vector<ActiviteConducteur> selected = new Vector();
    int dayKm = 0;
    int dayDriving = 0;

    public GraphJour() {
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setInitialDelay(10);
        ToolTipManager.sharedInstance().setReshowDelay(10);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.addMouseWheelListener(this);
    }

    public GraphJour(String tableActivite) {
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setInitialDelay(10);
        ToolTipManager.sharedInstance().setReshowDelay(10);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.addMouseWheelListener(this);
    }

    public Vector<ActiviteConducteur> getJour() {
        return this.v1;
    }

    public Vector<ActiviteConducteur> getActiviteAvant(int minute) {
        Vector<ActiviteConducteur> retour = new Vector<ActiviteConducteur>();
        for (ActiviteConducteur act : this.v1) {
            if (act.getHeureFin() > minute) continue;
            retour.add(act);
        }
        return retour;
    }

    public Vector<ActiviteConducteur> getActiviteApres(int minute) {
        Vector<ActiviteConducteur> retour = new Vector<ActiviteConducteur>();
        for (ActiviteConducteur act : this.v1) {
            if (act.getHeureDebut() >= minute) {
                retour.add(act);
                continue;
            }
            if (act.getHeureFin() <= minute) continue;
            act.setHeureDebut(minute);
            act.setDuree(act.getHeureFin() - act.getHeureDebut());
            retour.add(act);
        }
        return retour;
    }

    public int getMinute(int x) {
        return (int)((float)x / this.minuteWidth);
    }

    public float getMinuteWidth() {
        return this.minuteWidth;
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
        this.setToolTipText(null);
        if (this.v1 == null) {
            return;
        }
        if (this.v1.size() == 0) {
            this.setToolTipText(null);
            return;
        }
        int X = arg0.getX();
        int Y = arg0.getY();
        boolean toolTipAdded = false;
        for (ActiviteConducteur elt1 : this.v1) {
            int h_debut = (int)((float)elt1.getHeureDebut() * this.minuteWidth);
            int h_fin = (int)((float)elt1.getHeureFin() * this.minuteWidth);
            int hauteur = this.hauteur(elt1.getCleType());
            if (X < h_debut || X > h_fin || Y < this.dayHeight - hauteur) continue;
            if (elt1.getCleType() == 1 && this.dayKm != 0) {
                TimsLogger.debug(String.valueOf(elt1.getDuree()) + " " + this.dayKm);
                float ratio = (float)elt1.getDuree() / (float)this.dayDriving;
                int actKm = (int)(ratio * (float)this.dayKm);
                this.setToolTipText(LanguageTranslator.getString("graphic.driving.toolTip", ConversionTime.heureIntToString(elt1.getHeureDebut(), "h"), ConversionTime.heureIntToString(elt1.getHeureFin(), "h"), ConversionTime.heureIntToString(elt1.getDuree(), "h"), elt1.getDescription(), String.valueOf(actKm)));
            } else {
                this.setToolTipText(LanguageTranslator.getString("graphic.activity.toolTip", ConversionTime.heureIntToString(elt1.getHeureDebut(), "h"), ConversionTime.heureIntToString(elt1.getHeureFin(), "h"), ConversionTime.heureIntToString(elt1.getDuree(), "h"), elt1.getDescription()));
            }
            toolTipAdded = true;
        }
        if (!toolTipAdded) {
            this.setToolTipText(null);
        }
    }

    public ActiviteConducteur getActivite(int x) {
        for (ActiviteConducteur elt1 : this.v1) {
            if (!((float)x >= (float)elt1.getHeureDebut() * this.minuteWidth) || !((float)x <= (float)elt1.getHeureFin() * this.minuteWidth)) continue;
            return elt1;
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        int xPos;
        int height = this.getHeight();
        int width = this.getWidth();
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        this.addMouseMotionListener(this);
        this.minuteWidth = (float)width / 1440.0f;
        this.dayHeight = height;
        g.setColor(Color.black);
        int x = 0;
        while (x <= 24) {
            xPos = (int)((float)x * this.minuteWidth * 60.0f);
            if (x == 0) {
                g.drawString("0", xPos, 10);
            } else if (x == 24) {
                g.drawString("24", xPos - 14, 10);
            } else {
                g.drawString(String.valueOf(x), xPos - 4, 10);
            }
            g.drawLine(xPos, 15, xPos, 7 * this.dayHeight);
            ++x;
        }
        if (width > 1100) {
            g.setColor(Color.lightGray);
            x = 0;
            while (x < 24) {
                xPos = (int)((float)x * this.minuteWidth * 60.0f + 30.0f * this.minuteWidth);
                g.drawLine(xPos, 0, xPos, 7 * this.dayHeight);
                ++x;
            }
        }
        if (width > 1600) {
            g.setColor(new Color(240, 240, 240));
            x = 0;
            while (x < 24) {
                xPos = (int)((float)x * this.minuteWidth * 60.0f + 15.0f * this.minuteWidth);
                g.drawLine(xPos, 0, xPos, 7 * this.dayHeight);
                xPos = (int)((float)xPos + 30.0f * this.minuteWidth);
                g.drawLine(xPos, 0, xPos, 7 * this.dayHeight);
                ++x;
            }
        }
        g.setColor(Color.BLACK);
        g.drawLine(0, this.dayHeight, (int)(24.0f * this.minuteWidth), this.dayHeight);
        this.affichage(g, this.dayHeight);
    }

    private void affichage(Graphics g, int PosY) {
        if (this.v1 == null || this.v1.size() == 0) {
            return;
        }
        for (ActiviteConducteur tmp : this.v1) {
            g.setColor(new Color(Integer.parseInt(tmp.getCouleur())));
            int beginX = (int)((float)tmp.getHeureDebut() * this.minuteWidth);
            int beginY = this.dayHeight - this.hauteur(tmp.getCleType());
            int widthAct = (float)tmp.getDuree() * this.minuteWidth == 0.0f ? 1 : (int)((float)tmp.getDuree() * this.minuteWidth);
            int hightAct = this.hauteur(tmp.getCleType());
            g.fillRect(beginX, beginY, widthAct, hightAct);
            if (!tmp.isManualInput()) continue;
            g.setColor(Color.BLACK);
            g.fillRect(beginX, beginY - 5, widthAct, 2);
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0 || this.v1 == null || this.v1.size() == 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int pasV = (int)pageFormat.getImageableWidth() / 24;
        int pasH = 45;
        float valUnitaire = (float)pageFormat.getImageableWidth() / 1440.0f;
        g.setColor(Color.black);
        g.drawString("0", 0, 10);
        g.drawLine(0, 15, 0, pasH);
        int i = 1;
        while (i < 24) {
            g.drawString(String.valueOf(i), i * pasV - 4, 10);
            g.drawLine(i * pasV, 15, i * pasV, pasH);
            ++i;
        }
        g.drawString("24", 24 * pasV - 12, 10);
        g.drawLine(24 * pasV, 15, 24 * pasV, pasH);
        g.setColor(Color.BLACK);
        g.drawLine(0, pasH, 24 * pasV, pasH);
        for (ActiviteConducteur tmp : this.v1) {
            g.setColor(new Color(Integer.parseInt(tmp.getCouleur())));
            int beginX = (int)((float)tmp.getHeureDebut() * valUnitaire);
            int beginY = pasH - this.hauteur(tmp.getCleType());
            int widthAct = (float)tmp.getDuree() * valUnitaire == 0.0f ? 1 : (int)((float)tmp.getDuree() * valUnitaire);
            int hightAct = this.hauteur(tmp.getCleType());
            g.fillRect(beginX, beginY, widthAct, hightAct);
            if (!tmp.isManualInput()) continue;
            g.setColor(Color.BLACK);
            g.fillRect(beginX, beginY - 5, widthAct, 2);
        }
        return 0;
    }

    int hauteur(int activite) {
        if (activite == 1) {
            return 20;
        }
        if (activite == 2) {
            return 15;
        }
        if (activite == 3) {
            return 11;
        }
        if (activite == 4) {
            return 5;
        }
        if (activite == 5) {
            return 11;
        }
        if (activite == 6) {
            return 15;
        }
        if (activite == 7) {
            return 5;
        }
        return 8;
    }

    public void initialiser(Vector<ActiviteConducteur> v1, int dayKm, int dayDriving) {
        this.v1 = v1;
        this.dayKm = dayKm;
        this.dayDriving = dayDriving;
        this.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent arg0) {
        TimsLogger.verbose("on entre dans mouse wheel");
        int notches = arg0.getWheelRotation();
        int ratio = -notches * 100;
        int finalWidth = this.getWidth() + ratio;
        int mouseX = arg0.getX();
        int finalPosition = finalWidth * mouseX / this.getWidth();
        double viewPosition = ((JViewport)this.getParent()).getViewPosition().getX();
        int interval = mouseX - (int)viewPosition;
        int finalViewPosition = finalPosition - interval;
        this.setSize(new Dimension(finalWidth, this.getHeight()));
        this.setPreferredSize(new Dimension(finalWidth, this.getHeight()));
        ((JViewport)this.getParent()).setViewPosition(new Point(finalViewPosition, 0));
    }
}

