/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.ChangementActivite;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.ExpensesValidation;
import fr.pgh.data.bdd.ExternalDay;
import fr.pgh.data.bdd.Jour;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Offence;
import fr.pgh.data.bdd.Pays;
import fr.pgh.data.bdd.Place;
import fr.pgh.data.bdd.RoundAffectation;
import fr.pgh.data.bdd.RoundType;
import fr.pgh.data.bdd.SpecificCondition;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.exception.ExpensesNotFoundException;
import fr.pgh.exception.ServiceException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import transpo.system.TimsLogger;
import transpo.system.traitement.TraitementTempsService;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.AbsencePopup;
import transpo.system.ui.views.ListPopup;
import transpo.system.ui.views.PopupCaller;
import transpo.system.ui.views.conducteur.PnlActiviteC;
import transpo.system.util.Fonctions;

public class GrapheActivite
extends JPanel
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
Printable,
PopupCaller,
ActionListener,
DataListener {
    private static final long serialVersionUID = 1L;
    private Vector<Jour> d = new Vector();
    private Vector<RoundAffectation> r = new Vector();
    private Vector<Offence>[] i = new Vector[7];
    private Vector<VehicleUsed>[] v = new Vector[7];
    private Vector<Place>[] p = new Vector[7];
    private Vector<SpecificCondition>[] s = new Vector[7];
    private Vector<ExternalDay>[] e = new Vector[7];
    private Vector<DriverExpenses> f = new Vector();
    private Vector<LienJourConducteur> a = new Vector();
    private Vector<ExpensesValidation> expV = new Vector();
    private HashMap<Integer, Vector<JButtonExpenses>> btnsExp = null;
    private HashMap<JButtonExpenses, DriverExpenses> linkExpense = null;
    private Conducteur currentDriver = null;
    private Date firstDay = null;
    private boolean showExpenses = false;
    private ListPopup lp = null;
    private AbsencePopup ap = null;
    private ActiviteConducteur focused = null;
    private int dayPosition = 0;
    private boolean isPopupVisible = false;
    private int dayHeight = 0;
    private int absHeight = 5;
    private float minuteWidth = 0.0f;
    private static int pasInfraction = 17;
    private static int circleSize = 6;
    private static int pasVehicule = 15;
    private static int hauteurVehicule = 15;
    private static int largeurVehicule = 15;
    private static int placeHeight = 12;
    private static int placeWidth = 11;
    private static int placePosition = 15;
    private static int specHeight = 16;
    private static int specWidth = 24;
    private static int specPosition = 15;
    private static int extActivityPosition = -10;
    private boolean checkRight = false;
    Color LIGHT_RED = new Color(0xFFF1F1);
    Color LIGHT_ORANGE = new Color(16775589);
    Color LIGHT_GREEN = new Color(0xDEFFDE);

    public GrapheActivite(boolean checkRight) {
        this.checkRight = checkRight;
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        if (checkRight && ConnexionSettings.getInstance().isConsultable("FRAIS")) {
            this.initExp();
        }
        this.setOpaque(false);
        BddTransport.getInstance().addDataListener(this);
    }

    public void initExp() {
        this.removeAll();
        this.linkExpense = new HashMap();
        this.btnsExp = new HashMap();
        for (ExpensesType exp : ExpensesType.getList()) {
            if (!exp.isFastView()) continue;
            TimsLogger.debug("#GrapheActivite.initExp# Init " + exp.getCode());
            Vector<JButtonExpenses> btnExp = new Vector<JButtonExpenses>();
            this.btnsExp.put(exp.getId(), btnExp);
            int x = 0;
            while (x <= 6) {
                JButtonExpenses btn = new JButtonExpenses(exp.getCode(), x, exp);
                btnExp.add(btn);
                if (this.showExpenses) {
                    btn.setVisible(false);
                }
                btn.setFont(new Font("Arial", 0, 8));
                btn.setMargin(new Insets(2, 2, 2, 2));
                this.add(btn);
                btn.setToolTipText(LanguageTranslator.getString("expenses.graph.add", exp.getDesignation()));
                btn.addActionListener(this);
                ++x;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButtonExpenses) {
            JButtonExpenses clicked = (JButtonExpenses)e.getSource();
            DriverExpenses de = clicked.getDe();
            TimsLogger.debug(de == null ? "Pas de frais" : de.affiche());
            if (de != null) {
                if (!de.isOutside()) {
                    de.setOutside(true);
                    de.setAmount(clicked.getEt().getMontant(de.getDate(), 1));
                    de.updateValue();
                    clicked.setToolTipText(LanguageTranslator.getString("expenses.graph.delete", clicked.getEt().getDesignation()));
                } else {
                    de.delete();
                    this.f.remove(de);
                    clicked.setDe(null);
                    clicked.setToolTipText(LanguageTranslator.getString("expenses.graph.add", clicked.getEt().getDesignation()));
                }
            } else {
                ExpensesType et = clicked.getEt();
                int pos = clicked.getPos();
                Date date = ConversionTime.addDay(this.firstDay, pos);
                float amount = et.getMontant(date, 0);
                DriverExpenses toAdd = new DriverExpenses(0, this.currentDriver.getCleConducteur(), date, et.getId(), true, 0.0f, 0.0f, amount, false, 0);
                toAdd.insert();
                clicked.setDe(toAdd);
                clicked.setToolTipText(LanguageTranslator.getString("expenses.graph.switch"));
            }
            clicked.repaint();
        }
    }

    public void initialiser(Conducteur currentDriver, Date firstDay, Vector<Jour> d, Vector<RoundAffectation> r, Vector<Offence>[] i, Vector<VehicleUsed>[] v, Vector<Place>[] p, Vector<SpecificCondition>[] s, Vector<ExternalDay>[] e, Vector<DriverExpenses> f, Vector<ExpensesValidation> expV, Vector<LienJourConducteur> a, boolean showExpenses) {
        this.showExpenses = showExpenses;
        this.currentDriver = currentDriver;
        this.firstDay = firstDay;
        this.d = d;
        this.r = r;
        this.i = i;
        this.v = v;
        this.p = p;
        this.s = s;
        this.e = e;
        this.f = f;
        this.a = a;
        this.expV = expV;
        if (this.checkRight && ConnexionSettings.getInstance().isConsultable("FRAIS")) {
            int x = 0;
            while (x <= 6) {
                Vector<ExpensesValidation> tmp = ExpensesValidation.find(expV, currentDriver.getCleConducteur(), ConversionTime.add(firstDay, 5, x));
                for (ExpensesType exp : ExpensesType.getList()) {
                    Vector<JButtonExpenses> btnList;
                    if (!exp.isFastView() || (btnList = this.btnsExp.get(exp.getId())) == null) continue;
                    btnList.get(x).setText(exp.getCode());
                    btnList.get(x).setDe(null);
                    btnList.get(x).setVisible(showExpenses);
                    if (tmp.size() != 0) {
                        btnList.get(x).setEnabled(false);
                        continue;
                    }
                    btnList.get(x).setEnabled(true);
                }
                ++x;
            }
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        TimsLogger.verbose("#GrapheACtivite.paint# on dessine le graphique...");
        this.drawBack(g);
        int x = 0;
        while (x < 7) {
            this.drawDay(this.d == null || this.d.size() <= x ? null : this.d.get(x), this.r == null ? null : this.r, this.i == null ? null : this.i[x], this.v == null ? null : this.v[x], this.p == null ? null : this.p[x], this.s == null ? null : this.s[x], this.e == null ? null : this.e[x], g, (x + 1) * this.dayHeight);
            ++x;
        }
        this.drawGlobal(this.a, this.f, this.expV, g);
        super.paint(g);
    }

    private void drawGlobal(Vector<LienJourConducteur> absences, Vector<DriverExpenses> expenses, Vector<ExpensesValidation> expV, Graphics g) {
        if (absences != null) {
            for (LienJourConducteur abs : absences) {
                try {
                    JourType jt = JourType.getDayType(abs.getCleJourType());
                    abs.getDateJour();
                    int begin = abs.getHeureDebut();
                    int end = abs.getPrintEnd();
                    int heightOffset = this.getDayHeight(abs.getDateJour()) + 1;
                    int beginOffset = (int)((float)begin * this.minuteWidth);
                    int endOffset = (int)((float)end * this.minuteWidth);
                    TimsLogger.verbose("#GrapheActivite.drawGlobal # draw " + jt.getCode() + " from " + begin + " to " + end + " at " + abs.getDateJour());
                    this.drawHatching(beginOffset, heightOffset, endOffset - beginOffset, this.absHeight, g, jt.getColor());
                }
                catch (Exception ex) {
                    TimsLogger.warn("#GrapheActivite.drawGlobal # dayTypeNotFound : " + abs.getCleJourType());
                }
            }
        }
        if (this.showExpenses && expenses != null && expenses.size() != 0 && (ConnexionSettings.getInstance().isConsultable("FRAIS") || !this.checkRight)) {
            for (ExpensesType et : ExpensesType.getList()) {
                if (!et.isFastView()) continue;
                Vector<JButtonExpenses> btnList = this.btnsExp.get(et.getId());
                int x = 0;
                while (x <= 6) {
                    btnList.get(x).setToolTipText(LanguageTranslator.getString("expenses.graph.add", et.getDesignation()));
                    ++x;
                }
            }
            for (DriverExpenses de : expenses) {
                try {
                    ExpensesType et = ExpensesType.getExpenses(de.getExpensesId());
                    TimsLogger.debug("search " + et.getCode() + " " + de.getDate() + " (" + de.isOutside() + ")");
                    if (!et.isFastView()) continue;
                    Vector<JButtonExpenses> btnList = this.btnsExp.get(et.getId());
                    int x = 0;
                    while (x <= 6) {
                        if (ConversionTime.add(this.firstDay, 5, x).equals(de.getDate())) {
                            TimsLogger.debug("affect on " + x);
                            JButtonExpenses btn = btnList.get(x);
                            btn.setDe(de);
                            this.linkExpense.put(btn, de);
                            if (btn.isEnabled()) {
                                if (de.isOutside()) {
                                    btn.setToolTipText(LanguageTranslator.getString("expenses.graph.delete", et.getDesignation()));
                                } else {
                                    btn.setToolTipText("<html>" + LanguageTranslator.getString("expenses.graph.switch", et.getDesignation(), String.valueOf(de.getAmount())) + "</html>");
                                }
                            } else {
                                btn.setToolTipText(LanguageTranslator.getString("expenses.graph.locked"));
                            }
                        }
                        ++x;
                    }
                }
                catch (ExpensesNotFoundException ex) {
                    TimsLogger.error("#Expense type not found#" + de.getExpensesId());
                }
            }
        }
    }

    private void drawHatching(int beginOffset, int heightOffset, int width, int height, Graphics g, int color) {
        int ecart = 8;
        int epais = 5;
        int biais = 2;
        g.setColor(new Color(color));
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < epais) {
                g.drawLine(beginOffset + i + j, heightOffset, beginOffset + i - biais + j, heightOffset + height);
                ++j;
            }
            i += ecart;
        }
    }

    private void drawBack(Graphics g) {
        int xPos;
        this.minuteWidth = (float)this.getWidth() / 1440.0f;
        this.dayHeight = (this.getHeight() - 15) / 7;
        g.setColor(Color.black);
        int x = 0;
        while (x <= 24) {
            xPos = (int)((float)x * this.minuteWidth * 60.0f);
            if (x == 0) {
                g.drawString("0", xPos, 10);
            } else if (x == 24) {
                g.drawString("24", xPos - 14, 10);
            } else {
                g.drawString(String.valueOf(x), xPos - 4, 10);
            }
            g.drawLine(xPos, 15, xPos, 7 * this.dayHeight);
            ++x;
        }
        if (this.getWidth() > 1000) {
            g.setColor(Color.lightGray);
            x = 0;
            while (x < 24) {
                xPos = (int)((float)x * this.minuteWidth * 60.0f + 30.0f * this.minuteWidth);
                g.drawLine(xPos, 0, xPos, 7 * this.dayHeight);
                ++x;
            }
        }
        if (this.getWidth() > 1600) {
            g.setColor(new Color(240, 240, 240));
            x = 0;
            while (x < 24) {
                xPos = (int)((float)x * this.minuteWidth * 60.0f + 15.0f * this.minuteWidth);
                g.drawLine(xPos, 0, xPos, 7 * this.dayHeight);
                xPos = (int)((float)xPos + 30.0f * this.minuteWidth);
                g.drawLine(xPos, 0, xPos, 7 * this.dayHeight);
                ++x;
            }
        }
        if (this.showExpenses && this.checkRight && ConnexionSettings.getInstance().isConsultable("FRAIS")) {
            g.setColor(new Color(0x5EFF5E));
            for (ExpensesType exp : ExpensesType.getList()) {
                if (!exp.isFastView()) continue;
                TimsLogger.debug("#GrapheActivite.drawback# put button for " + exp.getCode());
                int hour = exp.getHour();
                int xPos2 = (int)((float)hour * this.minuteWidth);
                Vector<JButtonExpenses> set = this.btnsExp.get(exp.getId());
                int buttonHeight = 16;
                int buttonShift = 45;
                TimsLogger.info("dayHeight " + this.dayHeight);
                if (this.dayHeight < 70) {
                    buttonHeight = 14;
                    buttonShift = Math.max(32, this.dayHeight * 50 / 100);
                    TimsLogger.info("need adjustement " + buttonHeight + " " + buttonShift);
                }
                int i = 0;
                while (i <= 6) {
                    set.get(i).setBounds(xPos2 - 13, (i + 1) * this.dayHeight - buttonShift, exp.getCode().length() * 8 + 14, buttonHeight);
                    ++i;
                }
            }
        }
        int i = 1;
        while (i <= 7) {
            g.setColor(Color.BLACK);
            g.drawLine(0, i * this.dayHeight, (int)(24.0f * this.minuteWidth * 60.0f), i * this.dayHeight);
            ++i;
        }
    }

    void drawDay(Jour day, Vector<RoundAffectation> r, Vector<Offence> infraction, Vector<VehicleUsed> vehicle, Vector<Place> place, Vector<SpecificCondition> spec, Vector<ExternalDay> extActivity, Graphics g, int PosY) {
        String image;
        int val1;
        int time;
        if (day != null && r != null && r.size() != 0) {
            int theoricRoundPosition = 14;
            int theoricFlagHeight = 6;
            int theoricRoundHeight = 3;
            int doneRoundPosition = 2;
            int doneFlagHeight = 6;
            int doneRoundHeight = 3;
            RoundAffectation roundA = this.getRoundOn(day.getDate());
            if (roundA != null) {
                RoundType rt = new RoundType();
                rt.loadById(roundA.getRoundId());
                int begin = (int)((float)rt.getBeginTime() * this.minuteWidth);
                int loadTime = (int)((float)rt.getLoadTime() * this.minuteWidth);
                int agencyLeft = (int)((float)(rt.getBeginTime() + rt.getLoadTime()) * this.minuteWidth);
                int agencyReturn = (int)((float)rt.getReturnTime() * this.minuteWidth);
                int unloadTime = (int)((float)rt.getUnloadTime() * this.minuteWidth);
                int end = (int)((float)(rt.getReturnTime() + rt.getUnloadTime()) * this.minuteWidth);
                int yForTheoric = PosY + theoricRoundPosition - theoricFlagHeight;
                g.setColor(Color.darkGray);
                g.fillRect(begin, yForTheoric, loadTime, theoricFlagHeight);
                g.fillRect(agencyReturn, yForTheoric, unloadTime, theoricFlagHeight);
                g.setColor(Color.darkGray);
                g.fillRect(begin + 1, PosY + theoricRoundPosition - theoricRoundHeight, end - begin - 2, theoricRoundHeight);
                if (roundA.isDone()) {
                    int yForDone = PosY + doneRoundPosition;
                    begin = (int)((float)roundA.getBeginTime() * this.minuteWidth);
                    loadTime = (int)((float)roundA.getLoadTime() * this.minuteWidth);
                    agencyLeft = (int)((float)(roundA.getBeginTime() + roundA.getLoadTime()) * this.minuteWidth);
                    agencyReturn = (int)((float)roundA.getReturnTime() * this.minuteWidth);
                    unloadTime = (int)((float)roundA.getUnloadTime() * this.minuteWidth);
                    end = (int)((float)(roundA.getReturnTime() + roundA.getUnloadTime()) * this.minuteWidth);
                    g.setColor(Color.gray);
                    g.fillRect(begin, yForDone, loadTime, doneFlagHeight);
                    g.fillRect(agencyReturn, yForDone, unloadTime, doneFlagHeight);
                    g.setColor(Color.gray);
                    g.fillRect(begin + 1, yForDone, end - begin - 2, doneRoundHeight);
                }
            }
        }
        if (day != null && day.getActivity() != null && day.getActivity().size() != 0 && (ConnexionSettings.getInstance().isConsultable("ACTIVITE") || !this.checkRight)) {
            for (ActiviteConducteur elt1 : day.getActivity()) {
                int begin = elt1.getHeureDebut();
                int end = elt1.getHeureFin();
                begin = (int)((float)begin * this.minuteWidth);
                end = (int)((float)end * this.minuteWidth);
                int last = end - begin;
                g.setColor(new Color(Integer.parseInt(elt1.getCouleur())));
                if (last == 0) {
                    g.fillRect(begin, PosY - this.hauteur(elt1.getCleType()), 1, this.hauteur(elt1.getCleType()));
                } else {
                    g.fillRect(begin, PosY - this.hauteur(elt1.getCleType()), last, this.hauteur(elt1.getCleType()));
                }
                if (!elt1.isManualInput()) continue;
                g.setColor(Color.BLACK);
                g.fillRect(begin, PosY - this.hauteur(elt1.getCleType()) - 5, last, 2);
            }
        }
        if (infraction != null && infraction.size() != 0 && (ConnexionSettings.getInstance().isConsultable("INFRACTION") || !this.checkRight)) {
            for (Offence inf : infraction) {
                g.setColor(this.getColorInfraction(inf));
                int pos = (int)((float)inf.getTime() * this.minuteWidth);
                int offenceSize = circleSize + this.getIncrementedSize(inf);
                int y = PosY - pasInfraction - offenceSize - this.getAjout(inf);
                g.fillOval(pos + 1, y, offenceSize, offenceSize);
            }
        }
        if (vehicle != null && vehicle.size() != 0 && (ConnexionSettings.getInstance().isConsultable("VEHICULE") || !this.checkRight)) {
            BufferedImage img = null;
            try {
                img = ImageIO.read(this.getClass().getClassLoader().getResource("images/camion.png"));
                for (VehicleUsed prise : vehicle) {
                    int time2 = ConversionTime.getMinut(prise.getDateDebut());
                    int pos = (int)((float)time2 * this.minuteWidth);
                    int y = PosY - pasVehicule - hauteurVehicule;
                    g.drawImage(img, pos + 1, y, hauteurVehicule, largeurVehicule, null);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (place != null && place.size() != 0) {
            try {
                BufferedImage img = null;
                for (Place tmp : place) {
                    String heure = ConversionTime.dateToString(tmp.getDateTime(), "HH:mm");
                    time = ConversionTime.heureStringToInt(heure, ":");
                    val1 = (int)((float)time * this.minuteWidth);
                    int y = PosY - placePosition;
                    image = "images/entree.png";
                    if (tmp.getType() % 2 == 1) {
                        image = "images/sortie.png";
                        val1 -= placeWidth;
                    }
                    img = ImageIO.read(this.getClass().getClassLoader().getResource(image));
                    g.drawImage(img, val1, y - placePosition, placeWidth, placeHeight, null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (spec != null && spec.size() != 0) {
            try {
                BufferedImage img = null;
                for (SpecificCondition tmp : spec) {
                    String heure = ConversionTime.dateToString(tmp.getSpecificTimestamp(), "HH:mm");
                    time = ConversionTime.heureStringToInt(heure, ":");
                    val1 = (int)((float)time * this.minuteWidth);
                    int y = PosY - specPosition;
                    image = SpecificCondition.getImage(tmp);
                    img = ImageIO.read(this.getClass().getClassLoader().getResource(image));
                    g.drawImage(img, val1, y - specPosition, specWidth, specHeight, null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (extActivity != null && extActivity.size() != 0) {
            int offset = 0;
            for (ExternalDay dayToPrint : extActivity) {
                int x = 0;
                while (x < dayToPrint.getActivities().size()) {
                    ChangementActivite toPrint = dayToPrint.getActivities().get(x);
                    int endAct = 1440;
                    if (x < dayToPrint.getActivities().size() - 1) {
                        endAct = dayToPrint.getActivities().get(x + 1).getHeure();
                    }
                    int begin = toPrint.getHeure();
                    int end = endAct;
                    int last = (end = (int)((float)end * this.minuteWidth)) - (begin = (int)((float)begin * this.minuteWidth));
                    if (last == 0) {
                        last = 1;
                    }
                    try {
                        g.setColor(new Color(TypeActivite.getActivityType(toPrint.getTypeActivite()).getColor()));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        g.setColor(Color.BLACK);
                    }
                    g.fillRect(begin, PosY - extActivityPosition - offset - this.hauteur(toPrint.getTypeActivite()) / 2, last, this.hauteur(toPrint.getTypeActivite()) / 2);
                    ++x;
                }
                offset -= 5;
            }
        }
    }

    public RoundAffectation getRoundOn(String sDate) {
        Date date = ConversionTime.stringToDate(sDate, "yyyy-MM-dd");
        for (RoundAffectation round : this.r) {
            if (!round.getRoundDate().equals(date)) continue;
            return round;
        }
        return null;
    }

    @Override
    public int print(Graphics g, PageFormat tmp, int x) {
        return 0;
    }

    public int getY(int Y, int decalage) {
        int coef = Y / this.dayHeight + 1;
        return coef * this.dayHeight - decalage;
    }

    public Color getColorInfraction(Offence offence) {
        if (offence.getType() == 0) {
            return Color.DARK_GRAY;
        }
        String libInf = offence.getDesignation();
        if (libInf.startsWith(LanguageTranslator.getString("offence.type.dailyRest")) || libInf.startsWith(LanguageTranslator.getString("offence.type.weeklyRest"))) {
            return Color.BLUE;
        }
        if (libInf.startsWith(LanguageTranslator.getString("offence.type.continuousDrive")) || libInf.startsWith(LanguageTranslator.getString("offence.type.continuousDriveTraveller")) || libInf.startsWith(LanguageTranslator.getString("offence.type.dailyDrive")) || libInf.startsWith(LanguageTranslator.getString("offence.type.weeklyDrive"))) {
            return Color.RED;
        }
        if (libInf.startsWith(LanguageTranslator.getString("offence.type.continuousWork")) || libInf.startsWith(LanguageTranslator.getString("offence.type.dailyWork")) || libInf.startsWith(LanguageTranslator.getString("offence.type.weeklyWork"))) {
            return Color.GREEN;
        }
        return Color.DARK_GRAY;
    }

    public int getAjout(Offence offence) {
        String libInf = offence.getDesignation();
        if (offence.getType() == 0) {
            return 0;
        }
        if (libInf.startsWith(LanguageTranslator.getString("offence.type.dailyRest")) || libInf.startsWith(LanguageTranslator.getString("offence.type.weeklyRest"))) {
            return 3;
        }
        if (libInf.startsWith(LanguageTranslator.getString("offence.type.continuousDrive")) || libInf.startsWith(LanguageTranslator.getString("offence.type.continuousDriveTraveller")) || libInf.startsWith(LanguageTranslator.getString("offence.type.dailyDrive")) || libInf.startsWith(LanguageTranslator.getString("offence.type.weeklyDrive"))) {
            return 6;
        }
        if (libInf.startsWith(LanguageTranslator.getString("offence.type.continuousWork")) || libInf.startsWith(LanguageTranslator.getString("offence.type.dailyWork")) || libInf.startsWith(LanguageTranslator.getString("offence.type.weeklyWork"))) {
            return 9;
        }
        return 0;
    }

    public int getIncrementedSize(Offence offence) {
        if (offence.getType() == 0) {
            return 0;
        }
        if (offence.getType() == 1) {
            return 1;
        }
        if (offence.getType() == 2) {
            return 2;
        }
        if (offence.getType() == 3) {
            return 4;
        }
        return 0;
    }

    int hauteur(int activite) {
        if (activite == 1) {
            return 15;
        }
        if (activite == 2) {
            return 10;
        }
        if (activite == 3) {
            return 5;
        }
        if (activite == 4) {
            return 3;
        }
        if (activite == 5) {
            return 5;
        }
        if (activite == 6) {
            return 10;
        }
        if (activite == 7) {
            return 3;
        }
        return 8;
    }

    public void setDriver(Conducteur currentDriver) {
        this.currentDriver = currentDriver;
    }

    public Conducteur getDriver() {
        return this.currentDriver;
    }

    public Vector<TypeActivite> getAuthorizedList() {
        Vector<TypeActivite> list = new Vector<TypeActivite>();
        for (TypeActivite act : TypeActivite.getList()) {
            if (act.getModificationLevel() != 2) continue;
            list.add(act);
        }
        return list;
    }

    public ListPopup getListPopup() {
        if (this.lp == null) {
            this.lp = new ListPopup(this.getAuthorizedList());
        }
        return this.lp;
    }

    public AbsencePopup getAbsencePopup() {
        if (this.ap == null) {
            this.ap = new AbsencePopup();
        }
        return this.ap;
    }

    @Override
    public void callPopup(MouseEvent e) {
        this.isPopupVisible = true;
        this.getListPopup().setActivity(this.focused);
        this.getListPopup().show((Component)e.getSource(), e.getX(), e.getY());
    }

    @Override
    public void submitPopup() {
        TimsLogger.verbose("submit");
        if (!(this.getListPopup().getSelected() instanceof TypeActivite)) {
            this.isPopupVisible = false;
            return;
        }
        TypeActivite selAct = (TypeActivite)this.getListPopup().getSelected();
        if (selAct == null) {
            this.isPopupVisible = false;
            return;
        }
        int selected = selAct.getCle();
        if (this.focused.getCleType() != selected) {
            this.focused.affiche();
            ((TypeActivite)this.getListPopup().getSelected()).affiche();
            if (!(this.getParent() instanceof PnlActiviteC)) {
                TimsLogger.debug("Parent not PnlActiviteC");
            }
            Jour day = PnlActiviteC.getInstance().getDay(this.dayPosition);
            TimsLogger.verbose("#RoundGraphic.submitPopup# on modifie rapidement : ");
            day.affiche();
            TimsLogger.debug("");
            int modifiedTime = this.focused.getHeureFin() - this.getListPopup().getHour();
            if (modifiedTime < 0) {
                System.err.println("#RoundGraphic.submitListPopup# length of activity < 0, cancelling");
                this.isPopupVisible = false;
                return;
            }
            switch (this.focused.getCleType()) {
                case 1: {
                    day.setDriving(day.getDriving() - modifiedTime);
                    break;
                }
                case 2: {
                    day.setWork(day.getWork() - modifiedTime);
                    break;
                }
                case 3: {
                    day.setAvailability(day.getAvailability() - modifiedTime);
                    break;
                }
                case 4: {
                    day.setRest(day.getRest() - modifiedTime);
                    break;
                }
                case 5: {
                    day.setCrew(day.getCrew() - modifiedTime);
                    break;
                }
                case 6: {
                    day.setOther(day.getOther() - modifiedTime);
                    break;
                }
                case 7: {
                    day.setUnk(day.getUnk() - modifiedTime);
                }
            }
            switch (selAct.getCle()) {
                case 1: {
                    day.setDriving(day.getDriving() + modifiedTime);
                    break;
                }
                case 2: {
                    day.setWork(day.getWork() + modifiedTime);
                    break;
                }
                case 3: {
                    day.setAvailability(day.getAvailability() + modifiedTime);
                    break;
                }
                case 4: {
                    day.setRest(day.getRest() + modifiedTime);
                    break;
                }
                case 5: {
                    day.setCrew(day.getCrew() + modifiedTime);
                    break;
                }
                case 6: {
                    day.setOther(day.getOther() + modifiedTime);
                    break;
                }
                case 7: {
                    day.setUnk(day.getUnk() + modifiedTime);
                }
            }
            int actIdx = 0;
            boolean found = false;
            while (actIdx < day.getActivity().size()) {
                if (this.focused.equals(day.getActivity().get(actIdx))) {
                    found = true;
                    break;
                }
                ++actIdx;
            }
            if (!found) {
                TimsLogger.error("Impossible de trouver l'activit\u00e9 en focus");
            }
            ActiviteConducteur toAdd = null;
            if (this.getListPopup().getHour() != this.focused.getHeureDebut()) {
                toAdd = new ActiviteConducteur(this.focused);
                this.focused.setHeureFin(this.getListPopup().getHour());
                toAdd.setHeureDebut(this.getListPopup().getHour());
                toAdd.setCleType(selAct.getCle());
                toAdd.setCouleur(String.valueOf(selAct.getColor()));
                toAdd.setDescription(selAct.getName());
                toAdd.setEtatCarte("generics.none");
                toAdd.setEtatConduite("generics.none");
                toAdd.setLecteur("generics.none");
                toAdd.setTypeSource("generics.graph");
                toAdd.setCleDisque(0);
            } else {
                this.focused.setEtatCarte("generics.none");
                this.focused.setEtatConduite("generics.none");
                this.focused.setLecteur("generics.none");
                this.focused.setTypeSource("generics.graph");
                this.focused.setCleDisque(0);
                this.focused.setCleType(selAct.getCle());
                this.focused.setCouleur(String.valueOf(selAct.getColor()));
                this.focused.setDescription(selAct.getName());
            }
            day.getActivity().remove(actIdx);
            day.getActivity().add(actIdx, this.focused);
            if (toAdd != null) {
                day.getActivity().add(actIdx + 1, toAdd);
            }
            TimsLogger.verbose("#RoundGraphic.submitPopup# apr\u00e8s modification : ");
            day.affiche();
            day.update();
            try {
                TraitementTempsService tts = new TraitementTempsService(this.currentDriver, day.getDate(), day.getDate(), false);
                tts.loadActivite();
                tts.calculService();
                tts.saveListe();
            }
            catch (ServiceException ex) {
                ex.printStackTrace();
            }
            this.repaint();
            this.isPopupVisible = false;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
        Vector<Place> place;
        boolean toolTipAdded = false;
        int mouseX = arg0.getX();
        int mouseY = arg0.getY();
        this.dayPosition = mouseY / this.dayHeight;
        this.setToolTipText(null);
        Jour day = this.d == null || this.d.size() <= this.dayPosition ? null : this.d.get(this.dayPosition);
        Vector<ActiviteConducteur> activite = day == null || this.dayPosition >= 7 ? null : day.getActivity();
        Vector<Offence> offence = this.i == null || this.dayPosition >= 7 ? null : this.i[this.dayPosition];
        Vector<VehicleUsed> vehicle = this.v == null || this.dayPosition >= 7 ? null : this.v[this.dayPosition];
        Vector<Place> vector = place = this.p == null || this.dayPosition >= 7 ? null : this.p[this.dayPosition];
        if (!this.isPopupVisible) {
            this.focused = null;
        }
        if (activite != null) {
            if (activite.size() == 0) {
                this.setToolTipText(null);
            } else {
                for (ActiviteConducteur elt1 : activite) {
                    int begin = (int)((float)elt1.getHeureDebut() * this.minuteWidth);
                    int end = (int)((float)elt1.getHeureFin() * this.minuteWidth);
                    int hauteur = this.hauteur(elt1.getCleType());
                    if (mouseX < begin || mouseX > end || mouseY > this.getY(mouseY, 0) || mouseY < this.getY(mouseY, 0) - hauteur) continue;
                    if (!this.isPopupVisible) {
                        this.focused = elt1;
                    }
                    if (this.focused.getCleType() == 1) {
                        float ratio = (float)this.focused.getDuree() / (float)day.getDriving();
                        int actKm = (int)(ratio * (float)day.getKm());
                        this.setToolTipText(LanguageTranslator.getString("graphic.driving.toolTip", ConversionTime.heureIntToString(elt1.getHeureDebut(), "h"), ConversionTime.heureIntToString(elt1.getHeureFin(), "h"), ConversionTime.heureIntToString(elt1.getDuree(), "h"), elt1.getDescription(), String.valueOf(actKm)));
                    } else {
                        this.setToolTipText(LanguageTranslator.getString("graphic.activity.toolTip", ConversionTime.heureIntToString(elt1.getHeureDebut(), "h"), ConversionTime.heureIntToString(elt1.getHeureFin(), "h"), ConversionTime.heureIntToString(elt1.getDuree(), "h"), elt1.getDescription()));
                    }
                    toolTipAdded = true;
                }
                if (!toolTipAdded) {
                    this.setToolTipText(null);
                }
            }
        }
        if (offence != null && offence.size() != 0 && !toolTipAdded) {
            for (Offence inf : offence) {
                int debut = (int)((float)inf.getTime() * this.minuteWidth);
                int offenceSize = circleSize + this.getIncrementedSize(inf);
                if (mouseX < debut || mouseX > debut + offenceSize || mouseY > this.getY(mouseY, pasInfraction) - this.getAjout(inf) || mouseY < this.getY(mouseY, pasInfraction) - offenceSize - this.getAjout(inf)) continue;
                this.setToolTipText(LanguageTranslator.getString("graphic.offence.toolTip", inf.getDesignation(), ConversionTime.heureIntToString(inf.getThreshold(), "h")));
                toolTipAdded = true;
            }
        }
        if (vehicle != null && vehicle.size() != 0 && !toolTipAdded) {
            for (VehicleUsed prise : vehicle) {
                int time = ConversionTime.getMinut(prise.getDateDebut());
                int debut = (int)((float)time * this.minuteWidth);
                if (mouseX < debut || mouseX > debut + largeurVehicule || this.getY(mouseY, pasVehicule) - hauteurVehicule > mouseY || mouseY > this.getY(mouseY, pasVehicule)) continue;
                this.setToolTipText(LanguageTranslator.getString("graphic.vehicle.toolTip", prise.getImmatriculation(), ConversionTime.dateToString(prise.getDateDebut(), "dd/MM/yyyy HH:mm"), ConversionTime.dateToString(prise.getDateFin(), "dd/MM/yyyy HH:mm"), String.valueOf(prise.getKmDebut()), String.valueOf(prise.getKmFin()), String.valueOf(prise.getKmEffectue())));
                toolTipAdded = true;
            }
        }
        if (place != null) {
            try {
                for (Place tmp : place) {
                    String heure = ConversionTime.dateToString(tmp.getDateTime(), "HH:mm");
                    int time = ConversionTime.heureStringToInt(heure, ":");
                    int pos = (int)((float)time * this.minuteWidth);
                    if (tmp.getType() % 2 == 1) {
                        pos -= placeWidth;
                    }
                    if (pos > mouseX || mouseX > pos + placeWidth || this.getY(mouseY, placePosition) - placeHeight > mouseY || mouseY > this.getY(mouseY, placePosition)) continue;
                    this.setToolTipText(LanguageTranslator.getString("graphic.place.toolTip", Pays.getLibellePays(tmp.getPays()), ConversionTime.dateToString(tmp.getDateTime(), "dd/MM/yyyy HH'h'mm"), LanguageTranslator.getString(Place.EntryType[tmp.getType()]), String.valueOf(tmp.getKm())));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.a != null) {
            for (LienJourConducteur abs : this.a) {
                int endOffset;
                int heightOffset = this.getDayHeight(abs.getDateJour()) + 1;
                int beginOffset = (int)((float)abs.getHeureDebut() * this.minuteWidth);
                if (!this.mouseIn(arg0, beginOffset, heightOffset, endOffset = (int)((float)abs.getPrintEnd() * this.minuteWidth), heightOffset + this.absHeight + 1)) continue;
                try {
                    JourType jt = JourType.getDayType(abs.getCleJourType());
                    this.setToolTipText(String.valueOf(jt.getCode()) + " " + ConversionTime.heureIntToString(jt.getService(), "h"));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private boolean mouseIn(MouseEvent arg0, int x, int y, int x2, int y2) {
        TimsLogger.verbose("#GrapheActivite.mouseIn# " + arg0.getX() + " " + arg0.getY() + " in " + x + " " + x2 + " / " + y + " " + y2 + " ?");
        return x <= arg0.getX() && arg0.getX() <= x2 && y <= arg0.getY() && arg0.getY() <= y2;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int mouseX = e.getX();
        int finalWidth = 0;
        if (e.getButton() == 1) {
            if (e.getClickCount() == 2) {
                finalWidth = this.getWidth() * 2;
            }
        } else if (e.getButton() == 3 && e.getClickCount() == 2) {
            finalWidth = this.getWidth() / 2;
        } else {
            try {
                if (this.focused != null && TypeActivite.getActivityType(this.focused.getCleType()).getModificationLevel() == 2 && !this.isPopupVisible) {
                    this.callPopup(e);
                } else {
                    this.isPopupVisible = false;
                }
            }
            catch (Exception ex) {
                TimsLogger.warn("Type d'activit\u00e9 " + this.focused.getCleType() + " non trouv\u00e9");
                ex.printStackTrace();
            }
        }
        int finalPosition = finalWidth * mouseX / this.getWidth();
        double viewPosition = ((JViewport)this.getParent()).getViewPosition().getX();
        int interval = mouseX - (int)viewPosition;
        int finalViewPosition = finalPosition - interval;
        this.setSize(new Dimension(finalWidth, this.getHeight()));
        this.setPreferredSize(new Dimension(finalWidth, this.getHeight()));
        ((JViewport)this.getParent()).setViewPosition(new Point(finalViewPosition, 0));
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent arg0) {
        int notches = arg0.getWheelRotation();
        int ratio = -notches * 100;
        int finalWidth = this.getWidth() + ratio;
        int mouseX = arg0.getX();
        int finalPosition = finalWidth * mouseX / this.getWidth();
        double viewPosition = ((JViewport)this.getParent()).getViewPosition().getX();
        int interval = mouseX - (int)viewPosition;
        int finalViewPosition = finalPosition - interval;
        this.setSize(new Dimension(finalWidth, this.getHeight()));
        this.setPreferredSize(new Dimension(finalWidth, this.getHeight()));
        ((JViewport)this.getParent()).setViewPosition(new Point(finalViewPosition, 0));
    }

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        if (dataEvent.getTable().equals("T_FRAIS") || dataEvent.getTable().equals("t_societe")) {
            TimsLogger.debug("#GrapheActivite# Reload expenses#");
            if (this.checkRight && ConnexionSettings.getInstance().isConsultable("FRAIS")) {
                this.initExp();
            }
        }
    }

    private int getDayHeight(Date date) {
        int day = ConversionTime.getDaysBetween(this.firstDay, date) + 1;
        TimsLogger.debug("#GrapheActivite.getDayHeight# day " + date + " is on " + day + " => " + day * this.dayHeight);
        return day * this.dayHeight;
    }

    private class JButtonExpenses
    extends JButton {
        int pos;
        ExpensesType et;
        DriverExpenses de;

        public JButtonExpenses(String txt, int pos, ExpensesType et) {
            super(txt);
            this.pos = 0;
            this.et = null;
            this.de = null;
            this.pos = pos;
            this.et = et;
            this.setFocusable(false);
            if (!ConnexionSettings.getInstance().isModifiable("FRAIS") && GrapheActivite.this.checkRight) {
                this.setEnabled(false);
            }
        }

        @Override
        public void paint(Graphics g) {
            TimsLogger.debug("paint" + this.getBounds());
            super.paint(g);
        }

        @Override
        public String getText() {
            return this.de == null ? (this.et == null ? "?" : this.et.getCode()) : "";
        }

        @Override
        public Icon getIcon() {
            if (this.de != null) {
                TimsLogger.debug(String.valueOf(this.de.getExpensesId()) + " " + this.de.getDate() + " " + (this.de.isOutside() ? " true => images/eu.png" : " false => images/fr.png") + " (" + this.getBounds() + ")");
            }
            return this.de == null ? null : (this.de.isOutside() ? Fonctions.getIcon("images/eu.png") : Fonctions.getIcon("images/fr.png"));
        }

        public int getPos() {
            return this.pos;
        }

        public void setPos(int pos) {
            this.pos = pos;
        }

        public ExpensesType getEt() {
            return this.et;
        }

        public void setEt(ExpensesType et) {
            this.et = et;
        }

        public void setDe(DriverExpenses de) {
            this.de = de;
        }

        public DriverExpenses getDe() {
            return this.de;
        }
    }
}

