/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

class ModelTableApercu
extends AbstractTableModel {
    String[] titres = new String[]{LanguageTranslator.getString("generics.begin"), LanguageTranslator.getString("generics.end"), LanguageTranslator.getString("generics.activity"), LanguageTranslator.getString("generics.length"), LanguageTranslator.getString("generics.cardStatus"), LanguageTranslator.getString("generics.drivingStatus"), LanguageTranslator.getString("generics.reader")};
    Vector<String>[] data;

    public ModelTableApercu(Vector list) {
        this.setVector(list);
    }

    public void setVector(Vector list) {
        this.data = new Vector[this.titres.length];
        int i = 0;
        while (i < this.titres.length) {
            this.data[i] = new Vector();
            ++i;
        }
        for (ActiviteConducteur elt : list) {
            this.data[0].add(ConversionTime.heureIntToString(elt.getHeureDebut(), "h"));
            this.data[1].add(ConversionTime.heureIntToString(elt.getHeureFin(), "h"));
            this.data[2].add(elt.getDescription());
            this.data[3].add(ConversionTime.heureIntToString(elt.getDuree(), "h"));
            this.data[4].add(elt.getEtatCarte());
            this.data[5].add(elt.getEtatConduite());
            this.data[6].add(elt.getLecteur());
        }
    }

    @Override
    public int getColumnCount() {
        return this.titres.length;
    }

    public void Supprimer(int row) {
        int i = 0;
        while (i < this.getColumnCount()) {
            this.data[i].remove(row);
            ++i;
        }
        this.fireTableDataChanged();
    }

    @Override
    public Object getValueAt(int parm1, int parm2) {
        return this.data[parm2].get(parm1);
    }

    @Override
    public int getRowCount() {
        return this.data[0].size();
    }

    public void clear() {
        int i = 0;
        while (i < this.titres.length) {
            this.data[i].clear();
            ++i;
        }
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int x, int y) {
        return false;
    }

    @Override
    public String getColumnName(int col) {
        return this.titres[col].toString();
    }
}

