/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.AgencyType;
import fr.pgh.data.bdd.DriverAnalyticCode;
import fr.pgh.data.bdd.EmployeeObligationTypeGroup;
import fr.pgh.data.bdd.EmployeeType;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.TailleAgence;
import fr.pgh.data.bdd.VehicleAffectation;
import fr.pgh.data.bdd.VehicleAnalyticCode;
import fr.pgh.data.bdd.VehicleBody;
import fr.pgh.data.bdd.VehicleModel;
import fr.pgh.data.bdd.VehicleType;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class ParametersTable
extends JDialog
implements Observer {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JList listType = null;
    private JScrollPane jspListe = null;
    private JTextField txtType = null;
    private JButton btnAdd = null;
    private JButton btnDelete = null;
    private JButton btnOk = null;
    private Class dataType = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#ParametersTable.dispose()#");
        super.dispose();
    }

    @Override
    public void update(Observable o, Object arg) {
        TimsLogger.verbose("#" + this.getClass() + ".update# a faire");
        LanguageTranslator.getInstance().addObserver(this);
    }

    public ParametersTable(Frame owner, Class dataType) {
        super(owner);
        TimsLogger.verbose("#ParametersTable()#");
        this.dataType = dataType;
        LanguageTranslator.getInstance().addObserver(this);
        this.initialize();
    }

    public ParametersTable(Dialog owner, Class dataType) {
        super(owner);
        TimsLogger.verbose("#ParametersTable()#");
        this.dataType = dataType;
        LanguageTranslator.getInstance().addObserver(this);
        this.initialize();
    }

    private void initialize() {
        this.setBounds(new Rectangle(0, 0, 300, 300));
        if (this.dataType.equals(AgencyType.class)) {
            this.setTitle(LanguageTranslator.getString("agency.type.title"));
        }
        if (this.dataType.equals(TailleAgence.class)) {
            this.setTitle(LanguageTranslator.getString("agency.size.title"));
        }
        if (this.dataType.equals(EmployeeType.class)) {
            this.setTitle(LanguageTranslator.getString("driver.type.title"));
        }
        if (this.dataType.equals(VehicleType.class)) {
            this.setTitle(LanguageTranslator.getString("generics.type"));
        }
        if (this.dataType.equals(VehicleBody.class)) {
            this.setTitle(LanguageTranslator.getString("generics.body"));
        }
        if (this.dataType.equals(VehicleAffectation.class)) {
            this.setTitle(LanguageTranslator.getString("generics.affectation"));
        }
        if (this.dataType.equals(VehicleModel.class)) {
            this.setTitle(LanguageTranslator.getString("vehicle.model"));
        }
        if (this.dataType.equals(VehicleAnalyticCode.class)) {
            this.setTitle(LanguageTranslator.getString("generics.analyticCode"));
        }
        if (this.dataType.equals(DriverAnalyticCode.class)) {
            this.setTitle(LanguageTranslator.getString("generics.analyticCode"));
        }
        if (this.dataType.equals(EmployeeObligationTypeGroup.class)) {
            this.setTitle(LanguageTranslator.getString("generics.group"));
        }
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gcbList = Fonctions.getGridBagConstraints(0, 0, 1, 4, 0.5, 1.0, 1, -1, new Insets(5, 5, 5, 5));
            GridBagConstraints gcbTxt = Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 1, -1, new Insets(0, 5, 5, 2));
            GridBagConstraints gcbAdd = Fonctions.getGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, -1, -1, new Insets(0, 0, 5, 1));
            GridBagConstraints gcbDel = Fonctions.getGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, -1, -1, new Insets(0, 0, 5, 0));
            GridBagConstraints gcbOk = Fonctions.getGridBagConstraints(3, 1, 1, 1, 0.0, 0.0, -1, -1, new Insets(0, 1, 5, 5));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJspListe(), gcbList);
            this.jContentPane.add((Component)this.getTxt(), gcbTxt);
            if (ConnexionSettings.getInstance().isAjoutable(this.getSheetName())) {
                this.jContentPane.add((Component)this.getBtnAdd(), gcbAdd);
            }
            if (ConnexionSettings.getInstance().isSupprimable(this.getSheetName())) {
                this.jContentPane.add((Component)this.getBtnDelete(), gcbDel);
            }
            this.jContentPane.add((Component)this.getBtnOk(), gcbOk);
        }
        return this.jContentPane;
    }

    private JList getList() {
        if (this.listType == null) {
            this.listType = new JList();
            this.listType.setSize(new Dimension(0, 0));
            Vector<MainElement> toDisplay = null;
            if (this.dataType.equals(AgencyType.class)) {
                toDisplay = AgencyType.getList();
            }
            if (this.dataType.equals(TailleAgence.class)) {
                toDisplay = BddTransport.getInstance().getTailleAgence();
            }
            if (this.dataType.equals(EmployeeType.class)) {
                toDisplay = EmployeeType.getList();
            }
            if (this.dataType.equals(VehicleAffectation.class)) {
                toDisplay = VehicleAffectation.getList();
            }
            if (this.dataType.equals(VehicleBody.class)) {
                toDisplay = VehicleBody.getList();
            }
            if (this.dataType.equals(VehicleType.class)) {
                toDisplay = VehicleType.getList();
            }
            if (this.dataType.equals(VehicleModel.class)) {
                toDisplay = VehicleModel.getList();
            }
            if (this.dataType.equals(VehicleAnalyticCode.class)) {
                toDisplay = VehicleAnalyticCode.getList();
            }
            if (this.dataType.equals(DriverAnalyticCode.class)) {
                toDisplay = DriverAnalyticCode.getList();
            }
            if (this.dataType.equals(EmployeeObligationTypeGroup.class)) {
                toDisplay = EmployeeObligationTypeGroup.getList();
            }
            ComboBoxModel tmp = new ComboBoxModel((Vector<?>)toDisplay);
            this.listType.setModel(tmp);
            this.listType.setAutoscrolls(true);
        }
        return this.listType;
    }

    public void delete() {
        MainElement tmp;
        int index = this.getList().getSelectedIndex();
        String type = (String)this.getList().getSelectedValue();
        if (this.dataType.equals(AgencyType.class)) {
            tmp = new AgencyType();
            ((AgencyType)tmp).loadByName(type);
            ((AgencyType)tmp).compareAndUpdate(((AgencyType)tmp).getId(), ((AgencyType)tmp).getName(), ((AgencyType)tmp).getCode(), true);
        }
        if (this.dataType.equals(TailleAgence.class)) {
            BddTransport.getInstance().delTailleAgence(type);
        }
        if (this.dataType.equals(EmployeeType.class)) {
            tmp = new EmployeeType();
            ((EmployeeType)tmp).loadByName(type);
            ((EmployeeType)tmp).compareAndUpdate(((EmployeeType)tmp).getId(), ((EmployeeType)tmp).getName(), ((EmployeeType)tmp).getCode(), true);
        }
        if (this.dataType.equals(VehicleAffectation.class)) {
            tmp = new VehicleAffectation();
            ((VehicleAffectation)tmp).loadByName(type);
            ((VehicleAffectation)tmp).compareAndUpdate(((VehicleAffectation)tmp).getId(), ((VehicleAffectation)tmp).getName(), ((VehicleAffectation)tmp).getCode(), true);
        }
        if (this.dataType.equals(VehicleType.class)) {
            tmp = new VehicleType();
            ((VehicleType)tmp).loadByName(type);
            ((VehicleType)tmp).compareAndUpdate(((VehicleType)tmp).getId(), ((VehicleType)tmp).getName(), ((VehicleType)tmp).getCode(), true);
        }
        if (this.dataType.equals(VehicleBody.class)) {
            tmp = new VehicleBody();
            ((VehicleBody)tmp).loadByName(type);
            ((VehicleBody)tmp).compareAndUpdate(((VehicleBody)tmp).getId(), ((VehicleBody)tmp).getName(), ((VehicleBody)tmp).getCode(), true);
        }
        if (this.dataType.equals(VehicleModel.class)) {
            tmp = new VehicleModel();
            ((VehicleModel)tmp).loadByName(type);
            ((VehicleModel)tmp).compareAndUpdate(((VehicleModel)tmp).getId(), ((VehicleModel)tmp).getName(), ((VehicleModel)tmp).getCode(), true);
        }
        if (this.dataType.equals(VehicleAnalyticCode.class)) {
            tmp = new VehicleAnalyticCode();
            ((VehicleAnalyticCode)tmp).loadByName(type);
            ((VehicleAnalyticCode)tmp).compareAndUpdate(((VehicleAnalyticCode)tmp).getId(), ((VehicleAnalyticCode)tmp).getName(), ((VehicleAnalyticCode)tmp).getCode(), true);
        }
        if (this.dataType.equals(DriverAnalyticCode.class)) {
            tmp = new DriverAnalyticCode();
            ((DriverAnalyticCode)tmp).loadByName(type);
            ((DriverAnalyticCode)tmp).compareAndUpdate(((DriverAnalyticCode)tmp).getId(), ((DriverAnalyticCode)tmp).getName(), ((DriverAnalyticCode)tmp).getCode(), true);
        }
        if (this.dataType.equals(EmployeeObligationTypeGroup.class)) {
            tmp = new EmployeeObligationTypeGroup();
            ((EmployeeObligationTypeGroup)tmp).loadByName(type);
            ((EmployeeObligationTypeGroup)tmp).compareAndUpdate(((EmployeeObligationTypeGroup)tmp).getId(), ((EmployeeObligationTypeGroup)tmp).getName(), ((EmployeeObligationTypeGroup)tmp).getCode(), true);
        }
        ((ComboBoxModel)this.getList().getModel()).removeElementAt(index);
    }

    private JScrollPane getJspListe() {
        if (this.jspListe == null) {
            this.jspListe = new JScrollPane();
            this.jspListe.setViewportView(this.getList());
        }
        return this.jspListe;
    }

    private JTextField getTxt() {
        if (this.txtType == null) {
            this.txtType = new JTextField();
        }
        return this.txtType;
    }

    private JButton getBtnAdd() {
        if (this.btnAdd == null) {
            this.btnAdd = new JButton();
            this.btnAdd.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_cliq"))));
            this.btnAdd.setPreferredSize(new Dimension(25, 25));
            this.btnAdd.setToolTipText(LanguageTranslator.getString("button.save"));
            this.btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParametersTable.this.save();
                }
            });
        }
        return this.btnAdd;
    }

    private void save() {
        String value = this.getTxt().getText();
        if (value.equals("") || ((ComboBoxModel)this.getList().getModel()).getIndexOf(value) != -1) {
            Toolkit.getDefaultToolkit().beep();
            this.getTxt().requestFocusInWindow();
            this.getTxt().selectAll();
            return;
        }
        if (this.dataType.equals(AgencyType.class)) {
            new AgencyType(0, value, value.substring(0, Math.min(value.length(), 3)), false).insert();
        }
        if (this.dataType.equals(TailleAgence.class)) {
            BddTransport.getInstance().addTailleAgence(value);
        }
        if (this.dataType.equals(EmployeeType.class)) {
            new EmployeeType(0, value, value.substring(0, Math.min(value.length(), 3)), false).insert();
        }
        if (this.dataType.equals(VehicleAffectation.class)) {
            new VehicleAffectation(0, value, value.substring(0, Math.min(value.length(), 3)), false).insert();
        }
        if (this.dataType.equals(VehicleType.class)) {
            new VehicleType(0, value, value.substring(0, Math.min(value.length(), 3)), false).insert();
        }
        if (this.dataType.equals(VehicleBody.class)) {
            new VehicleBody(0, value, value.substring(0, Math.min(value.length(), 3)), false).insert();
        }
        if (this.dataType.equals(VehicleModel.class)) {
            new VehicleModel(0, value, value.substring(0, Math.min(value.length(), 3)), false).insert();
        }
        if (this.dataType.equals(VehicleAnalyticCode.class)) {
            new VehicleAnalyticCode(0, value, value.substring(0, Math.min(value.length(), 3)), false).insert();
        }
        if (this.dataType.equals(DriverAnalyticCode.class)) {
            new DriverAnalyticCode(0, value, value.substring(0, Math.min(value.length(), 3)), false).insert();
        }
        if (this.dataType.equals(EmployeeObligationTypeGroup.class)) {
            new EmployeeObligationTypeGroup(0, value, value.substring(0, Math.min(value.length(), 3)), false).insert();
        }
        ((ComboBoxModel)this.getList().getModel()).addElement(value);
        this.getTxt().setText("");
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton();
            this.btnDelete.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_sup"))));
            this.btnDelete.setPreferredSize(new Dimension(25, 25));
            this.btnDelete.setToolTipText(LanguageTranslator.getString("button.delete"));
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParametersTable.this.delete();
                }
            });
        }
        return this.btnDelete;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_valid"))));
            this.btnOk.setPreferredSize(new Dimension(25, 25));
            this.btnOk.setToolTipText(LanguageTranslator.getString("button.valid"));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParametersTable.this.dispose();
                }
            });
        }
        return this.btnOk;
    }

    private String getSheetName() {
        if (this.dataType.equals(AgencyType.class)) {
            return "TYPE_AGENCE";
        }
        if (this.dataType.equals(TailleAgence.class)) {
            return "TAILLE_AGENCE";
        }
        if (this.dataType.equals(EmployeeType.class)) {
            return "TYPE_PERSONNEL";
        }
        if (this.dataType.equals(VehicleType.class)) {
            return "VEHICLE_TYPE";
        }
        if (this.dataType.equals(VehicleBody.class)) {
            return "BODY";
        }
        if (this.dataType.equals(VehicleAffectation.class)) {
            return "VEHICLE_AFFECTATION";
        }
        if (this.dataType.equals(VehicleModel.class)) {
            return "VEHICLE_MODEL";
        }
        if (this.dataType.equals(VehicleAnalyticCode.class)) {
            return "VEHICLE_ANALYTIC_CODE";
        }
        if (this.dataType.equals(DriverAnalyticCode.class)) {
            return "DRIVER_ANALYTIC_CODE";
        }
        if (this.dataType.equals(EmployeeObligationTypeGroup.class)) {
            return "EMPLOYEE_OBLIGATION_TYPE";
        }
        return "NONE";
    }
}

