/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.component.JFittedComboBox;
import fr.pgh.component.JTextDate;
import fr.pgh.component.JTextHour;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.Accident;
import fr.pgh.data.bdd.AccidentAction;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Garage;
import fr.pgh.data.bdd.Injured;
import fr.pgh.data.bdd.Repairing;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.CheckBoxBorder;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.TMAccidentAction;
import transpo.system.ui.modele.TMInjuried;
import transpo.system.ui.modele.TMRepair;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.DialogAccident;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class PnlAccident
extends ViewPanel
implements Observer,
DataListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlListAcc = null;
    private JScrollPane jspListAcc = null;
    private JList listAcc = null;
    private JPanel pnlBtn = null;
    private JButton btnEnregistrer = null;
    private JButton btnPrint = null;
    private JButton btnAdd = null;
    private JPanel pnlContent = null;
    private JLabel lblNumber = null;
    private JTextField txtNumber = null;
    private JLabel lblInsuranceNumber = null;
    private JTextField txtInsuranceNumber = null;
    private JLabel lblAgency = null;
    private JFittedComboBox cbAgency = null;
    private JLabel lblDriver = null;
    private JFittedComboBox cbDriver = null;
    private JLabel lblVehicle = null;
    private JFittedComboBox cbVehicle = null;
    private JLabel lblDate = null;
    private JTextDate txtDate = null;
    private JLabel lblHour = null;
    private JTextHour txtHour = null;
    private JLabel lblPlace = null;
    private JTextField txtPlace = null;
    private JTextArea txtDescription = null;
    private JLabel lblType = null;
    private JFittedComboBox cbType = null;
    private JLabel lblResponsability = null;
    private JFittedComboBox cbResponsability = null;
    private JCheckBox cbSteal = null;
    private JCheckBox cbTowing = null;
    private JCheckBox cbBigDamages = null;
    private JLabel lblInsuranceType = null;
    private JTextField txtInsuranceType = null;
    private JLabel lblInsuranceCode = null;
    private JTextField txtInsuranceCode = null;
    private JLabel lblConventionType = null;
    private JTextField txtConventionType = null;
    private JCheckBox cbInTraffic = null;
    private JPanel pnlGarage = null;
    private JFittedComboBox cbGarage = null;
    private JCheckBox cbRestrictGarage = null;
    private JLabel lblGarageIn = null;
    private JLabel lblGarageHour = null;
    private JTextHour txtGarageHour = null;
    private JTextField txtGarageIn = null;
    private JLabel lblGarageOut = null;
    private JTextField txtGarageOut = null;
    private JPanel pnlFinancial = null;
    private JLabel lblRcCost = null;
    private JLabel lblRcExcess = null;
    private JLabel lblInsuranceRecourse = null;
    private JLabel lblCompanyRecourse = null;
    private JLabel lblDamageExcess = null;
    private JLabel lblVAT = null;
    private JLabel lblDilapidation = null;
    private JLabel lblSelfInsurance = null;
    private JLabel lblExpertCost = null;
    private JLabel lblFixingCost = null;
    private JLabel lblCompanyFixingCost = null;
    private JLabel lblLocationDebt = null;
    private JLabel lblCompanyLocationDebt = null;
    private JLabel lblGuarding = null;
    private JLabel lblTotalCost = null;
    private JLabel lblTotalInsurance = null;
    private JTextField txtRcCost = null;
    private JTextField txtRcExcess = null;
    private JTextField txtInsuranceRecourse = null;
    private JTextField txtCompanyRecourse = null;
    private JTextField txtDamageExcess = null;
    private JTextField txtVAT = null;
    private JTextField txtDilapidation = null;
    private JTextField txtSelfInsurance = null;
    private JTextField txtExpertCost = null;
    private JTextField txtFixingCost = null;
    private JTextField txtCompanyFixingCost = null;
    private JTextField txtLocationDebt = null;
    private JTextField txtCompanyLocationDebt = null;
    private JTextField txtGuarding = null;
    private JTextField txtTotalCost = null;
    private JTextField txtTotalInsurance = null;
    private JPanel pnlInjuried = null;
    private JCheckBox cbInjury = null;
    private JScrollPane jspList = null;
    private JTable tblInjuried = null;
    private JButton btnInjured = null;
    private JScrollPane jspAction = null;
    private JTable tblAction = null;
    private JButton btnAction = null;
    private JScrollPane jspRepair = null;
    private JTable tblRepair = null;
    private JButton btnRepair = null;
    private Accident current = null;
    private Conducteur driver = null;
    private Vehicule vehicle = null;

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        BddEvent e;
        if (dataEvent instanceof BddEvent && (e = (BddEvent)dataEvent).getTable().equals("ACCIDENT") && e.getAction() == Constants.ACTION_TYPE.CREATE) {
            this.reload();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        TimsLogger.verbose("#" + this.getClass() + ".update# a faire");
    }

    public PnlAccident() {
        this.initialize();
        Transport.bdd.addDataListener(this);
    }

    private void initialize() {
        GridBagConstraints gcbPpl = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 0, 18, new Insets(5, 5, 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJContentPane(), gcbPpl);
    }

    public void set(Conducteur driver, Vehicule vehicle) {
        this.driver = driver;
        if (driver != null) {
            this.getCbDriver().setSelectedItem(String.valueOf(driver.getNom()) + "  " + driver.getPrenom());
        } else {
            this.getCbDriver().setSelectedIndex(0);
        }
        this.vehicle = vehicle;
        if (vehicle != null) {
            this.getCbVehicle().setSelectedItem(vehicle.toString());
        } else {
            this.getCbVehicle().setSelectedIndex(0);
        }
        this.desactivate();
        this.load = false;
    }

    @Override
    public void loadData() {
        if (!this.load) {
            this.reload();
            this.load = true;
        }
    }

    private void reload() {
        this.getListAcc().setModel(new ComboBoxModel(Accident.loadList(this.driver, this.vehicle), true, null));
        this.load(null);
    }

    public void setAccident(Accident accident) {
        this.load(accident);
    }

    private void load(Accident toLoad) {
        this.current = toLoad;
        if (this.current != null) {
            this.getBtnEnregistrer().setEnabled(true);
            this.getBtnPrint().setEnabled(true);
            Vector<Injured> cloneI = new Vector<Injured>();
            for (Injured original : this.current.getInjuried()) {
                cloneI.add((Injured)original.clone());
            }
            Vector<Repairing> cloneR = new Vector<Repairing>();
            for (Repairing original : this.current.getRepairing()) {
                cloneR.add((Repairing)original.clone());
            }
            Vector<AccidentAction> cloneA = new Vector<AccidentAction>();
            for (AccidentAction original : this.current.getAccidentAction()) {
                cloneA.add((AccidentAction)original.clone());
            }
            this.getTblInjuried().setModel(new TMInjuried(cloneI));
            this.getTblAction().setModel(new TMAccidentAction(cloneA));
            this.getTblRepair().setModel(new TMRepair(cloneR));
        } else {
            this.getTblInjuried().setModel(new TMInjuried());
            this.getTblAction().setModel(new TMAccidentAction());
            this.getTblRepair().setModel(new TMRepair());
        }
        this.getTxtNumber().setText(this.current == null ? "" : this.current.getIdentificationNumber());
        this.getTxtInsuranceNumber().setText(this.current == null ? "" : this.current.getInsuranceNumber());
        ((ComboBoxModel)this.getCbAgency().getModel()).setSelected(this.current == null ? 0 : this.current.getAgencyId());
        ((ComboBoxModel)this.getCbDriver().getModel()).setSelected(this.current == null ? 0 : this.current.getDriverId());
        ((ComboBoxModel)this.getCbVehicle().getModel()).setSelected(this.current == null ? 0 : this.current.getVehicleId());
        this.getTxtDate().setText(this.current == null ? "" : ConversionTime.dateToString(this.current.getDay(), "dd/MM/yyyy"));
        this.getTxtHour().setText(this.current == null ? "" : ConversionTime.dateToString(this.current.getDay(), "HH'h'mm"));
        this.getTxtPlace().setText(this.current == null ? "" : this.current.getPlace());
        this.getTxtDescription().setText(this.current == null ? "" : this.current.getDescription());
        this.getCbType().setSelectedIndex(this.current == null ? 0 : this.current.getType());
        this.getCbResponsability().setSelectedIndex(this.current == null ? 0 : this.current.getResponsability());
        this.getCbSteal().setSelected(this.current == null ? false : this.current.getSteal());
        this.getCbTowing().setSelected(this.current == null ? false : this.current.isTowing());
        this.getCbBigDamages().setSelected(this.current == null ? false : this.current.isBigDamages());
        this.getTxtInsuranceCode().setText(this.current == null ? "" : this.current.getInsuranceCode());
        this.getTxtInsuranceType().setText(this.current == null ? "" : this.current.getInsuranceType());
        this.getTxtConventionType().setText(this.current == null ? "" : this.current.getConventionType());
        this.getCbInTraffic().setSelected(this.current == null ? false : this.current.isInTraffic());
        this.getCbInjury().setSelected(this.current == null ? false : this.current.getInjury());
        this.getPnlInjuried().repaint();
        this.getCbGarage().setSelectedItem(((ComboBoxModel)this.getCbGarage().getModel()).getLabel(this.current == null ? 0 : this.current.getGarageId()));
        this.getTxtGarageIn().setText(this.current == null ? "" : ConversionTime.dateToString(this.current.getGarageIn(), "dd/MM/yyyy"));
        this.getTxtGarageHour().setText(this.current == null ? "" : ConversionTime.dateToString(this.current.getGarageIn(), "HH'h'mm"));
        this.getTxtGarageOut().setText(this.current == null ? "" : ConversionTime.dateToString(this.current.getGarageOut(), "dd/MM/yyyy"));
        this.getTxtRcCost().setText(this.current == null ? "" : String.valueOf(this.current.getRcCost()));
        this.getTxtRcExcess().setText(this.current == null ? "" : String.valueOf(this.current.getRcExcess()));
        this.getTxtInsuranceRecourse().setText(this.current == null ? "" : String.valueOf(this.current.getInsuranceRecourse()));
        this.getTxtCompanyRecourse().setText(this.current == null ? "" : String.valueOf(this.current.getCompanyRecourse()));
        this.getTxtDamageExcess().setText(this.current == null ? "" : String.valueOf(this.current.getDamageExcess()));
        this.getTxtVAT().setText(this.current == null ? "" : String.valueOf(this.current.getVAT()));
        this.getTxtDilapidation().setText(this.current == null ? "" : String.valueOf(this.current.getDilapidation()));
        this.getTxtSelfInsurance().setText(this.current == null ? "" : String.valueOf(this.current.getSelfInsurance()));
        this.getTxtExpertCost().setText(this.current == null ? "" : String.valueOf(this.current.getExpertCost()));
        this.getTxtFixingCost().setText(this.current == null ? "" : String.valueOf(this.current.getFixingCost()));
        this.getTxtCompanyFixingCost().setText(this.current == null ? "" : String.valueOf(this.current.getCompanyFixingCost()));
        this.getTxtLocationDebt().setText(this.current == null ? "" : String.valueOf(this.current.getLocationDebt()));
        this.getTxtCompanyLocationDebt().setText(this.current == null ? "" : String.valueOf(this.current.getCompanyLocationDebt()));
        this.getTxtGuarding().setText(this.current == null ? "" : String.valueOf(this.current.getGuarding()));
        this.getTxtTotalCost().setText(this.current == null ? "" : String.valueOf(this.current.getTotalCost()));
        this.getTxtTotalInsurance().setText(this.current == null ? "" : String.valueOf(this.current.getTotalInsurance()));
        if (toLoad != null) {
            this.activate();
        }
    }

    private void activate() {
        this.getCbTowing().setEnabled(true);
        this.getCbInTraffic().setEnabled(true);
        this.getCbBigDamages().setEnabled(true);
        this.getCbSteal().setEnabled(true);
        this.getCbInjury().setEnabled(true);
        this.getCbResponsability().setEnabled(true);
        this.getCbType().setEnabled(true);
        this.getTxtGarageOut().setEnabled(true);
        this.getTxtGarageHour().setEnabled(true);
        this.getTxtGarageIn().setEnabled(true);
        this.getTxtDescription().setEnabled(true);
        this.getTxtHour().setEnabled(true);
        this.getTxtDate().setEnabled(true);
        this.getTxtPlace().setEnabled(true);
        this.getTxtConventionType().setEnabled(true);
        this.getTxtInsuranceCode().setEnabled(true);
        this.getTxtInsuranceType().setEnabled(true);
        this.getTxtInsuranceNumber().setEnabled(true);
        this.getTxtNumber().setEnabled(true);
        this.getCbRestrictGarage().setEnabled(true);
        this.getCbGarage().setEnabled(true);
        this.getCbVehicle().setEnabled(true);
        this.getCbAgency().setEnabled(true);
        this.getCbDriver().setEnabled(true);
        this.getTxtTotalCost().setEnabled(true);
        this.getTxtTotalInsurance().setEnabled(true);
        this.getTxtGuarding().setEnabled(true);
        this.getTxtCompanyLocationDebt().setEnabled(true);
        this.getTxtLocationDebt().setEnabled(true);
        this.getTxtCompanyFixingCost().setEnabled(true);
        this.getTxtFixingCost().setEnabled(true);
        this.getTxtExpertCost().setEnabled(true);
        this.getTxtSelfInsurance().setEnabled(true);
        this.getTxtDilapidation().setEnabled(true);
        this.getTxtVAT().setEnabled(true);
        this.getTxtDamageExcess().setEnabled(true);
        this.getTxtCompanyRecourse().setEnabled(true);
        this.getTxtInsuranceRecourse().setEnabled(true);
        this.getTxtRcCost().setEnabled(true);
        this.getTxtRcExcess().setEnabled(true);
    }

    private void desactivate() {
        this.getCbTowing().setEnabled(false);
        this.getCbInTraffic().setEnabled(false);
        this.getCbBigDamages().setEnabled(false);
        this.getCbSteal().setEnabled(false);
        this.getCbInjury().setEnabled(false);
        this.getCbResponsability().setEnabled(false);
        this.getCbType().setEnabled(false);
        this.getTxtGarageOut().setEnabled(false);
        this.getTxtGarageHour().setEnabled(false);
        this.getTxtGarageIn().setEnabled(false);
        this.getTxtDescription().setEnabled(false);
        this.getTxtHour().setEnabled(false);
        this.getTxtDate().setEnabled(false);
        this.getTxtPlace().setEnabled(false);
        this.getTxtConventionType().setEnabled(false);
        this.getTxtInsuranceCode().setEnabled(false);
        this.getTxtInsuranceType().setEnabled(false);
        this.getTxtInsuranceNumber().setEnabled(false);
        this.getTxtNumber().setEnabled(false);
        this.getCbRestrictGarage().setEnabled(false);
        this.getCbGarage().setEnabled(false);
        this.getCbVehicle().setEnabled(false);
        this.getCbAgency().setEnabled(false);
        this.getCbDriver().setEnabled(false);
        this.getTxtTotalCost().setEnabled(false);
        this.getTxtTotalInsurance().setEnabled(false);
        this.getTxtGuarding().setEnabled(false);
        this.getTxtCompanyLocationDebt().setEnabled(false);
        this.getTxtLocationDebt().setEnabled(false);
        this.getTxtCompanyFixingCost().setEnabled(false);
        this.getTxtFixingCost().setEnabled(false);
        this.getTxtExpertCost().setEnabled(false);
        this.getTxtSelfInsurance().setEnabled(false);
        this.getTxtDilapidation().setEnabled(false);
        this.getTxtVAT().setEnabled(false);
        this.getTxtDamageExcess().setEnabled(false);
        this.getTxtCompanyRecourse().setEnabled(false);
        this.getTxtInsuranceRecourse().setEnabled(false);
        this.getTxtRcCost().setEnabled(false);
        this.getTxtRcExcess().setEnabled(false);
    }

    @Override
    public void close() {
    }

    @Override
    public String getMnemo() {
        return null;
    }

    @Override
    public String getViewName() {
        return LanguageTranslator.getString("accident");
    }

    @Override
    public void refresh() {
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gcbPnlList = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2));
            GridBagConstraints gcbPnlContent = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2));
            GridBagConstraints gcbFinancial = Fonctions.getGridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 2, 5, 5));
            GridBagConstraints gcbPnlBtn = Fonctions.getGridBagConstraints(0, 1, 1, 3, 1.0, 0.0, 1, -1, new Insets(5, 5, 5, 5));
            this.jContentPane = new JPanel();
            if (ConnexionSettings.getInstance().isAjoutable("ACCIDENT_FINANCIAL")) {
                this.jContentPane.setPreferredSize(new Dimension(930, 630));
            } else {
                this.jContentPane.setPreferredSize(new Dimension(780, 630));
            }
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlBtn(), gcbPnlBtn);
            this.jContentPane.add((Component)this.getPnlList(), gcbPnlList);
            this.jContentPane.add((Component)this.getPnlContent(), gcbPnlContent);
            this.jContentPane.add((Component)this.getPnlFinancial(), gcbFinancial);
        }
        return this.jContentPane;
    }

    private JPanel getPnlList() {
        if (this.pnlListAcc == null) {
            GridBagConstraints gcbPnlBtn = Fonctions.getGridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5));
            this.pnlListAcc = new JPanel();
            this.pnlListAcc.setMinimumSize(new Dimension(80, 0));
            this.pnlListAcc.setBorder(new TitledBorder(LanguageTranslator.getString("accident")));
            this.pnlListAcc.setLayout(new GridBagLayout());
            this.pnlListAcc.add((Component)this.getJspListAcc(), gcbPnlBtn);
        }
        return this.pnlListAcc;
    }

    private JScrollPane getJspListAcc() {
        if (this.jspListAcc == null) {
            this.jspListAcc = new JScrollPane();
            this.jspListAcc.setViewportView(this.getListAcc());
        }
        return this.jspListAcc;
    }

    private JList getListAcc() {
        if (this.listAcc == null) {
            this.listAcc = new JList();
            this.listAcc.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && PnlAccident.this.getListAcc().getSelectedIndex() != -1) {
                        ComboBoxModel tmp = (ComboBoxModel)PnlAccident.this.getListAcc().getModel();
                        PnlAccident.this.load((Accident)tmp.getObjectAt(PnlAccident.this.getListAcc().getSelectedIndex()));
                    }
                }
            });
        }
        return this.listAcc;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gcbSave = Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, -1, 13, new Insets(2, 0, 2, 5));
            this.pnlBtn = new JPanel();
            this.pnlBtn.add(this.getBtnAdd());
            this.pnlBtn.add(this.getBtnEnregistrer());
            this.pnlBtn.add(this.getBtnPrint());
        }
        return this.pnlBtn;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setEnabled(false);
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlAccident.this.save();
                }
            });
        }
        return this.btnEnregistrer;
    }

    private JButton getBtnAdd() {
        if (this.btnAdd == null) {
            this.btnAdd = new JButton();
            this.btnAdd.setText(LanguageTranslator.getString("button.add"));
            this.btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAccident tmp = new DialogAccident(MainFrameTransport.getInstance());
                    if (PnlAccident.this.driver != null) {
                        tmp.setSelectedAgency(PnlAccident.this.driver.getCleAgence());
                        tmp.setSelectedDriver(PnlAccident.this.driver.getCleConducteur());
                    } else if (PnlAccident.this.vehicle != null) {
                        tmp.setSelectedAgency(PnlAccident.this.vehicle.getAgencyId());
                        tmp.setSelectedVehicle(PnlAccident.this.vehicle.getCleVehicule());
                    }
                    tmp.setVisible(true);
                }
            });
        }
        return this.btnAdd;
    }

    private JButton getBtnPrint() {
        if (this.btnPrint == null) {
            this.btnPrint = new JButton();
            this.btnPrint.setEnabled(false);
            this.btnPrint.setText(LanguageTranslator.getString("button.print"));
            this.btnPrint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Vector<Agence> agencies = new Vector<Agence>();
                    agencies.add((Agence)((ComboBoxModel)PnlAccident.this.getCbAgency().getModel()).getObjectAt(PnlAccident.this.getCbAgency().getSelectedIndex()));
                    Vector<Conducteur> drivers = new Vector<Conducteur>();
                    drivers.add((Conducteur)((ComboBoxModel)PnlAccident.this.getCbDriver().getModel()).getObjectAt(PnlAccident.this.getCbDriver().getSelectedIndex()));
                    Vector<Vehicule> vehicles = new Vector<Vehicule>();
                    vehicles.add((Vehicule)((ComboBoxModel)PnlAccident.this.getCbVehicle().getModel()).getObjectAt(PnlAccident.this.getCbVehicle().getSelectedIndex()));
                    Fonctions.generateReport(PnlAccident.this.current, agencies, drivers, vehicles);
                }
            });
        }
        return this.btnPrint;
    }

    private JFittedComboBox getCbAgency() {
        if (this.cbAgency == null) {
            this.cbAgency = new JFittedComboBox();
            this.cbAgency.setMaxWidth(170);
            this.cbAgency.setModel(new ComboBoxModel(Agence.getList(), true, LanguageTranslator.getString("generics.select")));
            this.cbAgency.setEnabled(false);
            this.cbAgency.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int cleAgence = ((ComboBoxModel)PnlAccident.this.getCbAgency().getModel()).getSelectedCle();
                    PnlAccident.this.getCbDriver().setModel(new ComboBoxModel(Conducteur.loadList(cleAgence), true, LanguageTranslator.getString("generics.select")));
                    if (System.getProperty("company", "PGH").equals("scan.vehicle.enlarge")) {
                        PnlAccident.this.getCbVehicle().setModel(new ComboBoxModel(Vehicule.loadList(cleAgence), true, LanguageTranslator.getString("generics.select")));
                    }
                    if (PnlAccident.this.getCbRestrictGarage().isSelected()) {
                        PnlAccident.this.getCbGarage().setModel(new ComboBoxModel(Garage.loadList(cleAgence, false), true, LanguageTranslator.getString("generics.select")));
                    }
                }
            });
        }
        return this.cbAgency;
    }

    private JFittedComboBox getCbDriver() {
        if (this.cbDriver == null) {
            this.cbDriver = new JFittedComboBox();
            this.cbDriver.setMaxWidth(170);
            this.cbDriver.setEnabled(false);
            this.cbDriver.setModel(new ComboBoxModel(Conducteur.getList(), true, LanguageTranslator.getString("generics.select")));
        }
        return this.cbDriver;
    }

    private JFittedComboBox getCbVehicle() {
        if (this.cbVehicle == null) {
            this.cbVehicle = new JFittedComboBox();
            this.cbVehicle.setMaxWidth(170);
            this.cbVehicle.setEnabled(false);
            this.cbVehicle.setModel(new ComboBoxModel(Vehicule.loadList(0), true, LanguageTranslator.getString("generics.select")));
        }
        return this.cbVehicle;
    }

    private JFittedComboBox getCbGarage() {
        if (this.cbGarage == null) {
            this.cbGarage = new JFittedComboBox();
            this.cbGarage.setMaxWidth(120);
            this.cbGarage.setEnabled(false);
            this.cbGarage.setModel(new ComboBoxModel(Garage.getList(), true, LanguageTranslator.getString("generics.select")));
        }
        return this.cbGarage;
    }

    private JCheckBox getCbRestrictGarage() {
        if (this.cbRestrictGarage == null) {
            this.cbRestrictGarage = new JCheckBox(LanguageTranslator.getString("accident.restrictGarage"));
            this.cbRestrictGarage.setEnabled(false);
            this.cbRestrictGarage.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ComboBoxModel to = null;
                    if (e.getStateChange() == 1) {
                        int selected = ((ComboBoxModel)PnlAccident.this.getCbAgency().getModel()).getSelectedCle();
                        to = new ComboBoxModel(Garage.loadList(selected, false), true, LanguageTranslator.getString("generics.select"));
                    } else {
                        to = new ComboBoxModel(Garage.loadList(0, false), true, LanguageTranslator.getString("generics.select"));
                    }
                    PnlAccident.this.cbGarage.setModel(to);
                }
            });
        }
        return this.cbRestrictGarage;
    }

    private JTextField getTxtNumber() {
        if (this.txtNumber == null) {
            this.txtNumber = new JTextField();
            this.txtNumber.setEnabled(false);
        }
        return this.txtNumber;
    }

    private JTextField getTxtInsuranceNumber() {
        if (this.txtInsuranceNumber == null) {
            this.txtInsuranceNumber = new JTextField();
            this.txtInsuranceNumber.setEnabled(false);
        }
        return this.txtInsuranceNumber;
    }

    private JTextField getTxtInsuranceType() {
        if (this.txtInsuranceType == null) {
            this.txtInsuranceType = new JTextField();
            this.txtInsuranceType.setEnabled(false);
        }
        return this.txtInsuranceType;
    }

    private JTextField getTxtInsuranceCode() {
        if (this.txtInsuranceCode == null) {
            this.txtInsuranceCode = new JTextField();
            this.txtInsuranceCode.setEnabled(false);
        }
        return this.txtInsuranceCode;
    }

    private JTextField getTxtConventionType() {
        if (this.txtConventionType == null) {
            this.txtConventionType = new JTextField();
            this.txtConventionType.setEnabled(false);
        }
        return this.txtConventionType;
    }

    private JTextField getTxtPlace() {
        if (this.txtPlace == null) {
            this.txtPlace = new JTextField();
            this.txtPlace.setEnabled(false);
        }
        return this.txtPlace;
    }

    private JTextDate getTxtDate() {
        if (this.txtDate == null) {
            this.txtDate = new JTextDate();
            this.txtDate.setPreferredSize(new Dimension(70, 20));
            this.txtDate.setEnabled(false);
            this.txtDate.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(PnlAccident.this.getTxtDate());
                }
            });
        }
        return this.txtDate;
    }

    private JTextHour getTxtHour() {
        if (this.txtHour == null) {
            this.txtHour = new JTextHour();
            this.txtHour.setEnabled(false);
        }
        return this.txtHour;
    }

    private JTextArea getTxtDescription() {
        if (this.txtDescription == null) {
            this.txtDescription = new JTextArea();
            this.txtDescription.setEnabled(false);
        }
        return this.txtDescription;
    }

    private JTextField getTxtGarageIn() {
        if (this.txtGarageIn == null) {
            this.txtGarageIn = new JTextField();
            this.txtGarageIn.setMinimumSize(new Dimension(70, 20));
            this.txtGarageIn.setPreferredSize(new Dimension(70, 20));
            this.txtGarageIn.setMaximumSize(new Dimension(70, 20));
            this.txtGarageIn.setEnabled(false);
            this.txtGarageIn.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(PnlAccident.this.getTxtGarageIn());
                }
            });
        }
        return this.txtGarageIn;
    }

    private JTextHour getTxtGarageHour() {
        if (this.txtGarageHour == null) {
            this.txtGarageHour = new JTextHour();
            this.txtGarageHour.setEnabled(false);
        }
        return this.txtGarageHour;
    }

    private JTextField getTxtGarageOut() {
        if (this.txtGarageOut == null) {
            this.txtGarageOut = new JTextField();
            this.txtGarageOut.setMinimumSize(new Dimension(70, 20));
            this.txtGarageOut.setPreferredSize(new Dimension(70, 20));
            this.txtGarageOut.setMaximumSize(new Dimension(70, 20));
            this.txtGarageOut.setEnabled(false);
            this.txtGarageOut.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(PnlAccident.this.getTxtGarageOut());
                }
            });
        }
        return this.txtGarageOut;
    }

    private JFittedComboBox getCbType() {
        if (this.cbType == null) {
            this.cbType = new JFittedComboBox(Accident.TYPE_WORDING);
            this.cbType.setMaxWidth(150);
            this.cbType.setEnabled(false);
        }
        return this.cbType;
    }

    private JFittedComboBox getCbResponsability() {
        if (this.cbResponsability == null) {
            this.cbResponsability = new JFittedComboBox(Accident.RESPONSABILITY_WORDING);
            this.cbResponsability.setMaxWidth(150);
            this.cbResponsability.setEnabled(false);
        }
        return this.cbResponsability;
    }

    private JCheckBox getCbInjury() {
        if (this.cbInjury == null) {
            this.cbInjury = new JCheckBox(LanguageTranslator.getString("generics.injuried"));
            this.cbInjury.setEnabled(false);
            this.cbInjury.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (PnlAccident.this.getCbInjury().isSelected()) {
                        PnlAccident.this.getBtnInjured().setEnabled(true);
                    }
                }
            });
        }
        return this.cbInjury;
    }

    private JCheckBox getCbSteal() {
        if (this.cbSteal == null) {
            this.cbSteal = new JCheckBox(LanguageTranslator.getString("accident.steal"));
            this.cbSteal.setEnabled(false);
        }
        return this.cbSteal;
    }

    private JCheckBox getCbBigDamages() {
        if (this.cbBigDamages == null) {
            this.cbBigDamages = new JCheckBox(LanguageTranslator.getString("accident.bigDamages"));
            this.cbBigDamages.setEnabled(false);
        }
        return this.cbBigDamages;
    }

    private JCheckBox getCbInTraffic() {
        if (this.cbInTraffic == null) {
            this.cbInTraffic = new JCheckBox(LanguageTranslator.getString("accident.inTraffic"));
            this.cbInTraffic.setEnabled(false);
        }
        return this.cbInTraffic;
    }

    private JCheckBox getCbTowing() {
        if (this.cbTowing == null) {
            this.cbTowing = new JCheckBox(LanguageTranslator.getString("accident.towing"));
            this.cbTowing.setEnabled(false);
        }
        return this.cbTowing;
    }

    private JScrollPane getJspList() {
        if (this.jspList == null) {
            this.jspList = new JScrollPane();
            this.jspList.setViewportView(this.getTblInjuried());
        }
        return this.jspList;
    }

    private JTable getTblInjuried() {
        if (this.tblInjuried == null) {
            this.tblInjuried = new JTable();
        }
        return this.tblInjuried;
    }

    private JButton getBtnInjured() {
        if (this.btnInjured == null) {
            this.btnInjured = new JButton();
            this.btnInjured.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_cliq"))));
            this.btnInjured.setMinimumSize(new Dimension(20, 20));
            this.btnInjured.setEnabled(false);
            this.btnInjured.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((TMInjuried)PnlAccident.this.getTblInjuried().getModel()).addLine();
                }
            });
        }
        return this.btnInjured;
    }

    private JPanel getPnlContent() {
        if (this.pnlContent == null) {
            this.lblAgency = new JLabel(LanguageTranslator.getString("generics.agency"));
            this.lblDriver = new JLabel(LanguageTranslator.getString("generics.driver"));
            this.lblVehicle = new JLabel(LanguageTranslator.getString("generics.vehicle"));
            this.lblResponsability = new JLabel(LanguageTranslator.getString("generics.responsability"));
            this.lblDate = new JLabel(LanguageTranslator.getString("generics.date"));
            this.lblHour = new JLabel(LanguageTranslator.getString("generics.hour"));
            this.lblNumber = new JLabel(LanguageTranslator.getString("accident.identification"));
            this.lblInsuranceNumber = new JLabel(LanguageTranslator.getString("accident.insuranceNumber"));
            this.lblPlace = new JLabel(LanguageTranslator.getString("generics.place"));
            this.lblType = new JLabel(LanguageTranslator.getString("accident.type"));
            this.lblInsuranceType = new JLabel(LanguageTranslator.getString("accident.insuranceType"));
            this.lblInsuranceCode = new JLabel(LanguageTranslator.getString("accident.insuranceCode"));
            this.lblConventionType = new JLabel(LanguageTranslator.getString("accident.conventionType"));
            GridBagConstraints gcbLblAgency = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbCbAgency = Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblDate = Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbTxtDate = Fonctions.getGridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblDriver = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbCbDriver = Fonctions.getGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblHour = Fonctions.getGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbTxtHour = Fonctions.getGridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblVehicle = Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbCbVehicle = Fonctions.getGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblNumber = Fonctions.getGridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbTxtNumber = Fonctions.getGridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblResp = Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbCbResp = Fonctions.getGridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblINumber = Fonctions.getGridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbTxtINumber = Fonctions.getGridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblType = Fonctions.getGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbCbType = Fonctions.getGridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblPlace = Fonctions.getGridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbTxtPlace = Fonctions.getGridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblInsType = Fonctions.getGridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbTxtInsType = Fonctions.getGridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblInsCode = Fonctions.getGridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbTxtInsCode = Fonctions.getGridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblConvType = Fonctions.getGridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbTxtConvType = Fonctions.getGridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbCbInTraffic = Fonctions.getGridBagConstraints(2, 6, 1, 2, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbPnlCb = Fonctions.getGridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 2, -1, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbPnlAction = Fonctions.getGridBagConstraints(1, 7, 1, 3, 0.0, 0.0, 1, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbPnlDesc = Fonctions.getGridBagConstraints(0, 8, 1, 4, 1.0, 1.0, 1, -1, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbPnlGarage = Fonctions.getGridBagConstraints(0, 9, 1, 4, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbPnlInjury = Fonctions.getGridBagConstraints(0, 10, 1, 4, 1.0, 1.0, 1, -1, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbCbSteal = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 2, -1, new Insets(2, 0, 0, 5));
            GridBagConstraints gcbCbBigDamages = Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 2, -1, new Insets(2, 0, 0, 5));
            GridBagConstraints gcbCbTowing = Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 2, -1, new Insets(2, 0, 0, 5));
            JPanel pnlCb = new JPanel(new GridBagLayout());
            pnlCb.add((Component)this.getCbSteal(), gcbCbSteal);
            pnlCb.add((Component)this.getCbBigDamages(), gcbCbBigDamages);
            pnlCb.add((Component)this.getCbTowing(), gcbCbTowing);
            JPanel pnlDate = new JPanel(new GridBagLayout());
            pnlDate.add((Component)this.lblDate, gcbLblDate);
            pnlDate.add((Component)this.getTxtDate(), gcbTxtDate);
            pnlDate.add((Component)this.lblHour, gcbLblHour);
            pnlDate.add((Component)this.getTxtHour(), gcbTxtHour);
            GridBagConstraints gcbJspAction = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 0, 0, 1));
            GridBagConstraints gcbBtnAction = Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, -1, 15, new Insets(0, 0, 2, 1));
            JPanel pnlAction = new JPanel(new GridBagLayout());
            pnlAction.add((Component)this.getJspAction(), gcbJspAction);
            pnlAction.add((Component)this.getBtnAction(), gcbBtnAction);
            JPanel pnlDescription = new JPanel(new GridBagLayout());
            JScrollPane jsp = new JScrollPane();
            jsp.setViewportView(this.getTxtDescription());
            jsp.setVerticalScrollBarPolicy(22);
            GridBagConstraints gcbTxtDescription = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(0, 5, 5, 5));
            pnlDescription.setBorder(new TitledBorder(LanguageTranslator.getString("accident.description")));
            pnlDescription.add((Component)jsp, gcbTxtDescription);
            this.pnlContent = new JPanel();
            this.pnlContent.setLayout(new GridBagLayout());
            this.pnlContent.add((Component)this.lblDate, gcbLblDate);
            this.pnlContent.add((Component)this.getTxtDate(), gcbTxtDate);
            this.pnlContent.add((Component)this.lblHour, gcbLblHour);
            this.pnlContent.add((Component)this.getTxtHour(), gcbTxtHour);
            this.pnlContent.add((Component)this.lblAgency, gcbLblAgency);
            this.pnlContent.add((Component)this.getCbAgency(), gcbCbAgency);
            this.pnlContent.add((Component)this.lblDriver, gcbLblDriver);
            this.pnlContent.add((Component)this.getCbDriver(), gcbCbDriver);
            this.pnlContent.add((Component)this.lblVehicle, gcbLblVehicle);
            this.pnlContent.add((Component)this.getCbVehicle(), gcbCbVehicle);
            this.pnlContent.add((Component)this.lblNumber, gcbLblNumber);
            this.pnlContent.add((Component)this.getTxtNumber(), gcbTxtNumber);
            this.pnlContent.add((Component)this.lblInsuranceNumber, gcbLblINumber);
            this.pnlContent.add((Component)this.getTxtInsuranceNumber(), gcbTxtINumber);
            this.pnlContent.add((Component)this.lblPlace, gcbLblPlace);
            this.pnlContent.add((Component)this.getTxtPlace(), gcbTxtPlace);
            this.pnlContent.add((Component)this.lblType, gcbLblType);
            this.pnlContent.add((Component)this.getCbType(), gcbCbType);
            this.pnlContent.add((Component)this.lblResponsability, gcbLblResp);
            this.pnlContent.add((Component)this.getCbResponsability(), gcbCbResp);
            this.pnlContent.add((Component)pnlCb, gcbPnlCb);
            this.pnlContent.add((Component)pnlAction, gcbPnlAction);
            this.pnlContent.add((Component)pnlDescription, gcbPnlDesc);
            this.pnlContent.add((Component)this.getPnlGarage(), gcbPnlGarage);
            this.pnlContent.add((Component)this.getPnlInjuried(), gcbPnlInjury);
            this.pnlContent.add((Component)this.lblInsuranceType, gcbLblInsType);
            this.pnlContent.add((Component)this.getTxtInsuranceType(), gcbTxtInsType);
            this.pnlContent.add((Component)this.lblInsuranceCode, gcbLblInsCode);
            this.pnlContent.add((Component)this.getTxtInsuranceCode(), gcbTxtInsCode);
            this.pnlContent.add((Component)this.lblConventionType, gcbLblConvType);
            this.pnlContent.add((Component)this.getTxtConventionType(), gcbTxtConvType);
            this.pnlContent.add((Component)this.getCbInTraffic(), gcbCbInTraffic);
        }
        return this.pnlContent;
    }

    private JPanel getPnlInjuried() {
        if (this.pnlInjuried == null) {
            this.pnlInjuried = new JPanel(new GridBagLayout());
            CheckBoxBorder border = new CheckBoxBorder(this.getCbInjury(), this.pnlInjuried, BorderFactory.createLineBorder(SystemColor.activeCaption, 1));
            GridBagConstraints gcbJspTbl = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(1, 5, 0, 1));
            GridBagConstraints gcbBtn = Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 15, new Insets(0, 0, 2, 1));
            this.pnlInjuried.setBorder(border);
            this.pnlInjuried.add((Component)this.getJspList(), gcbJspTbl);
            this.pnlInjuried.add((Component)this.getBtnInjured(), gcbBtn);
        }
        return this.pnlInjuried;
    }

    private JPanel getPnlGarage() {
        if (this.pnlGarage == null) {
            GridBagConstraints gcbCbGarage = Fonctions.getGridBagConstraints(0, 0, 1, 4, 0.0, 0.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbCbRestrict = Fonctions.getGridBagConstraints(0, 1, 1, 4, 0.0, 0.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblGarageIn = Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtGarageIn = Fonctions.getGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblGarageHour = Fonctions.getGridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtGarageHour = Fonctions.getGridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbPnlRepair = Fonctions.getGridBagConstraints(4, 0, 3, 1, 1.0, 1.0, 1, -1, new Insets(5, 0, 0, 1));
            GridBagConstraints gcbBtnRepair = Fonctions.getGridBagConstraints(5, 0, 3, 1, 0.0, 0.0, 0, 15, new Insets(0, 0, 2, 1));
            this.lblGarageIn = new JLabel(LanguageTranslator.getString("accident.garageIn"));
            this.lblGarageHour = new JLabel(LanguageTranslator.getString("generics.hour"));
            this.lblGarageOut = new JLabel(LanguageTranslator.getString("accident.garageOut"));
            this.pnlGarage = new JPanel(new GridBagLayout());
            this.pnlGarage.setMaximumSize(new Dimension(0, 120));
            this.pnlGarage.setMinimumSize(new Dimension(0, 120));
            this.pnlGarage.setPreferredSize(new Dimension(0, 120));
            this.pnlGarage.setSize(new Dimension(0, 120));
            this.pnlGarage.setBorder(new TitledBorder(LanguageTranslator.getString("generics.garage")));
            this.pnlGarage.add((Component)this.getCbGarage(), gcbCbGarage);
            this.pnlGarage.add((Component)this.getCbRestrictGarage(), gcbCbRestrict);
            this.pnlGarage.add((Component)this.lblGarageIn, gcbLblGarageIn);
            this.pnlGarage.add((Component)this.getTxtGarageIn(), gcbTxtGarageIn);
            this.pnlGarage.add((Component)this.lblGarageHour, gcbLblGarageHour);
            this.pnlGarage.add((Component)this.getTxtGarageHour(), gcbTxtGarageHour);
            this.pnlGarage.add((Component)this.getJspRepair(), gcbPnlRepair);
            this.pnlGarage.add((Component)this.getBtnRepair(), gcbBtnRepair);
        }
        return this.pnlGarage;
    }

    private JScrollPane getJspRepair() {
        if (this.jspRepair == null) {
            this.jspRepair = new JScrollPane();
            this.jspRepair.setViewportView(this.getTblRepair());
        }
        return this.jspRepair;
    }

    private JTable getTblRepair() {
        if (this.tblRepair == null) {
            this.tblRepair = new JTable();
        }
        return this.tblRepair;
    }

    private JButton getBtnRepair() {
        if (this.btnRepair == null) {
            this.btnRepair = new JButton();
            this.btnRepair.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_cliq"))));
            this.btnRepair.setEnabled(false);
            this.btnRepair.setToolTipText(LanguageTranslator.getString("button.add"));
            this.btnRepair.setMinimumSize(new Dimension(20, 20));
            this.btnRepair.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((TMRepair)PnlAccident.this.getTblRepair().getModel()).addLine();
                }
            });
        }
        return this.btnRepair;
    }

    private JScrollPane getJspAction() {
        if (this.jspAction == null) {
            this.jspAction = new JScrollPane();
            this.jspAction.setViewportView(this.getTblAction());
        }
        return this.jspAction;
    }

    private JTable getTblAction() {
        if (this.tblAction == null) {
            this.tblAction = new JTable();
        }
        return this.tblAction;
    }

    private JButton getBtnAction() {
        if (this.btnAction == null) {
            this.btnAction = new JButton();
            this.btnAction.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_cliq"))));
            this.btnAction.setMinimumSize(new Dimension(20, 20));
            this.btnAction.setEnabled(false);
            this.btnAction.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((TMAccidentAction)PnlAccident.this.getTblAction().getModel()).addLine();
                }
            });
        }
        return this.btnAction;
    }

    private void save() {
        Fonctions.commit(this.getTblInjuried());
        Fonctions.commit(this.getTblRepair());
        Fonctions.commit(this.getTblAction());
        if (!this.check()) {
            return;
        }
        Transport.bdd.startTransaction();
        String date = String.valueOf(this.getTxtDate().getText()) + " " + this.getTxtHour().getText();
        String garageIn = String.valueOf(this.getTxtGarageIn().getText()) + " " + this.getTxtGarageHour().getText();
        boolean saved = this.current.compareAndUpdate(this.getTxtNumber().getText(), this.getTxtInsuranceNumber().getText(), ((ComboBoxModel)this.getCbAgency().getModel()).getSelectedCle(), ((ComboBoxModel)this.getCbDriver().getModel()).getSelectedCle(), ((ComboBoxModel)this.getCbVehicle().getModel()).getSelectedCle(), ConversionTime.stringToDate(date, "dd/MM/yyyy HH'h'mm"), this.getTxtPlace().getText(), this.getCbType().getSelectedIndex(), this.getCbInjury().isSelected(), this.getCbSteal().isSelected(), this.getTxtDescription().getText(), this.getCbBigDamages().isSelected(), this.getCbResponsability().getSelectedIndex(), ((ComboBoxModel)this.getCbGarage().getModel()).getSelectedCle(), garageIn.length() == 16 ? ConversionTime.stringToDate(garageIn, "dd/MM/yyyy HH'h'mm") : null, ConversionTime.stringToDate(this.getTxtGarageOut().getText(), "dd/MM/yyyy"), this.getCbTowing().isSelected(), this.getTxtRcCost().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtRcCost().getText()).floatValue(), this.getTxtRcExcess().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtRcExcess().getText()).floatValue(), this.getTxtInsuranceRecourse().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtInsuranceRecourse().getText()).floatValue(), this.getTxtCompanyRecourse().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtCompanyRecourse().getText()).floatValue(), this.getTxtDamageExcess().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtDamageExcess().getText()).floatValue(), this.getTxtVAT().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtVAT().getText()).floatValue(), this.getTxtDilapidation().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtDilapidation().getText()).floatValue(), this.getTxtSelfInsurance().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtSelfInsurance().getText()).floatValue(), this.getTxtExpertCost().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtExpertCost().getText()).floatValue(), this.getTxtFixingCost().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtFixingCost().getText()).floatValue(), this.getTxtCompanyFixingCost().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtCompanyFixingCost().getText()).floatValue(), this.getTxtLocationDebt().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtLocationDebt().getText()).floatValue(), this.getTxtCompanyLocationDebt().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtCompanyLocationDebt().getText()).floatValue(), this.getTxtGuarding().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtGuarding().getText()).floatValue(), this.getTxtTotalCost().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtTotalCost().getText()).floatValue(), this.getTxtTotalInsurance().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtTotalInsurance().getText()).floatValue(), true, this.getCbInTraffic().isSelected(), this.getTxtInsuranceType().getText(), this.getTxtConventionType().getText(), this.getTxtInsuranceType().getText(), null);
        if (this.getCbInjury().isSelected() && saved) {
            saved = this.saveInjuredWithTracking();
        }
        if (saved) {
            saved = this.saveActionWithTracking();
        }
        if (saved) {
            saved = this.saveRepairWithTracking();
        }
        if (saved) {
            Transport.bdd.commit();
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveSucceed"), LanguageTranslator.getString("message.done"), 1);
        } else {
            Transport.bdd.rollback();
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveError"), LanguageTranslator.getString("message.error"), 1);
        }
    }

    private boolean check() {
        boolean toReturn = true;
        if (this.getTxtNumber().getText().length() > 13) {
            this.getTxtNumber().setBackground(new Color(255, 192, 203));
            this.getTxtNumber().setToolTipText(LanguageTranslator.getString("generics.maxAuthorised", "13"));
            toReturn = false;
        } else {
            this.getTxtNumber().setBackground(Color.white);
        }
        if (this.getTxtPlace().getText().equals("")) {
            this.getTxtPlace().setBackground(new Color(255, 192, 203));
            this.getTxtPlace().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtPlace().setBackground(Color.white);
        }
        if (this.getTxtDescription().getText().equals("")) {
            this.getTxtDescription().setBackground(new Color(255, 192, 203));
            this.getTxtDescription().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtDescription().setBackground(Color.white);
        }
        if (this.getTxtDate().getText().equals("")) {
            this.getTxtDate().setBackground(new Color(255, 192, 203));
            this.getTxtDate().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtDate().setBackground(Color.white);
        }
        if (!this.getTxtHour().isValidHour()) {
            this.getTxtHour().setBackground(new Color(255, 192, 203));
            this.getTxtHour().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtHour().setBackground(Color.white);
        }
        if (((ComboBoxModel)this.getCbAgency().getModel()).getSelectedCle() == 0) {
            this.getCbAgency().setBackground(new Color(255, 192, 203));
            this.getCbAgency().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getCbAgency().setBackground(UIManager.getColor("ComboBox.background"));
        }
        if (((ComboBoxModel)this.getCbDriver().getModel()).getSelectedCle() == 0) {
            this.getCbDriver().setBackground(new Color(255, 192, 203));
            this.getCbDriver().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getCbDriver().setBackground(UIManager.getColor("ComboBox.background"));
        }
        if (((ComboBoxModel)this.getCbVehicle().getModel()).getSelectedCle() == 0) {
            this.getCbVehicle().setBackground(new Color(255, 192, 203));
            this.getCbVehicle().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getCbVehicle().setBackground(UIManager.getColor("ComboBox.background"));
        }
        return toReturn;
    }

    private boolean saveInjuredWithTracking() {
        Injured tmp;
        boolean toReturn = true;
        Vector<Injured> injured = ((TMInjuried)this.getTblInjuried().getModel()).getData();
        int x = 0;
        int delx = 0;
        while (x < this.current.getInjuried().size()) {
            Injured injured2 = tmp = x - delx < injured.size() ? injured.get(x - delx) : null;
            if (tmp == null || tmp.getId() != this.current.getInjuried().get(x).getId()) {
                this.current.getInjuried().get(x).delete();
                ++delx;
            } else if (!this.current.getInjuried().get(x).compareAndUpdate(this.current.getId(), tmp.isEmployee(), tmp.getFirstName(), tmp.getLastName(), tmp.getAddress(), tmp.getCity(), tmp.getPostalCode(), tmp.getPhone())) {
                TimsLogger.debug("#DialogAccident.save()# unable to save Injured");
                toReturn = false;
                break;
            }
            ++x;
        }
        while (x - delx < injured.size()) {
            tmp = injured.get(x - delx);
            if (!tmp.compareAndUpdate(this.current.getId(), tmp.isEmployee(), tmp.getFirstName(), tmp.getLastName(), tmp.getAddress(), tmp.getCity(), tmp.getPostalCode(), tmp.getPhone())) {
                TimsLogger.debug("#DialogAccident.save()# unable to save Injured");
                toReturn = false;
                break;
            }
            ++x;
        }
        return toReturn;
    }

    public boolean saveActionWithTracking() {
        AccidentAction tmp;
        boolean toReturn = true;
        Vector<AccidentAction> actions = ((TMAccidentAction)this.getTblAction().getModel()).getData();
        int x = 0;
        int delx = 0;
        Vector<AccidentAction> ac = this.current.getAccidentAction();
        while (x < ac.size()) {
            AccidentAction accidentAction = tmp = x - delx < actions.size() ? actions.get(x - delx) : null;
            if (tmp == null || tmp.getId() != this.current.getAccidentAction().get(x).getId()) {
                this.current.getAccidentAction().get(x).delete();
                ++delx;
            } else if (!this.current.getAccidentAction().get(x).compareAndUpdate(tmp.getUserId(), tmp.getInsertionDate(), this.current.getId(), tmp.getPurpose())) {
                TimsLogger.debug("#DialogAccident.save()# unable to save AccidentAction");
                toReturn = false;
                break;
            }
            ++x;
        }
        while (x - delx < actions.size()) {
            tmp = actions.get(x - delx);
            if (!tmp.compareAndUpdate(tmp.getUserId(), tmp.getInsertionDate(), this.current.getId(), tmp.getPurpose())) {
                TimsLogger.debug("#DialogAccident.save()# unable to save Injured");
                toReturn = false;
                break;
            }
            ++x;
        }
        return toReturn;
    }

    public boolean saveRepairWithTracking() {
        Repairing tmp;
        String garageIn = String.valueOf(this.getTxtGarageIn().getText()) + " " + this.getTxtGarageHour().getText();
        Date entry = garageIn.length() == 16 ? ConversionTime.stringToDate(garageIn, "dd/MM/yyyy HH'h'mm") : null;
        boolean toReturn = true;
        Vector<Repairing> repairs = ((TMRepair)this.getTblRepair().getModel()).getData();
        int x = 0;
        int delx = 0;
        int garageId = ((ComboBoxModel)this.getCbGarage().getModel()).getSelectedCle();
        while (x < this.current.getRepairing().size()) {
            Repairing repairing = tmp = x - delx < repairs.size() ? repairs.get(x - delx) : null;
            if (tmp == null || tmp.getId() != this.current.getRepairing().get(x).getId()) {
                this.current.getRepairing().get(x).delete();
                ++delx;
            } else if (!this.current.getRepairing().get(x).compareAndUpdate(tmp.getDay() == null ? entry : tmp.getDay(), this.current.getId(), garageId, tmp.getPurpose(), tmp.getTotalCost(), 0.0f)) {
                TimsLogger.debug("#DialogAccident.save()# unable to save repair");
                toReturn = false;
                break;
            }
            ++x;
        }
        while (x - delx < repairs.size()) {
            if (!tmp.compareAndUpdate((tmp = repairs.get(x - delx)).getDay() == null ? entry : tmp.getDay(), this.current.getId(), garageId, tmp.getPurpose(), tmp.getTotalCost(), 0.0f)) {
                TimsLogger.debug("#DialogAccident.save()# unable to save repair");
                toReturn = false;
                break;
            }
            ++x;
        }
        return toReturn;
    }

    private JPanel getPnlFinancial() {
        if (this.pnlFinancial == null) {
            GridBagConstraints gcblblRcCost = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtRcCost = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblRcExcess = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtRcExcess = Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblInsuranceRecourse = Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtInsuranceRecourse = Fonctions.getGridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblCompanyRecourse = Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtCompanyRecourse = Fonctions.getGridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblDamageExcess = Fonctions.getGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtDamageExcess = Fonctions.getGridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblVAT = Fonctions.getGridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtVAT = Fonctions.getGridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblDilapidation = Fonctions.getGridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtDilapidation = Fonctions.getGridBagConstraints(1, 6, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblSelfInsurance = Fonctions.getGridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtSelfInsurance = Fonctions.getGridBagConstraints(1, 7, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblExpertCost = Fonctions.getGridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtExpertCost = Fonctions.getGridBagConstraints(1, 8, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblFixingCost = Fonctions.getGridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtFixingCost = Fonctions.getGridBagConstraints(1, 9, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblCompanyFixingCost = Fonctions.getGridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtCompanyFixingCost = Fonctions.getGridBagConstraints(1, 10, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblLocationDebt = Fonctions.getGridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtLocationDebt = Fonctions.getGridBagConstraints(1, 11, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblCompanyLocationDebt = Fonctions.getGridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtCompanyLocationDebt = Fonctions.getGridBagConstraints(1, 12, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblGuarding = Fonctions.getGridBagConstraints(0, 13, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtGuarding = Fonctions.getGridBagConstraints(1, 13, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblTotalCost = Fonctions.getGridBagConstraints(0, 14, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtTotalCost = Fonctions.getGridBagConstraints(1, 14, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblTotalInsurance = Fonctions.getGridBagConstraints(0, 15, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtTotalInsurance = Fonctions.getGridBagConstraints(1, 15, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            this.lblRcCost = new JLabel(LanguageTranslator.getString("accident.rcCost"));
            this.lblRcExcess = new JLabel(LanguageTranslator.getString("accident.rcExcess"));
            this.lblInsuranceRecourse = new JLabel(LanguageTranslator.getString("accident.insuranceRecourse"));
            this.lblCompanyRecourse = new JLabel(LanguageTranslator.getString("accident.companyRecourse"));
            this.lblDamageExcess = new JLabel(LanguageTranslator.getString("accident.damageExcess"));
            this.lblVAT = new JLabel(LanguageTranslator.getString("accident.VAT"));
            this.lblDilapidation = new JLabel(LanguageTranslator.getString("accident.dilapidation"));
            this.lblSelfInsurance = new JLabel(LanguageTranslator.getString("accident.selfInsurance"));
            this.lblExpertCost = new JLabel(LanguageTranslator.getString("accident.expertCost"));
            this.lblFixingCost = new JLabel(LanguageTranslator.getString("accident.fixingCost"));
            this.lblCompanyFixingCost = new JLabel(LanguageTranslator.getString("accident.companyFixingCost"));
            this.lblLocationDebt = new JLabel(LanguageTranslator.getString("accident.locationDebt"));
            this.lblCompanyLocationDebt = new JLabel(LanguageTranslator.getString("accident.companyLocationDebt"));
            this.lblGuarding = new JLabel(LanguageTranslator.getString("accident.guarding"));
            this.lblTotalCost = new JLabel(LanguageTranslator.getString("accident.totalCost"));
            this.lblTotalInsurance = new JLabel(LanguageTranslator.getString("accident.totalInsurance"));
            this.pnlFinancial = new JPanel();
            this.pnlFinancial.setMinimumSize(new Dimension(220, 0));
            this.pnlFinancial.setMaximumSize(new Dimension(220, 0));
            this.pnlFinancial.setPreferredSize(new Dimension(220, 0));
            this.pnlFinancial.setSize(new Dimension(220, 0));
            this.pnlFinancial.setBorder(new TitledBorder(LanguageTranslator.getString("accident.financial")));
            this.pnlFinancial.setLayout(new GridBagLayout());
            this.pnlFinancial.add((Component)this.lblRcCost, gcblblRcCost);
            this.pnlFinancial.add((Component)this.getTxtRcCost(), gcbTxtRcCost);
            this.pnlFinancial.add((Component)this.lblRcExcess, gcblblRcExcess);
            this.pnlFinancial.add((Component)this.getTxtRcExcess(), gcbTxtRcExcess);
            this.pnlFinancial.add((Component)this.getTxtInsuranceRecourse(), gcbTxtInsuranceRecourse);
            this.pnlFinancial.add((Component)this.lblInsuranceRecourse, gcblblInsuranceRecourse);
            this.pnlFinancial.add((Component)this.lblCompanyRecourse, gcblblCompanyRecourse);
            this.pnlFinancial.add((Component)this.getTxtCompanyRecourse(), gcbTxtCompanyRecourse);
            this.pnlFinancial.add((Component)this.lblDamageExcess, gcblblDamageExcess);
            this.pnlFinancial.add((Component)this.getTxtDamageExcess(), gcbTxtDamageExcess);
            this.pnlFinancial.add((Component)this.lblVAT, gcblblVAT);
            this.pnlFinancial.add((Component)this.getTxtVAT(), gcbTxtVAT);
            this.pnlFinancial.add((Component)this.lblDilapidation, gcblblDilapidation);
            this.pnlFinancial.add((Component)this.getTxtDilapidation(), gcbTxtDilapidation);
            this.pnlFinancial.add((Component)this.lblSelfInsurance, gcblblSelfInsurance);
            this.pnlFinancial.add((Component)this.getTxtSelfInsurance(), gcbTxtSelfInsurance);
            this.pnlFinancial.add((Component)this.lblExpertCost, gcblblExpertCost);
            this.pnlFinancial.add((Component)this.getTxtExpertCost(), gcbTxtExpertCost);
            this.pnlFinancial.add((Component)this.lblFixingCost, gcblblFixingCost);
            this.pnlFinancial.add((Component)this.getTxtFixingCost(), gcbTxtFixingCost);
            this.pnlFinancial.add((Component)this.lblCompanyFixingCost, gcblblCompanyFixingCost);
            this.pnlFinancial.add((Component)this.getTxtCompanyFixingCost(), gcbTxtCompanyFixingCost);
            this.pnlFinancial.add((Component)this.lblLocationDebt, gcblblLocationDebt);
            this.pnlFinancial.add((Component)this.getTxtLocationDebt(), gcbTxtLocationDebt);
            this.pnlFinancial.add((Component)this.lblCompanyLocationDebt, gcblblCompanyLocationDebt);
            this.pnlFinancial.add((Component)this.getTxtCompanyLocationDebt(), gcbTxtCompanyLocationDebt);
            this.pnlFinancial.add((Component)this.lblGuarding, gcblblGuarding);
            this.pnlFinancial.add((Component)this.getTxtGuarding(), gcbTxtGuarding);
            this.pnlFinancial.add((Component)this.lblTotalCost, gcbLblTotalCost);
            this.pnlFinancial.add((Component)this.getTxtTotalCost(), gcbTxtTotalCost);
            this.pnlFinancial.add((Component)this.lblTotalInsurance, gcbLblTotalInsurance);
            this.pnlFinancial.add((Component)this.getTxtTotalInsurance(), gcbTxtTotalInsurance);
        }
        return this.pnlFinancial;
    }

    private JTextField getTxtRcCost() {
        if (this.txtRcCost == null) {
            this.txtRcCost = new JTextField();
            this.txtRcCost.setEnabled(false);
        }
        return this.txtRcCost;
    }

    private JTextField getTxtRcExcess() {
        if (this.txtRcExcess == null) {
            this.txtRcExcess = new JTextField();
            this.txtRcExcess.setEnabled(false);
        }
        return this.txtRcExcess;
    }

    private JTextField getTxtInsuranceRecourse() {
        if (this.txtInsuranceRecourse == null) {
            this.txtInsuranceRecourse = new JTextField();
            this.txtInsuranceRecourse.setEnabled(false);
        }
        return this.txtInsuranceRecourse;
    }

    private JTextField getTxtCompanyRecourse() {
        if (this.txtCompanyRecourse == null) {
            this.txtCompanyRecourse = new JTextField();
            this.txtCompanyRecourse.setEnabled(false);
        }
        return this.txtCompanyRecourse;
    }

    private JTextField getTxtDamageExcess() {
        if (this.txtDamageExcess == null) {
            this.txtDamageExcess = new JTextField();
            this.txtDamageExcess.setEnabled(false);
        }
        return this.txtDamageExcess;
    }

    private JTextField getTxtVAT() {
        if (this.txtVAT == null) {
            this.txtVAT = new JTextField();
            this.txtVAT.setEnabled(false);
        }
        return this.txtVAT;
    }

    private JTextField getTxtDilapidation() {
        if (this.txtDilapidation == null) {
            this.txtDilapidation = new JTextField();
            this.txtDilapidation.setEnabled(false);
        }
        return this.txtDilapidation;
    }

    private JTextField getTxtSelfInsurance() {
        if (this.txtSelfInsurance == null) {
            this.txtSelfInsurance = new JTextField();
            this.txtSelfInsurance.setEnabled(false);
            this.txtDilapidation.setEnabled(false);
            this.txtVAT.setEnabled(false);
            this.txtDamageExcess.setEnabled(false);
            this.txtCompanyRecourse.setEnabled(false);
            this.txtInsuranceRecourse.setEnabled(false);
            this.txtRcCost.setEnabled(false);
            this.txtRcExcess.setEnabled(false);
        }
        return this.txtSelfInsurance;
    }

    private JTextField getTxtExpertCost() {
        if (this.txtExpertCost == null) {
            this.txtExpertCost = new JTextField();
            this.txtExpertCost.setEnabled(false);
        }
        return this.txtExpertCost;
    }

    private JTextField getTxtFixingCost() {
        if (this.txtFixingCost == null) {
            this.txtFixingCost = new JTextField();
            this.txtFixingCost.setEnabled(false);
        }
        return this.txtFixingCost;
    }

    private JTextField getTxtCompanyFixingCost() {
        if (this.txtCompanyFixingCost == null) {
            this.txtCompanyFixingCost = new JTextField();
            this.txtCompanyFixingCost.setEnabled(false);
        }
        return this.txtCompanyFixingCost;
    }

    private JTextField getTxtLocationDebt() {
        if (this.txtLocationDebt == null) {
            this.txtLocationDebt = new JTextField();
            this.txtLocationDebt.setEnabled(false);
        }
        return this.txtLocationDebt;
    }

    private JTextField getTxtCompanyLocationDebt() {
        if (this.txtCompanyLocationDebt == null) {
            this.txtCompanyLocationDebt = new JTextField();
            this.txtCompanyLocationDebt.setEnabled(false);
        }
        return this.txtCompanyLocationDebt;
    }

    private JTextField getTxtGuarding() {
        if (this.txtGuarding == null) {
            this.txtGuarding = new JTextField();
            this.txtGuarding.setEnabled(false);
        }
        return this.txtGuarding;
    }

    private JTextField getTxtTotalCost() {
        if (this.txtTotalCost == null) {
            this.txtTotalCost = new JTextField();
            this.txtTotalCost.setEnabled(false);
        }
        return this.txtTotalCost;
    }

    private JTextField getTxtTotalInsurance() {
        if (this.txtTotalInsurance == null) {
            this.txtTotalInsurance = new JTextField();
            this.txtTotalInsurance.setEnabled(false);
        }
        return this.txtTotalInsurance;
    }
}

