/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.UevDownload;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.uev.UEVProperty;
import transpo.system.uev.VuProcessingG1;
import transpo.system.uev.VuProcessingG2;
import transpo.system.uev.exception.VuFileNotFoundException;
import transpo.system.uev.exception.VuFileStructureException;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.ProgressBarIndetermine;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.vehicule.DialogSpeedNew;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;
import transpo.system.util.messaging.MessageSystemManager;

public class PnlArchivageUEV
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JDialog pere;
    private JComboBox cbVehicule = null;
    private JLabel lVehicule = null;
    private JLabel lSociete = null;
    private JComboBox cbAgence = null;
    private JLabel lDateDebut = null;
    private JTextField tfDateFin = null;
    private JLabel lDateFin = null;
    private JTextField tfDateDebut = null;
    private JPanel pBas = null;
    private JButton boutonExporter = null;
    private JScrollPane jScrollPaneTable = null;
    private JTable tableFichierUEV = null;
    private JPanel pnlFilter = null;
    private JButton boutonQuitter = null;
    private BddTransport bdd = null;
    private int cleVehiculeDL = 0;
    private int cleAgenceDL = 0;
    private JButton btnVitesse = null;

    public PnlArchivageUEV(JDialog dialogPere, BddTransport bddMF) {
        this.pere = dialogPere;
        this.bdd = bddMF;
        this.initialize();
        this.MAJTable();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(900, 600));
        this.add((Component)this.getPnlFilter(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 3, 11, new Insets(0, 20, 10, 20)));
        this.add((Component)this.getPBas(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, 11, new Insets(0, 20, 0, 20)));
    }

    private JPanel getPnlFilter() {
        if (this.pnlFilter == null) {
            this.pnlFilter = new JPanel();
            this.pnlFilter.setPreferredSize(new Dimension(600, 100));
            this.lDateFin = new JLabel(LanguageTranslator.getString("generics.end"));
            this.lDateDebut = new JLabel(LanguageTranslator.getString("generics.begin"));
            this.lSociete = new JLabel(LanguageTranslator.getString("generics.agency"));
            this.lVehicule = new JLabel(LanguageTranslator.getString("generics.vehicle"));
            this.pnlFilter.setLayout(new GridBagLayout());
            this.pnlFilter.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.filter"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlFilter.add((Component)this.lSociete, Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 50, 0, 10)));
            this.pnlFilter.add((Component)this.lDateDebut, Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, -1, 17, new Insets(0, 60, 0, 10)));
            this.pnlFilter.add((Component)this.getCbAgence(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 1, 17, new Insets(5, 0, 5, 0)));
            this.pnlFilter.add((Component)this.lVehicule, Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, -1, 17, new Insets(0, 50, 0, 10)));
            this.pnlFilter.add((Component)this.getCbVehicule(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 1, 17, new Insets(5, 0, 5, 0)));
            this.pnlFilter.add((Component)this.getTfDateDebut(), Fonctions.getGridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 0, 17, null));
            this.pnlFilter.add((Component)this.lDateFin, Fonctions.getGridBagConstraints(2, 1, 1, 1, 1.0, 0.0, -1, 17, new Insets(0, 60, 0, 10)));
            this.pnlFilter.add((Component)this.getTfDateFin(), Fonctions.getGridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 3, 17, new Insets(5, 0, 5, 0)));
        }
        return this.pnlFilter;
    }

    private JPanel getPBas() {
        if (this.pBas == null) {
            this.pBas = new JPanel();
            this.pBas.setPreferredSize(new Dimension(600, 250));
            this.pBas.setLayout(new GridBagLayout());
            this.pBas.add((Component)this.getJScrollPaneTable(), Fonctions.getGridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 1, -1, new Insets(5, 0, 0, 0)));
            this.pBas.add((Component)this.getBoutonExporter(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, -1, 17, new Insets(5, 0, 15, 0)));
            this.pBas.add((Component)this.getBtnVitesse(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, -1, -1, new Insets(5, 10, 15, 0)));
            this.pBas.add((Component)this.getBoutonQuitter(), Fonctions.getGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 0, 13, new Insets(5, 0, 15, 0)));
        }
        return this.pBas;
    }

    private JComboBox getCbVehicule() {
        if (this.cbVehicule == null) {
            this.cbVehicule = new JComboBox();
            this.cbVehicule.setPreferredSize(new Dimension(140, 20));
            ComboBoxModel tmp = new ComboBoxModel(Vehicule.loadList(this.cleAgenceDL), false, LanguageTranslator.getString("generics.all"));
            this.cbVehicule.setModel(tmp);
            this.cbVehicule.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PnlArchivageUEV.this.cleVehiculeDL = ((ComboBoxModel)PnlArchivageUEV.this.getCbVehicule().getModel()).getSelectedCle();
                    PnlArchivageUEV.this.MAJTable();
                }
            });
        }
        return this.cbVehicule;
    }

    private void updateVehicle() {
        ComboBoxModel tmp = new ComboBoxModel(Vehicule.loadList(this.cleAgenceDL), false, LanguageTranslator.getString("generics.all"));
        this.cbVehicule.setModel(tmp);
        this.cbVehicule.setSelectedItem("");
    }

    private void MAJTable() {
        String dateFinDL;
        String dateDebutDL = ConversionTime.dateFromFranceToBDD(this.getTfDateDebut().getText(), false);
        if (dateDebutDL.equals("1970-01-01")) {
            dateDebutDL = null;
        }
        if ((dateFinDL = ConversionTime.dateFromFranceToBDD(this.getTfDateFin().getText(), false)).equals("1970-01-01")) {
            dateFinDL = null;
        }
        TimsLogger.debug("#PnlArchiveUEV.MAJTable# " + dateDebutDL + " " + dateFinDL);
        long start = System.currentTimeMillis();
        Vector<UevDownload> dl = UevDownload.getTelechargementUEV(this.cleAgenceDL, this.cleVehiculeDL, dateDebutDL, dateFinDL);
        TimsLogger.info("#PnlArchivageUev.MAJTable()# load uev download in " + (System.currentTimeMillis() - start));
        this.tableFichierUEV.setModel(new TableFichierModele(dl));
        Fonctions.centrerTable(this.tableFichierUEV);
    }

    private JComboBox getCbAgence() {
        if (this.cbAgence == null) {
            this.cbAgence = new JComboBox();
            this.cbAgence.setPreferredSize(new Dimension(140, 20));
            ComboBoxModel tmp = new ComboBoxModel(Agence.getList(), false, LanguageTranslator.getString("generics.all"));
            this.cbAgence.setModel(tmp);
            this.cbAgence.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PnlArchivageUEV.this.cleAgenceDL = ((ComboBoxModel)PnlArchivageUEV.this.getCbAgence().getModel()).getSelectedCle();
                    PnlArchivageUEV.this.MAJTable();
                    PnlArchivageUEV.this.updateVehicle();
                }
            });
        }
        return this.cbAgence;
    }

    private JTextField getTfDateFin() {
        if (this.tfDateFin == null) {
            this.tfDateFin = new JTextField();
            this.tfDateFin.setPreferredSize(new Dimension(80, 20));
            this.tfDateFin.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    PnlArchivageUEV.this.setDate(PnlArchivageUEV.this.getTfDateFin(), 2);
                }
            });
        }
        return this.tfDateFin;
    }

    private JTextField getTfDateDebut() {
        if (this.tfDateDebut == null) {
            SimpleDateFormat tmp = new SimpleDateFormat("dd/MM/yyyy");
            GregorianCalendar date = new GregorianCalendar();
            date.setTime(new Date());
            date.set(5, 1);
            this.tfDateDebut = new JTextField(tmp.format(date.getTime()));
            this.tfDateDebut.setPreferredSize(new Dimension(80, 20));
            this.tfDateDebut.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    PnlArchivageUEV.this.setDate(PnlArchivageUEV.this.getTfDateDebut(), 1);
                }
            });
        }
        return this.tfDateDebut;
    }

    private JButton getBoutonExporter() {
        if (this.boutonExporter == null) {
            this.boutonExporter = new JButton();
            this.boutonExporter.setPreferredSize(new Dimension(100, 20));
            this.boutonExporter.setText(LanguageTranslator.getString("button.export"));
            this.boutonExporter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                GetFile tmp = new GetFile();
                                SwingUtilities.invokeAndWait(tmp);
                                if (tmp.getCheminSave() != null) {
                                    ProgressBarIndetermine progres = new ProgressBarIndetermine((Frame)MainFrameTransport.getInstance(), LanguageTranslator.getString("download.copy"));
                                    progres.setVisible(true);
                                    String cheminSave = tmp.getCheminSave();
                                    PnlArchivageUEV.this.saveFichier(cheminSave);
                                    progres.dispose();
                                }
                            }
                            catch (InvocationTargetException ex) {
                                ex.printStackTrace();
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }.start();
                }
            });
        }
        return this.boutonExporter;
    }

    private JScrollPane getJScrollPaneTable() {
        if (this.jScrollPaneTable == null) {
            this.jScrollPaneTable = new JScrollPane();
            this.jScrollPaneTable.setViewportView(this.getTableFichierUEV());
            this.jScrollPaneTable.setPreferredSize(new Dimension(600, 400));
        }
        return this.jScrollPaneTable;
    }

    private void setDate(JTextField txt, int maj) {
        if (Fonctions.afficheCalendrier(txt)) {
            this.MAJTable();
        }
    }

    private JTable getTableFichierUEV() {
        if (this.tableFichierUEV == null) {
            this.tableFichierUEV = new JTable();
            this.tableFichierUEV.setSelectionMode(2);
            this.tableFichierUEV.setRowHeight(20);
        }
        return this.tableFichierUEV;
    }

    private JButton getBoutonQuitter() {
        if (this.boutonQuitter == null) {
            this.boutonQuitter = new JButton();
            this.boutonQuitter.setPreferredSize(new Dimension(100, 20));
            this.boutonQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.boutonQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlArchivageUEV.this.pere.dispose();
                }
            });
        }
        return this.boutonQuitter;
    }

    private void saveFichier(String repertoireSauvegarde) {
        if (this.getTableFichierUEV().getSelectedRows().length != 0) {
            int[] nArray = this.getTableFichierUEV().getSelectedRows();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int x = nArray[n2];
                UevDownload tmp = ((TableFichierModele)this.getTableFichierUEV().getModel()).getUevDownloadAt(x);
                this.getFile(tmp, String.valueOf(repertoireSauvegarde) + "\\" + tmp.getFichier());
                ++n2;
            }
        } else {
            int x = 0;
            while (x < this.tableFichierUEV.getRowCount()) {
                UevDownload tmp = ((TableFichierModele)this.getTableFichierUEV().getModel()).getUevDownloadAt(x);
                this.getFile(tmp, String.valueOf(repertoireSauvegarde) + "\\" + tmp.getFichier());
                ++x;
            }
        }
        JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("download.export.succeed"), LanguageTranslator.getString("message.done"), 1);
    }

    private void getFile(UevDownload tmp, String destination) {
        File fichier = FileManager.getFile(tmp.getVehicle(), tmp.getFichier());
        if (fichier == null) {
            MessageSystemManager.error(null, LanguageTranslator.getString("generics.fileNotFound", tmp.getFichier()), LanguageTranslator.getString("generics.error"));
        } else {
            Fonctions.copyLocalFile(fichier, new File(destination), System.getProperty("URL") != null);
        }
    }

    private JButton getBtnVitesse() {
        if (this.btnVitesse == null) {
            this.btnVitesse = new JButton();
            this.btnVitesse.setText(LanguageTranslator.getString("button.speed"));
            this.btnVitesse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlArchivageUEV.this.loadVitesse();
                }
            });
        }
        return this.btnVitesse;
    }

    public void overview() {
        int RowSel = this.getTableFichierUEV().getSelectedRow();
        UevDownload tmp = ((TableFichierModele)this.getTableFichierUEV().getModel()).getUevDownloadAt(RowSel);
        File fichier = FileManager.getFile(tmp.getVehicle(), tmp.getFichier());
        if (fichier == null) {
            MessageSystemManager.error(null, LanguageTranslator.getString("generics.fileNotFound", tmp.getFichier()), LanguageTranslator.getString("generics.error"));
        } else {
            new VuProcessingG1(fichier).readInformation();
        }
    }

    private void loadVitesse() {
        TimsLogger.debug("print speed data");
        int RowSel = this.getTableFichierUEV().getSelectedRow();
        UevDownload tmp = ((TableFichierModele)this.getTableFichierUEV().getModel()).getUevDownloadAt(RowSel);
        File fichier = FileManager.getFile(tmp.getVehicle(), tmp.getFichier());
        if (fichier == null) {
            MessageSystemManager.error(null, LanguageTranslator.getString("generics.fileNotFound", tmp.getFichier()), LanguageTranslator.getString("generics.error"));
        } else {
            try {
                TreeMap<String, Hashtable<Integer, String>> detailedSpeeds = null;
                detailedSpeeds = UEVProperty.getVuGeneration(fichier.getAbsolutePath()) == 2 ? new VuProcessingG2(fichier).getDetailedSpeed() : new VuProcessingG1(fichier).getDetailedSpeed();
                new DialogSpeedNew((Frame)MainFrameTransport.getInstance(), detailedSpeeds);
            }
            catch (VuFileNotFoundException ex) {
                MessageSystemManager.error(null, LanguageTranslator.getString("generics.fileNotFound", LanguageTranslator.getString("generics.speed")), LanguageTranslator.getString("generics.error"));
            }
            catch (VuFileStructureException ex) {
                MessageSystemManager.error(null, LanguageTranslator.getString("generics.fileError", LanguageTranslator.getString("generics.speed")), LanguageTranslator.getString("generics.error"));
            }
            catch (Exception ex) {
                MessageSystemManager.error(null, ex.getMessage(), LanguageTranslator.getString("generics.error"));
            }
        }
    }

    class GetFile
    implements Runnable {
        private String cheminSave = String.valueOf(Preferences.userRoot().node("TIMS").node("DIRECTORY").get("EXPORT", System.getProperty("user.home"))) + "\\";

        @Override
        public void run() {
            JFileChooser choix = new JFileChooser();
            choix.setDialogTitle("o\u00f9 desirez-vous sauvegarger les fichiers ?");
            choix.setFileSelectionMode(1);
            choix.setCurrentDirectory(new File(this.cheminSave));
            if (choix.showSaveDialog(MainFrameTransport.getInstance()) == 0) {
                this.cheminSave = choix.getSelectedFile().getAbsolutePath();
                Preferences.userRoot().node("TIMS").node("DIRECTORY").put("EXPORT", this.cheminSave);
            }
        }

        public String getCheminSave() {
            return this.cheminSave;
        }
    }

    public class TableFichierModele
    extends AbstractTableModel {
        Vector<UevDownload> donnees;
        String[] titres = new String[]{LanguageTranslator.getString("generics.vehicle"), LanguageTranslator.getString("download.date"), LanguageTranslator.getString("download.fileName"), LanguageTranslator.getString("download.activity"), LanguageTranslator.getString("download.previousDownload"), LanguageTranslator.getString("download.auto")};

        public TableFichierModele(Vector<UevDownload> donnees) {
            this.donnees = donnees;
        }

        @Override
        public int getColumnCount() {
            return System.getProperty("URL") == null ? this.titres.length - 1 : this.titres.length;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Object getValueAt(int parm1, int parm2) {
            UevDownload tmp = this.donnees.get(parm1);
            switch (parm2) {
                case 0: {
                    return tmp.getVehicle().getRegistrationNumber();
                }
                case 1: {
                    return ConversionTime.dateToString(tmp.getTelechargement(), "dd/MM/yyyy HH'h'mm");
                }
                case 2: {
                    return tmp.getFichier();
                }
                case 3: {
                    if (tmp.getBeginActivity() == null || tmp.getBeginActivity() == null) {
                        return LanguageTranslator.getString("generics.unknown");
                    }
                    return String.valueOf(ConversionTime.dateToString(tmp.getBeginActivity(), "dd/MM/yy")) + " -> " + ConversionTime.dateToString(tmp.getEndActivity(), "dd/MM/yy");
                }
                case 4: {
                    if (tmp.getPreviousDownload() == null) {
                        return LanguageTranslator.getString("generics.unknown");
                    }
                    return ConversionTime.dateToString(tmp.getPreviousDownload(), "dd/MM/yyyy HH'h'mm");
                }
                case 5: {
                    return tmp.getUserId() == 0 ? new Boolean(true) : new Boolean(false);
                }
            }
            return "?";
        }

        public Class getColumnClass(int c) {
            if (this.donnees == null || this.donnees.size() == 0) {
                return null;
            }
            TimsLogger.debug(this.getValueAt(0, c) == null ? String.class.getName() : this.getValueAt(0, c).getClass().getName());
            return this.getValueAt(0, c) == null ? String.class : this.getValueAt(0, c).getClass();
        }

        public UevDownload getUevDownloadAt(int line) {
            return this.donnees.get(line);
        }

        @Override
        public int getRowCount() {
            return this.donnees.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.titres[col];
        }
    }
}

