/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import java.awt.Graphics;
import java.awt.GridLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import transpo.system.TimsLogger;
import transpo.system.ui.viewable.ProgressView;

public class ProgressBar
extends JDialog
implements ProgressView {
    private static final long serialVersionUID = 1L;
    public JProgressBar jBar;

    public ProgressBar(JFrame parent, String titre) {
        super(parent);
        this.setTitle(titre);
        this.setSize(300, 75);
        this.setLocation(250, 250);
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(this.getBar());
    }

    public ProgressBar(JDialog parent, String titre) {
        super(parent);
        this.setTitle(titre);
        this.setSize(300, 75);
        this.setLocation(250, 250);
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(this.getBar());
        this.setVisible(true);
    }

    public JProgressBar getBar() {
        if (this.jBar == null) {
            this.jBar = new JProgressBar();
            this.jBar.setMinimum(0);
            this.jBar.setMaximum(100);
            this.jBar.setStringPainted(true);
        }
        return this.jBar;
    }

    public void incrementBarValue(int n) {
        this.getBar().setValue(this.getBar().getValue() + n);
    }

    @Override
    public void setValue(int n) {
        this.getBar().setValue(n);
    }

    public void paintComponent(Graphics g) {
        super.paintComponents(g);
        TimsLogger.debug("#ProgressBar.paintComponent# " + SwingUtilities.isEventDispatchThread());
    }

    public void setString(String text) {
        this.getBar().setString(text);
    }

    @Override
    public void setMinimum(int x) {
        this.getBar().setMinimum(x);
    }

    @Override
    public void setMaximum(int x) {
        this.getBar().setMaximum(x);
    }

    @Override
    public void incrementValue(int x) {
        this.incrementBarValue(x);
    }

    @Override
    public void setText(String text) {
        this.getBar().setString(text);
    }
}

