/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.data.BddEvent;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.JourType;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.PopupCaller;
import transpo.system.ui.views.widget.WidgetFactory;
import transpo.system.util.Fonctions;

public class WidgetPopup
extends JPopupMenu
implements DataListener {
    JList<String> list = null;
    MouseListener lsl = null;

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        BddEvent e;
        if (dataEvent instanceof BddEvent && (e = (BddEvent)dataEvent).getTable().equals(JourType.table)) {
            this.getList().setModel(new ComboBoxModel(JourType.getList(), true, LanguageTranslator.getString("generics.none")));
        }
    }

    public WidgetPopup() {
        this.initialize();
    }

    @Override
    public void show(Component invoker, int x, int y) {
        if (!(invoker instanceof PopupCaller)) {
            TimsLogger.debug("ListPopup must be invoked by a class which is implementing ListPopupCaller");
            return;
        }
        super.show(null, x, y);
        this.setInvoker(invoker);
    }

    public void initialize() {
        this.setLayout(new GridBagLayout());
        this.add(this.getList(), Fonctions.getGridBagConstraints(0, 2, 1, 4, 1.0, 1.0, 1, -1, null));
    }

    public JList<String> getList() {
        if (this.list == null) {
            this.list = new JList(new ComboBoxModel(WidgetFactory.getAvailable(), true, LanguageTranslator.getString("generics.none")));
        }
        return this.list;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            this.getList().removeMouseListener(this.getMouseListener());
        }
        if (visible) {
            this.getList().addMouseListener(this.getMouseListener());
        }
        super.setVisible(visible);
    }

    public MouseListener getMouseListener() {
        if (this.lsl == null) {
            this.lsl = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        WidgetPopup.this.save();
                    }
                }
            };
        }
        return this.lsl;
    }

    public void save() {
        ((PopupCaller)((Object)this.getInvoker())).submitPopup();
        TimsLogger.debug("Return " + this.list.getSelectedIndex());
        this.setVisible(false);
    }

    public int getSelected() {
        return this.list.getSelectedIndex();
    }
}

