/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.admin;

import fr.pgh.component.JTextDate;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Tracking;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DataAdministration
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlPurge = null;
    private JButton btnPurge = null;
    private JButton btnQuit = null;
    private JTextDate txtBegin = null;
    private JPanel pnlBtn = null;

    public DataAdministration(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("data.admin.title"));
        this.setBounds(new Rectangle(0, 0, 800, 500));
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlPurge(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(10, 10, 10, 5)));
            this.jContentPane.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(10, 10, 10, 5)));
        }
        return this.jContentPane;
    }

    private JPanel getPnlPurge() {
        if (this.pnlPurge == null) {
            this.pnlPurge = new JPanel();
            this.pnlPurge.setLayout(new FlowLayout());
            this.pnlPurge.add((Component)this.getTxtBegin(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(10, 10, 10, 5)));
            this.pnlPurge.add((Component)this.getBtnPurge(), null);
        }
        return this.pnlPurge;
    }

    private JTextDate getTxtBegin() {
        if (this.txtBegin == null) {
            this.txtBegin = new JTextDate();
        }
        return this.txtBegin;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new FlowLayout());
            this.pnlBtn.add((Component)this.getBtnQuit(), null);
        }
        return this.pnlBtn;
    }

    private JButton getBtnPurge() {
        if (this.btnPurge == null) {
            this.btnPurge = new JButton();
            this.btnPurge.setText(LanguageTranslator.getString("button.purge"));
            this.btnPurge.setPreferredSize(new Dimension(98, 26));
            this.btnPurge.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataAdministration.this.purge();
                }
            });
        }
        return this.btnPurge;
    }

    public void purge() {
        Date begin = ConversionTime.stringToDateFr("01/01/2000");
        String sEnd = this.getTxtBegin().getText();
        Date end = ConversionTime.stringToDateFr(this.getTxtBegin().getText());
        Vector<Conducteur> drivers = Conducteur.loadListWithArchive(0);
        BddTransport db = BddTransport.getInstance();
        db.startTransaction();
        String action = "Purge jusqu'au " + this.getTxtBegin().getText();
        for (Conducteur driver : drivers) {
            String last = driver.getLastWorkedDay();
            if (ConversionTime.stringToDateDb(last).before(end)) {
                action = String.valueOf(action) + "suppression totale (derni\u00e8re activit\u00e9 le " + last + ") : " + driver.getNom() + "\r\n";
                TimsLogger.debug("#DataAdministration.purge# suppression totale (derni\u00e8re activit\u00e9 le " + last + ") : " + driver.getNom());
                db.delDriverInformation(driver);
                continue;
            }
            action = String.valueOf(action) + "suppression jusqu'au " + sEnd + " : " + driver.getNom() + "\r\n";
            TimsLogger.debug("#DataAdministration.purge# suppression jusqu'au " + sEnd + " (derni\u00e8re activit\u00e9 le " + last + ") : " + driver.getNom());
            db.delDriverConflit(driver, begin, end);
            db.delDriverActivityConflitAnalyse(driver, begin, end);
            db.delDriverActivityConflitBase(driver, begin, end);
            db.delDriverHistorisedActivity(driver, begin, end);
            db.delDriverDay(driver, begin, end);
            db.delDriverChangedDay(driver, begin, end);
            db.delDriverDeletedDay(driver, begin, end);
            db.delDriverService(driver, begin, end);
            db.delDriverComment(driver, begin, end);
            db.delDriverUsed(driver, begin, end);
            db.delDriverPlaces(driver, begin, end);
            db.delDriverInfraction(driver, begin, end);
            db.delDriverCardDownload(driver, begin, end);
        }
        new Tracking(0, ConnexionSettings.getInstance().getUserCle(), "PURGE", 1, new Date(), action).insert();
        db.commit();
        this.dispose();
    }

    private JButton getBtnQuit() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton();
            this.btnQuit.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataAdministration.this.dispose();
                }
            });
        }
        return this.btnQuit;
    }
}

