/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.admin;

import fr.pgh.component.JFittedComboBox;
import fr.pgh.component.JTextDate;
import fr.pgh.component.JTextHour;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.ActionPriority;
import fr.pgh.data.bdd.ActionState;
import fr.pgh.data.bdd.ActionType;
import fr.pgh.data.bdd.CompanyAction;
import fr.pgh.data.bdd.IcontactCompany;
import fr.pgh.data.bdd.IcontactPerson;
import fr.pgh.data.bdd.Product;
import fr.pgh.data.bdd.Utilisateur;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.TMCompanyAction;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.admin.DialogAdminCompany;
import transpo.system.ui.views.admin.DialogAdminContact;
import transpo.system.util.Fonctions;

public class DialogAdminAction
extends JDialog
implements DataListener {
    public static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JButton btnCompany = null;
    private JButton btnContact = null;
    private JButton btn = null;
    private JButton btnQuit = null;
    private JButton btnCreate = null;
    private JButton btnSave = null;
    private JPanel pnlBtn = null;
    private JPanel pnlFilter = null;
    private JTextDate txtFilterDate = null;
    private JFittedComboBox cbFilterManager = null;
    private JFittedComboBox cbFilterProduct = null;
    private JFittedComboBox cbFilterAction = null;
    private JFittedComboBox cbFilterPriority = null;
    private JFittedComboBox cbFilterContact = null;
    private JFittedComboBox cbFilterCompany = null;
    private JFittedComboBox cbFilterState = null;
    private JTextField txtLargeSearch = null;
    private JPanel pnlCompanyAction = null;
    private JPanel pnlTbl = null;
    private JScrollPane jspTbl = null;
    private JTable tblAction = null;
    private JPanel pnlContentTechnical = null;
    private JTextDate txtDateTechnical = null;
    private JTextHour txtHourTechnical = null;
    private JComboBox<ActionState> cbState = null;
    private JComboBox<Utilisateur> cbManager = null;
    private JComboBox<Product> cbProduct = null;
    private JComboBox<ActionType> cbAction = null;
    private JComboBox<ActionPriority> cbPriority = null;
    private JComboBox<IcontactPerson> cbContact = null;
    private JComboBox<IcontactCompany> cbCompany = null;
    private JScrollPane jspPb = null;
    private JTextArea txtPbTechnical = null;
    private JScrollPane jspSolve = null;
    private JTextArea txtSolveTechnical = null;
    private JTextHour txtLengthTelTechnical = null;
    private JTextHour txtLengthIntervTechnical = null;
    private JTextField cost = null;
    private CompanyAction selected = null;

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        if (dataEvent instanceof BddEvent) {
            BddEvent e = (BddEvent)dataEvent;
            if (e.getTable().equals(IcontactCompany.table)) {
                this.reloadCompany();
            } else if (e.getTable().equals(IcontactPerson.table)) {
                this.updatePersonn();
            }
        }
    }

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogCompany.dispose()#");
        super.dispose();
    }

    public DialogAdminAction(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogCompanyAction()#");
        this.initialize();
        this.reload();
        Transport.bdd.addDataListener(this);
    }

    private void initialize() {
        this.setBounds(new Rectangle(0, 0, 1010, 730));
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("company.action.title"));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlTbl(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.jContentPane.add((Component)this.getPnlCompanyAction(), Fonctions.getGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.jContentPane.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 2, -1, new Insets(5, 5, 5, 5)));
        }
        return this.jContentPane;
    }

    private JButton getBtnCompany() {
        if (this.btnCompany == null) {
            this.btnCompany = new JButton();
            this.btnCompany.setPreferredSize(new Dimension(25, 25));
            this.btnCompany.setIcon(Fonctions.getIcon(Transport.res.getResourceString("icone_cliq")));
            this.btnCompany.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdminCompany dac = new DialogAdminCompany(null);
                    int companyId = ((ComboBoxModel)DialogAdminAction.this.getCbFilterCompany().getModel()).getSelectedCle();
                    dac.setSelectedCompany(companyId);
                    dac.setVisible(true);
                }
            });
        }
        return this.btnCompany;
    }

    private JButton getBtnContact() {
        if (this.btnContact == null) {
            this.btnContact = new JButton();
            this.btnContact.setPreferredSize(new Dimension(25, 25));
            this.btnContact.setIcon(Fonctions.getIcon(Transport.res.getResourceString("icone_cliq")));
            this.btnContact.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdminContact dac = new DialogAdminContact(null);
                    int companyId = ((ComboBoxModel)DialogAdminAction.this.getCbFilterCompany().getModel()).getSelectedCle();
                    dac.setSelectedCompany(companyId);
                    dac.setVisible(true);
                }
            });
        }
        return this.btnContact;
    }

    private JButton getBtnQuit() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton();
            this.btnQuit.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdminAction.this.dispose();
                }
            });
        }
        return this.btnQuit;
    }

    private JButton getBtnCreate() {
        if (this.btnCreate == null) {
            this.btnCreate = new JButton();
            this.btnCreate.setText(LanguageTranslator.getString("button.new"));
            this.btnCreate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdminAction.this.load(null);
                }
            });
        }
        return this.btnCreate;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setText(LanguageTranslator.getString("button.save"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogAdminAction.this.check()) {
                        DialogAdminAction.this.save();
                    }
                }
            });
        }
        return this.btnSave;
    }

    private boolean check() {
        boolean validation = true;
        if (this.getTxtDateTechnical().getText().equals("")) {
            this.getTxtDateTechnical().setBackground(new Color(255, 192, 203));
            validation = false;
        } else {
            this.getTxtDateTechnical().setBackground(Color.white);
        }
        if (this.getCbCompany().getSelectedItem().equals(LanguageTranslator.getString("generics.none"))) {
            this.getCbCompany().setBackground(new Color(255, 192, 203));
            validation = false;
        } else {
            this.getCbCompany().setBackground(UIManager.getColor("ComboBox.background"));
        }
        return validation;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add((Component)this.getBtnQuit(), null);
            this.pnlBtn.add((Component)this.getBtnSave(), null);
            this.pnlBtn.add((Component)this.getBtnCreate(), null);
        }
        return this.pnlBtn;
    }

    private JPanel getPnlFilter() {
        if (this.pnlFilter == null) {
            this.pnlFilter = new JPanel();
            this.pnlFilter.setLayout(new GridBagLayout());
            this.pnlFilter.add((Component)this.getCbFilterCompany(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 3, -1, new Insets(2, 0, 2, 2)));
            this.pnlFilter.add((Component)this.getTxtLargeSearch(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 1, -1, new Insets(2, 0, 2, 2)));
            this.pnlFilter.add((Component)this.getTxtFilterDate(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 3, -1, new Insets(2, 0, 2, 2)));
            this.pnlFilter.add((Component)this.getCbFilterManager(), Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 3, -1, new Insets(2, 0, 2, 2)));
            this.pnlFilter.add((Component)this.getCbFilterProduct(), Fonctions.getGridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 3, -1, new Insets(2, 0, 2, 2)));
            this.pnlFilter.add((Component)this.getCbFilterAction(), Fonctions.getGridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 3, -1, new Insets(2, 0, 2, 2)));
            this.pnlFilter.add((Component)this.getCbFilterPriority(), Fonctions.getGridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 3, -1, new Insets(2, 0, 2, 2)));
            this.pnlFilter.add((Component)this.getCbFilterContact(), Fonctions.getGridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 3, -1, new Insets(2, 0, 2, 2)));
            this.pnlFilter.add((Component)this.getCbFilterState(), Fonctions.getGridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 3, -1, new Insets(2, 0, 2, 2)));
        }
        return this.pnlFilter;
    }

    private JTextDate getTxtFilterDate() {
        if (this.txtFilterDate == null) {
            this.txtFilterDate = new JTextDate();
        }
        return this.txtFilterDate;
    }

    private JFittedComboBox getCbFilterManager() {
        if (this.cbFilterManager == null) {
            this.cbFilterManager = new JFittedComboBox();
            this.cbFilterManager.setMaxWidth(125);
            this.cbFilterManager.setModel(new ComboBoxModel(Utilisateur.listAdmin(), false, LanguageTranslator.getString("generics.none")));
            this.cbFilterManager.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DialogAdminAction.this.reload();
                    }
                }
            });
        }
        return this.cbFilterManager;
    }

    private JFittedComboBox getCbFilterProduct() {
        if (this.cbFilterProduct == null) {
            this.cbFilterProduct = new JFittedComboBox();
            this.cbFilterProduct.setMaxWidth(125);
            this.cbFilterProduct.setModel(new ComboBoxModel(Product.getList(), false, LanguageTranslator.getString("generics.none")));
            this.cbFilterProduct.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DialogAdminAction.this.reload();
                    }
                }
            });
        }
        return this.cbFilterProduct;
    }

    private JFittedComboBox getCbFilterAction() {
        if (this.cbFilterAction == null) {
            this.cbFilterAction = new JFittedComboBox();
            this.cbFilterAction.setMaxWidth(125);
            this.cbFilterAction.setModel(new ComboBoxModel(ActionType.getList(), false, LanguageTranslator.getString("generics.none")));
            this.cbFilterAction.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DialogAdminAction.this.reload();
                    }
                }
            });
        }
        return this.cbFilterAction;
    }

    private JFittedComboBox getCbFilterPriority() {
        if (this.cbFilterPriority == null) {
            this.cbFilterPriority = new JFittedComboBox();
            this.cbFilterPriority.setMaxWidth(125);
            this.cbFilterPriority.setModel(new ComboBoxModel(ActionPriority.getList(), false, LanguageTranslator.getString("generics.none")));
            this.cbFilterPriority.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DialogAdminAction.this.reload();
                    }
                }
            });
        }
        return this.cbFilterPriority;
    }

    private JFittedComboBox getCbFilterContact() {
        if (this.cbFilterContact == null) {
            this.cbFilterContact = new JFittedComboBox();
            this.cbFilterContact.setMaxWidth(125);
            this.cbFilterContact.setModel(new ComboBoxModel(IcontactPerson.getList(), false, LanguageTranslator.getString("generics.none")));
            this.cbFilterContact.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DialogAdminAction.this.reload();
                    }
                }
            });
        }
        return this.cbFilterContact;
    }

    private JFittedComboBox getCbFilterCompany() {
        if (this.cbFilterCompany == null) {
            this.cbFilterCompany = new JFittedComboBox();
            this.cbFilterCompany.setMaxWidth(125);
            this.cbFilterCompany.setModel(new ComboBoxModel(IcontactCompany.getList(false), false, LanguageTranslator.getString("generics.none")));
            this.cbFilterCompany.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DialogAdminAction.this.reload();
                    }
                }
            });
        }
        return this.cbFilterCompany;
    }

    private JTextField getTxtLargeSearch() {
        if (this.txtLargeSearch == null) {
            this.txtLargeSearch = new JTextField();
            this.txtLargeSearch.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent event) {
                    String field = DialogAdminAction.this.getTxtLargeSearch().getText();
                    if (field.length() >= 3) {
                        TimsLogger.debug("key : " + field);
                        DialogAdminAction.this.reload();
                    }
                }
            });
        }
        return this.txtLargeSearch;
    }

    private void reloadCompany() {
        this.getCbFilterCompany().setModel(new ComboBoxModel(IcontactCompany.getList(false), false, LanguageTranslator.getString("generics.none")));
        this.getCbCompany().setModel(new ComboBoxModel(IcontactCompany.getList(false), false, LanguageTranslator.getString("generics.none")));
    }

    public void updatePersonn() {
        this.getCbContact().setModel(new ComboBoxModel(IcontactPerson.filterCompany(((ComboBoxModel)this.getCbCompany().getModel()).getSelectedCle()), false, LanguageTranslator.getString("generics.none")));
    }

    private JFittedComboBox getCbFilterState() {
        if (this.cbFilterState == null) {
            this.cbFilterState = new JFittedComboBox();
            this.cbFilterState.setMaxWidth(125);
            this.cbFilterState.setModel(new ComboBoxModel(ActionState.getList(), false, LanguageTranslator.getString("generics.none")));
            this.cbFilterState.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DialogAdminAction.this.reload();
                    }
                }
            });
        }
        return this.cbFilterState;
    }

    private JPanel getPnlCompanyAction() {
        if (this.pnlCompanyAction == null) {
            this.pnlCompanyAction = new JPanel();
            this.pnlCompanyAction.setLayout(new GridBagLayout());
            this.pnlCompanyAction.add((Component)this.getPnlContentTechnical(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlCompanyAction.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
        }
        return this.pnlCompanyAction;
    }

    private JPanel getPnlTbl() {
        if (this.pnlTbl == null) {
            this.pnlTbl = new JPanel();
            this.pnlTbl.setBorder(new TitledBorder(LanguageTranslator.getString("company.action")));
            this.pnlTbl.setLayout(new GridBagLayout());
            this.pnlTbl.add((Component)this.getPnlFilter(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, -1, new Insets(5, 5, 0, 5)));
            this.pnlTbl.add((Component)this.getJspTbl(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(0, 5, 5, 5)));
        }
        return this.pnlTbl;
    }

    private JScrollPane getJspTbl() {
        if (this.jspTbl == null) {
            this.jspTbl = new JScrollPane();
            this.jspTbl.setViewportView(this.getTableAction());
        }
        return this.jspTbl;
    }

    private JTable getTableAction() {
        if (this.tblAction == null) {
            this.tblAction = new JTable();
            this.tblAction.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && DialogAdminAction.this.getTableAction().getSelectedRow() != -1) {
                        TMCompanyAction tmp = (TMCompanyAction)DialogAdminAction.this.getTableAction().getModel();
                        DialogAdminAction.this.load(tmp.getData().get(DialogAdminAction.this.getTableAction().getSelectedRow()));
                    }
                }
            });
        }
        return this.tblAction;
    }

    private void reload() {
        Date day = this.getTxtFilterDate().getText().equals("") ? null : this.getTxtFilterDate().getDate();
        int companyId = ((ComboBoxModel)this.getCbFilterCompany().getModel()).getSelectedCle();
        int managerId = ((ComboBoxModel)this.getCbFilterManager().getModel()).getSelectedCle();
        int productId = ((ComboBoxModel)this.getCbFilterProduct().getModel()).getSelectedCle();
        int actionTypeId = ((ComboBoxModel)this.getCbFilterAction().getModel()).getSelectedCle();
        int priorityId = ((ComboBoxModel)this.getCbFilterPriority().getModel()).getSelectedCle();
        int contactId = ((ComboBoxModel)this.getCbFilterContact().getModel()).getSelectedCle();
        int stateId = ((ComboBoxModel)this.getCbFilterState().getModel()).getSelectedCle();
        String field = this.getTxtLargeSearch().getText();
        if (companyId == 0 && !field.equals(LanguageTranslator.getString("generics.none"))) {
            this.getTableAction().setModel(new TMCompanyAction(CompanyAction.loadList(field, managerId, actionTypeId, stateId, productId, contactId, priorityId, day, null)));
        } else {
            this.getTableAction().setModel(new TMCompanyAction(CompanyAction.loadList(companyId, managerId, actionTypeId, stateId, productId, contactId, priorityId, day, null)));
        }
        this.load(null);
    }

    private void load(CompanyAction ca) {
        this.selected = ca;
        this.getTxtDateTechnical().setText(this.selected == null ? ConversionTime.dateToString(new Date(), "dd/MM/yyyy") : ConversionTime.dateToString(this.selected.getDate(), "dd/MM/yyyy"));
        this.getTxtHourTechnical().setHourMinute(this.selected == null ? ConversionTime.heureStringToInt(ConversionTime.dateToString(new Date(), "HH'h'mm"), "h") : ConversionTime.heureStringToInt(ConversionTime.dateToString(this.selected.getDate(), "HH'h'mm"), "h"));
        if (this.selected == null) {
            this.getCbCompany().setSelectedIndex(this.getCbFilterCompany().getSelectedIndex());
            this.getCbState().setSelectedItem(LanguageTranslator.getString("generics.none"));
            this.getCbManager().setSelectedItem(ConnexionSettings.getInstance().user.toString());
            this.getCbProduct().setSelectedItem(LanguageTranslator.getString("generics.none"));
            this.getCbAction().setSelectedItem(LanguageTranslator.getString("generics.none"));
            this.getCbPriority().setSelectedItem(LanguageTranslator.getString("generics.none"));
            this.getCbContact().setSelectedItem(LanguageTranslator.getString("generics.none"));
        } else {
            this.getCbCompany().setSelectedItem(((ComboBoxModel)this.getCbCompany().getModel()).getLabel(this.selected.getCompanyId()));
            this.getCbState().setSelectedItem(((ComboBoxModel)this.getCbState().getModel()).getLabel(this.selected.getStateId()));
            this.getCbManager().setSelectedItem(((ComboBoxModel)this.getCbManager().getModel()).getLabel(this.selected.getManagerId()));
            this.getCbProduct().setSelectedItem(((ComboBoxModel)this.getCbProduct().getModel()).getLabel(this.selected.getProductId()));
            this.getCbAction().setSelectedItem(((ComboBoxModel)this.getCbAction().getModel()).getLabel(this.selected.getActionTypeId()));
            this.getCbPriority().setSelectedItem(((ComboBoxModel)this.getCbPriority().getModel()).getLabel(this.selected.getPriorityId()));
            this.getCbContact().setSelectedItem(((ComboBoxModel)this.getCbContact().getModel()).getLabel(this.selected.getContactId()));
        }
        this.getTxtLengthTelTechnical().setHourMinute(this.selected == null ? 0 : this.selected.getLengthTel());
        this.getTxtLengthIntervTechnical().setHourMinute(this.selected == null ? 0 : this.selected.getLengthInterv());
        this.getTxtPbTechnical().setText(this.selected == null ? "" : this.selected.getProblem());
        this.getTxtSolveTechnical().setText(this.selected == null ? "" : this.selected.getSolve());
        this.getCost().setText(this.selected == null ? "0" : String.valueOf(this.selected.getCost()));
    }

    private void save() {
        String sDate = String.valueOf(this.getTxtDateTechnical().getText()) + " " + this.getTxtHourTechnical().getText();
        Date date = ConversionTime.stringToDate(sDate, "dd/MM/yyyy hh'h'mm");
        int companyId = ((ComboBoxModel)this.getCbCompany().getModel()).getSelectedCle();
        int stateId = ((ComboBoxModel)this.getCbState().getModel()).getSelectedCle();
        int managerId = ((ComboBoxModel)this.getCbManager().getModel()).getSelectedCle();
        int productId = ((ComboBoxModel)this.getCbProduct().getModel()).getSelectedCle();
        int actionTypeId = ((ComboBoxModel)this.getCbAction().getModel()).getSelectedCle();
        int priorityId = ((ComboBoxModel)this.getCbPriority().getModel()).getSelectedCle();
        int contactId = ((ComboBoxModel)this.getCbContact().getModel()).getSelectedCle();
        int lengthTel = ConversionTime.heureStringToInt(this.getTxtLengthTelTechnical().getText(), "h");
        int lengthInterv = ConversionTime.heureStringToInt(this.getTxtLengthIntervTechnical().getText(), "h");
        float costInterv = Float.parseFloat(this.getCost().getText());
        if (this.selected == null) {
            this.selected = new CompanyAction();
        }
        if (this.selected.compareAndUpdate(companyId, date, stateId, managerId, productId, actionTypeId, priorityId, contactId, this.getTxtPbTechnical().getText(), this.getTxtSolveTechnical().getText(), lengthTel, lengthInterv, costInterv)) {
            Fonctions.showSuccessMessage(null, null);
            this.reload();
        } else {
            Fonctions.showErrorMessage(null, null);
        }
    }

    private JPanel getPnlContentTechnical() {
        if (this.pnlContentTechnical == null) {
            this.pnlContentTechnical = new JPanel();
            this.pnlContentTechnical.setLayout(new GridBagLayout());
            this.pnlContentTechnical.setBorder(new TitledBorder(LanguageTranslator.getString("generics.detail")));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.date")), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)this.getTxtDateTechnical(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)this.getTxtHourTechnical(), Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.company")), Fonctions.getGridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add(this.getCbCompany(), Fonctions.getGridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 2, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)this.getBtnCompany(), Fonctions.getGridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.responsible")), Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add(this.getCbManager(), Fonctions.getGridBagConstraints(1, 1, 1, 2, 0.0, 0.0, 2, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.state")), Fonctions.getGridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add(this.getCbState(), Fonctions.getGridBagConstraints(4, 1, 1, 2, 0.0, 0.0, 2, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.action")), Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add(this.getCbAction(), Fonctions.getGridBagConstraints(1, 2, 1, 2, 0.0, 0.0, 2, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.product")), Fonctions.getGridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add(this.getCbProduct(), Fonctions.getGridBagConstraints(4, 2, 1, 2, 0.0, 0.0, 2, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.contact")), Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add(this.getCbContact(), Fonctions.getGridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 2, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)this.getBtnContact(), Fonctions.getGridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.priority")), Fonctions.getGridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add(this.getCbPriority(), Fonctions.getGridBagConstraints(4, 3, 1, 2, 0.0, 0.0, 2, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.length.interv")), Fonctions.getGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)this.getTxtLengthIntervTechnical(), Fonctions.getGridBagConstraints(1, 4, 1, 2, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.length.tel")), Fonctions.getGridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)this.getTxtLengthTelTechnical(), Fonctions.getGridBagConstraints(4, 4, 1, 2, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.cost")), Fonctions.getGridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)this.getCost(), Fonctions.getGridBagConstraints(1, 5, 1, 2, 0.0, 0.0, 2, -1, new Insets(5, 2, 0, 2)));
            JPanel pnlPb = new JPanel();
            pnlPb.setLayout(new GridBagLayout());
            pnlPb.add((Component)this.getJspPb(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, null));
            pnlPb.setBorder(new TitledBorder(LanguageTranslator.getString("generics.problem")));
            this.pnlContentTechnical.add((Component)pnlPb, Fonctions.getGridBagConstraints(0, 6, 1, 3, 1.0, 1.0, 1, -1, new Insets(5, 2, 0, 2)));
            JPanel pnlSolve = new JPanel();
            pnlSolve.setLayout(new GridBagLayout());
            pnlSolve.add((Component)this.getJspSolve(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, null));
            pnlSolve.setBorder(new TitledBorder(LanguageTranslator.getString("generics.solve")));
            this.pnlContentTechnical.add((Component)pnlSolve, Fonctions.getGridBagConstraints(3, 6, 1, 3, 1.0, 1.0, 1, -1, new Insets(5, 2, 0, 2)));
        }
        return this.pnlContentTechnical;
    }

    private JTextDate getTxtDateTechnical() {
        if (this.txtDateTechnical == null) {
            this.txtDateTechnical = new JTextDate();
        }
        return this.txtDateTechnical;
    }

    private JTextHour getTxtHourTechnical() {
        if (this.txtHourTechnical == null) {
            this.txtHourTechnical = new JTextHour();
        }
        return this.txtHourTechnical;
    }

    private JComboBox<ActionState> getCbState() {
        if (this.cbState == null) {
            this.cbState = new JComboBox();
            this.cbState.setModel(new ComboBoxModel(ActionState.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbState;
    }

    private JComboBox<Utilisateur> getCbManager() {
        if (this.cbManager == null) {
            this.cbManager = new JComboBox();
            this.cbManager.setModel(new ComboBoxModel(Utilisateur.listAdmin(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbManager;
    }

    private JComboBox<Product> getCbProduct() {
        if (this.cbProduct == null) {
            this.cbProduct = new JComboBox();
            this.cbProduct.setModel(new ComboBoxModel(Product.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbProduct;
    }

    private JComboBox<ActionType> getCbAction() {
        if (this.cbAction == null) {
            this.cbAction = new JComboBox();
            this.cbAction.setModel(new ComboBoxModel(ActionType.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbAction;
    }

    private JComboBox<ActionPriority> getCbPriority() {
        if (this.cbPriority == null) {
            this.cbPriority = new JComboBox();
            this.cbPriority.setModel(new ComboBoxModel(ActionPriority.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbPriority;
    }

    private JComboBox<IcontactPerson> getCbContact() {
        if (this.cbContact == null) {
            this.cbContact = new JComboBox();
        }
        return this.cbContact;
    }

    private JComboBox<IcontactCompany> getCbCompany() {
        if (this.cbCompany == null) {
            this.cbCompany = new JComboBox();
            this.cbCompany.setModel(new ComboBoxModel(IcontactCompany.getList(false), false, LanguageTranslator.getString("generics.none")));
            this.cbCompany.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdminAction.this.getCbContact().setModel(new ComboBoxModel(IcontactPerson.filterCompany(((ComboBoxModel)DialogAdminAction.this.getCbCompany().getModel()).getSelectedCle()), false, LanguageTranslator.getString("generics.none")));
                }
            });
        }
        return this.cbCompany;
    }

    private JScrollPane getJspPb() {
        if (this.jspPb == null) {
            this.jspPb = new JScrollPane();
            this.jspPb.setViewportView(this.getTxtPbTechnical());
        }
        return this.jspPb;
    }

    private JTextArea getTxtPbTechnical() {
        if (this.txtPbTechnical == null) {
            this.txtPbTechnical = new JTextArea();
            this.txtPbTechnical.setLineWrap(true);
            this.txtPbTechnical.setWrapStyleWord(true);
        }
        return this.txtPbTechnical;
    }

    private JScrollPane getJspSolve() {
        if (this.jspSolve == null) {
            this.jspSolve = new JScrollPane();
            this.jspSolve.setViewportView(this.getTxtSolveTechnical());
        }
        return this.jspSolve;
    }

    private JTextArea getTxtSolveTechnical() {
        if (this.txtSolveTechnical == null) {
            this.txtSolveTechnical = new JTextArea();
            this.txtSolveTechnical.setLineWrap(true);
            this.txtSolveTechnical.setWrapStyleWord(true);
        }
        return this.txtSolveTechnical;
    }

    private JTextHour getTxtLengthTelTechnical() {
        if (this.txtLengthTelTechnical == null) {
            this.txtLengthTelTechnical = new JTextHour();
        }
        return this.txtLengthTelTechnical;
    }

    private JTextHour getTxtLengthIntervTechnical() {
        if (this.txtLengthIntervTechnical == null) {
            this.txtLengthIntervTechnical = new JTextHour();
        }
        return this.txtLengthIntervTechnical;
    }

    private JTextField getCost() {
        if (this.cost == null) {
            this.cost = new JTextField();
        }
        return this.cost;
    }
}

