/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.admin;

import fr.pgh.component.JFittedComboBox;
import fr.pgh.connexion.TimsSession;
import fr.pgh.data.BddEvent;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.IcontactCompany;
import fr.pgh.data.bdd.IcontactPerson;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogAdminContact
extends JDialog
implements DataListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JFittedComboBox cbFilterCompany = null;
    private JPanel pnlListe = null;
    private JPanel pnlDetail = null;
    private JPanel pnlGeneral = null;
    private JScrollPane jpsListe = null;
    private JList listContact = null;
    private JPanel pnlBtn = null;
    private JButton btnCreer = null;
    private JButton btnQuitter = null;
    private JButton btnEnregistrer = null;
    private JTextField txtFirstName = null;
    private JTextField txtLastName = null;
    private JTextField txtPhone = null;
    private JFittedComboBox cbCompany = null;
    private JTextField txtMail = null;
    private IcontactPerson current = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogAdminContact.dispose()#");
        super.dispose();
    }

    public DialogAdminContact(Frame owner) {
        super(owner);
        this.initialize();
        this.setModal(true);
        TimsSession.getInstance().addVisit(this.getClass().getName());
        Transport.bdd.addDataListener(this);
    }

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        if (dataEvent instanceof BddEvent) {
            BddEvent e = (BddEvent)dataEvent;
            if (e.getTable().equals(IcontactCompany.table)) {
                this.reloadCompany();
            } else if (e.getTable().equals(IcontactPerson.table)) {
                this.updateList();
            }
        }
    }

    private void initialize() {
        this.setSize(750, 500);
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("generics.contact"));
        this.setContentPane(this.getJContentPane());
        this.reloadCompany();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlListe(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.jContentPane.add((Component)this.getPnlDetail(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5)));
        }
        return this.jContentPane;
    }

    private JPanel getPnlListe() {
        if (this.pnlListe == null) {
            this.pnlListe = new JPanel();
            this.pnlListe.setLayout(new GridBagLayout());
            this.pnlListe.setPreferredSize(new Dimension(120, 0));
            this.pnlListe.add((Component)this.getCbFilterCompany(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, -1, new Insets(0, 0, 5, 0)));
            this.pnlListe.add((Component)this.getJpsListe(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(0, 0, 5, 0)));
            this.pnlListe.add((Component)this.getBtnCreer(), Fonctions.getGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 2, -1, new Insets(0, 0, 5, 0)));
        }
        return this.pnlListe;
    }

    private JPanel getPnlDetail() {
        if (this.pnlDetail == null) {
            this.pnlDetail = new JPanel();
            this.pnlDetail.setLayout(new GridBagLayout());
            this.pnlDetail.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 1, 15, new Insets(2, 0, 0, 0)));
            this.pnlDetail.add((Component)this.getPnlGeneral(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 15, new Insets(5, 0, 5, 0)));
        }
        return this.pnlDetail;
    }

    private JScrollPane getJpsListe() {
        if (this.jpsListe == null) {
            this.jpsListe = new JScrollPane();
            this.jpsListe.setPreferredSize(new Dimension(0, 0));
            this.jpsListe.setViewportView(this.getListContact());
        }
        return this.jpsListe;
    }

    private JList getListContact() {
        if (this.listContact == null) {
            this.listContact = new JList();
            this.listContact.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && DialogAdminContact.this.getListContact().getSelectedIndex() != -1) {
                        IcontactPerson selected = (IcontactPerson)((ComboBoxModel)DialogAdminContact.this.getListContact().getModel()).getObjectAt(DialogAdminContact.this.getListContact().getSelectedIndex());
                        DialogAdminContact.this.load(selected);
                    }
                }
            });
        }
        return this.listContact;
    }

    private JButton getBtnCreer() {
        if (this.btnCreer == null) {
            this.btnCreer = new JButton();
            this.btnCreer.setText(LanguageTranslator.getString("button.new"));
            this.btnCreer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdminContact.this.load(null);
                }
            });
        }
        return this.btnCreer;
    }

    private JTextField getTxtFirstName() {
        if (this.txtFirstName == null) {
            this.txtFirstName = new JTextField();
        }
        return this.txtFirstName;
    }

    private JTextField getTxtLastName() {
        if (this.txtLastName == null) {
            this.txtLastName = new JTextField();
            this.txtLastName.setPreferredSize(new Dimension(70, 20));
        }
        return this.txtLastName;
    }

    private JTextField getTxtPhone() {
        if (this.txtPhone == null) {
            this.txtPhone = new JTextField();
            this.txtPhone.setPreferredSize(new Dimension(45, 20));
        }
        return this.txtPhone;
    }

    private JTextField getTxtMail() {
        if (this.txtMail == null) {
            this.txtMail = new JTextField();
        }
        return this.txtMail;
    }

    private JFittedComboBox getCbCompany() {
        if (this.cbCompany == null) {
            this.cbCompany = new JFittedComboBox();
            this.cbCompany.setMaxWidth(125);
        }
        return this.cbCompany;
    }

    private void reloadCompany() {
        this.getCbCompany().setModel(new ComboBoxModel(IcontactCompany.getList(false), false, LanguageTranslator.getString("generics.none")));
        this.getCbFilterCompany().setModel(new ComboBoxModel(IcontactCompany.getList(false), false, LanguageTranslator.getString("generics.none")));
    }

    private JFittedComboBox getCbFilterCompany() {
        if (this.cbFilterCompany == null) {
            this.cbFilterCompany = new JFittedComboBox();
            this.cbFilterCompany.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DialogAdminContact.this.updateList();
                    }
                }
            });
        }
        return this.cbFilterCompany;
    }

    private void load(IcontactPerson toLoad) {
        this.current = toLoad;
        if (this.current == null) {
            this.getTxtFirstName().setText("");
            this.getTxtLastName().setText("");
            this.getTxtPhone().setText("");
            this.getTxtMail().setText("");
            this.getCbCompany().setSelectedIndex(this.getCbFilterCompany().getSelectedIndex());
        } else {
            this.getTxtFirstName().setText(toLoad.getFirstName());
            this.getTxtLastName().setText(toLoad.getLastName());
            this.getTxtPhone().setText(toLoad.getPhone());
            this.getTxtMail().setText(toLoad.getMail());
            this.getCbCompany().setSelectedItem(((ComboBoxModel)this.getCbCompany().getModel()).getLabel(this.current.getCompanyId()));
        }
    }

    public void setSelectedCompany(int companyId) {
        this.getCbFilterCompany().setSelectedItem(((ComboBoxModel)this.getCbCompany().getModel()).getLabel(companyId));
        this.updateList();
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnQuitter(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 0, -1, new Insets(5, 0, 0, 5)));
            this.pnlBtn.add((Component)this.getBtnEnregistrer(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 0, -1, new Insets(5, 0, 0, 5)));
        }
        return this.pnlBtn;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdminContact.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdminContact.this.save();
                    DialogAdminContact.this.updateList();
                }
            });
        }
        return this.btnEnregistrer;
    }

    private JPanel getPnlGeneral() {
        if (this.pnlGeneral == null) {
            this.pnlGeneral = new JPanel();
            this.pnlGeneral.setLayout(new GridBagLayout());
            this.pnlGeneral.add((Component)new JLabel(LanguageTranslator.getString("user.firstName")), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5)));
            this.pnlGeneral.add((Component)this.getTxtFirstName(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 1, 10, new Insets(5, 0, 0, 5)));
            this.pnlGeneral.add((Component)new JLabel(LanguageTranslator.getString("user.lastName")), Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5)));
            this.pnlGeneral.add((Component)this.getTxtLastName(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 1, 10, new Insets(5, 0, 0, 5)));
            this.pnlGeneral.add((Component)new JLabel(LanguageTranslator.getString("generics.company")), Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5)));
            this.pnlGeneral.add((Component)this.getCbCompany(), Fonctions.getGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 1, 10, new Insets(5, 0, 0, 5)));
            this.pnlGeneral.add((Component)new JLabel(LanguageTranslator.getString("generics.phone")), Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5)));
            this.pnlGeneral.add((Component)this.getTxtPhone(), Fonctions.getGridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 1, 10, new Insets(5, 0, 0, 5)));
            this.pnlGeneral.add((Component)new JLabel(LanguageTranslator.getString("generics.mail")), Fonctions.getGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5)));
            this.pnlGeneral.add((Component)this.getTxtMail(), Fonctions.getGridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 1, 10, new Insets(5, 0, 0, 5)));
        }
        return this.pnlGeneral;
    }

    private void save() {
        if (this.check()) {
            if (this.current == null) {
                this.current = new IcontactPerson();
            }
            int companyId = ((ComboBoxModel)this.getCbCompany().getModel()).getSelectedCle();
            if (this.current.compareAndUpdate(this.getTxtFirstName().getText(), this.getTxtLastName().getText(), companyId, this.getTxtMail().getText(), this.getTxtPhone().getText())) {
                Fonctions.showSuccessMessage(null, null);
            } else {
                Fonctions.showErrorMessage(null, null);
            }
        }
    }

    private boolean check() {
        boolean toReturn = true;
        if (this.getTxtFirstName().getText().equals("")) {
            this.getTxtFirstName().setBackground(new Color(255, 192, 203));
            this.getTxtFirstName().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtFirstName().setBackground(Color.white);
        }
        if (this.getTxtLastName().getText().equals("")) {
            this.getTxtLastName().setBackground(new Color(255, 192, 203));
            this.getTxtLastName().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtLastName().setBackground(Color.white);
        }
        if (this.getTxtPhone().getText().equals("")) {
            this.getTxtPhone().setBackground(new Color(255, 192, 203));
            this.getTxtPhone().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtPhone().setBackground(Color.white);
        }
        if (this.getTxtMail().getText().equals("")) {
            this.getTxtMail().setBackground(new Color(255, 192, 203));
            this.getTxtMail().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtMail().setBackground(Color.white);
        }
        if (this.getCbCompany().getSelectedItem().equals(LanguageTranslator.getString("generics.none"))) {
            this.getCbCompany().setBackground(new Color(255, 192, 203));
            toReturn = false;
        } else {
            this.getCbCompany().setBackground(UIManager.getColor("ComboBox.background"));
        }
        return toReturn;
    }

    public void updateList() {
        int companyId = ((ComboBoxModel)this.getCbFilterCompany().getModel()).getSelectedCle();
        this.getListContact().setModel(new ComboBoxModel(IcontactPerson.filterCompany(companyId), true, null));
        if (this.current != null) {
            this.getListContact().setSelectedValue(String.valueOf(this.current.toString()) + " - " + this.current.getPhone(), true);
        }
    }

    public int getSelectedCompanyId() {
        int companyId = ((ComboBoxModel)this.getCbFilterCompany().getModel()).getSelectedCle();
        return companyId;
    }
}

