/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.admin;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.AgencyRestriction;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.Profil;
import fr.pgh.data.bdd.Societe;
import fr.pgh.data.bdd.UserWarningActivation;
import fr.pgh.data.bdd.Utilisateur;
import fr.pgh.data.dao.factory.DAOFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.CheckBoxBorder;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.LMUser;
import transpo.system.ui.modele.TMUserAlert;
import transpo.system.ui.renderer.LRUser;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.DialogChangementMdp;
import transpo.system.ui.views.NouvelUtilisateur;
import transpo.system.ui.views.PnlRestrictionAgence;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;

public class DialogAdministrationUtilisateur
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pUser = null;
    private JPanel pDetailUser = null;
    private JList listeUser = null;
    private JButton btnNouveau = null;
    private JPanel pUserInfo = null;
    private JTextField txtNom = null;
    private JTextField txtPrenom = null;
    private JLabel lblNom = null;
    private JLabel lblPrenom = null;
    private JLabel lblSociete = null;
    private JLabel lblProfil = null;
    private JComboBox cbSociete = null;
    private JComboBox cbProfil = null;
    public LMUser modeleUser = null;
    private Utilisateur currentUser = null;
    private JButton btnEnregistrer = null;
    private JButton btnQuitter = null;
    private JComboBox cbAgence = null;
    private JLabel lblAgence = null;
    private JComboBox cbConducteur = null;
    private JLabel lblCond = null;
    private JScrollPane jsp = null;
    private JPanel tpRes = null;
    private PnlRestrictionAgence pnlResAgence = null;
    private JPanel pnlRestriction = null;
    private JCheckBox cbRestreintSociete = null;
    private JCheckBox cbRestreintAgence = null;
    private JCheckBox cbRestreintConducteur = null;
    private JButton btnChangePasse = null;
    private JCheckBox cbDisable = null;
    private Profil defaultProfil = null;
    private JButton btnExport = null;
    private JPanel pnlBtn = null;
    private JCheckBox cbEnabled = null;
    private JTextField txtMail = null;
    private JLabel lblMail = null;
    private JCheckBox cbAlertEnable = null;
    private JComboBox cbFCompany = null;
    private Vector<Societe> companies = null;
    private Vector<Utilisateur> users = null;
    private JPanel pnlAutomaticWarning = null;
    private JScrollPane jspWarn = null;
    private JTable tblAuto = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogAdministrationUtilisateur.dispose()#");
        super.dispose();
    }

    public DialogAdministrationUtilisateur(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogAdministrationUtilisateur()#");
        this.initialize();
    }

    private void initialize() {
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("user.admin.title"));
        this.setBounds(new Rectangle(0, 0, 850, 500));
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setContentPane(this.getJContentPane());
        this.refreshListe();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.weightx = 4.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.insets = new Insets(10, 5, 10, 10);
            gridBagConstraints1.gridwidth = 1;
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(10, 10, 10, 5);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPUser(), gridBagConstraints);
            this.jContentPane.add((Component)this.getPDetailUser(), gridBagConstraints1);
        }
        return this.jContentPane;
    }

    private JPanel getPUser() {
        if (this.pUser == null) {
            GridBagConstraints gcbCompany = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, -1, null);
            GridBagConstraints gcbJsp = Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, -1, null);
            GridBagConstraints gcbDisable = Fonctions.getGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 1, -1, new Insets(0, 5, 0, 5));
            GridBagConstraints gcbBtnNew = Fonctions.getGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 1, -1, new Insets(0, 5, 0, 5));
            this.pUser = new JPanel();
            this.pUser.setLayout(new GridBagLayout());
            this.pUser.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("user"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pUser.setPreferredSize(new Dimension(0, 0));
            this.pUser.add((Component)this.getCbFCompany(), gcbCompany);
            this.pUser.add((Component)this.getJsp(), gcbJsp);
            this.pUser.add((Component)this.getCbDisable(), gcbDisable);
            this.pUser.add((Component)this.getBtnNouveau(), gcbBtnNew);
        }
        return this.pUser;
    }

    private JPanel getPDetailUser() {
        if (this.pDetailUser == null) {
            GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
            gridBagConstraints28.gridx = 1;
            gridBagConstraints28.weightx = 1.0;
            gridBagConstraints28.weighty = 1.0;
            gridBagConstraints28.fill = 1;
            gridBagConstraints28.insets = new Insets(5, 2, 5, 1);
            gridBagConstraints28.gridy = 1;
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.gridx = 0;
            gridBagConstraints27.gridwidth = 2;
            gridBagConstraints27.gridy = 3;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.insets = new Insets(5, 1, 5, 2);
            gridBagConstraints5.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 0.0;
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.gridy = 0;
            this.pDetailUser = new JPanel();
            this.pDetailUser.setLayout(new GridBagLayout());
            this.pDetailUser.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("user.information"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pDetailUser.setPreferredSize(new Dimension(0, 0));
            this.pDetailUser.add((Component)this.getPUserInfo(), gridBagConstraints4);
            this.pDetailUser.add((Component)this.getPnlRestriction(), gridBagConstraints5);
            this.pDetailUser.add((Component)this.getPnlBtn(), gridBagConstraints27);
            this.pDetailUser.add((Component)this.getPnlAutomaticWarning(), gridBagConstraints28);
        }
        return this.pDetailUser;
    }

    private JList getListeUser() {
        if (this.listeUser == null) {
            this.listeUser = new JList();
            this.listeUser.setSelectionMode(0);
            this.listeUser.setSize(new Dimension(0, 0));
            this.listeUser.setCellRenderer(new LRUser());
            this.listeUser.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && DialogAdministrationUtilisateur.this.listeUser.getSelectedIndex() != -1) {
                        DialogAdministrationUtilisateur.this.currentUser = (Utilisateur)DialogAdministrationUtilisateur.this.modeleUser.get(DialogAdministrationUtilisateur.this.listeUser.getSelectedIndex());
                        DialogAdministrationUtilisateur.this.setUser();
                    }
                }
            });
        }
        return this.listeUser;
    }

    public void setUser() {
        this.txtNom.setText(this.currentUser.getNom());
        this.txtPrenom.setText(this.currentUser.getPrenom());
        this.getTxtMail().setText(this.currentUser.getEmail());
        this.getCbSociete().setSelectedItem(this.currentUser.getSociete());
        this.getCbRestreintSociete().setSelected(this.currentUser.isRestreintSociete());
        this.getCbRestreintAgence().setSelected(this.currentUser.isRestreintAgence());
        this.getCbRestreintConducteur().setSelected(this.currentUser.isRestreintConducteur());
        this.getCbAgence().setSelectedItem(((ComboBoxModel)this.getCbAgence().getModel()).getLabel(this.currentUser.getCleAgence()));
        this.getCbConducteur().setSelectedItem(((ComboBoxModel)this.getCbConducteur().getModel()).getLabel(this.currentUser.getCleConducteur()));
        this.getCbEnabled().setSelected(this.currentUser.isEnable());
        String text = LanguageTranslator.getString("generics.enable");
        if (this.currentUser.getLastActivationAction() != null) {
            String date = ConversionTime.dateToString(this.currentUser.getLastActivationAction(), "dd/MM/yyyy");
            text = this.currentUser.isEnable() ? String.valueOf(text) + LanguageTranslator.getString("user.activated", date) : String.valueOf(text) + " (" + LanguageTranslator.getString("user.desactivated", date) + ")";
        }
        this.getCbEnabled().setText(text);
        this.getCbAlertEnable().setSelected(this.currentUser.isAlerted());
        ArrayList<UserWarningActivation> active = UserWarningActivation.getList(this.currentUser.getCleUser());
        ((TMUserAlert)this.getTblAuto().getModel()).setActivation(active);
        int cleProfil = this.currentUser.getCleProfil();
        this.getCbProfil().setSelectedItem(((ComboBoxModel)this.getCbProfil().getModel()).getLabel(cleProfil));
        this.getCbProfil().setEditable(false);
    }

    public void deleteUser(Utilisateur a) {
        a.delete();
        this.listeUser.setSelectedIndex(0);
        this.refreshListe();
    }

    public void reloadComboBox() {
        Societe database = (Societe)((ComboBoxModel)this.getCbSociete().getModel()).getObjectAt(this.getCbSociete().getSelectedIndex());
        ComboBoxModel tmp = new ComboBoxModel(Agence.loadList(database.getNomBase(), 0), false, null);
        this.cbAgence.setModel(tmp);
        this.cbAgence.setSelectedItem("");
        ComboBoxModel cbm = new ComboBoxModel(Transport.bdd.getConducteurListAgence(database.getNomBase()), false, LanguageTranslator.getString("generics.none"));
        this.cbConducteur.setModel(cbm);
        this.cbConducteur.setSelectedItem("");
        if (this.getCbRestreintAgence().isSelected()) {
            this.getPnlResAgence().load(database, this.currentUser);
        }
    }

    public boolean check() {
        boolean toReturn = true;
        if (this.getTxtNom().getText().equals("")) {
            this.getTxtNom().setBackground(new Color(255, 192, 203));
            this.getTxtNom().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtNom().setBackground(Color.white);
        }
        if (this.getTxtPrenom().getText().equals("")) {
            this.getTxtPrenom().setBackground(new Color(255, 192, 203));
            this.getTxtPrenom().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtPrenom().setBackground(Color.white);
        }
        if (this.getTxtMail().getText().equals("")) {
            this.getTxtMail().setBackground(new Color(255, 192, 203));
            this.getTxtMail().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtMail().setBackground(Color.white);
        }
        return toReturn;
    }

    public boolean updateUser() {
        boolean toReturn = true;
        if (!this.check()) {
            return false;
        }
        int driverId = ((ComboBoxModel)this.getCbConducteur().getModel()).getSelectedCle();
        if (driverId == -1) {
            driverId = 0;
        }
        int profilId = ((ComboBoxModel)this.getCbProfil().getModel()).getSelectedCle();
        int agencyId = ((ComboBoxModel)this.getCbAgence().getModel()).getSelectedCle();
        if (this.currentUser == null || this.currentUser.getCleUser() == 0) {
            String nomS = this.getCbSociete().getSelectedItem().toString();
            this.currentUser = new Utilisateur(this.txtNom.getText(), this.txtPrenom.getText(), profilId, nomS, agencyId, driverId, this.getCbEnabled().isSelected());
            this.currentUser.setRestreintAgence(this.getCbRestreintAgence().isSelected());
            this.currentUser.setRestreintConducteur(this.getCbRestreintConducteur().isSelected());
            this.currentUser.setRestreintSociete(this.getCbRestreintSociete().isSelected());
            this.currentUser.setEmail(this.getTxtMail().getText());
            this.currentUser.setAlerted(this.getCbAlertEnable().isSelected());
            NouvelUtilisateur newUser = new NouvelUtilisateur(this, this.currentUser);
            newUser.setVisible(true);
            if (this.currentUser.getCleUser() == 0) {
                TimsLogger.error("#DAU.updateUser impossible de r\u00e9cup\u00e9rer l'id de l'utilisateur" + this.currentUser.getLogin());
                return false;
            }
            TimsLogger.error("#DAU.updateUser# utilisateur cr\u00e9e " + this.currentUser.getCleUser());
        } else if (!this.currentUser.compareAndUpdate(this.txtNom.getText(), this.txtPrenom.getText(), this.getTxtMail().getText(), this.getCbSociete().getSelectedItem().toString(), this.getCbRestreintSociete().isSelected(), this.getCbRestreintAgence().isSelected(), this.getCbRestreintConducteur().isSelected(), profilId, driverId, this.getCbEnabled().isSelected(), this.currentUser.isEnable() != this.getCbEnabled().isSelected() ? new Date() : this.currentUser.getLastActivationAction(), this.getCbAlertEnable().isSelected())) {
            return false;
        }
        ArrayList<UserWarningActivation> activation = ((TMUserAlert)this.getTblAuto().getModel()).getActivation();
        UserWarningActivation.multipleDelete(this.currentUser.getCleUser(), null);
        for (UserWarningActivation toActive : activation) {
            toActive.setUserId(this.currentUser.getCleUser());
            toActive.insert();
        }
        Vector<Integer> restricted = this.getPnlResAgence().getVectorRestreint();
        AgencyRestriction.multipleDelete(this.currentUser.getCleUser(), null);
        AgencyRestriction.multipleCreate(this.currentUser.getCleUser(), restricted, ((ComboBoxModel)this.getCbSociete().getModel()).getSelectedCle());
        this.refreshListe();
        return toReturn;
    }

    public void refreshListe() {
        this.users = null;
        String companyName = this.getCbFCompany().getSelectedItem().toString();
        if (companyName.equals(LanguageTranslator.getString("generics.none"))) {
            companyName = null;
        }
        this.modeleUser = new LMUser(this.userFilter(this.getUsers(), companyName));
        this.listeUser.setModel(this.modeleUser);
        this.reinit();
    }

    public Vector<Utilisateur> userFilter(Vector<Utilisateur> list, String companyName) {
        Vector<Utilisateur> newList = new Vector<Utilisateur>();
        for (Utilisateur user : list) {
            if (companyName != null && !companyName.equals("") && !user.getSociete().equals(companyName) || !this.getCbDisable().isSelected() && !user.isEnable()) continue;
            newList.add(user);
        }
        return newList;
    }

    private JButton getBtnNouveau() {
        if (this.btnNouveau == null) {
            this.btnNouveau = new JButton();
            this.btnNouveau.setText(LanguageTranslator.getString("button.new"));
            this.btnNouveau.setPreferredSize(new Dimension(90, 26));
            this.btnNouveau.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdministrationUtilisateur.this.reinit();
                }
            });
        }
        return this.btnNouveau;
    }

    public void reinit() {
        this.txtNom.setText("");
        this.txtPrenom.setText("");
        this.txtMail.setText("");
        if (this.defaultProfil != null) {
            this.cbProfil.setSelectedItem(this.defaultProfil.getNomProfil());
        }
        this.getCbEnabled().setSelected(true);
        this.getCbRestreintAgence().setSelected(false);
        this.getCbRestreintConducteur().setSelected(false);
        this.getCbRestreintSociete().setSelected(false);
        this.getTpRes().removeAll();
    }

    private JPanel getPUserInfo() {
        if (this.pUserInfo == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.fill = 1;
            gridBagConstraints14.gridy = 1;
            gridBagConstraints14.weightx = 0.0;
            gridBagConstraints14.weighty = 0.0;
            gridBagConstraints14.gridx = 4;
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.anchor = 10;
            gridBagConstraints24.gridx = 4;
            gridBagConstraints24.gridy = 3;
            gridBagConstraints24.weightx = 0.0;
            gridBagConstraints24.weighty = 0.0;
            gridBagConstraints24.fill = 1;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints21.anchor = 17;
            gridBagConstraints21.gridy = 3;
            this.lblMail = new JLabel();
            this.lblMail.setText(LanguageTranslator.getString("generics.mail"));
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.fill = 2;
            gridBagConstraints16.gridy = 3;
            gridBagConstraints16.weightx = 1.0;
            gridBagConstraints16.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints16.gridx = 1;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.gridwidth = 2;
            gridBagConstraints15.anchor = 17;
            gridBagConstraints15.gridy = 0;
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.gridx = 2;
            gridBagConstraints20.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints20.weighty = 1.0;
            gridBagConstraints20.anchor = 17;
            gridBagConstraints20.gridy = 3;
            this.lblCond = new JLabel();
            this.lblCond.setText(LanguageTranslator.getString("generics.driver"));
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.fill = 2;
            gridBagConstraints19.gridy = 3;
            gridBagConstraints19.weightx = 1.0;
            gridBagConstraints19.weighty = 1.0;
            gridBagConstraints19.gridx = 3;
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 2;
            gridBagConstraints18.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints18.anchor = 17;
            gridBagConstraints18.gridy = 1;
            this.lblAgence = new JLabel();
            this.lblAgence.setText(LanguageTranslator.getString("generics.company"));
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.fill = 2;
            gridBagConstraints17.gridy = 2;
            gridBagConstraints17.weightx = 1.0;
            gridBagConstraints17.weighty = 1.0;
            gridBagConstraints17.gridwidth = 2;
            gridBagConstraints17.gridx = 3;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.fill = 2;
            gridBagConstraints13.gridy = 4;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.weighty = 1.0;
            gridBagConstraints13.gridwidth = 2;
            gridBagConstraints13.gridx = 3;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.gridy = 1;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints11.gridwidth = 1;
            gridBagConstraints11.gridx = 3;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 2;
            gridBagConstraints12.anchor = 17;
            gridBagConstraints12.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints12.weighty = 1.0;
            gridBagConstraints12.gridy = 4;
            this.lblProfil = new JLabel();
            this.lblProfil.setText(LanguageTranslator.getString("profil"));
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 2;
            gridBagConstraints10.weightx = 0.0;
            gridBagConstraints10.weighty = 1.0;
            gridBagConstraints10.anchor = 17;
            gridBagConstraints10.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints10.gridy = 2;
            this.lblSociete = new JLabel();
            this.lblSociete.setText(LanguageTranslator.getString("generics.agency"));
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.weightx = 0.0;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints9.gridy = 2;
            this.lblPrenom = new JLabel();
            this.lblPrenom.setText(LanguageTranslator.getString("user.firstName"));
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.weightx = 0.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints8.gridy = 1;
            this.lblNom = new JLabel();
            this.lblNom.setText(LanguageTranslator.getString("user.lastName"));
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridy = 2;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.weighty = 1.0;
            gridBagConstraints7.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints6.gridx = 1;
            this.pUserInfo = new JPanel();
            this.pUserInfo.setLayout(new GridBagLayout());
            this.pUserInfo.setBorder(BorderFactory.createLineBorder(SystemColor.activeCaption, 1));
            this.pUserInfo.setPreferredSize(new Dimension(0, 0));
            this.pUserInfo.add((Component)this.getTxtNom(), gridBagConstraints6);
            this.pUserInfo.add((Component)this.getTxtPrenom(), gridBagConstraints7);
            this.pUserInfo.add((Component)this.lblNom, gridBagConstraints8);
            this.pUserInfo.add((Component)this.lblPrenom, gridBagConstraints9);
            this.pUserInfo.add((Component)this.lblSociete, gridBagConstraints10);
            this.pUserInfo.add((Component)this.lblProfil, gridBagConstraints12);
            this.pUserInfo.add((Component)this.getCbSociete(), gridBagConstraints11);
            this.pUserInfo.add((Component)this.getCbProfil(), gridBagConstraints13);
            this.pUserInfo.add((Component)this.getCbAgence(), gridBagConstraints17);
            this.pUserInfo.add((Component)this.lblAgence, gridBagConstraints18);
            this.pUserInfo.add((Component)this.getCbConducteur(), gridBagConstraints19);
            this.pUserInfo.add((Component)this.lblCond, gridBagConstraints20);
            this.pUserInfo.add((Component)this.getCbEnabled(), gridBagConstraints15);
            this.pUserInfo.add((Component)this.getTxtMail(), gridBagConstraints16);
            this.pUserInfo.add((Component)this.lblMail, gridBagConstraints21);
            this.pUserInfo.add((Component)this.getCbRestreintConducteur(), gridBagConstraints24);
            this.pUserInfo.add((Component)this.getCbRestreintSociete(), gridBagConstraints14);
        }
        return this.pUserInfo;
    }

    private JTextField getTxtNom() {
        if (this.txtNom == null) {
            this.txtNom = new JTextField();
            this.txtNom.setPreferredSize(new Dimension(0, 20));
        }
        return this.txtNom;
    }

    private JTextField getTxtPrenom() {
        if (this.txtPrenom == null) {
            this.txtPrenom = new JTextField();
            this.txtPrenom.setPreferredSize(new Dimension(0, 20));
        }
        return this.txtPrenom;
    }

    private JComboBox getCbAgence() {
        if (this.cbAgence == null) {
            this.cbAgence = new JComboBox();
            ComboBoxModel tmp = new ComboBoxModel(Agence.getList(), false, LanguageTranslator.getString("generics.none"));
            this.cbAgence.setModel(tmp);
            this.cbAgence.setPreferredSize(new Dimension(0, 20));
        }
        return this.cbAgence;
    }

    private JComboBox getCbProfil() {
        if (this.cbProfil == null) {
            this.cbProfil = new JComboBox();
            this.cbProfil.setPreferredSize(new Dimension(0, 20));
            this.cbProfil.setEditable(false);
            Vector<Profil> tmp = Transport.bdd.getProfil();
            this.cbProfil.setModel(new ComboBoxModel(tmp, false, null));
            for (Profil p : tmp) {
                if (!p.isDefault()) continue;
                this.defaultProfil = p;
                break;
            }
            if (this.defaultProfil != null) {
                this.cbProfil.setSelectedItem(this.defaultProfil.getNomProfil());
            }
        }
        return this.cbProfil;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.setMnemonic(0);
            this.btnEnregistrer.setPreferredSize(new Dimension(98, 26));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdministrationUtilisateur.this.updateUser();
                    JOptionPane.showMessageDialog(DialogAdministrationUtilisateur.this.getParent(), LanguageTranslator.getString("message.done"), LanguageTranslator.getString("message.saveSucceed"), 1);
                }
            });
        }
        return this.btnEnregistrer;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdministrationUtilisateur.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JComboBox getCbSociete() {
        if (this.cbSociete == null) {
            this.cbSociete = new JComboBox();
            this.cbSociete.setPreferredSize(new Dimension(0, 20));
            ComboBoxModel tmp = new ComboBoxModel(this.getCompanies(), true, null);
            this.cbSociete.setModel(tmp);
            this.cbSociete.setEditable(false);
            String currentSoc = Transport.bdd.getCompany().getNomSociete();
            this.cbSociete.setSelectedItem(currentSoc);
            this.cbSociete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdministrationUtilisateur.this.reloadComboBox();
                }
            });
        }
        return this.cbSociete;
    }

    private JComboBox getCbConducteur() {
        if (this.cbConducteur == null) {
            this.cbConducteur = new JComboBox();
            ComboBoxModel cbm = new ComboBoxModel(Transport.bdd.getConducteurListAgence(""), false, LanguageTranslator.getString("generics.none"));
            this.cbConducteur.setModel(cbm);
            this.cbConducteur.setPreferredSize(new Dimension(0, 20));
        }
        return this.cbConducteur;
    }

    private JScrollPane getJsp() {
        if (this.jsp == null) {
            this.jsp = new JScrollPane();
            this.jsp.setPreferredSize(new Dimension(0, 0));
            this.jsp.setViewportView(this.getListeUser());
        }
        return this.jsp;
    }

    private JPanel getTpRes() {
        if (this.tpRes == null) {
            this.tpRes = new JPanel();
            this.tpRes.setBorder(BorderFactory.createLineBorder(SystemColor.activeCaption, 1));
        }
        return this.tpRes;
    }

    private PnlRestrictionAgence getPnlResAgence() {
        if (this.pnlResAgence == null) {
            this.pnlResAgence = new PnlRestrictionAgence();
        }
        return this.pnlResAgence;
    }

    private JPanel getPnlRestriction() {
        if (this.pnlRestriction == null) {
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.fill = 1;
            gridBagConstraints22.gridx = 0;
            gridBagConstraints22.gridy = 1;
            gridBagConstraints22.weightx = 1.0;
            gridBagConstraints22.weighty = 1.0;
            gridBagConstraints22.gridwidth = 3;
            gridBagConstraints22.insets = new Insets(0, 3, 3, 3);
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.gridx = 1;
            gridBagConstraints23.fill = 1;
            gridBagConstraints23.weightx = 1.0;
            gridBagConstraints23.weighty = 0.0;
            gridBagConstraints23.anchor = 10;
            gridBagConstraints23.gridy = 0;
            this.pnlRestriction = new JPanel();
            this.pnlRestriction.setLayout(new GridBagLayout());
            CheckBoxBorder border = new CheckBoxBorder(this.getCbRestreintAgence(), this.pnlRestriction, BorderFactory.createLineBorder(SystemColor.activeCaption, 1));
            this.pnlRestriction.setBorder(border);
            this.pnlRestriction.add((Component)this.getTpRes(), gridBagConstraints22);
        }
        return this.pnlRestriction;
    }

    private JCheckBox getCbRestreintSociete() {
        if (this.cbRestreintSociete == null) {
            this.cbRestreintSociete = new JCheckBox();
            this.cbRestreintSociete.setText(LanguageTranslator.getString("generics.restrict"));
        }
        return this.cbRestreintSociete;
    }

    private JCheckBox getCbRestreintAgence() {
        if (this.cbRestreintAgence == null) {
            this.cbRestreintAgence = new JCheckBox();
            this.cbRestreintAgence.setText(LanguageTranslator.getString("generics.restriction.agency"));
            this.cbRestreintAgence.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DialogAdministrationUtilisateur.this.getCbRestreintSociete().setSelected(true);
                        if (DialogAdministrationUtilisateur.this.getCbSociete().getSelectedIndex() != -1) {
                            Societe database = (Societe)((ComboBoxModel)DialogAdministrationUtilisateur.this.getCbSociete().getModel()).getObjectAt(DialogAdministrationUtilisateur.this.getCbSociete().getSelectedIndex());
                            DialogAdministrationUtilisateur.this.getPnlResAgence().load(database, DialogAdministrationUtilisateur.this.currentUser);
                            DialogAdministrationUtilisateur.this.getTpRes().setLayout(new BorderLayout());
                            DialogAdministrationUtilisateur.this.getTpRes().add(DialogAdministrationUtilisateur.this.getPnlResAgence());
                            DialogAdministrationUtilisateur.this.getTpRes().validate();
                        }
                    } else {
                        DialogAdministrationUtilisateur.this.getTpRes().removeAll();
                    }
                }
            });
        }
        return this.cbRestreintAgence;
    }

    private JCheckBox getCbRestreintConducteur() {
        if (this.cbRestreintConducteur == null) {
            this.cbRestreintConducteur = new JCheckBox();
            this.cbRestreintConducteur.setText(LanguageTranslator.getString("generics.restrict"));
        }
        return this.cbRestreintConducteur;
    }

    private JButton getBtnChangePasse() {
        if (this.btnChangePasse == null) {
            this.btnChangePasse = new JButton();
            this.btnChangePasse.setText(LanguageTranslator.getString("button.changePwd"));
            this.btnChangePasse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdministrationUtilisateur.this.afficheDialog();
                }
            });
        }
        return this.btnChangePasse;
    }

    public void afficheDialog() {
        new DialogChangementMdp(this, this.currentUser).setVisible(true);
    }

    private JButton getBtnExport() {
        if (this.btnExport == null) {
            this.btnExport = new JButton(LanguageTranslator.getString("button.export"));
            this.btnExport.addActionListener(new ActionListener(){

                private HashMap<String, Object> getPrefilled(Utilisateur user) {
                    HashMap<String, Object> userData = new HashMap<String, Object>();
                    userData.put(LanguageTranslator.getString("user.login"), user.getLogin());
                    userData.put(LanguageTranslator.getString("user.lastName"), user.getNom());
                    userData.put(LanguageTranslator.getString("user.firstName"), user.getPrenom());
                    userData.put(LanguageTranslator.getString("generics.company"), user.getSociete());
                    userData.put(LanguageTranslator.getString("profil"), ((ComboBoxModel)DialogAdministrationUtilisateur.this.getCbProfil().getModel()).getLabel(user.getCleProfil()));
                    userData.put(LanguageTranslator.getString("generics.restriction.company"), user.isRestreintSociete() ? "1" : "0");
                    userData.put(LanguageTranslator.getString("generics.restriction.agency"), user.isRestreintAgence() ? "1" : "0");
                    userData.put(LanguageTranslator.getString("generics.restriction.driver"), user.isRestreintConducteur() ? "1" : "0");
                    userData.put(LanguageTranslator.getString("generics.enable"), user.isEnable() ? "1" : "0");
                    userData.put(LanguageTranslator.getString("user.lastActivationAction"), user.getLastActivationAction());
                    return userData;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrayList data = new ArrayList();
                    Vector<Agence> agencies = Agence.loadList(null, 0);
                    for (Utilisateur user : DialogAdministrationUtilisateur.this.userFilter(DialogAdministrationUtilisateur.this.getUsers(), DialogAdministrationUtilisateur.this.getCbFCompany().getSelectedItem().toString())) {
                        TimsLogger.debug("#DialogAdministration.# user " + user.getNom() + " " + user.getLogin());
                        if (!user.isRestreintAgence()) {
                            HashMap<String, Object> userData = this.getPrefilled(user);
                            userData.put(LanguageTranslator.getString("generics.agency"), "TOUTES");
                            data.add(userData);
                            continue;
                        }
                        if (user.getResAgence().size() == 0) {
                            HashMap<String, Object> userData = this.getPrefilled(user);
                            userData.put(LanguageTranslator.getString("generics.agency"), "AUCUNE");
                            data.add(userData);
                            continue;
                        }
                        boolean first = false;
                        for (Integer agencyId : user.getResAgence()) {
                            Agence agency = Agence.find(agencies, agencyId);
                            HashMap<String, Object> userData = null;
                            if (!first) {
                                userData = this.getPrefilled(user);
                                first = true;
                            } else {
                                userData = new HashMap();
                            }
                            userData.put(LanguageTranslator.getString("generics.agency"), agency == null ? "Agence introuvable " + agencyId : agency.getDescription());
                            data.add(userData);
                        }
                    }
                    CustomReport cr = CustomReportFactory.getGeneric(LanguageTranslator.getString("user"));
                    cr.setColumn(CustomReportFactory.getDefaultUserColumn());
                    Fonctions.tblToReport(cr, null, data, "xls");
                }
            });
        }
        return this.btnExport;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new FlowLayout());
            this.pnlBtn.add((Component)this.getBtnQuitter(), null);
            this.pnlBtn.add((Component)this.getBtnChangePasse(), null);
            this.pnlBtn.add((Component)this.getBtnExport(), null);
            this.pnlBtn.add((Component)this.getBtnEnregistrer(), null);
        }
        return this.pnlBtn;
    }

    private JCheckBox getCbEnabled() {
        if (this.cbEnabled == null) {
            this.cbEnabled = new JCheckBox();
            this.cbEnabled.setText(LanguageTranslator.getString("generics.enable"));
        }
        return this.cbEnabled;
    }

    private JTextField getTxtMail() {
        if (this.txtMail == null) {
            this.txtMail = new JTextField();
            this.txtMail.setPreferredSize(new Dimension(0, 20));
        }
        return this.txtMail;
    }

    private JCheckBox getCbAlertEnable() {
        if (this.cbAlertEnable == null) {
            this.cbAlertEnable = new JCheckBox();
            this.cbAlertEnable.setText(LanguageTranslator.getString("generics.alert"));
            this.cbAlertEnable.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean enable = DialogAdministrationUtilisateur.this.getCbAlertEnable().isSelected();
                    DialogAdministrationUtilisateur.this.getTblAuto().setEnabled(enable);
                    if (!enable) {
                        DialogAdministrationUtilisateur.this.getTblAuto().setForeground(SystemColor.inactiveCaption);
                        DialogAdministrationUtilisateur.this.getTblAuto().setBackground(DialogAdministrationUtilisateur.this.jspWarn.getBackground());
                        ((TMUserAlert)DialogAdministrationUtilisateur.this.getTblAuto().getModel()).setActivation(new ArrayList<UserWarningActivation>());
                    } else {
                        DialogAdministrationUtilisateur.this.getTblAuto().setBackground(SystemColor.white);
                        DialogAdministrationUtilisateur.this.getTblAuto().setForeground(SystemColor.black);
                    }
                    DialogAdministrationUtilisateur.this.getPnlAutomaticWarning().repaint();
                }
            });
        }
        return this.cbAlertEnable;
    }

    private JComboBox getCbFCompany() {
        if (this.cbFCompany == null) {
            this.cbFCompany = Fonctions.getCustomizedCB();
            this.cbFCompany.setPreferredSize(new Dimension(0, 20));
            this.cbFCompany.setModel(new ComboBoxModel(this.getCompanies(), true, LanguageTranslator.getString("generics.none")));
            this.cbFCompany.setEditable(false);
            this.cbFCompany.setEnabled(false);
            this.cbFCompany.setSelectedItem(Transport.bdd.getCompany().getNomSociete());
            this.cbFCompany.setSelectedItem(BddTransport.getInstance().getCompany());
            this.cbFCompany.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdministrationUtilisateur.this.refreshListe();
                }
            });
        }
        return this.cbFCompany;
    }

    private Vector<Societe> getCompanies() {
        if (this.companies == null) {
            this.companies = Societe.loadList(null);
        }
        return this.companies;
    }

    private Vector<Utilisateur> getUsers() {
        if (this.users == null) {
            this.users = Utilisateur.list("");
        }
        return this.users;
    }

    private JPanel getPnlAutomaticWarning() {
        if (this.pnlAutomaticWarning == null) {
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.fill = 1;
            gridBagConstraints41.gridy = 0;
            gridBagConstraints41.weightx = 1.0;
            gridBagConstraints41.weighty = 1.0;
            gridBagConstraints41.gridx = 0;
            gridBagConstraints41.insets = new Insets(0, 3, 3, 3);
            this.pnlAutomaticWarning = new JPanel();
            this.pnlAutomaticWarning.setLayout(new GridBagLayout());
            CheckBoxBorder border = new CheckBoxBorder(this.getCbAlertEnable(), this.pnlAutomaticWarning, BorderFactory.createLineBorder(SystemColor.activeCaption, 1));
            this.pnlAutomaticWarning.setBorder(border);
            this.pnlAutomaticWarning.add((Component)this.getJspWarn(), gridBagConstraints41);
        }
        return this.pnlAutomaticWarning;
    }

    private JScrollPane getJspWarn() {
        if (this.jspWarn == null) {
            this.jspWarn = new JScrollPane();
            this.jspWarn.setViewportView(this.getTblAuto());
        }
        return this.jspWarn;
    }

    private JTable getTblAuto() {
        if (this.tblAuto == null) {
            this.tblAuto = new JTable();
            this.tblAuto.setForeground(SystemColor.inactiveCaption);
            this.tblAuto.setBackground(this.jspWarn.getBackground());
            this.tblAuto.setEnabled(false);
            this.tblAuto.setModel(new TMUserAlert(DAOFactory.getDAOAutomaticWarning().list()));
            this.tblAuto.getColumnModel().getColumn(1).setMaxWidth(25);
        }
        return this.tblAuto;
    }

    private JCheckBox getCbDisable() {
        if (this.cbDisable == null) {
            this.cbDisable = new JCheckBox();
            this.cbDisable.setSelected(true);
            this.cbDisable.setText(LanguageTranslator.getString("user.disable"));
            this.cbDisable.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DialogAdministrationUtilisateur.this.refreshListe();
                }
            });
        }
        return this.cbDisable;
    }
}

