/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.agence;

import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.AgencyType;
import fr.pgh.data.bdd.GlobalCalendar;
import fr.pgh.data.bdd.Pays;
import fr.pgh.data.bdd.Region;
import fr.pgh.data.bdd.TailleAgence;
import fr.pgh.data.bdd.TypeAgence;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogCreationAgence
extends JDialog
implements DataListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlInformations = null;
    private JPanel pnlBtn = null;
    private JButton btnEnregistrer = null;
    private JButton btnAnnuler = null;
    private JPanel pnlAddress = null;
    private JLabel lblStreet = null;
    private JLabel lblCP = null;
    private JTextField txtCP = null;
    private JLabel lblCity = null;
    private JTextField txtCity = null;
    private JTextPane txtAddress = null;
    private JPanel pnlOther = null;
    private JLabel lblPhone = null;
    private JTextField txtPhone = null;
    private JLabel lblPhone2 = null;
    private JTextField txtPhone2 = null;
    private JLabel lblFax = null;
    private JTextField txtFax = null;
    private JTextField txtEmail = null;
    private JLabel lblSecuriteSociale = null;
    private JLabel lblCountry = null;
    private JComboBox cbCountry = null;
    private JPanel pnlName = null;
    private JLabel lblName = null;
    private JLabel lblCode = null;
    private JTextField txtName = null;
    private JTextField txtCode = null;
    private JLabel lblType = null;
    private JLabel lblSize = null;
    private JComboBox cbType = null;
    private JComboBox cbSize = null;
    private JButton btnAddType = null;
    private JButton btnAddSize = null;
    private ImageIcon imgAdd = null;
    private Agence current = null;
    private JTextField txtOpening = null;
    private JLabel lblOpening = null;
    private JLabel lblClose = null;
    private JTextField txtClose = null;
    public boolean enregistrement = false;
    private JComboBox cbRegion = null;
    private JLabel lblRegion = null;
    private JCheckBox cbSatWorking = null;
    private JLabel lblSatWorking = null;
    private JLabel lblCld = null;
    private JComboBox cbDefaultCalendar = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogCreationAgence.dispose()#");
        super.dispose();
    }

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        if (dataEvent instanceof BddEvent) {
            BddEvent e = (BddEvent)dataEvent;
            if (e.getTable().equals("AGENCY_TYPE")) {
                this.getCbType().setModel(new ComboBoxModel(AgencyType.getList(), false, LanguageTranslator.getString("generics.none")));
            }
            if (e.getTable().equals("CALENDAR")) {
                this.getCbDefaultCalendar().setModel(new ComboBoxModel(GlobalCalendar.loadList(), false, LanguageTranslator.getString("generics.none")));
            }
            if (e.getTable().equals("region")) {
                this.getCbRegion().setModel(new ComboBoxModel(Region.loadList(((ComboBoxModel)this.getCbCountry().getModel()).getSelectedCle()), false, LanguageTranslator.getString("generics.none")));
            }
            if (e.getTable().equals("t_taille_agence")) {
                this.getCbSize().setModel(new ComboBoxModel(BddTransport.getInstance().getTailleAgence(), false, LanguageTranslator.getString("generics.none")));
            }
        }
    }

    public DialogCreationAgence(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogCreationAgence()#");
        this.initialize();
        Transport.bdd.addDataListener(this);
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    private void initialize() {
        this.setBounds(new Rectangle(0, 0, 620, 380));
        this.setModal(true);
        this.setTitle(LanguageTranslator.getString("agency.create.title"));
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlInformations(), gridBagConstraints);
            this.jContentPane.add((Component)this.getPnlBtn(), gridBagConstraints2);
        }
        return this.jContentPane;
    }

    private JPanel getPnlInformations() {
        if (this.pnlInformations == null) {
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 0;
            gridBagConstraints18.weightx = 1.0;
            gridBagConstraints18.weighty = 1.0;
            gridBagConstraints18.fill = 1;
            gridBagConstraints18.gridwidth = 2;
            gridBagConstraints18.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            this.pnlInformations = new JPanel();
            this.pnlInformations.setLayout(new GridBagLayout());
            this.pnlInformations.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("agency.information"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlInformations.add((Component)this.getPnlAddress(), gridBagConstraints1);
            this.pnlInformations.add((Component)this.getPnlOther(), gridBagConstraints3);
            this.pnlInformations.add((Component)this.getPnlName(), gridBagConstraints18);
        }
        return this.pnlInformations;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints19.gridy = 0;
            gridBagConstraints19.gridx = 0;
            GridBagConstraints gridBagConstraints65 = new GridBagConstraints();
            gridBagConstraints65.anchor = 10;
            gridBagConstraints65.gridx = 1;
            gridBagConstraints65.gridy = 0;
            gridBagConstraints65.weightx = 1.0;
            gridBagConstraints65.weighty = 1.0;
            gridBagConstraints65.insets = new Insets(0, 5, 5, 0);
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnEnregistrer(), gridBagConstraints65);
            this.pnlBtn.add((Component)this.getBtnAnnuler(), gridBagConstraints19);
        }
        return this.pnlBtn;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogCreationAgence.this.enregistrer();
                }
            });
        }
        return this.btnEnregistrer;
    }

    public void enregistrer() {
        if (!this.check()) {
            return;
        }
        if (this.current == null) {
            this.current = new Agence(0);
        }
        this.current.setDescription(this.getTxtName().getText());
        this.current.setCleInterneAgence(this.getTxtCode().getText());
        this.current.setAdresse(this.getTxtAddress().getText());
        this.current.setCodePostal(this.getTxtCP().getText());
        this.current.setVille(this.getTxtCity().getText());
        this.current.setClePays(((ComboBoxModel)this.getCbCountry().getModel()).getSelectedCle());
        this.current.setTel1(this.getTxtPhone().getText());
        this.current.setTel2(this.getTxtPhone2().getText());
        this.current.setFax(this.getTxtFax().getText());
        this.current.setEmail(this.getTxtEmail().getText());
        this.current.setDateDebut(ConversionTime.dateFromFranceToBDD(this.getTxtOpening().getText(), false));
        this.current.setDateFin(ConversionTime.dateFromFranceToBDD(this.getTxtClose().getText(), false));
        this.current.setCleTailleAgence(((ComboBoxModel)this.getCbSize().getModel()).getSelectedCle());
        this.current.setCleTypeAgence(((ComboBoxModel)this.getCbType().getModel()).getSelectedCle());
        this.current.setSatWork(this.getCbSatWorking().isSelected());
        this.current.setRegionId(((ComboBoxModel)this.getCbRegion().getModel()).getSelectedCle());
        this.current.setDefaultCalendarId(((ComboBoxModel)this.getCbDefaultCalendar().getModel()).getSelectedCle());
        try {
            float[] position;
            String fullAddress = String.valueOf(this.getTxtAddress().getText()) + " " + this.getTxtCP().getText() + " " + this.getTxtCity().getText();
            if (!fullAddress.trim().equals("") && (position = Fonctions.getCoordinates(fullAddress)) != null) {
                this.current.setLongitude(position[0]);
                this.current.setLatitude(position[1]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TimsLogger.error("#DCC.add# erreur getPosition");
        }
        if (this.current.insert()) {
            this.enregistrement = true;
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveSucceed"), LanguageTranslator.getString("message.done"), 1);
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveError"), LanguageTranslator.getString("message.saveError"), 0);
        }
    }

    public boolean check() {
        boolean toReturn = true;
        if (this.getTxtCode().getText().length() > 4) {
            this.getTxtCode().setBackground(new Color(255, 192, 203));
            this.getTxtCode().setToolTipText(LanguageTranslator.getString("generics.maxAuthorised", "4"));
            toReturn = false;
        } else {
            this.getTxtCode().setBackground(Color.white);
        }
        if (this.getTxtName().getText().equals("")) {
            this.getTxtName().setBackground(new Color(255, 192, 203));
            this.getTxtName().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtName().setBackground(Color.white);
        }
        return toReturn;
    }

    private JButton getBtnAnnuler() {
        if (this.btnAnnuler == null) {
            this.btnAnnuler = new JButton();
            this.btnAnnuler.setText(LanguageTranslator.getString("button.quit"));
            this.btnAnnuler.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogCreationAgence.this.dispose();
                }
            });
        }
        return this.btnAnnuler;
    }

    private JPanel getPnlAddress() {
        if (this.pnlAddress == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridy = 2;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.gridwidth = 3;
            gridBagConstraints6.insets = new Insets(0, 3, 0, 3);
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 2;
            this.lblCountry = new JLabel();
            this.lblCountry.setText(LanguageTranslator.getString("generics.country"));
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.fill = 1;
            gridBagConstraints13.gridwidth = 3;
            gridBagConstraints13.gridx = 1;
            gridBagConstraints13.gridy = 0;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.weighty = 1.0;
            gridBagConstraints13.insets = new Insets(0, 5, 5, 5);
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.fill = 2;
            gridBagConstraints17.gridx = 3;
            gridBagConstraints17.gridy = 1;
            gridBagConstraints17.weightx = 0.0;
            gridBagConstraints17.insets = new Insets(0, 3, 0, 3);
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.insets = new Insets(0, 3, 0, 3);
            gridBagConstraints16.gridy = 1;
            gridBagConstraints16.gridx = 2;
            this.lblCity = new JLabel();
            this.lblCity.setText(LanguageTranslator.getString("generics.city"));
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.fill = 0;
            gridBagConstraints15.gridx = 1;
            gridBagConstraints15.gridy = 1;
            gridBagConstraints15.weightx = 0.0;
            gridBagConstraints15.insets = new Insets(0, 3, 0, 3);
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.fill = 2;
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.gridy = 1;
            gridBagConstraints14.insets = new Insets(0, 3, 0, 3);
            this.lblCP = new JLabel();
            this.lblCP.setText(LanguageTranslator.getString("generics.cp"));
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.anchor = 11;
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.gridy = 0;
            gridBagConstraints10.insets = new Insets(0, 3, 0, 3);
            this.lblStreet = new JLabel();
            this.lblStreet.setText(LanguageTranslator.getString("generics.street"));
            this.pnlAddress = new JPanel();
            this.pnlAddress.setLayout(new GridBagLayout());
            this.pnlAddress.setPreferredSize(new Dimension(330, 150));
            this.pnlAddress.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.address"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlAddress.add((Component)this.lblStreet, gridBagConstraints10);
            this.pnlAddress.add((Component)this.lblCP, gridBagConstraints14);
            this.pnlAddress.add((Component)this.getTxtCP(), gridBagConstraints15);
            this.pnlAddress.add((Component)this.lblCity, gridBagConstraints16);
            this.pnlAddress.add((Component)this.getTxtCity(), gridBagConstraints17);
            this.pnlAddress.add((Component)this.getTxtAddress(), gridBagConstraints13);
            this.pnlAddress.add((Component)this.lblCountry, gridBagConstraints4);
            this.pnlAddress.add((Component)this.getCbCountry(), gridBagConstraints6);
        }
        return this.pnlAddress;
    }

    private JTextField getTxtCP() {
        if (this.txtCP == null) {
            this.txtCP = new JTextField();
            this.txtCP.setPreferredSize(new Dimension(40, 20));
            this.txtCP.setMinimumSize(new Dimension(40, 20));
            this.txtCP.setText("");
        }
        return this.txtCP;
    }

    private JTextField getTxtCity() {
        if (this.txtCity == null) {
            this.txtCity = new JTextField();
        }
        return this.txtCity;
    }

    private JTextPane getTxtAddress() {
        if (this.txtAddress == null) {
            this.txtAddress = new JTextPane();
        }
        return this.txtAddress;
    }

    private JPanel getPnlOther() {
        if (this.pnlOther == null) {
            GridBagConstraints gridBagConstraints67 = new GridBagConstraints();
            gridBagConstraints67.anchor = 10;
            gridBagConstraints67.gridx = 1;
            gridBagConstraints67.gridy = 3;
            gridBagConstraints67.weightx = 1.0;
            gridBagConstraints67.fill = 2;
            GridBagConstraints gridBagConstraints66 = new GridBagConstraints();
            gridBagConstraints66.anchor = 17;
            gridBagConstraints66.gridy = 3;
            gridBagConstraints66.weightx = 0.0;
            gridBagConstraints66.weighty = 1.0;
            gridBagConstraints66.fill = 0;
            gridBagConstraints66.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints66.gridx = 0;
            this.lblSecuriteSociale = new JLabel();
            this.lblSecuriteSociale.setText(LanguageTranslator.getString("generics.mail"));
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.anchor = 13;
            gridBagConstraints12.gridx = 1;
            gridBagConstraints12.gridy = 2;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.weighty = 1.0;
            gridBagConstraints12.fill = 2;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.gridy = 2;
            gridBagConstraints11.fill = 0;
            this.lblFax = new JLabel();
            this.lblFax.setText(LanguageTranslator.getString("generics.fax"));
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.anchor = 13;
            gridBagConstraints9.gridx = 1;
            gridBagConstraints9.gridy = 1;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.fill = 2;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 1;
            gridBagConstraints7.fill = 0;
            this.lblPhone2 = new JLabel();
            this.lblPhone2.setText(LanguageTranslator.getString("generics.mobile"));
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.fill = 2;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints5.gridx = -1;
            gridBagConstraints5.gridy = -1;
            gridBagConstraints5.fill = 0;
            this.lblPhone = new JLabel();
            this.lblPhone.setText(LanguageTranslator.getString("generics.phone"));
            this.pnlOther = new JPanel();
            this.pnlOther.setLayout(new GridBagLayout());
            this.pnlOther.add((Component)this.lblPhone, gridBagConstraints5);
            this.pnlOther.add((Component)this.getTxtPhone(), gridBagConstraints8);
            this.pnlOther.add((Component)this.lblPhone2, gridBagConstraints7);
            this.pnlOther.add((Component)this.getTxtPhone2(), gridBagConstraints9);
            this.pnlOther.add((Component)this.lblFax, gridBagConstraints11);
            this.pnlOther.add((Component)this.getTxtFax(), gridBagConstraints12);
            this.pnlOther.add((Component)this.lblSecuriteSociale, gridBagConstraints66);
            this.pnlOther.add((Component)this.getTxtEmail(), gridBagConstraints67);
        }
        return this.pnlOther;
    }

    private JTextField getTxtPhone() {
        if (this.txtPhone == null) {
            this.txtPhone = new JTextField();
            this.txtPhone.setPreferredSize(new Dimension(80, 20));
        }
        return this.txtPhone;
    }

    private JTextField getTxtPhone2() {
        if (this.txtPhone2 == null) {
            this.txtPhone2 = new JTextField();
            this.txtPhone2.setPreferredSize(new Dimension(80, 20));
            this.txtPhone2.setText("");
        }
        return this.txtPhone2;
    }

    private JTextField getTxtFax() {
        if (this.txtFax == null) {
            this.txtFax = new JTextField();
            this.txtFax.setPreferredSize(new Dimension(80, 20));
        }
        return this.txtFax;
    }

    private JTextField getTxtEmail() {
        if (this.txtEmail == null) {
            this.txtEmail = new JTextField();
        }
        return this.txtEmail;
    }

    private JComboBox getCbCountry() {
        if (this.cbCountry == null) {
            this.cbCountry = new JComboBox();
            this.cbCountry.setModel(new ComboBoxModel(Pays.getVector(), false, LanguageTranslator.getString("generics.none")));
            this.cbCountry.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                }
            });
        }
        return this.cbCountry;
    }

    private JPanel getPnlName() {
        if (this.pnlName == null) {
            GridBagConstraints gridBagConstraints39 = new GridBagConstraints();
            gridBagConstraints39.fill = 2;
            gridBagConstraints39.gridy = 3;
            gridBagConstraints39.weightx = 1.0;
            gridBagConstraints39.gridx = 3;
            GridBagConstraints gridBagConstraints38 = new GridBagConstraints();
            gridBagConstraints38.gridx = 2;
            gridBagConstraints38.gridy = 3;
            this.lblCld = new JLabel();
            this.lblCld.setText(LanguageTranslator.getString("generics.calendar"));
            GridBagConstraints gridBagConstraints37 = new GridBagConstraints();
            gridBagConstraints37.gridx = 0;
            gridBagConstraints37.gridy = 3;
            this.lblSatWorking = new JLabel();
            this.lblSatWorking.setText(LanguageTranslator.getString("agency.satOpen"));
            GridBagConstraints gridBagConstraints36 = new GridBagConstraints();
            gridBagConstraints36.fill = 2;
            gridBagConstraints36.weightx = 1.0;
            gridBagConstraints36.gridx = 1;
            gridBagConstraints36.gridy = 3;
            GridBagConstraints gridBagConstraints35 = new GridBagConstraints();
            gridBagConstraints35.gridx = 0;
            gridBagConstraints35.gridy = 4;
            this.lblRegion = new JLabel();
            this.lblRegion.setText(LanguageTranslator.getString("generics.region"));
            GridBagConstraints gridBagConstraints34 = new GridBagConstraints();
            gridBagConstraints34.fill = 2;
            gridBagConstraints34.gridy = 4;
            gridBagConstraints34.weightx = 1.0;
            gridBagConstraints34.gridx = 1;
            GridBagConstraints gridBagConstraints33 = new GridBagConstraints();
            gridBagConstraints33.fill = 2;
            gridBagConstraints33.gridy = 2;
            gridBagConstraints33.weightx = 1.0;
            gridBagConstraints33.gridx = 3;
            GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
            gridBagConstraints32.gridx = 2;
            gridBagConstraints32.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints32.gridy = 2;
            this.lblClose = new JLabel();
            this.lblClose.setText(LanguageTranslator.getString("agency.closing"));
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.weighty = 1.0;
            gridBagConstraints31.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints31.gridy = 2;
            this.lblOpening = new JLabel();
            this.lblOpening.setText(LanguageTranslator.getString("agency.opening"));
            GridBagConstraints gridBagConstraints30 = new GridBagConstraints();
            gridBagConstraints30.gridy = 2;
            gridBagConstraints30.gridx = 1;
            GridBagConstraints gridBagConstraints29 = new GridBagConstraints();
            gridBagConstraints29.gridx = 4;
            gridBagConstraints29.gridy = 2;
            GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
            gridBagConstraints28.gridx = 4;
            gridBagConstraints28.gridy = 1;
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.fill = 2;
            gridBagConstraints27.gridy = 1;
            gridBagConstraints27.weightx = 1.0;
            gridBagConstraints27.gridx = 3;
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.fill = 2;
            gridBagConstraints26.gridy = 0;
            gridBagConstraints26.weightx = 1.0;
            gridBagConstraints26.gridx = 3;
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.gridx = 2;
            gridBagConstraints25.gridy = 1;
            this.lblSize = new JLabel();
            this.lblSize.setText(LanguageTranslator.getString("agency.size.title"));
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.gridx = 2;
            gridBagConstraints24.gridy = 0;
            this.lblType = new JLabel();
            this.lblType.setText(LanguageTranslator.getString("agency.type.title"));
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.fill = 2;
            gridBagConstraints23.gridy = 1;
            gridBagConstraints23.weightx = 1.0;
            gridBagConstraints23.gridx = 1;
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.fill = 2;
            gridBagConstraints22.gridy = 0;
            gridBagConstraints22.weightx = 1.0;
            gridBagConstraints22.gridx = 1;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.weighty = 1.0;
            gridBagConstraints21.gridy = 1;
            this.lblCode = new JLabel();
            this.lblCode.setText(LanguageTranslator.getString("generics.code"));
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.gridx = 0;
            gridBagConstraints20.weighty = 1.0;
            gridBagConstraints20.gridy = 0;
            this.lblName = new JLabel();
            this.lblName.setText(LanguageTranslator.getString("generics.name"));
            this.pnlName = new JPanel();
            this.pnlName.setLayout(new GridBagLayout());
            this.pnlName.add((Component)this.lblName, gridBagConstraints20);
            this.pnlName.add((Component)this.lblCode, gridBagConstraints21);
            this.pnlName.add((Component)this.getTxtName(), gridBagConstraints22);
            this.pnlName.add((Component)this.getTxtCode(), gridBagConstraints23);
            this.pnlName.add((Component)this.lblType, gridBagConstraints25);
            this.pnlName.add((Component)this.lblSize, gridBagConstraints32);
            this.pnlName.add((Component)this.getCbType(), gridBagConstraints27);
            this.pnlName.add((Component)this.getCbSize(), gridBagConstraints33);
            this.pnlName.add((Component)this.getBtnAddType(), gridBagConstraints28);
            this.pnlName.add((Component)this.getBtnAddSize(), gridBagConstraints29);
            this.pnlName.add((Component)this.getTxtOpening(), gridBagConstraints36);
            this.pnlName.add((Component)this.lblOpening, gridBagConstraints37);
            this.pnlName.add((Component)this.lblClose, gridBagConstraints35);
            this.pnlName.add((Component)this.getTxtClose(), gridBagConstraints34);
            this.pnlName.add((Component)this.getCbRegion(), gridBagConstraints26);
            this.pnlName.add((Component)this.lblRegion, gridBagConstraints24);
            this.pnlName.add((Component)this.getCbSatWorking(), gridBagConstraints30);
            this.pnlName.add((Component)this.lblSatWorking, gridBagConstraints31);
            this.pnlName.add((Component)this.lblCld, gridBagConstraints38);
            this.pnlName.add((Component)this.getCbDefaultCalendar(), gridBagConstraints39);
        }
        return this.pnlName;
    }

    private JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
        }
        return this.txtName;
    }

    private JTextField getTxtCode() {
        if (this.txtCode == null) {
            this.txtCode = new JTextField();
        }
        return this.txtCode;
    }

    private JComboBox getCbType() {
        if (this.cbType == null) {
            this.cbType = new JComboBox();
            this.cbType.setModel(new ComboBoxModel(AgencyType.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbType;
    }

    private JComboBox getCbSize() {
        if (this.cbSize == null) {
            this.cbSize = new JComboBox();
            this.cbSize.setModel(new ComboBoxModel(BddTransport.getInstance().getTailleAgence(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbSize;
    }

    private JButton getBtnAddType() {
        if (this.btnAddType == null) {
            this.btnAddType = new JButton();
            this.btnAddType.setIcon(this.getImgAdd());
            this.btnAddType.setPreferredSize(new Dimension(25, 25));
            this.btnAddType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Fonctions.define(TypeAgence.class);
                }
            });
        }
        return this.btnAddType;
    }

    private JButton getBtnAddSize() {
        if (this.btnAddSize == null) {
            this.btnAddSize = new JButton();
            this.btnAddSize.setIcon(this.getImgAdd());
            this.btnAddSize.setPreferredSize(new Dimension(25, 25));
            this.btnAddSize.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Fonctions.define(TailleAgence.class);
                }
            });
        }
        return this.btnAddSize;
    }

    private ImageIcon getImgAdd() {
        if (this.imgAdd == null) {
            ClassLoader cl = this.getClass().getClassLoader();
            this.imgAdd = new ImageIcon(cl.getResource(Transport.res.getResourceString("icone_cliq")));
        }
        return this.imgAdd;
    }

    private JTextField getTxtOpening() {
        if (this.txtOpening == null) {
            this.txtOpening = new JTextField();
            this.txtOpening.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogCreationAgence.this.txtOpening);
                }
            });
        }
        return this.txtOpening;
    }

    private JTextField getTxtClose() {
        if (this.txtClose == null) {
            this.txtClose = new JTextField();
            this.txtClose.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogCreationAgence.this.txtClose);
                }
            });
        }
        return this.txtClose;
    }

    private JComboBox getCbRegion() {
        if (this.cbRegion == null) {
            this.cbRegion = new JComboBox();
            this.cbRegion.setModel(new ComboBoxModel(Region.loadList(((ComboBoxModel)this.getCbCountry().getModel()).getSelectedCle()), true, LanguageTranslator.getString("generics.none")));
            this.cbRegion.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                }
            });
        }
        return this.cbRegion;
    }

    private JCheckBox getCbSatWorking() {
        if (this.cbSatWorking == null) {
            this.cbSatWorking = new JCheckBox();
        }
        return this.cbSatWorking;
    }

    private JComboBox getCbDefaultCalendar() {
        if (this.cbDefaultCalendar == null) {
            this.cbDefaultCalendar = new JComboBox();
            this.cbDefaultCalendar.setModel(new ComboBoxModel(GlobalCalendar.loadList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbDefaultCalendar;
    }
}

