/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.agence;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.exception.TypeContratNotFoundException;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.TMPrintable2;
import transpo.system.ui.modele.TMVehicleAgency;
import transpo.system.ui.renderer.DriverTableRenderer;
import transpo.system.ui.renderer.VehicleTableRenderer;
import transpo.system.ui.views.conducteur.PnlCalendarPopup;

public class GlobalScrollPane
extends JScrollPane {
    public static final int ROW_HEIGHT = 20;
    public static final int DRIVER = 0;
    public static final int VEHICLE = 1;
    private int type = 0;
    private PnlCalendarPopup pcp = null;
    private JTable tbl = null;
    private MouseListener mouseListener = null;

    public GlobalScrollPane(int type) {
        this.type = type;
    }

    public PnlCalendarPopup getPcp() {
        if (this.pcp == null) {
            this.pcp = new PnlCalendarPopup();
        }
        return this.pcp;
    }

    public void defineTable(JTable globalTable, Vector<?> list, Vector<String> date, ArrayList<Map<String, ?>> data) {
        this.tbl = globalTable;
        this.tbl.setRowHeight(20);
        this.tbl.setAutoResizeMode(0);
        if (this.type == 0) {
            this.tbl.setModel(new TMPrintable2(list, date, data));
            if (Transport.conn.isModifiable("CALENDRIER") || "GENEX".equals(System.getProperty("client", null))) {
                this.tbl.removeMouseListener(this.getMouseListener());
                this.tbl.addMouseListener(this.getMouseListener());
            }
            DriverTableRenderer.initialize(this.tbl);
        } else {
            this.tbl.setModel(new TMVehicleAgency(list, date, data));
            VehicleTableRenderer.initialize(this.tbl);
        }
        this.setViewportView(this.tbl);
        JList objectList = new JList(new ComboBoxModel(list));
        objectList.setFixedCellWidth(150);
        objectList.setFixedCellHeight(this.tbl.getRowHeight());
        objectList.setCellRenderer(new GlobalRowHeader(this.tbl));
        objectList.setBackground(this.tbl.getTableHeader().getBackground());
        this.setRowHeaderView(objectList);
    }

    private MouseListener getMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    Point p = e.getPoint();
                    int row = GlobalScrollPane.this.tbl.rowAtPoint(p);
                    int column = GlobalScrollPane.this.tbl.columnAtPoint(p);
                    if (row == -1 || column == -1) {
                        TimsLogger.debug("clic hors d'une cellule");
                        return;
                    }
                    final TMPrintable2 ptm = (TMPrintable2)GlobalScrollPane.this.tbl.getModel();
                    final String day = ptm.getDate().get(column);
                    final Conducteur driver = (Conducteur)ptm.getObjectList().get(row);
                    if (e.getClickCount() == 2) {
                        TimsLogger.debug("#GSP.mousseListener# double click on " + day + " " + driver.getNom());
                        GlobalScrollPane.this.getPcp().show(GlobalScrollPane.this.tbl, (int)p.getX(), (int)p.getY());
                        new Thread(){

                            @Override
                            public void run() {
                                while (GlobalScrollPane.this.getPcp().isVisible()) {
                                    try {
                                        Thread.sleep(50L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (GlobalScrollPane.this.getPcp().getStatus() == PnlCalendarPopup.VALIDATED) {
                                    JourType toAdd;
                                    Date dayDate = ConversionTime.stringToDate(day, "dd/MM/yyyy");
                                    LienJourConducteur tmp = new LienJourConducteur();
                                    tmp.load(driver.getCle(), new Timestamp(dayDate.getTime()));
                                    if (tmp.getCle() != 0) {
                                        TimsLogger.debug("#GSP.mousseListener# delete " + tmp.getDesignation());
                                        tmp.delete();
                                    }
                                    if ((toAdd = GlobalScrollPane.this.getPcp().getSelectedType()) != null) {
                                        TimsLogger.debug("#GSP.mousseListener# add " + toAdd.getDesignation());
                                        LienJourConducteur ljc = new LienJourConducteur();
                                        ljc.setCleUser(ConnexionSettings.getInstance().getUserCle());
                                        ljc.setCleConducteur(driver.getCleConducteur());
                                        ljc.setDateJour(dayDate);
                                        ljc.setHeureDebut(480);
                                        ljc.setCleJourType(toAdd.getCle());
                                        ljc.setType(2);
                                        ljc.update();
                                        int remuneration = 0;
                                        int defaultDayLength = 0;
                                        if (System.getProperty("contract_day_length_reference", "0").equals("1")) {
                                            try {
                                                TypeContrat currentContract = TypeContrat.getTypeContrat(driver.getCleTypeContrat());
                                                defaultDayLength = currentContract != null ? currentContract.getDailyValue() : 0;
                                            }
                                            catch (TypeContratNotFoundException ex) {
                                                ex.printStackTrace();
                                            }
                                        }
                                        if (toAdd.shouldPay(driver, ljc.getDateJour()) && toAdd.isGenerateHS()) {
                                            remuneration += ljc.getDuree(defaultDayLength);
                                        }
                                        ptm.addValue(day, driver, toAdd.getCode(), remuneration, toAdd.getColor());
                                    } else {
                                        ptm.addValue(day, driver, null, 0, 0);
                                    }
                                }
                            }
                        }.start();
                    } else if (SwingUtilities.isRightMouseButton(e)) {
                        TimsLogger.debug("right click on " + day + " " + driver.getNom());
                    }
                }
            };
        }
        return this.mouseListener;
    }

    public class GlobalRowHeader
    extends JLabel
    implements ListCellRenderer {
        public GlobalRowHeader(JTable table) {
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            return this;
        }
    }
}

