/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.agence;

import fr.pgh.component.JMultiListBox;
import fr.pgh.component.model.MultiListBoxModel;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.GNSSPlace;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DBObjectNotFoundException;
import fr.pgh.jxmapviewer.viewer.ClusterWaypointPainter;
import fr.pgh.jxmapviewer.viewer.DefaultTimsWaypoint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.input.CenterMapListener;
import org.jxmapviewer.input.PanKeyListener;
import org.jxmapviewer.input.PanMouseInputListener;
import org.jxmapviewer.input.ZoomMouseWheelListenerCursor;
import org.jxmapviewer.painter.CompoundPainter;
import org.jxmapviewer.viewer.DayTrack;
import org.jxmapviewer.viewer.DefaultTileFactory;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.RoutePainter;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.position.TimsTileFactoryInfo;
import transpo.system.ui.resources.Fmresources;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.tree.ArbreDonnees;
import transpo.system.util.Fonctions;

public class PnlAgencyPosition
extends ViewPanel
implements Observer,
DataListener {
    private static final long serialVersionUID = 1L;
    private JPanel pnlFilter = null;
    private JPanel pnlLeft = null;
    private JPanel pnlMap = null;
    private JPanel pnlInfos = null;
    private Agence current = null;
    private JButton btnPrevDay = null;
    private JButton btnPrevWeek = null;
    private JLabel lblMonth = null;
    private JButton btnNextDay = null;
    private JButton btnNextWeek = null;
    private JButton btnUpdate = null;
    private JXMapViewer mapViewer = null;
    private JMultiListBox<Vehicule> mbVehicle = null;
    private JMultiListBox<Conducteur> mbDriver = null;
    private Date currentDate = ConversionTime.dateTruncate(new Date());
    private static final Fmresources res = new Fmresources();
    ClassLoader cl = this.getClass().getClassLoader();

    @Override
    public String getViewName() {
        return LanguageTranslator.getString("position.title");
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close() {
    }

    @Override
    public String getMnemo() {
        return "";
    }

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        if (dataEvent instanceof BddEvent) {
            BddEvent e = (BddEvent)dataEvent;
            e.getTable().equals("t_conducteur");
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        TimsLogger.debug("#" + this.getClass() + ".update# a faire");
    }

    public PnlAgencyPosition() {
        LanguageTranslator.getInstance().addObserver(this);
        this.initialize();
        Transport.bdd.addDataListener(this);
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getPnlMap(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 0, 18, null));
    }

    private JPanel getPnlMap() {
        if (this.pnlMap == null) {
            this.pnlMap = new JPanel();
            this.pnlMap.setLayout(new GridBagLayout());
            this.pnlMap.add((Component)this.getPnlLeft(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 3, 18, new Insets(0, 5, 0, 0)));
            this.pnlMap.add((Component)this.getMap(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 1, 18, new Insets(0, 0, 0, 0)));
        }
        return this.pnlMap;
    }

    private JPanel getPnlLeft() {
        if (this.pnlLeft == null) {
            this.pnlLeft = new JPanel();
            this.pnlLeft.setLayout(new GridBagLayout());
            this.pnlLeft.setPreferredSize(new Dimension(250, 0));
            this.pnlLeft.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("position.title"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlLeft.add((Component)this.getPnlFilter(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, 18, new Insets(0, 5, 0, 0)));
            this.pnlLeft.add((Component)this.getPnlInfos(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, 18, new Insets(0, 3, 0, 3)));
        }
        return this.pnlLeft;
    }

    private JPanel getPnlInfos() {
        if (this.pnlInfos == null) {
            this.pnlInfos = new JPanel();
            this.pnlInfos.setLayout(new GridBagLayout());
            this.pnlInfos.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("position.infos"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        }
        return this.pnlInfos;
    }

    private JPanel getPnlFilter() {
        if (this.pnlFilter == null) {
            this.lblMonth = new JLabel(ConversionTime.dateToString(this.currentDate, "dd/MM/yyyy"), 0);
            this.lblMonth.setPreferredSize(new Dimension(100, 30));
            this.lblMonth.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.pnlFilter = new JPanel();
            this.pnlFilter.setLayout(new GridBagLayout());
            this.pnlFilter.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.filter"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlFilter.add((Component)this.getBtnPrevWeek(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(0, 0, 0, 0)));
            this.pnlFilter.add((Component)this.getBtnPrevDay(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(0, 2, 0, 0)));
            this.pnlFilter.add((Component)this.lblMonth, Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(5, 5, 5, 5)));
            this.pnlFilter.add((Component)this.getBtnNextDay(), Fonctions.getGridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(0, 0, 0, 0)));
            this.pnlFilter.add((Component)this.getBtnNextWeek(), Fonctions.getGridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(0, 2, 0, 0)));
            this.pnlFilter.add(this.getMbVehicle(), Fonctions.getGridBagConstraints(0, 1, 1, 5, 0.0, 0.0, 2, 10, new Insets(5, 5, 0, 0)));
            this.pnlFilter.add(this.getMbDriver(), Fonctions.getGridBagConstraints(0, 2, 1, 5, 0.0, 0.0, 2, 10, new Insets(5, 5, 5, 0)));
            this.pnlFilter.add((Component)this.getBtnUpdate(), Fonctions.getGridBagConstraints(0, 3, 1, 5, 0.0, 0.0, 0, 10, new Insets(0, 5, 0, 0)));
        }
        return this.pnlFilter;
    }

    private JButton getBtnUpdate() {
        if (this.btnUpdate == null) {
            this.btnUpdate = new JButton();
            this.btnUpdate.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_refresh"))));
            this.btnUpdate.setPreferredSize(new Dimension(25, 25));
            this.btnUpdate.setToolTipText(LanguageTranslator.getString("button.update"));
            this.btnUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Vector<Integer> selection = PnlAgencyPosition.this.getMbVehicle().getModel().getSelectedId(false);
                    Integer[] inte = new Integer[selection.size()];
                    PnlAgencyPosition.this.loadHistoric(true, selection.toArray(inte));
                }
            });
        }
        return this.btnUpdate;
    }

    private JMultiListBox<Vehicule> getMbVehicle() {
        if (this.mbVehicle == null) {
            this.mbVehicle = new JMultiListBox();
            this.mbVehicle.setPreferredSize(new Dimension(0, 25));
        }
        return this.mbVehicle;
    }

    private JMultiListBox<Conducteur> getMbDriver() {
        if (this.mbDriver == null) {
            this.mbDriver = new JMultiListBox();
            this.mbDriver.setPreferredSize(new Dimension(0, 25));
            this.mbDriver.setEnabled(false);
        }
        return this.mbDriver;
    }

    private JXMapViewer getMap() {
        if (this.mapViewer == null) {
            this.mapViewer = new JXMapViewer();
            this.mapViewer.setPreferredSize(new Dimension(1200, 900));
            if (Transport.debug >= 1) {
                this.mapViewer.setDrawTileBorders(true);
            }
            String tileServerURL = System.getProperty("carto.server.url", "https://tile.openstreetmap.org");
            TimsTileFactoryInfo info = new TimsTileFactoryInfo(1, 19, 19, 256, true, true, tileServerURL, "x", "y", "z");
            DefaultTileFactory tileFactory = new DefaultTileFactory(info);
            tileFactory.setThreadPoolSize(4);
            this.mapViewer.setTileFactory(tileFactory);
            PanMouseInputListener mia = new PanMouseInputListener(this.mapViewer);
            this.mapViewer.addMouseListener(mia);
            this.mapViewer.addMouseMotionListener(mia);
            this.mapViewer.addMouseListener(new CenterMapListener(this.mapViewer));
            this.mapViewer.addMouseWheelListener(new ZoomMouseWheelListenerCursor(this.mapViewer));
            this.mapViewer.addKeyListener(new PanKeyListener(this.mapViewer));
        }
        return this.mapViewer;
    }

    @Override
    public void loadData() {
        if (!this.load) {
            if (this.current.getLatitude() == 0.0f) {
                this.getMap().setAddressLocation(new GeoPosition(45.4796633, 4.4463057));
            } else {
                this.getMap().setAddressLocation(new GeoPosition(this.current.getLatitude(), this.current.getLongitude()));
            }
            this.loadLastPos();
            this.load = true;
        }
    }

    public void loadHistoric(boolean moveToFit, Integer ... vehicleIds) {
        Integer[] integerArray = vehicleIds;
        int n = vehicleIds.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.getMbVehicle().clearSelection();
            this.getMbVehicle().addSelectedId(id);
            ++n2;
        }
        Color[] color = new Color[]{Color.red, Color.blue, Color.green, Color.CYAN, Color.gray, Color.orange, Color.MAGENTA, Color.pink};
        TimsLogger.debug("#PnlAgencyPosition# loadHistoric of " + vehicleIds.length + " markers");
        HashSet<GeoPosition> track = new HashSet<GeoPosition>();
        ArrayList<RoutePainter> painters = new ArrayList<RoutePainter>();
        Vehicule current = null;
        ArrayList<GNSSPlace> toLoad = GNSSPlace.getGnssVehiclePlaces(Arrays.asList(vehicleIds), this.currentDate, ConversionTime.addDay(this.currentDate, 1));
        TimsLogger.debug("#PAP.loadHistoric# " + toLoad.size() + " points to load");
        ArrayList<GNSSPlace> one = new ArrayList<GNSSPlace>();
        int colorIdx = 0;
        for (GNSSPlace gnss : toLoad) {
            if (current == null) {
                try {
                    current = Vehicule.getVehicule(null, gnss.getVehicleId());
                }
                catch (DBObjectNotFoundException e) {
                    e.printStackTrace();
                }
            } else if (current.getCleVehicule() != gnss.getVehicleId()) {
                TimsLogger.debug("PAP.loadHistoric# done for " + current.getId() + " [" + current.getRegistrationNumber() + "]" + one.size() + " points. next is " + gnss.getVehicleId());
                RoutePainter toAdd = new RoutePainter(new DayTrack(current, one), color[colorIdx % 7]);
                ++colorIdx;
                painters.add(toAdd);
                one = new ArrayList();
                current = null;
            }
            one.add(gnss);
            TimsLogger.debug("#PAP.reloadMap# add " + gnss.getDriverId() + " " + ConversionTime.dateToString(gnss.getPointTime(), "dd/MM/yyyy HH:mm") + " " + gnss.getLongitude() + " " + gnss.getLatitude());
            GeoPosition gp = new GeoPosition(gnss.getLatitude(), gnss.getLongitude());
            track.add(gp);
        }
        RoutePainter toAdd = new RoutePainter(new DayTrack(current, one), color[colorIdx % 7]);
        ++colorIdx;
        painters.add(toAdd);
        if (moveToFit) {
            this.zoomMap(track);
        }
        CompoundPainter painter = new CompoundPainter(painters);
        this.getMap().setOverlayPainter(painter);
    }

    private void loadLastPos() {
        TimsLogger.debug("#PnlAgencyPosition# loadLastPos");
        HashSet<GeoPosition> track = new HashSet<GeoPosition>();
        HashSet<DefaultTimsWaypoint> waypoints = new HashSet<DefaultTimsWaypoint>();
        ArrayList<GNSSPlace> list = ArbreDonnees.getInstance().getType() == 1 ? GNSSPlace.getLastDriverPosition(this.current.getCleAgence(), 0, this.currentDate, null) : GNSSPlace.getLastVehiclePosition(this.current.getCleAgence(), 0, this.currentDate, null);
        for (GNSSPlace gnss : list) {
            TimsLogger.debug("#PAP.reloadMap# add " + gnss.getDriverId() + " " + ConversionTime.dateToString(gnss.getPointTime(), "dd/MM/yyyy HH:mm") + " " + gnss.getLongitude() + " " + gnss.getLatitude());
            GeoPosition toAdd = new GeoPosition(gnss.getLatitude(), gnss.getLongitude());
            track.add(toAdd);
            waypoints.add(new DefaultTimsWaypoint(gnss));
        }
        ClusterWaypointPainter<DefaultTimsWaypoint> clusterWPPainter = new ClusterWaypointPainter<DefaultTimsWaypoint>();
        clusterWPPainter.setWaypoints(waypoints);
        this.getMap().addPropertyChangeListener("zoom", clusterWPPainter);
        this.zoomMap(track);
        this.getMap().setOverlayPainter(clusterWPPainter);
    }

    private void zoomMap(Set<GeoPosition> track) {
        if (track.size() == 0) {
            this.getMap().recenterToAddressLocation();
            this.getMap().setZoom(8);
        } else {
            this.getMap().zoomToBestFit(track, 0.8);
        }
    }

    public void set(Agence current) {
        this.current = current;
        this.getMbVehicle().setModel(new MultiListBoxModel<Vehicule>(Vehicule.loadList(current.getCleAgence()), true));
        this.getMbDriver().setModel(new MultiListBoxModel<Conducteur>(Conducteur.loadList(current.getCleAgence()), true));
        this.load = false;
    }

    private JButton getBtnPrevWeek() {
        if (this.btnPrevWeek == null) {
            this.btnPrevWeek = new JButton();
            this.btnPrevWeek.setBorder(null);
            this.btnPrevWeek.setToolTipText(LanguageTranslator.getString("calendar.previousWeek"));
            this.btnPrevWeek.setBorderPainted(false);
            this.btnPrevWeek.setContentAreaFilled(false);
            this.btnPrevWeek.setFocusPainted(false);
            this.btnPrevWeek.setIcon(this.getDLeft());
            this.btnPrevWeek.setPreferredSize(new Dimension(25, 27));
            this.btnPrevWeek.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlAgencyPosition.this.addDay(-7);
                }
            });
        }
        return this.btnPrevWeek;
    }

    private JButton getBtnNextWeek() {
        if (this.btnNextWeek == null) {
            this.btnNextWeek = new JButton();
            this.btnNextWeek.setBorder(null);
            this.btnNextWeek.setToolTipText(LanguageTranslator.getString("calendar.nextWeek"));
            this.btnNextWeek.setBorderPainted(false);
            this.btnNextWeek.setContentAreaFilled(false);
            this.btnNextWeek.setFocusPainted(false);
            this.btnNextWeek.setIcon(this.getDRight());
            this.btnNextWeek.setPreferredSize(new Dimension(25, 27));
            this.btnNextWeek.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlAgencyPosition.this.addDay(7);
                }
            });
        }
        return this.btnNextWeek;
    }

    private JButton getBtnPrevDay() {
        if (this.btnPrevDay == null) {
            this.btnPrevDay = new JButton();
            this.btnPrevDay.setBorder(null);
            this.btnPrevDay.setToolTipText(LanguageTranslator.getString("calendar.previousDay"));
            this.btnPrevDay.setBorderPainted(false);
            this.btnPrevDay.setContentAreaFilled(false);
            this.btnPrevDay.setFocusPainted(false);
            this.btnPrevDay.setIcon(this.getLeft());
            this.btnPrevDay.setPreferredSize(new Dimension(25, 27));
            this.btnPrevDay.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlAgencyPosition.this.addDay(-1);
                }
            });
        }
        return this.btnPrevDay;
    }

    private JButton getBtnNextDay() {
        if (this.btnNextDay == null) {
            this.btnNextDay = new JButton();
            this.btnNextDay.setBorder(null);
            this.btnNextDay.setToolTipText(LanguageTranslator.getString("calendar.nextDay"));
            this.btnNextDay.setBorderPainted(false);
            this.btnNextDay.setContentAreaFilled(false);
            this.btnNextDay.setFocusPainted(false);
            this.btnNextDay.setIcon(this.getRight());
            this.btnNextDay.setPreferredSize(new Dimension(25, 27));
            this.btnNextDay.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlAgencyPosition.this.addDay(1);
                }
            });
        }
        return this.btnNextDay;
    }

    private ImageIcon getRight() {
        return new ImageIcon(this.cl.getResource(res.getResourceString("icone_right")));
    }

    private ImageIcon getLeft() {
        return new ImageIcon(this.cl.getResource(res.getResourceString("icone_left")));
    }

    private ImageIcon getDRight() {
        return new ImageIcon(this.cl.getResource(res.getResourceString("icone_dright")));
    }

    private ImageIcon getDLeft() {
        return new ImageIcon(this.cl.getResource(res.getResourceString("icone_dleft")));
    }

    private void addDay(int i) {
        this.currentDate = ConversionTime.add(this.currentDate, 5, i);
        this.lblMonth.setText(ConversionTime.dateToString(this.currentDate, "dd/MM/yyyy"));
    }
}

