/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.agence;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.AgencyType;
import fr.pgh.data.bdd.GlobalCalendar;
import fr.pgh.data.bdd.Pays;
import fr.pgh.data.bdd.Region;
import fr.pgh.data.bdd.TailleAgence;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import transpo.system.Transport;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.Fmresources;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class PnlDetailAgence
extends ViewPanel
implements DataListener {
    private static final long serialVersionUID = 1L;
    private Agence current = null;
    private Fmresources res = null;
    private JPanel jContentPane = null;
    private JPanel pnlInformations = null;
    private JPanel pnlAddress = null;
    private JLabel lblStreet = null;
    private JLabel lblCP = null;
    private JTextField txtCP = null;
    private JLabel lblCity = null;
    private JTextField txtCity = null;
    private JTextPane txtAddress = null;
    private JLabel lblCountry = null;
    private JComboBox cbCountry = null;
    private JPanel pnlOther = null;
    private JLabel lblPhone = null;
    private JTextField txtPhone = null;
    private JLabel lblPhone2 = null;
    private JTextField txtPhone2 = null;
    private JLabel lblFax = null;
    private JTextField txtFax = null;
    private JLabel lblSecuriteSociale = null;
    private JTextField txtEmail = null;
    private JPanel pnlName = null;
    private JLabel lblName = null;
    private JLabel lblCode = null;
    private JTextField txtName = null;
    private JTextField txtCode = null;
    private JLabel lblType = null;
    private JLabel lblSize = null;
    private JComboBox cbType = null;
    private JComboBox cbSize = null;
    private JButton btnAddType = null;
    private JButton btnAddSize = null;
    private JTextField txtOpening = null;
    private JLabel lblOpening = null;
    private JLabel lblClose = null;
    private JTextField txtClose = null;
    private JPanel pnlBtn = null;
    private JButton btnEnregistrer = null;
    private ImageIcon imgAdd = null;
    private JLabel lblRegion = null;
    private JComboBox cbRegion = null;
    private JLabel lblSat = null;
    private JCheckBox cbSatWork = null;
    private JLabel txtCld = null;
    private JComboBox cbDefaultCalendar = null;
    private JScrollPane jspTbl = null;
    private JTable tblCompanyCard = null;
    private JLabel lblSaveDir = null;

    @Override
    public String getViewName() {
        return LanguageTranslator.getString("generics.information");
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close() {
    }

    @Override
    public String getMnemo() {
        return "";
    }

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        if (dataEvent instanceof BddEvent) {
            BddEvent e = (BddEvent)dataEvent;
            if (e.getTable().equals("AGENCY_TYPE")) {
                this.getCbType().setModel(new ComboBoxModel(AgencyType.getList(), false, LanguageTranslator.getString("generics.none")));
                this.getCbType().setSelectedItem(((ComboBoxModel)this.getCbType().getModel()).getLabel(this.current.getCleTypeAgence()));
            }
            if (e.getTable().equals("CALENDAR")) {
                this.getCbDefaultCalendar().setModel(new ComboBoxModel(GlobalCalendar.loadList(), false, LanguageTranslator.getString("generics.none")));
                this.getCbDefaultCalendar().setSelectedItem(((ComboBoxModel)this.getCbDefaultCalendar().getModel()).getLabel(this.current.getDefaultCalendarId()));
            }
            if (e.getTable().equals("region")) {
                this.getCbRegion().setModel(new ComboBoxModel(Region.loadList(((ComboBoxModel)this.getCbCountry().getModel()).getSelectedCle()), false, LanguageTranslator.getString("generics.none")));
                this.getCbRegion().setSelectedItem(((ComboBoxModel)this.getCbRegion().getModel()).getLabel(this.current.getRegionId()));
            }
            if (e.getTable().equals("t_taille_agence")) {
                this.getCbSize().setModel(new ComboBoxModel(BddTransport.getInstance().getTailleAgence(), false, LanguageTranslator.getString("generics.none")));
                this.getCbSize().setSelectedItem(((ComboBoxModel)this.getCbSize().getModel()).getLabel(this.current.getCleTailleAgence()));
            }
        }
    }

    public PnlDetailAgence() {
        this.initialize();
        Transport.bdd.addDataListener(this);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints210 = new GridBagConstraints();
        gridBagConstraints210.gridx = 0;
        gridBagConstraints210.weightx = 1.0;
        gridBagConstraints210.weighty = 1.0;
        gridBagConstraints210.fill = 1;
        gridBagConstraints210.gridy = 0;
        GridBagConstraints gridBagConstraints110 = new GridBagConstraints();
        gridBagConstraints110.gridx = 0;
        gridBagConstraints110.gridy = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridy = -1;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(750, 600));
        this.setMaximumSize(new Dimension(750, 600));
        this.setMinimumSize(new Dimension(750, 600));
        this.setLocation(new Point(0, 0));
        this.add((Component)this.getJContentPane(), gridBagConstraints210);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints2 = Fonctions.getGridBagConstraints(0, 1, 1, 1, -1.0, -1.0, -1, -1, null);
            GridBagConstraints gridBagConstraints = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5));
            GridBagConstraints gcbConso = Fonctions.getGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 2, -1, null);
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlInformations(), gridBagConstraints);
            this.jContentPane.add((Component)this.getPnlBtn(), gridBagConstraints2);
        }
        return this.jContentPane;
    }

    private JPanel getPnlInformations() {
        if (this.pnlInformations == null) {
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 0;
            gridBagConstraints18.weightx = 1.0;
            gridBagConstraints18.weighty = 1.0;
            gridBagConstraints18.fill = 1;
            gridBagConstraints18.gridwidth = 2;
            gridBagConstraints18.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.weighty = 0.0;
            gridBagConstraints1.gridy = 1;
            this.pnlInformations = new JPanel();
            this.pnlInformations.setLayout(new GridBagLayout());
            this.pnlInformations.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("agency.information"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlInformations.add((Component)this.getPnlAddress(), gridBagConstraints1);
            this.pnlInformations.add((Component)this.getPnlOther(), gridBagConstraints3);
            this.pnlInformations.add((Component)this.getPnlName(), gridBagConstraints18);
        }
        return this.pnlInformations;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints65 = new GridBagConstraints();
            gridBagConstraints65.anchor = 10;
            gridBagConstraints65.gridx = 1;
            gridBagConstraints65.gridy = 0;
            gridBagConstraints65.weightx = 1.0;
            gridBagConstraints65.weighty = 1.0;
            gridBagConstraints65.insets = new Insets(0, 5, 5, 0);
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnEnregistrer(), gridBagConstraints65);
        }
        return this.pnlBtn;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlDetailAgence.this.enregistrer();
                }
            });
        }
        return this.btnEnregistrer;
    }

    public void enregistrer() {
        if (!this.check()) {
            return;
        }
        if (this.current.compareAndUpdate(this.getTxtName().getText(), this.getTxtCode().getText(), this.getTxtAddress().getText(), this.getTxtCP().getText(), this.getTxtCity().getText(), ((ComboBoxModel)this.getCbCountry().getModel()).getSelectedCle(), this.getTxtPhone().getText(), this.getTxtPhone2().getText(), this.getTxtFax().getText(), this.getTxtEmail().getText(), ConversionTime.dateFromFranceToBDD(this.getTxtOpening().getText(), false), ConversionTime.dateFromFranceToBDD(this.getTxtClose().getText(), false), ((ComboBoxModel)this.getCbSize().getModel()).getSelectedCle(), ((ComboBoxModel)this.getCbType().getModel()).getSelectedCle(), ((ComboBoxModel)this.getCbRegion().getModel()).getSelectedCle(), this.getCbSatWork().isSelected(), ((ComboBoxModel)this.getCbDefaultCalendar().getModel()).getSelectedCle())) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveSucceed"), LanguageTranslator.getString("message.done"), 1);
        } else {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveError"), LanguageTranslator.getString("message.saveError"), 0);
        }
    }

    public boolean check() {
        boolean toReturn = true;
        if (this.getTxtCode().getText().length() > 4) {
            this.getTxtCode().setBackground(new Color(255, 192, 203));
            this.getTxtCode().setToolTipText(LanguageTranslator.getString("generics.maxAuthorised", "4"));
            toReturn = false;
        } else {
            this.getTxtCode().setBackground(Color.white);
        }
        if (this.getTxtName().getText().equals("")) {
            this.getTxtName().setBackground(new Color(255, 192, 203));
            this.getTxtName().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtName().setBackground(Color.white);
        }
        return toReturn;
    }

    private JPanel getPnlAddress() {
        if (this.pnlAddress == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridy = 2;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.gridwidth = 3;
            gridBagConstraints6.insets = new Insets(0, 3, 0, 3);
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 2;
            this.lblCountry = new JLabel();
            this.lblCountry.setText(LanguageTranslator.getString("generics.country"));
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.fill = 1;
            gridBagConstraints13.gridwidth = 3;
            gridBagConstraints13.gridx = 1;
            gridBagConstraints13.gridy = 0;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.weighty = 1.0;
            gridBagConstraints13.insets = new Insets(0, 5, 5, 5);
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.fill = 2;
            gridBagConstraints17.gridx = 3;
            gridBagConstraints17.gridy = 1;
            gridBagConstraints17.weightx = 0.0;
            gridBagConstraints17.insets = new Insets(0, 3, 0, 3);
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.insets = new Insets(0, 3, 0, 3);
            gridBagConstraints16.gridy = 1;
            gridBagConstraints16.gridx = 2;
            this.lblCity = new JLabel();
            this.lblCity.setText(LanguageTranslator.getString("generics.city"));
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.fill = 0;
            gridBagConstraints15.gridx = 1;
            gridBagConstraints15.gridy = 1;
            gridBagConstraints15.weightx = 0.0;
            gridBagConstraints15.insets = new Insets(0, 3, 0, 3);
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.fill = 2;
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.gridy = 1;
            gridBagConstraints14.insets = new Insets(0, 3, 0, 3);
            this.lblCP = new JLabel();
            this.lblCP.setText(LanguageTranslator.getString("generics.cp"));
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.anchor = 11;
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.gridy = 0;
            gridBagConstraints10.insets = new Insets(0, 3, 0, 3);
            this.lblStreet = new JLabel();
            this.lblStreet.setText(LanguageTranslator.getString("generics.street"));
            this.pnlAddress = new JPanel();
            this.pnlAddress.setLayout(new GridBagLayout());
            this.pnlAddress.setPreferredSize(new Dimension(330, 150));
            this.pnlAddress.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.address"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlAddress.add((Component)this.lblStreet, gridBagConstraints10);
            this.pnlAddress.add((Component)this.lblCP, gridBagConstraints14);
            this.pnlAddress.add((Component)this.getTxtCP(), gridBagConstraints15);
            this.pnlAddress.add((Component)this.lblCity, gridBagConstraints16);
            this.pnlAddress.add((Component)this.getTxtCity(), gridBagConstraints17);
            this.pnlAddress.add((Component)this.getTxtAddress(), gridBagConstraints13);
            this.pnlAddress.add((Component)this.lblCountry, gridBagConstraints4);
            this.pnlAddress.add((Component)this.getCbCountry(), gridBagConstraints6);
        }
        return this.pnlAddress;
    }

    private JTextField getTxtCP() {
        if (this.txtCP == null) {
            this.txtCP = new JTextField();
            this.txtCP.setPreferredSize(new Dimension(40, 20));
            this.txtCP.setText("");
        }
        return this.txtCP;
    }

    private JTextField getTxtCity() {
        if (this.txtCity == null) {
            this.txtCity = new JTextField();
        }
        return this.txtCity;
    }

    private JTextPane getTxtAddress() {
        if (this.txtAddress == null) {
            this.txtAddress = new JTextPane();
        }
        return this.txtAddress;
    }

    private JPanel getPnlOther() {
        if (this.pnlOther == null) {
            GridBagConstraints gridBagConstraints67 = new GridBagConstraints();
            gridBagConstraints67.anchor = 10;
            gridBagConstraints67.gridx = 1;
            gridBagConstraints67.gridy = 3;
            gridBagConstraints67.weightx = 1.0;
            gridBagConstraints67.fill = 2;
            GridBagConstraints gridBagConstraints66 = new GridBagConstraints();
            gridBagConstraints66.anchor = 17;
            gridBagConstraints66.gridy = 3;
            gridBagConstraints66.weightx = 0.0;
            gridBagConstraints66.weighty = 1.0;
            gridBagConstraints66.fill = 0;
            gridBagConstraints66.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints66.gridx = 0;
            this.lblSecuriteSociale = new JLabel();
            this.lblSecuriteSociale.setText(LanguageTranslator.getString("generics.mail"));
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.anchor = 13;
            gridBagConstraints12.gridx = 1;
            gridBagConstraints12.gridy = 2;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.weighty = 1.0;
            gridBagConstraints12.fill = 2;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.gridy = 2;
            gridBagConstraints11.fill = 0;
            this.lblFax = new JLabel();
            this.lblFax.setText(LanguageTranslator.getString("generics.fax"));
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.anchor = 13;
            gridBagConstraints9.gridx = 1;
            gridBagConstraints9.gridy = 1;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.fill = 2;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 1;
            gridBagConstraints7.fill = 0;
            this.lblPhone2 = new JLabel();
            this.lblPhone2.setText(LanguageTranslator.getString("generics.mobile"));
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.fill = 2;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints5.gridx = -1;
            gridBagConstraints5.gridy = -1;
            gridBagConstraints5.fill = 0;
            this.lblPhone = new JLabel();
            this.lblPhone.setText(LanguageTranslator.getString("generics.phone"));
            this.pnlOther = new JPanel();
            this.pnlOther.setLayout(new GridBagLayout());
            this.pnlOther.add((Component)this.lblPhone, gridBagConstraints5);
            this.pnlOther.add((Component)this.getTxtPhone(), gridBagConstraints8);
            this.pnlOther.add((Component)this.lblPhone2, gridBagConstraints7);
            this.pnlOther.add((Component)this.getTxtPhone2(), gridBagConstraints9);
            this.pnlOther.add((Component)this.lblFax, gridBagConstraints11);
            this.pnlOther.add((Component)this.getTxtFax(), gridBagConstraints12);
            this.pnlOther.add((Component)this.lblSecuriteSociale, gridBagConstraints66);
            this.pnlOther.add((Component)this.getTxtEmail(), gridBagConstraints67);
        }
        return this.pnlOther;
    }

    private JTextField getTxtPhone() {
        if (this.txtPhone == null) {
            this.txtPhone = new JTextField();
            this.txtPhone.setPreferredSize(new Dimension(80, 20));
        }
        return this.txtPhone;
    }

    private JTextField getTxtPhone2() {
        if (this.txtPhone2 == null) {
            this.txtPhone2 = new JTextField();
            this.txtPhone2.setPreferredSize(new Dimension(80, 20));
            this.txtPhone2.setText("");
        }
        return this.txtPhone2;
    }

    private JTextField getTxtFax() {
        if (this.txtFax == null) {
            this.txtFax = new JTextField();
            this.txtFax.setPreferredSize(new Dimension(80, 20));
        }
        return this.txtFax;
    }

    private JTextField getTxtEmail() {
        if (this.txtEmail == null) {
            this.txtEmail = new JTextField();
        }
        return this.txtEmail;
    }

    private JComboBox getCbCountry() {
        if (this.cbCountry == null) {
            this.cbCountry = new JComboBox();
            this.cbCountry.setModel(new ComboBoxModel(Pays.getVector(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbCountry;
    }

    private JPanel getPnlName() {
        if (this.pnlName == null) {
            this.lblSaveDir = new JLabel(LanguageTranslator.getString("generics.saveDir", "0"));
            this.txtCld = new JLabel(LanguageTranslator.getString("generics.calendar"));
            this.lblSat = new JLabel(LanguageTranslator.getString("agency.satOpen"));
            this.lblRegion = new JLabel(LanguageTranslator.getString("generics.region"));
            this.lblClose = new JLabel(LanguageTranslator.getString("agency.closing"));
            this.lblOpening = new JLabel(LanguageTranslator.getString("agency.opening"));
            this.lblSize = new JLabel(LanguageTranslator.getString("agency.size.title"));
            this.lblType = new JLabel(LanguageTranslator.getString("agency.type.title"));
            this.lblCode = new JLabel(LanguageTranslator.getString("generics.code"));
            this.lblName = new JLabel(LanguageTranslator.getString("generics.name"));
            GridBagConstraints gcbl0c0 = new GridBagConstraints();
            gcbl0c0.gridx = 0;
            gcbl0c0.weighty = 1.0;
            gcbl0c0.gridy = 0;
            GridBagConstraints gcbl0c1 = new GridBagConstraints();
            gcbl0c1.fill = 2;
            gcbl0c1.gridy = 0;
            gcbl0c1.weightx = 1.0;
            gcbl0c1.gridx = 1;
            GridBagConstraints gcbl0c2 = new GridBagConstraints();
            gcbl0c2.gridx = 2;
            gcbl0c2.gridwidth = 2;
            gcbl0c2.gridy = 0;
            GridBagConstraints gcbl1c0 = new GridBagConstraints();
            gcbl1c0.gridx = 0;
            gcbl1c0.weighty = 1.0;
            gcbl1c0.gridy = 1;
            GridBagConstraints gcbl1c1 = new GridBagConstraints();
            gcbl1c1.fill = 2;
            gcbl1c1.gridy = 1;
            gcbl1c1.weightx = 1.0;
            gcbl1c1.gridx = 1;
            GridBagConstraints gcbl1c2 = new GridBagConstraints();
            gcbl1c2.gridx = 2;
            gcbl1c2.gridy = 1;
            GridBagConstraints gcbl1c3 = new GridBagConstraints();
            gcbl1c3.fill = 2;
            gcbl1c3.gridy = 1;
            gcbl1c3.weightx = 1.0;
            gcbl1c3.gridx = 3;
            GridBagConstraints gcbl2c0 = new GridBagConstraints();
            gcbl2c0.gridx = 0;
            gcbl2c0.weighty = 1.0;
            gcbl2c0.gridy = 2;
            GridBagConstraints gcbl2c1 = new GridBagConstraints();
            gcbl2c1.gridx = 1;
            gcbl2c1.gridy = 2;
            GridBagConstraints gcbl2c2 = new GridBagConstraints();
            gcbl2c2.gridx = 2;
            gcbl2c2.gridy = 2;
            GridBagConstraints gcbl2c3 = new GridBagConstraints();
            gcbl2c3.fill = 2;
            gcbl2c3.gridy = 2;
            gcbl2c3.weightx = 1.0;
            gcbl2c3.gridx = 3;
            GridBagConstraints gcbl2c4 = new GridBagConstraints();
            gcbl2c4.gridx = 4;
            gcbl2c4.gridy = 2;
            GridBagConstraints gcbl3c0 = new GridBagConstraints();
            gcbl3c0.gridx = 0;
            gcbl3c0.weighty = 1.0;
            gcbl3c0.insets = new Insets(0, 5, 0, 5);
            gcbl3c0.gridy = 3;
            GridBagConstraints gcbl3c1 = new GridBagConstraints();
            gcbl3c1.fill = 2;
            gcbl3c1.gridy = 3;
            gcbl3c1.weightx = 1.0;
            gcbl3c1.gridx = 1;
            GridBagConstraints gcbl3c2 = new GridBagConstraints();
            gcbl3c2.gridx = 2;
            gcbl3c2.gridy = 3;
            GridBagConstraints gcbl3c3 = new GridBagConstraints();
            gcbl3c3.fill = 2;
            gcbl3c3.gridy = 3;
            gcbl3c3.weightx = 1.0;
            gcbl3c3.gridx = 3;
            GridBagConstraints gcbl3c4 = new GridBagConstraints();
            gcbl3c4.gridx = 4;
            gcbl3c4.fill = 0;
            gcbl3c4.weightx = 0.0;
            gcbl3c4.weighty = 0.0;
            gcbl3c4.gridy = 3;
            GridBagConstraints gcbl4c0 = new GridBagConstraints();
            gcbl4c0.gridx = 0;
            gcbl4c0.insets = new Insets(0, 5, 0, 5);
            gcbl4c0.weighty = 1.0;
            gcbl4c0.gridy = 4;
            GridBagConstraints gcbl4c1 = new GridBagConstraints();
            gcbl4c1.fill = 2;
            gcbl4c1.gridy = 4;
            gcbl4c1.weightx = 1.0;
            gcbl4c1.gridx = 1;
            GridBagConstraints gcbl4c2 = new GridBagConstraints();
            gcbl4c2.gridx = 2;
            gcbl4c2.gridy = 4;
            GridBagConstraints gcbl4c3 = new GridBagConstraints();
            gcbl4c3.fill = 2;
            gcbl4c3.gridy = 4;
            gcbl4c3.weightx = 1.0;
            gcbl4c3.gridx = 3;
            GridBagConstraints gcbl5c0 = new GridBagConstraints();
            gcbl5c0.gridx = 0;
            gcbl5c0.gridy = 5;
            GridBagConstraints gcbl5c1 = new GridBagConstraints();
            gcbl5c1.fill = 2;
            gcbl5c1.gridx = 1;
            gcbl5c1.gridy = 5;
            gcbl5c1.weightx = 1.0;
            this.pnlName = new JPanel();
            this.pnlName.setLayout(new GridBagLayout());
            this.pnlName.add((Component)this.lblName, gcbl0c0);
            this.pnlName.add((Component)this.getTxtName(), gcbl0c1);
            if (ConnexionSettings.getInstance().isConsultable("ADMINISTRATION")) {
                this.pnlName.add((Component)this.lblSaveDir, gcbl0c2);
            }
            this.pnlName.add((Component)this.lblCode, gcbl1c0);
            this.pnlName.add((Component)this.getTxtCode(), gcbl1c1);
            this.pnlName.add((Component)this.lblRegion, gcbl1c2);
            this.pnlName.add((Component)this.getCbRegion(), gcbl1c3);
            this.pnlName.add((Component)this.lblSat, gcbl2c0);
            this.pnlName.add((Component)this.getCbSatWork(), gcbl2c1);
            this.pnlName.add((Component)this.lblType, gcbl2c2);
            this.pnlName.add((Component)this.getCbType(), gcbl2c3);
            if (ConnexionSettings.getInstance().isAjoutable("TYPE_AGENCE")) {
                this.pnlName.add((Component)this.getBtnAddType(), gcbl2c4);
            }
            this.pnlName.add((Component)this.lblOpening, gcbl3c0);
            this.pnlName.add((Component)this.getTxtOpening(), gcbl3c1);
            this.pnlName.add((Component)this.lblSize, gcbl3c2);
            this.pnlName.add((Component)this.getCbSize(), gcbl3c3);
            if (ConnexionSettings.getInstance().isAjoutable("TAILLE_AGENCE")) {
                this.pnlName.add((Component)this.getBtnAddSize(), gcbl3c4);
            }
            this.pnlName.add((Component)this.lblClose, gcbl4c0);
            this.pnlName.add((Component)this.getTxtClose(), gcbl4c1);
            this.pnlName.add((Component)this.txtCld, gcbl4c2);
            this.pnlName.add((Component)this.getCbDefaultCalendar(), gcbl4c3);
        }
        return this.pnlName;
    }

    private JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
        }
        return this.txtName;
    }

    private JTextField getTxtCode() {
        if (this.txtCode == null) {
            this.txtCode = new JTextField();
        }
        return this.txtCode;
    }

    private JComboBox getCbType() {
        if (this.cbType == null) {
            this.cbType = new JComboBox();
            this.cbType.setModel(new ComboBoxModel(AgencyType.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbType;
    }

    private JComboBox getCbSize() {
        if (this.cbSize == null) {
            this.cbSize = new JComboBox();
            this.cbSize.setModel(new ComboBoxModel(BddTransport.getInstance().getTailleAgence(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbSize;
    }

    private JButton getBtnAddType() {
        if (this.btnAddType == null) {
            this.btnAddType = new JButton();
            this.btnAddType.setIcon(this.getImgAdd());
            this.btnAddType.setPreferredSize(new Dimension(25, 25));
            this.btnAddType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Fonctions.define(AgencyType.class);
                }
            });
        }
        return this.btnAddType;
    }

    private JButton getBtnAddSize() {
        if (this.btnAddSize == null) {
            this.btnAddSize = new JButton();
            this.btnAddSize.setIcon(this.getImgAdd());
            this.btnAddSize.setPreferredSize(new Dimension(25, 25));
            this.btnAddSize.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Fonctions.define(TailleAgence.class);
                }
            });
        }
        return this.btnAddSize;
    }

    private ImageIcon getImgAdd() {
        if (this.imgAdd == null) {
            ClassLoader cl = this.getClass().getClassLoader();
            this.imgAdd = new ImageIcon(cl.getResource(this.getRes().getResourceString("icone_cliq")));
        }
        return this.imgAdd;
    }

    private Fmresources getRes() {
        if (this.res == null) {
            this.res = Transport.res;
        }
        return this.res;
    }

    private JTextField getTxtOpening() {
        if (this.txtOpening == null) {
            this.txtOpening = new JTextField();
            this.txtOpening.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(PnlDetailAgence.this.txtOpening);
                }
            });
        }
        return this.txtOpening;
    }

    private JTextField getTxtClose() {
        if (this.txtClose == null) {
            this.txtClose = new JTextField();
            this.txtClose.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(PnlDetailAgence.this.txtClose);
                }
            });
        }
        return this.txtClose;
    }

    @Override
    public void loadData() {
        if (!this.load) {
            this.loadAgence();
            this.load = true;
        }
    }

    public void setAgence(Agence detail) {
        this.current = detail;
        this.load = false;
    }

    public void loadAgence() {
        this.getTxtAddress().setText(this.current.getAdresse());
        this.getCbCountry().setSelectedItem(((ComboBoxModel)this.getCbCountry().getModel()).getLabel(this.current.getClePays()));
        this.getCbType().setSelectedItem(((ComboBoxModel)this.getCbType().getModel()).getLabel(this.current.getCleTypeAgence()));
        this.getCbSize().setSelectedItem(((ComboBoxModel)this.getCbSize().getModel()).getLabel(this.current.getCleTailleAgence()));
        this.getTxtName().setText(this.current.getDescription());
        this.getTxtCP().setText(this.current.getCodePostal());
        this.getTxtCity().setText(this.current.getVille());
        this.getTxtPhone().setText(this.current.getTel1());
        this.getTxtFax().setText(this.current.getFax());
        this.getTxtCode().setText(this.current.getCleInterneAgence());
        this.getTxtEmail().setText(this.current.getEmail());
        this.getTxtPhone2().setText(this.current.getTel2());
        this.getTxtOpening().setText(ConversionTime.dateFromBDDToFrance(this.current.getDateDebut(), false, true));
        this.getTxtClose().setText(ConversionTime.dateFromBDDToFrance(this.current.getDateFin(), false, true));
        this.getCbSatWork().setSelected(this.current.isSatWork());
        this.getCbRegion().setSelectedItem(((ComboBoxModel)this.getCbRegion().getModel()).getLabel(this.current.getRegionId()));
        this.getCbDefaultCalendar().setSelectedItem(((ComboBoxModel)this.getCbDefaultCalendar().getModel()).getLabel(this.current.getDefaultCalendarId()));
        this.lblSaveDir.setText(LanguageTranslator.getString("agency.saveDir", String.valueOf(this.current.getCleAgence())));
    }

    private JComboBox getCbRegion() {
        if (this.cbRegion == null) {
            this.cbRegion = new JComboBox();
            this.cbRegion.setModel(new ComboBoxModel(Region.loadList(((ComboBoxModel)this.getCbCountry().getModel()).getSelectedCle()), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbRegion;
    }

    private JCheckBox getCbSatWork() {
        if (this.cbSatWork == null) {
            this.cbSatWork = new JCheckBox();
        }
        return this.cbSatWork;
    }

    private JComboBox getCbDefaultCalendar() {
        if (this.cbDefaultCalendar == null) {
            this.cbDefaultCalendar = new JComboBox();
            this.cbDefaultCalendar.setModel(new ComboBoxModel(GlobalCalendar.loadList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbDefaultCalendar;
    }

    private JScrollPane getJspTbl() {
        if (this.jspTbl == null) {
            this.jspTbl = new JScrollPane();
        }
        return this.jspTbl;
    }

    private JTable getTblCompanyCard() {
        if (this.tblCompanyCard == null) {
            this.tblCompanyCard = new JTable();
        }
        return this.tblCompanyCard;
    }
}

