/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.agence;

import fr.pgh.component.JFriendlyLoadTable;
import fr.pgh.component.JMultiListBox;
import fr.pgh.component.JPanelButton;
import fr.pgh.component.JTextDate;
import fr.pgh.component.model.MultiListBoxModel;
import fr.pgh.component.ui.WaiterLayerUI;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import fr.pgh.data.bdd.DayPlanning;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.TMDriverPlanning;
import transpo.system.ui.modele.TMVehiclePlanning;
import transpo.system.ui.renderer.DriverTableHeaderRenderer;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.agence.PlaningScrollPane;
import transpo.system.util.Fonctions;
import transpo.system.util.messaging.MessageSystemManager;
import transport.report.CustomReportFactory;
import transport.report.generator.DJGenerator;
import transport.report.generator.DJPlanning;
import transport.report.generator.DJPlanningExcel;

public class PnlPlanningAgence
extends ViewPanel {
    private static final long serialVersionUID = 1L;
    private Agence agence = null;
    private PlaningScrollPane jspDriverTable = null;
    private JFriendlyLoadTable tblDriverData = null;
    private PlaningScrollPane jspVehicleTable = null;
    private JFriendlyLoadTable tblVehicleData = null;
    private JPanel pnlGlobal = null;
    private JTextField txtDebut = null;
    private JTextField txtFin = null;
    private static final String VIEW_NAME = LanguageTranslator.getString("generics.planning");
    Vector<String> date = null;
    Vector<Conducteur> drivers = null;
    Vector<Vehicule> vehicles = null;
    private ArrayList<Map<String, ?>> data = null;
    private JButton btnImprimer = null;
    private JButton btnExport = null;
    private JPanel pnlFilter = null;
    private JPanel pnlDetail = null;
    private JButton btnRefresh = null;
    private JPanel pnlBtn = null;
    private JTabbedPane tab = null;
    private JMultiListBox<Vehicule> mbVehicles = null;
    private JMultiListBox<Conducteur> mbDrivers = null;
    final WaiterLayerUI layerUI = new WaiterLayerUI();
    JCheckBox cbAvailable = null;
    JTextDate txtBegin = null;
    JLabel txtUntil = null;
    JTextDate txtEnd = null;
    JComboBox<JourType> cbDayType = null;
    JComboBox<Conducteur> cbDriversList = null;
    JMultiListBox<Vehicule> mbVehiclesList = null;
    JTextField txtComm = null;
    JPanelButton pnlBtnDetail = null;
    private JCheckBox cbSat = null;
    private JCheckBox cbSun = null;
    JButton btnValid = null;
    JButton btnDel = null;
    private MouseListener driverMouseListener = null;
    private MouseListener vehicleMouseListener = null;
    private DayPlanning current = null;

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close() {
    }

    @Override
    public String getMnemo() {
        return "";
    }

    public PnlPlanningAgence(Agence agence) {
        this.agence = agence;
        this.initialize();
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.fill = 1;
        gridBagConstraints11.weightx = 1.0;
        gridBagConstraints11.gridy = 3;
        this.setLayout(new GridBagLayout());
        JLayer<JPanel> jlayer = new JLayer<JPanel>(this.getPnlGlobal(), this.layerUI);
        this.add(jlayer, Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, null));
    }

    private JPanel getPnlGlobal() {
        if (this.pnlGlobal == null) {
            this.pnlGlobal = new JPanel();
            this.pnlGlobal.setLayout(new GridBagLayout());
            this.pnlGlobal.add((Component)this.getPnlFilter(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 1, 11, new Insets(10, 0, 5, 0)));
            this.pnlGlobal.add((Component)this.getPnlDetail(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 18, new Insets(10, 0, 5, 0)));
            JScrollPane jspDroite = new JScrollPane();
            jspDroite.getViewport().add((Component)this.getTab(), "Center");
            this.pnlGlobal.add((Component)jspDroite, Fonctions.getGridBagConstraints(0, 2, 1, 2, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.pnlGlobal.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 3, 1, 2, 0.0, 0.0, 0, -1, new Insets(10, 0, 5, 0)));
        }
        return this.pnlGlobal;
    }

    private JTabbedPane getTab() {
        if (this.tab == null) {
            this.tab = new JTabbedPane();
            this.tab.addTab(LanguageTranslator.getString("generics.driver"), this.getJspDriverTable());
            this.tab.addTab(LanguageTranslator.getString("generics.vehicle"), this.getJspVehicleTable());
        }
        return this.tab;
    }

    private MouseListener getDriverMouseListener() {
        if (this.driverMouseListener == null) {
            this.driverMouseListener = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    Point p = e.getPoint();
                    int row = PnlPlanningAgence.this.getTblDriverData().rowAtPoint(p);
                    int column = PnlPlanningAgence.this.getTblDriverData().columnAtPoint(p);
                    if (row == -1 || column == -1) {
                        TimsLogger.debug("clic hors d'une cellule");
                        return;
                    }
                    TMDriverPlanning ptm = (TMDriverPlanning)PnlPlanningAgence.this.getTblDriverData().getModel();
                    String day = ptm.getDate().get(column);
                    Vector days = (Vector)ptm.getValueAt(row, column);
                    Conducteur driver = (Conducteur)ptm.getObjectList().get(row);
                    if (e.getClickCount() == 2) {
                        TimsLogger.debug("#GSP.mousseListener# double click on " + day + " " + driver.getNom());
                    } else if (SwingUtilities.isLeftMouseButton(e)) {
                        PnlPlanningAgence.this.loadDay(driver, null, day, days == null ? null : (DayPlanning)days.get(0));
                        ptm.setSelectionBegin(row, column);
                    } else if (SwingUtilities.isRightMouseButton(e)) {
                        PnlPlanningAgence.this.getTxtEnd().setText(ptm.getDate().get(column));
                        ptm.setSelectionEnd(column);
                    }
                }
            };
        }
        return this.driverMouseListener;
    }

    private MouseListener getVehicleMouseListener() {
        if (this.vehicleMouseListener == null) {
            this.vehicleMouseListener = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    Point p = e.getPoint();
                    int row = PnlPlanningAgence.this.getTblDriverData().rowAtPoint(p);
                    int column = PnlPlanningAgence.this.getTblDriverData().columnAtPoint(p);
                    if (row == -1 || column == -1) {
                        TimsLogger.debug("clic hors d'une cellule");
                        return;
                    }
                    TMVehiclePlanning ptm = (TMVehiclePlanning)PnlPlanningAgence.this.getTblVehicleData().getModel();
                    String day = ptm.getDate().get(column);
                    Vector days = (Vector)ptm.getValueAt(row, column);
                    Vehicule vehicle = (Vehicule)ptm.getObjectList().get(row);
                    if (e.getClickCount() == 2) {
                        TimsLogger.debug("#GSP.mousseListener# double click on " + day + " " + vehicle.getRegistrationNumber());
                    } else if (SwingUtilities.isLeftMouseButton(e)) {
                        PnlPlanningAgence.this.loadDay(null, vehicle, day, days == null ? null : (DayPlanning)days.get(0));
                        ptm.setSelectionBegin(row, column);
                    } else if (SwingUtilities.isRightMouseButton(e)) {
                        PnlPlanningAgence.this.getTxtEnd().setText(ptm.getDate().get(column));
                        ptm.setSelectionEnd(column);
                    }
                }
            };
        }
        return this.vehicleMouseListener;
    }

    private void loadDay(Conducteur driver, Vehicule vehicle, String day, DayPlanning dayPlanning) {
        this.current = dayPlanning;
        if (dayPlanning != null) {
            this.getMbVehiclesList().clearSelection();
            this.getTxtBegin().setText(ConversionTime.dateToStringFr(dayPlanning.getDay()));
            this.getTxtEnd().setText("");
            ((ComboBoxModel)this.getCbDayType().getModel()).setSelected(dayPlanning.getDayTypeId());
            ((ComboBoxModel)this.getCbDriversList().getModel()).setSelected(dayPlanning.getDrivers().get(0));
            for (Integer id : dayPlanning.getVehicles()) {
                this.getMbVehiclesList().addSelectedId(id);
            }
            this.getTxtComm().setText(dayPlanning.getComm());
        } else {
            if (driver != null) {
                ((ComboBoxModel)this.getCbDriversList().getModel()).setSelected(driver.getCleConducteur());
            }
            if (vehicle != null) {
                this.getMbVehiclesList().getModel().addSelectedId(vehicle.getId());
            }
            this.getMbVehiclesList().clearSelection();
            ((ComboBoxModel)this.getCbDayType().getModel()).setSelected(System.getProperty("company", "PGH").equals("genex") ? 21 : -1);
            this.getTxtBegin().setText(day == null ? "" : day);
            this.getTxtEnd().setText("");
            this.getTxtComm().setText("");
        }
    }

    private PlaningScrollPane getJspDriverTable() {
        if (this.jspDriverTable == null) {
            this.jspDriverTable = new PlaningScrollPane(0);
        }
        return this.jspDriverTable;
    }

    private PlaningScrollPane getJspVehicleTable() {
        if (this.jspVehicleTable == null) {
            this.jspVehicleTable = new PlaningScrollPane(1);
        }
        return this.jspVehicleTable;
    }

    private JFriendlyLoadTable getTblDriverData() {
        if (this.tblDriverData == null) {
            this.tblDriverData = new JFriendlyLoadTable();
            this.tblDriverData.setRowHeight(22);
            this.tblDriverData.setAutoResizeMode(0);
            if (Transport.conn.isModifiable("PLANNING") || "GENEX".equals(System.getProperty("client", null))) {
                this.tblDriverData.removeMouseListener(this.getDriverMouseListener());
                this.tblDriverData.addMouseListener(this.getDriverMouseListener());
            }
            this.tblDriverData.getTableHeader().setDefaultRenderer(new DriverTableHeaderRenderer());
        }
        return this.tblDriverData;
    }

    private JFriendlyLoadTable getTblVehicleData() {
        if (this.tblVehicleData == null) {
            this.tblVehicleData = new JFriendlyLoadTable();
            this.tblVehicleData.setRowHeight(22);
            this.tblVehicleData.setAutoResizeMode(0);
            if (Transport.conn.isModifiable("PLANNING") || "GENEX".equals(System.getProperty("client", null))) {
                this.tblVehicleData.removeMouseListener(this.getVehicleMouseListener());
                this.tblVehicleData.addMouseListener(this.getVehicleMouseListener());
            }
            this.tblVehicleData.getTableHeader().setDefaultRenderer(new DriverTableHeaderRenderer());
        }
        return this.tblVehicleData;
    }

    private JTextField getTxtDebut() {
        if (this.txtDebut == null) {
            this.txtDebut = new JTextField();
            this.txtDebut.setPreferredSize(new Dimension(70, 20));
            this.txtDebut.setText(ConversionTime.getFirstDayOfMonth(new Date(), ConversionTime.STRING).toString());
            this.txtDebut.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(PnlPlanningAgence.this.getTxtDebut());
                }
            });
        }
        return this.txtDebut;
    }

    private JTextField getTxtFin() {
        if (this.txtFin == null) {
            this.txtFin = new JTextField();
            this.txtFin.setPreferredSize(new Dimension(70, 20));
            this.txtFin.setText(ConversionTime.dateToString(new Date(), "dd/MM/yyyy"));
            this.txtFin.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(PnlPlanningAgence.this.getTxtFin());
                }
            });
        }
        return this.txtFin;
    }

    private JMultiListBox<Vehicule> getMbVehicles() {
        if (this.mbVehicles == null) {
            this.mbVehicles = new JMultiListBox();
            this.mbVehicles.setModel(new MultiListBoxModel<Vehicule>(Vehicule.loadList(this.agence.getCle()), true));
            this.mbVehicles.setPreferredSize(new Dimension(0, 25));
        }
        return this.mbVehicles;
    }

    private JMultiListBox<Conducteur> getMbDrivers() {
        if (this.mbDrivers == null) {
            this.mbDrivers = new JMultiListBox();
            this.mbDrivers.setModel(new MultiListBoxModel<Conducteur>(Conducteur.loadList(this.agence.getCle()), true));
            this.mbDrivers.setPreferredSize(new Dimension(0, 25));
        }
        return this.mbDrivers;
    }

    private JCheckBox getCbSat() {
        if (this.cbSat == null) {
            this.cbSat = new JCheckBox(LanguageTranslator.getString("calendar.satIncluding"));
        }
        return this.cbSat;
    }

    private JCheckBox getCbSun() {
        if (this.cbSun == null) {
            this.cbSun = new JCheckBox(LanguageTranslator.getString("calendar.sunIncluding"));
        }
        return this.cbSun;
    }

    @Override
    public void loadData() {
        if (!this.load) {
            this.refreshTable();
            this.load = true;
        }
    }

    private void refreshTable() {
        Thread t = new Thread(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        (this).PnlPlanningAgence.this.layerUI.start();
                    }
                });
                if (PnlPlanningAgence.this.getTab().getSelectedIndex() == 0) {
                    PnlPlanningAgence.this.loadDriverData();
                } else {
                    PnlPlanningAgence.this.loadVehicleData();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (PnlPlanningAgence.this.getTab().getSelectedIndex() == 0) {
                            PnlPlanningAgence.this.getJspDriverTable().defineTable(PnlPlanningAgence.this.getTblDriverData(), (this).PnlPlanningAgence.this.drivers, (this).PnlPlanningAgence.this.date, PnlPlanningAgence.this.data);
                        } else {
                            PnlPlanningAgence.this.getJspVehicleTable().defineTable(PnlPlanningAgence.this.getTblVehicleData(), (this).PnlPlanningAgence.this.vehicles, (this).PnlPlanningAgence.this.date, PnlPlanningAgence.this.data);
                        }
                    }
                });
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        (this).PnlPlanningAgence.this.layerUI.stop();
                    }
                });
            }
        };
        t.start();
    }

    private void loadDriverData() {
        Date end;
        Transport.ps.startOperation();
        Date begin = ConversionTime.stringToDate(this.getTxtDebut().getText(), "dd/MM/yyyy");
        Date date = end = this.getCbAvailable().isSelected() ? null : ConversionTime.stringToDate(this.getTxtFin().getText(), "dd/MM/yyyy");
        if (end != null && begin.after(end)) {
            MessageSystemManager.error((Component)MainFrameTransport.getInstance(), LanguageTranslator.getString("monitoring.dateError"), LanguageTranslator.getString("message.inputError"));
            return;
        }
        this.date = this.getDateVector(this.getTxtDebut().getText(), this.getCbAvailable().isSelected() ? this.getTxtDebut().getText() : this.getTxtFin().getText());
        this.drivers = this.getMbDrivers().getModel().getSelectedItems();
        this.data = new ArrayList();
        Vector<DayPlanning> tmpL = DayPlanning.loadListByAgency(this.agence.getCleAgence(), begin, end);
        TimsLogger.debug("#PPA.loadTable()# " + this.drivers.size() + " conducteurs, " + tmpL.size() + " jours");
        boolean defaultDayLength = false;
        Object currentContract = null;
        Vector<Object> ljc = new Vector();
        int x = 0;
        while (x < this.drivers.size()) {
            boolean toAdd = true;
            Conducteur currentDriver = this.drivers.get(x);
            HashMap<String, Object> driverData = new HashMap<String, Object>();
            driverData.put(LanguageTranslator.getString("generics.driver"), String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
            Vector<DayPlanning> filtered = DayPlanning.findDriverPlanning(tmpL, currentDriver.getCleConducteur(), null);
            TimsLogger.debug("#PCA.loadTable()# C'est le d\u00e9but du conducteur " + currentDriver.getNom() + " (" + currentDriver.getCleConducteur() + ")" + filtered.size() + " lignes \u00e0 g\u00e9rer");
            boolean ljcLeft = true;
            Date day = begin;
            while (day.compareTo(end == null ? begin : end) <= 0) {
                ljc = DayPlanning.findDriverPlanning(filtered, currentDriver.getCleConducteur(), day);
                if (Transport.debug >= 2) {
                    TimsLogger.debug("#PCA.loadTable()# (" + currentDriver.getCleConducteur() + ") " + ConversionTime.dateToString(day, "dd/MM/yyyy") + " => " + ljc.size());
                }
                String date2 = ConversionTime.dateToString(day, "dd/MM/yyyy");
                if (ljc.size() != 0) {
                    driverData.put(date2, ljc);
                    if (this.getCbAvailable().isSelected()) {
                        toAdd = false;
                    }
                }
                day = ConversionTime.addDay(day, 1);
            }
            if (toAdd) {
                TimsLogger.debug("#PPA.loadTable()# C'est la fin du conducteur " + currentDriver.getNom() + " on l'ajoute");
                this.data.add(driverData);
            } else {
                TimsLogger.debug("#PPA.loadTable()# C'est la fin du conducteur " + currentDriver.getNom() + " on ne l'ajoute pas");
                this.drivers.remove(x);
                --x;
            }
            ++x;
        }
        TimsLogger.info("#PlanningAgence.loadTable# data contient " + this.data.size() + " entr\u00e9es");
        Transport.ps.endOperation(PerformanceScanner.READING, "driver table");
    }

    private void loadVehicleData() {
        Date end;
        Transport.ps.startOperation();
        Date begin = ConversionTime.stringToDate(this.getTxtDebut().getText(), "dd/MM/yyyy");
        Date date = end = this.getCbAvailable().isSelected() ? null : ConversionTime.stringToDate(this.getTxtFin().getText(), "dd/MM/yyyy");
        if (end != null && begin.after(end)) {
            MessageSystemManager.error((Component)MainFrameTransport.getInstance(), LanguageTranslator.getString("monitoring.dateError"), LanguageTranslator.getString("message.inputError"));
            return;
        }
        this.date = this.getDateVector(this.getTxtDebut().getText(), this.getCbAvailable().isSelected() ? this.getTxtDebut().getText() : this.getTxtFin().getText());
        this.vehicles = this.getMbVehicles().getModel().getSelectedItems();
        this.data = new ArrayList();
        Vector<DayPlanning> tmpL = DayPlanning.loadListByAgency(this.agence.getCleAgence(), begin, end);
        TimsLogger.debug("#PCA.loadTable()# " + this.vehicles.size() + " v\u00e9hicule, " + tmpL.size() + " jours");
        boolean defaultDayLength = false;
        Object currentContract = null;
        Vector<Object> ljc = new Vector();
        int x = 0;
        while (x < this.vehicles.size()) {
            boolean toAdd = true;
            Vehicule currentVehicle = this.vehicles.get(x);
            HashMap<String, Object> vehicleData = new HashMap<String, Object>();
            vehicleData.put(LanguageTranslator.getString("generics.vehicle"), currentVehicle.getRegistrationNumber());
            Vector<DayPlanning> filtered = DayPlanning.findVehiclePlanning(tmpL, currentVehicle.getCleVehicule(), null);
            TimsLogger.debug("#PCA.loadTable()# C'est le d\u00e9but du v\u00e9hicule " + currentVehicle.getRegistrationNumber() + " (" + currentVehicle.getCleVehicule() + ")" + filtered.size() + " lignes \u00e0 g\u00e9rer");
            boolean ljcLeft = true;
            Date day = begin;
            while (day.compareTo(end == null ? begin : end) <= 0) {
                ljc = DayPlanning.findVehiclePlanning(filtered, currentVehicle.getCleVehicule(), day);
                if (Transport.debug >= 2) {
                    TimsLogger.debug("#PCA.loadTable()# (" + currentVehicle.getCleVehicule() + ") " + ConversionTime.dateToString(day, "dd/MM/yyyy") + " => " + ljc.size());
                }
                String date2 = ConversionTime.dateToString(day, "dd/MM/yyyy");
                if (ljc.size() != 0) {
                    vehicleData.put(date2, ljc);
                    if (this.getCbAvailable().isSelected()) {
                        toAdd = false;
                    }
                }
                day = ConversionTime.addDay(day, 1);
            }
            if (toAdd) {
                TimsLogger.debug("#PPA.loadTable()# C'est la fin du v\u00e9hicule " + currentVehicle.getRegistrationNumber() + " on l'ajoute");
                this.data.add(vehicleData);
            } else {
                TimsLogger.debug("#PPA.loadTable()# C'est la fin du v\u00e9hicule " + currentVehicle.getRegistrationNumber() + " on ne l'ajoute pas");
                this.vehicles.remove(x);
                --x;
            }
            ++x;
        }
        TimsLogger.info("#PlanningAgence.loadTable# data contient " + this.data.size() + " entr\u00e9es");
        Transport.ps.endOperation(PerformanceScanner.READING, "driver table");
    }

    public void setAgence(Agence current) {
        this.agence = current;
        this.load = false;
    }

    private Vector<String> getDateVector(String dateDebut, String dateFin) {
        Vector<String> tmp = new Vector<String>();
        tmp.add(dateDebut);
        while (!dateDebut.equals(dateFin)) {
            dateDebut = ConversionTime.addDay(dateDebut, "dd/MM/yyyy", 1);
            tmp.add(dateDebut);
        }
        return tmp;
    }

    private void printTbl(String out) {
        CustomReport cr = CustomReportFactory.getGeneric(LanguageTranslator.getString("agency.synthesis"));
        Vector<CustomReportColumn> columns = CustomReportFactory.getDefaultPlanningColumn(this.date);
        cr.setColumn(columns);
        cr.updateProperty("OUT", out);
        cr.updateProperty("TEMPLATE", DJGenerator.LANDSCAPE_TEMPLATE);
        cr.updateProperty("AGENCE", this.agence.getDescription());
        if (out.equals("xls")) {
            if (this.getTab().getSelectedIndex() == 0) {
                Fonctions.tblToReport(cr, new DJPlanningExcel(), ((TMDriverPlanning)this.getTblDriverData().getModel()).getExcelData(), out);
            } else {
                Fonctions.tblToReport(cr, new DJPlanningExcel(), ((TMVehiclePlanning)this.getTblVehicleData().getModel()).getData(), out);
            }
        } else if (this.getTab().getSelectedIndex() == 0) {
            Fonctions.tblToReport(cr, new DJPlanning(), ((TMDriverPlanning)this.getTblDriverData().getModel()).getData(), out);
        } else {
            Fonctions.tblToReport(cr, new DJPlanning(), ((TMVehiclePlanning)this.getTblVehicleData().getModel()).getData(), out);
        }
    }

    private JButton getBtnImprimer() {
        if (this.btnImprimer == null) {
            this.btnImprimer = new JButton();
            this.btnImprimer.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_print"))));
            this.btnImprimer.setPreferredSize(new Dimension(35, 35));
            this.btnImprimer.setToolTipText(LanguageTranslator.getString("button.print"));
            this.btnImprimer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlPlanningAgence.this.printTbl("\u00e9cran");
                }
            });
        }
        return this.btnImprimer;
    }

    private JButton getBtnExport() {
        if (this.btnExport == null) {
            this.btnExport = new JButton();
            this.btnExport.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_xls"))));
            this.btnExport.setPreferredSize(new Dimension(35, 35));
            this.btnExport.setToolTipText(LanguageTranslator.getString("button.export"));
            this.btnExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlPlanningAgence.this.printTbl("xls");
                    PnlPlanningAgence.this.refreshTable();
                }
            });
        }
        return this.btnExport;
    }

    private JPanel getPnlFilter() {
        if (this.pnlFilter == null) {
            this.pnlFilter = new JPanel();
            this.pnlFilter.setBorder(new TitledBorder(LanguageTranslator.getString("generics.filter")));
            this.pnlFilter.setLayout(new GridBagLayout());
            this.pnlFilter.add((Component)new JLabel(LanguageTranslator.getString("generics.available")), Fonctions.getGridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.pnlFilter.add((Component)this.getCbAvailable(), Fonctions.getGridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.pnlFilter.add((Component)new JLabel(LanguageTranslator.getString("generics.from")), Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.pnlFilter.add((Component)this.getTxtDebut(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.pnlFilter.add((Component)new JLabel(LanguageTranslator.getString("generics.to")), Fonctions.getGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.pnlFilter.add((Component)this.getTxtFin(), Fonctions.getGridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.pnlFilter.add(this.getMbDrivers(), Fonctions.getGridBagConstraints(0, 2, 1, 4, 0.0, 0.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.pnlFilter.add(this.getMbVehicles(), Fonctions.getGridBagConstraints(0, 3, 1, 4, 0.0, 0.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.pnlFilter.add((Component)this.getBtnRefresh(), Fonctions.getGridBagConstraints(0, 4, 1, 4, 0.0, 0.0, 1, -1, new Insets(5, 5, 5, 5)));
        }
        return this.pnlFilter;
    }

    private JPanel getPnlDetail() {
        if (this.pnlDetail == null) {
            this.pnlDetail = new JPanel();
            this.pnlDetail.setLayout(new GridBagLayout());
            this.pnlDetail.setBorder(new TitledBorder(LanguageTranslator.getString("generics.addOrModify")));
            JPanel pnlDate = new JPanel();
            pnlDate.add(new JLabel(LanguageTranslator.getString("generics.date")));
            pnlDate.add(this.getTxtBegin());
            pnlDate.add(this.getCbUntil());
            pnlDate.add(this.getTxtEnd());
            pnlDate.add(this.getCbSat());
            pnlDate.add(this.getCbSun());
            this.pnlDetail.add((Component)pnlDate, Fonctions.getGridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 0, -1, new Insets(5, 5, 5, 5)));
            this.pnlDetail.add((Component)new JLabel(LanguageTranslator.getString("generics.day")), Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 5, 5, 5)));
            this.pnlDetail.add(this.getCbDayType(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlDetail.add((Component)new JLabel(LanguageTranslator.getString("generics.driver")), Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 5, 5, 5)));
            this.pnlDetail.add(this.getCbDriversList(), Fonctions.getGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlDetail.add((Component)new JLabel(LanguageTranslator.getString("generics.vehicle")), Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 5, 5, 5)));
            this.pnlDetail.add(this.getMbVehiclesList(), Fonctions.getGridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlDetail.add((Component)new JLabel(LanguageTranslator.getString("generics.comment")), Fonctions.getGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 5, 5, 5)));
            this.pnlDetail.add((Component)this.getTxtComm(), Fonctions.getGridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.pnlDetail.add((Component)this.getPnlBtnDetail(), Fonctions.getGridBagConstraints(0, 5, 1, 4, 1.0, 0.0, 2, -1, new Insets(5, 5, 5, 5)));
        }
        return this.pnlDetail;
    }

    public JComboBox<JourType> getCbDayType() {
        if (this.cbDayType == null) {
            this.cbDayType = new JComboBox(new ComboBoxModel(JourType.getList(), true, LanguageTranslator.getString("generics.none")));
            if ("GENEX".equals(System.getProperty("client", null))) {
                ((ComboBoxModel)this.getCbDayType().getModel()).setSelected(21);
            }
            TimsLogger.debug("Company is " + System.getProperty("company", "PGH"));
        }
        return this.cbDayType;
    }

    public JComboBox<Conducteur> getCbDriversList() {
        if (this.cbDriversList == null) {
            this.cbDriversList = new JComboBox();
            this.cbDriversList.setModel(new ComboBoxModel(Conducteur.loadList(this.agence.getCle()), true, null));
        }
        return this.cbDriversList;
    }

    public JMultiListBox<Vehicule> getMbVehiclesList() {
        if (this.mbVehiclesList == null) {
            this.mbVehiclesList = new JMultiListBox<Vehicule>(Vehicule.loadUnrestrictedList(new Integer[0]), false);
        }
        return this.mbVehiclesList;
    }

    private JTextField getTxtComm() {
        if (this.txtComm == null) {
            this.txtComm = new JTextField();
        }
        return this.txtComm;
    }

    private JCheckBox getCbAvailable() {
        if (this.cbAvailable == null) {
            this.cbAvailable = new JCheckBox();
            this.cbAvailable.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PnlPlanningAgence.this.getTxtFin().setEnabled(!PnlPlanningAgence.this.getCbAvailable().isSelected());
                }
            });
        }
        return this.cbAvailable;
    }

    private JTextDate getTxtBegin() {
        if (this.txtBegin == null) {
            this.txtBegin = new JTextDate();
        }
        return this.txtBegin;
    }

    private JTextDate getTxtEnd() {
        if (this.txtEnd == null) {
            this.txtEnd = new JTextDate();
        }
        return this.txtEnd;
    }

    private JLabel getCbUntil() {
        if (this.txtUntil == null) {
            this.txtUntil = new JLabel(LanguageTranslator.getString("generics.doUntil"));
        }
        return this.txtUntil;
    }

    private JPanelButton getPnlBtnDetail() {
        if (this.pnlBtnDetail == null) {
            this.pnlBtnDetail = new JPanelButton();
            this.pnlBtnDetail.addBtn(this.getBtnValid());
            this.pnlBtnDetail.addBtn(this.getBtnDel());
        }
        return this.pnlBtnDetail;
    }

    private JButton getBtnValid() {
        if (this.btnValid == null) {
            this.btnValid = new JButton();
            this.btnValid.setPreferredSize(new Dimension(25, 25));
            this.btnValid.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_valid"))));
            this.btnValid.setToolTipText(LanguageTranslator.getString("generics.save"));
            this.btnValid.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlPlanningAgence.this.save();
                }
            });
        }
        return this.btnValid;
    }

    private void save() {
        if (this.check()) {
            BddTransport.getInstance().startTransaction();
            boolean ok = true;
            Date day = ConversionTime.stringToDateFr(this.getTxtBegin().getText());
            int driverId = ((ComboBoxModel)this.getCbDriversList().getModel()).getSelectedCle();
            Conducteur driver = (Conducteur)((ComboBoxModel)this.getCbDriversList().getModel()).getObjectAt(this.getCbDriversList().getSelectedIndex());
            TMDriverPlanning ptm = (TMDriverPlanning)this.getTblDriverData().getModel();
            Vector<Vehicule> vehicles = this.getMbVehiclesList().getModel().getSelectedItems();
            TMVehiclePlanning vPtm = null;
            if (!this.isDriverMode()) {
                vPtm = (TMVehiclePlanning)this.getTblVehicleData().getModel();
            }
            int dayTypeId = ((ComboBoxModel)this.getCbDayType().getModel()).getSelectedCle();
            String comm = this.getTxtComm().getText();
            Vector<Integer> vehicleIds = this.getMbVehiclesList().getModel().getSelectedId(false);
            if (!this.getTxtEnd().getText().equals("")) {
                if (this.isDriverMode()) {
                    DayPlanning.deleteDriverDay(driverId, this.getTxtBegin().getText(), this.getTxtEnd().getText());
                } else {
                    int vehicleId = ((Vehicule)((TMVehiclePlanning)this.getTblVehicleData().getModel()).getSelectedObject()).getCleVehicule();
                    DayPlanning.deleteVehicleDay(vehicleId, this.getTxtBegin().getText(), this.getTxtEnd().getText());
                }
            } else {
                DayPlanning.deleteDriverDay(driverId, this.getTxtBegin().getText(), this.getTxtEnd().getText());
                if (this.current != null) {
                    ptm.removeValue(ConversionTime.dateToStringFr(this.current.getDay()), "", driver);
                    if (!this.isDriverMode()) {
                        for (Vehicule toRemove : vehicles) {
                            vPtm.removeValue(ConversionTime.dateToStringFr(this.current.getDay()), "", toRemove);
                        }
                    }
                    ok = this.current.delete();
                }
            }
            this.current = new DayPlanning(0, dayTypeId, ConnexionSettings.getInstance().getUserCle(), day, 0, 0, 1, comm);
            this.current.getDrivers().add(driverId);
            this.current.getVehicles().addAll(vehicleIds);
            ok = this.current.update();
            LienJourConducteur ljc = new LienJourConducteur();
            ljc.setCleUser(ConnexionSettings.getInstance().getUserCle());
            ljc.setCleConducteur(driver.getCleConducteur());
            ljc.setDateJour(day);
            ljc.setHeureDebut(480);
            ljc.setCleJourType(dayTypeId);
            ljc.setType(2);
            ljc.update();
            if (this.isDriverMode()) {
                ptm.removeValue(this.getTxtBegin().getText(), this.getTxtEnd().getText(), driver);
                ptm.addValue(this.getTxtBegin().getText(), driver, this.current);
            } else {
                for (Vehicule toAdd : vehicles) {
                    vPtm.addValue(this.getTxtBegin().getText(), toAdd, this.current);
                }
            }
            if (!this.getTxtEnd().getText().equals("") && ok) {
                Date end = ConversionTime.stringToDateFr(this.getTxtEnd().getText());
                while (day.compareTo(end) < 0) {
                    day = ConversionTime.add(day, 5, 1);
                    int dayOfWeek = ConversionTime.getDayOfWeek(day, false);
                    if (!this.getCbSat().isSelected() && dayOfWeek == 7 || !this.getCbSun().isSelected() && dayOfWeek == 1) continue;
                    DayPlanning more = new DayPlanning(0, dayTypeId, ConnexionSettings.getInstance().getUserCle(), day, 0, 0, 1, comm);
                    more.getDrivers().add(driverId);
                    more.getVehicles().addAll(vehicleIds);
                    ok = more.update();
                    ljc = new LienJourConducteur();
                    ljc.setCleUser(ConnexionSettings.getInstance().getUserCle());
                    ljc.setCleConducteur(driver.getCleConducteur());
                    ljc.setDateJour(day);
                    ljc.setHeureDebut(480);
                    ljc.setCleJourType(dayTypeId);
                    ljc.setType(2);
                    ljc.update();
                    if (this.isDriverMode()) {
                        ptm.addValue(ConversionTime.dateToStringFr(day), driver, more);
                        continue;
                    }
                    for (Vehicule toAdd : vehicles) {
                        vPtm.addValue(ConversionTime.dateToStringFr(day), toAdd, more);
                    }
                }
            }
            if (vPtm != null) {
                vPtm.clearSelection();
            }
            ptm.clearSelection();
            this.current = null;
            this.loadDay(null, null, null, null);
        }
    }

    private boolean isDriverMode() {
        return this.getTab().getSelectedIndex() == 0;
    }

    private boolean check() {
        boolean toReturn = true;
        int driverId = ((ComboBoxModel)this.getCbDriversList().getModel()).getSelectedCle();
        int typeId = ((ComboBoxModel)this.getCbDayType().getModel()).getSelectedCle();
        if (driverId == 0) {
            this.getCbDriversList().setBackground(new Color(255, 192, 203));
            this.getCbDriversList().setToolTipText(LanguageTranslator.getString("generics.fillNeeded", "40"));
            toReturn = false;
        } else {
            this.getCbDriversList().setBackground(UIManager.getColor("ComboBox.background"));
        }
        if (typeId == 0) {
            this.getCbDayType().setBackground(new Color(255, 192, 203));
            this.getCbDayType().setToolTipText(LanguageTranslator.getString("generics.fillNeeded", "40"));
            toReturn = false;
        } else {
            this.getCbDayType().setBackground(UIManager.getColor("ComboBox.background"));
        }
        if (this.getTxtComm().getText().length() > 40) {
            this.getTxtComm().setBackground(new Color(255, 192, 203));
            this.getTxtComm().setToolTipText(LanguageTranslator.getString("generics.maxAuthorised", "40"));
            toReturn = false;
        } else {
            this.getTxtComm().setBackground(Color.white);
        }
        if (this.getTxtBegin().getText().equals("")) {
            this.getTxtBegin().setBackground(new Color(255, 192, 203));
            this.getTxtBegin().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtBegin().setBackground(Color.white);
        }
        if (!this.getTxtEnd().getText().equals("") && ConversionTime.stringToDateFr(this.getTxtEnd().getText()).compareTo(ConversionTime.stringToDateFr(this.getTxtBegin().getText())) <= 0) {
            this.getTxtEnd().setBackground(new Color(255, 192, 203));
            this.getTxtEnd().setToolTipText(LanguageTranslator.getString("generics.endBeforeBegin"));
            toReturn = false;
        } else {
            this.getTxtEnd().setBackground(Color.white);
        }
        return toReturn;
    }

    private JButton getBtnDel() {
        if (this.btnDel == null) {
            this.btnDel = new JButton();
            this.btnDel.setPreferredSize(new Dimension(25, 25));
            this.btnDel.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_sup"))));
            this.btnDel.setToolTipText(LanguageTranslator.getString("button.delete"));
            this.btnDel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PnlPlanningAgence.this.getTxtBegin().getText().equals("")) {
                        PnlPlanningAgence.this.getTxtBegin().setBackground(new Color(255, 192, 203));
                        PnlPlanningAgence.this.getTxtBegin().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
                    } else {
                        PnlPlanningAgence.this.getTxtBegin().setBackground(Color.white);
                        if (PnlPlanningAgence.this.getTab().getSelectedIndex() == 0) {
                            int driverId = ((ComboBoxModel)PnlPlanningAgence.this.getCbDriversList().getModel()).getSelectedCle();
                            if (driverId == 0) {
                                PnlPlanningAgence.this.getCbDriversList().setBackground(new Color(255, 192, 203));
                                PnlPlanningAgence.this.getCbDriversList().setToolTipText(LanguageTranslator.getString("generics.fillNeeded", "40"));
                            } else {
                                PnlPlanningAgence.this.getCbDriversList().setBackground(Color.white);
                                DayPlanning.deleteDriverDay(driverId, PnlPlanningAgence.this.getTxtBegin().getText(), PnlPlanningAgence.this.getTxtEnd().getText());
                                TMDriverPlanning ptm = (TMDriverPlanning)PnlPlanningAgence.this.getTblDriverData().getModel();
                                Conducteur driver = (Conducteur)((ComboBoxModel)PnlPlanningAgence.this.getCbDriversList().getModel()).getObjectAt(PnlPlanningAgence.this.getCbDriversList().getSelectedIndex());
                                ptm.removeValue(PnlPlanningAgence.this.getTxtBegin().getText(), PnlPlanningAgence.this.getTxtEnd().getText(), driver);
                            }
                        } else {
                            int vehicleId = ((Vehicule)((TMVehiclePlanning)PnlPlanningAgence.this.getTblVehicleData().getModel()).getSelectedObject()).getCleVehicule();
                            DayPlanning.deleteVehicleDay(vehicleId, PnlPlanningAgence.this.getTxtBegin().getText(), PnlPlanningAgence.this.getTxtEnd().getText());
                        }
                    }
                    PnlPlanningAgence.this.loadDay(null, null, null, null);
                }
            });
        }
        return this.btnDel;
    }

    private JButton getBtnRefresh() {
        if (this.btnRefresh == null) {
            this.btnRefresh = new JButton();
            this.btnRefresh.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_refresh"))));
            this.btnRefresh.setPreferredSize(new Dimension(25, 25));
            this.btnRefresh.setToolTipText(LanguageTranslator.getString("button.load"));
            this.btnRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlPlanningAgence.this.refreshTable();
                }
            });
        }
        return this.btnRefresh;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.insets = new Insets(0, 0, 5, 0);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(0, 0, 5, 5);
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnImprimer(), gridBagConstraints4);
            this.pnlBtn.add((Component)this.getBtnExport(), gridBagConstraints5);
        }
        return this.pnlBtn;
    }
}

