/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.agence;

import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Intervention;
import fr.pgh.data.bdd.JourUEV;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.modele.TMPrintable2;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.agence.GlobalScrollPane;
import transpo.system.util.Fonctions;

public class PnlVehiculeAgence
extends ViewPanel {
    private static final long serialVersionUID = 1L;
    private Agence agence = null;
    private GlobalScrollPane jspTable = null;
    private JTable tableVehicule = null;
    private JTextField txtDebut = null;
    private JTextField txtFin = null;
    private static final String VIEW_NAME = LanguageTranslator.getString("generics.vehicle");
    Vector<String> date = null;
    Vector<Vehicule> vehicles = null;
    private ArrayList<Map<String, ?>> data = null;
    private JPanel pnlPpl = null;
    private JPanel pnlBtn = null;
    private JButton btnImprimer = null;
    private JButton btnExport = null;
    private Date begin = null;
    private Date end = null;

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close() {
    }

    @Override
    public String getMnemo() {
        return "";
    }

    public PnlVehiculeAgence(Agence agence) {
        this.agence = agence;
        this.loadTable();
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.fill = 1;
        gridBagConstraints11.weighty = 1.0;
        gridBagConstraints11.weightx = 1.0;
        this.setSize(600, 400);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getPnlPpl(), gridBagConstraints11);
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    private GlobalScrollPane getJspTable() {
        if (this.jspTable == null) {
            this.jspTable = new GlobalScrollPane(1);
        }
        return this.jspTable;
    }

    private JTable getTableVehicule() {
        if (this.tableVehicule == null) {
            this.tableVehicule = new JTable();
            this.tableVehicule.setAutoResizeMode(0);
            this.tableVehicule.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row = PnlVehiculeAgence.this.getTableVehicule().rowAtPoint(e.getPoint());
                    int col = PnlVehiculeAgence.this.getTableVehicule().columnAtPoint(e.getPoint());
                    Object value = ((TMPrintable2)PnlVehiculeAgence.this.getTableVehicule().getModel()).getValueAt(row, col);
                    TimsLogger.verbose("clic on table " + row + " " + col + " " + value.toString());
                    if (value instanceof Intervention) {
                        Fonctions.showDialogInterv((Intervention)value, null);
                        PnlVehiculeAgence.this.loadTable();
                    }
                }
            });
        }
        return this.tableVehicule;
    }

    private JTextField getTxtDebut() {
        if (this.txtDebut == null) {
            this.txtDebut = new JTextField(){

                @Override
                public void setText(String t) {
                    PnlVehiculeAgence.this.begin = ConversionTime.stringToDate(t, "dd/MM/yyyy");
                    super.setText(t);
                }
            };
            this.txtDebut.setPreferredSize(new Dimension(60, 20));
            this.txtDebut.setText(ConversionTime.getFirstDayOfMonth(new Date(), ConversionTime.STRING).toString());
            this.txtDebut.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Fonctions.afficheCalendrier(PnlVehiculeAgence.this.getTxtDebut())) {
                        PnlVehiculeAgence.this.loadTable();
                    }
                }
            });
        }
        return this.txtDebut;
    }

    private JTextField getTxtFin() {
        if (this.txtFin == null) {
            this.txtFin = new JTextField(){

                @Override
                public void setText(String t) {
                    PnlVehiculeAgence.this.end = ConversionTime.stringToDate(t, "dd/MM/yyyy");
                    super.setText(t);
                }
            };
            this.txtFin.setPreferredSize(new Dimension(60, 20));
            this.txtFin.setText(ConversionTime.dateToString(new Date(), "dd/MM/yyyy"));
            this.txtFin.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Fonctions.afficheCalendrier(PnlVehiculeAgence.this.getTxtFin())) {
                        PnlVehiculeAgence.this.loadTable();
                    }
                }
            });
        }
        return this.txtFin;
    }

    @Override
    public void loadData() {
        if (!this.load) {
            this.loadTable();
            this.load = true;
        }
    }

    public void setAgence(Agence agence) {
        this.agence = agence;
        this.load = false;
    }

    private void loadTable() {
        Transport.ps.startOperation();
        String dateDebut = ConversionTime.dateFromFranceToBDD(this.getTxtDebut().getText(), false);
        String dateFin = ConversionTime.dateFromFranceToBDD(this.getTxtFin().getText(), false);
        if (this.begin.after(this.end)) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("monitoring.dateError"), LanguageTranslator.getString("message.inputError"), 0);
            return;
        }
        this.date = this.getDateVector(this.getTxtDebut().getText(), this.getTxtFin().getText());
        this.vehicles = Vehicule.loadList(this.agence.getCleAgence());
        this.data = new ArrayList();
        this.loadTableActivite(dateDebut, dateFin);
        this.getJspTable().defineTable(this.getTableVehicule(), this.vehicles, this.date, this.data);
        Transport.ps.endOperation(PerformanceScanner.READING, "vehicle table");
    }

    private void loadTableActivite(String dateDebut, String dateFin) {
        Vector<JourUEV> tmp = JourUEV.getJourUEV(dateDebut, dateFin, this.agence.getCleAgence(), 0, false);
        Vector<Intervention> intervs = Intervention.loadList(this.agence.getCleAgence(), 0, dateDebut, dateFin);
        Vector<Intervention> nextIntervs = Fonctions.getNextIntervention(Intervention.loadLastList(this.agence.getCleAgence(), 0), this.vehicles, false, this.begin, this.end);
        int x = 0;
        for (Vehicule currentVehicle : this.vehicles) {
            String date;
            int total = 0;
            HashMap<String, Object> vehicleData = new HashMap<String, Object>();
            this.data.add(vehicleData);
            vehicleData.put(LanguageTranslator.getString("generics.vehicle"), currentVehicle.getRegistrationNumber());
            while (x < tmp.size()) {
                if (tmp.get(x).getVehicleId() != currentVehicle.getCleVehicule()) break;
                String date2 = ConversionTime.dateToString(tmp.get(x).getDay(), "dd/MM");
                vehicleData.put(date2, tmp.get(x).getTotal());
                total += tmp.get(x).getTotal();
                ++x;
            }
            for (Intervention interv : intervs) {
                if (interv.getVehicleId() != currentVehicle.getCleVehicule() || !this.isInLimit(interv.getDay()) || interv.getState() == 2) continue;
                date = String.valueOf(ConversionTime.dateToString(interv.getDay(), "dd/MM")) + "_INT";
                vehicleData.put(date, interv);
            }
            for (Intervention interv : nextIntervs) {
                if (interv.getVehicleId() != currentVehicle.getCleVehicule() || !this.isInLimit(interv.getDay())) continue;
                date = String.valueOf(ConversionTime.dateToString(interv.getDay(), "dd/MM")) + "_INT";
                vehicleData.put(date, interv);
            }
            vehicleData.put(LanguageTranslator.getString("generics.total"), total);
        }
    }

    private boolean isInLimit(Date day) {
        return this.begin.compareTo(day) <= 0 && day.compareTo(this.end) <= 0;
    }

    private Vector<String> getDateVector(String dateDebut, String dateFin) {
        Vector<String> tmp = new Vector<String>();
        tmp.add(dateDebut.substring(0, 5));
        while (!dateDebut.equals(dateFin)) {
            dateDebut = ConversionTime.addDay(dateDebut, "dd/MM/yyyy", 1);
            tmp.add(dateDebut.substring(0, 5));
        }
        return tmp;
    }

    private JPanel getPnlPpl() {
        if (this.pnlPpl == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.gridwidth = 3;
            gridBagConstraints13.fill = 2;
            gridBagConstraints13.gridy = 2;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 2;
            gridBagConstraints12.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.anchor = 10;
            gridBagConstraints1.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 0.0;
            gridBagConstraints1.fill = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(5, 5, 0, 5);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 3;
            gridBagConstraints4.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 4;
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.pnlPpl = new JPanel();
            this.pnlPpl.setLayout(new GridBagLayout());
            this.pnlPpl.add((Component)this.getJspTable(), gridBagConstraints);
            this.pnlPpl.add((Component)this.getTxtFin(), gridBagConstraints2);
            this.pnlPpl.add((Component)this.getTxtDebut(), gridBagConstraints1);
            this.pnlPpl.add((Component)this.getPnlBtn(), gridBagConstraints13);
        }
        return this.pnlPpl;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.insets = new Insets(0, 0, 5, 0);
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.insets = new Insets(0, 0, 5, 5);
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
        }
        return this.pnlBtn;
    }

    private JButton getBtnImprimer() {
        if (this.btnImprimer == null) {
            this.btnImprimer = new JButton();
            this.btnImprimer.setText(LanguageTranslator.getString("button.print"));
        }
        return this.btnImprimer;
    }

    private JButton getBtnExport() {
        if (this.btnExport == null) {
            this.btnExport = new JButton();
            this.btnExport.setText(LanguageTranslator.getString("button.export"));
        }
        return this.btnExport;
    }
}

