/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.agence;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.RoundAffectation;
import fr.pgh.data.bdd.RoundType;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class RoundGraphic
extends JPanel
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
Printable {
    private static final long serialVersionUID = 1L;
    private Vector<RoundAffectation> r = new Vector();
    private Vector<RoundType> ro = new Vector();
    private Vector<Service> s = null;
    private JPanel nameHeader = null;
    private JPanel hourHeader = null;
    int dayPosition = 0;
    boolean isPopupVisible = false;
    private int dayHeight = 40;
    private float minuteWidth = 0.0f;
    int theoricRoundPosition = -2;
    int theoricFlagHeight = 8;
    int theoricRoundHeight = 5;
    int doneRoundPosition = -18;
    int doneFlagHeight = 8;
    int doneRoundHeight = 5;
    int stringHeight = 15;
    int nameWidth = 200;
    private boolean checkRight = true;

    public RoundGraphic() {
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setInitialDelay(10);
        ToolTipManager.sharedInstance().setReshowDelay(10);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
    }

    public RoundGraphic(boolean checkRight) {
        this.checkRight = checkRight;
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setInitialDelay(10);
        ToolTipManager.sharedInstance().setReshowDelay(10);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
    }

    public void initialiser(Vector<RoundAffectation> r, Vector<Service> s) {
        TimsLogger.verbose("#RoundGraphic# on recharge " + r.size() + " tourn\u00e9e");
        this.r = r;
        this.s = s;
        this.ro.clear();
        int graphHeight = this.dayHeight * r.size();
        this.setPreferredSize(new Dimension(this.getWidth(), graphHeight + 15));
        this.setSize(this.getWidth(), graphHeight + 15);
        this.repaint();
    }

    public JPanel getNameHeader() {
        if (this.nameHeader == null) {
            this.nameHeader = new JPanel(){

                @Override
                public void paint(Graphics g) {
                    int i = 0;
                    while (i <= RoundGraphic.this.r.size()) {
                        g.setColor(Color.BLACK);
                        g.drawLine(0, i * RoundGraphic.this.dayHeight, (int)(24.0f * RoundGraphic.this.minuteWidth * 60.0f), i * RoundGraphic.this.dayHeight);
                        ++i;
                    }
                }
            };
        }
        this.nameHeader.setPreferredSize(new Dimension(150, this.getHeight()));
        return this.nameHeader;
    }

    public JPanel getHourHeader() {
        if (this.hourHeader == null) {
            this.hourHeader = new JPanel(){

                @Override
                public void paint(Graphics g) {
                    int graphTotalHeight = RoundGraphic.this.dayHeight * RoundGraphic.this.r.size() + RoundGraphic.this.stringHeight;
                    int x = 0;
                    while (x <= 24) {
                        int xPos = (int)((float)x * RoundGraphic.this.minuteWidth * 60.0f);
                        if (x == 0) {
                            g.drawString("0", xPos, RoundGraphic.this.stringHeight - 2);
                        } else if (x == 24) {
                            g.drawString("24", xPos - 14, RoundGraphic.this.stringHeight - 2);
                        } else {
                            g.drawString(String.valueOf(x), xPos - 4, RoundGraphic.this.stringHeight - 2);
                        }
                        ++x;
                    }
                }
            };
            this.hourHeader.setPreferredSize(new Dimension(0, this.stringHeight));
        }
        return this.hourHeader;
    }

    @Override
    public void paint(Graphics g) {
        int xPos;
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.getHourHeader().repaint();
        this.getNameHeader().repaint();
        this.minuteWidth = (float)(this.getWidth() - this.nameWidth) / 1440.0f;
        int dayCount = this.r.size();
        g.setColor(Color.black);
        int x = 0;
        while (x <= 24) {
            xPos = (int)((float)x * this.minuteWidth * 60.0f) + this.nameWidth;
            if (x == 24) {
                g.drawString("24", xPos - 14, this.stringHeight - 2);
            } else {
                g.drawString(String.valueOf(x), xPos - 4, this.stringHeight - 2);
            }
            g.drawLine(xPos, this.stringHeight, xPos, this.getHeight());
            ++x;
        }
        if (this.getWidth() > 1000) {
            g.setColor(Color.lightGray);
            x = 0;
            while (x < 24) {
                xPos = (int)((float)x * this.minuteWidth * 60.0f + 30.0f * this.minuteWidth + (float)this.nameWidth);
                g.drawLine(xPos, 0, xPos, this.getHeight());
                ++x;
            }
        }
        if (this.getWidth() > 1600) {
            g.setColor(new Color(240, 240, 240));
            x = 0;
            while (x < 24) {
                xPos = (int)((float)x * this.minuteWidth * 60.0f + 15.0f * this.minuteWidth + (float)this.nameWidth);
                g.drawLine(xPos, 0, xPos, this.getHeight());
                xPos = (int)((float)xPos + 30.0f * this.minuteWidth);
                g.drawLine(xPos, 0, xPos, this.getHeight());
                ++x;
            }
        }
        int i = 0;
        while (i <= this.r.size()) {
            g.setColor(Color.BLACK);
            if (i < this.r.size()) {
                this.drawDay(this.r.get(i), this.s == null ? null : this.s.get(i), g, (i + 1) * this.dayHeight + this.stringHeight);
            }
            g.drawLine(0, i * this.dayHeight + this.stringHeight, (int)(24.0f * this.minuteWidth * 60.0f + (float)this.nameWidth), i * this.dayHeight + this.stringHeight);
            ++i;
        }
    }

    void drawDay(RoundAffectation roundA, Service day, Graphics g, int PosY) {
        if (roundA == null) {
            TimsLogger.verbose("#RoundGraphic.paint# pas de tourn\u00e9es \u00e0 afficher ????");
        } else {
            RoundType rt = RoundType.getRoundType(null, roundA.getRoundId());
            this.ro.add(rt);
            int begin = this.getMinPos(rt.getBeginTime());
            int loadTime = (int)((float)rt.getLoadTime() * this.minuteWidth);
            int agencyLeft = this.getMinPos(rt.getBeginTime() + rt.getLoadTime());
            int agencyReturn = this.getMinPos(rt.getReturnTime());
            int unloadTime = (int)((float)rt.getUnloadTime() * this.minuteWidth);
            int end = this.getMinPos(rt.getReturnTime() + rt.getUnloadTime());
            int yForTheoric = PosY + this.theoricRoundPosition - this.theoricFlagHeight;
            g.setColor(Color.darkGray);
            g.fillRect(begin, yForTheoric, loadTime, this.theoricFlagHeight);
            g.fillRect(agencyReturn, yForTheoric, unloadTime, this.theoricFlagHeight);
            g.setColor(Color.darkGray);
            g.fillRect(begin + 1, PosY + this.theoricRoundPosition - this.theoricRoundHeight, end - begin - 2, this.theoricRoundHeight);
            int driverPos = PosY - 26;
            int vehiclePos = PosY - 14;
            int datePos = PosY - 2;
            String driver = LanguageTranslator.getString("generics.unknown");
            try {
                Conducteur tmp = Conducteur.getDriver(Conducteur.getList(), roundA.getDriverId());
                int index = tmp.getPrenom().indexOf(" ");
                String prenom = tmp.getPrenom();
                if (index != -1) {
                    prenom = tmp.getPrenom().substring(0, index);
                }
                driver = String.valueOf(tmp.getNom()) + " " + prenom;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            g.drawString(driver, 5, driverPos);
            String vehicle = LanguageTranslator.getString("generics.unknown");
            try {
                Vehicule tmp = Vehicule.getVehicule(Vehicule.getList(), roundA.getVehicleId());
                vehicle = tmp.getRegistrationNumber();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            g.drawString(vehicle, 5, vehiclePos);
            g.drawString(String.valueOf(ConversionTime.dateToString(roundA.getRoundDate(), "dd/MM/yyyy")) + " - " + rt.getCode(), 5, datePos);
            if (roundA.isDone()) {
                int yForDone = PosY + this.doneRoundPosition;
                begin = this.getMinPos(roundA.getBeginTime());
                loadTime = (int)((float)roundA.getLoadTime() * this.minuteWidth);
                agencyLeft = this.getMinPos(roundA.getBeginTime() + roundA.getLoadTime());
                agencyReturn = this.getMinPos(roundA.getReturnTime());
                unloadTime = (int)((float)roundA.getUnloadTime() * this.minuteWidth);
                end = this.getMinPos(roundA.getReturnTime() + roundA.getUnloadTime());
                g.setColor(Color.gray);
                g.fillRect(begin, yForDone, loadTime, this.doneFlagHeight);
                g.fillRect(agencyReturn, yForDone, unloadTime, this.doneFlagHeight);
                g.setColor(Color.gray);
                g.fillRect(begin + 1, yForDone, end - begin - 2, this.doneRoundHeight);
            }
        }
    }

    public int getMinPos(int minute) {
        return (int)((float)minute * this.minuteWidth + (float)this.nameWidth);
    }

    @Override
    public int print(Graphics g, PageFormat tmp, int x) {
        return 0;
    }

    public int getY(int Y, int decalage) {
        int coef = Y / this.dayHeight + 1;
        return coef * this.dayHeight - decalage;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
        int mouseX = arg0.getX();
        int mouseY = arg0.getY();
        this.dayPosition = mouseY - this.stringHeight / this.dayHeight;
        this.setToolTipText(null);
        if (this.dayPosition == 0 || this.dayPosition > this.r.size()) {
            return;
        }
        RoundAffectation roundA = this.r.get(this.dayPosition - 1);
        Service service = this.s == null ? null : this.s.get(this.dayPosition - 1);
        RoundType rt = this.ro.get(this.dayPosition - 1);
        if (roundA != null) {
            int begin = this.getMinPos(rt.getBeginTime());
            int loadTime = (int)((float)rt.getLoadTime() * this.minuteWidth);
            int agencyLeft = this.getMinPos(rt.getBeginTime() + rt.getLoadTime());
            int agencyReturn = this.getMinPos(rt.getReturnTime());
            int unloadTime = (int)((float)rt.getUnloadTime() * this.minuteWidth);
            int end = this.getMinPos(rt.getReturnTime() + rt.getUnloadTime());
            int yForTheoric = this.dayPosition * this.dayHeight + this.stringHeight + this.theoricRoundPosition - this.theoricFlagHeight;
            if (mouseX >= begin && mouseX <= agencyLeft && mouseY <= this.getY(mouseY, 0) && mouseY >= this.getY(mouseY, 0) - this.theoricFlagHeight) {
                this.setToolTipText(LanguageTranslator.getString("graphic.round.loadTheorical.toolTip", ConversionTime.heureIntToString(begin, "h"), ConversionTime.heureIntToString(agencyLeft, "h"), ConversionTime.heureIntToString(loadTime, "h")));
                return;
            }
            if (mouseX >= agencyLeft && mouseX <= agencyReturn && mouseY <= this.getY(mouseY, 0) && mouseY >= this.getY(mouseY, 0) - this.theoricFlagHeight) {
                this.setToolTipText(LanguageTranslator.getString("graphic.round.timeTheorical.toolTip", ConversionTime.heureIntToString(agencyLeft, "h"), ConversionTime.heureIntToString(agencyReturn, "h"), ConversionTime.heureIntToString(agencyReturn - agencyLeft, "h"), ConversionTime.heureIntToString(rt.getTotalTime(), "h")));
                return;
            }
            if (mouseX >= agencyReturn && end <= end && mouseY <= this.getY(mouseY, 0) && mouseY >= this.getY(mouseY, 0) - this.theoricFlagHeight) {
                this.setToolTipText(LanguageTranslator.getString("graphic.round.unloadTheorical.toolTip", ConversionTime.heureIntToString(agencyReturn, "h"), ConversionTime.heureIntToString(end, "h"), ConversionTime.heureIntToString(unloadTime, "h")));
                return;
            }
            if (roundA.isDone()) {
                int yForDone = this.dayPosition * this.dayHeight + this.doneRoundPosition;
                begin = this.getMinPos(roundA.getBeginTime());
                loadTime = (int)((float)roundA.getLoadTime() * this.minuteWidth);
                agencyLeft = this.getMinPos(roundA.getBeginTime() + roundA.getLoadTime());
                agencyReturn = this.getMinPos(roundA.getReturnTime());
                unloadTime = (int)((float)roundA.getUnloadTime() * this.minuteWidth);
                end = this.getMinPos(roundA.getReturnTime() + roundA.getUnloadTime());
                if (mouseX >= begin && mouseX <= agencyLeft && mouseY <= this.getY(mouseY, 0) - this.theoricFlagHeight && mouseY >= this.getY(mouseY, 0) - this.doneFlagHeight) {
                    this.setToolTipText(LanguageTranslator.getString("graphic.round.loadDone.toolTip", ConversionTime.heureIntToString(begin, "h"), ConversionTime.heureIntToString(agencyLeft, "h"), ConversionTime.heureIntToString(loadTime, "h")));
                    return;
                }
                if (mouseX >= agencyLeft && mouseX <= agencyReturn && mouseY <= this.getY(mouseY, 0) - this.theoricFlagHeight && mouseY >= this.getY(mouseY, 0) - this.doneFlagHeight) {
                    this.setToolTipText(LanguageTranslator.getString("graphic.round.loadDone.toolTip", ConversionTime.heureIntToString(agencyLeft, "h"), ConversionTime.heureIntToString(agencyReturn, "h"), ConversionTime.heureIntToString(agencyReturn - agencyLeft, "h"), ConversionTime.heureIntToString(rt.getTotalTime(), "h")));
                    return;
                }
                if (mouseX >= agencyReturn && end <= end && mouseY <= this.getY(mouseY, 0) - this.theoricFlagHeight && mouseY >= this.getY(mouseY, 0) - this.doneFlagHeight) {
                    this.setToolTipText(LanguageTranslator.getString("graphic.round.loadDone.toolTip", ConversionTime.heureIntToString(agencyReturn, "h"), ConversionTime.heureIntToString(end, "h"), ConversionTime.heureIntToString(unloadTime, "h")));
                    return;
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int mouseX = e.getX();
        int finalWidth = 0;
        if (e.getButton() == 1) {
            if (e.getClickCount() == 2) {
                finalWidth = this.getWidth() * 2;
            }
        } else if (e.getButton() == 3 && e.getClickCount() == 2) {
            finalWidth = this.getWidth() / 2;
        }
        int finalPosition = finalWidth * mouseX / this.getWidth();
        double viewPosition = ((JViewport)this.getParent()).getViewPosition().getX();
        int interval = mouseX - (int)viewPosition;
        int finalViewPosition = finalPosition - interval;
        this.setSize(new Dimension(finalWidth, this.getHeight()));
        this.setPreferredSize(new Dimension(finalWidth, this.getHeight()));
        ((JViewport)this.getParent()).setViewPosition(new Point(finalViewPosition, 0));
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent arg0) {
        int notches = arg0.getWheelRotation();
        int ratio = -notches * 100;
        int finalWidth = this.getWidth() + ratio;
        int mouseX = arg0.getX();
        int finalPosition = finalWidth * mouseX / this.getWidth();
        double viewPosition = ((JViewport)this.getParent()).getViewPosition().getX();
        int interval = mouseX - (int)viewPosition;
        int finalViewPosition = finalPosition - interval;
        this.setSize(new Dimension(finalWidth, this.getHeight()));
        this.setPreferredSize(new Dimension(finalWidth, this.getHeight()));
        ((JViewport)this.getParent()).setViewPosition(new Point(finalViewPosition, 0));
    }
}

