/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.calendarManagement;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.GlobalCalendar;
import fr.pgh.data.bdd.GlobalCalendarDay;
import fr.pgh.data.bdd.JourType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.LMCalendar;
import transpo.system.ui.resources.Fmresources;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.ui.calendrier.Calendrier;

public class DialogGlobalCalendar
extends JDialog
implements Observer {
    private static final long serialVersionUID = 1L;
    public Calendrier cal = new Calendrier();
    private static final Fmresources res = new Fmresources();
    private String icon_right = res.getResourceString("icone_right");
    private String icon_left = res.getResourceString("icone_left");
    private ClassLoader cl = this.getClass().getClassLoader();
    private JPanel jContentPane = null;
    private JPanel pnlFiltre = null;
    private JLabel lblAgence = null;
    private JTextField cbCalendar = null;
    private JPanel pnlCal = null;
    private JLabel[] lblJour = new JLabel[7];
    private JLabel lblMois = null;
    private JLabel lblAnnee = null;
    private DayPicture[] jour = new DayPicture[42];
    private JButton btnPrecedent = null;
    private JButton btnSuivant = null;
    private JButton btnPrecedentAnnee = null;
    private JButton btnSuivantAnnee = null;
    private JPanel pnlJour = null;
    private JPanel pnlDate = null;
    private JButton btnAdd = null;
    private JButton btnOk = null;
    private DayListPopup dayTypeList = null;
    private JPanel pnlBtn = null;
    private JScrollPane jspListe = null;
    private JList listCal = null;
    private JPanel pnlDetail = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogCalendrier.dispose()#");
        super.dispose();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.lblAgence.setText(LanguageTranslator.getString("generics.agency"));
    }

    public DialogGlobalCalendar(JFrame owner) {
        super(owner);
        TimsLogger.verbose("#DialogCalendrier()#");
        LanguageTranslator.getInstance().addObserver(this);
        this.initialize();
    }

    private void initialize() {
        this.setSize(750, 450);
        this.setModal(true);
        this.setLocationRelativeTo(this.getParent());
        this.setContentPane(this.getJContentPane());
        this.setTitle(LanguageTranslator.getString("calendar.title"));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints6.gridy = 0;
            GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
            gridBagConstraints51.fill = 1;
            gridBagConstraints51.gridy = 0;
            gridBagConstraints51.weightx = 0.6;
            gridBagConstraints51.weighty = 1.0;
            gridBagConstraints51.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints51.gridx = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = -1;
            gridBagConstraints4.gridy = -1;
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.insets = new Insets(0, 0, 0, 1);
            gridBagConstraints31.gridy = -1;
            gridBagConstraints31.gridx = -1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.gridheight = 1;
            gridBagConstraints11.fill = 0;
            gridBagConstraints11.weightx = 0.0;
            gridBagConstraints11.gridwidth = 2;
            gridBagConstraints11.gridy = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlBtn(), gridBagConstraints11);
            this.jContentPane.add((Component)this.getJspListe(), gridBagConstraints51);
            this.jContentPane.add((Component)this.getPnlDetail(), gridBagConstraints6);
        }
        return this.jContentPane;
    }

    private JPanel getPnlFiltre() {
        if (this.pnlFiltre == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weightx = 0.0;
            gridBagConstraints5.weighty = 0.0;
            gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints1.gridy = 0;
            this.lblAgence = new JLabel();
            this.lblAgence.setText(LanguageTranslator.getString("generics.calendar"));
            this.pnlFiltre = new JPanel();
            this.pnlFiltre.setLayout(new GridBagLayout());
            this.pnlFiltre.add((Component)this.lblAgence, gridBagConstraints1);
            this.pnlFiltre.add((Component)this.getCbCalendar(), gridBagConstraints3);
        }
        return this.pnlFiltre;
    }

    private JTextField getCbCalendar() {
        if (this.cbCalendar == null) {
            this.cbCalendar = new JTextField();
        }
        return this.cbCalendar;
    }

    public void commit() {
        TimsLogger.verbose("#DialogCalendrier# commit");
    }

    private JPanel getPnlCal() {
        if (this.pnlCal == null) {
            this.pnlCal = new JPanel();
            ToolTipManager.sharedInstance().registerComponent(this.pnlCal);
            ToolTipManager.sharedInstance().setInitialDelay(10);
            ToolTipManager.sharedInstance().setReshowDelay(10);
            ToolTipManager.sharedInstance().setDismissDelay(10000);
            this.pnlCal.setLayout(new BorderLayout());
            int x = 0;
            while (x < this.lblJour.length) {
                this.lblJour[x] = new JLabel(Calendrier.DAY_NAME[x].substring(0, 3));
                this.lblJour[x].setHorizontalAlignment(0);
                this.lblJour[x].setHorizontalTextPosition(0);
                ++x;
            }
            int i = 0;
            while (i < this.jour.length) {
                this.jour[i] = new DayPicture();
                this.jour[i].addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        DayPicture source = (DayPicture)e.getSource();
                        if (source.getDayNumber() == 0) {
                            return;
                        }
                        ComboBoxModel tmp = (ComboBoxModel)DialogGlobalCalendar.this.getDayTypeList().getList().getModel();
                        if (source.getDay() != null) {
                            TimsLogger.verbose("jour d\u00e9fini : ");
                            source.getDay().affiche();
                            DialogGlobalCalendar.this.getDayTypeList().getList().setSelectedValue(tmp.getLabel(source.getDay().getDayTypeId()), true);
                        } else {
                            TimsLogger.verbose("jour d\u00e9fini : ");
                            DialogGlobalCalendar.this.getDayTypeList().getList().setSelectedIndex(0);
                        }
                        DialogGlobalCalendar.this.getDayTypeList().show(source, 0, 0);
                    }
                });
                this.jour[i].setBorder(BorderFactory.createEtchedBorder());
                ++i;
            }
            int x2 = 0;
            while (x2 < this.lblJour.length) {
                this.getPnlJour().add(this.lblJour[x2]);
                ++x2;
            }
            x2 = 0;
            while (x2 < this.jour.length / 7) {
                i = 7 * x2;
                while (i < 7 * (x2 + 1)) {
                    this.getPnlJour().add(this.jour[i]);
                    ++i;
                }
                ++x2;
            }
            this.getPnlDate().add(this.getBtnPrecedent());
            this.getPnlDate().add(this.getLblMois());
            this.getPnlDate().add(this.getBtnSuivant());
            this.getPnlDate().add(this.getBtnPrecedentAnnee());
            this.getPnlDate().add(this.getLblAnnee());
            this.getPnlDate().add(this.getBtnSuivantAnnee());
            this.pnlCal.add((Component)this.getPnlJour(), "Center");
            this.pnlCal.add((Component)this.getPnlDate(), "South");
            this.updateCalendar();
        }
        return this.pnlCal;
    }

    public JPanel getPnlJour() {
        if (this.pnlJour == null) {
            this.pnlJour = new JPanel(new GridLayout(7, 7));
        }
        return this.pnlJour;
    }

    public JPanel getPnlDate() {
        if (this.pnlDate == null) {
            this.pnlDate = new JPanel(new FlowLayout());
        }
        return this.pnlDate;
    }

    public JButton getBtnPrecedent() {
        if (this.btnPrecedent == null) {
            this.btnPrecedent = new JButton();
            this.btnPrecedent.setBorder(null);
            this.btnPrecedent.setToolTipText(LanguageTranslator.getString("calendar.previousMonth"));
            this.btnPrecedent.setBorderPainted(false);
            this.btnPrecedent.setContentAreaFilled(false);
            this.btnPrecedent.setFocusPainted(false);
            this.btnPrecedent.setHorizontalTextPosition(0);
            this.btnPrecedent.setIcon(new ImageIcon(this.cl.getResource(this.icon_left)));
            this.btnPrecedent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogGlobalCalendar.this.addMonth(-1);
                }
            });
        }
        return this.btnPrecedent;
    }

    public JButton getBtnSuivant() {
        if (this.btnSuivant == null) {
            this.btnSuivant = new JButton();
            this.btnSuivant.setBorder(null);
            this.btnSuivant.setToolTipText(LanguageTranslator.getString("calendar.nextMonth"));
            this.btnSuivant.setBorderPainted(false);
            this.btnSuivant.setContentAreaFilled(false);
            this.btnSuivant.setFocusPainted(false);
            this.btnSuivant.setHorizontalTextPosition(0);
            this.btnSuivant.setIcon(new ImageIcon(this.cl.getResource(this.icon_right)));
            this.btnSuivant.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogGlobalCalendar.this.addMonth(1);
                }
            });
        }
        return this.btnSuivant;
    }

    public JButton getBtnPrecedentAnnee() {
        if (this.btnPrecedentAnnee == null) {
            this.btnPrecedentAnnee = new JButton();
            this.btnPrecedentAnnee.setBorder(null);
            this.btnPrecedentAnnee.setToolTipText(LanguageTranslator.getString("calendar.previousYear"));
            this.btnPrecedentAnnee.setBorderPainted(false);
            this.btnPrecedentAnnee.setContentAreaFilled(false);
            this.btnPrecedentAnnee.setFocusPainted(false);
            this.btnPrecedentAnnee.setHorizontalTextPosition(0);
            this.btnPrecedentAnnee.setIcon(new ImageIcon(this.cl.getResource(this.icon_left)));
            this.btnPrecedentAnnee.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogGlobalCalendar.this.addMonth(-12);
                }
            });
        }
        return this.btnPrecedentAnnee;
    }

    public JButton getBtnSuivantAnnee() {
        if (this.btnSuivantAnnee == null) {
            this.btnSuivantAnnee = new JButton();
            this.btnSuivantAnnee.setBorder(null);
            this.btnSuivantAnnee.setToolTipText(LanguageTranslator.getString("calendar.nextYear"));
            this.btnSuivantAnnee.setBorderPainted(false);
            this.btnSuivantAnnee.setContentAreaFilled(false);
            this.btnSuivantAnnee.setFocusPainted(false);
            this.btnSuivantAnnee.setHorizontalTextPosition(0);
            this.btnSuivantAnnee.setIcon(new ImageIcon(this.cl.getResource(this.icon_right)));
            this.btnSuivantAnnee.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogGlobalCalendar.this.addMonth(12);
                }
            });
        }
        return this.btnSuivantAnnee;
    }

    public JLabel getLblMois() {
        if (this.lblMois == null) {
            this.lblMois = new JLabel();
            this.lblMois.setBackground(SystemColor.inactiveCaptionBorder);
            this.lblMois.setFont(new Font("Dialog", 1, 16));
            this.lblMois.setForeground(SystemColor.inactiveCaption);
            this.lblMois.setBorder(BorderFactory.createLineBorder(Color.black));
            this.lblMois.setHorizontalAlignment(0);
            this.lblMois.setHorizontalTextPosition(0);
            this.lblMois.setPreferredSize(new Dimension(130, 30));
            this.lblMois.setMaximumSize(new Dimension(130, 30));
        }
        return this.lblMois;
    }

    public JLabel getLblAnnee() {
        if (this.lblAnnee == null) {
            this.lblAnnee = new JLabel();
            this.lblAnnee.setBackground(SystemColor.inactiveCaptionBorder);
            this.lblAnnee.setFont(new Font("Dialog", 1, 16));
            this.lblAnnee.setForeground(SystemColor.inactiveCaption);
            this.lblAnnee.setBorder(BorderFactory.createLineBorder(Color.black));
            this.lblAnnee.setHorizontalAlignment(0);
            this.lblAnnee.setHorizontalTextPosition(0);
        }
        return this.lblAnnee;
    }

    void addMonth(int amount) {
        this.cal.addMonth(amount);
        this.updateCalendar();
    }

    public void update(GlobalCalendar gCalendar) {
        this.updateCalendar();
    }

    public void updateCalendar() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Transport.ps.startOperation();
                int a = 1;
                DialogGlobalCalendar.this.getLblMois().setText(Calendrier.MONTH_NAME[DialogGlobalCalendar.this.cal.getMonth()]);
                DialogGlobalCalendar.this.getLblAnnee().setText(String.valueOf(DialogGlobalCalendar.this.cal.getYear()));
                int pjdm = DialogGlobalCalendar.this.cal.premierJour - 1;
                if (pjdm == 0) {
                    pjdm = 7;
                }
                while (a != pjdm) {
                    DialogGlobalCalendar.this.jour[a - 1].init();
                    ++a;
                }
                String firstDay = String.valueOf(DialogGlobalCalendar.this.getLblAnnee().getText()) + "-" + DialogGlobalCalendar.this.getMoisInt(DialogGlobalCalendar.this.getLblMois().getText()) + "-01";
                String lastDay = String.valueOf(DialogGlobalCalendar.this.getLblAnnee().getText()) + "-" + DialogGlobalCalendar.this.getMoisInt(DialogGlobalCalendar.this.getLblMois().getText()) + "-" + DialogGlobalCalendar.this.cal.nbDayInMonth;
                int selected = DialogGlobalCalendar.this.getListCal().getSelectedIndex();
                Vector<Object> days = null;
                if (DialogGlobalCalendar.this.getListCal().getSelectedIndex() != -1) {
                    int calendarId = ((LMCalendar)DialogGlobalCalendar.this.getListCal().getModel()).getGlobalCalendarAt(selected).getId();
                    days = GlobalCalendarDay.loadList(calendarId, ConversionTime.stringToDate(firstDay, "yyyy-MM-dd"), ConversionTime.stringToDate(lastDay, "yyyy-MM-dd"));
                } else {
                    days = new Vector();
                }
                TimsLogger.debug(firstDay + ", " + lastDay + ", nb jour " + days.size());
                int numJour = 1;
                while (numJour < DialogGlobalCalendar.this.cal.nbDayInMonth + 1) {
                    DialogGlobalCalendar.this.jour[a - 1].init();
                    String sJour = String.valueOf(DialogGlobalCalendar.this.getLblAnnee().getText()) + "-" + DialogGlobalCalendar.this.getMoisInt(DialogGlobalCalendar.this.getLblMois().getText()) + "-" + DialogGlobalCalendar.this.getJourInt(numJour);
                    Date dJour = ConversionTime.stringToDate(sJour, "yyyy-MM-dd");
                    GlobalCalendarDay toShow = null;
                    for (GlobalCalendarDay globalCalendarDay : days) {
                        if (!globalCalendarDay.getDate().equals(dJour)) continue;
                        toShow = globalCalendarDay;
                        break;
                    }
                    DialogGlobalCalendar.this.jour[a - 1].setDay(numJour, toShow);
                    ++a;
                    ++numJour;
                }
                while (a <= DialogGlobalCalendar.this.jour.length) {
                    DialogGlobalCalendar.this.jour[a - 1].init();
                    ++a;
                }
                DialogGlobalCalendar.this.repaint();
                Transport.ps.endOperation(PerformanceScanner.READING, "complementary day");
            }
        });
    }

    String getMoisInt(String jour) {
        String retour = "";
        if (jour.equals(Calendrier.MONTH_NAME[0])) {
            retour = "01";
        } else if (jour.equals(Calendrier.MONTH_NAME[1])) {
            retour = "02";
        } else if (jour.equals(Calendrier.MONTH_NAME[2])) {
            retour = "03";
        } else if (jour.equals(Calendrier.MONTH_NAME[3])) {
            retour = "04";
        } else if (jour.equals(Calendrier.MONTH_NAME[4])) {
            retour = "05";
        } else if (jour.equals(Calendrier.MONTH_NAME[5])) {
            retour = "06";
        } else if (jour.equals(Calendrier.MONTH_NAME[6])) {
            retour = "07";
        } else if (jour.equals(Calendrier.MONTH_NAME[7])) {
            retour = "08";
        } else if (jour.equals(Calendrier.MONTH_NAME[8])) {
            retour = "09";
        } else if (jour.equals(Calendrier.MONTH_NAME[9])) {
            retour = "10";
        } else if (jour.equals(Calendrier.MONTH_NAME[10])) {
            retour = "11";
        } else if (jour.equals(Calendrier.MONTH_NAME[11])) {
            retour = "12";
        }
        return retour;
    }

    String getJourInt(String jour) {
        if (Integer.parseInt(jour) < 10) {
            return "0" + jour;
        }
        return jour;
    }

    String getJourInt(int jour) {
        if (jour < 10) {
            return "0" + jour;
        }
        return String.valueOf(jour);
    }

    private JButton getBtnAdd() {
        if (this.btnAdd == null) {
            this.btnAdd = new JButton(LanguageTranslator.getString("button.new"));
            this.btnAdd.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_cliq"))));
            this.btnAdd.setToolTipText(LanguageTranslator.getString("button.add"));
            this.btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogGlobalCalendar.this.getListCal().setSelectedIndex(-1);
                    DialogGlobalCalendar.this.getCbCalendar().setText("");
                    DialogGlobalCalendar.this.getPnlDetail().setEnabled(false);
                    DialogGlobalCalendar.this.getPnlDetail().setToolTipText("enregistrer le nouveau pour modifier");
                }
            });
        }
        return this.btnAdd;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton(LanguageTranslator.getString("button.save"));
            this.btnOk.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_valid"))));
            this.btnOk.setToolTipText(LanguageTranslator.getString("button.valid"));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogGlobalCalendar.this.valid();
                }
            });
        }
        return this.btnOk;
    }

    public void valid() {
        if (this.getListCal().getSelectedIndex() == -1) {
            if (this.getCbCalendar().getText().equals("")) {
                JOptionPane.showMessageDialog(this, "pas de nom renseign\u00e9");
            } else {
                GlobalCalendar toAdd = new GlobalCalendar(0, this.getCbCalendar().getText());
                toAdd.update();
                this.getListCal().setModel(new LMCalendar(GlobalCalendar.loadList()));
            }
        } else {
            if (!this.getListCal().getSelectedValue().equals(this.getCbCalendar().getText())) {
                GlobalCalendar toUpdate = ((LMCalendar)this.getListCal().getModel()).getGlobalCalendarAt(this.getListCal().getSelectedIndex());
                toUpdate.setName(this.getCbCalendar().getText());
                toUpdate.update();
            }
            this.dispose();
        }
    }

    private DayListPopup getDayTypeList() {
        if (this.dayTypeList == null) {
            this.dayTypeList = new DayListPopup();
        }
        return this.dayTypeList;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add(this.getBtnAdd());
            this.pnlBtn.add(this.getBtnOk());
        }
        return this.pnlBtn;
    }

    private JScrollPane getJspListe() {
        if (this.jspListe == null) {
            this.jspListe = new JScrollPane();
            this.jspListe.setViewportView(this.getListCal());
        }
        return this.jspListe;
    }

    private JList getListCal() {
        if (this.listCal == null) {
            this.listCal = new JList();
            this.listCal.setSelectionMode(0);
            this.listCal.setPreferredSize(new Dimension(0, 0));
            this.listCal.setModel(new LMCalendar(GlobalCalendar.loadList()));
            this.listCal.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    DialogGlobalCalendar.this.getCbCalendar().setText(DialogGlobalCalendar.this.getListCal().getSelectedValue().toString());
                    DialogGlobalCalendar.this.updateCalendar();
                }
            });
        }
        return this.listCal;
    }

    private JPanel getPnlDetail() {
        if (this.pnlDetail == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(0, 5, 0, 5);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.pnlDetail = new JPanel();
            this.pnlDetail.setLayout(new GridBagLayout());
            this.pnlDetail.add((Component)this.getPnlFiltre(), gridBagConstraints);
            this.pnlDetail.add((Component)this.getPnlCal(), gridBagConstraints2);
        }
        return this.pnlDetail;
    }

    public class DayListPopup
    extends JPopupMenu
    implements DataListener {
        JList list = null;
        MouseListener lsl = null;

        @Override
        public void changeUpdate(DataEvent dataEvent) {
            BddEvent e;
            if (dataEvent instanceof BddEvent && (e = (BddEvent)dataEvent).getTable().equals(JourType.table)) {
                this.getList().setModel(new ComboBoxModel(JourType.getList(), true, LanguageTranslator.getString("generics.none")));
            }
        }

        public DayListPopup() {
            this.initialize();
        }

        public void initialize() {
            this.add(this.getList());
        }

        public JList getList() {
            if (this.list == null) {
                this.list = new JList(new ComboBoxModel(JourType.getList(), true, LanguageTranslator.getString("generics.none")));
            }
            return this.list;
        }

        @Override
        public void setVisible(boolean visible) {
            if (!visible) {
                this.getList().removeMouseListener(this.getMouseListener());
            }
            if (visible) {
                this.getList().addMouseListener(this.getMouseListener());
            }
            super.setVisible(visible);
        }

        public void saveAndExit() {
            DayPicture invoker = (DayPicture)this.getInvoker();
            if (invoker == null) {
                TimsLogger.verbose("Oups... no invoker !");
            }
            if (this.getList().getSelectedValue().equals(LanguageTranslator.getString("generics.none"))) {
                if (invoker.getDay() != null) {
                    TimsLogger.debug("On supprime");
                    invoker.getDay().affiche();
                    invoker.getDay().delete();
                    invoker.setDay(invoker.getDayNumber(), null);
                } else {
                    TimsLogger.debug("Pas de journ\u00e9e pour le " + invoker.getDayNumber());
                }
            } else {
                JourType dayType = (JourType)((ComboBoxModel)this.getList().getModel()).getObjectAt(this.getList().getSelectedIndex());
                int selected = dayType.getCle();
                if (invoker.getDay() == null) {
                    String sDate = String.valueOf(DialogGlobalCalendar.this.getLblAnnee().getText()) + "-" + DialogGlobalCalendar.this.getMoisInt(DialogGlobalCalendar.this.getLblMois().getText()) + "-" + (invoker.getDayNumber() < 9 ? "0" + invoker.getDayNumber() : String.valueOf(invoker.getDayNumber()));
                    int selectedCal = DialogGlobalCalendar.this.getListCal().getSelectedIndex();
                    if (selectedCal != -1) {
                        int calendarId = ((LMCalendar)DialogGlobalCalendar.this.getListCal().getModel()).getGlobalCalendarAt(selectedCal).getId();
                        GlobalCalendarDay tmp = new GlobalCalendarDay(0, calendarId, selected, ConversionTime.stringToDate(sDate, "yyyy-MM-dd"));
                        tmp.insert();
                        invoker.setDay(invoker.getDayNumber(), tmp);
                    }
                } else {
                    invoker.getDay().setDayTypeId(selected);
                    invoker.getDay().update();
                    invoker.setDay(invoker.getDayNumber(), invoker.getDay());
                }
            }
            invoker.repaint();
            this.setVisible(false);
        }

        public MouseListener getMouseListener() {
            if (this.lsl == null) {
                this.lsl = new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        if (e.getClickCount() == 2) {
                            DayListPopup.this.saveAndExit();
                        }
                    }
                };
            }
            return this.lsl;
        }
    }

    public class DayPicture
    extends JButton {
        GlobalCalendarDay day;
        int dayNumber = 0;

        public void setDay(int dayNumber, GlobalCalendarDay day) {
            this.dayNumber = dayNumber;
            this.day = day;
            this.setText(String.valueOf(dayNumber));
            if (day != null) {
                try {
                    JourType tmp = JourType.getDayType(day.getDayTypeId());
                    this.setBackground(new Color(tmp.getColor()));
                    this.setText("<html>" + this.getText() + "<br>" + tmp.getCode() + "</html>");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                this.setBackground(Color.WHITE);
            }
        }

        public void init() {
            this.setBackground(Color.WHITE);
            this.setText("");
            this.day = null;
        }

        public GlobalCalendarDay getDay() {
            return this.day;
        }

        public int getDayNumber() {
            return this.dayNumber;
        }
    }
}

