/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.calendarManagement;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.GlobalCalendarDay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.Fmresources;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.calendarManagement.DialogGlobalCalendar;
import transpo.ui.calendrier.Calendrier;

public class PnlGlobalCalendar
extends JPanel
implements Observer {
    private static final String KEY_RIGHT = "icone_right";
    private static final String KEY_LEFT = "icone_left";
    private static final Fmresources res = new Fmresources();
    private String icon_right = res.getResourceString("icone_right");
    private String icon_left = res.getResourceString("icone_left");
    private ClassLoader cl = this.getClass().getClassLoader();
    protected Conducteur driver = null;
    private JLabel[] lblJour = new JLabel[7];
    private JLabel lblMois = null;
    private JLabel lblAnnee = null;
    private DayPicture[] jour = new DayPicture[42];
    private JButton btnPrecedent = null;
    private JButton btnSuivant = null;
    private JButton btnPrecedentAnnee = null;
    private JButton btnSuivantAnnee = null;
    public Calendrier cal = new Calendrier();
    private JPanel pnlJour = null;
    private JPanel pnlDate = null;
    DialogGlobalCalendar pere = null;

    @Override
    public void update(Observable o, Object arg) {
        TimsLogger.verbose("#" + this.getClass() + ".update# a faire");
        LanguageTranslator.getInstance().addObserver(this);
    }

    public PnlGlobalCalendar() {
        this.initialize();
    }

    public PnlGlobalCalendar(DialogGlobalCalendar pere) {
        this.pere = pere;
        LanguageTranslator.getInstance().addObserver(this);
        this.initialize();
    }

    private void initialize() {
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setInitialDelay(10);
        ToolTipManager.sharedInstance().setReshowDelay(10);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.setLayout(new BorderLayout());
        int x = 0;
        while (x < this.lblJour.length) {
            this.lblJour[x] = new JLabel(Calendrier.DAY_NAME[x].substring(0, 3));
            this.lblJour[x].setHorizontalAlignment(0);
            this.lblJour[x].setHorizontalTextPosition(0);
            ++x;
        }
        int i = 0;
        while (i < this.jour.length) {
            this.jour[i] = new DayPicture();
            this.jour[i].setBorder(BorderFactory.createEtchedBorder());
            ++i;
        }
        int x2 = 0;
        while (x2 < this.lblJour.length) {
            this.getPnlJour().add(this.lblJour[x2]);
            ++x2;
        }
        x2 = 0;
        while (x2 < this.jour.length / 7) {
            i = 7 * x2;
            while (i < 7 * (x2 + 1)) {
                this.getPnlJour().add(this.jour[i]);
                ++i;
            }
            ++x2;
        }
        this.getPnlDate().add(this.getBtnPrecedent());
        this.getPnlDate().add(this.getLblMois());
        this.getPnlDate().add(this.getBtnSuivant());
        this.getPnlDate().add(this.getBtnPrecedentAnnee());
        this.getPnlDate().add(this.getLblAnnee());
        this.getPnlDate().add(this.getBtnSuivantAnnee());
        this.add((Component)this.getPnlJour(), "Center");
        this.add((Component)this.getPnlDate(), "South");
    }

    public JPanel getPnlJour() {
        if (this.pnlJour == null) {
            this.pnlJour = new JPanel(new GridLayout(7, 7));
        }
        return this.pnlJour;
    }

    public JPanel getPnlDate() {
        if (this.pnlDate == null) {
            this.pnlDate = new JPanel(new FlowLayout());
        }
        return this.pnlDate;
    }

    public JButton getBtnPrecedent() {
        if (this.btnPrecedent == null) {
            this.btnPrecedent = new JButton();
            this.btnPrecedent.setBorder(null);
            this.btnPrecedent.setToolTipText(LanguageTranslator.getString("calendar.previousMonth"));
            this.btnPrecedent.setBorderPainted(false);
            this.btnPrecedent.setContentAreaFilled(false);
            this.btnPrecedent.setFocusPainted(false);
            this.btnPrecedent.setHorizontalTextPosition(0);
            this.btnPrecedent.setIcon(new ImageIcon(this.cl.getResource(this.icon_left)));
            this.btnPrecedent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlGlobalCalendar.this.addMonth(-1);
                }
            });
        }
        return this.btnPrecedent;
    }

    public JButton getBtnSuivant() {
        if (this.btnSuivant == null) {
            this.btnSuivant = new JButton();
            this.btnSuivant.setBorder(null);
            this.btnSuivant.setToolTipText(LanguageTranslator.getString("calendar.nextMonth"));
            this.btnSuivant.setBorderPainted(false);
            this.btnSuivant.setContentAreaFilled(false);
            this.btnSuivant.setFocusPainted(false);
            this.btnSuivant.setHorizontalTextPosition(0);
            this.btnSuivant.setIcon(new ImageIcon(this.cl.getResource(this.icon_right)));
            this.btnSuivant.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlGlobalCalendar.this.addMonth(1);
                }
            });
        }
        return this.btnSuivant;
    }

    public JButton getBtnPrecedentAnnee() {
        if (this.btnPrecedentAnnee == null) {
            this.btnPrecedentAnnee = new JButton();
            this.btnPrecedentAnnee.setBorder(null);
            this.btnPrecedentAnnee.setToolTipText(LanguageTranslator.getString("calendar.previousYear"));
            this.btnPrecedentAnnee.setBorderPainted(false);
            this.btnPrecedentAnnee.setContentAreaFilled(false);
            this.btnPrecedentAnnee.setFocusPainted(false);
            this.btnPrecedentAnnee.setHorizontalTextPosition(0);
            this.btnPrecedentAnnee.setIcon(new ImageIcon(this.cl.getResource(this.icon_left)));
            this.btnPrecedentAnnee.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlGlobalCalendar.this.addMonth(-12);
                }
            });
        }
        return this.btnPrecedentAnnee;
    }

    public JButton getBtnSuivantAnnee() {
        if (this.btnSuivantAnnee == null) {
            this.btnSuivantAnnee = new JButton();
            this.btnSuivantAnnee.setBorder(null);
            this.btnSuivantAnnee.setToolTipText(LanguageTranslator.getString("calendar.nextYear"));
            this.btnSuivantAnnee.setBorderPainted(false);
            this.btnSuivantAnnee.setContentAreaFilled(false);
            this.btnSuivantAnnee.setFocusPainted(false);
            this.btnSuivantAnnee.setHorizontalTextPosition(0);
            this.btnSuivantAnnee.setIcon(new ImageIcon(this.cl.getResource(this.icon_right)));
            this.btnSuivantAnnee.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlGlobalCalendar.this.addMonth(12);
                }
            });
        }
        return this.btnSuivantAnnee;
    }

    public JLabel getLblMois() {
        if (this.lblMois == null) {
            this.lblMois = new JLabel();
            this.lblMois.setBackground(SystemColor.inactiveCaptionBorder);
            this.lblMois.setFont(new Font("Dialog", 1, 16));
            this.lblMois.setForeground(SystemColor.inactiveCaption);
            this.lblMois.setBorder(BorderFactory.createLineBorder(Color.black));
            this.lblMois.setHorizontalAlignment(0);
            this.lblMois.setHorizontalTextPosition(0);
            this.lblMois.setPreferredSize(new Dimension(130, 30));
            this.lblMois.setMaximumSize(new Dimension(130, 30));
        }
        return this.lblMois;
    }

    public JLabel getLblAnnee() {
        if (this.lblAnnee == null) {
            this.lblAnnee = new JLabel();
            this.lblAnnee.setBackground(SystemColor.inactiveCaptionBorder);
            this.lblAnnee.setFont(new Font("Dialog", 1, 16));
            this.lblAnnee.setForeground(SystemColor.inactiveCaption);
            this.lblAnnee.setBorder(BorderFactory.createLineBorder(Color.black));
            this.lblAnnee.setHorizontalAlignment(0);
            this.lblAnnee.setHorizontalTextPosition(0);
        }
        return this.lblAnnee;
    }

    void addMonth(int amount) {
        this.cal.addMonth(amount);
        this.updateCalendar();
    }

    public void update(Conducteur driver) {
        this.driver = driver;
        this.updateCalendar();
    }

    public void updateCalendar() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Transport.ps.startOperation();
                int a = 1;
                PnlGlobalCalendar.this.getLblMois().setText(Calendrier.MONTH_NAME[PnlGlobalCalendar.this.cal.getMonth()]);
                PnlGlobalCalendar.this.getLblAnnee().setText(String.valueOf(PnlGlobalCalendar.this.cal.getYear()));
                int pjdm = PnlGlobalCalendar.this.cal.premierJour - 1;
                if (pjdm == 0) {
                    pjdm = 7;
                }
                while (a != pjdm) {
                    PnlGlobalCalendar.this.jour[a - 1].setDay(null);
                    ++a;
                }
                String firstDay = String.valueOf(PnlGlobalCalendar.this.getLblAnnee().getText()) + "-" + PnlGlobalCalendar.this.getMoisInt(PnlGlobalCalendar.this.getLblMois().getText()) + "-01";
                String lastDay = String.valueOf(PnlGlobalCalendar.this.getLblAnnee().getText()) + "-" + PnlGlobalCalendar.this.getMoisInt(PnlGlobalCalendar.this.getLblMois().getText()) + "-" + PnlGlobalCalendar.this.cal.nbDayInMonth;
                Vector<GlobalCalendarDay> days = GlobalCalendarDay.loadList(0, ConversionTime.stringToDate(firstDay, "yyyy-MM-dd"), ConversionTime.stringToDate(lastDay, "yyyy-MM-dd"));
                TimsLogger.debug(firstDay + ", " + lastDay + ", " + PnlGlobalCalendar.this.driver.getNom() + " nb jour " + days.size());
                int numJour = 1;
                while (numJour < PnlGlobalCalendar.this.cal.nbDayInMonth + 1) {
                    String sJour = String.valueOf(PnlGlobalCalendar.this.getLblAnnee().getText()) + "-" + PnlGlobalCalendar.this.getMoisInt(PnlGlobalCalendar.this.getLblMois().getText()) + "-" + PnlGlobalCalendar.this.getJourInt(numJour);
                    Date dJour = ConversionTime.stringToDate(sJour, "yyyy-MM-dd");
                    Vector<GlobalCalendarDay> list = new Vector<GlobalCalendarDay>();
                    for (GlobalCalendarDay day : days) {
                        if (!day.getDate().equals(dJour)) continue;
                        list.add(day);
                    }
                    PnlGlobalCalendar.this.jour[a - 1].setDay(list);
                    ++a;
                    ++numJour;
                }
                while (a <= PnlGlobalCalendar.this.jour.length) {
                    PnlGlobalCalendar.this.jour[a - 1].setDay(null);
                    ++a;
                }
                PnlGlobalCalendar.this.repaint();
                Transport.ps.endOperation(PerformanceScanner.READING, "complementary day");
            }
        });
    }

    String getMoisInt(String jour) {
        String retour = "";
        if (jour.equals(Calendrier.MONTH_NAME[0])) {
            retour = "01";
        } else if (jour.equals(Calendrier.MONTH_NAME[1])) {
            retour = "02";
        } else if (jour.equals(Calendrier.MONTH_NAME[2])) {
            retour = "03";
        } else if (jour.equals(Calendrier.MONTH_NAME[3])) {
            retour = "04";
        } else if (jour.equals(Calendrier.MONTH_NAME[4])) {
            retour = "05";
        } else if (jour.equals(Calendrier.MONTH_NAME[5])) {
            retour = "06";
        } else if (jour.equals(Calendrier.MONTH_NAME[6])) {
            retour = "07";
        } else if (jour.equals(Calendrier.MONTH_NAME[7])) {
            retour = "08";
        } else if (jour.equals(Calendrier.MONTH_NAME[8])) {
            retour = "09";
        } else if (jour.equals(Calendrier.MONTH_NAME[9])) {
            retour = "10";
        } else if (jour.equals(Calendrier.MONTH_NAME[10])) {
            retour = "11";
        } else if (jour.equals(Calendrier.MONTH_NAME[11])) {
            retour = "12";
        }
        return retour;
    }

    String getJourInt(String jour) {
        if (Integer.parseInt(jour) < 10) {
            return "0" + jour;
        }
        return jour;
    }

    String getJourInt(int jour) {
        if (jour < 10) {
            return "0" + jour;
        }
        return String.valueOf(jour);
    }

    public class DayPicture
    extends JButton {
        Vector<GlobalCalendarDay> day;
        boolean clicked = false;

        public DayPicture() {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!DayPicture.this.clicked) {
                        DayPicture.this.setJour();
                        DayPicture.this.clicked = true;
                    }
                }
            });
        }

        public void setDay(Vector<GlobalCalendarDay> day) {
            this.day = day;
        }

        public void setClicked(boolean clicked) {
            this.clicked = clicked;
        }

        public void init() {
            this.clicked = false;
            this.day = null;
        }

        public void setJour() {
        }
    }
}

