/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.conducteur;

import fr.pgh.component.JNotificationFrame;
import fr.pgh.component.JTextDate;
import fr.pgh.component.JTextHour;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.EmployeeObligation;
import fr.pgh.data.bdd.EmployeeObligationType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.LMFileAttachment;
import transpo.system.ui.modele.LMSavableFile;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.sync.SynchronizedOptionDialog;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;
import transpo.system.util.messaging.MessageSystemManager;

public class DialogEmployeeObligation
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlBtn = null;
    private JButton btnSave = null;
    private JButton btnCancel = null;
    private JPanel pnlContent = null;
    private JLabel lblDriver = null;
    private JLabel lblDate = null;
    private JLabel lblPlace = null;
    private JLabel lblCost = null;
    private JLabel lblType = null;
    private JLabel lblState = null;
    private JTextField txtDriver = null;
    private JTextDate txtDate = null;
    private JTextField txtPlace = null;
    private JTextField txtCost = null;
    private JComboBox cbType = null;
    private JComboBox cbState = null;
    private JLabel lblHour = null;
    private JTextHour txtHour = null;
    private JPanel pnlAttachment = null;
    private JLabel lblAttachment = null;
    private JScrollPane jspAttachment = null;
    private JList listAttachment = null;
    private JButton btnAddAttachment = null;
    private JButton btnExportAttachment = null;
    private JButton btnShowAttachment = null;
    private JButton btnDeleteAttachment = null;
    private JTextArea txtCom = null;
    private JPanel pnlCom = null;
    private JTextDate txtExpiration = null;
    private JLabel lblExpiration = null;
    private Conducteur selected = null;
    private EmployeeObligation toShow = null;

    public DialogEmployeeObligation(Frame owner) {
        super(owner);
        this.initialize();
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    private void initialize() {
        this.setSize(400, 510);
        this.setTitle(LanguageTranslator.getString("employee.obligation.add.title"));
        this.setModal(true);
        this.setLocationRelativeTo(this.getParent());
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gcbContent = new GridBagConstraints();
            gcbContent.gridx = 0;
            gcbContent.weightx = 1.0;
            gcbContent.weighty = 1.0;
            gcbContent.fill = 1;
            gcbContent.gridy = 0;
            GridBagConstraints gcbBtn = new GridBagConstraints();
            gcbBtn.gridx = 0;
            gcbBtn.fill = 3;
            gcbBtn.weightx = 1.0;
            gcbBtn.weighty = 0.0;
            gcbBtn.insets = new Insets(5, 5, 5, 5);
            gcbBtn.anchor = 13;
            gcbBtn.gridy = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlBtn(), gcbBtn);
            this.jContentPane.add((Component)this.getPnlContent(), gcbContent);
        }
        return this.jContentPane;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 1);
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 0;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnSave(), gridBagConstraints1);
            this.pnlBtn.add((Component)this.getBtnCancel(), gridBagConstraints2);
        }
        return this.pnlBtn;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setPreferredSize(new Dimension(25, 25));
            this.btnSave.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_valid"))));
            this.btnSave.setToolTipText(LanguageTranslator.getString("button.valid"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogEmployeeObligation.this.update()) {
                        DialogEmployeeObligation.this.dispose();
                    }
                }
            });
        }
        return this.btnSave;
    }

    public boolean update() {
        boolean toReturn = true;
        if (!this.check()) {
            return false;
        }
        if (this.toShow == null) {
            this.toShow = new EmployeeObligation();
        }
        int driverId = this.selected.getCleConducteur();
        int employeeObligationTypeId = ((ComboBoxModel)this.getCbType().getModel()).getSelectedCle();
        Date day = this.getTxtDate().getDate();
        Date expiration = this.getTxtExpiration().getDate();
        Float cost = Float.valueOf(this.getTxtCost().getText().equals("") ? 0.0f : Float.parseFloat(this.getTxtCost().getText()));
        String attachment = "";
        Enumeration<?> tmp = ((LMFileAttachment)this.getListAttachment().getModel()).getFiles();
        while (tmp.hasMoreElements() && toReturn) {
            attachment = String.valueOf(attachment) + ";" + tmp.nextElement().toString();
        }
        BddTransport.getInstance().startTransaction();
        toReturn = this.toShow.compareAndUpdate(employeeObligationTypeId, driverId, day, expiration, this.getTxtHour().getMinuteHour(), this.getTxtPlace().getText(), this.getTxtCom().getText(), cost.floatValue(), this.getCbState().getSelectedIndex(), attachment.equals("") ? null : attachment.substring(1));
        if (!toReturn) {
            BddTransport.getInstance().rollback();
        } else {
            BddTransport.getInstance().commit();
        }
        return toReturn;
    }

    private boolean check() {
        boolean toReturn = true;
        if (this.selected == null) {
            this.getTxtDriver().setBackground(new Color(255, 192, 203));
            this.getTxtDriver().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtDriver().setBackground(Color.white);
        }
        if (!this.getTxtHour().getText().equals("00h00") && !this.getTxtHour().isValidHour()) {
            this.getTxtHour().setBackground(new Color(255, 192, 203));
            this.getTxtHour().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtHour().setBackground(Color.white);
        }
        if (((ComboBoxModel)this.getCbType().getModel()).getSelectedCle() == 0) {
            this.getCbType().setBackground(new Color(255, 192, 203));
            this.getCbType().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        }
        if (this.getTxtPlace().getText().equals("")) {
            this.getTxtPlace().setBackground(new Color(255, 192, 203));
            this.getTxtPlace().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtPlace().setBackground(Color.white);
        }
        if (this.getTxtDate().getText().equals("")) {
            this.getTxtDate().setBackground(new Color(255, 192, 203));
            this.getTxtDate().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtDate().setBackground(Color.white);
        }
        if (this.getCbState().getSelectedIndex() == 3) {
            this.getCbState().setBackground(new Color(255, 192, 203));
            this.getCbState().setToolTipText(LanguageTranslator.getString("message.state.suggestedError"));
            toReturn = false;
        } else {
            this.getCbState().setBackground(Color.white);
        }
        return toReturn;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setPreferredSize(new Dimension(25, 25));
            this.btnCancel.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_sup"))));
            this.btnCancel.setToolTipText(LanguageTranslator.getString("button.cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogEmployeeObligation.this.dispose();
                }
            });
        }
        return this.btnCancel;
    }

    private JPanel getPnlContent() {
        if (this.pnlContent == null) {
            GridBagConstraints gcbLblDriver = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtDriver = Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 2, 10, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblType = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbCbType = Fonctions.getGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 2, 10, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblDate = Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtDate = Fonctions.getGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, -1, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblExpiration = Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtExpiration = Fonctions.getGridBagConstraints(1, 3, 1, 1, 0.0, 0.0, -1, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblHour = Fonctions.getGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtHour = Fonctions.getGridBagConstraints(1, 4, 1, 1, 0.0, 0.0, -1, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblPlace = Fonctions.getGridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 1, 10, new Insets(5, 5, 5, 5));
            GridBagConstraints gcbTxtPlace = Fonctions.getGridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 2, 13, new Insets(5, 0, 5, 5));
            GridBagConstraints gcbLblCost = Fonctions.getGridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtCost = Fonctions.getGridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 2, 10, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblState = Fonctions.getGridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbCbState = Fonctions.getGridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 1, 10, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbPnlCom = Fonctions.getGridBagConstraints(0, 8, 1, 2, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbPnlAttachment = Fonctions.getGridBagConstraints(0, 9, 1, 2, 1.0, 0.0, 2, 17, new Insets(5, 5, 0, 5));
            this.lblHour = new JLabel(LanguageTranslator.getString("generics.length"));
            this.lblCost = new JLabel(LanguageTranslator.getString("generics.cost"));
            this.lblDriver = new JLabel(LanguageTranslator.getString("generics.driver"));
            this.lblDate = new JLabel(LanguageTranslator.getString("generics.obtaining"));
            this.lblExpiration = new JLabel(LanguageTranslator.getString("generics.expiry"));
            this.lblPlace = new JLabel(LanguageTranslator.getString("generics.place"));
            this.lblType = new JLabel(LanguageTranslator.getString("employee.obligation.type"));
            this.lblState = new JLabel(LanguageTranslator.getString("generics.state"));
            this.pnlContent = new JPanel();
            this.pnlContent.setLayout(new GridBagLayout());
            this.pnlContent.add((Component)this.lblDriver, gcbLblDriver);
            this.pnlContent.add((Component)this.getTxtDriver(), gcbTxtDriver);
            this.pnlContent.add((Component)this.lblType, gcbLblType);
            this.pnlContent.add((Component)this.getCbType(), gcbCbType);
            this.pnlContent.add((Component)this.lblDate, gcbLblDate);
            this.pnlContent.add((Component)this.getTxtDate(), gcbTxtDate);
            this.pnlContent.add((Component)this.lblExpiration, gcbLblExpiration);
            this.pnlContent.add((Component)this.getTxtExpiration(), gcbTxtExpiration);
            this.pnlContent.add((Component)this.lblHour, gcbLblHour);
            this.pnlContent.add((Component)this.getTxtHour(), gcbTxtHour);
            this.pnlContent.add((Component)this.lblPlace, gcbLblPlace);
            this.pnlContent.add((Component)this.getTxtPlace(), gcbTxtPlace);
            this.pnlContent.add((Component)this.lblCost, gcbLblCost);
            this.pnlContent.add((Component)this.getTxtCost(), gcbTxtCost);
            this.pnlContent.add((Component)this.lblState, gcbLblState);
            this.pnlContent.add((Component)this.getCbState(), gcbCbState);
            this.pnlContent.add((Component)this.getPnlCom(), gcbPnlCom);
            if (ConnexionSettings.getInstance().isConsultable("ATTACHMENT")) {
                this.pnlContent.add((Component)this.getPnlAttachment(), gcbPnlAttachment);
            }
        }
        return this.pnlContent;
    }

    private JPanel getPnlAttachment() {
        if (this.pnlAttachment == null) {
            GridBagConstraints gcbLblAttachment = Fonctions.getGridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 0, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbListAttachment = Fonctions.getGridBagConstraints(1, 0, 4, 1, 1.0, 1.0, 1, 10, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbBtnAddAttachment = Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbBtnDeleteAttachment = Fonctions.getGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 0, 10, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbBtnExportAttachment = Fonctions.getGridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 0, 10, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbBtnShowAttachment = Fonctions.getGridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 0, 10, new Insets(5, 0, 0, 5));
            this.lblAttachment = new JLabel(LanguageTranslator.getString("generics.attachment"));
            this.pnlAttachment = new JPanel();
            this.pnlAttachment.setLayout(new GridBagLayout());
            this.pnlAttachment.add((Component)this.lblAttachment, gcbLblAttachment);
            this.pnlAttachment.add((Component)this.getJspAttachment(), gcbListAttachment);
            if (ConnexionSettings.getInstance().isAjoutable("ATTACHMENT")) {
                this.pnlAttachment.add((Component)this.getBtnAddAttachment(), gcbBtnAddAttachment);
            }
            if (ConnexionSettings.getInstance().isSupprimable("ATTACHMENT")) {
                this.pnlAttachment.add((Component)this.getBtnDeleteAttachment(), gcbBtnDeleteAttachment);
            }
            this.pnlAttachment.add((Component)this.getBtnExportAttachment(), gcbBtnExportAttachment);
            this.pnlAttachment.add((Component)this.getBtnShowAttachment(), gcbBtnShowAttachment);
        }
        return this.pnlAttachment;
    }

    private JTextDate getTxtDate() {
        if (this.txtDate == null) {
            this.txtDate = new JTextDate();
            this.txtDate.setPreferredSize(new Dimension(70, 20));
            this.txtDate.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent arg0) {
                    DialogEmployeeObligation.this.updateExpiry();
                }

                @Override
                public void insertUpdate(DocumentEvent arg0) {
                    DialogEmployeeObligation.this.updateExpiry();
                }

                @Override
                public void changedUpdate(DocumentEvent arg0) {
                    DialogEmployeeObligation.this.updateExpiry();
                }
            });
        }
        return this.txtDate;
    }

    private void updateExpiry() {
        if (this.getCbType().getSelectedIndex() > 0) {
            EmployeeObligationType tmp = (EmployeeObligationType)((ComboBoxModel)this.getCbType().getModel()).getObjectAt(this.getCbType().getSelectedIndex());
            if (!this.getTxtDate().getText().equals("") && tmp.getPeriodExpiration() > 0) {
                this.getTxtExpiration().setText(ConversionTime.addDay(this.getTxtDate().getText(), "dd/MM/yyyy", tmp.getPeriodExpiration()));
                return;
            }
        }
        this.getTxtExpiration().setText("");
    }

    private JTextDate getTxtExpiration() {
        if (this.txtExpiration == null) {
            this.txtExpiration = new JTextDate();
            this.txtExpiration.setPreferredSize(new Dimension(70, 20));
            this.txtExpiration.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }
            });
        }
        return this.txtExpiration;
    }

    private JTextArea getTxtCom() {
        if (this.txtCom == null) {
            this.txtCom = new JTextArea();
            this.txtCom.setMinimumSize(new Dimension(0, 50));
        }
        return this.txtCom;
    }

    private JPanel getPnlCom() {
        if (this.pnlCom == null) {
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.fill = 1;
            gridBagConstraints23.gridwidth = 3;
            gridBagConstraints23.gridx = 0;
            gridBagConstraints23.gridy = 0;
            gridBagConstraints23.weightx = 1.0;
            gridBagConstraints23.weighty = 1.0;
            gridBagConstraints23.insets = new Insets(2, 2, 2, 2);
            this.pnlCom = new JPanel();
            this.pnlCom.setLayout(new GridBagLayout());
            this.pnlCom.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.comment"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlCom.add((Component)this.getTxtCom(), gridBagConstraints23);
        }
        return this.pnlCom;
    }

    private JTextField getTxtPlace() {
        if (this.txtPlace == null) {
            this.txtPlace = new JTextField();
        }
        return this.txtPlace;
    }

    private JTextField getTxtCost() {
        if (this.txtCost == null) {
            this.txtCost = new JTextField();
        }
        return this.txtCost;
    }

    private JComboBox getCbType() {
        if (this.cbType == null) {
            this.cbType = new JComboBox();
            this.cbType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    EmployeeObligationType tmp = (EmployeeObligationType)((ComboBoxModel)DialogEmployeeObligation.this.getCbType().getModel()).getObjectAt(DialogEmployeeObligation.this.getCbType().getSelectedIndex());
                    if (tmp == null) {
                        return;
                    }
                    if (tmp.getDefaultCost() != 0.0f) {
                        DialogEmployeeObligation.this.getTxtCost().setText(String.valueOf(tmp.getDefaultCost()));
                    }
                    if (!DialogEmployeeObligation.this.getTxtDate().getText().equals("") && tmp.getPeriodExpiration() > 0) {
                        DialogEmployeeObligation.this.getTxtExpiration().setText(ConversionTime.addDay(DialogEmployeeObligation.this.getTxtDate().getText(), "dd/MM/yyyy", tmp.getPeriodExpiration()));
                    } else {
                        DialogEmployeeObligation.this.getTxtExpiration().setText("");
                    }
                }
            });
            ComboBoxModel tmp = new ComboBoxModel(EmployeeObligationType.loadList(false), true, LanguageTranslator.getString("generics.select"));
            this.cbType.setModel(tmp);
        }
        return this.cbType;
    }

    private JTextField getTxtDriver() {
        if (this.txtDriver == null) {
            this.txtDriver = new JTextField();
            this.txtDriver.setEnabled(false);
        }
        return this.txtDriver;
    }

    private JTextHour getTxtHour() {
        if (this.txtHour == null) {
            this.txtHour = new JTextHour(false);
            this.txtHour.setPreferredSize(new Dimension(70, 20));
        }
        return this.txtHour;
    }

    private JComboBox getCbState() {
        if (this.cbState == null) {
            this.cbState = new JComboBox();
            this.cbState.addItem(LanguageTranslator.getString("generics.done"));
            this.cbState.addItem(LanguageTranslator.getString("generics.scheduled"));
            this.cbState.addItem(LanguageTranslator.getString("generics.cancelled"));
            this.cbState.addItem(LanguageTranslator.getString("generics.suggested"));
        }
        return this.cbState;
    }

    private JScrollPane getJspAttachment() {
        if (this.jspAttachment == null) {
            this.jspAttachment = new JScrollPane();
            this.jspAttachment.setViewportView(this.getListAttachment());
        }
        return this.jspAttachment;
    }

    private JList getListAttachment() {
        if (this.listAttachment == null) {
            this.listAttachment = new JList();
        }
        return this.listAttachment;
    }

    private JButton getBtnAddAttachment() {
        if (this.btnAddAttachment == null) {
            this.btnAddAttachment = new JButton();
            this.btnAddAttachment.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_cliq"))));
            this.btnAddAttachment.setPreferredSize(new Dimension(25, 25));
            this.btnAddAttachment.setToolTipText(LanguageTranslator.getString("button.add"));
            this.btnAddAttachment.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogEmployeeObligation.this.addAttachment();
                }
            });
        }
        return this.btnAddAttachment;
    }

    private void addAttachment() {
        new Thread(){

            @Override
            public void run() {
                JFileChooser choix = new JFileChooser(".");
                choix.setApproveButtonText(LanguageTranslator.getString("button.add"));
                if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
                    String attached = null;
                    if (!Fonctions.checkFileSize(choix.getSelectedFile())) {
                        return;
                    }
                    attached = FileManager.moveFile(DialogEmployeeObligation.this.selected, choix.getSelectedFile());
                    JNotificationFrame frame = JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT);
                    if (attached != null) {
                        frame.addMessage(LanguageTranslator.getString("attachment.title"), new JLabel(LanguageTranslator.getString("attachment.added.content.obligation", choix.getSelectedFile().getName())), Fonctions.getSuccessStatusIcon());
                        ((LMFileAttachment)DialogEmployeeObligation.this.getListAttachment().getModel()).addElement(attached);
                    }
                    frame.showNotification(6);
                }
            }
        }.start();
    }

    private JButton getBtnExportAttachment() {
        if (this.btnExportAttachment == null) {
            this.btnExportAttachment = new JButton();
            this.btnExportAttachment.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_save"))));
            this.btnExportAttachment.setPreferredSize(new Dimension(25, 25));
            this.btnExportAttachment.setToolTipText(LanguageTranslator.getString("button.export"));
            this.btnExportAttachment.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogEmployeeObligation.this.saveFile(DialogEmployeeObligation.this.getListAttachment());
                }
            });
        }
        return this.btnExportAttachment;
    }

    private void saveFile(JList toSave) {
        int[] selected = toSave.getSelectedIndices();
        JFileChooser choix = new JFileChooser(".");
        choix.setApproveButtonText("Sauvegarder les fichiers dans");
        choix.setFileSelectionMode(1);
        if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
            String cheminSave = choix.getSelectedFile().getAbsolutePath();
            int x = 0;
            while (x < selected.length) {
                String nomFichier = ((LMSavableFile)((Object)toSave.getModel())).getName(selected[x]);
                File fichier = FileManager.getFile(this.selected, nomFichier);
                if (fichier == null) {
                    MessageSystemManager.error(null, LanguageTranslator.getString("generics.fileNotFound", nomFichier), LanguageTranslator.getString("generics.error"));
                } else {
                    Fonctions.copyLocalFile(fichier, new File(cheminSave, nomFichier), System.getProperty("URL") != null);
                }
                ++x;
            }
        }
    }

    private JButton getBtnShowAttachment() {
        if (this.btnShowAttachment == null) {
            this.btnShowAttachment = new JButton();
            this.btnShowAttachment.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_loupe"))));
            this.btnShowAttachment.setPreferredSize(new Dimension(25, 25));
            this.btnShowAttachment.setToolTipText(LanguageTranslator.getString("button.show"));
            this.btnShowAttachment.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogEmployeeObligation.this.showFile(DialogEmployeeObligation.this.getListAttachment());
                }
            });
        }
        return this.btnShowAttachment;
    }

    private void showFile(JList toSave) {
        int[] selected = toSave.getSelectedIndices();
        if (selected.length == 0) {
            return;
        }
        int x = 0;
        while (x < selected.length) {
            String nomFichier = ((LMSavableFile)((Object)toSave.getModel())).getName(selected[x]);
            File fichier = FileManager.getFile(this.selected, nomFichier);
            if (fichier == null) {
                MessageSystemManager.error(null, LanguageTranslator.getString("generics.fileNotFound", nomFichier), LanguageTranslator.getString("generics.error"));
            } else if (Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                try {
                    Desktop.getDesktop().open(fichier);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++x;
        }
    }

    private JButton getBtnDeleteAttachment() {
        if (this.btnDeleteAttachment == null) {
            this.btnDeleteAttachment = new JButton();
            this.btnDeleteAttachment.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_sup"))));
            this.btnDeleteAttachment.setPreferredSize(new Dimension(25, 25));
            this.btnDeleteAttachment.setToolTipText(LanguageTranslator.getString("button.delete"));
            this.btnDeleteAttachment.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogEmployeeObligation.this.deleteAttachment();
                }
            });
        }
        return this.btnDeleteAttachment;
    }

    private void deleteAttachment() {
        SynchronizedOptionDialog tmp = new SynchronizedOptionDialog(LanguageTranslator.getString("message.delete.confirm"), LanguageTranslator.getString("generics.warning"));
        tmp.run();
        if (tmp.option == 0) {
            int[] selected = this.getListAttachment().getSelectedIndices();
            String file = selected.length == 1 ? ((LMFileAttachment)this.getListAttachment().getModel()).getName(selected[0]) : LanguageTranslator.getString("generics.files");
            JNotificationFrame frame = JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT);
            frame.addMessage(LanguageTranslator.getString("attachment.title"), new JLabel(LanguageTranslator.getString("attachment.deleted.content", file)), Fonctions.getSuccessStatusIcon());
            int x = 0;
            while (x < selected.length) {
                ((LMFileAttachment)this.getListAttachment().getModel()).remove(selected[x]);
                ++x;
            }
            frame.showNotification(6);
        }
    }

    public void setSelectedDriver(Conducteur driver) {
        this.selected = driver;
        this.getTxtDriver().setText(this.selected.toString());
        this.getBtnExportAttachment().setEnabled(false);
        this.getListAttachment().setModel(new LMFileAttachment());
    }

    public void setEmployeeObligation(EmployeeObligation toShow) {
        this.toShow = toShow;
        if (this.selected == null || this.selected.getCleConducteur() != toShow.getDriverId()) {
            this.selected = new Conducteur();
            this.selected.loadById(toShow.getDriverId());
        }
        this.getTxtDriver().setText(this.selected.toString());
        this.getCbType().setSelectedItem(((ComboBoxModel)this.getCbType().getModel()).getLabel(toShow.getTypeId()));
        this.getTxtDate().setDate(toShow.getDay());
        this.getTxtExpiration().setDate(toShow.getExpiration());
        this.getTxtHour().setHourMinute(toShow.getLength());
        this.getTxtPlace().setText(toShow.getPlace());
        this.getTxtCom().setText(toShow.getComment());
        this.getTxtCost().setText(String.valueOf(toShow.getCost()));
        this.getCbState().setSelectedIndex(toShow.getState() >= 3 ? 3 : toShow.getState());
        this.getBtnExportAttachment().setEnabled(true);
        if (toShow.getAttachment() == null) {
            this.getListAttachment().setModel(new LMFileAttachment());
        } else {
            this.getListAttachment().setModel(new LMFileAttachment(toShow.getAttachment().split(";")));
        }
    }
}

