/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.conducteur;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Activite;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.exception.ActivityTypeNotFoundException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.LMActivity;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.conducteur.DialogDetailJournee;
import transpo.system.util.Fonctions;

public class DialogModification
extends JDialog
implements Observer {
    private static final long serialVersionUID = 1L;
    private static int CONTINUE = 0;
    private static int BREAK = 1;
    private ActiviteConducteur activite = null;
    public Vector<ActiviteConducteur> activiteJour = null;
    public boolean update = false;
    private LMActivity modeleListe = null;
    DialogDetailJournee pere = null;
    private JPanel jContentPane = null;
    private JPanel pnlModification = null;
    private JLabel lblDebut = null;
    private JLabel lblFin = null;
    private JTextField txtDebut = null;
    private JTextField txtFin = null;
    private JScrollPane jspActivite = null;
    private JList listeActivite = null;
    private JButton btnQuitter = null;
    private JPanel pnlCompletion = null;
    private JCheckBox cbCompletion = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogModification.dispose()#");
        super.dispose();
    }

    @Override
    public void update(Observable o, Object arg) {
        TimsLogger.verbose("#" + this.getClass() + ".update# a faire");
        LanguageTranslator.getInstance().addObserver(this);
    }

    public DialogModification(DialogDetailJournee pere, Vector<ActiviteConducteur> activiteJour, ActiviteConducteur activite) {
        super(pere);
        TimsLogger.verbose("#DialogModification()#");
        this.pere = pere;
        this.activiteJour = activiteJour;
        this.activite = activite;
        LanguageTranslator.getInstance().addObserver(this);
        this.initialize();
    }

    private void initialize() {
        PointerInfo info = MouseInfo.getPointerInfo();
        this.setLocation(info.getLocation());
        this.setSize(new Dimension(270, 130));
        this.setPreferredSize(new Dimension(270, 130));
        this.setModal(true);
        this.setUndecorated(true);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints7.gridy = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints6.weightx = 1.0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            this.jContentPane.add((Component)this.getPnlModification(), gridBagConstraints6);
            this.jContentPane.add((Component)this.getPnlCompletion(), gridBagConstraints7);
        }
        return this.jContentPane;
    }

    private JPanel getPnlModification() {
        if (this.pnlModification == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridwidth = 2;
            gridBagConstraints5.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.gridwidth = 1;
            gridBagConstraints4.gridheight = 3;
            gridBagConstraints4.gridx = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 3;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 3;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            this.lblFin = new JLabel();
            this.lblFin.setText(LanguageTranslator.getString("generics.end"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.lblDebut = new JLabel();
            this.lblDebut.setText(LanguageTranslator.getString("generics.begin"));
            this.pnlModification = new JPanel();
            this.pnlModification.setLayout(new GridBagLayout());
            this.pnlModification.setPreferredSize(new Dimension(260, 125));
            this.pnlModification.add((Component)this.lblDebut, gridBagConstraints);
            this.pnlModification.add((Component)this.lblFin, gridBagConstraints1);
            this.pnlModification.add((Component)this.getTxtDebut(), gridBagConstraints2);
            this.pnlModification.add((Component)this.getTxtFin(), gridBagConstraints3);
            this.pnlModification.add((Component)this.getJspActivite(), gridBagConstraints4);
            this.pnlModification.add((Component)this.getBtnQuitter(), gridBagConstraints5);
        }
        return this.pnlModification;
    }

    private JTextField getTxtDebut() {
        if (this.txtDebut == null) {
            this.txtDebut = new JTextField();
            this.txtDebut.setMinimumSize(new Dimension(50, 20));
            this.txtDebut.setText(ConversionTime.heureIntToString(this.activite.getHeureDebut(), "h"));
            this.txtDebut.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    DialogModification.this.verifSaisie(e, DialogModification.this.txtDebut);
                }
            });
            this.txtDebut.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
        }
        return this.txtDebut;
    }

    private JTextField getTxtFin() {
        if (this.txtFin == null) {
            this.txtFin = new JTextField();
            this.txtFin.setMinimumSize(new Dimension(50, 20));
            this.txtFin.setText(ConversionTime.heureIntToString(this.activite.getHeureFin(), "h"));
            this.txtFin.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    DialogModification.this.verifSaisie(e, DialogModification.this.txtFin);
                }
            });
            this.txtFin.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
        }
        return this.txtFin;
    }

    private JScrollPane getJspActivite() {
        if (this.jspActivite == null) {
            this.jspActivite = new JScrollPane();
            this.jspActivite.setViewportView(this.getListeActivite());
            this.jspActivite.setMinimumSize(new Dimension(80, 60));
        }
        return this.jspActivite;
    }

    private JList getListeActivite() {
        if (this.listeActivite == null) {
            this.listeActivite = new JList();
            this.listeActivite.setMinimumSize(new Dimension(70, 60));
            this.listeActivite.setSelectionMode(0);
            this.modeleListe = new LMActivity(TypeActivite.getList());
            this.listeActivite.setModel(this.modeleListe);
            this.listeActivite.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && DialogModification.this.listeActivite.getSelectedIndex() != -1 && DialogModification.this.updateActivite()) {
                        DialogModification.this.dispose();
                    }
                }
            });
        }
        return this.listeActivite;
    }

    private boolean updateActivite() {
        TypeActivite newActiv;
        boolean avant = false;
        boolean apres = false;
        boolean trouDebut = false;
        boolean trouFin = false;
        boolean changedActivity = false;
        this.update = true;
        TimsLogger.debug("ex debut " + this.activite.getHeureDebut());
        TimsLogger.debug("ex fin " + this.activite.getHeureFin());
        TimsLogger.debug("new debut " + ConversionTime.heureStringToInt(this.getTxtDebut().getText(), "h"));
        TimsLogger.debug("new fin " + ConversionTime.heureStringToInt(this.getTxtFin().getText(), "h"));
        int newBegin = ConversionTime.heureStringToInt(this.getTxtDebut().getText(), "h");
        int newEnd = ConversionTime.heureStringToInt(this.getTxtFin().getText(), "h");
        if (newBegin > newEnd) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.inputError"), LanguageTranslator.getString("message.saveError"), 0);
            return false;
        }
        if (newBegin < this.activite.getHeureDebut()) {
            avant = true;
        }
        if (newEnd > this.activite.getHeureFin()) {
            apres = true;
        }
        if (newBegin > this.activite.getHeureDebut()) {
            trouDebut = true;
        }
        if (newEnd < this.activite.getHeureFin()) {
            trouFin = true;
        }
        if (!(newActiv = (TypeActivite)this.modeleListe.get(this.getListeActivite().getSelectedIndex())).getName().equals(this.activite.getDescription())) {
            changedActivity = true;
        }
        if (newEnd == this.activite.getHeureFin() && newBegin == this.activite.getHeureDebut()) {
            if (changedActivity) {
                TimsLogger.debug("on change d'activite");
            } else {
                TimsLogger.debug("on a rien fait...");
                this.update = false;
            }
        }
        if (this.update) {
            if ((avant || apres) && this.stretchPeriod(newBegin, newEnd, avant, apres) != CONTINUE) {
                this.update = false;
                return true;
            }
            if (trouDebut || trouFin) {
                try {
                    int x;
                    TypeActivite rest = TypeActivite.getActivityType(4);
                    TypeActivite activityType = TypeActivite.getActivityType(this.activite.getCleType());
                    if (trouDebut) {
                        x = this.activiteJour.indexOf(this.activite);
                        if (this.activite.getHeureDebut() != 0 && this.getCbCompletion().isSelected()) {
                            this.activiteJour.get(x).setHeureFin(newBegin);
                            Fonctions.setGraphicOrigin(this.activiteJour.get(x));
                        } else if (changedActivity) {
                            this.activiteJour.add(x + 1, this.getNewActivity(activityType, this.activite.getHeureDebut(), newBegin));
                        } else {
                            this.activiteJour.add(x + 1, this.getNewActivity(rest, this.activite.getHeureDebut(), newBegin));
                        }
                    }
                    if (trouFin) {
                        x = this.activiteJour.indexOf(this.activite) + 1;
                        if (this.activite.getHeureFin() != 1440 && this.getCbCompletion().isSelected()) {
                            this.activiteJour.get(x).setHeureDebut(newEnd);
                            Fonctions.setGraphicOrigin(this.activiteJour.get(x));
                        } else if (changedActivity) {
                            this.activiteJour.add(x, this.getNewActivity(activityType, newEnd, this.activite.getHeureFin()));
                        } else {
                            this.activiteJour.add(x, this.getNewActivity(rest, newEnd, this.activite.getHeureFin()));
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.activite.setHeureDebut(newBegin);
            this.activite.setHeureFin(newEnd);
            if (changedActivity) {
                this.activite.setCleType(newActiv.getCle());
                this.activite.setCouleur(String.valueOf(newActiv.getColor()));
                this.activite.setDescription(newActiv.getName());
                Fonctions.setGraphicOrigin(this.activite);
            }
        }
        return true;
    }

    private ActiviteConducteur getNewActivity(TypeActivite ta, int begin, int end) {
        return new ActiviteConducteur(0, this.activite.getCleConducteur(), 0, ta.getCle(), ta.getName(), String.valueOf(ta.getColor()), begin, end, end - begin, this.activite.getDateJour(), "GRAPHE", "", "", "", "", 0, 1, 0);
    }

    private int stretchPeriod(int newBegin, int newEnd, boolean avant, boolean apres) {
        int updateLevel;
        ActiviteConducteur tmp;
        int x;
        TimsLogger.debug("#DialogModification.stretchPeriod# avant " + avant + ", apres " + apres);
        int option = -1;
        Vector<ActiviteConducteur> toRemove = new Vector<ActiviteConducteur>();
        Activite endHour = null;
        Activite beginHour = null;
        boolean canUpdate = true;
        if (avant) {
            x = 0;
            while (this.activiteJour.get(x).getHeureDebut() < this.activite.getHeureDebut()) {
                tmp = this.activiteJour.get(x);
                TimsLogger.debug("#process ");
                tmp.affiche();
                if (tmp.getHeureFin() > newBegin) {
                    try {
                        updateLevel = TypeActivite.getActivityType(tmp.getCleType()).getModificationLevel();
                        if (updateLevel == 0) {
                            canUpdate = false;
                            break;
                        }
                    }
                    catch (ActivityTypeNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    if (tmp.getHeureDebut() >= newBegin) {
                        TimsLogger.debug("#remove ");
                        tmp.affiche();
                        toRemove.add(tmp);
                    } else {
                        endHour = tmp;
                    }
                }
                ++x;
            }
        }
        if (apres && canUpdate) {
            x = 0;
            while (this.activiteJour.get(x).getHeureDebut() != this.activite.getHeureDebut()) {
                ++x;
            }
            TimsLogger.debug(String.valueOf(this.activiteJour.indexOf(this.activite)) + " !=? " + x);
            ++x;
            while (this.activiteJour.get(x).getHeureDebut() < newEnd) {
                tmp = this.activiteJour.get(x);
                try {
                    updateLevel = TypeActivite.getActivityType(tmp.getCleType()).getModificationLevel();
                    if (updateLevel == 0) {
                        canUpdate = false;
                        break;
                    }
                }
                catch (ActivityTypeNotFoundException ex) {
                    ex.printStackTrace();
                }
                if (tmp.getHeureFin() < newEnd) {
                    toRemove.add(tmp);
                } else {
                    beginHour = tmp;
                }
                ++x;
            }
        }
        if (!canUpdate) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("activity.activityUpdateError"), LanguageTranslator.getString("message.unauthorized"), 0);
            return BREAK;
        }
        if (option == -1) {
            option = JOptionPane.showConfirmDialog(this, LanguageTranslator.getString("update.otherActivitiesAffected"));
        }
        if (option == 0) {
            for (ActiviteConducteur tmp2 : toRemove) {
                this.activiteJour.remove(tmp2);
            }
            if (beginHour != null) {
                beginHour.setHeureDebut(newEnd);
                Fonctions.setGraphicOrigin((ActiviteConducteur)beginHour);
            }
            if (endHour != null) {
                endHour.setHeureFin(newBegin);
                Fonctions.setGraphicOrigin((ActiviteConducteur)endHour);
            }
        }
        return CONTINUE;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogModification.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private void verifSaisie(KeyEvent e, JTextField txt) {
        int keyCode = e.getKeyCode();
        char keyChar = e.getKeyChar();
        if (keyCode == 8 || keyCode == 20 || keyCode == 16) {
            return;
        }
        if (txt.getText().length() == 1) {
            if (keyChar < '0' || keyChar > '9') {
                txt.setText("");
            }
        } else if (txt.getText().length() == 2) {
            if (keyChar < '0' || keyChar > '9') {
                txt.setText("0" + txt.getText().substring(0, 1) + "h");
            } else {
                txt.setText(String.valueOf(txt.getText()) + "h");
            }
        } else if (txt.getText().length() == 3) {
            if (keyChar < '0' || keyChar > '9') {
                txt.setText(String.valueOf(txt.getText().substring(0, 2)) + "h");
            } else {
                txt.setText(String.valueOf(txt.getText().substring(0, 2)) + "h" + txt.getText().substring(2));
            }
        } else if (txt.getText().length() == 4) {
            if (keyChar < '0' || keyChar > '9') {
                txt.setText(txt.getText().substring(0, 3));
            }
        } else if (txt.getText().length() == 5) {
            if (keyChar < '0' || keyChar > '9') {
                txt.setText(txt.getText().substring(0, 4));
            }
        } else if (txt.getText().length() >= 6) {
            txt.setText(txt.getText().substring(0, 5));
        }
    }

    private JPanel getPnlCompletion() {
        if (this.pnlCompletion == null) {
            this.pnlCompletion = new JPanel();
            this.pnlCompletion.setLayout(new GridBagLayout());
            this.pnlCompletion.add((Component)this.getCbCompletion(), new GridBagConstraints());
        }
        return this.pnlCompletion;
    }

    private JCheckBox getCbCompletion() {
        if (this.cbCompletion == null) {
            this.cbCompletion = new JCheckBox();
            this.cbCompletion.setText(LanguageTranslator.getString("activity.update.complete"));
        }
        return this.cbCompletion;
    }
}

