/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.conducteur;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.TypeActivite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.LMActivity;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogSelectionActivite
extends JDialog
implements Observer {
    private static final long serialVersionUID = 1L;
    private int heure = 0;
    public Vector<ActiviteConducteur> activiteJour = null;
    public boolean update = false;
    private LMActivity modeleListe = null;
    private JPanel jContentPane = null;
    private JPanel pnlModification = null;
    private JLabel lblDebut = null;
    private JTextField txtDebut = null;
    private JScrollPane jspActivite = null;
    private JList listeActivite = null;
    private JButton btnQuitter = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogSelectionActivite.dispose()#");
        super.dispose();
    }

    @Override
    public void update(Observable o, Object arg) {
        TimsLogger.verbose("#" + this.getClass() + ".update# a faire");
        LanguageTranslator.getInstance().addObserver(this);
    }

    public DialogSelectionActivite(JDialog pere, Vector<ActiviteConducteur> activiteJour, int heure) {
        super(pere);
        TimsLogger.verbose("#DialogSelectionActivite()#");
        this.activiteJour = activiteJour;
        this.heure = heure;
        LanguageTranslator.getInstance().addObserver(this);
        this.initialize();
    }

    private void initialize() {
        PointerInfo info = MouseInfo.getPointerInfo();
        this.setLocation(info.getLocation());
        this.setSize(new Dimension(160, 200));
        this.setPreferredSize(new Dimension(270, 130));
        this.setModal(true);
        this.setUndecorated(true);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 3;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridwidth = 2;
            gridBagConstraints1.gridy = 2;
            gridBagConstraints1.gridx = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridwidth = 2;
            gridBagConstraints6.weightx = 1.0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            this.jContentPane.add((Component)this.getPnlModification(), gridBagConstraints6);
            this.jContentPane.add((Component)this.getBtnQuitter(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getTxtDebut(), gridBagConstraints2);
            this.jContentPane.add((Component)this.lblDebut, gridBagConstraints);
        }
        return this.jContentPane;
    }

    private JPanel getPnlModification() {
        if (this.pnlModification == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.gridwidth = 1;
            gridBagConstraints4.gridheight = 3;
            gridBagConstraints4.gridx = 2;
            this.lblDebut = new JLabel();
            this.lblDebut.setText(LanguageTranslator.getString("generics.begin"));
            this.pnlModification = new JPanel();
            this.pnlModification.setLayout(new GridBagLayout());
            this.pnlModification.setPreferredSize(new Dimension(260, 125));
            this.pnlModification.add((Component)this.getJspActivite(), gridBagConstraints4);
        }
        return this.pnlModification;
    }

    private JTextField getTxtDebut() {
        if (this.txtDebut == null) {
            this.txtDebut = new JTextField();
            this.txtDebut.setMinimumSize(new Dimension(50, 20));
            this.txtDebut.setText(ConversionTime.heureIntToString(this.heure, "h"));
            this.txtDebut.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    Fonctions.verifSaisieHeure(e, DialogSelectionActivite.this.txtDebut);
                }
            });
        }
        return this.txtDebut;
    }

    private JScrollPane getJspActivite() {
        if (this.jspActivite == null) {
            this.jspActivite = new JScrollPane();
            this.jspActivite.setMinimumSize(new Dimension(80, 60));
            this.jspActivite.setViewportView(this.getListeActivite());
        }
        return this.jspActivite;
    }

    private JList getListeActivite() {
        if (this.listeActivite == null) {
            this.listeActivite = new JList();
            this.listeActivite.setMinimumSize(new Dimension(70, 60));
            this.listeActivite.setSelectionMode(0);
            this.modeleListe = new LMActivity(TypeActivite.getList());
            this.listeActivite.setModel(this.modeleListe);
            this.listeActivite.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && DialogSelectionActivite.this.listeActivite.getSelectedIndex() != -1) {
                        DialogSelectionActivite.this.updateActivite();
                        DialogSelectionActivite.this.dispose();
                    }
                }
            });
        }
        return this.listeActivite;
    }

    private void updateActivite() {
        this.update = true;
        int heureSelected = ConversionTime.heureStringToInt(this.getTxtDebut().getText(), "h");
        int x = 0;
        while (this.activiteJour.get(x).getHeureFin() < heureSelected) {
            ++x;
        }
        TypeActivite newActiv = (TypeActivite)this.modeleListe.get(this.getListeActivite().getSelectedIndex());
        this.activiteJour.add(x + 1, new ActiviteConducteur(0, this.activiteJour.get(x).getCleConducteur(), 0, newActiv.getCle(), newActiv.getName(), String.valueOf(newActiv.getColor()), heureSelected, this.activiteJour.get(x).getHeureFin(), this.activiteJour.get(x).getHeureFin() - heureSelected, this.activiteJour.get(x).getDateJour(), LanguageTranslator.getString("generics.graphic"), "", "", "", "", 0, 1, 0));
        this.activiteJour.get(x).setHeureFin(heureSelected);
        Fonctions.setGraphicOrigin(this.activiteJour.get(x));
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogSelectionActivite.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }
}

