/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.conducteur;

import fr.pgh.connexion.TimsSession;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.LMDriver;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class DialogSupprimerConducteur
extends JDialog
implements Observer {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JComboBox cbAgence = null;
    private JList listeConducteur = null;
    private JPanel pnlBtn = null;
    private JButton btnSupprimer = null;
    private JButton btnQuitter = null;
    private JScrollPane jspListe = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogSupprimerConducteur.dispose()#");
        super.dispose();
    }

    @Override
    public void update(Observable o, Object arg) {
        TimsLogger.verbose("#" + this.getClass() + ".update# a faire");
        LanguageTranslator.getInstance().addObserver(this);
    }

    public DialogSupprimerConducteur(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogSupprimerConducteur()#");
        LanguageTranslator.getInstance().addObserver(this);
        this.initialize();
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    private void initialize() {
        this.setBounds(new Rectangle(0, 0, 350, 400));
        this.setTitle(LanguageTranslator.getString("driver.delete"));
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints4.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.weightx = 0.5;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints3.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(10, 10, 0, 10);
            gridBagConstraints2.gridx = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getCbAgence(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getJspListe(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getPnlBtn(), gridBagConstraints4);
        }
        return this.jContentPane;
    }

    private JComboBox getCbAgence() {
        if (this.cbAgence == null) {
            this.cbAgence = new JComboBox();
            ComboBoxModel modeleAgence = new ComboBoxModel(Agence.getList(), false, LanguageTranslator.getString("generics.all"));
            this.cbAgence.setEditable(true);
            this.cbAgence.setModel(modeleAgence);
            this.cbAgence.setSelectedItem("");
            this.cbAgence.setPreferredSize(new Dimension(150, 25));
            this.cbAgence.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DialogSupprimerConducteur.this.updateDriver();
                }
            });
        }
        return this.cbAgence;
    }

    public void updateDriver() {
        int cleAgence = ((ComboBoxModel)this.getCbAgence().getModel()).getSelectedCle();
        LMDriver tmp = new LMDriver(Conducteur.loadList(cleAgence));
        this.getListeConducteur().setModel(tmp);
    }

    private JList getListeConducteur() {
        if (this.listeConducteur == null) {
            this.listeConducteur = new JList();
            this.listeConducteur.setSize(new Dimension(0, 0));
            int cleAgence = ((ComboBoxModel)this.getCbAgence().getModel()).getSelectedCle();
            LMDriver tmp = new LMDriver(Conducteur.loadList(cleAgence));
            this.listeConducteur.setModel(tmp);
            this.listeConducteur.setAutoscrolls(true);
        }
        return this.listeConducteur;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 10;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.setPreferredSize(new Dimension(167, 50));
            this.pnlBtn.add((Component)this.getBtnSupprimer(), gridBagConstraints);
            this.pnlBtn.add((Component)this.getBtnQuitter(), gridBagConstraints1);
        }
        return this.pnlBtn;
    }

    private JButton getBtnSupprimer() {
        if (this.btnSupprimer == null) {
            this.btnSupprimer = new JButton();
            this.btnSupprimer.setText(LanguageTranslator.getString("button.delete"));
            this.btnSupprimer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogSupprimerConducteur.this.supprimerConducteur();
                }
            });
        }
        return this.btnSupprimer;
    }

    public void supprimerConducteur() {
        int confirm = JOptionPane.showConfirmDialog(this.getParent(), LanguageTranslator.getString("driver.warning.delete", this.getListeConducteur().getSelectedValue().toString()), LanguageTranslator.getString("message.confirm"), 0);
        if (confirm == 0) {
            int index = this.getListeConducteur().getSelectedIndex();
            Conducteur toDel = (Conducteur)((LMDriver)this.getListeConducteur().getModel()).get(index);
            toDel.delete();
            ((LMDriver)this.getListeConducteur().getModel()).remove(index);
            JOptionPane.showMessageDialog(this.getParent(), LanguageTranslator.getString("message.deleteSucceed"), LanguageTranslator.getString("message.done"), 0);
        }
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogSupprimerConducteur.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JScrollPane getJspListe() {
        if (this.jspListe == null) {
            this.jspListe = new JScrollPane();
            this.jspListe.setPreferredSize(new Dimension(200, 200));
            this.jspListe.setViewportView(this.getListeConducteur());
            this.jspListe.setVerticalScrollBarPolicy(22);
        }
        return this.jspListe;
    }
}

