/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.conducteur;

import fr.pgh.data.bdd.Conducteur;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.PageAttributes;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.ProgressBarIndetermine;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.conducteur.DiscScan;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;

public class ImageViewer
extends JDialog
implements Observer {
    private Conducteur driver = null;
    private Vector<String> files = null;
    private int current = 0;
    private File currentImage = null;
    private JScrollPane jsp = null;
    private JPanel pnlOptions = null;
    private JPanel pnlImage = null;
    private JButton btnExport = null;
    private JButton btnPrint = null;
    private JButton btnQuit = null;
    private JButton btnNext = null;
    private JButton btnPrevious = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#ImageViewer.dispose()#");
        super.dispose();
    }

    @Override
    public void update(Observable o, Object arg) {
        TimsLogger.verbose("#" + this.getClass() + ".update# a faire");
        LanguageTranslator.getInstance().addObserver(this);
    }

    public ImageViewer(JFrame main, Conducteur driver, Vector<String> files) {
        super(main);
        TimsLogger.verbose("#ImageViewer()#");
        this.setModal(true);
        this.driver = driver;
        this.files = files;
        this.setBounds(100, 100, 518, 573);
        this.setTitle(LanguageTranslator.getString("image.viewer"));
        LanguageTranslator.getInstance().addObserver(this);
        this.initialize();
    }

    private void initialize() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getJsp(), "Center");
        this.getContentPane().add((Component)this.getPnlOptions(), "South");
    }

    private JScrollPane getJsp() {
        if (this.jsp == null) {
            this.jsp = new JScrollPane();
            this.jsp.setViewportView(this.getPnlImage());
        }
        return this.jsp;
    }

    private JPanel getPnlImage() {
        if (this.pnlImage == null) {
            this.currentImage = FileManager.getFile(this.driver, this.files.get(this.current));
            this.pnlImage = new DiscScan(this.loadImage(this.currentImage.getAbsolutePath()));
        }
        return this.pnlImage;
    }

    private JPanel getPnlOptions() {
        if (this.pnlOptions == null) {
            this.pnlOptions = new JPanel();
            this.pnlOptions.setLayout(new FlowLayout());
            this.pnlOptions.add(this.getBtnPrevious());
            this.pnlOptions.add(this.getBtnExport());
            this.pnlOptions.add(this.getBtnPrint());
            this.pnlOptions.add(this.getBtnNext());
            this.pnlOptions.add(this.getBtnQuit());
        }
        return this.pnlOptions;
    }

    private JButton getBtnExport() {
        if (this.btnExport == null) {
            this.btnExport = new JButton(LanguageTranslator.getString("button.export"));
            this.btnExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser choix = new JFileChooser(".");
                    choix.setApproveButtonText("Sauvegarder l'image dans");
                    choix.setFileSelectionMode(1);
                    if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
                        ProgressBarIndetermine progres = new ProgressBarIndetermine((Frame)MainFrameTransport.getInstance(), LanguageTranslator.getString("download.copy"));
                        progres.setVisible(true);
                        String cheminSave = choix.getSelectedFile().getAbsolutePath();
                        try {
                            Fonctions.copyLocalFile(ImageViewer.this.currentImage, new File(String.valueOf(cheminSave) + "\\" + ImageViewer.this.currentImage.getName()), System.getProperty("URL") != null);
                            progres.dispose();
                            JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("download.export.succeed"), LanguageTranslator.getString("message.done"), 1);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("message.copyError"), LanguageTranslator.getString("message.numberedError", "0"), 1);
                        }
                    }
                }
            });
        }
        return this.btnExport;
    }

    private JButton getBtnPrint() {
        if (this.btnPrint == null) {
            this.btnPrint = new JButton(LanguageTranslator.getString("button.print"));
            this.btnPrint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewer.this.print();
                }
            });
        }
        return this.btnPrint;
    }

    private void print() {
        Properties props = new Properties();
        props.put("awt.print.paperSize", "a4");
        int[] tmp = new int[]{160, 160, 3};
        PageAttributes pa = new PageAttributes(PageAttributes.ColorType.MONOCHROME, PageAttributes.MediaType.A4, PageAttributes.OrientationRequestedType.PORTRAIT, PageAttributes.OriginType.PRINTABLE, PageAttributes.PrintQualityType.NORMAL, tmp);
        PrintJob pJob = this.getToolkit().getPrintJob(MainFrameTransport.getInstance(), "Impression", null, pa);
        Graphics pg = pJob.getGraphics();
        this.getPnlImage().printAll(pg);
        pg.dispose();
        pJob.end();
    }

    private JButton getBtnQuit() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton(LanguageTranslator.getString("button.quit"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewer.this.dispose();
                }
            });
        }
        return this.btnQuit;
    }

    private JButton getBtnNext() {
        if (this.btnNext == null) {
            this.btnNext = new JButton(">");
            if (this.files.size() == 0 || this.current == this.files.size() - 1) {
                this.btnNext.setEnabled(false);
            }
            this.btnNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewer imageViewer = ImageViewer.this;
                    imageViewer.current = imageViewer.current + 1;
                    TimsLogger.debug(String.valueOf(ImageViewer.this.current) + " de " + (ImageViewer.this.files.size() - 1));
                    ImageViewer.this.reloadImage();
                }
            });
        }
        return this.btnNext;
    }

    private JButton getBtnPrevious() {
        if (this.btnPrevious == null) {
            this.btnPrevious = new JButton("<");
            if (this.files.size() == 0 || this.current == 0) {
                this.btnPrevious.setEnabled(false);
            }
            this.btnPrevious.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewer imageViewer = ImageViewer.this;
                    imageViewer.current = imageViewer.current - 1;
                    TimsLogger.debug(String.valueOf(ImageViewer.this.current) + " de " + (ImageViewer.this.files.size() - 1));
                    ImageViewer.this.reloadImage();
                }
            });
        }
        return this.btnPrevious;
    }

    private void reloadImage() {
        this.currentImage = FileManager.getFile(this.driver, this.files.get(this.current));
        try {
            this.pnlImage = new DiscScan(this.loadImage(this.currentImage.getAbsolutePath()));
        }
        catch (Exception e) {
            TimsLogger.warn(" getimages : " + e);
        }
        this.jsp.setViewportView(this.getPnlImage());
        if (this.files.size() == 0 || this.current == this.files.size() - 1) {
            this.btnNext.setEnabled(false);
        } else {
            this.btnNext.setEnabled(true);
        }
        if (this.files.size() == 0 || this.current == 0) {
            this.btnPrevious.setEnabled(false);
        } else {
            this.btnPrevious.setEnabled(true);
        }
    }

    private Image loadImage(String imageFile) {
        try {
            MediaTracker mTrack = new MediaTracker(this);
            Image image = this.getToolkit().getImage(imageFile);
            mTrack.addImage(image, 0);
            mTrack.waitForAll();
            TimsLogger.debug(String.valueOf(imageFile) + " : Width " + image.getWidth(null) + " height " + image.getHeight(null));
            return image;
        }
        catch (Exception e) {
            TimsLogger.warn(" getimages : " + e);
            return null;
        }
    }

    private Image loadImage(URL imageFile) {
        try {
            MediaTracker mTrack = new MediaTracker(this);
            Image image = this.getToolkit().getImage(imageFile);
            mTrack.addImage(image, 0);
            mTrack.waitForAll();
            return image;
        }
        catch (Exception e) {
            TimsLogger.warn(" getimages : " + e);
            return null;
        }
    }
}

