/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.conducteur;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.ExpensesValidation;
import fr.pgh.data.bdd.Fault;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Service;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.TMDay;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.conducteur.NewPnlCalendrier;
import transpo.system.util.Fonctions;

public class NewDialogCalendrier
extends JDialog
implements Observer,
DataListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlFiltre = null;
    private JLabel lblAgence = null;
    private JLabel lblConducteur = null;
    private JComboBox cbAgence = null;
    private JComboBox cbConducteur = null;
    private JPanel pnlPeriode = null;
    private JLabel lblDebut = null;
    private JTextField txtDebut = null;
    private JLabel lblFin = null;
    private JTextField txtFin = null;
    private JComboBox cbJour = null;
    private JPanel pnlBtn = null;
    private JButton btnEnregistrer = null;
    private JButton btnQuitter = null;
    private TMDay tableModelDay = null;
    private JButton btnEffacer = null;
    private NewPnlCalendrier pnlCal = null;
    private JTextField txtBeginExpenses = null;
    private JTextField txtEndExpenses = null;
    private JComboBox cbExpenses = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JPanel pnlAbs = null;
    private JCheckBox cbSatAbs = null;
    private JCheckBox cbSunAbs = null;
    private JCheckBox cbSatExp = null;
    private JCheckBox cbSunExp = null;
    private JPanel pnlQuickInput = null;
    private JCheckBox cbMissingDay = null;
    private JCheckBox cbExpense = null;
    private JCheckBox cbForeign = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogCalendrier.dispose()#");
        super.dispose();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.lblAgence.setText(LanguageTranslator.getString("generics.agency"));
        this.lblConducteur.setText(LanguageTranslator.getString("generics.driver"));
        this.pnlPeriode.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("calendar.period"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.lblDebut.setText(LanguageTranslator.getString("calendar.from"));
        this.lblFin.setText(LanguageTranslator.getString("calendar.to"));
        this.getCbSatAbs().setText(LanguageTranslator.getString("calendar.satIncluding"));
        this.getCbSunAbs().setText(LanguageTranslator.getString("calendar.sunIncluding"));
        this.getCbSatExp().setText(LanguageTranslator.getString("calendar.satIncluding"));
        this.getCbSunExp().setText(LanguageTranslator.getString("calendar.sunIncluding"));
        this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
        this.btnEffacer.setText(LanguageTranslator.getString("button.delete"));
        this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
    }

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        if (dataEvent instanceof BddEvent) {
            BddEvent e = (BddEvent)dataEvent;
            if (e.getTable().equals("t_conducteur")) {
                this.initialiseCbConducteur();
            } else if (e.getTable().equals("t_agence")) {
                this.getCbAgence().setModel(new ComboBoxModel(Agence.getList(), false, null));
            } else if (e.getTable().equals("t_frais")) {
                this.getCbExpenses().setModel(new ComboBoxModel(ExpensesType.getList(), true, null));
            } else if (e.getTable().equals(JourType.table)) {
                this.getCbJour().setModel(new ComboBoxModel(JourType.getList(), true, null));
            }
        }
    }

    public NewDialogCalendrier(JFrame owner) {
        super(owner);
        TimsLogger.verbose("#DialogCalendrier()#");
        LanguageTranslator.getInstance().addObserver(this);
        Transport.bdd.addDataListener(this);
        this.initialize();
    }

    private void initialize() {
        if (System.getProperty("max.height", "0").equals("1")) {
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            this.setSize((int)(size.getWidth() * 0.8), (int)(size.getHeight() * 0.8));
        } else {
            this.setSize(1024, 768);
        }
        this.setLocationRelativeTo(this.getParent());
        this.setContentPane(this.getJContentPane());
        this.setTitle(LanguageTranslator.getString("calendar.title"));
    }

    public void setDriver(Conducteur driver) {
        ((ComboBoxModel)this.getCbConducteur().getModel()).setSelectedItem(String.valueOf(driver.getNom()) + "  " + driver.getPrenom());
    }

    public void setAgency(Agence agency) {
        ((ComboBoxModel)this.getCbAgence().getModel()).setSelectedItem(agency.getDescription());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints110 = new GridBagConstraints();
            gridBagConstraints110.gridx = 0;
            gridBagConstraints110.fill = 1;
            gridBagConstraints110.gridy = 1;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.fill = 1;
            gridBagConstraints13.gridy = 3;
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.gridx = 0;
            gridBagConstraints22.weightx = 1.0;
            gridBagConstraints22.weighty = 1.0;
            gridBagConstraints22.fill = 1;
            gridBagConstraints22.gridy = 2;
            gridBagConstraints22.insets = new Insets(0, 5, 0, 5);
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.fill = 1;
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.gridy = 5;
            gridBagConstraints12.weightx = 0.0;
            gridBagConstraints12.weighty = 0.0;
            gridBagConstraints12.insets = new Insets(0, 2, 0, 2);
            GridBagConstraints gridBagConstraints61 = new GridBagConstraints();
            gridBagConstraints61.gridx = 0;
            gridBagConstraints61.gridy = 4;
            gridBagConstraints61.fill = 1;
            gridBagConstraints61.weightx = 0.0;
            gridBagConstraints61.weighty = 0.0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlFiltre(), gridBagConstraints);
            this.jContentPane.add((Component)this.getPnlCal(), gridBagConstraints22);
            if (ConnexionSettings.getInstance().isAjoutable("CALENDRIER")) {
                this.jContentPane.add((Component)this.getPnlAbs(), gridBagConstraints13);
            }
            if (ConnexionSettings.getInstance().isAjoutable("CALENDRIER")) {
                this.jContentPane.add((Component)this.getPnlPeriode(), gridBagConstraints61);
            }
            this.jContentPane.add((Component)this.getPnlBtn(), gridBagConstraints12);
        }
        return this.jContentPane;
    }

    private JPanel getPnlFiltre() {
        if (this.pnlFiltre == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weightx = 0.0;
            gridBagConstraints5.weighty = 0.0;
            gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            this.lblConducteur = new JLabel();
            this.lblConducteur.setText(LanguageTranslator.getString("generics.driver"));
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints1.gridy = 0;
            this.lblAgence = new JLabel();
            this.lblAgence.setText(LanguageTranslator.getString("generics.agency"));
            this.pnlFiltre = new JPanel();
            this.pnlFiltre.setLayout(new GridBagLayout());
            this.pnlFiltre.add((Component)this.lblAgence, gridBagConstraints1);
            this.pnlFiltre.add((Component)this.lblConducteur, gridBagConstraints2);
            this.pnlFiltre.add((Component)this.getCbAgence(), gridBagConstraints3);
            this.pnlFiltre.add((Component)this.getCbConducteur(), gridBagConstraints4);
        }
        return this.pnlFiltre;
    }

    private JComboBox getCbAgence() {
        if (this.cbAgence == null) {
            this.cbAgence = new JComboBox();
            this.cbAgence.setModel(new ComboBoxModel(Agence.getList(), false, LanguageTranslator.getString("generics.none")));
            this.cbAgence.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    NewDialogCalendrier.this.initialiseCbConducteur();
                }
            });
        }
        return this.cbAgence;
    }

    private void initialiseCbConducteur() {
        int cleAgence = ((ComboBoxModel)this.getCbAgence().getModel()).getSelectedCle();
        ((ComboBoxModel)this.getCbConducteur().getModel()).updateList(Conducteur.loadList(cleAgence), false, LanguageTranslator.getString("generics.none"));
    }

    private JComboBox getCbConducteur() {
        if (this.cbConducteur == null) {
            this.cbConducteur = new JComboBox();
            this.cbConducteur.setModel(new ComboBoxModel(null, false, null));
            this.cbConducteur.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        int selectedId = ((ComboBoxModel)NewDialogCalendrier.this.getCbConducteur().getModel()).getSelectedCle();
                        if (NewDialogCalendrier.this.getCbConducteur().getSelectedIndex() != -1 && selectedId != 0) {
                            NewDialogCalendrier.this.getBtnEffacer().setEnabled(true);
                            Conducteur toShow = new Conducteur(selectedId);
                            NewDialogCalendrier.this.getPnlCal().update(toShow);
                        } else {
                            NewDialogCalendrier.this.getBtnEffacer().setEnabled(false);
                        }
                    }
                }
            });
            this.initialiseCbConducteur();
        }
        return this.cbConducteur;
    }

    private JPanel getPnlPeriode() {
        if (this.pnlPeriode == null) {
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.gridx = 5;
            gridBagConstraints27.gridy = 1;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 7;
            gridBagConstraints21.insets = new Insets(0, 3, 0, 0);
            gridBagConstraints21.gridy = 1;
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.gridx = 6;
            gridBagConstraints25.insets = new Insets(0, 3, 0, 0);
            gridBagConstraints25.gridy = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.insets = new Insets(0, 3, 0, 3);
            gridBagConstraints11.gridy = 1;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(LanguageTranslator.getString("calendar.from"));
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 2;
            gridBagConstraints10.insets = new Insets(0, 3, 0, 3);
            gridBagConstraints10.gridy = 1;
            this.jLabel = new JLabel();
            this.jLabel.setText(LanguageTranslator.getString("calendar.to"));
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.gridy = 1;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints9.gridx = 4;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 0;
            gridBagConstraints8.gridy = 1;
            gridBagConstraints8.weightx = 0.0;
            gridBagConstraints8.gridx = 3;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 0;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.weightx = 0.0;
            gridBagConstraints6.gridx = 1;
            this.pnlPeriode = new JPanel();
            this.pnlPeriode.setLayout(new GridBagLayout());
            this.pnlPeriode.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("calendar.expPeriod"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlPeriode.add((Component)this.getTxtBeginExpenses(), gridBagConstraints6);
            this.pnlPeriode.add((Component)this.getTxtEndExpenses(), gridBagConstraints8);
            this.pnlPeriode.add((Component)this.getCbExpenses(), gridBagConstraints9);
            this.pnlPeriode.add((Component)this.jLabel, gridBagConstraints10);
            this.pnlPeriode.add((Component)this.jLabel1, gridBagConstraints11);
            this.pnlPeriode.add((Component)this.getCbSatExp(), gridBagConstraints25);
            this.pnlPeriode.add((Component)this.getCbSunExp(), gridBagConstraints21);
            this.pnlPeriode.add((Component)this.getCbForeign(), gridBagConstraints27);
        }
        return this.pnlPeriode;
    }

    private JTextField getTxtDebut() {
        if (this.txtDebut == null) {
            this.txtDebut = new JTextField();
            this.txtDebut.setPreferredSize(new Dimension(70, 20));
            this.txtDebut.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(NewDialogCalendrier.this.getTxtDebut());
                }
            });
        }
        return this.txtDebut;
    }

    private JTextField getTxtFin() {
        if (this.txtFin == null) {
            this.txtFin = new JTextField();
            this.txtFin.setPreferredSize(new Dimension(70, 20));
            this.txtFin.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(NewDialogCalendrier.this.getTxtFin());
                }
            });
        }
        return this.txtFin;
    }

    private JComboBox getCbJour() {
        if (this.cbJour == null) {
            this.cbJour = new JComboBox();
            this.cbJour.setModel(new ComboBoxModel(JourType.getList(), true, null));
        }
        return this.cbJour;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints7.gridy = 0;
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.gridx = 2;
            gridBagConstraints24.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints24.weightx = 1.0;
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.gridx = 0;
            gridBagConstraints23.weightx = 1.0;
            gridBagConstraints23.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints23.gridy = 0;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            if (ConnexionSettings.getInstance().isAjoutable("CALENDRIER")) {
                this.pnlBtn.add((Component)this.getBtnEnregistrer(), gridBagConstraints24);
            }
            this.pnlBtn.add((Component)this.getBtnQuitter(), gridBagConstraints23);
            this.pnlBtn.add((Component)this.getBtnEffacer(), gridBagConstraints7);
        }
        return this.pnlBtn;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewDialogCalendrier.this.enregistrer();
                }
            });
        }
        return this.btnEnregistrer;
    }

    public void enregistrer() {
        int driverId = ((ComboBoxModel)this.getCbConducteur().getModel()).getSelectedCle();
        Date debut = ConversionTime.stringToDate(this.getTxtDebut().getText(), "dd/MM/yyyy");
        Date fin = ConversionTime.stringToDate(this.getTxtFin().getText(), "dd/MM/yyyy");
        if (debut != null && fin != null) {
            this.savePeriode(driverId, debut, fin);
        }
        debut = ConversionTime.stringToDate(this.getTxtBeginExpenses().getText(), "dd/MM/yyyy");
        fin = ConversionTime.stringToDate(this.getTxtEndExpenses().getText(), "dd/MM/yyyy");
        if (debut != null && fin != null) {
            this.saveExpensesPeriod(driverId, debut, fin);
        }
        JOptionPane.showMessageDialog(this, LanguageTranslator.getString("calendar.saveSucceed"), LanguageTranslator.getString("message.saveSucceed"), 1);
        this.getPnlCal().updateCalendar();
    }

    /*
     * Unable to fully structure code
     */
    public void savePeriode(int driverId, Date debut, Date fin) {
        block6: {
            services = Service.getService(0, driverId, debut, fin);
            expenses = DriverExpenses.loadList(0, driverId, debut, fin);
            if (this.getTxtDebut().getText().equals("") || this.getTxtFin().getText().equals("")) break block6;
            tmpType = (JourType)((ComboBoxModel)this.getCbJour().getModel()).getObjectAt(this.getCbJour().getSelectedIndex());
            if (tmpType != null && tmpType.getCle() != 0) ** GOTO lbl28
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("calendar.emptyDayType"), LanguageTranslator.getString("message.inputError"), 0);
            return;
lbl-1000:
            // 1 sources

            {
                toAdd = false;
                dayOfWeek = ConversionTime.getDayOfWeek(debut, false);
                if (this.getCbSatAbs().isSelected() && dayOfWeek == 7) {
                    toAdd = true;
                }
                if (this.getCbSunAbs().isSelected() && dayOfWeek == 1) {
                    toAdd = true;
                }
                if ((dayOfWeek != 7 && dayOfWeek != 1 || toAdd) && !(tmp = new LienJourConducteur()).load(driverId, new Timestamp(debut.getTime()))) {
                    tmp.setValues(0, driverId, tmpType.getCle(), ConnexionSettings.getInstance().getUserCle(), debut, LienJourConducteur.DEFAULT_BEGIN_VALUE, 0, 2);
                    tmp.update();
                    service = Service.find(services, driverId, debut).size() != 0;
                    v0 = expense = DriverExpenses.find(expenses, driverId, debut).size() != 0;
                    if (service) {
                        fault = new Fault(0, driverId, debut, ConnexionSettings.getInstance().getUserCle(), 4);
                        fault.insert();
                    }
                    if (expense) {
                        fault = new Fault(0, driverId, debut, ConnexionSettings.getInstance().getUserCle(), 2);
                        fault.insert();
                    }
                }
                debut = ConversionTime.addDay(debut, 1);
lbl28:
                // 2 sources

                ** while (debut.compareTo((Date)fin) <= 0)
            }
        }
        this.getTxtDebut().setText("");
        this.getTxtFin().setText("");
    }

    public void saveExpensesPeriod(int driverId, Date debut, Date fin) {
        Vector<LienJourConducteur> ljc = LienJourConducteur.loadList(0, driverId, debut, fin);
        Vector<ExpensesValidation> expValids = null;
        if (ConnexionSettings.getInstance().isConsultable("EXPENSES_VALIDATION")) {
            expValids = ExpensesValidation.loadList(driverId, debut, fin);
        }
        int x = 0;
        while (x < ljc.size()) {
            LienJourConducteur tmp = ljc.get(x);
            if (tmp.getType() == 0) {
                ljc.remove(x);
            }
            ++x;
        }
        if (!this.getTxtBeginExpenses().getText().equals("") && !this.getTxtEndExpenses().getText().equals("")) {
            ExpensesType expenses = (ExpensesType)((ComboBoxModel)this.getCbExpenses().getModel()).getObjectAt(this.getCbExpenses().getSelectedIndex());
            boolean foreign = this.getCbForeign().isSelected();
            int type = foreign ? 1 : 0;
            while (debut.compareTo(fin) <= 0) {
                boolean add = false;
                int dayOfWeek = ConversionTime.getDayOfWeek(debut, false);
                if (this.getCbSatExp().isSelected() && dayOfWeek == 7) {
                    add = true;
                }
                if (this.getCbSunExp().isSelected() && dayOfWeek == 1) {
                    add = true;
                }
                if ((dayOfWeek != 7 && dayOfWeek != 1 || add) && ExpensesValidation.find(expValids, driverId, debut).size() == 0) {
                    boolean jour;
                    float amount = expenses.getMontant(debut, type);
                    DriverExpenses toAdd = new DriverExpenses(0, driverId, debut, expenses.getCle(), true, 0.0f, 0.0f, amount, foreign, 0);
                    toAdd.update();
                    boolean bl = jour = LienJourConducteur.find(ljc, driverId, debut).size() != 0;
                    if (jour) {
                        Fault fault = new Fault(0, driverId, debut, ConnexionSettings.getInstance().getUserCle(), 1);
                        fault.insert();
                    }
                }
                debut = ConversionTime.addDay(debut, 1);
            }
        }
        this.getTxtBeginExpenses().setText("");
        this.getTxtEndExpenses().setText("");
    }

    public void delete() {
        int cleConducteur = ((ComboBoxModel)this.getCbConducteur().getModel()).getSelectedCle();
        boolean dayDeleted = this.deleteLJC(cleConducteur);
        boolean expensesDeleted = this.deleteExpenses(cleConducteur);
        if (dayDeleted || expensesDeleted) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.deleteSucceed"));
        }
        this.getPnlCal().updateCalendar();
    }

    public boolean deleteLJC(int cleConducteur) {
        if (this.getTxtDebut().getText().equals("") && this.getTxtFin().getText().equals("")) {
            return false;
        }
        try {
            if (JOptionPane.showOptionDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("calendar.deletion", this.getTxtDebut().getText(), this.getTxtFin().getText()), LanguageTranslator.getString("generics.warning"), 0, 2, null, null, null) == 1) {
                return false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Date debut = ConversionTime.stringToDate(this.getTxtDebut().getText(), "dd/MM/yyyy");
        Date fin = ConversionTime.stringToDate(this.getTxtFin().getText(), "dd/MM/yyyy");
        if (fin.after(debut)) {
            Vector<Fault> toDel = Fault.loadList(cleConducteur, debut, fin);
            while (debut.compareTo(fin) <= 0) {
                LienJourConducteur tmp = new LienJourConducteur();
                if (tmp.load(cleConducteur, new Timestamp(debut.getTime()))) {
                    tmp.delete();
                    for (Fault delete : toDel) {
                        if (!delete.getDay().equals(debut) || delete.getType() != 4 && delete.getType() != 2 && delete.getType() != 3 && delete.getType() != 1) continue;
                        delete.delete();
                    }
                }
                debut = ConversionTime.addDay(debut, 1);
            }
        }
        this.getTxtDebut().setText("");
        this.getTxtFin().setText("");
        return true;
    }

    public boolean deleteExpenses(int cleConducteur) {
        if (this.getTxtBeginExpenses().getText().equals("") && this.getTxtEndExpenses().getText().equals("")) {
            return false;
        }
        try {
            if (JOptionPane.showOptionDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("expenses.deletion", this.getTxtBeginExpenses().getText(), this.getTxtEndExpenses().getText()), LanguageTranslator.getString("generics.warning"), 0, 2, null, null, null) == 1) {
                return false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Date debut = ConversionTime.stringToDate(this.getTxtBeginExpenses().getText(), "dd/MM/yyyy");
        Date fin = ConversionTime.stringToDate(this.getTxtEndExpenses().getText(), "dd/MM/yyyy");
        if (fin.after(debut)) {
            Vector<ExpensesValidation> expValids = null;
            if (ConnexionSettings.getInstance().isConsultable("EXPENSES_VALIDATION")) {
                expValids = ExpensesValidation.loadList(cleConducteur, debut, fin);
            }
            Vector<Fault> toDel = Fault.loadList(cleConducteur, debut, fin);
            Vector<DriverExpenses> de = DriverExpenses.loadList(0, cleConducteur, debut, fin);
            int x = 0;
            while (x < de.size()) {
                DriverExpenses deToDel = de.get(x);
                if (ExpensesValidation.find(expValids, cleConducteur, deToDel.getDate()).size() != 0) {
                    de.remove(x);
                    --x;
                } else {
                    deToDel.delete();
                }
                ++x;
            }
            while (debut.compareTo(fin) <= 0) {
                if (DriverExpenses.find(de, cleConducteur, debut).size() != 0) {
                    for (Fault delete : toDel) {
                        if (!delete.getDay().equals(debut) || delete.getType() != 2 && delete.getType() != 1) continue;
                        delete.delete();
                    }
                }
                debut = ConversionTime.addDay(debut, 1);
            }
        }
        this.getTxtBeginExpenses().setText("");
        this.getTxtEndExpenses().setText("");
        return true;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewDialogCalendrier.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JButton getBtnEffacer() {
        if (this.btnEffacer == null) {
            this.btnEffacer = new JButton();
            this.btnEffacer.setText(LanguageTranslator.getString("button.delete"));
            this.btnEffacer.setEnabled(false);
            this.btnEffacer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewDialogCalendrier.this.delete();
                }
            });
        }
        return this.btnEffacer;
    }

    private NewPnlCalendrier getPnlCal() {
        if (this.pnlCal == null) {
            this.pnlCal = new NewPnlCalendrier(this);
        }
        return this.pnlCal;
    }

    private JTextField getTxtBeginExpenses() {
        if (this.txtBeginExpenses == null) {
            this.txtBeginExpenses = new JTextField();
            this.txtBeginExpenses.setPreferredSize(new Dimension(70, 20));
            this.txtBeginExpenses.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(NewDialogCalendrier.this.getTxtBeginExpenses());
                }
            });
        }
        return this.txtBeginExpenses;
    }

    private JTextField getTxtEndExpenses() {
        if (this.txtEndExpenses == null) {
            this.txtEndExpenses = new JTextField();
            this.txtEndExpenses.setPreferredSize(new Dimension(70, 20));
            this.txtEndExpenses.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(NewDialogCalendrier.this.getTxtEndExpenses());
                }
            });
        }
        return this.txtEndExpenses;
    }

    private JComboBox getCbExpenses() {
        if (this.cbExpenses == null) {
            this.cbExpenses = new JComboBox();
            this.cbExpenses.setModel(new ComboBoxModel(ExpensesType.getList(), true, null));
        }
        return this.cbExpenses;
    }

    private JPanel getPnlAbs() {
        if (this.pnlAbs == null) {
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.gridx = 6;
            gridBagConstraints20.insets = new Insets(0, 3, 0, 0);
            gridBagConstraints20.gridy = 0;
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.gridx = 5;
            gridBagConstraints19.insets = new Insets(0, 3, 0, 0);
            gridBagConstraints19.gridy = 0;
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.fill = 1;
            gridBagConstraints18.gridx = 4;
            gridBagConstraints18.gridy = 0;
            gridBagConstraints18.weightx = 1.0;
            gridBagConstraints18.insets = new Insets(0, 5, 0, 0);
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.fill = 0;
            gridBagConstraints17.gridy = 0;
            gridBagConstraints17.weightx = 0.0;
            gridBagConstraints17.gridx = 3;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.insets = new Insets(0, 3, 0, 3);
            gridBagConstraints16.gridy = 0;
            gridBagConstraints16.gridx = 2;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.fill = 0;
            gridBagConstraints15.gridy = -1;
            gridBagConstraints15.weightx = 0.0;
            gridBagConstraints15.gridx = -1;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.insets = new Insets(0, 3, 0, 3);
            gridBagConstraints14.gridy = -1;
            gridBagConstraints14.gridx = -1;
            this.lblFin = new JLabel();
            this.lblFin.setText(LanguageTranslator.getString("calendar.to"));
            this.lblDebut = new JLabel();
            this.lblDebut.setText(LanguageTranslator.getString("calendar.from"));
            this.pnlAbs = new JPanel();
            this.pnlAbs.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("calendar.absPeriod"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlAbs.setLayout(new GridBagLayout());
            this.pnlAbs.add((Component)this.lblDebut, gridBagConstraints14);
            this.pnlAbs.add((Component)this.getTxtDebut(), gridBagConstraints15);
            this.pnlAbs.add((Component)this.lblFin, gridBagConstraints16);
            this.pnlAbs.add((Component)this.getTxtFin(), gridBagConstraints17);
            this.pnlAbs.add((Component)this.getCbJour(), gridBagConstraints18);
            this.pnlAbs.add((Component)this.getCbSatAbs(), gridBagConstraints19);
            this.pnlAbs.add((Component)this.getCbSunAbs(), gridBagConstraints20);
        }
        return this.pnlAbs;
    }

    private JCheckBox getCbSatAbs() {
        if (this.cbSatAbs == null) {
            this.cbSatAbs = new JCheckBox();
            this.cbSatAbs.setText(LanguageTranslator.getString("calendar.satIncluding"));
        }
        return this.cbSatAbs;
    }

    private JCheckBox getCbSunAbs() {
        if (this.cbSunAbs == null) {
            this.cbSunAbs = new JCheckBox();
            this.cbSunAbs.setText(LanguageTranslator.getString("calendar.sunIncluding"));
        }
        return this.cbSunAbs;
    }

    private JCheckBox getCbSatExp() {
        if (this.cbSatExp == null) {
            this.cbSatExp = new JCheckBox();
            this.cbSatExp.setText(LanguageTranslator.getString("calendar.satIncluding"));
        }
        return this.cbSatExp;
    }

    private JCheckBox getCbSunExp() {
        if (this.cbSunExp == null) {
            this.cbSunExp = new JCheckBox();
            this.cbSunExp.setText(LanguageTranslator.getString("calendar.sunIncluding"));
        }
        return this.cbSunExp;
    }

    private JPanel getPnlQuickInput() {
        if (this.pnlQuickInput == null) {
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.gridx = 1;
            gridBagConstraints26.gridy = 0;
            this.pnlQuickInput = new JPanel();
            this.pnlQuickInput.setLayout(new GridBagLayout());
            this.pnlQuickInput.add((Component)this.getCbMissingDay(), new GridBagConstraints());
            this.pnlQuickInput.add((Component)this.getCbExpense(), gridBagConstraints26);
            ButtonGroup tmp = new ButtonGroup();
            tmp.add(this.getCbMissingDay());
            tmp.add(this.getCbExpense());
        }
        return this.pnlQuickInput;
    }

    private JCheckBox getCbMissingDay() {
        if (this.cbMissingDay == null) {
            this.cbMissingDay = new JCheckBox();
            this.cbMissingDay.setText("Saisie rapide des journ\u00e9es suppl\u00e9mentaires");
        }
        return this.cbMissingDay;
    }

    public boolean isQuickDay() {
        return this.getCbMissingDay().isSelected();
    }

    private JCheckBox getCbExpense() {
        if (this.cbExpense == null) {
            this.cbExpense = new JCheckBox();
            this.cbExpense.setText("Saisie rapide des frais");
        }
        return this.cbExpense;
    }

    public boolean isQuickExpense() {
        return this.getCbExpense().isSelected();
    }

    private JCheckBox getCbForeign() {
        if (this.cbForeign == null) {
            this.cbForeign = new JCheckBox(LanguageTranslator.getString("expenses.foreign"));
        }
        return this.cbForeign;
    }
}

