/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.conducteur;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.ExpensesValidation;
import fr.pgh.data.bdd.ExportUpdate;
import fr.pgh.data.bdd.ExternalDay;
import fr.pgh.data.bdd.Jour;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Place;
import fr.pgh.data.bdd.RoundAffectation;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.exception.DayException;
import fr.pgh.exception.ServiceException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import transpo.system.LicenceManager;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.listener.ActivityChangeListener;
import transpo.system.traitement.TraitementTempsService;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.modele.TMActivityType;
import transpo.system.ui.renderer.ColorRenderer;
import transpo.system.ui.resources.Fmresources;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.AbsencePopup;
import transpo.system.ui.views.DialogCreerJour;
import transpo.system.ui.views.DialogDetailJourSupprime;
import transpo.system.ui.views.GrapheActivite;
import transpo.system.ui.views.PopupCaller;
import transpo.system.ui.views.conducteur.DialogDetailJournee;
import transpo.system.ui.views.conducteur.ImageViewer;
import transpo.system.ui.views.conducteur.Model_table_ActivC;
import transpo.system.util.Fonctions;

public class PnlActiviteC
extends ViewPanel
implements Observer,
DataListener,
ActivityChangeListener {
    private DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private final Fmresources res = Transport.res;
    private ClassLoader cl = this.getClass().getClassLoader();
    private Conducteur detailConducteur;
    private Model_table_ActivC modele_activ;
    private GregorianCalendar calendar;
    private static PnlActiviteC single = null;
    private GrapheActivite graphe = null;
    private static BddTransport bddEco = null;
    private JScrollPane jspTbl = null;
    private JPanel pnlToShow = null;
    private JTable tblJour = null;
    private JPanel pnlGraphicGlobal = null;
    private JScrollPane jspGraphe = null;
    private JPanel pnlDateSelect = null;
    private JScrollPane pnlAct = null;
    private JCheckBox cbBrut = null;
    private JCheckBox cbVehicle = null;
    private JCheckBox cbOffence = null;
    private JCheckBox cbPlace = null;
    private JCheckBox cbSpec = null;
    private JCheckBox cbExtActivity = null;
    private JCheckBox cbRound = null;
    private JCheckBox cbExp = null;
    private JCheckBox cbAbs = null;
    private JButton btnSup7Jours = null;
    private JButton btnSup1Jour = null;
    private JTextField txtDate = null;
    private JLabel txtDriver = null;
    private JButton btnAdd1Jour = null;
    private JButton btnAdd7Jours = null;
    private JButton[] btnDetail = null;
    private BtnAbsence[] btnAbs = null;
    private JButton[] btnSup = null;
    private BtnExport[] btnExport = null;
    private BtnExp[] btnExp = null;
    private JButton[] btnImg = null;
    private JLabel[] lblJour = null;
    private JLabel[] lblDate = null;
    private Vector<Jour> detailJour = null;
    private JTable tblActivities = null;
    private AbsencePopup ap = null;
    private Date lastExport = null;
    ItemListener refreshListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            PnlActiviteC.this.refresh();
        }
    };

    public static PnlActiviteC getInstance() {
        if (single == null) {
            single = new PnlActiviteC();
        }
        return single;
    }

    @Override
    public String getViewName() {
        return LanguageTranslator.getString("generics.activity");
    }

    @Override
    public void refresh() {
        try {
            String dateCourante = this.txtDate.getText();
            Date dateField = this.dateFormat.parse(dateCourante);
            this.loadDate(dateField);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        this.repaint();
    }

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        BddEvent e;
        if (dataEvent instanceof BddEvent && (e = (BddEvent)dataEvent).getTable().equals(TypeActivite.table)) {
            PnlActiviteC.getInstance().updateActivities();
        }
    }

    public void updateActivities() {
        this.getTblActivities().setModel(new TMActivityType(TypeActivite.getList()));
    }

    @Override
    public void close() {
    }

    @Override
    public String getMnemo() {
        return "";
    }

    @Override
    public void update(Observable o, Object arg) {
        TimsLogger.verbose("#" + this.getClass() + ".update# a faire");
        LanguageTranslator.getInstance().addObserver(this);
    }

    public PnlActiviteC() {
        this.calendar = new GregorianCalendar();
        this.btnSup7Jours = new JButton();
        this.btnSup1Jour = new JButton();
        this.txtDate = new JTextField();
        this.txtDriver = new JLabel();
        this.btnAdd1Jour = new JButton();
        this.btnAdd7Jours = new JButton();
        this.btnDetail = new JButton[7];
        this.btnAbs = new BtnAbsence[7];
        this.btnSup = new JButton[7];
        this.btnExport = new BtnExport[7];
        this.btnExp = new BtnExp[7];
        this.btnImg = new JButton[7];
        this.lblJour = new JLabel[7];
        this.lblDate = new JLabel[7];
        try {
            LanguageTranslator.getInstance().addObserver(this);
            this.jbInit();
            TimsSession.getInstance().addVisit(this.getClass().getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Transport.bdd.addDataListener(this);
    }

    private void jbInit() throws Exception {
        JPanel haut = new JPanel();
        JPanel bas = new JPanel();
        bas.setPreferredSize(new Dimension(0, 400));
        this.setLayout(new BorderLayout());
        this.add((Component)haut, "North");
        this.add((Component)bas, "Center");
        bas.setLayout(new BorderLayout());
        haut.setLayout(new GridBagLayout());
        GridBagConstraints cPnlDate = new GridBagConstraints();
        cPnlDate.gridx = 0;
        cPnlDate.gridy = 0;
        cPnlDate.gridwidth = 2;
        cPnlDate.fill = 1;
        GridBagConstraints cJspTbl = new GridBagConstraints();
        cJspTbl.gridx = 0;
        cJspTbl.gridy = 1;
        cJspTbl.weightx = 0.8;
        cJspTbl.insets = new Insets(0, 5, 0, 0);
        cJspTbl.anchor = 11;
        cJspTbl.fill = 1;
        GridBagConstraints cPnlAct = new GridBagConstraints();
        cPnlAct.gridx = 1;
        cPnlAct.gridy = 1;
        cPnlAct.weightx = 0.2;
        cPnlAct.insets = new Insets(0, 10, 0, 5);
        cPnlAct.anchor = 11;
        cPnlAct.fill = 1;
        haut.add((Component)this.getPnlDateSelect(), cPnlDate);
        haut.add((Component)this.getJspTbl(), cJspTbl);
        haut.add((Component)this.getJspAct(), cPnlAct);
        bas.add((Component)this.getPnlToShow(), "North");
        bas.add((Component)this.getPnlGraphicGlobal(), "Center");
        TimsLogger.debug("getPnlGraphicGlobal height " + this.getPnlGraphicGlobal().getHeight());
    }

    public AbsencePopup getAbsencePopup() {
        if (this.ap == null) {
            this.ap = new AbsencePopup();
        }
        return this.ap;
    }

    private JPanel getPnlToShow() {
        if (this.pnlToShow == null) {
            Preferences prefs;
            this.pnlToShow = new JPanel();
            this.pnlToShow.setPreferredSize(new Dimension(479, 40));
            if (ConnexionSettings.getInstance().isConsultable("INFRACTION") && LicenceManager.isExploitationLevel()) {
                this.pnlToShow.add((Component)this.getCbOffence(), null);
            }
            if (ConnexionSettings.getInstance().isConsultable("ACTIVITE")) {
                this.pnlToShow.add((Component)this.getCbPlace(), null);
                this.pnlToShow.add((Component)this.getCbSpec(), null);
            }
            if (ConnexionSettings.getInstance().isConsultable("VEHICULE")) {
                this.pnlToShow.add((Component)this.getCbVehicle(), null);
            }
            if (ConnexionSettings.getInstance().isConsultable("FRAIS") && LicenceManager.isHRLevel()) {
                this.pnlToShow.add((Component)this.getCbExp(), null);
            }
            if (ConnexionSettings.getInstance().isConsultable("CALENDRIER") && LicenceManager.isHRLevel()) {
                this.pnlToShow.add((Component)this.getCbAbs(), null);
            }
            if (LicenceManager.isExploitationLevel()) {
                this.pnlToShow.add((Component)this.getCbBrut(), null);
            }
            if (ConnexionSettings.getInstance().isConsultable("ACTIVITE") && LicenceManager.isHRLevel()) {
                this.pnlToShow.add((Component)this.getCbExtActivity(), null);
            }
            if (ConnexionSettings.getInstance().isConsultable("TOURNEE") && LicenceManager.isHRLevel()) {
                this.pnlToShow.add((Component)this.getCbRound(), null);
            }
            if ((prefs = Preferences.userRoot().node("TIMS")).get("preference.offences", "0").equals("1")) {
                this.getCbOffence().setSelected(true);
            }
            if (prefs.get("preference.places", "0").equals("1")) {
                this.getCbPlace().setSelected(true);
            }
            if (prefs.get("preference.vehiclesUsed", "0").equals("1")) {
                this.getCbVehicle().setSelected(true);
            }
            if (prefs.get("preference.round", "0").equals("1")) {
                this.getCbRound().setSelected(true);
            }
            if (prefs.get("preference.expenses", "0").equals("1")) {
                this.getCbExp().setSelected(true);
            }
            if (prefs.get("preference.absences", "0").equals("1")) {
                this.getCbAbs().setSelected(true);
            }
            if (prefs.get("preference.activities", "0").equals("1")) {
                this.getCbExtActivity().setSelected(true);
            }
            if (prefs.get("preference.rawActivities", "0").equals("1")) {
                this.getCbBrut().setSelected(true);
            }
            this.getCbOffence().addItemListener(this.refreshListener);
            this.getCbSpec().addItemListener(this.refreshListener);
            this.getCbPlace().addItemListener(this.refreshListener);
            this.getCbRound().addItemListener(this.refreshListener);
            this.getCbExtActivity().addItemListener(this.refreshListener);
            this.getCbVehicle().addItemListener(this.refreshListener);
            this.getCbBrut().addItemListener(this.refreshListener);
            this.getCbBrut().addItemListener(this.refreshListener);
            this.getCbExp().addItemListener(this.refreshListener);
            this.getCbAbs().addItemListener(this.refreshListener);
        }
        return this.pnlToShow;
    }

    private JScrollPane getJspTbl() {
        if (this.jspTbl == null) {
            this.jspTbl = new JScrollPane();
            this.jspTbl.setPreferredSize(new Dimension(650, 187));
            this.jspTbl.setViewportView(this.getTblJour());
        }
        return this.jspTbl;
    }

    private JTable getTblJour() {
        if (this.tblJour == null) {
            this.tblJour = new JTable();
            this.tblJour.setRowHeight(21);
            this.tblJour.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (PnlActiviteC.this.tblJour.getSelectedRow() == 7) {
                        return;
                    }
                    PnlActiviteC.this.detailShow(PnlActiviteC.this.tblJour.getSelectedRow());
                }
            });
        }
        return this.tblJour;
    }

    private JPanel getPnlGraphicGlobal() {
        if (this.pnlGraphicGlobal == null) {
            JPanel dateSpacer;
            JPanel btnSpacer;
            this.pnlGraphicGlobal = new JPanel(new BorderLayout());
            JPanel borderPnlDate = new JPanel(new BorderLayout());
            JPanel gridPnlDate = new JPanel(new GridBagLayout());
            JPanel borderPnlBtn = new JPanel(new BorderLayout());
            JPanel gridPnlBtn = new JPanel(new GridBagLayout());
            if (Transport.debug >= 3) {
                gridPnlBtn.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            }
            int x = 0;
            borderPnlBtn.add((Component)gridPnlBtn, "Center");
            borderPnlDate.add((Component)gridPnlDate, "Center");
            int i = 0;
            while (i < 7) {
                btnSpacer = new JPanel();
                dateSpacer = new JPanel();
                if (Transport.debug >= 3) {
                    btnSpacer.setBorder(BorderFactory.createLineBorder(Color.blue));
                    dateSpacer.setBorder(BorderFactory.createLineBorder(Color.blue));
                }
                this.lblJour[i] = new JLabel();
                this.lblDate[i] = new JLabel();
                this.btnSup[i] = new JButton();
                this.btnSup[i].setPreferredSize(new Dimension(30, 30));
                this.btnSup[i].setIcon(new ImageIcon(this.cl.getResource(this.res.getResourceString("icone_sup"))));
                this.btnSup[i].setToolTipText(LanguageTranslator.getString("button.delete"));
                this.btnSup[i].addActionListener(new ActionDelJour(i));
                this.btnExport[i] = new BtnExport(i);
                this.btnExport[i].setPreferredSize(new Dimension(30, 30));
                this.btnExp[i] = new BtnExp(i);
                this.btnExp[i].setPreferredSize(new Dimension(30, 30));
                this.btnAbs[i] = new BtnAbsence(i);
                this.btnAbs[i].setPreferredSize(new Dimension(30, 30));
                this.btnAbs[i].setIcon(new ImageIcon(this.cl.getResource(this.res.getResourceString("icone_cal"))));
                this.btnImg[i] = new JButton();
                this.btnImg[i].setPreferredSize(new Dimension(30, 30));
                this.btnImg[i].setIcon(new ImageIcon(this.cl.getResource(this.res.getResourceString("icone_right"))));
                this.btnImg[i].setToolTipText(LanguageTranslator.getString("button.disc"));
                this.btnImg[i].addActionListener(new ActionShowDisque(i));
                this.btnDetail[i] = new JButton();
                this.btnDetail[i].setPreferredSize(new Dimension(30, 30));
                this.btnDetail[i].setIcon(new ImageIcon(this.cl.getResource(this.res.getResourceString("icone_loupe"))));
                this.btnDetail[i].setToolTipText(LanguageTranslator.getString("button.details"));
                this.btnDetail[i].addActionListener(new ActionShow(i));
                JPanel pnlBtnDay = new JPanel(new GridLayout(0, 3));
                gridPnlDate.add((Component)dateSpacer, Fonctions.getGridBagConstraints(0, x, 1, 2, 1.0, 1.0, 1, -1, null));
                gridPnlBtn.add((Component)btnSpacer, Fonctions.getGridBagConstraints(0, x++, 1, 1, 1.0, 1.0, 1, -1, null));
                gridPnlBtn.add((Component)pnlBtnDay, Fonctions.getGridBagConstraints(0, x, 1, 1, 0.0, 0.0, 2, -1, null));
                gridPnlDate.add((Component)this.lblJour[i], Fonctions.getGridBagConstraints(0, x, 1, 1, 0.0, 0.0, 0, -1, null));
                gridPnlDate.add((Component)this.lblDate[i], Fonctions.getGridBagConstraints(1, x++, 1, 1, 0.0, 0.0, 1, -1, null));
                if (Transport.debug >= 3) {
                    pnlBtnDay.setBorder(BorderFactory.createLineBorder(Color.red));
                }
                pnlBtnDay.add(this.btnDetail[i]);
                if (ConnexionSettings.getInstance().isSupprimable("ACTIVITE") && LicenceManager.isExploitationLevel()) {
                    pnlBtnDay.add(this.btnSup[i]);
                }
                pnlBtnDay.add(this.btnImg[i]);
                if (ConnexionSettings.getInstance().isConsultable("EXPENSES_VALIDATION") && LicenceManager.isHRLevel() && this.getCbExp().isSelected()) {
                    pnlBtnDay.add(this.btnExp[i]);
                }
                if (ConnexionSettings.getInstance().isConsultable("EXPORT_PAIE") && LicenceManager.isHRLevel()) {
                    pnlBtnDay.add(this.btnExport[i]);
                }
                if (ConnexionSettings.getInstance().isSupprimable("CALENDRIER") && LicenceManager.isHRLevel() && this.getCbAbs().isSelected()) {
                    pnlBtnDay.add(this.btnAbs[i]);
                }
                ++i;
            }
            int spacerHeight = 30;
            btnSpacer = new JPanel();
            dateSpacer = new JPanel();
            if (Transport.debug >= 3) {
                btnSpacer.setBorder(BorderFactory.createLineBorder(Color.blue));
                dateSpacer.setBorder(BorderFactory.createLineBorder(Color.blue));
            }
            btnSpacer.setPreferredSize(new Dimension(0, spacerHeight));
            dateSpacer.setPreferredSize(new Dimension(0, spacerHeight));
            gridPnlBtn.add((Component)btnSpacer, Fonctions.getGridBagConstraints(0, x, 1, 1, 0.0, 0.0, 0, -1, null));
            gridPnlDate.add((Component)dateSpacer, Fonctions.getGridBagConstraints(0, x, 1, 1, 0.0, 0.0, 0, -1, null));
            this.pnlGraphicGlobal.add((Component)borderPnlDate, "West");
            this.pnlGraphicGlobal.add((Component)this.getJspGraphe(), "Center");
            this.pnlGraphicGlobal.add((Component)borderPnlBtn, "East");
        }
        return this.pnlGraphicGlobal;
    }

    private JScrollPane getJspGraphe() {
        if (this.jspGraphe == null) {
            this.jspGraphe = new JScrollPane();
            this.jspGraphe.setPreferredSize(new Dimension(0, 0));
            this.jspGraphe.setHorizontalScrollBarPolicy(32);
            this.jspGraphe.setVerticalScrollBarPolicy(21);
            this.jspGraphe.setViewportView(this.getGraphe());
        }
        return this.jspGraphe;
    }

    private GrapheActivite getGraphe() {
        if (this.graphe == null) {
            this.graphe = new GrapheActivite(true);
        }
        return this.graphe;
    }

    private JPanel getPnlDateSelect() {
        if (this.pnlDateSelect == null) {
            this.pnlDateSelect = new JPanel();
            ((FlowLayout)this.pnlDateSelect.getLayout()).setVgap(15);
            this.btnSup1Jour.setPreferredSize(new Dimension(32, 32));
            this.btnSup1Jour.setFocusable(false);
            this.btnSup1Jour.setIcon(new ImageIcon(this.cl.getResource(this.res.getResourceString("icone_left"))));
            this.btnSup1Jour.addActionListener(new ActionAddJour(-1));
            this.btnSup7Jours.setPreferredSize(new Dimension(32, 32));
            this.btnSup7Jours.setFocusable(false);
            this.btnSup7Jours.setIcon(new ImageIcon(this.cl.getResource(this.res.getResourceString("icone_dleft"))));
            this.btnSup7Jours.addActionListener(new ActionAddJour(-7));
            this.btnAdd1Jour.setPreferredSize(new Dimension(32, 32));
            this.btnAdd1Jour.setFocusable(false);
            this.btnAdd1Jour.setIcon(new ImageIcon(this.cl.getResource(this.res.getResourceString("icone_right"))));
            this.btnAdd1Jour.addActionListener(new ActionAddJour(1));
            this.btnAdd7Jours.setPreferredSize(new Dimension(32, 32));
            this.btnAdd7Jours.setFocusable(false);
            this.btnAdd7Jours.setIcon(new ImageIcon(this.cl.getResource(this.res.getResourceString("icone_dright"))));
            this.btnAdd7Jours.addActionListener(new ActionAddJour(7));
            this.txtDate.setPreferredSize(new Dimension(70, 32));
            this.txtDate.setEditable(false);
            this.txtDriver = new JLabel();
            this.pnlDateSelect.add(this.txtDriver);
            this.pnlDateSelect.add((Component)this.btnSup7Jours, null);
            this.pnlDateSelect.add((Component)this.btnSup1Jour, null);
            this.pnlDateSelect.add((Component)this.txtDate, null);
            this.pnlDateSelect.add((Component)this.btnAdd1Jour, null);
            this.pnlDateSelect.add((Component)this.btnAdd7Jours, null);
            this.txtDate.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Fonctions.afficheCalendrier(PnlActiviteC.this.txtDate)) {
                        PnlActiviteC.this.refresh();
                    }
                }
            });
        }
        return this.pnlDateSelect;
    }

    private JScrollPane getJspAct() {
        if (this.pnlAct == null) {
            this.pnlAct = new JScrollPane();
            this.pnlAct.setPreferredSize(new Dimension(150, 166));
            this.pnlAct.setViewportView(this.getTblActivities());
        }
        return this.pnlAct;
    }

    private JTable getTblActivities() {
        if (this.tblActivities == null) {
            this.tblActivities = new JTable();
            this.tblActivities.setModel(new TMActivityType(TypeActivite.getList()));
            this.tblActivities.setDefaultRenderer(Color.class, new ColorRenderer(true));
            this.tblActivities.getColumnModel().getColumn(1).setPreferredWidth(5);
            this.tblActivities.setRowHeight(21);
        }
        return this.tblActivities;
    }

    private JCheckBox getCbBrut() {
        if (this.cbBrut == null) {
            this.cbBrut = new JCheckBox(LanguageTranslator.getString("activity.choiceType"));
        }
        return this.cbBrut;
    }

    private JCheckBox getCbVehicle() {
        if (this.cbVehicle == null) {
            this.cbVehicle = new JCheckBox(LanguageTranslator.getString("activity.seeVehicle"));
        }
        return this.cbVehicle;
    }

    private JCheckBox getCbOffence() {
        if (this.cbOffence == null) {
            this.cbOffence = new JCheckBox(LanguageTranslator.getString("activity.seeOffence"));
        }
        return this.cbOffence;
    }

    private JCheckBox getCbPlace() {
        if (this.cbPlace == null) {
            this.cbPlace = new JCheckBox(LanguageTranslator.getString("activity.seePlace"));
        }
        return this.cbPlace;
    }

    private JCheckBox getCbSpec() {
        if (this.cbSpec == null) {
            this.cbSpec = new JCheckBox(LanguageTranslator.getString("activity.seeSpec"));
        }
        return this.cbSpec;
    }

    private JCheckBox getCbExtActivity() {
        if (this.cbExtActivity == null) {
            this.cbExtActivity = new JCheckBox(LanguageTranslator.getString("activity.seeExtActivity"));
        }
        return this.cbExtActivity;
    }

    private JCheckBox getCbRound() {
        if (this.cbRound == null) {
            this.cbRound = new JCheckBox(LanguageTranslator.getString("activity.seeRound"));
        }
        return this.cbRound;
    }

    private JCheckBox getCbExp() {
        if (this.cbExp == null) {
            this.cbExp = new JCheckBox(LanguageTranslator.getString("activity.seeExpenses"));
        }
        return this.cbExp;
    }

    private JCheckBox getCbAbs() {
        if (this.cbAbs == null) {
            this.cbAbs = new JCheckBox(LanguageTranslator.getString("preference.absences"));
        }
        return this.cbAbs;
    }

    public void detailShow(int numJour) {
        MainFrameTransport.test0 = 5;
        String date = this.lblDate[numJour].getText().substring(0, 10);
        try {
            int etatJour = bddEco.getEtatJour(this.detailConducteur.getCleConducteur(), ConversionTime.dateFromFranceToBDD(date, false));
            if (etatJour == 0) {
                DialogDetailJournee detail = DialogDetailJournee.getInstance();
                detail.setDetail(this.detailConducteur, date, this.getCbBrut().isSelected(), this.detailJour.get(numJour));
                detail.addActivityChangeListener(this);
                detail.setVisible(true);
            } else if (etatJour == 1) {
                Vector<String> nb = bddEco.getCleJourSup(this.detailConducteur.getCleConducteur(), ConversionTime.dateFromFranceToBDD(date, false));
                new DialogDetailJourSupprime((Frame)MainFrameTransport.getInstance(), this.detailConducteur, date, nb).setVisible(true);
                this.refresh();
            } else if (etatJour == 2 && ConnexionSettings.getInstance().isAjoutable("ACTIVITE")) {
                if (JOptionPane.showConfirmDialog(this.getParent(), LanguageTranslator.getString("activity.empty", date), "", 0) == 0) {
                    new DialogCreerJour((Frame)MainFrameTransport.getInstance(), this.detailConducteur, date).setVisible(true);
                    this.refresh();
                }
            } else {
                TimsLogger.warn("etatJour = " + etatJour + " et fiche activit\u00e9 (ajout) = " + ConnexionSettings.getInstance().isAjoutable("ACTIVITE"));
                JOptionPane.showMessageDialog(this.getParent(), LanguageTranslator.getString("message.numberedError", "192"), "", 0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void activityChanged() {
        this.refresh();
    }

    public void setDB(BddTransport bdd, Conducteur detailConducteur) {
        this.load = false;
        bddEco = bdd;
        this.txtDate.setText(this.dateFormat.format(new Date()));
        this.detailConducteur = detailConducteur;
        if (ConnexionSettings.getInstance().isConsultable("EXPORT_PAIE") && LicenceManager.isHRLevel()) {
            this.lastExport = BddTransport.getInstance().getLastExport(detailConducteur.getCleConducteur());
        }
        this.txtDriver.setText(String.valueOf(detailConducteur.getNom()) + " " + detailConducteur.getPrenom());
    }

    public void setActiv(Date dateJour) {
        this.txtDate.setText(this.dateFormat.format(dateJour));
    }

    @Override
    public void loadData() {
        if (!this.load) {
            this.loadDate(ConversionTime.stringToDate(this.txtDate.getText(), "dd/MM/yyyy"));
            this.load = true;
        }
    }

    public void loadDate(Date premierJour) {
        long start2 = System.currentTimeMillis();
        if (premierJour == null) {
            return;
        }
        this.txtDate.setText(this.dateFormat.format(premierJour));
        String date = ConversionTime.dateToString(premierJour, "yyyy-MM-dd");
        Vector[] inf = null;
        Vector[] prise = null;
        Vector[] place = null;
        Vector[] spec = null;
        Vector[] extDay = null;
        Vector<RoundAffectation> round = null;
        Vector<DriverExpenses> expenses = null;
        Vector<LienJourConducteur> absences = null;
        if (this.getCbOffence().isSelected()) {
            inf = bddEco.getInfractionConducteurSemaine(this.detailConducteur.getCleConducteur(), premierJour, this.getCbBrut().isSelected());
        }
        if (this.getCbVehicle().isSelected()) {
            prise = bddEco.getPriseVehiculeSemaine(this.detailConducteur.getCleConducteur(), premierJour);
        }
        if (this.getCbPlace().isSelected()) {
            place = bddEco.getPlaceSemaine(this.detailConducteur.getCleConducteur(), premierJour);
        }
        if (this.getCbSpec().isSelected()) {
            spec = bddEco.getSpecificConditionSemaine(this.detailConducteur.getCleConducteur(), premierJour);
        }
        if (this.getCbExtActivity().isSelected()) {
            extDay = ExternalDay.loadListOrderedByWeek(this.detailConducteur.getCleConducteur(), premierJour);
        }
        if (this.getCbRound().isSelected()) {
            round = RoundAffectation.loadList(0, 0, this.detailConducteur.getCleConducteur(), premierJour, ConversionTime.add(premierJour, 5, 6), null);
        }
        if (this.getCbExp().isSelected()) {
            expenses = DriverExpenses.loadList(0, this.detailConducteur.getCleConducteur(), premierJour, ConversionTime.add(premierJour, 5, 6));
        }
        if (this.getCbAbs().isSelected()) {
            absences = LienJourConducteur.loadList(0, this.detailConducteur.getCleConducteur(), premierJour, ConversionTime.add(premierJour, 5, 6));
        }
        try {
            this.detailJour = bddEco.getJour(this.detailConducteur.getCleConducteur(), date, ConversionTime.addDay(date, "yyyy-MM-dd", 6), this.getCbBrut().isSelected(), false, false);
        }
        catch (DayException ex) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("driver.activity.doubleError"), LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(1)) + "1"), 0);
            return;
        }
        Vector<ExpensesValidation> expValid = null;
        if (ConnexionSettings.getInstance().isConsultable("EXPENSES_VALIDATION")) {
            expValid = ExpensesValidation.loadList(this.detailConducteur.getCleConducteur(), premierJour, ConversionTime.addDay(premierJour, 7));
        }
        Transport.ps.startOperation();
        this.modele_activ = new Model_table_ActivC(this.detailJour);
        this.getTblJour().setModel(this.modele_activ);
        Fonctions.centrerTable(this.getTblJour());
        this.getGraphe().initialiser(this.detailConducteur, premierJour, this.detailJour, round, inf, prise, place, spec, extDay, expenses, expValid, absences, this.getCbExp().isSelected());
        int i = 0;
        while (i < 7) {
            Object tmp;
            Date day = ConversionTime.stringToDate(this.detailJour.get(i).getDate(), "yyyy-MM-dd");
            if (this.detailJour.get(i).getUpdate() > 0) {
                this.lblDate[i].setForeground(Color.RED);
            } else if (this.detailJour.get(i).isDelete()) {
                this.lblDate[i].setForeground(Color.BLUE);
            } else {
                this.lblDate[i].setForeground(Color.BLACK);
            }
            this.lblDate[i].setText(ConversionTime.dateFromBDDToFrance(this.detailJour.get(i).getDate(), false, true));
            this.lblJour[i].setText(ConversionTime.getJour(this.detailJour.get(i).getDate()).substring(0, 1).toUpperCase());
            if (this.detailJour.get(i).getComment() != null) {
                String html = "<html>" + this.detailJour.get(i).getComment().replace("\r\n", "<br>") + "</html>";
                html = String.valueOf(html) + html.replace("\n", "<br>");
                this.lblDate[i].setToolTipText(html);
                this.lblDate[i].setText(String.valueOf(this.lblDate[i].getText()) + "*");
            } else {
                this.lblDate[i].setToolTipText(null);
            }
            if (ConnexionSettings.getInstance().isConsultable("EXPORT_PAIE") && LicenceManager.isHRLevel()) {
                this.btnExport[i].setEnabled(true);
                this.btnExport[i].setExport(null);
                if (this.lastExport != null && this.lastExport.after(day)) {
                    tmp = new ExportUpdate();
                    if (((ExportUpdate)tmp).load(this.detailConducteur.getCleConducteur(), day)) {
                        this.btnExport[i].setExport((ExportUpdate)tmp);
                        this.btnExport[i].setIcon(new ImageIcon(this.cl.getResource(this.res.getResourceString("icone_wait_export"))));
                        this.btnExport[i].setToolTipText(LanguageTranslator.getString("export.unvalided"));
                    } else {
                        if (!ConnexionSettings.getInstance().isModifiable("EXPORT_PAIE")) {
                            this.btnExport[i].setEnabled(false);
                        }
                        this.btnExport[i].setIcon(new ImageIcon(this.cl.getResource(this.res.getResourceString("icone_exported"))));
                        this.btnExport[i].setToolTipText(LanguageTranslator.getString("export.unvalid"));
                    }
                } else {
                    this.btnExport[i].setEnabled(false);
                    this.btnExport[i].setIcon(new ImageIcon(this.cl.getResource(this.res.getResourceString("icone_wait_export"))));
                    this.btnExport[i].setToolTipText(LanguageTranslator.getString("export.un"));
                }
            }
            if (ConnexionSettings.getInstance().isConsultable("EXPENSES_VALIDATION")) {
                this.btnExp[i].setEnabled(true);
                this.btnExp[i].setExpValid(null);
                tmp = ExpensesValidation.find(expValid, this.detailConducteur.getCleConducteur(), ConversionTime.stringToDate(this.detailJour.get(i).getDate(), "yyyy-MM-dd"));
                if (((Vector)tmp).size() != 0) {
                    if (((Vector)tmp).size() > 1) {
                        TimsLogger.debug("2 clot\u00fbres sur la m\u00eame journ\u00e9e");
                    }
                    if (!ConnexionSettings.getInstance().isSupprimable("EXPENSES_VALIDATION")) {
                        this.btnExp[i].setEnabled(false);
                    }
                    this.btnExp[i].setIcon(new ImageIcon(this.cl.getResource(this.res.getResourceString("icone_padlock"))));
                    this.btnExp[i].setToolTipText(LanguageTranslator.getString("expenses.unvalid"));
                    this.btnExp[i].setExpValid((ExpensesValidation)((Vector)tmp).get(0));
                } else {
                    if (!ConnexionSettings.getInstance().isAjoutable("EXPENSES_VALIDATION")) {
                        this.btnExp[i].setEnabled(false);
                    }
                    this.btnExp[i].setIcon(new ImageIcon(this.cl.getResource(this.res.getResourceString("icone_opadlock"))));
                    this.btnExp[i].setToolTipText(LanguageTranslator.getString("expenses.valid"));
                }
            }
            if (ConnexionSettings.getInstance().isSupprimable("CALENDRIER") && LicenceManager.isHRLevel()) {
                this.btnAbs[i].setDriver(this.detailConducteur);
            }
            ++i;
        }
        this.updateButton();
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "Rechargement des activit\u00e9s");
        TimsLogger.debug("#PnlActiviteC.setActiv# init jtable : " + (System.currentTimeMillis() - start2));
    }

    public Jour getDay(int x) {
        return this.detailJour.get(x);
    }

    private void updateButton() {
        int i = 0;
        while (i < 7) {
            Vector<ActiviteConducteur> tmp = this.detailJour.get(i).getActivity();
            if (tmp != null && tmp.size() != 0) {
                this.btnSup[i].setEnabled(true);
            } else {
                this.btnSup[i].setEnabled(false);
            }
            this.btnImg[i].setEnabled(false);
            if (this.detailJour.get(i).getSourceName() != null && this.detailJour.get(i).getSourceName().contains(".jpg")) {
                this.btnImg[i].setEnabled(true);
            }
            ++i;
        }
    }

    class ActionAddJour
    implements ActionListener {
        private int nbJour = 0;

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String date_courante = PnlActiviteC.this.txtDate.getText();
                Date date_field = PnlActiviteC.this.dateFormat.parse(date_courante);
                PnlActiviteC.this.calendar.setTime(date_field);
                PnlActiviteC.this.calendar.add(5, this.nbJour);
                PnlActiviteC.this.txtDate.setText(PnlActiviteC.this.dateFormat.format(PnlActiviteC.this.calendar.getTime()));
                Date premierJour = PnlActiviteC.this.calendar.getTime();
                PnlActiviteC.this.loadDate(premierJour);
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }

        public ActionAddJour(int nb) {
            this.nbJour = nb;
        }
    }

    class ActionDelJour
    implements ActionListener {
        private int numJour = 0;

        @Override
        public void actionPerformed(ActionEvent e) {
            int tmp = JOptionPane.showConfirmDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("activity.delete.warning", PnlActiviteC.this.lblDate[this.numJour].getText()), LanguageTranslator.getString("message.confirm"), 2);
            if (tmp == 0) {
                if (bddEco.getNombreConflit(PnlActiviteC.this.detailConducteur.getCleConducteur(), ConversionTime.dateFromFranceToBDD(PnlActiviteC.this.lblDate[this.numJour].getText(), false))) {
                    JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("activity.delete.conflictError"), "", 0);
                } else {
                    String raison = JOptionPane.showInputDialog(LanguageTranslator.getString("activity.delete.reason"));
                    if (raison != null && !raison.equals("")) {
                        int cleConducteur = PnlActiviteC.this.detailConducteur.getCleConducteur();
                        String dateBDD = ConversionTime.dateFromFranceToBDD(PnlActiviteC.this.lblDate[this.numJour].getText(), false);
                        Date day = ConversionTime.stringToDate(dateBDD, "yyyy-MM-dd");
                        bddEco.delJour(cleConducteur, dateBDD, raison);
                        for (VehicleUsed vehicleUsed : VehicleUsed.loadListDriver(cleConducteur, 0, dateBDD, null)) {
                            vehicleUsed.delete("driver_vehicle_used");
                        }
                        for (Place place : Place.load(cleConducteur, ConversionTime.dateToString(day, "yyyy-MM-dd"), null)) {
                            place.delete();
                        }
                        try {
                            TraitementTempsService traitementTempsService = new TraitementTempsService(PnlActiviteC.this.detailConducteur, dateBDD, dateBDD, true);
                            traitementTempsService.loadActivite();
                            traitementTempsService.calculService();
                            traitementTempsService.saveListe();
                        }
                        catch (ServiceException serviceException) {
                            serviceException.printStackTrace();
                        }
                        if (System.getProperty("horoquartz", "0").equals("1")) {
                            Date date = BddTransport.getInstance().getLastExport(PnlActiviteC.this.detailConducteur.getCleConducteur());
                            Date jour = ConversionTime.stringToDate(dateBDD, "yyyy-MM-dd");
                            if (date != null && (jour.before(date) || jour.equals(date))) {
                                BddTransport.getInstance().updateExportHoroquartz(PnlActiviteC.this.detailConducteur.getCleConducteur(), dateBDD);
                            }
                        }
                        JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("message.done"), LanguageTranslator.getString("message.deleteSucceed"), 1);
                        PnlActiviteC.this.refresh();
                    }
                }
            }
        }

        public ActionDelJour(int nb) {
            this.numJour = nb;
        }
    }

    class ActionShow
    implements ActionListener {
        private int numJour = 0;

        @Override
        public void actionPerformed(ActionEvent e) {
            PnlActiviteC.this.detailShow(this.numJour);
        }

        public ActionShow(int nb) {
            this.numJour = nb;
        }
    }

    class ActionShowDisque
    implements ActionListener {
        private int numJour;

        @Override
        public void actionPerformed(ActionEvent e) {
            Vector<String> images = new Vector<String>();
            String[] timage = ((Jour)PnlActiviteC.this.detailJour.get(this.numJour)).getSourceName().split(";");
            int x = 0;
            while (x < timage.length) {
                if (timage[x].contains("jpg")) {
                    images.add(timage[x]);
                }
                ++x;
            }
            if (images.size() != 0 && images.get(0) != null) {
                new ImageViewer(MainFrameTransport.getInstance(), PnlActiviteC.this.detailConducteur, images).setVisible(true);
            } else {
                JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("activity.noDisc"), "", 2);
            }
        }

        public ActionShowDisque(int nb) {
            this.numJour = nb;
        }
    }

    class BtnAbsence
    extends JButton
    implements PopupCaller {
        Conducteur driver = null;
        int nbJour = 0;
        boolean isPopupVisible = false;

        public BtnAbsence(int nbJour) {
            this.nbJour = nbJour;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    BtnAbsence.this.callPopup(e);
                }
            });
        }

        public void setDriver(Conducteur driver) {
            this.driver = driver;
        }

        @Override
        public void callPopup(MouseEvent e) {
            this.isPopupVisible = true;
            TimsLogger.debug("show popup");
            PnlActiviteC.this.getAbsencePopup().set(PnlActiviteC.this.detailConducteur, ConversionTime.stringToDateFr(PnlActiviteC.this.lblDate[this.nbJour].getText().substring(0, 10)));
            PnlActiviteC.this.getAbsencePopup().show((Component)e.getSource(), e.getX(), e.getY());
        }

        @Override
        public void submitPopup() {
            this.isPopupVisible = false;
            PnlActiviteC.this.refresh();
        }
    }

    class BtnExp
    extends JButton
    implements ActionListener {
        ExpensesValidation expValid = null;
        int nbJour = 0;

        public BtnExp(int nbJour) {
            this.nbJour = nbJour;
            this.addActionListener(this);
        }

        public void setExpValid(ExpensesValidation toSet) {
            this.expValid = toSet;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Date date = PnlActiviteC.this.dateFormat.parse(PnlActiviteC.this.lblDate[this.nbJour].getText().substring(0, 10));
                if (this.expValid == null || this.expValid.getUserUnvalid() != -1) {
                    TimsLogger.debug("on cloture le " + date + " " + PnlActiviteC.this.detailConducteur.getCleConducteur());
                    this.expValid = new ExpensesValidation(0, PnlActiviteC.this.detailConducteur.getCleConducteur(), date, new Date(), ConnexionSettings.getInstance().getUserCle(), new Date(), -1);
                    this.expValid.update();
                    this.setIcon(new ImageIcon(PnlActiviteC.this.cl.getResource(PnlActiviteC.this.res.getResourceString("icone_padlock"))));
                    this.setToolTipText(LanguageTranslator.getString("expenses.unvalid"));
                } else {
                    TimsLogger.debug("on decloture le " + date + " " + PnlActiviteC.this.detailConducteur.getCleConducteur());
                    this.expValid.unlock();
                    this.setIcon(new ImageIcon(PnlActiviteC.this.cl.getResource(PnlActiviteC.this.res.getResourceString("icone_opadlock"))));
                    this.setToolTipText(LanguageTranslator.getString("expenses.valid"));
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
    }

    class BtnExport
    extends JButton
    implements ActionListener {
        ExportUpdate export = null;
        int nbJour = 0;

        public BtnExport(int nbJour) {
            this.nbJour = nbJour;
            this.addActionListener(this);
        }

        public void setExport(ExportUpdate toSet) {
            this.export = toSet;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Date date = PnlActiviteC.this.dateFormat.parse(PnlActiviteC.this.lblDate[this.nbJour].getText().substring(0, 10));
                if (this.export == null) {
                    TimsLogger.debug("on demande le r\u00e9export pour le " + date + " " + PnlActiviteC.this.detailConducteur.getCleConducteur());
                    this.export = new ExportUpdate(0, PnlActiviteC.this.detailConducteur.getCleConducteur(), date, ConnexionSettings.getInstance().getUserCle(), false);
                    this.export.insert();
                    this.setIcon(new ImageIcon(PnlActiviteC.this.cl.getResource(PnlActiviteC.this.res.getResourceString("icone_wait_export"))));
                    this.setToolTipText(LanguageTranslator.getString("export.unvalided"));
                } else {
                    TimsLogger.debug("on enl\u00e8ve le demande de r\u00e9export pour le " + date + " " + PnlActiviteC.this.detailConducteur.getCleConducteur());
                    this.export.delete();
                    this.setIcon(new ImageIcon(PnlActiviteC.this.cl.getResource(PnlActiviteC.this.res.getResourceString("icone_exported"))));
                    this.setToolTipText(LanguageTranslator.getString("export.unvalid"));
                    this.export = null;
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
    }
}

