/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.conducteur;

import fr.pgh.component.JMultiListBox;
import fr.pgh.component.JPanelButton;
import fr.pgh.component.JTextDate;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class PnlPlanningPopup
extends JPopupMenu
implements DataListener {
    public static int CANCELLED = 0;
    public static int VALIDATED = 1;
    private int status = CANCELLED;
    JTextDate txtBegin = null;
    JCheckBox cbUntil = null;
    JTextDate txtEnd = null;
    JList<JourType> dayTypeList = null;
    JMultiListBox<Conducteur> mbDriversList = null;
    JMultiListBox<Vehicule> mbVehiclesList = null;
    JTextArea txtComm = null;
    JPanelButton pnlBtn = null;
    JButton btnValid = null;
    JButton btnCancel = null;
    MouseListener lsl = null;

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        BddEvent e;
        if (dataEvent instanceof BddEvent && (e = (BddEvent)dataEvent).getTable().equals(JourType.table)) {
            this.getDayTypeList().setModel(new ComboBoxModel(JourType.getList(), true, LanguageTranslator.getString("generics.none")));
        }
    }

    public PnlPlanningPopup() {
        this.initialize();
    }

    public void initialize() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getTxtBegin(), Fonctions.getGridBagConstraints(0, 0));
        this.add((Component)this.getCbUntil(), Fonctions.getGridBagConstraints(1, 0));
        this.add((Component)this.getTxtEnd(), Fonctions.getGridBagConstraints(2, 0));
        this.add(this.getDayTypeList(), Fonctions.getGridBagConstraints(0, 1));
        this.add(this.getMbDriversList(), Fonctions.getGridBagConstraints(0, 2));
        this.add(this.getMbVehiclesList(), Fonctions.getGridBagConstraints(0, 3));
        this.add((Component)this.getTxtComm(), Fonctions.getGridBagConstraints(0, 4));
        this.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 5));
        BddTransport.getInstance().addDataListener(this);
    }

    public JList<JourType> getDayTypeList() {
        if (this.dayTypeList == null) {
            this.dayTypeList = new JList(new ComboBoxModel(JourType.getList(), true, LanguageTranslator.getString("generics.none")));
        }
        return this.dayTypeList;
    }

    public JMultiListBox<Conducteur> getMbDriversList() {
        if (this.mbDriversList == null) {
            this.mbDriversList = new JMultiListBox<Conducteur>(Conducteur.loadList(new Integer[0]), false);
        }
        return this.mbDriversList;
    }

    public JMultiListBox<Vehicule> getMbVehiclesList() {
        if (this.mbVehiclesList == null) {
            this.mbVehiclesList = new JMultiListBox<Vehicule>(Vehicule.loadList(new Integer[0]), false);
        }
        return this.mbVehiclesList;
    }

    public int getStatus() {
        return this.status;
    }

    private JTextArea getTxtComm() {
        if (this.txtComm == null) {
            this.txtComm = new JTextArea();
        }
        return this.txtComm;
    }

    private JTextDate getTxtBegin() {
        if (this.txtBegin == null) {
            this.txtBegin = new JTextDate();
        }
        return this.txtBegin;
    }

    private JTextDate getTxtEnd() {
        if (this.txtEnd == null) {
            this.txtEnd = new JTextDate();
        }
        return this.txtEnd;
    }

    private JCheckBox getCbUntil() {
        if (this.cbUntil == null) {
            this.cbUntil = new JCheckBox("generics.doUntil");
        }
        return this.cbUntil;
    }

    private JPanelButton getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanelButton();
            this.pnlBtn.addBtn(this.getBtnValid());
            this.pnlBtn.addBtn(this.getBtnCancel());
        }
        return this.pnlBtn;
    }

    private JButton getBtnValid() {
        if (this.btnValid == null) {
            this.btnValid = new JButton(LanguageTranslator.getString("generics.save"));
        }
        return this.btnValid;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton(LanguageTranslator.getString("generics.cancel"));
        }
        return this.btnCancel;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public void saveAndExit() {
        this.status = VALIDATED;
        this.setVisible(false);
    }

    public void exit() {
        this.status = CANCELLED;
        this.setVisible(false);
    }
}

