/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.conducteur;

import fr.pgh.component.JFittedComboBox;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.TMVehicleUsed;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.ui.calendrier.JCalendrier;

public class PnlVehiculeConducteur
extends JPanel
implements Observer {
    private static final long serialVersionUID = 1L;
    private String dateJour;
    private Conducteur conducteur;
    private int modification;
    private JButton btnAdd = null;
    private JButton btnDel = null;
    private JScrollPane jspTable = null;
    private JTable tableVehicule = null;
    private TMVehicleUsed modeleTableVehicule = null;
    private JComboBox cbVehicule = null;
    private Vector<VehicleUsed> rowToDel = null;
    private Vector<VehicleUsed> rowToUpdate = null;
    private JLabel lblKm = null;
    private JTextField txtKm = null;
    EventListenerList listenerList = new EventListenerList();

    @Override
    public void update(Observable o, Object arg) {
        TimsLogger.verbose("#" + this.getClass() + ".update# a faire");
        LanguageTranslator.getInstance().addObserver(this);
    }

    public PnlVehiculeConducteur() {
        LanguageTranslator.getInstance().addObserver(this);
        this.initialize();
    }

    public void setModification(int modification) {
        this.modification = modification;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.fill = 2;
        gridBagConstraints21.gridy = 1;
        gridBagConstraints21.weightx = 0.0;
        gridBagConstraints21.weighty = 0.0;
        gridBagConstraints21.gridx = 4;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 3;
        gridBagConstraints11.anchor = 13;
        gridBagConstraints11.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints11.gridy = 1;
        this.lblKm = new JLabel();
        this.lblKm.setText(LanguageTranslator.getString("vehicle.fastKmInput"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.gridwidth = 4;
        gridBagConstraints3.gridx = 1;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(2, 5, 5, 5);
        gridBagConstraints2.gridy = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.weightx = 0.0;
        gridBagConstraints1.insets = new Insets(2, 5, 5, 5);
        gridBagConstraints1.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setBounds(new Rectangle(0, 0, 450, 150));
        if (ConnexionSettings.getInstance().isAjoutable("VEHICULE")) {
            this.add((Component)this.getBtnAdd(), gridBagConstraints1);
        }
        if (ConnexionSettings.getInstance().isSupprimable("VEHICULE")) {
            this.add((Component)this.getBtnDel(), gridBagConstraints2);
        }
        this.add((Component)this.getJspTable(), gridBagConstraints3);
        this.add((Component)this.lblKm, gridBagConstraints11);
        this.add((Component)this.getTxtKm(), gridBagConstraints21);
    }

    private JButton getBtnAdd() {
        if (this.btnAdd == null) {
            this.btnAdd = new JButton();
            this.btnAdd.setText(LanguageTranslator.getString("button.add"));
            this.btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlVehiculeConducteur.this.newLine();
                }
            });
        }
        return this.btnAdd;
    }

    public void newLine() {
        Date date = ConversionTime.stringToDateFr(this.dateJour);
        VehicleUsed toAdd = new VehicleUsed(this.conducteur.getCleConducteur(), this.conducteur.getNom(), this.conducteur.getPrenom(), this.conducteur.getNumeroCarte(), date, date);
        this.getModeleTableVehicule().addRow(toAdd);
    }

    private JButton getBtnDel() {
        if (this.btnDel == null) {
            this.btnDel = new JButton();
            this.btnDel.setText(LanguageTranslator.getString("button.delete"));
            this.btnDel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlVehiculeConducteur.this.commit();
                    int row = PnlVehiculeConducteur.this.getTableVehicule().getSelectedRow();
                    VehicleUsed toDel = PnlVehiculeConducteur.this.getModeleTableVehicule().removeRow(row);
                    if (toDel.getCle() != 0) {
                        PnlVehiculeConducteur.this.getRowToDel().add(toDel);
                    } else {
                        PnlVehiculeConducteur.this.getRowToUpdate().remove(toDel);
                    }
                    toDel.print();
                }
            });
        }
        return this.btnDel;
    }

    private JScrollPane getJspTable() {
        if (this.jspTable == null) {
            this.jspTable = new JScrollPane();
            this.jspTable.setViewportView(this.getTableVehicule());
        }
        return this.jspTable;
    }

    public JTable getTableVehicule() {
        if (this.tableVehicule == null) {
            this.tableVehicule = new JTable();
            this.tableVehicule.setModel(this.getModeleTableVehicule());
            this.tableVehicule.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "none");
            this.cbEditor(this.tableVehicule.getColumnModel().getColumn(0));
            this.setSize(this.tableVehicule);
            this.tableVehicule.setCellSelectionEnabled(true);
            this.tableVehicule.setColumnSelectionAllowed(true);
            this.tableVehicule.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        int row = PnlVehiculeConducteur.this.getTableVehicule().getSelectedRow();
                        int column = PnlVehiculeConducteur.this.getTableVehicule().getSelectedColumn();
                        if (column == 1 || column == 3) {
                            JCalendrier.affiche(e.getPoint());
                            if (JCalendrier.clicked()) {
                                PnlVehiculeConducteur.this.getModeleTableVehicule().setValueAt(JCalendrier.getDate(), row, column);
                            }
                        }
                    }
                }
            });
        }
        return this.tableVehicule;
    }

    private void setSize(JTable table) {
        table.setRowHeight(20);
        table.getColumnModel().getColumn(0).setMinWidth(75);
        table.getColumnModel().getColumn(1).setMinWidth(57);
        table.getColumnModel().getColumn(2).setMinWidth(15);
        table.getColumnModel().getColumn(3).setMinWidth(57);
        table.getColumnModel().getColumn(4).setMinWidth(15);
        table.getColumnModel().getColumn(5).setMinWidth(45);
        table.getColumnModel().getColumn(6).setMinWidth(45);
    }

    private void cbEditor(TableColumn col) {
        DefaultCellEditor dce = new DefaultCellEditor(this.getCbVehicule());
        dce.setClickCountToStart(2);
        col.setCellEditor(dce);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText(LanguageTranslator.getString("generics.doubleClick"));
        col.setCellRenderer(renderer);
    }

    public TMVehicleUsed getModeleTableVehicule() {
        if (this.modeleTableVehicule == null) {
            Vector<VehicleUsed> tmp = null;
            tmp = this.conducteur != null && this.dateJour != null ? VehicleUsed.loadListDriver(this.conducteur.getCleConducteur(), 0, ConversionTime.dateFromFranceToBDD(this.dateJour, false), null) : new Vector<VehicleUsed>();
            this.modeleTableVehicule = new TMVehicleUsed(tmp, new ChangeTableListener());
        }
        return this.modeleTableVehicule;
    }

    private void setModeleTableVehicule(TMVehicleUsed modelTableVehicule) {
        this.modeleTableVehicule = modelTableVehicule;
    }

    public void commit() {
        TimsLogger.verbose("#PnlVehiculeConducteur# commit");
        int row = this.getTableVehicule().getSelectedRow();
        int column = this.getTableVehicule().getSelectedColumn();
        if (!this.getTableVehicule().isEditing()) {
            TimsLogger.verbose("not editing a cell");
        } else {
            TimsLogger.verbose("STOP EDITING " + row + " : " + column);
            this.getTableVehicule().getCellEditor(row, column).stopCellEditing();
        }
    }

    private JComboBox getCbVehicule() {
        if (this.cbVehicule == null) {
            this.cbVehicule = new JFittedComboBox();
        }
        return this.cbVehicule;
    }

    private Vector<VehicleUsed> getRowToDel() {
        if (this.rowToDel == null) {
            this.rowToDel = new Vector();
        }
        return this.rowToDel;
    }

    private Vector<VehicleUsed> getRowToUpdate() {
        if (this.rowToUpdate == null) {
            this.rowToUpdate = new Vector();
        }
        return this.rowToUpdate;
    }

    public boolean sauvegarde() {
        this.commit();
        Iterator<VehicleUsed> iter = this.getRowToDel().iterator();
        while (iter.hasNext()) {
            if (iter.next().delete("driver_vehicle_used")) continue;
            return false;
        }
        iter = this.getRowToUpdate().iterator();
        while (iter.hasNext()) {
            if (iter.next().update("driver_vehicle_used")) continue;
            return false;
        }
        return true;
    }

    public void initialise(Vector<Vehicule> vehiclesList, Vector<VehicleUsed> tmp, Conducteur conducteur, String dateJour) {
        this.conducteur = conducteur;
        this.dateJour = dateJour;
        if (vehiclesList == null) {
            vehiclesList = System.getProperty("scan.vehicle.enlarge", "0").equals("0") ? Vehicule.loadList(conducteur.getCleAgence()) : Vehicule.getList();
        }
        this.getCbVehicule().setModel(new ComboBoxModel(vehiclesList, false, null));
        this.setModeleTableVehicule(new TMVehicleUsed(tmp, new ChangeTableListener()));
        this.getTableVehicule().setModel(this.getModeleTableVehicule());
        this.cbEditor(this.tableVehicule.getColumnModel().getColumn(0));
        this.setSize(this.tableVehicule);
        this.tableVehicule.setCellSelectionEnabled(true);
        this.tableVehicule.setColumnSelectionAllowed(true);
        int km = Transport.bdd.getKmJour(ConversionTime.dateFromFranceToBDD(dateJour, false), conducteur.getCleConducteur(), this.modification);
        this.txtKm.setText(String.valueOf(km));
    }

    public Vector<VehicleUsed> getListeVehiculeConducteur() {
        return this.getModeleTableVehicule().getData();
    }

    private JTextField getTxtKm() {
        if (this.txtKm == null) {
            this.txtKm = new JTextField();
        }
        return this.txtKm;
    }

    public void setKm(int km) {
        this.getTxtKm().setText(String.valueOf(km));
    }

    public int getKm() {
        if (this.getTxtKm().getText().equals("") || Integer.valueOf(this.getTxtKm().getText()) == 0) {
            int km = 0;
            for (VehicleUsed iter : this.getModeleTableVehicule().getData()) {
                km += iter.getKmEffectue();
            }
            return km;
        }
        return Integer.valueOf(this.getTxtKm().getText());
    }

    public VehicleUsed getSelectedVehicule() {
        return this.getModeleTableVehicule().getRow(this.getTableVehicule().getSelectedRow());
    }

    public void addKmListener(KmListener kmListener) {
        this.listenerList.add(KmListener.class, kmListener);
    }

    public void removeKmListener(KmListener kmListener) {
        this.listenerList.remove(KmListener.class, kmListener);
    }

    public void fireKmChanged(int km) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == KmListener.class) {
                ((KmListener)listeners[i + 1]).kmChanged(km);
            }
            ++i;
        }
    }

    class ChangeTableListener
    implements TableModelListener {
        @Override
        public void tableChanged(TableModelEvent e) {
            switch (e.getType()) {
                case -1: {
                    TimsLogger.verbose("suppression");
                    break;
                }
                case 1: {
                    TimsLogger.verbose("insertion " + e.getFirstRow());
                    PnlVehiculeConducteur.this.getRowToUpdate().add(PnlVehiculeConducteur.this.getModeleTableVehicule().getRow(e.getFirstRow()));
                    break;
                }
                case 0: {
                    if (e.getColumn() == 7) {
                        int km = 0;
                        int x = 0;
                        while (x < PnlVehiculeConducteur.this.getModeleTableVehicule().getRowCount()) {
                            km += PnlVehiculeConducteur.this.getModeleTableVehicule().getRow(x).getKmEffectue();
                            ++x;
                        }
                        PnlVehiculeConducteur.this.getTxtKm().setText(String.valueOf(km));
                        PnlVehiculeConducteur.this.fireKmChanged(km);
                    }
                    VehicleUsed tmp = PnlVehiculeConducteur.this.getModeleTableVehicule().getRow(e.getFirstRow());
                    if (PnlVehiculeConducteur.this.getRowToUpdate().contains(tmp) || tmp.getCle() == 0) break;
                    PnlVehiculeConducteur.this.getRowToUpdate().add(tmp);
                }
            }
        }
    }

    public static interface KmListener
    extends EventListener {
        public void kmChanged(int var1);
    }
}

