/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.export;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import transpo.system.PerformanceScanner;
import transpo.system.Transport;
import transpo.system.exp.VehicleExport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.LMVehicle;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogExportVehicule
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JList listeVehicule = null;
    private JComboBox cbAgence = null;
    private JPanel pnlDetail = null;
    private JScrollPane jspListe = null;
    private JTextField txtDebut = null;
    private JTextField txtFin = null;
    private JLabel lblFin = null;
    private JLabel lblDebut = null;
    private JCheckBox cbSuppression = null;
    private JButton btnEnvoyer = null;
    private JButton btnQuitter = null;
    private BddTransport database = null;
    private JCheckBox cbArchive = null;

    public DialogExportVehicule(Frame owner, BddTransport database) {
        super(owner);
        this.database = database;
        this.load();
        this.initialize();
    }

    private void initialize() {
        this.setSize(500, 300);
        this.setTitle(LanguageTranslator.getString("export.vehicle.title"));
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 0.0;
            gridBagConstraints1.insets = new Insets(5, 5, 5, 0);
            gridBagConstraints1.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.insets = new Insets(0, 5, 5, 0);
            gridBagConstraints3.weightx = 0.0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.gridheight = 2;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints2.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJspListe(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getPnlDetail(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getCbAgence(), gridBagConstraints1);
        }
        return this.jContentPane;
    }

    private JList getListeVehicule() {
        if (this.listeVehicule == null) {
            this.listeVehicule = new JList();
        }
        return this.listeVehicule;
    }

    private JComboBox getCbAgence() {
        if (this.cbAgence == null) {
            this.cbAgence = new JComboBox();
            this.cbAgence.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DialogExportVehicule.this.reloadListe();
                }
            });
        }
        return this.cbAgence;
    }

    private JPanel getPnlDetail() {
        if (this.pnlDetail == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 2;
            gridBagConstraints11.gridwidth = 2;
            gridBagConstraints11.gridy = 1;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.gridwidth = 2;
            gridBagConstraints9.gridy = 2;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 2;
            gridBagConstraints8.gridwidth = 2;
            gridBagConstraints8.gridy = 2;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridwidth = 2;
            gridBagConstraints7.gridy = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 0;
            this.lblDebut = new JLabel();
            this.lblDebut.setText(LanguageTranslator.getString("generics.begin"));
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.gridy = 0;
            this.lblFin = new JLabel();
            this.lblFin.setText(LanguageTranslator.getString("generics.end"));
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 3;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridx = 3;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            this.pnlDetail = new JPanel();
            this.pnlDetail.setLayout(new GridBagLayout());
            this.pnlDetail.add((Component)this.getTxtDebut(), gridBagConstraints);
            this.pnlDetail.add((Component)this.getTxtFin(), gridBagConstraints4);
            this.pnlDetail.add((Component)this.lblFin, gridBagConstraints5);
            this.pnlDetail.add((Component)this.lblDebut, gridBagConstraints6);
            this.pnlDetail.add((Component)this.getCbSuppression(), gridBagConstraints7);
            this.pnlDetail.add((Component)this.getBtnEnvoyer(), gridBagConstraints8);
            this.pnlDetail.add((Component)this.getBtnQuitter(), gridBagConstraints9);
            this.pnlDetail.add((Component)this.getCbArchive(), gridBagConstraints11);
        }
        return this.pnlDetail;
    }

    private JScrollPane getJspListe() {
        if (this.jspListe == null) {
            this.jspListe = new JScrollPane();
            this.jspListe.setPreferredSize(new Dimension(150, 0));
            this.jspListe.setViewportView(this.getListeVehicule());
        }
        return this.jspListe;
    }

    private JTextField getTxtDebut() {
        if (this.txtDebut == null) {
            this.txtDebut = new JTextField();
            this.txtDebut.setPreferredSize(new Dimension(60, 20));
            this.txtDebut.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogExportVehicule.this.getTxtDebut());
                }
            });
        }
        return this.txtDebut;
    }

    private JTextField getTxtFin() {
        if (this.txtFin == null) {
            this.txtFin = new JTextField();
            this.txtFin.setPreferredSize(new Dimension(60, 20));
            this.txtFin.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogExportVehicule.this.getTxtFin());
                }
            });
        }
        return this.txtFin;
    }

    private JCheckBox getCbSuppression() {
        if (this.cbSuppression == null) {
            this.cbSuppression = new JCheckBox();
            this.cbSuppression.setText(LanguageTranslator.getString("export.delete"));
        }
        return this.cbSuppression;
    }

    private JButton getBtnEnvoyer() {
        if (this.btnEnvoyer == null) {
            this.btnEnvoyer = new JButton();
            this.btnEnvoyer.setText(LanguageTranslator.getString("button.export"));
            this.btnEnvoyer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Transport.ps.startOperation();
                    DialogExportVehicule.this.runExport();
                    Transport.ps.endOperation(PerformanceScanner.READING, "vehicle export");
                }
            });
        }
        return this.btnEnvoyer;
    }

    public void runExport() {
        VehicleExport tmp = new VehicleExport(this.database);
        Date debut = this.getTxtDebut().getText().equals("") ? null : ConversionTime.stringToDate(this.getTxtDebut().getText(), "dd/MM/yyyy");
        Date fin = this.getTxtFin().getText().equals("") ? null : ConversionTime.stringToDate(this.getTxtFin().getText(), "dd/MM/yyyy");
        Vector<Vehicule> tmpV = ((LMVehicle)this.getListeVehicule().getModel()).get(this.getListeVehicule().getSelectedIndices());
        tmp.setParameters(tmpV, debut, fin, this.getCbSuppression().isSelected(), this.getCbArchive().isSelected());
        tmp.run();
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogExportVehicule.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private void load() {
        ComboBoxModel tmp = new ComboBoxModel(Agence.getList(), false, LanguageTranslator.getString("generics.all"));
        this.getCbAgence().setModel(tmp);
        LMVehicle mlv = new LMVehicle(Vehicule.loadList(tmp.getSelectedCle()));
        this.getListeVehicule().setModel(mlv);
    }

    private void reloadListe() {
        int selectedCle = ((ComboBoxModel)this.getCbAgence().getModel()).getSelectedCle();
        ((LMVehicle)this.getListeVehicule().getModel()).setVector(Vehicule.loadList(selectedCle));
    }

    private JCheckBox getCbArchive() {
        if (this.cbArchive == null) {
            this.cbArchive = new JCheckBox();
            this.cbArchive.setText(LanguageTranslator.getString("export.archive"));
        }
        return this.cbArchive;
    }
}

