/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.region;

import fr.pgh.component.JTextDate;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.FuelConsumption;
import fr.pgh.data.bdd.Pays;
import fr.pgh.data.bdd.Region;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import transpo.system.LicenceManager;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.Fmresources;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class PnlRegion
extends ViewPanel
implements Observer {
    private JPanel pnlInfos = null;
    private JLabel lblName = null;
    private JTextField txtName = null;
    private JLabel lblCode = null;
    private JTextField txtCode = null;
    private JLabel lblCountry = null;
    private JComboBox cbCountry = null;
    private ChartPanel chartPanel = null;
    private JPanel pnlConso = null;
    private JFreeChart chartConso = null;
    private DefaultPieDataset dataset;
    private JButton btnPrevMonth = null;
    private JButton btnPrevYear = null;
    private JTextDate txtBegin = null;
    private JTextDate txtEnd = null;
    private JButton btnNextMonth = null;
    private JButton btnNextYear = null;
    private JButton btnUpdate = null;
    private static final Fmresources res = new Fmresources();
    ClassLoader cl = this.getClass().getClassLoader();

    @Override
    public String getViewName() {
        return LanguageTranslator.getString("generics.information");
    }

    @Override
    public void refresh() {
    }

    @Override
    public String getMnemo() {
        return "";
    }

    @Override
    public void close() {
    }

    @Override
    public void update(Observable o, Object arg) {
        TimsLogger.verbose("#" + this.getClass() + ".update# a faire");
    }

    public PnlRegion() {
        LanguageTranslator.getInstance().addObserver(this);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getPnlInfos(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, -1, 18, null));
        if (LicenceManager.isModuleEnable(LicenceManager.MODULE_CONSUMPTION)) {
            this.add((Component)this.getPnlConso(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, -1, 18, null));
        }
    }

    private JPanel getPnlInfos() {
        if (this.pnlInfos == null) {
            this.pnlInfos = new JPanel();
            this.pnlInfos.setLayout(new GridBagLayout());
            GridBagConstraints l0c0 = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints l0c1 = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints l0c2 = Fonctions.getGridBagConstraints(2, 0, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints l0c3 = Fonctions.getGridBagConstraints(3, 0, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints l0c4 = Fonctions.getGridBagConstraints(4, 0, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints l0c5 = Fonctions.getGridBagConstraints(5, 0, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints l1c0 = Fonctions.getGridBagConstraints(0, 1, 1, 5, 1.0, 1.0, -1, -1, null);
            this.lblName = new JLabel(LanguageTranslator.getString("generics.name"));
            this.lblCode = new JLabel(LanguageTranslator.getString("generics.code"));
            this.lblCountry = new JLabel(LanguageTranslator.getString("generics.country"));
            this.pnlInfos.add((Component)this.lblName, l0c0);
            this.pnlInfos.add((Component)this.getTxtName(), l0c1);
            this.pnlInfos.add((Component)this.lblCode, l0c2);
            this.pnlInfos.add((Component)this.getTxtCode(), l0c3);
            this.pnlInfos.add((Component)this.lblCountry, l0c4);
            this.pnlInfos.add((Component)this.getCbCountry(), l0c5);
            if (ConnexionSettings.getInstance().isConsultable("CONSOMMATION") && LicenceManager.isModuleEnable(LicenceManager.MODULE_CONSUMPTION)) {
                this.pnlInfos.add((Component)this.getPnlConso(), l1c0);
            }
        }
        return this.pnlInfos;
    }

    private JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
            this.txtName.setPreferredSize(new Dimension(200, 25));
        }
        return this.txtName;
    }

    private JTextField getTxtCode() {
        if (this.txtCode == null) {
            this.txtCode = new JTextField();
            this.txtName.setPreferredSize(new Dimension(80, 25));
        }
        return this.txtCode;
    }

    private JComboBox getCbCountry() {
        if (this.cbCountry == null) {
            this.cbCountry = new JComboBox();
            this.cbCountry.setModel(new ComboBoxModel(Pays.getVector(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbCountry;
    }

    private JPanel getPnlConso() {
        if (this.pnlConso == null) {
            this.pnlConso = new JPanel();
            this.pnlConso.setLayout(new GridBagLayout());
            GridBagConstraints l0c0 = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints l0c1 = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints l0c2 = Fonctions.getGridBagConstraints(2, 0, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints l0c3 = Fonctions.getGridBagConstraints(3, 0, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints l0c4 = Fonctions.getGridBagConstraints(4, 0, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints l0c5 = Fonctions.getGridBagConstraints(5, 0, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints l1c0 = Fonctions.getGridBagConstraints(0, 1, 1, 6, 1.0, 1.0, -1, -1, null);
            this.pnlConso.add((Component)this.getBtnPrevMonth(), l0c0);
            this.pnlConso.add((Component)this.getTxtBegin(), l0c1);
            this.pnlConso.add((Component)this.getTxtEnd(), l0c2);
            this.pnlConso.add((Component)this.getBtnNextMonth(), l0c3);
            this.pnlConso.add((Component)this.getChartPanel(), l0c4);
            this.pnlConso.add((Component)this.getBtnUpdate(), l0c5);
            this.pnlConso.add((Component)this.getChartPanel(), l1c0);
        }
        return this.pnlConso;
    }

    private JPanel getChartPanel() {
        if (this.chartPanel == null) {
            this.chartPanel = new ChartPanel(this.getChartConso());
        }
        return this.chartPanel;
    }

    private JFreeChart getChartConso() {
        if (this.chartConso == null) {
            this.chartConso = ChartFactory.createPieChart((String)LanguageTranslator.getString("fuel.consumption"), (PieDataset)this.getDataset(), (boolean)false, (boolean)true, (boolean)false);
            PiePlot plot = (PiePlot)this.chartConso.getPlot();
            plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} = {1} L/100km", NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance()));
        }
        return this.chartConso;
    }

    private DefaultPieDataset getDataset() {
        if (this.dataset == null) {
            this.dataset = new DefaultPieDataset();
        }
        return this.dataset;
    }

    public void loadRegion(Region current) {
        this.getTxtCode().setText(current.getCode());
        this.getTxtName().setText(current.getName());
        this.getCbCountry().setSelectedItem(((ComboBoxModel)this.getCbCountry().getModel()).getLabel(current.getCountryId()));
        this.load = false;
    }

    @Override
    public void loadData() {
        if (!this.load) {
            if (ConnexionSettings.getInstance().isConsultable("CONSOMMATION")) {
                this.reloadConso();
            }
            this.load = true;
        }
    }

    private void reloadConso() {
        this.getDataset().clear();
        Date day = this.getTxtEnd().getDate();
        Date old = this.getTxtBegin().getDate();
        for (FuelConsumption tmp : FuelConsumption.loadTotal(0, 0, 0, old, day, 0, 0)) {
            Agence agency = Agence.find(null, tmp.getAgencyId());
            String desc = agency == null ? LanguageTranslator.getString("generics.unknown") : agency.getDescription();
            TimsLogger.debug(String.valueOf(tmp.getConsumption()) + " for " + desc + " (" + tmp.getLiters() + " liters and " + tmp.getKm() + " km) ");
            this.getDataset().setValue((Comparable)((Object)(agency == null ? LanguageTranslator.getString("generics.unknown") : agency.getDescription())), (double)tmp.getConsumption());
        }
    }

    private JTextDate getTxtBegin() {
        if (this.txtBegin == null) {
            this.txtBegin = new JTextDate();
            this.txtBegin.setText(ConversionTime.getFirstDayOfMonth(new Date(), ConversionTime.STRING).toString());
            this.txtBegin.setMinimumSize(new Dimension(70, 20));
            this.txtBegin.setPreferredSize(new Dimension(80, 20));
        }
        return this.txtBegin;
    }

    private JTextDate getTxtEnd() {
        if (this.txtEnd == null) {
            this.txtEnd = new JTextDate();
            this.txtEnd.setText(ConversionTime.dateToString(new Date(), "dd/MM/yyyy"));
            this.txtEnd.setMinimumSize(new Dimension(70, 20));
            this.txtEnd.setPreferredSize(new Dimension(80, 20));
        }
        return this.txtEnd;
    }

    private JButton getBtnPrevMonth() {
        if (this.btnPrevMonth == null) {
            this.btnPrevMonth = new JButton();
            this.btnPrevMonth.setBorder(null);
            this.btnPrevMonth.setToolTipText(LanguageTranslator.getString("calendar.previousMonth"));
            this.btnPrevMonth.setBorderPainted(false);
            this.btnPrevMonth.setContentAreaFilled(false);
            this.btnPrevMonth.setFocusPainted(false);
            this.btnPrevMonth.setHorizontalTextPosition(0);
            this.btnPrevMonth.setIcon(this.getLeft());
            this.btnPrevMonth.setBounds(new Rectangle(1, 33, 25, 27));
            this.btnPrevMonth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlRegion.this.nextPeriod(-1);
                }
            });
        }
        return this.btnPrevMonth;
    }

    private JButton getBtnNextMonth() {
        if (this.btnNextMonth == null) {
            this.btnNextMonth = new JButton();
            this.btnNextMonth.setBorder(null);
            this.btnNextMonth.setToolTipText(LanguageTranslator.getString("calendar.nextMonth"));
            this.btnNextMonth.setBorderPainted(false);
            this.btnNextMonth.setContentAreaFilled(false);
            this.btnNextMonth.setFocusPainted(false);
            this.btnNextMonth.setHorizontalTextPosition(0);
            this.btnNextMonth.setIcon(this.getRight());
            this.btnNextMonth.setBounds(new Rectangle(151, 33, 25, 27));
            this.btnNextMonth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlRegion.this.nextPeriod(1);
                }
            });
        }
        return this.btnNextMonth;
    }

    private JButton getBtnUpdate() {
        if (this.btnUpdate == null) {
            this.btnUpdate = new JButton();
            this.btnUpdate.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_refresh"))));
            this.btnUpdate.setPreferredSize(new Dimension(25, 25));
            this.btnUpdate.setToolTipText(LanguageTranslator.getString("button.update"));
            this.btnUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlRegion.this.reloadConso();
                }
            });
        }
        return this.btnUpdate;
    }

    private ImageIcon getRight() {
        return new ImageIcon(this.cl.getResource(res.getResourceString("icone_right")));
    }

    private ImageIcon getLeft() {
        return new ImageIcon(this.cl.getResource(res.getResourceString("icone_left")));
    }

    private void nextPeriod(int i) {
        Date day = this.getTxtEnd().getDate();
        Date old = this.getTxtBegin().getDate();
        if (i < 0) {
            Date prev = ConversionTime.add(old, 5, -1);
            int nbDay = ConversionTime.getDaysBetween(old, day);
            this.getTxtEnd().setDate(prev);
            if (27 < nbDay && nbDay < 32) {
                this.getTxtBegin().setDate((Date)ConversionTime.getFirstDayOfMonth(prev, ConversionTime.DATE));
            } else {
                this.getTxtBegin().setDate(ConversionTime.add(prev, 5, nbDay));
            }
        } else {
            Date next = ConversionTime.add(day, 5, 1);
            int nbDay = ConversionTime.getDaysBetween(old, day);
            this.getTxtBegin().setDate(next);
            if (27 < nbDay && nbDay < 32) {
                this.getTxtEnd().setDate((Date)ConversionTime.getLastDayOfMonth(next, ConversionTime.DATE));
            } else {
                this.getTxtEnd().setDate(ConversionTime.add(next, 5, -nbDay));
            }
        }
    }
}

