/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.scan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class DialogDiscSelect
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    public boolean valider = false;
    private JCheckBox btn1 = null;
    private JCheckBox btn2 = null;
    private JCheckBox btn3 = null;
    private JCheckBox btn4 = null;
    private JCheckBox btn5 = null;
    private JCheckBox btn6 = null;
    private JButton btnOk = null;
    private JButton btnAnnuler = null;
    private JPanel pnlSelection = null;
    private JPanel pnlBtn = null;

    public DialogDiscSelect(Dialog owner) {
        super(owner, LanguageTranslator.getString("scan.setWaiting"), true);
        this.initialize();
    }

    private void initialize() {
        this.setSize(260, 130);
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getPnlSelection(), "Center");
            this.jContentPane.add((Component)this.getPnlBtn(), "South");
        }
        return this.jContentPane;
    }

    private JCheckBox getBtn1() {
        if (this.btn1 == null) {
            this.btn1 = new JCheckBox(LanguageTranslator.getString("scan.plot.number", "1"));
        }
        return this.btn1;
    }

    private JCheckBox getBtn2() {
        if (this.btn2 == null) {
            this.btn2 = new JCheckBox(LanguageTranslator.getString("scan.plot.number", "2"));
        }
        return this.btn2;
    }

    private JCheckBox getBtn3() {
        if (this.btn3 == null) {
            this.btn3 = new JCheckBox(LanguageTranslator.getString("scan.plot.number", "3"));
        }
        return this.btn3;
    }

    private JCheckBox getBtn5() {
        if (this.btn5 == null) {
            this.btn5 = new JCheckBox(LanguageTranslator.getString("scan.plot.number", "5"));
        }
        return this.btn5;
    }

    private JCheckBox getBtn6() {
        if (this.btn6 == null) {
            this.btn6 = new JCheckBox(LanguageTranslator.getString("scan.plot.number", "6"));
        }
        return this.btn6;
    }

    private JCheckBox getBtn4() {
        if (this.btn4 == null) {
            this.btn4 = new JCheckBox(LanguageTranslator.getString("scan.plot.number", "4"));
        }
        return this.btn4;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setText(LanguageTranslator.getString("button.valid"));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDiscSelect.this.valider = true;
                    DialogDiscSelect.this.dispose();
                }
            });
        }
        return this.btnOk;
    }

    private JButton getBtnAnnuler() {
        if (this.btnAnnuler == null) {
            this.btnAnnuler = new JButton();
            this.btnAnnuler.setText(LanguageTranslator.getString("button.quit"));
            this.btnAnnuler.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDiscSelect.this.valider = false;
                    DialogDiscSelect.this.dispose();
                }
            });
        }
        return this.btnAnnuler;
    }

    private JPanel getPnlSelection() {
        if (this.pnlSelection == null) {
            this.pnlSelection = new JPanel();
            GridLayout gridLayout = new GridLayout();
            gridLayout.setColumns(3);
            gridLayout.setRows(2);
            this.pnlSelection.setLayout(gridLayout);
            this.pnlSelection.add((Component)this.getBtn1(), null);
            this.pnlSelection.add((Component)this.getBtn2(), null);
            this.pnlSelection.add((Component)this.getBtn3(), null);
            if (System.getProperty("scan.speed", "0").equals("0")) {
                this.pnlSelection.add((Component)this.getBtn4(), null);
                this.pnlSelection.add((Component)this.getBtn5(), null);
                this.pnlSelection.add((Component)this.getBtn6(), null);
            }
        }
        return this.pnlSelection;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add(this.getBtnOk());
            this.pnlBtn.add(this.getBtnAnnuler());
        }
        return this.pnlBtn;
    }

    public boolean isSelected(int disc) {
        switch (disc) {
            case 0: {
                return this.getBtn1().isSelected();
            }
            case 1: {
                return this.getBtn2().isSelected();
            }
            case 2: {
                return this.getBtn3().isSelected();
            }
            case 3: {
                return this.getBtn4().isSelected();
            }
            case 4: {
                return this.getBtn5().isSelected();
            }
            case 5: {
                return this.getBtn6().isSelected();
            }
        }
        return false;
    }

    public void setSelected(int disc) {
        switch (disc) {
            case 0: {
                this.getBtn1().setSelected(true);
                break;
            }
            case 1: {
                this.getBtn2().setSelected(true);
                break;
            }
            case 2: {
                this.getBtn3().setSelected(true);
                break;
            }
            case 3: {
                this.getBtn4().setSelected(true);
                break;
            }
            case 4: {
                this.getBtn5().setSelected(true);
                break;
            }
            case 5: {
                this.getBtn6().setSelected(true);
            }
        }
    }
}

