/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.scan;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.ChangementActivite;
import fr.pgh.data.bdd.Comment;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.ExpensesValidation;
import fr.pgh.data.bdd.Jour;
import fr.pgh.data.bdd.JourUEV;
import fr.pgh.data.bdd.ScanPicture;
import fr.pgh.data.bdd.UevOffence;
import fr.pgh.data.bdd.UevSpeed;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.data.bdd.WaitingFile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import transpo.system.LicenceManager;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.jtwain.JTwain;
import transpo.system.jtwain.JTwainException;
import transpo.system.traitement.TraitementTempsService;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transpo.system.ui.views.conducteur.DialogComment;
import transpo.system.ui.views.conducteur.PnlFraisConducteur;
import transpo.system.ui.views.conducteur.PnlVehiculeConducteur;
import transpo.system.ui.views.layout.TableLayout;
import transpo.system.ui.views.scan.Analyse;
import transpo.system.ui.views.scan.DialogCalibration;
import transpo.system.ui.views.scan.DialogDetailJour;
import transpo.system.ui.views.scan.DialogDiscSelect;
import transpo.system.ui.views.scan.DialogShowExistingActivity;
import transpo.system.ui.views.scan.DialogWaitingScan;
import transpo.system.ui.views.scan.DiscInformation;
import transpo.system.ui.views.scan.PnlActivite;
import transpo.system.ui.views.scan.ScrollableImagePane;
import transpo.system.ui.views.scan.SelectSource;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;
import transpo.system.util.GestionChevauchement;
import transpo.ui.calendrier.JCalendrier;

public class DialogScan
extends JDialog {
    private static final long serialVersionUID = 1L;
    boolean speedEnabled = System.getProperty("scan.speed", "0").equals("1");
    public Preferences prefs = Preferences.userRoot().node("TIMS");
    private int companyId = 0;
    public static final int OPTIMIZED_WIDTH = 1268;
    public static final int OPTIMIZED_HEIGHT = 1735;
    public static final int OPTIMIZED_SPEED_CIRCLE_SIZE = 640;
    public static final int OPTIMIZED_ACTIVITY_CIRCLE_SIZE = 475;
    public static final int OPTIMIZED_IMAGE_SIZE = System.getProperty("scan.speed", "0").equals("1") ? 725 : 510;
    public static final int OPTIMIZED_COMP_SIZE = OPTIMIZED_IMAGE_SIZE + 15;
    public int activDisc = 0;
    public Vector<ExpensesType> listeTypeFrais = null;
    public DiscInformation[] detail = new DiscInformation[6];
    private static DialogScan appli = null;
    private int[][] posSlid = null;
    private int[] adjust = null;
    private int[] speedAdjust = null;
    private Vector<WaitingFile> waiting = null;
    private File loadedImage = null;
    private Vector<Vehicule> currentVehiclelist = null;
    private boolean processOnExistingDay = false;
    protected BddTransport bddEco = null;
    private DialogDetailJour infosJour = null;
    private ComboBoxModel modeleAgence = null;
    private ComboBoxModel[] modeleConducteur = new ComboBoxModel[6];
    private JTabbedPane category = null;
    private JPanel pnlPpl = new JPanel();
    private JScrollPane jspPpl = new JScrollPane();
    private JPanel pnlDroite = new JPanel();
    private JPanel pnlGauche = new JPanel();
    private JPanel pnlSlider;
    private JPanel pnlAdjX;
    private JPanel pnlAdjY;
    private JScrollPane imageScrollPane;
    private JPanel pnlDetailPlot = new JPanel();
    private JPanel pnlListePlot = new JPanel();
    private JPanel pnlChoixActivite = null;
    private JPanel pnlComment = null;
    private JTextArea txtComment = null;
    private JCheckBox cbComment = null;
    private JPanel pnlTotal = null;
    private JPanel pnlBtn = null;
    private JPanel pnlLibelle = null;
    private JPanel panelOptionScan = null;
    private PnlVehiculeConducteur pnlVehiculeConducteur = null;
    private PnlFraisConducteur pnlFraisConducteur = null;
    public ScrollableImagePane image = null;
    private JLabel XYPos = new JLabel("(X, Y)");
    private JSlider adjX = null;
    private JSlider adjY = null;
    private JSlider sliderAjustement = null;
    private JSlider sliderSpeedAdjust = null;
    private ChangeListener listener;
    private ChangeListener parametersListener;
    private JComboBox cbAgence = null;
    private ButtonGroup bgPlot = new ButtonGroup();
    private JRadioButton[] plot = new JRadioButton[6];
    private JPanel[] pnlDisque = new JPanel[6];
    private JTextField[] txtDebut = new JTextField[6];
    private JTextField[] txtFin = new JTextField[6];
    private JComboBox[] cbConducteur = new JComboBox[6];
    private JComboBox[] cbVehicles = new JComboBox[6];
    private JTextField[] txtCodeCond = new JTextField[6];
    private JTextField[] dateAnalyse = new JTextField[6];
    private JTextField[] kmRapide = new JTextField[6];
    private JLabel lblTpsTotal = new JLabel("00h00");
    private ButtonGroup bgActivite = new ButtonGroup();
    private PnlActivite[] pnlActivite = new PnlActivite[6];
    private ButtonGroup uiSELECT = new ButtonGroup();
    protected JRadioButton uiON = new JRadioButton(LanguageTranslator.getString("scan.withInterface"));
    protected JRadioButton uiOFF = new JRadioButton(LanguageTranslator.getString("scan.withoutInterface"));
    private JButton btnQuitter = new JButton(LanguageTranslator.getString("button.quit"));
    private JButton btnSave = new JButton(LanguageTranslator.getString("button.save"));
    private JButton btnEffacer = new JButton(LanguageTranslator.getString("button.erase"));
    private JButton btnImage = new JButton(LanguageTranslator.getString("scan.image"));
    private JButton btnAnalyser = new JButton(LanguageTranslator.getString("scan.analyse"));
    private JButton btn6Disque = new JButton(LanguageTranslator.getString("scan.6disc"));
    private JButton btnScan = new JButton(LanguageTranslator.getString("scan.scan"));
    private JButton btnCalibration = new JButton(LanguageTranslator.getString("scan.calibrate"));
    private JButton btnSetWait = new JButton(LanguageTranslator.getString("scan.setWaiting"));
    private JButton btnGetWait = new JButton(LanguageTranslator.getString("scan.getWaiting"));
    private LoadCode alCond = new LoadCode(1);
    private VehicleListener alVehicle = new VehicleListener(1);
    private JPanel pnlZoom;
    private ButtonGroup bgZoom = new ButtonGroup();
    protected JRadioButton rbZNW = null;
    protected JRadioButton rbZNE = null;
    protected JRadioButton rbZSW = null;
    protected JRadioButton rbZSE = null;
    protected JRadioButton rbNoZoom = null;
    PnlVehiculeConducteur.KmListener kmListener = new PnlVehiculeConducteur.KmListener(){

        @Override
        public void kmChanged(int newKm) {
            DialogScan.this.getKmRapide(DialogScan.this.activDisc).setText(String.valueOf(newKm));
        }
    };

    public static DialogScan getInstance() {
        if (appli == null || DialogScan.appli.companyId != DialogScan.appli.bddEco.getCompany().getCleSociete()) {
            appli = new DialogScan(MainFrameTransport.getInstance(), Transport.bdd);
            DialogScan.appli.companyId = DialogScan.appli.bddEco.getCompany().getCleSociete();
        }
        return appli;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public DialogScan(JFrame f, BddTransport bdd) throws HeadlessException {
        super(f);
        try {
            this.jbInit(bdd);
            TimsSession.getInstance().addVisit(this.getClass().getName());
        }
        catch (JTwainException ex) {
            TimsLogger.error("exception dans DialogScan : " + ex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean loadLibrary() {
        return JTwain.init();
    }

    private void jbInit(BddTransport bdd) throws Exception {
        this.bddEco = bdd;
        new Analyse(this.bddEco);
        this.loadPosition();
        this.setModal(true);
        this.setTitle(LanguageTranslator.getString("scan.scan"));
        this.pnlPpl.setLayout(new BorderLayout());
        this.pnlDetailPlot.setBorder(BorderFactory.createTitledBorder(LanguageTranslator.getString("generics.detail")));
        this.jspPpl.getViewport().add((Component)this.pnlPpl, null);
        this.pnlPpl.add((Component)this.pnlDroite, "East");
        this.pnlPpl.add((Component)this.pnlGauche, "Center");
        this.pnlPpl.add((Component)this.getPnlBtn(), "South");
        this.pnlDetailPlot.setLayout(new BorderLayout());
        this.pnlListePlot.setLayout(new GridLayout(0, 1));
        this.pnlListePlot.add((Component)this.getPnlLibelle(), null);
        int x = 0;
        while (x < 6) {
            this.getPnlDisque(x).add(this.getPlot(x));
            this.getPnlDisque(x).add(this.getDateAnalyse(x));
            this.getPnlDisque(x).add(this.getCbConducteur(x));
            this.getPnlDisque(x).add(this.getTxtCode(x));
            this.getPnlDisque(x).add(this.getCbVehicles(x));
            this.getPnlDisque(x).add(this.getTxtDebut(x));
            this.getPnlDisque(x).add(this.getTxtFin(x));
            this.getPnlDisque(x).add(this.getKmRapide(x));
            if (this.speedEnabled && x >= 3) {
                this.getPlot(x).setEnabled(false);
                this.getDateAnalyse(x).setEnabled(false);
                this.getCbConducteur(x).setEnabled(false);
                this.getCbVehicles(x).setEnabled(false);
                this.getTxtCode(x).setEnabled(false);
                this.getTxtDebut(x).setEnabled(false);
                this.getTxtFin(x).setEnabled(false);
                this.getKmRapide(x).setEnabled(false);
            }
            this.pnlListePlot.add((Component)this.getPnlDisque(x), null);
            ++x;
        }
        this.pnlDetailPlot.add((Component)this.getCbAgence(), "North");
        this.pnlDetailPlot.add((Component)this.pnlListePlot, "Center");
        this.pnlDroite.setLayout(new BorderLayout());
        this.pnlDroite.add((Component)this.pnlDetailPlot, "North");
        this.pnlDroite.add((Component)this.getOngletCategory(), "Center");
        this.pnlDroite.add((Component)this.getPnlOptionScan(), "South");
        this.pnlGauche.setLayout(new BorderLayout());
        this.listener = new SliderListener(this.XYPos);
        this.parametersListener = new ParametersSliderListener();
        this.pnlGauche.add((Component)this.XYPos, "South");
        this.pnlGauche.add((Component)this.getImageScrollPane(), "Center");
        this.pnlGauche.add((Component)this.getPnlAdjX(), "North");
        this.pnlGauche.add((Component)this.getPnlAdjY(), "West");
        this.pnlGauche.add((Component)this.getPnlSlider(), "East");
        this.btnAnalyser.setEnabled(false);
        this.btn6Disque.setEnabled(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jspPpl, "Center");
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogScan.this.save()) {
                    DialogScan.this.dispose();
                }
            }
        });
        this.btnEffacer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogScan.this.initDisque(false);
                DialogScan.this.getCbConducteur(DialogScan.this.activDisc).setEnabled(true);
                DialogScan.this.getCbVehicles(DialogScan.this.activDisc).setEnabled(true);
                DialogScan.this.btnAnalyser.setEnabled(true);
                DialogScan.this.btn6Disque.setEnabled(true);
            }
        });
        this.btnQuitter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogScan.this.quitter();
            }
        });
        this.btnImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogScan.this.autoSave();
                DialogScan.this.initDisque(true);
                try {
                    Image[] tmp = DialogScan.this.getFile();
                    if (tmp.length == 1) {
                        DialogScan.this.loadImage(tmp[0]);
                    } else {
                        DialogScan.this.loadImages(tmp);
                    }
                }
                catch (Exception ex) {
                    TimsLogger.warn("transpo.system.ui.views.scan.ScanProcess.actionPerformed()  : " + ex);
                }
            }
        });
        this.btnAnalyser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogScan.this.analyse();
            }
        });
        this.btn6Disque.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogScan.this.multiDiscAnalysis();
            }
        });
        this.btnScan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogScan.this.autoSave();
                DialogScan.this.initDisque(true);
                try {
                    DialogScan.this.loadImage(DialogScan.this.scanProcess());
                }
                catch (Exception ex) {
                    TimsLogger.warn("transpo.system.ui.views.scan.ScanProcess.actionPerformed()  : " + ex);
                }
            }
        });
        this.btnCalibration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogScan.this.autoSave();
                DialogScan.this.doCalibration(Transport.debug >= 1 ? DialogScan.this.getFile()[0] : DialogScan.this.scanProcess());
            }
        });
        this.btnSetWait.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogScan.this.setWaitingDisque();
            }
        });
        this.btnGetWait.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogScan.this.autoSave();
                DialogScan.this.initDisque(true);
                DialogScan.this.getWaitingDisque();
            }
        });
        this.btnEffacer.setEnabled(false);
        this.btnSave.setEnabled(false);
        this.pack();
        this.setLocation(0, 0);
    }

    private JPanel getPnlZoom() {
        if (this.pnlZoom == null) {
            this.pnlZoom = new JPanel();
            this.pnlZoom.setLayout(new GridBagLayout());
            this.pnlZoom.setBorder(BorderFactory.createTitledBorder(LanguageTranslator.getString("scan.zoom")));
            this.rbZNW = new JRadioButton("");
            this.rbZNE = new JRadioButton("");
            this.rbZSW = new JRadioButton("");
            this.rbZSE = new JRadioButton("");
            this.rbNoZoom = new JRadioButton("");
            this.rbZNW.addItemListener(new ZoomListener(18));
            this.rbZNE.addItemListener(new ZoomListener(12));
            this.rbZSW.addItemListener(new ZoomListener(16));
            this.rbZSE.addItemListener(new ZoomListener(14));
            this.rbNoZoom.addItemListener(new ZoomListener(10));
            this.bgZoom.add(this.rbZNW);
            this.bgZoom.add(this.rbZNE);
            this.bgZoom.add(this.rbZSW);
            this.bgZoom.add(this.rbZSE);
            this.bgZoom.add(this.rbNoZoom);
            GridBagConstraints nw = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, -1, 10, null);
            this.pnlZoom.add((Component)this.rbZNW, nw);
            GridBagConstraints ne = Fonctions.getGridBagConstraints(2, 0, 1, 1, 1.0, 1.0, -1, 10, null);
            this.pnlZoom.add((Component)this.rbZNE, ne);
            GridBagConstraints center = Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, -1, 10, null);
            this.pnlZoom.add((Component)this.rbNoZoom, center);
            GridBagConstraints sw = Fonctions.getGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, -1, 10, null);
            this.pnlZoom.add((Component)this.rbZSW, sw);
            GridBagConstraints se = Fonctions.getGridBagConstraints(2, 2, 1, 1, 1.0, 1.0, -1, 10, null);
            this.pnlZoom.add((Component)this.rbZSE, se);
        }
        return this.pnlZoom;
    }

    private void multiDiscAnalysis() {
        int option;
        boolean missingDate = false;
        int i = 0;
        while (i < 6) {
            if (this.getDateAnalyse(i).getText().equals("") && this.getDetail(i).getAssociatedImage() != null) {
                missingDate = true;
                break;
            }
            ++i;
        }
        if (missingDate && (option = JOptionPane.showConfirmDialog(this, "Certains plot n'ont pas de date saisies, voulez vous continuer ? (si vous continuez, les plots n'ayant pas de date seront ignor\u00e9s", "Demande de confirmation", 0, 2)) == 1) {
            return;
        }
        i = 0;
        while (i < 6) {
            if (!this.getDateAnalyse(i).getText().equals("")) {
                this.getPlot(i).setSelected(true);
                this.setSliderPosition();
                this.analyse();
            }
            ++i;
        }
        this.getPlot(0).setSelected(true);
        this.setSliderPosition();
    }

    private JPanel getPnlOptionScan() {
        if (this.panelOptionScan == null) {
            this.panelOptionScan = new JPanel();
            this.panelOptionScan.setBorder(BorderFactory.createTitledBorder(LanguageTranslator.getString("scan.option")));
            this.uiSELECT.add(this.uiON);
            this.uiSELECT.add(this.uiOFF);
            this.panelOptionScan.add(this.uiON);
            this.panelOptionScan.add(this.uiOFF);
            this.uiON.setSelected(true);
        }
        return this.panelOptionScan;
    }

    private JComboBox getCbConducteur(int x) {
        if (this.cbConducteur[x] == null) {
            this.cbConducteur[x] = new JComboBox();
            this.cbConducteur[x].setEnabled(false);
            this.cbConducteur[x].setPreferredSize(new Dimension(140, 23));
        }
        return this.cbConducteur[x];
    }

    private JComboBox getCbVehicles(int x) {
        if (this.cbVehicles[x] == null) {
            this.cbVehicles[x] = new JComboBox();
            this.cbVehicles[x].setEnabled(false);
            this.cbVehicles[x].setPreferredSize(new Dimension(140, 23));
            this.cbVehicles[x].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
        }
        return this.cbVehicles[x];
    }

    private JTextField getDateAnalyse(int x) {
        if (this.dateAnalyse[x] == null) {
            this.dateAnalyse[x] = new JTextField();
            this.dateAnalyse[x].addMouseListener(new MouseClickedDate(x));
            this.dateAnalyse[x].setPreferredSize(new Dimension(70, 23));
            this.dateAnalyse[x].setEnabled(false);
        }
        return this.dateAnalyse[x];
    }

    private JTextField getTxtCode(int x) {
        if (this.txtCodeCond[x] == null) {
            this.txtCodeCond[x] = new JTextField();
            this.txtCodeCond[x].setPreferredSize(new Dimension(38, 23));
        }
        return this.txtCodeCond[x];
    }

    private JTextField getKmRapide(int x) {
        if (this.kmRapide[x] == null) {
            this.kmRapide[x] = new JTextField();
            this.kmRapide[x].setPreferredSize(new Dimension(35, 23));
            this.kmRapide[x].addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent f) {
                    if (!((JTextField)f.getComponent()).getText().matches("[0-9]*")) {
                        JOptionPane.showMessageDialog(null, LanguageTranslator.getString("message.inputError"), LanguageTranslator.getString("generics.error"), 0);
                        ((JTextField)f.getComponent()).setText("");
                    }
                }
            });
        }
        return this.kmRapide[x];
    }

    private JTextField getTxtDebut(int x) {
        if (this.txtDebut[x] == null) {
            this.txtDebut[x] = new JTextField();
            this.txtDebut[x].setPreferredSize(new Dimension(40, 23));
        }
        return this.txtDebut[x];
    }

    private JTextField getTxtFin(int x) {
        if (this.txtFin[x] == null) {
            this.txtFin[x] = new JTextField();
            this.txtFin[x].setPreferredSize(new Dimension(40, 23));
        }
        return this.txtFin[x];
    }

    private JPanel getPnlDisque(int x) {
        if (this.pnlDisque[x] == null) {
            this.pnlDisque[x] = new JPanel();
        }
        return this.pnlDisque[x];
    }

    private JRadioButton getPlot(int x) {
        if (this.plot[x] == null) {
            this.plot[x] = new JRadioButton();
            this.plot[x].addItemListener(new ChangementDisque(x));
            this.bgPlot.add(this.plot[x]);
            this.plot[x].setPreferredSize(new Dimension(35, 23));
            this.plot[x].setText(String.valueOf(x + 1));
        }
        return this.plot[x];
    }

    private DiscInformation getDetail(int x) {
        if (this.detail[x] == null) {
            this.detail[x] = new DiscInformation();
        }
        return this.detail[x];
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add((Component)this.btnCalibration, null);
            this.pnlBtn.add((Component)this.btnScan, null);
            this.pnlBtn.add((Component)this.btnImage, null);
            if (ConnexionSettings.getInstance().isAjoutable("SCAN")) {
                this.pnlBtn.add((Component)this.btnAnalyser, null);
                this.pnlBtn.add((Component)this.btn6Disque, null);
                this.pnlBtn.add((Component)this.btnEffacer, null);
            }
            this.pnlBtn.add((Component)this.btnSave, null);
            this.pnlBtn.add((Component)this.btnSetWait, null);
            if (ConnexionSettings.getInstance().isAjoutable("SCAN")) {
                this.pnlBtn.add((Component)this.btnGetWait, null);
            }
            this.pnlBtn.add((Component)this.btnQuitter, null);
        }
        return this.pnlBtn;
    }

    private Conducteur getConducteurAtPlot(int x) {
        return (Conducteur)this.modeleConducteur[x].getObjectAt(this.cbConducteur[x].getSelectedIndex());
    }

    private Vehicule getVehicleAtPlot(int x) {
        return (Vehicule)((ComboBoxModel)this.getCbVehicles(x).getModel()).getSelectedItem();
    }

    private Vector<Conducteur> getDrivers() {
        Vector<Conducteur> drivers = new Vector<Conducteur>();
        int x = 0;
        while (x < 6) {
            if (this.getDetail(x).isAnalyzed() && !drivers.contains(this.getConducteurAtPlot(x))) {
                drivers.add(this.getConducteurAtPlot(x));
            }
            ++x;
        }
        return drivers;
    }

    private Image scanProcess() {
        Preferences prefs = Preferences.userRoot().node("TIMS");
        String defaultScan = prefs.get("preference.scanner", null);
        if (System.getProperty("preference.scanner") == null) {
            if (defaultScan != null) {
                System.setProperty("preference.scanner", defaultScan);
            } else {
                TimsLogger.debug("Aucun scanner par d\u00e9faut");
            }
        } else {
            TimsLogger.debug(System.getProperty("preference.scanner"));
        }
        Image im = null;
        Vector<String> srcNames = this.getSource();
        if (System.getProperty("preference.scanner") == null) {
            TimsLogger.debug("available src");
        }
        for (String src : srcNames) {
            if (System.getProperty("preference.scanner") != null) continue;
            TimsLogger.debug(src);
        }
        if (srcNames.size() == 0) {
            JOptionPane.showMessageDialog(null, LanguageTranslator.getString("scan.none"));
            return im;
        }
        if (srcNames.size() != 1 && (System.getProperty("preference.scanner") == null || srcNames.indexOf(System.getProperty("preference.scanner")) == -1)) {
            SelectSource ss = new SelectSource(MainFrameTransport.getInstance(), "", srcNames);
            ss.setVisible(true);
            if (ss.isCanceled()) {
                return im;
            }
            System.setProperty("preference.scanner", ss.getSrcName());
        } else if (System.getProperty("preference.scanner") == null) {
            System.setProperty("preference.scanner", srcNames.get(0));
        }
        String srcName = System.getProperty("preference.scanner");
        TimsLogger.info("Scanning with " + srcName);
        try {
            JTwain.openDSM();
            JTwain.openDS(srcName);
            if (this.uiOFF.isSelected()) {
                Image[] test2 = JTwain.preset(150);
                im = test2[0];
            } else {
                im = JTwain.acquireCfg();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("message.numberedError", e.getMessage()));
        }
        try {
            JTwain.closeDS();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            JTwain.closeDSM();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return im;
    }

    public void getWaitingDisque() {
        DialogWaitingScan tmp = new DialogWaitingScan(this);
        tmp.setVisible(true);
        if (tmp.isValid()) {
            this.initDisque(true);
            this.waiting = tmp.getSelected();
            this.loadWaitingFile(this.waiting);
        }
    }

    public void setWaitingDisque() {
        final DialogScan dialog = this;
        new Thread(){

            @Override
            public void run() {
                final DialogDiscSelect tmp = new DialogDiscSelect(dialog);
                int x = 0;
                while (x < 6) {
                    if (DialogScan.this.isDisc(DialogScan.this.getDetail(x).getAssociatedImage())) {
                        tmp.setSelected(x);
                    }
                    ++x;
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            tmp.setVisible(true);
                        }
                    });
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (tmp.valider) {
                    int max = 0;
                    int x2 = 0;
                    while (x2 < 6) {
                        if (tmp.isSelected(x2)) {
                            ++max;
                        }
                        ++x2;
                    }
                    ProgressBar pg = new ProgressBar(dialog, LanguageTranslator.getString("scan.upload"));
                    pg.setVisible(true);
                    pg.getBar().setMinimum(0);
                    pg.getBar().setMaximum(max);
                    int x3 = 0;
                    while (x3 < 6) {
                        if (tmp.isSelected(x3)) {
                            try {
                                pg.getBar().setValue(pg.getBar().getValue() + 1);
                                pg.getBar().setString(LanguageTranslator.getString("scan.uploading", String.valueOf(x3)));
                                DialogScan.this.moveToTemp(x3);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        ++x3;
                    }
                    pg.dispose();
                    JOptionPane.showMessageDialog(tmp, LanguageTranslator.getString("message.waitSucceed"), LanguageTranslator.getString("message.done"), 1);
                    DialogScan.this.initDisque(true);
                }
            }
        }.start();
    }

    public boolean moveToTemp(int x) {
        try {
            BufferedImage bufferedImageOut = new BufferedImage(this.getDetail(x).getAssociatedImage().getWidth(null), this.getDetail(x).getAssociatedImage().getHeight(null), 1);
            Graphics2D bufImageGraphics = bufferedImageOut.createGraphics();
            bufImageGraphics.drawImage(this.getDetail(x).getAssociatedImage(), 0, 0, null);
            String tmp = this.getCbAgence().getSelectedItem() + " - " + WaitingFile.getWaitingName();
            File file = new File(String.valueOf(Transport.savePath) + "\\" + tmp);
            FileOutputStream out = new FileOutputStream(file);
            ImageIO.write((RenderedImage)bufferedImageOut, "JPEG", out);
            out.close();
            TimsLogger.debug("#DilaogScan.moveToTemp# x = " + x + " , tmp = " + tmp);
            WaitingFile toAdd = new WaitingFile(0, ConnexionSettings.getInstance().getUserCle(), tmp);
            if (toAdd.insert()) {
                FileManager.moveTemporaryFile(file);
            }
            return true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public Vector<String> getSource() {
        Vector<String> srcNames = new Vector<String>();
        try {
            JTwain.openDSM();
            try {
                String srcName = JTwain.getFirstDS();
                if (srcName == null) {
                    JTwain.closeDSM();
                    return srcNames;
                }
                srcNames.add(srcName);
                while (!(srcName = JTwain.getNextDS()).equals("")) {
                    srcNames.add(srcName);
                }
            }
            catch (JTwainException ex) {
                TimsLogger.warn("can't open source" + ex);
            }
            JTwain.closeDSM();
        }
        catch (JTwainException ex) {
            TimsLogger.warn("can't open source" + ex);
        }
        TimsLogger.debug("#DS.getSource# available " + srcNames);
        return srcNames;
    }

    private void autoSave() {
        if (this.isOneAnalyzed() && JOptionPane.showConfirmDialog(this, LanguageTranslator.getString("scan.save"), this.getTitle(), 0, 3) == 0) {
            this.save();
        } else if (this.isOneLoaded() && JOptionPane.showConfirmDialog(this, LanguageTranslator.getString("scan.saveImg"), this.getTitle(), 0, 3) == 0) {
            this.setWaitingDisque();
        }
    }

    public boolean isOneAnalyzed() {
        int x = 0;
        while (x < 6) {
            if (this.getDetail(x).isAnalyzed()) {
                return true;
            }
            ++x;
        }
        return false;
    }

    public boolean isOneLoaded() {
        int x = 0;
        while (x < 6) {
            if (this.getDetail(x).getAssociatedImage() != null && this.waiting == null) {
                return true;
            }
            ++x;
        }
        return false;
    }

    public ChangementActivite getActivity(int cleType, int heure) {
        return new ChangementActivite(cleType, ConversionTime.stringToDate(this.getDateAnalyse(this.activDisc).getText(), "dd/MM/yyyy"), heure, "", "", "", "DISQUE", "");
    }

    public JTabbedPane getOngletCategory() {
        if (this.category == null) {
            this.category = new JTabbedPane();
            this.category.add(LanguageTranslator.getString("generics.activity"), this.getPnlActivite());
            this.category.add(LanguageTranslator.getString("generics.vehicle"), this.getPnlVehiculeConducteur());
            if (LicenceManager.isHRLevel()) {
                this.category.add(LanguageTranslator.getString("generics.expenses"), this.getPnlFraisConducteur());
            }
            this.category.add(LanguageTranslator.getString("generics.comment"), this.getPnlComment());
            this.category.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (DialogScan.this.category.getTitleAt(DialogScan.this.category.getSelectedIndex()).equals(LanguageTranslator.getString("generics.activity"))) {
                        DialogScan.this.getImage().setMode(ScrollableImagePane.MODE_ACTIVITE);
                    }
                    if (DialogScan.this.category.getTitleAt(DialogScan.this.category.getSelectedIndex()).equals(LanguageTranslator.getString("generics.vehicle"))) {
                        DialogScan.this.getImage().setMode(ScrollableImagePane.MODE_VEHICULE);
                    }
                }
            });
        }
        return this.category;
    }

    protected PnlVehiculeConducteur getPnlVehiculeConducteur() {
        if (this.pnlVehiculeConducteur == null) {
            this.pnlVehiculeConducteur = new PnlVehiculeConducteur();
            this.pnlVehiculeConducteur.setPreferredSize(new Dimension(450, 200));
            this.pnlVehiculeConducteur.getTableVehicule().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    VehicleUsed tmp = DialogScan.this.getPnlVehiculeConducteur().getSelectedVehicule();
                    DialogScan.this.getImage().setVehicule(tmp);
                }
            });
            this.pnlVehiculeConducteur.addKmListener(this.kmListener);
        }
        return this.pnlVehiculeConducteur;
    }

    private PnlFraisConducteur getPnlFraisConducteur() {
        if (this.pnlFraisConducteur == null) {
            this.pnlFraisConducteur = new PnlFraisConducteur();
            this.pnlFraisConducteur.setPreferredSize(new Dimension(450, 200));
        }
        return this.pnlFraisConducteur;
    }

    private JPanel getPnlComment() {
        if (this.pnlComment == null) {
            this.pnlComment = new JPanel();
            this.pnlComment.setLayout(new BorderLayout());
            this.pnlComment.add((Component)this.getTxtComment(), "Center");
            this.pnlComment.add((Component)this.getCbComment(), "South");
        }
        return this.pnlComment;
    }

    private JTextArea getTxtComment() {
        if (this.txtComment == null) {
            this.txtComment = new JTextArea();
            this.txtComment.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 3) {
                        DialogComment tmp = new DialogComment(DialogScan.this);
                        int nb = BddTransport.getInstance().getCommentCount(DialogScan.this.getConducteurAtPlot(DialogScan.this.activDisc).getCleConducteur(), ConversionTime.dateFromFranceToBDD(DialogScan.this.getDateAnalyse(DialogScan.this.activDisc).getText(), false), tmp.getSelected());
                        TimsLogger.debug("#DS.getTxtComment# nb comment (" + tmp.getSelected() + ")" + nb);
                        DialogScan.this.getTxtComment().setText(tmp.getSelected());
                    }
                }
            });
        }
        return this.txtComment;
    }

    private JCheckBox getCbComment() {
        if (this.cbComment == null) {
            this.cbComment = new JCheckBox("Mail");
        }
        return this.cbComment;
    }

    public JPanel getPnlActivite() {
        if (this.pnlChoixActivite == null) {
            this.pnlChoixActivite = new JPanel();
            this.pnlChoixActivite.setLayout(new GridLayout(0, 1));
            this.pnlChoixActivite.add((Component)this.getPnlActivite(0), null);
            this.pnlChoixActivite.add((Component)this.getPnlActivite(1), null);
            this.pnlChoixActivite.add((Component)this.getPnlActivite(2), null);
            this.pnlChoixActivite.add((Component)this.getPnlActivite(3), null);
            this.pnlChoixActivite.add((Component)this.getPnlActivite(4), null);
            this.pnlChoixActivite.add((Component)this.getPnlActivite(5), null);
            this.pnlChoixActivite.add((Component)this.getPnlTotal(), null);
        }
        return this.pnlChoixActivite;
    }

    public PnlActivite getPnlActivite(int x) {
        if (this.pnlActivite[x] == null) {
            String title = LanguageTranslator.getString("generics.none");
            Color color = Color.black;
            switch (x) {
                case 0: {
                    title = LanguageTranslator.getString("activity.rest");
                    color = Analyse.CouleurR;
                    break;
                }
                case 1: {
                    title = LanguageTranslator.getString("activity.availability");
                    color = Analyse.CouleurD;
                    break;
                }
                case 2: {
                    title = LanguageTranslator.getString("activity.work");
                    color = Analyse.CouleurT;
                    break;
                }
                case 3: {
                    title = LanguageTranslator.getString("activity.driving");
                    color = Analyse.CouleurC;
                    break;
                }
                case 4: {
                    title = LanguageTranslator.getString("activity.crew");
                    color = Analyse.CouleurDE;
                    break;
                }
                case 5: {
                    title = LanguageTranslator.getString("activity.other");
                    color = Analyse.CouleurAA;
                }
            }
            this.pnlActivite[x] = new PnlActivite(title, color);
            this.bgActivite.add(this.pnlActivite[x].getSelected());
        }
        return this.pnlActivite[x];
    }

    public JPanel getPnlTotal() {
        if (this.pnlTotal == null) {
            this.pnlTotal = new JPanel();
            this.pnlTotal.add(new JLabel(LanguageTranslator.getString("generics.total")));
            this.pnlTotal.add(this.lblTpsTotal);
        }
        return this.pnlTotal;
    }

    public DialogDetailJour getInfosJour() {
        if (this.infosJour == null) {
            this.infosJour = new DialogDetailJour(this);
        }
        return this.infosJour;
    }

    public JPanel getPnlLibelle() {
        if (this.pnlLibelle == null) {
            this.pnlLibelle = new JPanel();
            double p = -2.0;
            double[][] size = new double[][]{{p, p, p, p, p, p, p, p}, {-1.0}};
            this.pnlLibelle.setLayout(new TableLayout(size));
            JLabel lblPlot = new JLabel(LanguageTranslator.getString("scan.plot"));
            lblPlot.setPreferredSize(new Dimension(50, 23));
            JLabel date = new JLabel(LanguageTranslator.getString("generics.date"));
            date.setPreferredSize(new Dimension(70, 23));
            JLabel conducteur = new JLabel(LanguageTranslator.getString("generics.driver"));
            conducteur.setPreferredSize(new Dimension(150, 23));
            JLabel code = new JLabel(LanguageTranslator.getString("generics.code"));
            code.setPreferredSize(new Dimension(38, 23));
            JLabel vehicle = new JLabel(LanguageTranslator.getString("generics.vehicle"));
            vehicle.setPreferredSize(new Dimension(150, 23));
            JLabel km = new JLabel(LanguageTranslator.getString("generics.km.short"));
            km.setPreferredSize(new Dimension(35, 23));
            JLabel debut = new JLabel(LanguageTranslator.getString("generics.begin"));
            debut.setPreferredSize(new Dimension(45, 23));
            JLabel fin = new JLabel(LanguageTranslator.getString("generics.end"));
            fin.setPreferredSize(new Dimension(45, 23));
            this.getPnlLibelle().add((Component)lblPlot, "0, 0, R, C");
            this.getPnlLibelle().add((Component)date, "1, 0, R, C");
            this.getPnlLibelle().add((Component)conducteur, "2, 0, R, C");
            this.getPnlLibelle().add((Component)code, "3, 0, R, C");
            this.getPnlLibelle().add((Component)vehicle, "4, 0, R, C");
            this.getPnlLibelle().add((Component)debut, "5, 0, R, C");
            this.getPnlLibelle().add((Component)fin, "6, 0, R, C");
            this.getPnlLibelle().add((Component)km, "7, 0, R, C");
        }
        return this.pnlLibelle;
    }

    public JComboBox getCbAgence() {
        if (this.cbAgence == null) {
            this.cbAgence = new JComboBox();
            this.cbAgence.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DialogScan.this.updateDriverList();
                    if (System.getProperty("scan.vehicle.enlarge", "0").equals("0")) {
                        DialogScan.this.updateVehicleList();
                    }
                }
            });
        }
        return this.cbAgence;
    }

    private JScrollPane getImageScrollPane() {
        if (this.imageScrollPane == null) {
            this.imageScrollPane = new JScrollPane();
            this.imageScrollPane.setViewportView(this.getImage());
            this.imageScrollPane.updateUI();
            this.imageScrollPane.setPreferredSize(new Dimension(OPTIMIZED_COMP_SIZE, OPTIMIZED_COMP_SIZE));
        }
        return this.imageScrollPane;
    }

    private ScrollableImagePane getImage() {
        if (this.image == null) {
            this.image = new ScrollableImagePane(this);
        }
        return this.image;
    }

    public void setHeureDebut(int heureDebut) {
        this.getDetail(this.activDisc).setHeureDebut(heureDebut == 10000 ? 0 : heureDebut);
        if (heureDebut != 10000) {
            this.getTxtDebut(this.activDisc).setText(ConversionTime.heureIntToString(heureDebut, "h"));
        } else {
            this.getTxtDebut(this.activDisc).setText("");
        }
    }

    public void setHeureFin(boolean auto, int heureFin) {
        this.getDetail(this.activDisc).setHeureFin(heureFin == 10000 ? 1440 : heureFin);
        if (heureFin != 10000) {
            if (!auto) {
                this.getDetail(this.activDisc).setSetBeginEndByUser(true);
            }
            this.getTxtFin(this.activDisc).setText(ConversionTime.heureIntToString(heureFin, "h"));
        } else {
            if (!auto) {
                this.getDetail(this.activDisc).setSetBeginEndByUser(false);
            }
            this.getTxtFin(this.activDisc).setText("");
        }
    }

    private JPanel getPnlAdjX() {
        this.adjX = new JSlider(-10, 10, 0);
        this.adjX.getAccessibleContext().setAccessibleName("(X)");
        this.adjX.getAccessibleContext().setAccessibleDescription("(X)");
        this.adjX.addChangeListener(this.listener);
        this.pnlAdjX = new JPanel();
        this.pnlAdjX.setLayout(new BoxLayout(this.pnlAdjX, 0));
        this.pnlAdjX.add((Component)this.adjX, "East");
        this.pnlAdjX.setBorder(new TitledBorder("(X)"));
        return this.pnlAdjX;
    }

    private JPanel getPnlAdjY() {
        this.adjY = new JSlider(1, -10, 10, 0);
        this.adjY.getAccessibleContext().setAccessibleName("(Y)");
        this.adjY.getAccessibleContext().setAccessibleDescription("(Y)");
        this.adjY.addChangeListener(this.listener);
        this.pnlAdjY = new JPanel();
        this.pnlAdjY.setLayout(new BoxLayout(this.pnlAdjY, 1));
        this.pnlAdjY.setBorder(new TitledBorder("(Y)"));
        this.pnlAdjY.add(this.adjY);
        return this.pnlAdjY;
    }

    private void setSliderPosition() {
        TimsLogger.debug("#DialogScan.setSliderPosition#" + this.posSlid[this.activDisc][0] + " " + this.posSlid[this.activDisc][1]);
        try {
            this.adjX.setValue(this.posSlid[this.activDisc][0]);
            this.adjY.setValue(this.posSlid[this.activDisc][1]);
        }
        catch (Exception e) {
            TimsLogger.warn("setSliderPosition error :" + e);
        }
    }

    private JPanel getPnlSlider() {
        this.pnlSlider = new JPanel();
        this.pnlSlider.setLayout(new BorderLayout());
        this.pnlSlider.setBorder(new TitledBorder("(Rayon)"));
        JPanel paramPanel = new JPanel();
        JPanel paramPanelHaut = new JPanel();
        paramPanel.setLayout(new BoxLayout(paramPanel, 0));
        paramPanel.setBorder(BorderFactory.createTitledBorder(null, "R/D     D/T     T/C", 2, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        JSlider sliderR = Fonctions.getSlider(1, -10, 10, 0, 5, 1, "rayon", true, true, true, this.listener);
        this.sliderAjustement = Fonctions.getSlider(1, -40, 40, 0, 10, 1, "ajustement", true, true, true, this.listener);
        this.sliderSpeedAdjust = Fonctions.getSlider(1, -40, 40, 0, 10, 1, "vitesse", true, true, true, this.listener);
        JSlider sliderR1 = Fonctions.getSlider(1, 2, 6, 3, 1, 1, "r", true, true, true, this.parametersListener);
        JSlider sliderR2 = Fonctions.getSlider(1, 4, 8, 7, 1, 1, "d", true, true, true, this.parametersListener);
        JSlider sliderR3 = Fonctions.getSlider(1, 6, 13, 11, 1, 1, "t", true, true, true, this.parametersListener);
        paramPanelHaut.add(sliderR);
        paramPanelHaut.add(this.sliderAjustement);
        if (this.speedEnabled) {
            paramPanelHaut.add(this.sliderSpeedAdjust);
        }
        paramPanel.add(sliderR1);
        paramPanel.add(sliderR2);
        paramPanel.add(sliderR3);
        this.pnlSlider.add((Component)paramPanelHaut, "North");
        this.pnlSlider.add((Component)paramPanel, "Center");
        this.pnlSlider.add((Component)this.getPnlZoom(), "South");
        return this.pnlSlider;
    }

    private void updateParameters() {
        this.setSliderPosition();
        this.pnlSlider.setVisible(true);
        this.pnlAdjY.setVisible(true);
        this.sliderAjustement.setValue(this.adjust[this.activDisc]);
        if (this.speedEnabled) {
            this.sliderSpeedAdjust.setValue(this.speedAdjust[this.activDisc]);
        }
    }

    private void loadPosition() {
        this.posSlid = this.getPosition(this.prefs.get("MP" + (this.speedEnabled ? "S" : ""), ""));
        this.adjust = this.getRayon(this.prefs.get("RP" + (this.speedEnabled ? "S" : ""), ""));
        if (this.speedEnabled) {
            this.speedAdjust = this.getSpeedAdjust(this.prefs.get("SP", ""));
        }
    }

    private void savePosition() {
        String toWrite = "";
        int x = 0;
        while (x < 6) {
            toWrite = String.valueOf(toWrite) + ";" + this.posSlid[x][0] + "," + this.posSlid[x][1];
            ++x;
        }
        TimsLogger.debug("#DS.savePosition# " + toWrite);
        this.prefs.put("MP" + (this.speedEnabled ? "S" : ""), toWrite.substring(1));
    }

    private void saveRayon() {
        String toWrite = "";
        int x = 0;
        while (x < 6) {
            toWrite = String.valueOf(toWrite) + ";" + this.adjust[x];
            ++x;
        }
        TimsLogger.debug("#DS.saveRayon()# " + toWrite);
        this.prefs.put("RP" + (this.speedEnabled ? "S" : ""), toWrite.substring(1));
    }

    private void saveSpeedAjust() {
        String toWrite = "";
        int x = 0;
        while (x < 3) {
            toWrite = String.valueOf(toWrite) + ";" + this.speedAdjust[x];
            ++x;
        }
        TimsLogger.debug("#DS.saveSpeedAjust()# " + toWrite);
        this.prefs.put("SP", toWrite.substring(1));
    }

    private int[][] getPosition(String pos) {
        int[][] retour = new int[6][2];
        String[] tmp = pos.split(";");
        int end = 6;
        if (this.speedEnabled) {
            end = 3;
        }
        int x = 0;
        while (x < end) {
            if (!pos.equals("")) {
                retour[x][0] = Integer.parseInt(tmp[x].split(",")[0]);
                retour[x][1] = Integer.parseInt(tmp[x].split(",")[1]);
            } else {
                retour[x][0] = 0;
                retour[x][1] = 0;
            }
            ++x;
        }
        return retour;
    }

    private int[] getRayon(String pos) {
        int[] retour = new int[6];
        int end = 6;
        if (this.speedEnabled) {
            end = 3;
        }
        int x = 0;
        while (x < end) {
            retour[x] = !pos.equals("") ? Integer.parseInt(pos.split(";")[x]) : 0;
            ++x;
        }
        return retour;
    }

    private int[] getSpeedAdjust(String pos) {
        int[] retour = new int[3];
        int x = 0;
        while (x < 3) {
            retour[x] = !pos.equals("") ? Integer.parseInt(pos.split(";")[x]) : 0;
            ++x;
        }
        return retour;
    }

    public ScanPicture getScanPicture(int x) {
        String tmp = this.getConducteurAtPlot(x).getDataDirName();
        return new ScanPicture(0, ConnexionSettings.getInstance().getUserCle(), this.getDetail(x).getName(), new SimpleDateFormat("yyyy-MM-dd").format(new Date()), new SimpleDateFormat("yyyy-MM-dd").format(new Date()), x, tmp, 1, false);
    }

    private String getName(int x) {
        if (this.getDetail(x).getName() != null) {
            System.err.println("#Ds.getName# nom d\u00e9j\u00e0 d\u00e9fini !");
        }
        return String.valueOf(x) + ConversionTime.dateToString(new Date(), "yyMMddHHmmss") + " - " + ConversionTime.dateStringToFormat(this.getDateAnalyse(x).getText(), "dd/MM/yyyy", "yyMMdd") + ".jpg";
    }

    public void saveImage(int x, boolean wait) throws Exception {
        ScanPicture tmp = this.getScanPicture(x);
        Conducteur driver = this.getConducteurAtPlot(x);
        if (tmp == null) {
            throw new Exception(LanguageTranslator.getString("scan.noImage", String.valueOf(x)));
        }
        if (Transport.debug >= 1) {
            TimsLogger.debug("#DS.saveImage# save plot " + x + " size (" + this.getDetail(x).getAssociatedImage().getWidth(null) + "," + this.getDetail(x).getAssociatedImage().getHeight(null) + ")");
        }
        BufferedImage bufferedImageOut = new BufferedImage(this.getDetail(x).getAssociatedImage().getWidth(null), this.getDetail(x).getAssociatedImage().getHeight(null), 12);
        Graphics2D bufImageGraphics = bufferedImageOut.createGraphics();
        bufImageGraphics.drawImage(this.getDetail(x).getAssociatedImage(), 0, 0, null);
        File file = new File(String.valueOf(Transport.savePath) + "\\" + tmp.getName());
        FileOutputStream out = new FileOutputStream(file);
        ImageIO.write((RenderedImage)bufferedImageOut, "JPEG", out);
        out.close();
        FileManager.moveFile(driver, file);
        if (this.waiting != null) {
            this.waiting.get(x).setProcessed(true);
            this.waiting.get(x).update();
            FileManager.deleteTemporaryFile(this.waiting.get(x).getName());
        }
        if (!tmp.update()) {
            throw new Exception(LanguageTranslator.getString("scan.errorUpdate", String.valueOf(x)));
        }
    }

    public boolean isDisc(Image img) {
        int[] pixels;
        int white;
        int black;
        block8: {
            TimsLogger.verbose("#DS.isDisc# ");
            if (img == null) {
                return false;
            }
            black = 1;
            white = 1;
            pixels = new int[img.getWidth(null) * img.getHeight(null)];
            TimsLogger.debug("#DS.isDisc# loading " + img.getWidth(null) + " " + img.getHeight(null));
            PixelGrabber pg = new PixelGrabber(img, 0, 0, img.getWidth(null), img.getHeight(null), pixels, 0, img.getHeight(null));
            TimsLogger.debug("#DS.isDisc# loaded " + pg.getWidth() + " " + pg.getHeight());
            pg.grabPixels();
            TimsLogger.debug("#DS.isDisc# loaded");
            if ((pg.getStatus() & 0x80) == 0) break block8;
            System.err.println("#DS.isDisc# image fetch aborted or errored " + pg.getStatus());
            return false;
        }
        try {
            int i = 0;
            while (i < pixels.length) {
                int pixel = pixels[i];
                int red = pixel >> 16 & 0xFF;
                int green = pixel >> 8 & 0xFF;
                int blue = pixel & 0xFF;
                if ((red + green + blue) / 3 > 150) {
                    ++white;
                } else {
                    ++black;
                }
                ++i;
            }
            TimsLogger.debug("white = " + white + ", black = " + black);
            return 3 < white / black && (double)(white / black) < 11.5;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            TimsLogger.warn("#DS.isDisc# ex : " + ex.getMessage());
            ex.printStackTrace();
        }
        catch (Exception ex) {
            TimsLogger.warn("#DS.isDisc# ex : " + ex.getMessage());
            ex.printStackTrace();
        }
        return false;
    }

    private void quitter() {
        this.autoSave();
        this.dispose();
    }

    public boolean save() {
        int z;
        Transport.ps.startOperation();
        Transport.bdd.startTransaction();
        try {
            if (!this.saveInfos()) {
                JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("scan.save.error1"), LanguageTranslator.getString("message.saveError"), 0);
                Transport.ps.endOperation(PerformanceScanner.INSERT, "disc save");
                Transport.bdd.rollback();
                return false;
            }
        }
        catch (Exception exp) {
            JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("scan.save.error2"), LanguageTranslator.getString("message.saveError"), 0);
            Transport.ps.endOperation(PerformanceScanner.INSERT, "disc save");
            Transport.bdd.rollback();
            exp.printStackTrace();
            return false;
        }
        try {
            z = 0;
            while (z < 6) {
                if (this.getDetail(z).isAnalyzed()) {
                    this.saveImage(z, false);
                }
                ++z;
            }
        }
        catch (Exception exp) {
            JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("scan.save.error3"), LanguageTranslator.getString("message.saveError"), 2);
            Transport.ps.endOperation(PerformanceScanner.INSERT, "disc save");
            Transport.bdd.rollback();
            return false;
        }
        Transport.ps.endOperation(PerformanceScanner.INSERT, "disc save");
        Transport.bdd.commit();
        if (this.waiting != null) {
            z = 0;
            while (z < 6) {
                if (this.getDetail(z).isAnalyzed()) {
                    FileManager.deleteTemporaryFile(this.waiting.get(z).getName());
                }
                ++z;
            }
        }
        if (this.loadedImage != null) {
            TimsLogger.debug("#Ds.save# on a une image charg\u00e9e, on supprime " + this.loadedImage.getAbsolutePath());
            this.loadedImage.delete();
        }
        JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("message.saveSucceed"), LanguageTranslator.getString("message.done"), 1);
        this.initDisque(true);
        return true;
    }

    private void doCalibration(Image img) {
        img = img.getScaledInstance(1268, 1735, 1);
        new DialogCalibration(this, img);
    }

    public void loadImages(Image[] toLoad) {
        int x = 0;
        while (x < toLoad.length) {
            this.getDetail(x).setAssociatedImage(toLoad[x]);
            this.getDetail(x).setDriver(this.getConducteurAtPlot(x));
            ++x;
        }
        this.refreshScreen();
    }

    private void loadImage(Image toLoad) {
        if (toLoad == null) {
            TimsLogger.debug("#Ds.loadImage# image null...");
            return;
        }
        if (toLoad.getHeight(this) > 1500) {
            this.cropImage(toLoad);
        } else {
            this.getDetail(0).setAssociatedImage(toLoad);
            this.getDetail(0).setDriver(this.getConducteurAtPlot(0));
        }
        this.refreshScreen();
    }

    public void loadWaitingFile(Vector<WaitingFile> toLoad) {
        TimsLogger.debug("#ds.loadScanPicture# images a charger : " + toLoad.size());
        int x = 0;
        while (x < toLoad.size()) {
            this.getDetail(x).setAssociatedImage(this.getWaitingImage(toLoad.get(x).getName()));
            ++x;
        }
        this.refreshScreen();
    }

    private void refreshScreen() {
        this.getPlot(2).setSelected(true);
        this.getPlot(0).setSelected(true);
        this.updateParameters();
    }

    private Image getWaitingImage(String toGet) {
        String path = "data\\" + BddTransport.getInstance().getCompany().getNomBase() + "\\" + toGet;
        Image img = null;
        MediaTracker mt = new MediaTracker(this);
        if (System.getProperty("URL") != null) {
            try {
                URL urlFichier = Fonctions.getURL(null, path);
                TimsLogger.debug("#Ds.getImage()# adresse de l'image : " + urlFichier.toString());
                img = this.getToolkit().getImage(urlFichier);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            img = this.getToolkit().getImage(path);
        }
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException ex) {
            TimsLogger.warn("error");
            ex.printStackTrace();
        }
        return img;
    }

    private void setCodeListener(int x) {
        this.alCond.setSource(x);
        this.cbConducteur[x].addActionListener(this.alCond);
    }

    private void setVehicleUpdateListener(int x) {
        this.alVehicle.setSource(x);
        this.getCbVehicles(x).addActionListener(this.alVehicle);
    }

    private void cropImage(Image toCrop) {
        float factorX = (float)toCrop.getWidth(null) / 1268.0f;
        float factorY = (float)toCrop.getHeight(null) / 1735.0f;
        TimsLogger.debug("#DS.CropImage# factorY = " + factorY + " (" + toCrop.getWidth(null) + "/" + 1268 + "), factorX = " + factorX + " (" + toCrop.getHeight(null) + "/" + 1735 + ")");
        try {
            Image[] cropped = new Image[6];
            int[][] cropParam = Fonctions.getCroppingParameters(this.prefs.get("IP" + (this.speedEnabled ? "S" : ""), "0,0"));
            MediaTracker mt = new MediaTracker(this);
            int end = 6;
            if (this.speedEnabled) {
                end = 3;
            }
            int z = 0;
            while (z < end) {
                TimsLogger.debug("#DS.CropImage# cropping image " + z + " with parameters (" + cropParam[z][0] + "," + cropParam[z][1] + "," + (int)((float)OPTIMIZED_IMAGE_SIZE * factorY) + "," + (int)((float)OPTIMIZED_IMAGE_SIZE * factorX) + ")");
                int x = (int)((float)cropParam[z][0] * factorX);
                int y = (int)((float)cropParam[z][1] * factorY);
                int width = (int)((float)OPTIMIZED_IMAGE_SIZE * factorX);
                int height = (int)((float)OPTIMIZED_IMAGE_SIZE * factorY);
                CropImageFilter filtre = new CropImageFilter(x, y, width, height);
                cropped[z] = this.createImage(new FilteredImageSource(toCrop.getSource(), filtre));
                mt.addImage(cropped[z], 0);
                ++z;
            }
            try {
                mt.waitForAll();
            }
            catch (InterruptedException ex) {
                TimsLogger.warn("error");
                ex.printStackTrace();
            }
            this.loadImages(cropped);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Image[] getFile() {
        Image[] returnImg = null;
        try {
            Preferences prefs = Preferences.userRoot().node("TIMS");
            JFileChooser choix = new JFileChooser(prefs.node("DIRECTORY").get("DISC", System.getProperty("user.home")));
            choix.setFileSelectionMode(0);
            choix.setMultiSelectionEnabled(true);
            choix.setDialogTitle(LanguageTranslator.getString("message.selectFile"));
            choix.setApproveButtonText(LanguageTranslator.getString("button.valid"));
            if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
                prefs.node("DIRECTORY").put("DISC", choix.getCurrentDirectory().getAbsolutePath());
                MediaTracker mt = new MediaTracker(this);
                File[] selected = choix.getSelectedFiles();
                returnImg = new Image[selected.length];
                int x = 0;
                while (x < selected.length) {
                    this.loadedImage = selected[x];
                    returnImg[x] = this.getToolkit().createImage(this.loadedImage.getAbsolutePath());
                    mt.addImage(returnImg[x], 0);
                    ++x;
                }
                try {
                    mt.waitForAll();
                }
                catch (InterruptedException ex) {
                    TimsLogger.warn("error");
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            TimsLogger.warn("#DS.getFile(  )# " + ex);
            ex.printStackTrace();
        }
        return returnImg;
    }

    int checkDate() {
        int retour = 1;
        int cleConducteur = this.modeleConducteur[this.activDisc].getSelectedCle();
        String date = ConversionTime.dateFromFranceToBDD(this.dateAnalyse[this.activDisc].getText(), false);
        if (this.getDateAnalyse(this.activDisc).getText().equals("")) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("scan.date.empty"), LanguageTranslator.getString("message.inputError"), 0);
            retour = 0;
        } else if (this.bddEco.getConflitList(cleConducteur, date, 0, false).size() != 0) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("scan.date.conflict", this.getDateAnalyse(this.activDisc).getText()), LanguageTranslator.getString("message.inputError"), 0);
            retour = 0;
        } else {
            Vector<ActiviteConducteur> activiteJour = this.bddEco.getActivite(cleConducteur, date, date, -1, 0);
            this.processOnExistingDay = false;
            if (activiteJour.size() != 0) {
                this.processOnExistingDay = true;
                retour = DialogShowExistingActivity.showExistingActivity(this, activiteJour) == 0 ? 1 : 0;
            }
        }
        return retour;
    }

    public boolean conducteurSortie() {
        String dateSortie;
        block4: {
            try {
                dateSortie = ConversionTime.dateFromBDDToFrance(this.getConducteurAtPlot(this.activDisc).getDateSortie(), false, true);
                if (!dateSortie.equals("") && !dateSortie.equals("01/01/1970")) break block4;
                return false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        Date sortie = ConversionTime.stringToDate(dateSortie, "dd/MM/yyyy");
        Date jour = ConversionTime.stringToDate(this.getDateAnalyse(this.activDisc).getText(), "dd/MM/yyyy");
        if (sortie.before(jour)) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("scan.date.exit"), LanguageTranslator.getString("message.inputError"), 0);
            return true;
        }
        return false;
    }

    public void cumul() {
        int[] tabSum = new int[6];
        int i = 0;
        while (i < 6) {
            tabSum[i] = 0;
            ++i;
        }
        Vector<ChangementActivite> vTmp = this.getDetail(this.activDisc).getActivityChangeInfos();
        int x = 0;
        while (x < vTmp.size()) {
            ChangementActivite tmp = vTmp.get(x);
            int duree = 0;
            if (x < vTmp.size() - 1) {
                duree = vTmp.get(x + 1).getHeure() - vTmp.get(x).getHeure();
                if (vTmp.get(x + 1).getDate().after(vTmp.get(x).getDate())) {
                    duree += 1440;
                }
            } else {
                duree = 1440 - vTmp.get(x).getHeure();
            }
            switch (tmp.getTypeActivite()) {
                case 1: {
                    tabSum[0] = tabSum[0] + duree;
                    break;
                }
                case 2: {
                    tabSum[1] = tabSum[1] + duree;
                    break;
                }
                case 3: {
                    tabSum[2] = tabSum[2] + duree;
                    break;
                }
                case 4: {
                    tabSum[3] = tabSum[3] + duree;
                    break;
                }
                case 5: {
                    tabSum[4] = tabSum[4] + duree;
                    break;
                }
                case 6: {
                    tabSum[5] = tabSum[5] + duree;
                    break;
                }
                default: {
                    TimsLogger.warn("activit\u00e9s inconnue " + tmp.getTypeActivite());
                }
            }
            ++x;
        }
        this.getDetail(this.activDisc).setConduite(tabSum[0]);
        this.getDetail(this.activDisc).setTravail(tabSum[1]);
        this.getDetail(this.activDisc).setDisposition(tabSum[2]);
        this.getDetail(this.activDisc).setRepos(tabSum[3]);
        this.getDetail(this.activDisc).setDe(tabSum[4]);
        this.getDetail(this.activDisc).setAutre(tabSum[5]);
    }

    void ecrireLabel() {
        String cumulT = ConversionTime.heureIntToString(this.getDetail(this.activDisc).getDisposition() + this.getDetail(this.activDisc).getTravail() + this.getDetail(this.activDisc).getConduite() + this.getDetail(this.activDisc).getDe(), "h");
        this.getPnlActivite(0).setCumul(this.getDetail(this.activDisc).getRepos());
        this.getPnlActivite(1).setCumul(this.getDetail(this.activDisc).getDisposition());
        this.getPnlActivite(2).setCumul(this.getDetail(this.activDisc).getTravail());
        this.getPnlActivite(3).setCumul(this.getDetail(this.activDisc).getConduite());
        this.getPnlActivite(4).setCumul(this.getDetail(this.activDisc).getDe());
        this.getPnlActivite(5).setCumul(this.getDetail(this.activDisc).getAutre());
        this.lblTpsTotal.setText(cumulT);
    }

    public void analyse() {
        if (this.getDetail(this.activDisc).getAssociatedImage() == null) {
            TimsLogger.info("#DialogScan.analyse# Pas d'image sur le plot " + this.activDisc);
            return;
        }
        if (this.checkDate() == 0) {
            return;
        }
        if (this.conducteurSortie()) {
            return;
        }
        this.btnSave.setEnabled(true);
        this.btnEffacer.setEnabled(true);
        this.getCbConducteur(this.activDisc).setEnabled(false);
        this.getCbVehicles(this.activDisc).setEnabled(false);
        this.btnAnalyser.setEnabled(false);
        this.btn6Disque.setEnabled(false);
        this.getDetail(this.activDisc).setDateDebut(ConversionTime.stringToDate(this.getDateAnalyse(this.activDisc).getText(), "dd/MM/yyyy"));
        this.getDetail(this.activDisc).setName(this.getName(this.activDisc));
        this.getImage().analyseBinaire();
        this.majHoraire();
        this.cumul();
        this.ecrireLabel();
        this.reloadFrais();
        String debut = String.valueOf(this.getDateAnalyse(this.activDisc).getText()) + " " + ConversionTime.heureIntToString(this.getDetail(this.activDisc).getHeureDebut(), ":") + ":00";
        String fin = String.valueOf(this.getDateAnalyse(this.activDisc).getText()) + " " + ConversionTime.heureIntToString(this.getDetail(this.activDisc).getHeureFin(), ":") + ":00";
        Date dateDebut = ConversionTime.stringToDateFr(debut, true);
        Date dateFin = ConversionTime.stringToDateFr(fin, true);
        Conducteur tmp = this.getConducteurAtPlot(this.activDisc);
        VehicleUsed tmpVU = new VehicleUsed(tmp.getCleConducteur(), tmp.getPrenom(), tmp.getNom(), tmp.getNumeroCarte(), dateDebut, dateFin);
        tmpVU.setCleVehicule(((ComboBoxModel)this.getCbVehicles(this.activDisc).getModel()).getSelectedCle());
        tmpVU.setImmatriculation(this.getCbVehicles(this.activDisc).getSelectedItem().toString());
        this.getDetail(this.activDisc).getVehiclesUsed().add(tmpVU);
        this.getPnlVehiculeConducteur().initialise(this.currentVehiclelist, this.getDetail(this.activDisc).getVehiclesUsed(), tmp, this.getDateAnalyse(this.activDisc).getText());
    }

    public void majHoraire() {
        this.getDetail(this.activDisc).setHeureDebut(this.getHeureDebut(this.getDetail(this.activDisc).getActivityChangeInfos()));
        this.getDetail(this.activDisc).setHeureFin(this.getHeureFin(this.getDetail(this.activDisc).getActivityChangeInfos()));
        if (this.getDetail(this.activDisc).getHeureFin() != -1) {
            this.getTxtDebut(this.activDisc).setText(ConversionTime.heureIntToString(this.getDetail(this.activDisc).getHeureDebut(), "h"));
            this.getTxtFin(this.activDisc).setText(ConversionTime.heureIntToString(this.getDetail(this.activDisc).getHeureFin(), "h"));
        }
    }

    public void reloadFrais() {
        this.getDetail(this.activDisc).getFrais().clear();
        int cleConducteur = this.getConducteurAtPlot(this.activDisc).getCleConducteur();
        if (this.processOnExistingDay) {
            this.getDetail(this.activDisc).getFrais().addAll(DriverExpenses.loadList(0, cleConducteur, this.getDetail(this.activDisc).getDateDebut(), null));
        }
        boolean validated = false;
        if (ConnexionSettings.getInstance().isConsultable("EXPENSES_VALIDATION")) {
            validated = ExpensesValidation.checkLocked(this.getDetail(this.activDisc).getDateDebut(), cleConducteur);
        }
        if (!validated) {
            for (ExpensesType tf : ExpensesType.getList()) {
                if (!tf.isActif() || tf.getEmployeeTypeId() != 0 && tf.getEmployeeTypeId() != this.getDetail(this.activDisc).getDriver().getCleTypeConducteur() || !Fonctions.shouldAddExpensesByBeginEnd(tf, this.getDetail(this.activDisc).getDateDebut(), this.getDetail(this.activDisc).getHeureDebut(), this.getDetail(this.activDisc).getHeureFin()) && !Fonctions.shouldAddExpensesByAmount(tf, this.getDetail(this.activDisc).getHeureDebut(), this.getDetail(this.activDisc).getHeureFin(), this.getDetail(this.activDisc).getActivityChangeInfos())) continue;
                TimsLogger.debug("#DialogScan.reloadFrais()# ExpensesType " + tf.getCode() + " found in service begining on " + this.getDetail(this.activDisc).getDateDebut() + " " + ConversionTime.heureIntToString(this.getDetail(this.activDisc).getHeureDebut(), "h"));
                Date date = ConversionTime.stringToDate(this.getDateAnalyse(this.activDisc).getText(), "yyyy-MM-dd");
                float amount = tf.getMontant(date, 0);
                if (!(this.getDateAnalyse(this.activDisc).getText().equals(this.getDetail(this.activDisc).getDateFin()) || this.getDetail(this.activDisc).getHeureDebut() < tf.getHour() && tf.getHour() < 1440)) {
                    ConversionTime.stringToDate(this.getDetail(this.activDisc).getDateFin(), "yyyy-MM-dd");
                }
                this.getDetail(this.activDisc).getFrais().add(new DriverExpenses(0, cleConducteur, date, tf.getCle(), true, 0.0f, 0.0f, amount, false, 1));
            }
        }
        if (LicenceManager.isHRLevel()) {
            this.getPnlFraisConducteur().initialise(this.getDetail(this.activDisc).getFrais(), this.getConducteurAtPlot(this.activDisc), this.getDateAnalyse(this.activDisc).getText());
        }
    }

    private boolean saveInfos() throws IOException, Exception {
        int random = (int)(Math.random() * 1000.0);
        String dayFn = String.valueOf(Transport.savePath) + "jour" + random + ".txt";
        while (new File(dayFn).exists()) {
            random = (int)(Math.random() * 1000.0);
            dayFn = String.valueOf(Transport.savePath) + "activite" + random + ".txt";
        }
        String vehicleUsedFn = String.valueOf(Transport.savePath) + "priseVehicule" + random + ".txt";
        String dayUevFn = String.valueOf(Transport.savePath) + "day_uev" + random + ".txt";
        String speedFn = String.valueOf(Transport.savePath) + "speed" + random + ".txt";
        String expFn = String.valueOf(Transport.savePath) + "expense" + random + ".txt";
        String commentFn = String.valueOf(Transport.savePath) + "comment" + random + ".txt";
        FileWriter fDay = new FileWriter(dayFn);
        FileWriter fExp = new FileWriter(expFn);
        FileWriter fVehicle = new FileWriter(vehicleUsedFn);
        FileWriter fDayUev = new FileWriter(dayUevFn);
        FileWriter fSpeed = new FileWriter(speedFn);
        FileWriter fComment = new FileWriter(commentFn);
        Transport.ps.closeAll();
        Transport.ps.startOperation();
        if (LicenceManager.isHRLevel()) {
            this.getPnlFraisConducteur().commit();
        }
        this.getPnlVehiculeConducteur().commit();
        if (!this.getTxtComment().getText().equals("")) {
            this.getDetail(this.activDisc).setCommentaire(new Comment(0, this.getConducteurAtPlot(this.activDisc).getCleConducteur(), this.getDateAnalyse(this.activDisc).getText(), this.getTxtComment().getText(), this.getCbComment().isSelected()));
        }
        TimsLogger.debug("Ds.saveInfos# d\u00e9but traitement");
        Vector<String[]> service = new Vector<String[]>();
        Vector<Object[]> offence = new Vector<Object[]>();
        Vector<Conducteur> drivers = this.getDrivers();
        for (Conducteur driver : drivers) {
            Vector<Object> finalAct = new Vector<Object>();
            Vector<DriverExpenses> finalExp = new Vector<DriverExpenses>();
            Vector<VehicleUsed> finalVeh = new Vector<VehicleUsed>();
            Vector<UevSpeed> finalSpeed = new Vector<UevSpeed>();
            Vector<Comment> finalCom = new Vector<Comment>();
            boolean missingVehicle = false;
            int z = 0;
            while (z < 6) {
                if (!this.getConducteurAtPlot(z).equals(driver)) {
                    TimsLogger.debug("Ds.saveInfos# driver " + driver.getNom() + " not on plot " + z);
                } else {
                    TimsLogger.debug("Ds.saveInfos# on traite le plot " + z + " pour " + driver.getNom());
                    int y = 0;
                    while (y < this.getDetail(z).getActivityChangeInfos().size()) {
                        Iterator<UevSpeed> toAdd = this.getDetail(z).getActivityChangeInfos().get(y);
                        ChangementActivite nextToAdd = y != this.getDetail(z).getActivityChangeInfos().size() - 1 ? this.getDetail(z).getActivityChangeInfos().get(y + 1) : null;
                        ChangementActivite nextTocurrent = null;
                        ChangementActivite prevToCurrent = null;
                        boolean insertBetweenAct = false;
                        int x = 0;
                        while (x < finalAct.size()) {
                            nextTocurrent = (ChangementActivite)finalAct.get(x);
                            ChangementActivite changementActivite = prevToCurrent = x != 0 ? (ChangementActivite)finalAct.get(x - 1) : null;
                            if (nextTocurrent.getDate().after(((ChangementActivite)((Object)toAdd)).getDate()) || nextTocurrent.getDate().equals(((ChangementActivite)((Object)toAdd)).getDate()) && nextTocurrent.getHeure() > ((ChangementActivite)((Object)toAdd)).getHeure()) {
                                insertBetweenAct = true;
                                break;
                            }
                            ++x;
                        }
                        if (insertBetweenAct) {
                            ((ChangementActivite)((Object)toAdd)).affiche();
                            if (prevToCurrent != null) {
                                prevToCurrent.affiche();
                            }
                            if (nextTocurrent != null) {
                                nextTocurrent.affiche();
                            }
                            int isAuthorized = this.isAuthorized((ChangementActivite)((Object)toAdd), nextToAdd, prevToCurrent, nextTocurrent);
                            switch (isAuthorized) {
                                case -1: {
                                    return false;
                                }
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    finalAct.add(x, toAdd);
                                    finalAct.remove(nextTocurrent);
                                    break;
                                }
                                case 2: {
                                    finalAct.add(x, toAdd);
                                }
                            }
                        } else {
                            ((ChangementActivite)((Object)toAdd)).affiche();
                            finalAct.add(x, toAdd);
                        }
                        ++y;
                    }
                    finalExp.addAll(this.getDetail(z).getFrais());
                    finalVeh.addAll(this.getDetail(z).getVehiclesUsed());
                    for (VehicleUsed toCheck : this.getDetail(z).getVehiclesUsed()) {
                        toCheck.getCleVehicule();
                    }
                    for (UevSpeed toFill : this.getDetail(z).getSpeed()) {
                        if (toFill.getDriverId() == 0) {
                            toFill.setDriverId(this.getConducteurAtPlot(z).getCleConducteur());
                        }
                        if (toFill.getCleVehicule() != 0) continue;
                        if (this.findVehicleId(toFill, this.getDetail(z).getVehiclesUsed())) {
                            finalSpeed.add(toFill);
                            continue;
                        }
                        missingVehicle = true;
                    }
                    if (this.getDetail(z).getCommentaire() != null) {
                        finalCom.add(this.getDetail(z).getCommentaire());
                    }
                }
                ++z;
            }
            if (missingVehicle && JOptionPane.showConfirmDialog(this, "Des exc\u00e8s de vitesse n'ont pas de v\u00e9hicules associ\u00e9. Voulez vous continuer ?") != 0) {
                return false;
            }
            TimsLogger.debug("#DS.saveInfos()# Resultat final pour le conducteur " + driver.getNom());
            Vector<ActiviteConducteur> tmpJour = new Vector<ActiviteConducteur>();
            int conduite = 0;
            int travail = 0;
            int dispo = 0;
            int repos = 0;
            int de = 0;
            int inconnu = 0;
            int nuit = 0;
            int v = 0;
            while (v < finalAct.size()) {
                int duree;
                ChangementActivite one = (ChangementActivite)finalAct.get(v);
                Vector<String> vector = new Vector<String>();
                if (tmpJour.size() == 0 && one.getHeure() != 0) {
                    ChangementActivite minuit = (ChangementActivite)((ChangementActivite)finalAct.get(v)).clone();
                    minuit.setHeure(0);
                    if (v == 0) {
                        minuit.setTypeActivite(4);
                    } else {
                        minuit.setTypeActivite(((ChangementActivite)finalAct.get(v - 1)).getTypeActivite());
                    }
                    finalAct.add(v, minuit);
                    one = minuit;
                }
                int heureFin = 1440;
                if (v != finalAct.size() - 1 && ((ChangementActivite)finalAct.get(v + 1)).getDate().equals(one.getDate())) {
                    heureFin = ((ChangementActivite)finalAct.get(v + 1)).getHeure();
                }
                if ((duree = heureFin - one.getHeure()) != 0) {
                    tmpJour.add(new ActiviteConducteur(driver.getCleConducteur(), driver.getCleAgence(), one.getTypeActivite(), "", one.getHeure(), heureFin, duree, ConversionTime.dateToString(one.getDate(), "yyyy-MM-dd"), one.getSource(), one.getNomSource(), one.getEtatCarte(), one.getEtatConduite(), one.getLecteur(), 0));
                }
                if (one.getNomSource() != null && !vector.contains(one.getNomSource())) {
                    vector.add(one.getNomSource());
                }
                if (v == finalAct.size() - 1 || !((ChangementActivite)finalAct.get(v + 1)).getDate().equals(one.getDate())) {
                    String sSources = "";
                    for (String s : vector) {
                        sSources = String.valueOf(sSources) + ";" + s;
                    }
                    sSources = sSources.equals("") ? null : sSources.substring(1);
                    String dateJour = ConversionTime.dateToString(one.getDate(), "yyyy-MM-dd");
                    int debut = Integer.parseInt(Fonctions.getHeureDebut(tmpJour));
                    int fin = Integer.parseInt(Fonctions.getHeureFin(tmpJour));
                    if (!driver.getDateSortie().equals("") && !driver.getDateSortie().equals("1970-01-01") && dateJour.compareTo(driver.getDateSortie()) > 0) {
                        if (Transport.debug >= 1) {
                            TimsLogger.debug("#Ds.saveInfos# conducteur deja sorti le " + dateJour + " (sorti le " + driver.getDateSortie() + ")");
                        }
                    } else if (Transport.bdd.getJourCle(driver.getCleConducteur(), dateJour) != "") {
                        TimsLogger.debug("#Ds.saveInfos# on g\u00e8re le chevauchement");
                        new GestionChevauchement(tmpJour, driver, dateJour, this.getKm(dateJour, driver.getCleConducteur()), fDay, sSources);
                    } else {
                        Date lastExport;
                        for (ActiviteConducteur act : tmpJour) {
                            switch (act.getCleType()) {
                                case 1: {
                                    conduite += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 2: {
                                    travail += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 3: {
                                    dispo += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 4: {
                                    repos += act.getDuree();
                                    break;
                                }
                                case 5: {
                                    de += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 6: {
                                    inconnu += act.getDuree();
                                    break;
                                }
                                default: {
                                    TimsLogger.warn("activit\u00e9s inconnue " + act.getCleType());
                                }
                            }
                        }
                        Jour detailJour = new Jour(0, driver.getCleConducteur(), dateJour, conduite, travail, dispo, repos, de, inconnu, 0, conduite + travail + dispo + de, debut, fin, nuit, this.getKm(dateJour, driver.getCleConducteur()), 0, false, tmpJour, "", ConnexionSettings.getInstance().getUserCle(), sSources, false);
                        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                            detailJour.insert();
                        }
                        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                            fDay.write(detailJour.getSQLInsert());
                            fDay.write("\n");
                        }
                        if (System.getProperty("horoquartz", "0").equals("1") && (lastExport = BddTransport.getInstance().getLastExport(driver.getCleConducteur())) != null && (one.getDate().before(lastExport) || one.getDate().equals(lastExport))) {
                            BddTransport.getInstance().updateExportHoroquartz(driver.getCleConducteur(), detailJour.getDate());
                        }
                    }
                    conduite = 0;
                    travail = 0;
                    dispo = 0;
                    repos = 0;
                    de = 0;
                    inconnu = 0;
                    nuit = 0;
                    tmpJour.clear();
                }
                ++v;
            }
            String[] sTmp = new String[]{String.valueOf(driver.getCleConducteur()), ConversionTime.dateToString(((ChangementActivite)finalAct.get(0)).getDate(), "yyyy-MM-dd"), ConversionTime.dateToString(((ChangementActivite)finalAct.get(finalAct.size() - 1)).getDate(), "yyyy-MM-dd")};
            service.add(sTmp);
            Object[] oTmp = new Object[]{driver.getCleConducteur(), ((ChangementActivite)finalAct.get(0)).getDate(), ((ChangementActivite)finalAct.get(finalAct.size() - 1)).getDate()};
            for (DriverExpenses driverExpenses : finalExp) {
                if (driverExpenses.getId() != 0 || driverExpenses.getExpensesId() == 0) continue;
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    String sql = driverExpenses.getInsertString();
                    fExp.write(sql);
                    fExp.write("\n");
                    continue;
                }
                driverExpenses.insert();
            }
            for (VehicleUsed vehicleUsed : finalVeh) {
                JourUEV dayToAdd = new JourUEV(0, vehicleUsed.getCleVehicule(), ConnexionSettings.getInstance().getUserCle(), vehicleUsed.getDateFin(), vehicleUsed.getKmFin(), vehicleUsed.getKmEffectue(), 0, "", null);
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    fVehicle.write(vehicleUsed.getSQLInsert());
                    fVehicle.write("\n");
                    fDayUev.write(dayToAdd.getSQLInsert());
                    fDayUev.write("\n");
                    continue;
                }
                vehicleUsed.insert("driver_vehicle_used");
                dayToAdd.insert();
            }
            for (UevSpeed uevSpeed : finalSpeed) {
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    fSpeed.write(uevSpeed.getSQLString());
                    fSpeed.write("\n");
                } else {
                    uevSpeed.insert();
                }
                try {
                    long ms = uevSpeed.getDateFin().getTime() - uevSpeed.getDateDebut().getTime();
                    int length = (int)(ms / 60000L);
                    TimsLogger.debug("#DS.saveInfos# driver for uevSpeed = " + uevSpeed.getDriverId());
                    new UevOffence(uevSpeed.getCleVehicule(), uevSpeed.getDriverId(), uevSpeed.getDateDebut(), uevSpeed.getDateFin(), length, uevSpeed.getVitesseMax(), 1, 2).insert();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (Comment comment : finalCom) {
                if (comment == null || comment.getDesignation().equals("")) continue;
                String dateJourComm = ConversionTime.dateFromFranceToBDD(comment.getDate(), false);
                String txt = String.valueOf(driver.getCleConducteur()) + "\t" + dateJourComm + "\t" + comment.getDesignation();
                fComment.write(txt);
                fComment.write("\n");
            }
            TimsLogger.info("#ds.saveInfos# " + finalAct.size() + " activit\u00e9s," + finalExp.size() + " frais, " + finalVeh.size() + " vehicules, " + finalCom.size() + " comment pour le conducteur " + driver.getCleConducteur());
        }
        fDay.close();
        fExp.close();
        fVehicle.close();
        fSpeed.close();
        fComment.close();
        fDayUev.close();
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            this.bddEco.loadDay(dayFn);
            this.bddEco.loadVehicleDay(dayUevFn);
            this.bddEco.loadDriverExpenses(expFn);
            this.bddEco.loadVehicleUsed(vehicleUsedFn, "driver_vehicle_used");
            this.bddEco.loadDriverComment(commentFn);
            this.bddEco.loadVehicleSpeed(speedFn);
        }
        this.majService(service);
        this.majOffence(offence);
        Fonctions.deleteFile(dayFn, expFn, vehicleUsedFn, commentFn, speedFn, dayUevFn);
        return true;
    }

    private boolean findVehicleId(UevSpeed toFill, Vector<VehicleUsed> vehiclesUsed) {
        if (vehiclesUsed.size() == 0) {
            return false;
        }
        if (vehiclesUsed.size() == 1) {
            int id = vehiclesUsed.get(0).getCleVehicule();
            if (id == 0) {
                return false;
            }
            toFill.setCleVehicule(id);
            return true;
        }
        Date begin = toFill.getDateDebut();
        Date end = toFill.getDateFin();
        for (VehicleUsed tmp : vehiclesUsed) {
            Date vBegin = tmp.getDateDebut();
            Date vEnd = tmp.getDateFin();
            if ((!begin.after(vBegin) || !begin.before(vEnd)) && (!end.after(vBegin) || !end.before(vEnd))) continue;
            toFill.setCleVehicule(tmp.getCleVehicule());
            return true;
        }
        return false;
    }

    private int isAuthorized(ChangementActivite toAdd, ChangementActivite nextInDisc, ChangementActivite prevInSerie, ChangementActivite nextInSerie) {
        int isAuthorizedAfter;
        int isAuthorizedBefore = this.isAuthorizedBefore(toAdd, prevInSerie);
        return isAuthorizedBefore >= (isAuthorizedAfter = this.isAuthorizedAfter(toAdd, nextInDisc, nextInSerie)) ? isAuthorizedAfter : isAuthorizedBefore;
    }

    private int isAuthorizedBefore(ChangementActivite toAdd, ChangementActivite prevInSerie) {
        int retour = 2;
        if (prevInSerie == null) {
            retour = 2;
        } else if (prevInSerie.getNomSource().equals(toAdd.getNomSource())) {
            retour = 2;
        } else if (Fonctions.isActiv(prevInSerie.getTypeActivite()) && Fonctions.isActiv(toAdd.getTypeActivite())) {
            retour = -1;
        } else if (Fonctions.isActiv(prevInSerie.getTypeActivite()) && !Fonctions.isActiv(toAdd.getTypeActivite()) || !Fonctions.isActiv(prevInSerie.getTypeActivite()) && !Fonctions.isActiv(toAdd.getTypeActivite())) {
            retour = 0;
        }
        return retour;
    }

    private int isAuthorizedAfter(ChangementActivite toAdd, ChangementActivite nextInDisc, ChangementActivite nextInSerie) {
        int retour = 2;
        if (nextInDisc != null && (nextInSerie.getDate().after(nextInDisc.getDate()) || nextInSerie.getDate().equals(nextInDisc.getDate()) && nextInSerie.getHeure() > nextInDisc.getHeure())) {
            retour = 2;
        } else if (Fonctions.isActiv(toAdd.getTypeActivite()) && !Fonctions.isActiv(nextInSerie.getTypeActivite())) {
            retour = 1;
        } else if (Fonctions.isActiv(toAdd.getTypeActivite()) && Fonctions.isActiv(nextInSerie.getTypeActivite())) {
            retour = -1;
        }
        return retour;
    }

    public int getKm(String date, int cleConducteur) {
        int kmRapide = 0;
        int km = 0;
        int x = 0;
        while (x < 6) {
            if (date.equals(ConversionTime.dateFromFranceToBDD(this.getDateAnalyse(x).getText(), false)) && this.getConducteurAtPlot(x).getCleConducteur() == cleConducteur) {
                kmRapide += this.getKmRapide(x).getText().equals("") ? 0 : Integer.parseInt(this.getKmRapide(x).getText());
                if (this.getDetail(x).getVehiclesUsed().size() != 0) {
                    for (VehicleUsed elt : this.getDetail(x).getVehiclesUsed()) {
                        km += elt.getKmEffectue();
                    }
                }
                TimsLogger.debug("#ds.getKm# " + x + " = " + kmRapide);
            }
            ++x;
        }
        return kmRapide == 0 ? km : kmRapide;
    }

    public void majService(Vector<String[]> toMaj) throws Exception {
        for (String[] tmp : toMaj) {
            TimsLogger.debug("#DialogScan.majService# " + tmp[0] + "," + tmp[1] + "," + tmp[2]);
            TraitementTempsService tts = new TraitementTempsService(Integer.parseInt(tmp[0]), tmp[1], tmp[2], false);
            tts.loadActivite();
            tts.calculService();
            tts.saveListe();
        }
    }

    public void majOffence(Vector<Object[]> toMaj) {
        for (Object[] tmp : toMaj) {
            Date begin = (Date)tmp[1];
            Date end = (Date)tmp[2];
            int n = Fonctions.offenceCalculation((Conducteur)tmp[0], begin, end, false);
        }
    }

    public int getHeureDebut(Vector<ChangementActivite> tmp) {
        int heureDebut = 0;
        for (ChangementActivite act : tmp) {
            if (!Fonctions.isActiv(act.getTypeActivite())) continue;
            heureDebut = act.getHeure();
            break;
        }
        return heureDebut;
    }

    public int getHeureFin(Vector<ChangementActivite> tmp) {
        int heureFin = 1440;
        int i = tmp.size() - 1;
        while (i > 0) {
            if (Fonctions.isActiv(tmp.get(i - 1).getTypeActivite())) {
                if (i == tmp.size() && Fonctions.isActiv(tmp.get(i).getTypeActivite())) {
                    heureFin = 1440;
                    return heureFin;
                }
                heureFin = tmp.get(i).getHeure();
                return heureFin;
            }
            if (Fonctions.isActiv(tmp.get(i).getTypeActivite())) {
                heureFin = tmp.get(i).getHeure();
                return heureFin;
            }
            --i;
        }
        return heureFin;
    }

    String getPhaseName(String phase) {
        String retour = "";
        if (phase.equals("10")) {
            retour = "R";
        } else if (phase.equals("20")) {
            retour = "D";
        } else if (phase.equals("30")) {
            retour = "T";
        } else if (phase.equals("40")) {
            retour = "C";
        } else if (phase.equals("50")) {
            retour = "AA";
        } else if (phase.equals("60")) {
            retour = "DE";
        }
        return retour;
    }

    public int getActSelected() {
        if (this.getPnlActivite(0).isSelected()) {
            return 4;
        }
        if (this.getPnlActivite(1).isSelected()) {
            return 3;
        }
        if (this.getPnlActivite(2).isSelected()) {
            return 2;
        }
        if (this.getPnlActivite(3).isSelected()) {
            return 1;
        }
        if (this.getPnlActivite(4).isSelected()) {
            return 5;
        }
        if (this.getPnlActivite(5).isSelected()) {
            return 6;
        }
        return 4;
    }

    void initDisque(boolean all) {
        if (all) {
            int x = 0;
            while (x < 6) {
                this.getImage().load(null);
                this.detail[x] = null;
                this.detail[x] = new DiscInformation();
                this.getPnlVehiculeConducteur().setKm(0);
                this.getImage().current = null;
                this.getTxtDebut(x).setText("");
                this.getTxtFin(x).setText("");
                this.getDateAnalyse(x).setText("");
                this.getKmRapide(x).setText("");
                ++x;
            }
            this.waiting = null;
            this.loadedImage = null;
        } else {
            this.getDetail(this.activDisc).reinit();
            this.getImage().current = null;
            this.getTxtDebut(this.activDisc).setText("");
            this.getTxtFin(this.activDisc).setText("");
            this.getKmRapide(this.activDisc).setText("");
            this.getPnlVehiculeConducteur().setKm(0);
        }
        this.ecrireLabel();
        this.getTxtComment().setText(this.getDetail(this.activDisc).getCommentaire() != null ? this.getDetail(this.activDisc).getCommentaire().getDesignation() : "");
        this.getCbComment().setSelected(this.getDetail(this.activDisc).getCommentaire() != null ? this.getDetail(this.activDisc).getCommentaire().isMailed() : false);
        this.repaint();
    }

    private void updateDriverList() {
        int cleAgence = this.modeleAgence.getSelectedCle();
        Vector<Conducteur> list = Conducteur.loadList(cleAgence);
        int x = 0;
        while (x < 6) {
            if (!this.getDetail(x).isAnalyzed()) {
                this.modeleConducteur[x] = new ComboBoxModel(list, true, null);
                this.getCbConducteur(x).setModel(this.modeleConducteur[x]);
            }
            ++x;
        }
    }

    private void updateVehicleList() {
        int cleAgence = this.modeleAgence.getSelectedCle();
        this.currentVehiclelist = Vehicule.loadList(cleAgence);
        int x = 0;
        while (x < 6) {
            if (!this.getDetail(x).isAnalyzed()) {
                this.getCbVehicles(x).setModel(new ComboBoxModel(this.currentVehiclelist, true, LanguageTranslator.getString("generics.unfilled")));
            }
            ++x;
        }
    }

    public void setAgence() {
        this.modeleAgence = new ComboBoxModel(Agence.getList(), true, null);
        this.getCbAgence().setModel(this.modeleAgence);
        this.updateDriverList();
        if (System.getProperty("scan.vehicle.enlarge", "0").equals("1")) {
            this.currentVehiclelist = Vehicule.getList();
            int x = 0;
            while (x < 6) {
                this.getCbVehicles(x).setModel(new ComboBoxModel(this.currentVehiclelist, true, LanguageTranslator.getString("generics.unfilled")));
                ++x;
            }
        } else {
            this.updateVehicleList();
        }
    }

    class ChangementDisque
    implements ItemListener {
        int disque;

        ChangementDisque(int disqueSelect) {
            this.disque = disqueSelect;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                TimsLogger.debug("#DS.changementDisque# change to disc " + this.disque + " (previous was " + DialogScan.this.activDisc + ")");
                if (LicenceManager.isHRLevel()) {
                    DialogScan.this.getPnlFraisConducteur().commit();
                }
                DialogScan.this.getPnlVehiculeConducteur().commit();
                if (!DialogScan.this.getTxtComment().getText().equals("")) {
                    DialogScan.this.getDetail(DialogScan.this.activDisc).setCommentaire(new Comment(0, DialogScan.this.getConducteurAtPlot(DialogScan.this.activDisc).getCleConducteur(), DialogScan.this.getDateAnalyse(DialogScan.this.activDisc).getText(), DialogScan.this.getTxtComment().getText(), DialogScan.this.getCbComment().isSelected()));
                }
                DialogScan.this.getCbConducteur(DialogScan.this.activDisc).removeActionListener(DialogScan.this.alCond);
                DialogScan.this.getCbVehicles(DialogScan.this.activDisc).removeActionListener(DialogScan.this.alVehicle);
                DialogScan.this.getCbConducteur(DialogScan.this.activDisc).setEnabled(false);
                DialogScan.this.getCbVehicles(DialogScan.this.activDisc).setEnabled(false);
                DialogScan.this.activDisc = this.disque;
                DialogScan.this.getImage().load(DialogScan.this.getDetail(DialogScan.this.activDisc));
                DialogScan.this.updateParameters();
                DialogScan.this.setCodeListener(this.disque);
                DialogScan.this.setVehicleUpdateListener(this.disque);
                boolean enable = !DialogScan.this.getDetail(this.disque).isAnalyzed() && DialogScan.this.getDetail(this.disque).getAssociatedImage() != null;
                DialogScan.this.getCbConducteur(DialogScan.this.activDisc).setEnabled(enable);
                DialogScan.this.getCbVehicles(DialogScan.this.activDisc).setEnabled(enable);
                DialogScan.this.btnAnalyser.setEnabled(enable);
                DialogScan.this.btn6Disque.setEnabled(enable);
                DialogScan.this.ecrireLabel();
                DialogScan.this.getPnlVehiculeConducteur().initialise(DialogScan.this.currentVehiclelist, DialogScan.this.getDetail(DialogScan.this.activDisc).getVehiclesUsed(), DialogScan.this.getConducteurAtPlot(DialogScan.this.activDisc), DialogScan.this.getDateAnalyse(DialogScan.this.activDisc).getText());
                if (LicenceManager.isHRLevel()) {
                    DialogScan.this.getPnlFraisConducteur().initialise(DialogScan.this.getDetail(DialogScan.this.activDisc).getFrais(), DialogScan.this.getConducteurAtPlot(DialogScan.this.activDisc), DialogScan.this.getDateAnalyse(DialogScan.this.activDisc).getText());
                }
                DialogScan.this.getTxtComment().setText(DialogScan.this.getDetail(DialogScan.this.activDisc).getCommentaire() != null ? DialogScan.this.getDetail(DialogScan.this.activDisc).getCommentaire().getDesignation() : "");
                DialogScan.this.getCbComment().setSelected(DialogScan.this.getDetail(DialogScan.this.activDisc).getCommentaire() != null ? DialogScan.this.getDetail(DialogScan.this.activDisc).getCommentaire().isMailed() : false);
            }
        }
    }

    class LoadCode
    implements ActionListener {
        private int disc;

        public LoadCode(int x) {
            this.disc = x;
        }

        public void setSource(int x) {
            this.disc = x;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = this.disc;
            while (i < 6) {
                DialogScan.this.getTxtCode(i).setText(DialogScan.this.getConducteurAtPlot(this.disc).getNumeroImport());
                DialogScan.this.getCbConducteur(i).setSelectedIndex(DialogScan.this.getCbConducteur(this.disc).getSelectedIndex());
                DialogScan.this.getDetail(i).setDriver(DialogScan.this.getConducteurAtPlot(this.disc));
                ++i;
            }
        }
    }

    class MouseClickedDate
    extends MouseAdapter {
        int sourceClik;

        public MouseClickedDate(int sourceClik) {
            this.sourceClik = sourceClik;
        }

        public void setSource(int x) {
            this.sourceClik = x;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            block12: {
                GregorianCalendar calendrier;
                block13: {
                    block11: {
                        if (SwingUtilities.isLeftMouseButton(e) && !DialogScan.this.getDetail(this.sourceClik).isAnalyzed()) {
                            JCalendrier.affiche(e.getLocationOnScreen());
                            if (JCalendrier.clicked()) {
                                try {
                                    calendrier = new GregorianCalendar();
                                    Date dateJourCourant = calendrier.getTime();
                                    SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
                                    Date dateJour = dateFormat.parse(JCalendrier.getDate());
                                    if (dateJour.after(dateJourCourant)) {
                                        JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("scan.date.error"), LanguageTranslator.getString("message.inputError"), 0);
                                        break block11;
                                    }
                                    calendrier.setTime(dateJour);
                                    int i = this.sourceClik;
                                    while (i < 6) {
                                        if (!DialogScan.this.getDetail(i).isAnalyzed()) {
                                            DialogScan.this.dateAnalyse[i].setText(dateFormat.format(calendrier.getTime()));
                                            calendrier.add(5, 1);
                                            ++i;
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Exception ex) {
                                    TimsLogger.warn("erreur " + ex);
                                }
                            }
                        }
                    }
                    if (!SwingUtilities.isRightMouseButton(e)) break block12;
                    if (e.getClickCount() != 2) break block13;
                    int i = this.sourceClik;
                    while (i < 6) {
                        DialogScan.this.dateAnalyse[i].setText("");
                        ++i;
                    }
                    break block12;
                }
                if (e.getClickCount() != 1 || this.sourceClik < 1 || DialogScan.this.dateAnalyse[this.sourceClik - 1].getText().equals("")) break block12;
                try {
                    calendrier = new GregorianCalendar();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
                    Date dateJour = dateFormat.parse(DialogScan.this.dateAnalyse[this.sourceClik - 1].getText());
                    calendrier.setTime(dateJour);
                    int i = this.sourceClik;
                    while (i < 6) {
                        if (DialogScan.this.getDetail(i).isAnalyzed()) break;
                        DialogScan.this.dateAnalyse[i].setText(dateFormat.format(calendrier.getTime()));
                        calendrier.add(5, 1);
                        ++i;
                    }
                }
                catch (Exception ex) {
                    TimsLogger.warn("erreur " + ex);
                }
            }
        }
    }

    class ParametersSliderListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider s1 = (JSlider)e.getSource();
            if (s1.getAccessibleContext().getAccessibleName() == "r") {
                DialogScan.this.getImage().setSeuilRepos(s1.getValue());
            } else if (s1.getAccessibleContext().getAccessibleName() == "d") {
                DialogScan.this.getImage().setSeuilDispo(s1.getValue());
            } else if (s1.getAccessibleContext().getAccessibleName() == "t") {
                DialogScan.this.getImage().setSeuilTravail(s1.getValue());
            }
        }
    }

    class SliderListener
    implements ChangeListener {
        JLabel tf;

        public SliderListener(JLabel f) {
            this.tf = f;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider s1 = (JSlider)e.getSource();
            if (s1.getAccessibleContext().getAccessibleName() == "(Y)") {
                DialogScan.this.getImage().setYAdjust(-s1.getValue());
                ((DialogScan)DialogScan.this).posSlid[DialogScan.this.activDisc][1] = s1.getValue();
                DialogScan.this.savePosition();
            } else if (s1.getAccessibleContext().getAccessibleName() == "(X)") {
                DialogScan.this.getImage().setXAdjust(s1.getValue());
                ((DialogScan)DialogScan.this).posSlid[DialogScan.this.activDisc][0] = s1.getValue();
                DialogScan.this.savePosition();
            } else if (s1.getAccessibleContext().getAccessibleName() == "rayon") {
                DialogScan.this.getImage().setAjustZoneAnalyse(2 * s1.getValue());
            } else if (s1.getAccessibleContext().getAccessibleName() == "ajustement") {
                DialogScan.this.getImage().setAjustCirculaire(s1.getValue());
                ((DialogScan)DialogScan.this).adjust[DialogScan.this.activDisc] = s1.getValue();
                DialogScan.this.saveRayon();
            } else if (s1.getAccessibleContext().getAccessibleName() == "vitesse") {
                DialogScan.this.getImage().setSpeedAdjust(s1.getValue());
                ((DialogScan)DialogScan.this).speedAdjust[DialogScan.this.activDisc] = s1.getValue();
                DialogScan.this.saveSpeedAjust();
            }
            this.tf.setText("(X, Y) : (" + DialogScan.this.adjX.getValue() + ", " + DialogScan.this.adjY.getValue() + ")");
            ((DialogScan)DialogScan.this).getImage().calqueActivite.repaint();
        }
    }

    class VehicleListener
    implements ActionListener {
        private int disc;

        public VehicleListener(int x) {
            this.disc = x;
        }

        public void setSource(int x) {
            this.disc = x;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = this.disc;
            while (i < 6) {
                if (!DialogScan.this.getDetail(i).isAnalyzed()) {
                    DialogScan.this.getCbVehicles(i).setSelectedIndex(DialogScan.this.getCbVehicles(this.disc).getSelectedIndex());
                }
                ++i;
            }
        }
    }

    class ZoomListener
    implements ItemListener {
        private int zoomType = 10;

        public ZoomListener(int zoomType) {
            this.zoomType = zoomType;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                return;
            }
            if (this.zoomType != 10) {
                DialogScan.this.getImage().setZoomFactor(1);
            } else {
                DialogScan.this.getImage().setZoomFactor(-1);
            }
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    int x = 0;
                    int y = 0;
                    if (ZoomListener.this.zoomType == 14 || ZoomListener.this.zoomType == 12) {
                        x = DialogScan.this.getImage().getWidth() / 2 - 1;
                    }
                    if (ZoomListener.this.zoomType == 14 || ZoomListener.this.zoomType == 16) {
                        y = DialogScan.this.getImage().getHeight() / 2 - 1;
                    }
                    if (Transport.debug >= 1) {
                        String zoom = "CENTER";
                        if (ZoomListener.this.zoomType == 14) {
                            zoom = "SOUTHEAST";
                        }
                        if (ZoomListener.this.zoomType == 16) {
                            zoom = "SOUTHWEST";
                        }
                        if (ZoomListener.this.zoomType == 12) {
                            zoom = "NORTHEAST";
                        }
                        if (ZoomListener.this.zoomType == 18) {
                            zoom = "NORTHWEST";
                        }
                        TimsLogger.debug("#ZoomListener.stateChanged# Zoom to " + zoom + " on image size (" + DialogScan.this.getImage().getWidth() + "," + DialogScan.this.getImage().getHeight() + "), scrollPane view to (" + x + "," + y + ")");
                    }
                    if (ZoomListener.this.zoomType != 10) {
                        DialogScan.this.imageScrollPane.getViewport().setViewPosition(new Point(x, y));
                        TimsLogger.debug("#ZoomListener.stateChanged# new view to (" + DialogScan.this.imageScrollPane.getViewport().getViewPosition().getX() + "," + DialogScan.this.imageScrollPane.getViewport().getViewPosition().getY() + ")");
                    }
                }
            });
        }
    }
}

