/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.scan;

import fr.pgh.data.bdd.WaitingFile;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.LMScanPicture;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.FileManager;

public class DialogWaitingScan
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JList listeScanPicture = null;
    private JPanel pnlBtn = null;
    private JButton btnCharger = null;
    private JButton btnQuitter = null;
    private JButton btnDelete = null;
    private JScrollPane jspListe = null;
    private LMScanPicture modeleListe = null;
    private boolean valid = false;
    private Vector<WaitingFile> selected = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogWaitingScan.dispose()#");
        super.dispose();
    }

    public DialogWaitingScan(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogWaitingScan()#");
        this.initialize();
    }

    public DialogWaitingScan(Dialog owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setModal(true);
        this.setBounds(new Rectangle(0, 0, 350, 400));
        this.setTitle(LanguageTranslator.getString("scan.getWaiting"));
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints4.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.weightx = 0.5;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints3.gridx = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJspListe(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getPnlBtn(), gridBagConstraints4);
        }
        return this.jContentPane;
    }

    public void majListe() {
        this.modeleListe = new LMScanPicture(WaitingFile.searchUnprocessed());
        this.getListeScanPicture().setModel(this.modeleListe);
    }

    private JList getListeScanPicture() {
        if (this.listeScanPicture == null) {
            this.listeScanPicture = new JList();
            this.listeScanPicture.setSize(new Dimension(0, 0));
            this.listeScanPicture.setModel(this.getModeleScanPicture());
            this.listeScanPicture.setAutoscrolls(true);
            this.listeScanPicture.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && DialogWaitingScan.this.getListeScanPicture().getSelectedIndices().length > (System.getProperty("scan.speed", "0").equals("1") ? 3 : 6)) {
                        DialogWaitingScan.this.getListeScanPicture().getSelectionModel().clearSelection();
                    }
                }
            });
        }
        return this.listeScanPicture;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 2;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 10;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.setPreferredSize(new Dimension(167, 50));
            this.pnlBtn.add((Component)this.getBtnCharger(), gridBagConstraints);
            this.pnlBtn.add((Component)this.getBtnDelete(), gridBagConstraints2);
            this.pnlBtn.add((Component)this.getBtnQuitter(), gridBagConstraints1);
        }
        return this.pnlBtn;
    }

    private JButton getBtnCharger() {
        if (this.btnCharger == null) {
            this.btnCharger = new JButton();
            this.btnCharger.setText(LanguageTranslator.getString("button.load"));
            this.btnCharger.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogWaitingScan.this.loadScan();
                }
            });
        }
        return this.btnCharger;
    }

    public void loadScan() {
        this.valid = true;
        this.selected = this.getModeleScanPicture().get(this.getListeScanPicture().getSelectedIndices());
        this.dispose();
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogWaitingScan.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton();
            this.btnDelete.setText(LanguageTranslator.getString("button.delete"));
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogWaitingScan.this.deleteScan();
                }
            });
        }
        return this.btnDelete;
    }

    public void deleteScan() {
        int x = 0;
        while (x < this.getListeScanPicture().getSelectedIndices().length) {
            try {
                WaitingFile tmp = this.getModeleScanPicture().getWaitingFileAt(this.getListeScanPicture().getSelectedIndices()[x]);
                FileManager.deleteTemporaryFile(tmp.getName());
                tmp.delete();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++x;
        }
        this.majListe();
    }

    private JScrollPane getJspListe() {
        if (this.jspListe == null) {
            this.jspListe = new JScrollPane();
            this.jspListe.setPreferredSize(new Dimension(200, 200));
            this.jspListe.setViewportView(this.getListeScanPicture());
            this.jspListe.setVerticalScrollBarPolicy(22);
        }
        return this.jspListe;
    }

    private LMScanPicture getModeleScanPicture() {
        if (this.modeleListe == null) {
            this.modeleListe = new LMScanPicture(WaitingFile.searchUnprocessed());
        }
        return this.modeleListe;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public Vector<WaitingFile> getSelected() {
        return this.selected;
    }
}

