/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.scan;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ChangementActivite;
import fr.pgh.data.bdd.Comment;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.UevSpeed;
import fr.pgh.data.bdd.VehicleUsed;
import java.awt.Image;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;

public class DiscInformation {
    private int cleAgence = 0;
    private Conducteur driver = null;
    private Image associatedImage = null;
    private String name = null;
    private Vector<ChangementActivite> activityChangeInfos = null;
    private Vector<VehicleUsed> vehiclesUsed = new Vector();
    private Vector<DriverExpenses> frais = null;
    private Vector<UevSpeed> speedUev = null;
    private Comment commentaire = null;
    private Date dateDebut;
    private String dateFin;
    private int heureDebut = 0;
    private int heureFin = 1440;
    private int km;
    private int conduite = 0;
    private int travail = 0;
    private int disposition = 0;
    private int repos = 0;
    private int de = 0;
    private int autre = 0;
    private boolean analyzed = false;
    private boolean processed = false;
    private boolean setBeginEndByUser = false;

    public DiscInformation() {
        this.activityChangeInfos = new Vector();
        this.frais = new Vector();
        this.speedUev = new Vector();
    }

    public void reinit() {
        this.activityChangeInfos.clear();
        this.analyzed = false;
        this.processed = false;
        this.setBeginEndByUser = false;
        this.vehiclesUsed.clear();
        this.speedUev.clear();
        this.frais.clear();
        this.commentaire = null;
        this.dateDebut = null;
        this.dateFin = null;
        this.heureDebut = 0;
        this.heureFin = 1440;
        this.km = 0;
        this.conduite = 0;
        this.travail = 0;
        this.disposition = 0;
        this.repos = 0;
        this.de = 0;
    }

    public Vector<ChangementActivite> getActivityChangeInfos() {
        return this.activityChangeInfos;
    }

    public void setActivityChangeInfos(Vector<ChangementActivite> activityChangeInfos) {
        this.activityChangeInfos = activityChangeInfos;
    }

    public boolean isAnalyzed() {
        return this.analyzed;
    }

    public void setAnalyzed(boolean analyzed) {
        this.analyzed = analyzed;
    }

    public Image getAssociatedImage() {
        return this.associatedImage;
    }

    public void setAssociatedImage(Image associatedImage) {
        this.associatedImage = associatedImage;
    }

    public int getAutre() {
        return this.autre;
    }

    public void setAutre(int autre) {
        this.autre = autre;
    }

    public int getCleAgence() {
        return this.cleAgence;
    }

    public void setCleAgence(int cleAgence) {
        this.cleAgence = cleAgence;
    }

    public Conducteur getDriver() {
        return this.driver;
    }

    public void setDriver(Conducteur driver) {
        this.driver = driver;
    }

    public Comment getCommentaire() {
        return this.commentaire;
    }

    public void setCommentaire(Comment commentaire) {
        this.commentaire = commentaire;
    }

    public int getConduite() {
        return this.conduite;
    }

    public void setConduite(int conduite) {
        this.conduite = conduite;
    }

    public Date getDateDebut() {
        return this.dateDebut;
    }

    public void setDateDebut(Date dateDebut) {
        this.dateDebut = dateDebut;
    }

    public String getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(String dateFin) {
        this.dateFin = dateFin;
    }

    public int getDe() {
        return this.de;
    }

    public void setDe(int de) {
        this.de = de;
    }

    public int getDisposition() {
        return this.disposition;
    }

    public void setDisposition(int disposition) {
        this.disposition = disposition;
    }

    public Vector<DriverExpenses> getFrais() {
        return this.frais;
    }

    public void setFrais(Vector<DriverExpenses> frais) {
        this.frais = frais;
    }

    public int getKm() {
        return this.km;
    }

    public void setKm(int km) {
        this.km = km;
    }

    public int getRepos() {
        return this.repos;
    }

    public void setRepos(int repos) {
        this.repos = repos;
    }

    public int getTravail() {
        return this.travail;
    }

    public void setTravail(int travail) {
        this.travail = travail;
    }

    public Vector<UevSpeed> getSpeed() {
        return this.speedUev;
    }

    public Vector<VehicleUsed> getVehiclesUsed() {
        return this.vehiclesUsed;
    }

    public void setVehiclesUsed(Vector<VehicleUsed> vehiclesUsed) {
        this.vehiclesUsed = vehiclesUsed;
    }

    public int getHeureDebut() {
        return this.heureDebut;
    }

    public void setHeureDebut(int heureDebut) {
        this.heureDebut = heureDebut;
    }

    public int getHeureFin() {
        return this.heureFin;
    }

    public void setHeureFin(int heureFin) {
        this.heureFin = heureFin;
    }

    public boolean isSetBeginEndByUser() {
        return this.setBeginEndByUser;
    }

    public void setSetBeginEndByUser(boolean setBeginEndByUser) {
        this.setBeginEndByUser = setBeginEndByUser;
    }

    public boolean isAnalyzedTwoDays() {
        return this.analyzed && this.activityChangeInfos != null && !this.activityChangeInfos.get(0).getDate().equals(this.activityChangeInfos.get(this.activityChangeInfos.size() - 1).getDate());
    }

    public void addSpeed(int begin, int end, int maxSpeed) {
        String sDate = ConversionTime.dateToString(this.dateDebut, "yyyy-MM-dd");
        String sBegin = String.valueOf(ConversionTime.heureIntToString(begin, ":")) + ":00";
        String sEnd = String.valueOf(ConversionTime.heureIntToString(end, ":")) + ":00";
        Date dBegin = ConversionTime.stringToDate(String.valueOf(sDate) + " " + sBegin, "yyyy-MM-dd HH:mm:ss");
        Date dEnd = ConversionTime.stringToDate(String.valueOf(sDate) + " " + sEnd, "yyyy-MM-dd HH:mm:ss");
        TimsLogger.debug("#DiscInformation.addSpeed# (" + begin + "," + end + "," + maxSpeed + ") = (" + sBegin + "," + sEnd + "," + maxSpeed + ")");
        UevSpeed tmp = new UevSpeed(0, 0, dBegin, dEnd, 7, 255, maxSpeed, maxSpeed, this.driver.getNumeroCarte(), 0);
        tmp.setDriverId(this.driver.getCleConducteur());
        this.speedUev.add(tmp);
    }

    public void addActivity(int minute, int cleType) {
        ChangementActivite tmp = new ChangementActivite(cleType, this.dateDebut, minute, "", "", "", "DISQUE", this.name);
        if (this.activityChangeInfos.size() != 0 && this.activityChangeInfos.get(0).getHeure() > tmp.getHeure()) {
            tmp.setHeure(tmp.getHeure() + 1440);
        }
        this.activityChangeInfos.add(tmp);
    }

    public void addChange(int minute, int cleType) {
        TimsLogger.debug("#DiscInfo.addChange# add " + minute);
        int x = 0;
        ChangementActivite toAdd = new ChangementActivite(cleType, this.dateDebut, minute, "", "", "", "DISQUE", this.name);
        int tolerance = (this.getHeureDebut() - this.getHeureFin()) / 2;
        while (x < this.activityChangeInfos.size()) {
            String dateToUpdate;
            ChangementActivite tmp = this.activityChangeInfos.get(x);
            if (x == 0 && this.getHeureFin() < this.getHeureDebut() && tmp.getHeure() - tolerance < minute && minute < tmp.getHeure()) {
                TimsLogger.debug("#DiscInfo.addChange# on ajoute \u00e0 0");
                this.activityChangeInfos.add(x, toAdd);
                if (this.getVehiclesUsed().size() != 1 || cleType == 4) break;
                dateToUpdate = String.valueOf(ConversionTime.dateToStringDb(this.getVehiclesUsed().get(0).getDateDebut())) + " " + ConversionTime.heureIntToString(minute, ":") + ":00";
                this.getVehiclesUsed().get(0).setDateDebut(ConversionTime.stringToDateDb(dateToUpdate, true));
                TimsLogger.debug("#DiscInfo# set new begin on vehicleUsed" + dateToUpdate);
                break;
            }
            if (x == this.activityChangeInfos.size() - 1) {
                TimsLogger.debug("#DiscInfo#on ajoute au dernier");
                this.activityChangeInfos.add(toAdd);
                if (this.getVehiclesUsed().size() != 1) break;
                dateToUpdate = String.valueOf(ConversionTime.dateToStringDb(this.getVehiclesUsed().get(0).getDateDebut())) + " " + ConversionTime.heureIntToString(minute, ":") + ":00";
                this.getVehiclesUsed().get(0).setDateFin(ConversionTime.stringToDateDb(dateToUpdate, true));
                TimsLogger.debug("#DiscInfo# set new end on vehicleUsed" + dateToUpdate);
                break;
            }
            ChangementActivite next = this.activityChangeInfos.get(x + 1);
            if (!tmp.getDate().equals(next.getDate())) {
                if (minute > 0 && minute < this.getHeureFin() + tolerance) {
                    toAdd.setHeure(toAdd.getHeure() + 1440);
                }
                if (tmp.getHeure() < minute && minute < 1440 || minute > 0 && minute < next.getHeure()) {
                    this.activityChangeInfos.add(x + 1, toAdd);
                    break;
                }
            } else {
                if (tmp.getHeure() < minute && minute < next.getHeure()) {
                    this.activityChangeInfos.add(x + 1, toAdd);
                    break;
                }
                if (tmp.getHeure() == minute) break;
            }
            ++x;
        }
    }

    public void deleteChange(int minute) {
        TimsLogger.debug("#DiscInfo.delete# delete " + minute);
        int x = 0;
        while (x < this.activityChangeInfos.size()) {
            ChangementActivite tmp = this.activityChangeInfos.get(x);
            if (x == this.activityChangeInfos.size() - 1) {
                this.activityChangeInfos.remove(x);
                break;
            }
            ChangementActivite next = this.activityChangeInfos.get(x + 1);
            if (!tmp.getDate().equals(next.getDate())) {
                if (tmp.getHeure() < minute && minute < 1440 || minute > 0 && minute < next.getHeure()) {
                    this.activityChangeInfos.remove(x);
                    break;
                }
            } else if (tmp.getHeure() <= minute && minute < next.getHeure()) {
                TimsLogger.debug("#DiscInfo# on supprime " + x);
                this.activityChangeInfos.remove(x);
                break;
            }
            ++x;
        }
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

