/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.scan;

import fr.pgh.conversion.ConversionTime;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class PnlActivite
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private Color color = null;
    private JRadioButton selected = null;
    private JPanel pnlColor = null;
    private JLabel lblCumul = null;

    public PnlActivite(String title, Color color) {
        this.name = title;
        this.color = color;
        this.add(this.getSelected());
        this.add(this.getPnlColor());
        this.add(this.getLblCumul());
    }

    public JRadioButton getSelected() {
        if (this.selected == null) {
            this.selected = new JRadioButton(this.name);
            this.selected.setPreferredSize(new Dimension(120, 14));
        }
        return this.selected;
    }

    public JPanel getPnlColor() {
        if (this.pnlColor == null) {
            this.pnlColor = new JPanel();
            this.pnlColor.setPreferredSize(new Dimension(14, 14));
            this.pnlColor.setBorder(BorderFactory.createLineBorder(Color.black));
            this.pnlColor.setBackground(this.color);
        }
        return this.pnlColor;
    }

    public JLabel getLblCumul() {
        if (this.lblCumul == null) {
            this.lblCumul = new JLabel("00h00");
            this.lblCumul.setPreferredSize(new Dimension(50, 14));
        }
        return this.lblCumul;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setCumul(int cumul) {
        this.getLblCumul().setText(ConversionTime.heureIntToString(cumul, "h"));
    }

    public boolean isSelected() {
        return this.getSelected().isSelected();
    }
}

