/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.scan;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ChangementActivite;
import fr.pgh.data.bdd.UevSpeed;
import fr.pgh.data.bdd.VehicleUsed;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Arc2D;
import java.awt.image.PixelGrabber;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.scan.Analyse;
import transpo.system.ui.views.scan.DialogScan;
import transpo.system.ui.views.scan.DiscInformation;

public class ScrollableImagePane
extends JPanel
implements MouseWheelListener,
MouseMotionListener,
MouseListener {
    boolean speedEnabled = System.getProperty("scan.speed", "0").equals("1");
    private static final long serialVersionUID = 1L;
    public static int MODE_ACTIVITE = 1;
    public static int MODE_VEHICULE = 2;
    public static int BORDER_NONE = 0;
    public static int BORDER_BEGIN = 1;
    public static int BORDER_ALL = 2;
    public static int BORDER_UNKNOW = 3;
    private int kmAtSpeedCircle = 90;
    DialogScan parent = null;
    LblActivite calqueActivite = null;
    private DiscInformation detail = null;
    private int mode = MODE_ACTIVITE;
    private Rectangle selectedArea = new Rectangle();
    CPixel[][] imgPixel;
    int ajustCirculaire = 0;
    int speedAdjust = 0;
    int tailleZoneAnalyse = 24;
    int SeuilRepos = 3;
    int SeuilDispo = 7;
    int SeuilTravail = 11;
    int xCenter = DialogScan.OPTIMIZED_IMAGE_SIZE / 2;
    int yCenter = DialogScan.OPTIMIZED_IMAGE_SIZE / 2;
    int xActivityCircle = this.xCenter - 237;
    int xSpeedCircle = this.xCenter - 320;
    int xImageAdjust = 0;
    int yActivityCircle = this.yCenter - 237;
    int ySpeedCircle = this.yCenter - 320;
    int yImageAdjust = 0;
    public static final int OPTIMIZED_ANALYZE_BEGIN = 354;
    private int analyzeZoneAdjustement = 0;
    float kmPerPoint = 0.9222222f;
    int zoomFactor = 1;
    int[] cleActMinute;
    VehicleUsed current = null;
    int tpsReposJournalier = 0;
    boolean imageLoaded = false;
    private int speedBegin = -1;
    private int speedEnd = -1;
    private int speedMax = -1;

    public ScrollableImagePane(DialogScan dg) {
        this.parent = dg;
        this.setLayout(new FlowLayout(0));
        this.calqueActivite = new LblActivite();
        this.initCalqueActivite();
        this.add(this.calqueActivite);
        this.addMouseWheelListener(this);
        this.calqueActivite.addMouseListener(this);
        this.calqueActivite.addMouseMotionListener(this);
        ToolTipManager.sharedInstance().setInitialDelay(10);
        ToolTipManager.sharedInstance().setReshowDelay(10);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.setDoubleBuffered(true);
        this.updateUI();
    }

    public void load(DiscInformation toLoad) {
        this.detail = toLoad;
        this.loadImage(toLoad == null ? null : toLoad.getAssociatedImage());
    }

    void setSeuilRepos(int value) {
        this.SeuilRepos = value;
    }

    void setSeuilDispo(int value) {
        this.SeuilDispo = value;
    }

    void setSeuilTravail(int value) {
        this.SeuilTravail = value;
    }

    public void setAjustCirculaire(int value) {
        this.ajustCirculaire = value;
    }

    public void setSpeedAdjust(int value) {
        this.speedAdjust = value;
    }

    public void setAjustZoneAnalyse(int a) {
        this.analyzeZoneAdjustement = a;
    }

    public void setZoomFactor(int increase) {
        if (this.zoomFactor == 1 && increase < 0) {
            return;
        }
        if (this.zoomFactor == 2 && increase > 0) {
            return;
        }
        TimsLogger.debug("#SIP.setZoomFactor# old factoring references : discCenter=(" + this.getAdjustedXCenter() + "," + this.getAdjustedYCenter() + "," + this.getImageSize() + ")" + ", activityPoint=(" + this.getAdjustedXActivityCircle() + "," + this.getAdjustedYActivityCircle() + "," + this.getActivityCircle() + ")" + ", speedPoint=(" + this.getAdjustedXSpeedCircle() + "," + this.getAdjustedYSpeedCircle() + "," + this.getSpeedCircle() + ")" + ", adjust=(" + this.xImageAdjust * this.zoomFactor + "," + this.yImageAdjust * this.zoomFactor + ") ,)" + ", speed Adjust =(" + this.speedAdjust + ")");
        this.zoomFactor += increase;
        this.xCenter = this.getImageSize() / 2;
        this.yCenter = this.getImageSize() / 2;
        this.kmPerPoint = (float)(this.getSpeedCircle() / 2 - this.getActivityCircle() / 2) / (float)this.kmAtSpeedCircle;
        TimsLogger.debug("#SIP.setZoomFactor# new factoring references : discCenter=(" + this.getAdjustedXCenter() + "," + this.getAdjustedYCenter() + "," + this.getImageSize() + ")" + ", activityPoint=(" + this.getAdjustedXActivityCircle() + "," + this.getAdjustedYActivityCircle() + "," + this.getActivityCircle() + ")" + ", speedPoint=(" + this.getAdjustedXSpeedCircle() + "," + this.getAdjustedYSpeedCircle() + "," + this.getSpeedCircle() + ")" + ", adjust=(" + this.xImageAdjust * this.zoomFactor + "," + this.yImageAdjust * this.zoomFactor + ")" + ", speed Adjust =(" + this.speedAdjust + ")");
        this.calqueActivite.setIcon(null);
        System.gc();
        this.loadImage(this.detail.getAssociatedImage());
        this.repaint();
    }

    private int getImageSize() {
        return DialogScan.OPTIMIZED_IMAGE_SIZE * this.zoomFactor;
    }

    private int getDebutZoneAnalyse() {
        return (354 + this.analyzeZoneAdjustement) * this.zoomFactor;
    }

    private int getActivityCircle() {
        return 475 * this.zoomFactor;
    }

    private int getSpeedCircle() {
        return (640 + this.speedAdjust * 2) * this.zoomFactor;
    }

    private int getSpeedLimitZone() {
        return this.getSpeedCircle() / 2;
    }

    private int getMaxSpeedLimitZone() {
        return (int)((float)(this.getSpeedCircle() / 2) + this.kmPerPoint * 30.0f);
    }

    private int getAnalysisSize() {
        return this.tailleZoneAnalyse * this.zoomFactor;
    }

    public void setXAdjust(int x) {
        this.xImageAdjust = x;
    }

    public void setYAdjust(int y) {
        this.yImageAdjust = y;
    }

    public int getAdjustedXCenter() {
        return this.xCenter + this.xImageAdjust * this.zoomFactor;
    }

    public int getAdjustedYCenter() {
        return this.yCenter + this.yImageAdjust * this.zoomFactor;
    }

    public int getAdjustedXActivityCircle() {
        return (this.xActivityCircle + this.xImageAdjust) * this.zoomFactor;
    }

    public int getAdjustedYActivityCircle() {
        return (this.yActivityCircle + this.yImageAdjust) * this.zoomFactor;
    }

    public int getAdjustedXSpeedCircle() {
        return (this.xSpeedCircle + this.xImageAdjust - this.speedAdjust) * this.zoomFactor;
    }

    public int getAdjustedYSpeedCircle() {
        return (this.ySpeedCircle + this.yImageAdjust - this.speedAdjust) * this.zoomFactor;
    }

    public void hideLabel() {
        this.remove(this.calqueActivite);
        this.calqueActivite.removeMouseListener(this);
        this.calqueActivite.removeMouseMotionListener(this);
    }

    public void showLabel() {
        this.add(this.calqueActivite);
        this.calqueActivite.addMouseListener(this);
        this.calqueActivite.addMouseMotionListener(this);
    }

    public void setMode(int mode) {
        this.hideLabel();
        this.mode = mode;
        this.showLabel();
        this.updateUI();
    }

    public boolean loadImage(Image image) {
        if (image != null) {
            TimsLogger.debug("#SIP.loadImage# Scale image from (" + image.getWidth(null) + "," + image.getHeight(null) + ") to (" + this.getImageSize() + "," + this.getImageSize() + ")");
        }
        int imgSize = this.getImageSize();
        this.calqueActivite.setIcon(null);
        if (image != null) {
            Image newimage = image.getScaledInstance(imgSize, imgSize, 1);
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(newimage, 1);
            try {
                mt.waitForAll();
            }
            catch (InterruptedException ex) {
                TimsLogger.warn("error");
                ex.printStackTrace();
            }
            image = null;
            System.gc();
            ImageIcon toSet = new ImageIcon(newimage);
            this.calqueActivite.setIcon(toSet);
        }
        this.updateUI();
        return true;
    }

    private void initCalqueActivite() {
        if (this.calqueActivite == null) {
            this.calqueActivite = new LblActivite();
            this.calqueActivite.setText("");
        }
        ToolTipManager.sharedInstance().registerComponent(this.calqueActivite);
    }

    private void drawReference(Graphics2D g) {
        int tailleReference = (this.getActivityCircle() - this.getDebutZoneAnalyse()) / 2;
        g.drawOval(this.getAdjustedXCenter() - this.getDebutZoneAnalyse() / 2, this.getAdjustedYCenter() - this.getDebutZoneAnalyse() / 2, this.getDebutZoneAnalyse(), this.getDebutZoneAnalyse());
        int i = 0;
        while (i < 1440) {
            Long x0 = new Long(this.getXValue(i, this.getDebutZoneAnalyse() / 2) + (long)this.getAdjustedXCenter());
            Long y0 = new Long((long)this.getAdjustedYCenter() - this.getYValue(i, this.getDebutZoneAnalyse() / 2));
            Long x1 = new Long(this.getXValue(i, this.getDebutZoneAnalyse() / 2 + tailleReference) + (long)this.getAdjustedXCenter());
            Long y1 = new Long((long)this.getAdjustedYCenter() - this.getYValue(i, this.getDebutZoneAnalyse() / 2 + tailleReference));
            g.drawLine(x0.intValue(), y0.intValue(), x1.intValue(), y1.intValue());
            i += 180;
        }
    }

    private void fillCircle(Color c, Color cXOR, int x, int y, int width, int height, Graphics2D g2D) {
        g2D.setColor(c);
        g2D.setXORMode(cXOR);
        g2D.fillOval(x, y, width, height);
    }

    private void chargePixels(Image imgIn, int x, int y, int w, int h) {
        this.imgPixel = new CPixel[475][475];
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(imgIn, x, y, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException ie) {
            TimsLogger.warn("chargePixels :::: " + ie.getMessage());
        }
        if ((pg.getStatus() & 0x80) != 0) {
            TimsLogger.error("image fetch aborted or errored");
            return;
        }
        int j = 0;
        while (j < h) {
            int i = 0;
            while (i < w) {
                this.chargePixel(i, j, pixels[j * w + i]);
                ++i;
            }
            ++j;
        }
        pixels = null;
    }

    private void chargePixel(int x, int y, int pixel) {
        int red = pixel >> 16 & 0xFF;
        int green = pixel >> 8 & 0xFF;
        int blue = pixel & 0xFF;
        this.imgPixel[x][y] = new CPixel(red, green, blue);
    }

    boolean isWhite(int x, int y) {
        return this.imgPixel[x][y].isWhite();
    }

    void analyseBinaire() {
        if (this.zoomFactor != 1) {
            this.setZoomFactor(-1);
        }
        this.detail.getActivityChangeInfos().clear();
        this.cleActMinute = new int[1440];
        int i = 0;
        while (i < 1440) {
            this.cleActMinute[i] = 4;
            ++i;
        }
        Image scaled = this.detail.getAssociatedImage().getScaledInstance(DialogScan.OPTIMIZED_IMAGE_SIZE, DialogScan.OPTIMIZED_IMAGE_SIZE, 1);
        this.chargePixels(scaled, this.getAdjustedXActivityCircle(), this.getAdjustedYActivityCircle(), 475, 475);
        this.analyseBinaireZone2();
    }

    public void analyseBinaireZone2() {
        TimsLogger.debug("#Sip.analyseBinaireZone2# deux jours = " + this.detail.isAnalyzedTwoDays() + " heureDebut " + this.detail.getHeureDebut() + " heureFin " + this.detail.getHeureFin());
        int minute = 0;
        while (minute < 1440) {
            if (!this.inLimit(minute)) {
                TimsLogger.verbose("#sip.analyseZone2# jump " + minute);
            } else {
                int blackPxl = 0;
                int rayon = this.getDebutZoneAnalyse() / 2;
                while (rayon < this.getDebutZoneAnalyse() / 2 + this.getAnalysisSize()) {
                    Long x = new Long(this.getXValue(minute, rayon) + (long)this.getAdjustedXCenter());
                    Long y = new Long((long)this.getAdjustedYCenter() - this.getYValue(minute, rayon));
                    if (!this.isWhite(x.intValue() - this.getAdjustedXActivityCircle(), y.intValue() - this.getAdjustedYActivityCircle())) {
                        ++blackPxl;
                    }
                    ++rayon;
                }
                if (blackPxl >= this.SeuilTravail) {
                    this.cleActMinute[minute] = 1;
                } else if (blackPxl >= this.SeuilDispo && blackPxl < this.SeuilTravail) {
                    this.cleActMinute[minute] = 2;
                } else if (blackPxl >= this.SeuilRepos && blackPxl < this.SeuilDispo) {
                    this.cleActMinute[minute] = 3;
                } else if (blackPxl < this.SeuilRepos) {
                    this.cleActMinute[minute] = 4;
                }
                TimsLogger.verbose("#sip.analyseZone2#" + minute + " = " + this.cleActMinute[minute]);
            }
            ++minute;
        }
        int x = this.cleActMinute.length - 3;
        while (x >= 0) {
            if (this.cleActMinute[x + 2] != this.cleActMinute[x + 1] && this.cleActMinute[x + 1] != this.cleActMinute[x] && this.cleActMinute[x] != this.cleActMinute[x + 2]) {
                if (this.cleActMinute[x + 1] > this.cleActMinute[x + 2] && this.cleActMinute[x] > this.cleActMinute[x + 1]) {
                    this.cleActMinute[x + 1] = this.cleActMinute[x + 2];
                } else if (this.cleActMinute[x + 1] < this.cleActMinute[x + 2] && this.cleActMinute[x] < this.cleActMinute[x + 1]) {
                    this.cleActMinute[x + 1] = this.cleActMinute[x];
                } else {
                    this.cleActMinute[x + 2] = this.cleActMinute[x + 1];
                }
            }
            --x;
        }
        this.getNextChange(this.detail.getHeureDebut());
        TimsLogger.debug("#Sip.analyseBinaireZone2# fin analyse : " + this.detail.getActivityChangeInfos().size() + " activit\u00e9s");
        this.detail.setAnalyzed(true);
        this.repaint();
    }

    public void getNextChange(int minuteStart) {
        if (this.detail.getActivityChangeInfos().size() == 0) {
            if (this.detail.getHeureFin() > this.detail.getHeureDebut()) {
                this.detail.addActivity(0, this.cleActMinute[0]);
            } else if (this.cleActMinute[this.detail.getHeureDebut()] != 4) {
                this.detail.addActivity(this.detail.getHeureDebut(), this.cleActMinute[this.detail.getHeureDebut()]);
            }
        }
        TimsLogger.verbose("#Sip.getNextChange# minuteStart " + minuteStart);
        int minute = minuteStart;
        while (this.cleActMinute[minute % 1440] == this.cleActMinute[(minute + 1) % 1440]) {
            if (!this.inLimit(++minute)) break;
            TimsLogger.verbose("#Sip.getNextChange# changement d'activit\u00e9 (" + this.cleActMinute[minute % 1440] + "=>" + this.cleActMinute[(minute + 1) % 1440] + ") \u00e0" + minuteStart);
        }
        if (this.inLimit(minute)) {
            this.detail.addActivity(minute % 1440, this.cleActMinute[(minute + 1) % 1440]);
            this.getNextChange((minute + 1) % 1440);
        } else if (this.detail.getHeureDebut() == 0 && this.detail.getHeureFin() == 1440) {
            this.analyseServiceAuto();
        }
    }

    public boolean inLimit(int minute) {
        TimsLogger.verbose("#Sip.inlimit# heureDebut " + this.detail.getHeureDebut() + " heureFin " + this.detail.getHeureFin() + " minute " + minute);
        if (this.detail.getHeureDebut() == 0 && this.detail.getHeureFin() == 1440) {
            return minute != 1440;
        }
        return this.detail.getHeureFin() < this.detail.getHeureDebut() && (this.detail.getHeureDebut() <= minute || minute <= this.detail.getHeureFin()) || this.detail.getHeureFin() > this.detail.getHeureDebut() && this.detail.getHeureDebut() <= minute && minute <= this.detail.getHeureFin();
    }

    public void analyseServiceAuto() {
        int[] maxRepos = this.getMaxRepos();
        this.detail.setHeureDebut(maxRepos[1]);
        this.detail.setHeureDebut(maxRepos[0]);
        this.tpsReposJournalier = maxRepos[2];
        if (maxRepos[0] < maxRepos[1] && maxRepos[0] != 0) {
            this.reordonnerAct(maxRepos);
        }
    }

    private int[] getMaxRepos() {
        Vector<ChangementActivite> activite = this.detail.getActivityChangeInfos();
        int[] maxRepos = new int[3];
        int i = 0;
        while (i < activite.size()) {
            int[] nArray = new int[3];
            nArray[0] = 100000;
            int[] repos = nArray;
            ChangementActivite act = activite.get(i);
            int lastAct = activite.size() - 1;
            while (i <= lastAct && act.getTypeActivite() == 4) {
                int finAct;
                if (repos[0] == 100000) {
                    repos[0] = act.getHeure();
                }
                int n = finAct = i == lastAct ? 1440 : activite.get(i + 1).getHeure();
                if (i == lastAct) {
                    int debutPremiereActivite = 0;
                    int x = 0;
                    while (x < lastAct) {
                        if (activite.get(x).getTypeActivite() != 4) {
                            debutPremiereActivite = activite.get(x).getHeure();
                            break;
                        }
                        ++x;
                    }
                    finAct = debutPremiereActivite + 1440;
                }
                int duree = (finAct - act.getHeure() + 1440) % 1440;
                repos[2] = repos[2] + duree;
                repos[1] = finAct % 1440;
                if (repos[2] > maxRepos[2]) {
                    maxRepos = repos;
                }
                if (++i > lastAct) continue;
                act = activite.get(i);
            }
            ++i;
        }
        TimsLogger.verbose("#Sip.getMaxRepos#" + maxRepos[0] + " " + maxRepos[1] + " " + maxRepos[2]);
        return maxRepos;
    }

    private void reordonnerAct(int[] maxRepos) {
        ChangementActivite act;
        TimsLogger.verbose("#Sip.reordonnerAct#");
        Vector<ChangementActivite> activite = this.detail.getActivityChangeInfos();
        Vector<ChangementActivite> result = new Vector<ChangementActivite>();
        int y = 0;
        int i = 0;
        while (i < activite.size()) {
            activite.get(i).affiche();
            ++i;
        }
        i = 0;
        while (i < activite.size()) {
            act = activite.get(i);
            while (act.getHeure() < maxRepos[1]) {
                act = activite.get(++i);
                y = i;
            }
            result.add(act);
            ++i;
        }
        i = 0;
        while (i <= y - 1) {
            act = activite.get(i);
            act.setHeure(act.getHeure() + 1440);
            if (act.getHeure() != 0) {
                result.add(act);
            } else {
                ChangementActivite last = activite.get(activite.size() - 1);
                if (act.getTypeActivite() != last.getTypeActivite()) {
                    result.add(act);
                }
            }
            ++i;
        }
        this.detail.setActivityChangeInfos(result);
    }

    private Vector<ChangementActivite> changeActivite(int[] maxRepos, int toNbJour) {
        ChangementActivite tmp;
        Vector<ChangementActivite> activite = this.detail.getActivityChangeInfos();
        Vector<ChangementActivite> jour = new Vector<ChangementActivite>();
        int size = activite.size();
        int seuil = 0;
        TimsLogger.verbose("#sip.changeActivite# " + maxRepos[0] + " " + maxRepos[1] + " " + maxRepos[2]);
        ChangementActivite act = activite.get(seuil);
        while (act.getHeure() != maxRepos[1]) {
            act = activite.get(++seuil);
        }
        TimsLogger.verbose("#sip.changeActivite# on est a la fin du repos \u00e0 l'activit\u00e9 " + seuil);
        TimsLogger.verbose("#sip.changeActivite#");
        act.affiche();
        if (toNbJour == 1) {
            jour.add(this.parent.getActivity(4, 0));
        }
        int x = seuil;
        while (x < size) {
            tmp = activite.get(x);
            if (toNbJour == 1) {
                tmp.setDate(this.detail.getDateDebut());
            }
            jour.add(activite.get(x));
            if (toNbJour == 1 && tmp.getHeure() == maxRepos[0]) {
                TimsLogger.verbose("#sip.changeActivite# on arrete \u00e0 " + x + " => heure=heureDebuRepos=" + maxRepos[0]);
                break;
            }
            ++x;
        }
        x = 0;
        if (toNbJour == 2 && activite.get(0).getHeure() == 0) {
            ++x;
        }
        while (x < seuil) {
            tmp = activite.get(x);
            if (toNbJour == 2) {
                tmp.setHeure(tmp.getHeure() + 1440);
            }
            jour.add(tmp);
            if (toNbJour == 1 && tmp.getHeure() == maxRepos[0]) {
                TimsLogger.verbose("#sip.changeActivite# on arrete \u00e0 " + x + " => heure=heureDebuRepos=" + maxRepos[0]);
                break;
            }
            ++x;
        }
        this.detail.setHeureDebut(maxRepos[1]);
        this.detail.setHeureFin(maxRepos[0]);
        this.tpsReposJournalier = maxRepos[2];
        return jour;
    }

    Color getColor(int phase) {
        switch (phase) {
            case 4: {
                return Analyse.CouleurR;
            }
            case 3: {
                return Analyse.CouleurD;
            }
            case 2: {
                return Analyse.CouleurT;
            }
            case 1: {
                return Analyse.CouleurC;
            }
            case 6: {
                return Analyse.CouleurAA;
            }
            case 5: {
                return Analyse.CouleurDE;
            }
        }
        return Color.WHITE;
    }

    private int getHight(int cle) {
        switch (cle) {
            case 4: {
                return 4 * this.zoomFactor;
            }
            case 3: {
                return 8 * this.zoomFactor;
            }
            case 2: {
                return 12 * this.zoomFactor;
            }
            case 1: {
                return 16 * this.zoomFactor;
            }
            case 6: {
                return 10 * this.zoomFactor;
            }
            case 5: {
                return 10 * this.zoomFactor;
            }
        }
        return 0;
    }

    private long getXValue(int min, int R) {
        int value = min - this.ajustCirculaire;
        double alpha = Math.PI - (double)value * (Math.PI * 2) / 1440.0;
        long x = Math.round((double)R * Math.cos(alpha));
        return x;
    }

    private long getYValue(int min, int R) {
        int value = min - this.ajustCirculaire;
        double alpha = Math.PI - (double)value * (Math.PI * 2) / 1440.0;
        long y = Math.round((double)R * Math.sin(alpha));
        return y;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        int notches = event.getWheelRotation();
        int ratio = -notches;
        this.setZoomFactor(ratio);
    }

    public int debFinFlag() {
        if (this.detail == null || this.detail.getHeureDebut() == 0 && this.detail.getHeureFin() == 1440) {
            return BORDER_NONE;
        }
        if (this.detail.getHeureDebut() != 0 && this.detail.getHeureFin() == 1440) {
            return BORDER_BEGIN;
        }
        if (this.detail.getHeureDebut() != 0 && this.detail.getHeureFin() != 1440) {
            return BORDER_ALL;
        }
        return BORDER_UNKNOW;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        int minute = this.getMinuteFromXY(event.getX(), event.getY());
        int rayon = this.getRayonFromXY(event.getX(), event.getY());
        TimsLogger.debug("clicked at minute " + minute + " rayon " + rayon);
        if (rayon >= this.getDebutZoneAnalyse() / 2 - 20 && rayon <= (this.getDebutZoneAnalyse() + this.getAnalysisSize()) / 2 + 40 * this.zoomFactor) {
            if (!this.detail.isAnalyzed()) {
                if (event.getButton() == 1) {
                    if (this.debFinFlag() == BORDER_NONE) {
                        this.parent.setHeureDebut(minute);
                    } else if (this.debFinFlag() == BORDER_BEGIN) {
                        this.parent.setHeureFin(false, minute);
                    } else {
                        this.parent.setHeureFin(false, 10000);
                        this.parent.setHeureDebut(10000);
                    }
                }
                this.calqueActivite.repaint();
            } else if (ConnexionSettings.getInstance().isModifiable("SCAN")) {
                if (this.mode == MODE_ACTIVITE) {
                    boolean twoDayBeforeChange = this.detail.isAnalyzedTwoDays();
                    try {
                        if (event.getButton() == 1) {
                            this.detail.addChange(minute, this.parent.getActSelected());
                        }
                        if (event.getButton() == 3) {
                            this.detail.deleteChange(minute);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(this.parent, LanguageTranslator.getString("message.detailedError", ex.getMessage()), LanguageTranslator.getString("message.numberedError", "0"), 2);
                    }
                    TimsLogger.verbose("new (before adjusting) : ");
                    int y = 0;
                    while (y < this.detail.getActivityChangeInfos().size()) {
                        this.detail.getActivityChangeInfos().get(y).affiche();
                        ++y;
                    }
                    if (!this.detail.isSetBeginEndByUser()) {
                        TimsLogger.verbose("#Sip.mouseClicked# on ajuste (detail.isSetBeginEndByUser() " + this.detail.isSetBeginEndByUser() + ")");
                        this.automaticAdjust(twoDayBeforeChange);
                    } else {
                        TimsLogger.verbose("#Sip.mouseClicked# Cadr\u00e9 par l'utilisateur,  on n'ajuste pas (detail.isSetBeginEndByUser() " + this.detail.isSetBeginEndByUser() + ")");
                    }
                    y = 0;
                    while (y < this.detail.getActivityChangeInfos().size()) {
                        this.detail.getActivityChangeInfos().get(y).affiche();
                        ++y;
                    }
                    this.refreshParent();
                    this.calqueActivite.repaint();
                } else if (this.mode == MODE_VEHICULE) {
                    int column = this.parent.getPnlVehiculeConducteur().getTableVehicule().getSelectedColumn();
                    if (column != 2 && column != 4) {
                        JOptionPane.showMessageDialog(this, LanguageTranslator.getString("scan.vehicle.error"));
                    } else {
                        this.parent.getPnlVehiculeConducteur().getModeleTableVehicule().setValueAt(ConversionTime.heureIntToString(minute, "h"), this.parent.getPnlVehiculeConducteur().getTableVehicule().getSelectedRow(), column);
                        this.calqueActivite.repaint();
                    }
                }
            }
        } else if (rayon >= this.getSpeedLimitZone() && rayon < this.getMaxSpeedLimitZone()) {
            if (event.getButton() == 1) {
                TimsLogger.debug("new speed clic (left) at " + minute + " rayon " + rayon + "(" + this.speedBegin + "," + this.speedEnd + "," + this.speedMax + ")");
                if (this.speedBegin == -1) {
                    this.speedBegin = minute;
                } else if (this.speedEnd == -1) {
                    this.speedEnd = minute;
                } else if (this.speedMax == -1) {
                    this.speedMax = (int)((float)(rayon - this.getActivityCircle() / 2) / this.kmPerPoint);
                    this.detail.addSpeed(this.speedBegin, this.speedEnd, this.speedMax);
                    this.speedBegin = -1;
                    this.speedEnd = -1;
                    this.speedMax = -1;
                }
                this.calqueActivite.repaint();
            } else if (event.getButton() == 3) {
                TimsLogger.debug("new speed clic (right) at " + minute + " rayon " + rayon + "(" + this.speedBegin + "," + this.speedEnd + "," + this.speedMax + ")");
                if (this.speedBegin == -1) {
                    int size = this.detail.getSpeed().size();
                    if (size > 0) {
                        this.detail.getSpeed().remove(this.detail.getSpeed().size() - 1);
                    }
                } else {
                    this.speedBegin = -1;
                    this.speedEnd = -1;
                    this.speedMax = -1;
                }
                this.calqueActivite.repaint();
            }
        }
    }

    public void refreshParent() {
        this.parent.majHoraire();
        this.parent.reloadFrais();
        this.parent.cumul();
        this.parent.ecrireLabel();
        this.parent.getPnlVehiculeConducteur().commit();
    }

    public void automaticAdjust(boolean twoDayBeforeChange) {
        int[] maxRepos = this.getMaxRepos();
        TimsLogger.verbose("#AutoAdjust#" + maxRepos[0] + " " + maxRepos[1] + " " + maxRepos[2] + " != ? " + this.tpsReposJournalier + " 2 jours : " + twoDayBeforeChange);
        if (maxRepos[2] != this.tpsReposJournalier) {
            if (twoDayBeforeChange && maxRepos[0] > maxRepos[1]) {
                TimsLogger.verbose("#Sip.automaticAdjust# on passe a 1 jour");
                this.detail.setActivityChangeInfos(this.changeActivite(maxRepos, 1));
            }
            if (!twoDayBeforeChange && maxRepos[0] < maxRepos[1] && maxRepos[0] != 0) {
                TimsLogger.verbose("#Sip.automaticAdjust# on passe a 2 jours");
                this.detail.setActivityChangeInfos(this.changeActivite(maxRepos, 2));
            }
        }
    }

    public int getMinuteFromXY(int x, int y) {
        int minute = 0;
        double angle = Math.atan2(this.getAdjustedYCenter() - y, x - this.getAdjustedXCenter()) / Math.PI;
        minute = 1440 - (int)Math.round((1.0 + angle) * 720.0);
        int retour = (minute + this.ajustCirculaire) % 1440;
        if (retour < 0) {
            retour += 1440;
        }
        return retour;
    }

    public double getDegre(int x, int y) {
        TimsLogger.verbose("#SIP.getDegre# on cherche le degr\u00e9 ou se situe le point (" + x + "," + y + ") ");
        double angle = Math.atan2(this.getAdjustedYCenter() - y, x - this.getAdjustedXCenter());
        double degre = angle * 180.0 / Math.PI;
        degre = (degre + 360.0) % 360.0;
        return degre;
    }

    public int getRayonFromXY(int x, int y) {
        int rayon = 0;
        double angle = Math.atan2(this.getAdjustedYCenter() - y, x - this.getAdjustedXCenter());
        rayon = x == this.getAdjustedXCenter() ? this.getAdjustedYCenter() - y : (int)Math.abs(Math.round((double)(x - this.getAdjustedXCenter()) / Math.cos(angle)));
        return rayon;
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        int minute = this.getMinuteFromXY(event.getX(), event.getY());
        this.calqueActivite.setToolTipText(ConversionTime.heureIntToString(minute, "h"));
    }

    public void initSelectedArea() {
        this.selectedArea = new Rectangle();
    }

    public void setSelectedArea(Rectangle selectedArea) {
        this.selectedArea = selectedArea;
        this.repaint();
    }

    public Rectangle getSelectedArea() {
        return this.selectedArea;
    }

    public void setVehicule(VehicleUsed tmp) {
        this.current = tmp;
        this.calqueActivite.repaint();
    }

    private void draw360(Graphics2D g2D) {
        Long x0 = new Long(this.getAdjustedXCenter());
        Long y0 = new Long(this.getAdjustedYCenter());
        int x = 0;
        while (x < 360) {
            Long x1 = new Long(this.getXValue(x * 4, this.getSpeedCircle() / 2 + 50) + (long)this.getAdjustedXCenter());
            Long y1 = new Long((long)this.getAdjustedYCenter() - this.getYValue(x * 1440 / 360, this.getSpeedCircle() / 2 + 50));
            g2D.drawLine(x0.intValue(), y0.intValue(), x1.intValue(), y1.intValue());
            ++x;
        }
    }

    private void drawArrondi(ChangementActivite tmp, ChangementActivite tmp1, Graphics2D g2D) {
        float angle;
        float debut;
        g2D.setColor(this.getColor(tmp.getTypeActivite()));
        float rayon = 0.0f;
        float rayon1 = 0.0f;
        Long x = new Long(this.getXValue(tmp.getHeure(), this.getDebutZoneAnalyse() / 2) + (long)this.getAdjustedXCenter());
        Long y = new Long((long)this.getAdjustedYCenter() - this.getYValue(tmp.getHeure(), this.getDebutZoneAnalyse() / 2));
        rayon = (float)this.getDegre(x.intValue(), y.intValue());
        if (tmp1 != null) {
            Long x1 = new Long(this.getXValue(tmp1.getHeure(), this.getDebutZoneAnalyse() / 2) + (long)this.getAdjustedXCenter());
            Long y1 = new Long((long)this.getAdjustedYCenter() - this.getYValue(tmp1.getHeure(), this.getDebutZoneAnalyse() / 2));
            rayon1 = (float)this.getDegre(x1.intValue(), y1.intValue());
            if (rayon1 > rayon) {
                debut = rayon;
                angle = rayon1 - 360.0f - rayon;
            } else {
                debut = rayon;
                angle = rayon1 - rayon;
            }
        } else if (rayon < 180.0f) {
            debut = rayon;
            angle = -(180.0f + rayon);
        } else {
            debut = rayon;
            angle = 180.0f - rayon;
        }
        int rayonCourbe = 60 * this.zoomFactor;
        g2D.setStroke(new BasicStroke(6.0f));
        Arc2D.Float arc = new Arc2D.Float(this.getAdjustedXActivityCircle() + rayonCourbe, this.getAdjustedYActivityCircle() + rayonCourbe, this.getActivityCircle() - 2 * rayonCourbe, this.getActivityCircle() - 2 * rayonCourbe, debut, angle, 0);
        g2D.draw(arc);
        g2D.setStroke(new BasicStroke(1.0f));
    }

    private void drawFlagActivite(ChangementActivite tmp, Graphics2D g2D) {
        int ajoutDiametre = this.getHight(tmp.getTypeActivite());
        g2D.setColor(this.getColor(tmp.getTypeActivite()));
        Long x0 = new Long(this.getXValue(tmp.getHeure(), this.getDebutZoneAnalyse() / 2) + (long)this.getAdjustedXCenter());
        Long y0 = new Long((long)this.getAdjustedYCenter() - this.getYValue(tmp.getHeure(), this.getDebutZoneAnalyse() / 2));
        Long x1 = new Long(this.getXValue(tmp.getHeure(), this.getDebutZoneAnalyse() / 2 + this.getAnalysisSize() + 3 + ajoutDiametre) + (long)this.getAdjustedXCenter());
        Long y1 = new Long((long)this.getAdjustedYCenter() - this.getYValue(tmp.getHeure(), this.getDebutZoneAnalyse() / 2 + this.getAnalysisSize() + 3 + ajoutDiametre));
        g2D.drawLine(x0.intValue(), y0.intValue(), x1.intValue(), y1.intValue());
        g2D.fillOval(x1.intValue() - 2, y1.intValue() - 2, 8, 8);
    }

    private void drawFlag(Graphics2D g2D, int minute, Color color) {
        g2D.setColor(color);
        Long x0 = new Long(this.getXValue(minute, this.getDebutZoneAnalyse() / 2) + (long)this.getAdjustedXCenter());
        Long y0 = new Long((long)this.getAdjustedYCenter() - this.getYValue(minute, this.getDebutZoneAnalyse() / 2));
        Long x1 = new Long(this.getXValue(minute, this.getDebutZoneAnalyse() / 2 + this.getAnalysisSize() + 30) + (long)this.getAdjustedXCenter());
        Long y1 = new Long((long)this.getAdjustedYCenter() - this.getYValue(minute, this.getDebutZoneAnalyse() / 2 + this.getAnalysisSize() + 30));
        g2D.drawLine(x0.intValue(), y0.intValue(), x1.intValue(), y1.intValue());
        g2D.fillOval(x1.intValue(), y1.intValue(), 10, 10);
    }

    private void drawSpeed(Graphics2D g2D, int begin, int end, int maxHeight) {
        int flagHeight = 15 * this.zoomFactor;
        g2D.setStroke(new BasicStroke(2.0f));
        if (begin != -1) {
            Long x0 = new Long(this.getXValue(begin, this.getSpeedCircle() / 2) + (long)this.getAdjustedXCenter());
            Long y0 = new Long((long)this.getAdjustedYCenter() - this.getYValue(begin, this.getSpeedCircle() / 2));
            Long x1 = new Long(this.getXValue(begin, this.getSpeedCircle() / 2 + flagHeight) + (long)this.getAdjustedXCenter());
            Long y1 = new Long((long)this.getAdjustedYCenter() - this.getYValue(begin, this.getSpeedCircle() / 2 + flagHeight));
            g2D.drawLine(x0.intValue(), y0.intValue(), x1.intValue(), y1.intValue());
            if (end != -1) {
                Long x20 = new Long(this.getXValue(end, this.getSpeedCircle() / 2) + (long)this.getAdjustedXCenter());
                Long y20 = new Long((long)this.getAdjustedYCenter() - this.getYValue(end, this.getSpeedCircle() / 2));
                Long x21 = new Long(this.getXValue(end, this.getSpeedCircle() / 2 + flagHeight) + (long)this.getAdjustedXCenter());
                Long y21 = new Long((long)this.getAdjustedYCenter() - this.getYValue(end, this.getSpeedCircle() / 2 + flagHeight));
                g2D.drawLine(x20.intValue(), y20.intValue(), x21.intValue(), y21.intValue());
                if (maxHeight != -1) {
                    this.drawSpeedArrondi(g2D, x1.intValue(), y1.intValue(), x21.intValue(), y21.intValue(), maxHeight);
                }
            }
        }
        g2D.setStroke(new BasicStroke(1.0f));
    }

    private void drawSpeedArrondi(Graphics2D g2D, int x, int y, int x1, int y1, int maxHeight) {
        float degree = (float)this.getDegre(x, y);
        float degree2 = (float)this.getDegre(x1, y1);
        float debut = 0.0f;
        float angle = 0.0f;
        debut = degree;
        angle = degree2 > degree ? degree2 - 360.0f - degree : degree2 - degree;
        x = this.getAdjustedXSpeedCircle() + (this.getSpeedCircle() / 2 - maxHeight);
        y = this.getAdjustedYSpeedCircle() + (this.getSpeedCircle() / 2 - maxHeight);
        Arc2D.Float arc = new Arc2D.Float(x, y, maxHeight * 2, maxHeight * 2, debut, angle, 0);
        g2D.draw(arc);
    }

    class CPixel {
        boolean blanc;

        CPixel(int r, int g, int b) {
            int average = (r + g + b) / 3;
            this.blanc = average >= 150;
        }

        boolean isWhite() {
            return this.blanc;
        }

        CPixel() {
            this(-1, -1, -1);
        }
    }

    public class LblActivite
    extends JLabel {
        private static final long serialVersionUID = 1L;

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (ScrollableImagePane.this.mode == MODE_VEHICULE) {
                this.paintVehicle(g);
            } else {
                this.paintActivity(g);
            }
        }

        private void paintActivity(Graphics g) {
            if (ScrollableImagePane.this.debFinFlag() == BORDER_BEGIN || ScrollableImagePane.this.debFinFlag() == BORDER_ALL) {
                ScrollableImagePane.this.drawFlag((Graphics2D)g, ScrollableImagePane.this.detail.getHeureDebut(), Color.YELLOW);
            }
            if (ScrollableImagePane.this.debFinFlag() == BORDER_ALL) {
                ScrollableImagePane.this.drawFlag((Graphics2D)g, ScrollableImagePane.this.detail.getHeureFin(), Color.ORANGE);
            }
            g.setColor(Color.RED);
            g.drawOval(ScrollableImagePane.this.getAdjustedXActivityCircle(), ScrollableImagePane.this.getAdjustedYActivityCircle(), ScrollableImagePane.this.getActivityCircle(), ScrollableImagePane.this.getActivityCircle());
            if (ScrollableImagePane.this.detail.isAnalyzed()) {
                Vector<ChangementActivite> tmp = ScrollableImagePane.this.detail.getActivityChangeInfos();
                int x = 0;
                while (x < tmp.size()) {
                    ScrollableImagePane.this.drawFlagActivite(tmp.get(x), (Graphics2D)g);
                    if (x != tmp.size() - 1) {
                        ScrollableImagePane.this.drawArrondi(tmp.get(x), tmp.get(x + 1), (Graphics2D)g);
                    } else if (!ScrollableImagePane.this.detail.isAnalyzedTwoDays()) {
                        ScrollableImagePane.this.drawArrondi(tmp.get(x), null, (Graphics2D)g);
                    } else {
                        ScrollableImagePane.this.drawArrondi(tmp.get(x), tmp.get(0), (Graphics2D)g);
                    }
                    ++x;
                }
            } else {
                ScrollableImagePane.this.drawReference((Graphics2D)g);
                ScrollableImagePane.this.fillCircle(Color.LIGHT_GRAY, Color.WHITE, ScrollableImagePane.this.getAdjustedXCenter() - ScrollableImagePane.this.getDebutZoneAnalyse() / 2, ScrollableImagePane.this.getAdjustedYCenter() - ScrollableImagePane.this.getDebutZoneAnalyse() / 2, ScrollableImagePane.this.getDebutZoneAnalyse(), ScrollableImagePane.this.getDebutZoneAnalyse(), (Graphics2D)g);
            }
            if (ScrollableImagePane.this.speedEnabled) {
                g.setColor(Color.GREEN);
                g.drawOval(ScrollableImagePane.this.getAdjustedXSpeedCircle(), ScrollableImagePane.this.getAdjustedYSpeedCircle(), ScrollableImagePane.this.getSpeedCircle(), ScrollableImagePane.this.getSpeedCircle());
                g.setColor(Color.ORANGE);
                for (UevSpeed toDraw : ScrollableImagePane.this.detail.getSpeed()) {
                    String sBeginHour = ConversionTime.dateToString(toDraw.getDateDebut(), "HH:mm");
                    String sEndHour = ConversionTime.dateToString(toDraw.getDateFin(), "HH:mm");
                    int beginHour = ConversionTime.heureStringToInt(sBeginHour, ":");
                    int endHour = ConversionTime.heureStringToInt(sEndHour, ":");
                    TimsLogger.verbose("#SIP.paintActivity# (" + sBeginHour + "," + sEndHour + "," + toDraw.getVitesseMax() + ")");
                    ScrollableImagePane.this.drawSpeed((Graphics2D)g, beginHour, endHour, (int)((float)toDraw.getVitesseMax() * ScrollableImagePane.this.kmPerPoint + (float)(ScrollableImagePane.this.getActivityCircle() / 2)));
                }
                g.setColor(Color.RED.brighter().brighter());
                ScrollableImagePane.this.drawSpeed((Graphics2D)g, ScrollableImagePane.this.speedBegin, ScrollableImagePane.this.speedEnd, ScrollableImagePane.this.speedMax);
            }
        }

        private void paintVehicle(Graphics g) {
            if (ScrollableImagePane.this.debFinFlag() == BORDER_BEGIN || ScrollableImagePane.this.debFinFlag() == BORDER_ALL) {
                ScrollableImagePane.this.drawFlag((Graphics2D)g, ScrollableImagePane.this.detail.getHeureDebut(), Color.YELLOW);
            }
            if (ScrollableImagePane.this.debFinFlag() == BORDER_ALL) {
                ScrollableImagePane.this.drawFlag((Graphics2D)g, ScrollableImagePane.this.detail.getHeureFin(), Color.ORANGE);
            }
            g.setColor(Color.BLUE);
            g.drawOval(ScrollableImagePane.this.getAdjustedXActivityCircle(), ScrollableImagePane.this.getAdjustedYActivityCircle(), ScrollableImagePane.this.getActivityCircle(), ScrollableImagePane.this.getActivityCircle());
            if (ScrollableImagePane.this.detail.isAnalyzed() && ScrollableImagePane.this.current != null) {
                int debut = ConversionTime.getMinut(ScrollableImagePane.this.current.getDateDebut());
                int fin = ConversionTime.getMinut(ScrollableImagePane.this.current.getDateFin());
                ScrollableImagePane.this.drawFlag((Graphics2D)g, debut, Color.RED);
                ScrollableImagePane.this.drawFlag((Graphics2D)g, fin, Color.RED);
            } else {
                ScrollableImagePane.this.drawReference((Graphics2D)g);
                ScrollableImagePane.this.fillCircle(Color.LIGHT_GRAY, Color.WHITE, ScrollableImagePane.this.getAdjustedXCenter() - ScrollableImagePane.this.getDebutZoneAnalyse() / 2, ScrollableImagePane.this.getAdjustedYCenter() - ScrollableImagePane.this.getDebutZoneAnalyse() / 2, ScrollableImagePane.this.getDebutZoneAnalyse(), ScrollableImagePane.this.getDebutZoneAnalyse(), (Graphics2D)g);
            }
            if (ScrollableImagePane.this.speedEnabled) {
                g.setColor(Color.GREEN.darker().darker());
                g.drawOval(ScrollableImagePane.this.getAdjustedXSpeedCircle(), ScrollableImagePane.this.getAdjustedYSpeedCircle(), ScrollableImagePane.this.getSpeedCircle(), ScrollableImagePane.this.getSpeedCircle());
            }
        }
    }
}

