/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.scan;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import transpo.system.ui.resources.i18n.LanguageTranslator;

class SelectSource
extends JDialog {
    private static final long serialVersionUID = 1L;
    private String srcName;
    private boolean canceled;

    SelectSource(JFrame f, String defSrcName, Vector<String> src) {
        super(f, LanguageTranslator.getString("scan.select"), true);
        Vector<String> srcNames = src;
        JPanel pnlJsp = new JPanel();
        JPanel pnlBtn = new JPanel();
        JButton btnValid = new JButton(LanguageTranslator.getString("button.valid"));
        JButton btnQuit = new JButton(LanguageTranslator.getString("button.quit"));
        final JList<String> list = new JList<String>(srcNames);
        final JCheckBox cbPref = new JCheckBox(LanguageTranslator.getString("preference.save"));
        cbPref.setToolTipText(LanguageTranslator.getString("preference.explaination"));
        this.getRootPane().setDefaultButton(btnValid);
        this.addCancelByEscapeKey();
        list.setSelectionMode(0);
        if (srcNames.size() != 0) {
            list.setSelectedValue(defSrcName, true);
        }
        pnlJsp.add(new JScrollPane(list));
        pnlBtn.setLayout(new FlowLayout(2));
        pnlBtn.add(btnValid);
        pnlBtn.add(btnQuit);
        btnValid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectSource.this.canceled = false;
                SelectSource.this.srcName = (String)list.getSelectedValue();
                if (cbPref.isSelected()) {
                    Preferences prefs = Preferences.userRoot().node("TIMS");
                    prefs.put("preference.scanner", SelectSource.this.srcName);
                }
                SelectSource.this.dispose();
            }
        });
        btnQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectSource.this.canceled = true;
                SelectSource.this.dispose();
            }
        });
        this.getContentPane().add((Component)cbPref, "North");
        this.getContentPane().add((Component)pnlJsp, "Center");
        this.getContentPane().add((Component)pnlBtn, "South");
        this.pack();
        this.setLocationRelativeTo(f);
    }

    String getSrcName() {
        return this.srcName;
    }

    boolean isCanceled() {
        return this.canceled;
    }

    private void addCancelByEscapeKey() {
        String CANCEL_ACTION_KEY = "CANCEL_ACTION_KEY";
        int noModifiers = 0;
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, noModifiers, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(escapeKey, CANCEL_ACTION_KEY);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectSource.this.canceled = true;
                SelectSource.this.dispose();
            }
        };
        this.getRootPane().getActionMap().put(CANCEL_ACTION_KEY, cancelAction);
    }
}

