/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.tree;

import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.ElementArbre;
import fr.pgh.data.bdd.Region;
import fr.pgh.data.bdd.Vehicule;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.views.tree.TreeMainModel;
import transpo.system.ui.views.tree.TreeMouseListener;
import transpo.system.ui.views.tree.TreeNodeRenderer;

public class ArbreDonnees
extends JTree {
    public static final int ARBRE_CONDUCTEUR = 1;
    public static final int ARBRE_VEHICULE = 2;
    private ElementArbre selected = null;
    private TreePath selectedTreePath = null;
    public static int typeAffichage = 1;
    private static ArbreDonnees appli = null;

    public static ArbreDonnees getInstance() {
        if (appli == null) {
            appli = new ArbreDonnees();
        }
        return appli;
    }

    public ArbreDonnees() {
        this.setDragEnabled(true);
        this.setEditable(false);
        this.setRootVisible(true);
        this.setExpandsSelectedPaths(true);
        this.setShowsRootHandles(true);
        this.getSelectionModel().setSelectionMode(1);
        typeAffichage = 1;
        this.setModel(new TreeMainModel());
        this.setCellRenderer(new TreeNodeRenderer());
        this.addMouseListener(new TreeMouseListener());
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ArbreDonnees.this.loadPanelPrincipal();
            }
        });
    }

    public void setSelectionPath(ElementArbre selected) {
    }

    @Override
    public void setSelectionPath(TreePath path) {
        TimsLogger.verbose("#Arbredonnees.setSelectionPath# path to select = " + path);
        super.setSelectionPath(path);
    }

    public void setArchivage() {
        this.selected = null;
        ((TreeMainModel)this.getModel()).changeArchivage();
    }

    public void setType(int type) {
        this.selected = null;
        typeAffichage = type;
        ((TreeMainModel)this.getModel()).buildTree(null);
        this.repaint();
    }

    public int getType() {
        return typeAffichage;
    }

    private void loadPanelPrincipal() {
        DefaultMutableTreeNode leNoeud = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (leNoeud == null) {
            return;
        }
        if (leNoeud.getParent() == null) {
            MainFrameTransport.getInstance().afficheAccueil();
        } else {
            this.selectedTreePath = this.getSelectionPath();
            this.selected = (ElementArbre)leNoeud.getUserObject();
            TimsLogger.debug("#ArbreDonnees.loadPanelPrincipal# selected = " + this.selected + " : " + this.selected.getCle() + " (" + this.selected.getClass() + ") => selection path = " + this.getSelectionModel().getSelectionPath());
            if (this.selected instanceof Region) {
                TimsLogger.debug("Region selected.getCle() = " + this.selected.getCle());
                MainFrameTransport.getInstance().afficheRegion(this.selected.getCle());
            } else if (this.selected instanceof Agence) {
                MainFrameTransport.getInstance().afficheAgence(this.selected.getCle());
            } else if (this.selected instanceof Conducteur) {
                MainFrameTransport.getInstance().afficheConducteur(this.selected.getCle());
            } else if (this.selected instanceof Vehicule) {
                MainFrameTransport.getInstance().afficheVehicule((Vehicule)this.selected);
            }
        }
    }

    public void updateValues(String filter) {
        if ("".equals(filter)) {
            filter = null;
        }
        if (this.selected != null) {
            TimsLogger.debug("#ArbreDonnees.updateValues# selected (before update) = " + this.selected + " : " + this.selected.getCle() + " (" + this.selected.getClass() + ") => selection path = " + this.getSelectionModel().getSelectionPath());
        }
        try {
            ((TreeMainModel)this.getModel()).buildTree(filter);
            if (this.selected != null) {
                TimsLogger.debug("#ArbreDonnees.updateValues# selected (after update) = " + this.selected + " : " + this.selected.getCle() + " (" + this.selected.getClass() + ")");
            }
        }
        catch (Exception e) {
            TimsLogger.warn("change update  : " + e);
        }
    }

    public ElementArbre getSelected() {
        return this.selected;
    }

    public void expandAll() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.expandRow(i);
            ++i;
        }
    }
}

