/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.tree;

import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Pays;
import fr.pgh.data.bdd.Region;
import fr.pgh.data.bdd.Vehicule;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.tree.ArbreDonnees;

public class TreeMainModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 1L;
    static DefaultMutableTreeNode root = new DefaultMutableTreeNode(Transport.bdd.getCompany().getNomSociete());
    protected boolean afficheArchivage = false;

    public TreeMainModel() {
        super(root);
    }

    public void changeArchivage() {
        this.afficheArchivage = !this.afficheArchivage;
        this.buildTree(null);
    }

    protected void buildTree(String filter) {
        DefaultMutableTreeNode rtn;
        Transport.ps.startOperation();
        long startgeneral = System.currentTimeMillis();
        Hashtable<Pays, DefaultMutableTreeNode> countriesTable = new Hashtable<Pays, DefaultMutableTreeNode>();
        Hashtable<Region, DefaultMutableTreeNode> regionsTable = new Hashtable<Region, DefaultMutableTreeNode>();
        Hashtable<Agence, DefaultMutableTreeNode> agenciesTable = new Hashtable<Agence, DefaultMutableTreeNode>();
        root.setUserObject(Transport.bdd.getCompany().getNomSociete());
        root.removeAllChildren();
        boolean showRegion = Integer.parseInt(System.getProperty("show_region", "0")) == 1;
        boolean showCountry = Integer.parseInt(System.getProperty("show_country", "0")) == 1;
        Vector<Region> regions = null;
        Region ghostRegion = null;
        if (showRegion) {
            regions = Region.loadList(0);
            for (Region region : regions) {
                long start = System.currentTimeMillis();
                DefaultMutableTreeNode rtn2 = (DefaultMutableTreeNode)regionsTable.get(region);
                if (rtn2 == null) {
                    rtn2 = new DefaultMutableTreeNode(region);
                }
                if (showCountry) {
                    Pays country = Pays.getPays(region.getCountryId());
                    DefaultMutableTreeNode ctn = (DefaultMutableTreeNode)countriesTable.get(country);
                    if (ctn == null) {
                        ctn = new DefaultMutableTreeNode(country);
                        countriesTable.put(country, ctn);
                        root.add(ctn);
                    }
                    regionsTable.put(region, rtn2);
                    ctn.add(rtn2);
                    continue;
                }
                regionsTable.put(region, rtn2);
                root.add(rtn2);
            }
            ghostRegion = new Region(0, LanguageTranslator.getString("generics.unknown"), "", 0);
            DefaultMutableTreeNode rtn3 = new DefaultMutableTreeNode(ghostRegion);
            regionsTable.put(ghostRegion, rtn3);
        } else {
            TimsLogger.debug("#TMM.buildTree()# show_region = 0");
        }
        Vector<Agence> agencies = Agence.getList();
        Agence ghostAgency = new Agence(0, LanguageTranslator.getString("generics.unknown"), "", 0);
        for (Agence agency : agencies) {
            long start = System.currentTimeMillis();
            long start2 = System.currentTimeMillis();
            DefaultMutableTreeNode atn = (DefaultMutableTreeNode)agenciesTable.get(agency);
            if (atn == null) {
                TimsLogger.debug("agency not found " + agency.getLibelle());
                atn = new DefaultMutableTreeNode(agency);
            }
            if (showRegion) {
                start = System.currentTimeMillis();
                Region r = Region.find(regions, agency.getRegionId());
                if (r == null) {
                    r = ghostRegion;
                }
                start = System.currentTimeMillis();
                DefaultMutableTreeNode rtn4 = (DefaultMutableTreeNode)regionsTable.get(r);
                if (rtn4 == null) {
                    TimsLogger.verbose("#TMM.buildTree()# R\u00e9gion non trouv\u00e9e dans l'arbre de donn\u00e9es " + agency.getRegionId());
                    continue;
                }
                start = System.currentTimeMillis();
                agenciesTable.put(agency, atn);
                rtn4.add(atn);
                continue;
            }
            if (showCountry) {
                start = System.currentTimeMillis();
                Pays country = Pays.getPays(agency.getClePays());
                start = System.currentTimeMillis();
                DefaultMutableTreeNode ctn = (DefaultMutableTreeNode)countriesTable.get(country);
                if (ctn == null) {
                    ctn = new DefaultMutableTreeNode(country);
                }
                start = System.currentTimeMillis();
                if (this.getIndexOfChild(root, ctn) == 0) {
                    countriesTable.put(country, ctn);
                    root.add(ctn);
                }
                agenciesTable.put(agency, atn);
                ctn.add(atn);
                continue;
            }
            agenciesTable.put(agency, atn);
            root.add(atn);
        }
        agenciesTable.put(ghostAgency, new DefaultMutableTreeNode(ghostAgency));
        if (ArbreDonnees.typeAffichage == 1) {
            Vector<Conducteur> drivers = null;
            drivers = filter == null ? Conducteur.getList() : Conducteur.loadList(filter, new Integer[0]);
            for (Conducteur driver : drivers) {
                DefaultMutableTreeNode atn;
                long start2 = System.currentTimeMillis();
                DefaultMutableTreeNode dtn = new DefaultMutableTreeNode(driver);
                Agence agency = Agence.find(agencies, driver.getCleAgence());
                if (agency == null) {
                    agency = ghostAgency;
                }
                if ((atn = (DefaultMutableTreeNode)agenciesTable.get(agency)) == null) {
                    atn = new DefaultMutableTreeNode(agency);
                }
                atn.add(dtn);
            }
        } else {
            Vector<Vehicule> vehicles = null;
            vehicles = filter == null ? Vehicule.loadList(0) : Vehicule.loadList(filter, true, new Integer[0]);
            for (Vehicule vehicle : vehicles) {
                DefaultMutableTreeNode atn;
                DefaultMutableTreeNode dtn = new DefaultMutableTreeNode(vehicle);
                Agence agency = Agence.find(agencies, vehicle.getAgencyId());
                if (agency == null) {
                    agency = ghostAgency;
                }
                if ((atn = (DefaultMutableTreeNode)agenciesTable.get(agency)) == null) {
                    atn = new DefaultMutableTreeNode(agency);
                }
                atn.add(dtn);
            }
        }
        DefaultMutableTreeNode atn = (DefaultMutableTreeNode)agenciesTable.get(ghostAgency);
        if (atn.getChildCount() != 0) {
            if (showRegion) {
                rtn = (DefaultMutableTreeNode)regionsTable.get(ghostRegion);
                rtn.add(atn);
            } else if (showCountry) {
                Pays country = Pays.getPays(ghostAgency.getClePays());
                DefaultMutableTreeNode ctn = (DefaultMutableTreeNode)countriesTable.get(country);
                if (ctn == null) {
                    ctn = new DefaultMutableTreeNode(country);
                }
                if (this.getIndexOfChild(root, ctn) == 0) {
                    countriesTable.put(country, ctn);
                    root.add(ctn);
                }
            } else {
                root.add(atn);
            }
        }
        if (showRegion && (rtn = (DefaultMutableTreeNode)regionsTable.get(ghostRegion)).getChildCount() != 0) {
            root.add(rtn);
        }
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "#TMM.buildTree()# time to load treemodel", "#TMM.buildTree()# time to load treemodel : %s");
        this.reload();
    }

    public DefaultMutableTreeNode seekNode(DefaultMutableTreeNode parent, Object toSeek, Class dataType) {
        int level = 0;
        DefaultMutableTreeNode tmp = parent;
        while (!tmp.getUserObject().getClass().equals(dataType)) {
            tmp = parent.getFirstLeaf();
            if (tmp != null) continue;
            return null;
        }
        level = tmp.getLevel();
        return null;
    }

    public void setRootName(String name) {
        root.setUserObject(name);
    }
}

