/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.tree;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Vehicule;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import transpo.system.LicenceManager;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.actions.Accident;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transport.report.MasterReport;

class TreeMouseListener
extends MouseInputAdapter {
    TreeMouseListener() {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 3) {
            TimsLogger.verbose("#TreeMouseListener.mouseClicked# clic 3 : ");
            JTree tree = (JTree)e.getSource();
            TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
            if (selPath == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            TimsLogger.debug("elt is " + node.getUserObject().getClass());
            JPopupMenu menu = new JPopupMenu();
            if (ConnexionSettings.getInstance().isConsultable("RAPPORT")) {
                JMenu report = new JMenu("\u00e9diter un rapport");
                Vector<Report> reports = Report.loadAccessible(ConnexionSettings.getInstance().user.getCleProfil());
                for (Report toAdd : reports) {
                    if (node.getUserObject() instanceof String || node.getUserObject() instanceof Conducteur && toAdd.getType() == 1 || node.getUserObject() instanceof Agence && toAdd.getType() == 1 || node.getUserObject() instanceof Vehicule && toAdd.getType() == 2) {
                        if (toAdd.getMinimumVersion() > LicenceManager.getInstance().level) continue;
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTime(ConversionTime.dateTruncate(new Date()));
                        cal.set(5, ((Calendar)cal).getActualMaximum(5));
                        JMenu reportMenu = new JMenu(toAdd.getCustomizedName());
                        int x = 0;
                        while (x < 12) {
                            Date end = cal.getTime();
                            cal.set(5, 1);
                            Date begin = cal.getTime();
                            ((Calendar)cal).add(5, -1);
                            JMenuItem month = new JMenuItem(ConversionTime.dateToString(begin, "MMMMM yyyy"));
                            month.addActionListener(new ReportMenuAction(toAdd, node, begin, end));
                            reportMenu.add(month);
                            ++x;
                        }
                        report.add(reportMenu);
                        continue;
                    }
                    if (!(node.getUserObject() instanceof String)) continue;
                    toAdd.getMinimumVersion();
                    int cfr_ignored_0 = LicenceManager.getInstance().level;
                }
                menu.add(report);
            }
            if (node.getUserObject() instanceof Conducteur && ConnexionSettings.getInstance().isModifiable("CONDUCTEUR")) {
                JMenuItem archive = new JMenuItem("archiver");
                menu.add(archive);
            }
            if (node.getUserObject() instanceof Conducteur || node.getUserObject() instanceof Agence || node.getUserObject() instanceof Vehicule) {
                int driverId = 0;
                int agencyId = 0;
                int vehicleId = 0;
                if (node.getUserObject() instanceof Agence) {
                    agencyId = ((Agence)node.getUserObject()).getCleAgence();
                }
                if (node.getUserObject() instanceof Conducteur) {
                    driverId = ((Conducteur)node.getUserObject()).getCleConducteur();
                }
                if (node.getUserObject() instanceof Vehicule) {
                    vehicleId = ((Vehicule)node.getUserObject()).getCleVehicule();
                }
                if (ConnexionSettings.getInstance().isAjoutable("ACCIDENT") && LicenceManager.isModuleEnable(LicenceManager.MODULE_ACCIDENT)) {
                    JMenuItem accidentAdd = new JMenuItem(LanguageTranslator.getString("accident.add"));
                    accidentAdd.addActionListener(new Accident(agencyId, driverId, vehicleId));
                    menu.add(accidentAdd);
                }
            }
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    class ReportMenuAction
    implements ActionListener {
        private Report toGenerate = null;
        private DefaultMutableTreeNode node = null;
        private Date begin = null;
        private Date end = null;

        public ReportMenuAction(Report toGenerate, DefaultMutableTreeNode node, Date begin, Date end) {
            this.toGenerate = toGenerate;
            this.node = node;
            this.begin = begin;
            this.end = end;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            new Thread(){

                @Override
                public void run() {
                    ProgressBar pb = new ProgressBar(MainFrameTransport.getInstance(), LanguageTranslator.getString("generics.loading"));
                    pb.setVisible(true);
                    Vector<Conducteur> driver = null;
                    Vector<Agence> agency = null;
                    Object elt = ReportMenuAction.this.node.getUserObject();
                    if (elt instanceof Agence) {
                        agency = new Vector<Agence>();
                        agency.add((Agence)elt);
                        driver = Conducteur.loadList(((Agence)elt).getCleAgence());
                    }
                    if (elt instanceof Conducteur) {
                        agency = new Vector();
                        agency.add(new Agence(((Conducteur)elt).getCleAgence()));
                        driver = new Vector();
                        driver.add((Conducteur)elt);
                    }
                    if (elt instanceof String) {
                        driver = Conducteur.loadList(new Integer[0]);
                    }
                    try {
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        if (System.getProperty("URL") != null) {
                            params.put("SERVEUR", System.getProperty("HOME_PATH"));
                        } else {
                            params.put("SERVEUR", "");
                        }
                        params.put("DATE_DEBUT", ConversionTime.dateToString(ReportMenuAction.this.begin, "dd/MM/yyyy"));
                        params.put("DATE_FIN", ConversionTime.dateToString(ReportMenuAction.this.end, "dd/MM/yyyy"));
                        params.put("NOM_SOC", agency != null ? ((Agence)agency.get(0)).getDescription() : "TOUTES");
                        params.put("BEGIN", ReportMenuAction.this.begin);
                        params.put("END", ReportMenuAction.this.end);
                        params.put("RESOLUTION", 1);
                        params.put("DETAIL", false);
                        params.put("BRUTE", "1");
                        params.put("RSE_OFF", "1");
                        params.put("DF_OFF", "1");
                        params.put("UEV_OFF", "1");
                        params.put("OUT", "\u00e9cran");
                        if (elt instanceof Conducteur) {
                            params.put("CLE_CH", String.valueOf(((Conducteur)elt).getCleConducteur()));
                            params.put("NOM_CH", ((Conducteur)elt).getNom());
                            params.put("PRENOM_CH", ((Conducteur)elt).getPrenom());
                        }
                        MasterReport mr = null;
                        if (!ReportMenuAction.this.toGenerate.getClassToLoad().equals("NONE")) {
                            Class<?> c = Class.forName(ReportMenuAction.this.toGenerate.getClassToLoad());
                            mr = (MasterReport)c.newInstance();
                        } else {
                            mr = new MasterReport();
                        }
                        mr.setValues(pb, ReportMenuAction.this.toGenerate, agency, driver, null, params);
                        mr.process();
                        pb.dispose();
                    }
                    catch (ClassNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace();
                    }
                    catch (InstantiationException ex) {
                        ex.printStackTrace();
                    }
                    catch (Exception ex) {
                        TimsLogger.warn("#PCA.printTbl()# error during report process");
                        ex.printStackTrace();
                    }
                }
            }.start();
        }
    }
}

