/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.tree;

import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Pays;
import fr.pgh.data.bdd.Region;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TreeNodeRenderer
implements TreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel lbl = new JLabel();
        lbl.setOpaque(true);
        lbl.setBackground(selected ? SystemColor.lightGray : tree.getBackground());
        Color col = Color.BLACK;
        Object obj = ((DefaultMutableTreeNode)value).getUserObject();
        if (obj instanceof Conducteur) {
            Conducteur val = (Conducteur)obj;
            int status = val.getStatus();
            if (status == 0) {
                col = MainFrameTransport.COLOR_OK_DEFAULT;
            } else if (status == 1) {
                col = MainFrameTransport.COLOR_ALERTE_DEFAULT;
            } else if (status == 2) {
                col = MainFrameTransport.COLOR_TOO_LATE_DEFAULT;
            } else if (status == 5) {
                col = val.getNumeroCarte() != null && !val.getNumeroCarte().equals("") ? Color.blue : Color.magenta;
            }
            lbl.setForeground(col);
            lbl.setText(val.getLibelle());
        } else if (obj instanceof Agence) {
            Agence val = (Agence)obj;
            lbl.setForeground(col);
            lbl.setText(val.getLibelle());
        } else if (obj instanceof Vehicule) {
            Vehicule val = (Vehicule)obj;
            int status = val.getStatus();
            if (status == 0) {
                col = MainFrameTransport.COLOR_OK_DEFAULT;
            } else if (status == 1) {
                col = MainFrameTransport.COLOR_ALERTE_DEFAULT;
            } else if (status == 2) {
                col = MainFrameTransport.COLOR_TOO_LATE_DEFAULT;
            } else if (status == 5) {
                col = Color.blue;
            }
            lbl.setForeground(col);
            lbl.setText(val.getLibelle());
        } else if (obj instanceof Region) {
            Region val = (Region)obj;
            lbl.setText(val.getLibelle());
        } else if (obj instanceof Pays) {
            Pays val = (Pays)obj;
            lbl.setText(val.getLibelle());
        } else {
            lbl.setText(obj == null ? LanguageTranslator.getString("generics.unknown") : obj.toString());
        }
        return lbl;
    }
}

