/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.vehicule;

import fr.pgh.component.JFittedComboBox;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.VehicleAffectation;
import fr.pgh.data.bdd.VehicleAnalyticCode;
import fr.pgh.data.bdd.VehicleBody;
import fr.pgh.data.bdd.VehicleModel;
import fr.pgh.data.bdd.VehicleType;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.CheckBoxBorder;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogCreationVehicule
extends JDialog
implements DataListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JTextField txtDesignation = null;
    private JLabel lblDesignation = null;
    private JLabel lblImmatriculation = null;
    private JTextField txtImmatriculation = null;
    private JLabel lblIdentification;
    private JTextField txtIdentificationNumber;
    private JTextField txtMarque = null;
    private JLabel lblMarque = null;
    private JLabel lblFamille = null;
    private JTextField txtFamille = null;
    private JLabel lblAchat = null;
    private JLabel lblSortie = null;
    private JTextField txtSortie = null;
    private JTextField txtEntree = null;
    private JLabel lblAgence = null;
    private JComboBox cbAgence = null;
    private JTextPane txtCommentaire = null;
    private JLabel lblCommentaire = null;
    private JPanel pnlButton = null;
    private JButton btnQuit = null;
    private JButton btnSave = null;
    private JPanel pnlDescription = null;
    private Vehicule toCreate = null;
    public boolean enregistrement = false;
    private JTextField txtGuarantee = null;
    private JLabel lblGuarantee = null;
    private JPanel pnlLocation = null;
    private JCheckBox cbLocation = null;
    private JLabel lblLocationPrice = null;
    private JTextField txtLocationPrice = null;
    private JLabel lblOwner = null;
    private JTextField txtOwner = null;
    private JLabel lblLength = null;
    private JTextField txtLocationLimit = null;
    private JLabel lblKmMaxi = null;
    private JTextField txtKm = null;
    private JLabel lblType = null;
    private JFittedComboBox cbType = null;
    private JButton btnAddType = null;
    private JLabel lblBody = null;
    private JFittedComboBox cbBody = null;
    private JButton btnAddBody = null;
    private JLabel lblAffectation = null;
    private JFittedComboBox cbAffectation = null;
    private JButton btnAddAffectation = null;
    private JLabel lblModel = null;
    private JFittedComboBox cbModel = null;
    private JButton btnAddModel = null;
    private JLabel lblAnalyticCode = null;
    private JFittedComboBox cbAnalyticCode = null;
    private JButton btnAddAnalyticCode = null;
    private ImageIcon imgAdd = null;

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        if (dataEvent instanceof BddEvent) {
            BddEvent e = (BddEvent)dataEvent;
            if (e.getTable().equals("t_agence")) {
                this.getCbAgence().setModel(new ComboBoxModel(Agence.getList(), false, null));
            }
            if (e.getTable().equals("VEHICLE_TYPE")) {
                this.getCbType().setModel(new ComboBoxModel(VehicleType.getList(), false, LanguageTranslator.getString("generics.none")));
            }
            if (e.getTable().equals("VEHICLE_AFFECTATION")) {
                this.getCbAffectation().setModel(new ComboBoxModel(VehicleAffectation.getList(), false, LanguageTranslator.getString("generics.none")));
            }
            if (e.getTable().equals("BODY_TYPE")) {
                this.getCbBody().setModel(new ComboBoxModel(VehicleBody.getList(), false, LanguageTranslator.getString("generics.none")));
            }
            if (e.getTable().equals("VEHICLE_ANALYTIC_CODE")) {
                this.getCbAnalyticCode().setModel(new ComboBoxModel(VehicleAnalyticCode.getList(), false, LanguageTranslator.getString("generics.none")));
            }
            if (e.getTable().equals("VEHICLE_MODEL")) {
                this.getCbModel().setModel(new ComboBoxModel(VehicleModel.getList(), false, LanguageTranslator.getString("generics.none")));
            }
        }
    }

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogCreationVehicule.dispose()#");
        super.dispose();
    }

    public DialogCreationVehicule(Frame owner, Vehicule toCreate) {
        super(owner);
        TimsLogger.verbose("#DialogCreationVehicule()#");
        this.toCreate = toCreate;
        this.initialize();
        Transport.bdd.addDataListener(this);
    }

    private void initialize() {
        this.setSize(600, 400);
        this.setModal(true);
        this.setTitle(LanguageTranslator.getString("vehicle.creation"));
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gcbPnlDescription = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, null);
            GridBagConstraints gcbPnlButton = Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 2, -1, null);
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.fill = 1;
            gridBagConstraints9.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints9.weighty = 1.0;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 0;
            gridBagConstraints16.gridwidth = 0;
            gridBagConstraints16.fill = 2;
            gridBagConstraints16.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints16.gridy = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlDescription(), gcbPnlDescription);
            this.jContentPane.add((Component)this.getPnlButton(), gcbPnlButton);
        }
        return this.jContentPane;
    }

    private ImageIcon getImgAdd() {
        if (this.imgAdd == null) {
            ClassLoader cl = this.getClass().getClassLoader();
            this.imgAdd = new ImageIcon(cl.getResource(Transport.res.getResourceString("icone_cliq")));
        }
        return this.imgAdd;
    }

    private JTextField getTxtDesignation() {
        if (this.txtDesignation == null) {
            this.txtDesignation = new JTextField();
        }
        return this.txtDesignation;
    }

    private JTextField getTxtImmatriculation() {
        if (this.txtImmatriculation == null) {
            this.txtImmatriculation = new JTextField();
            if (this.toCreate != null) {
                this.txtImmatriculation.setText(this.toCreate.getRegistrationNumber());
            }
        }
        return this.txtImmatriculation;
    }

    private JTextField getTxtMarque() {
        if (this.txtMarque == null) {
            this.txtMarque = new JTextField();
        }
        return this.txtMarque;
    }

    private JTextField getTxtFamille() {
        if (this.txtFamille == null) {
            this.txtFamille = new JTextField();
        }
        return this.txtFamille;
    }

    private JTextField getTxtSortie() {
        if (this.txtSortie == null) {
            this.txtSortie = new JTextField();
            this.txtSortie.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogCreationVehicule.this.getTxtSortie());
                }
            });
        }
        return this.txtSortie;
    }

    private JTextField getTxtEntree() {
        if (this.txtEntree == null) {
            this.txtEntree = new JTextField();
            this.txtEntree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogCreationVehicule.this.getTxtEntree());
                }
            });
        }
        return this.txtEntree;
    }

    private JComboBox getCbAgence() {
        if (this.cbAgence == null) {
            this.cbAgence = new JComboBox();
            this.cbAgence.setModel(new ComboBoxModel(Agence.getList(), false, null));
        }
        return this.cbAgence;
    }

    private JTextPane getTxtCommentaire() {
        if (this.txtCommentaire == null) {
            this.txtCommentaire = new JTextPane();
        }
        return this.txtCommentaire;
    }

    private JPanel getPnlButton() {
        if (this.pnlButton == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(5);
            flowLayout.setVgap(2);
            this.pnlButton = new JPanel();
            this.pnlButton.setLayout(flowLayout);
            this.pnlButton.add((Component)this.getBtnQuit(), null);
            this.pnlButton.add((Component)this.getBtnSave(), null);
        }
        return this.pnlButton;
    }

    private JButton getBtnQuit() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton();
            this.btnQuit.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogCreationVehicule.this.dispose();
                }
            });
        }
        return this.btnQuit;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setText(LanguageTranslator.getString("button.save"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogCreationVehicule.this.check()) {
                        DialogCreationVehicule.this.create();
                    }
                }
            });
        }
        return this.btnSave;
    }

    public boolean check() {
        boolean toReturn = true;
        if (this.getTxtImmatriculation().getText().equals("")) {
            this.getTxtImmatriculation().setBackground(new Color(255, 192, 203));
            this.getTxtImmatriculation().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtImmatriculation().setBackground(Color.white);
        }
        if (this.getTxtDesignation().getText().contains(" - ")) {
            this.getTxtDesignation().setBackground(new Color(255, 192, 203));
            this.getTxtDesignation().setToolTipText(LanguageTranslator.getString("vehicle.errorCode"));
            toReturn = false;
        } else {
            this.getTxtDesignation().setBackground(Color.white);
        }
        return toReturn;
    }

    private JPanel getPnlDescription() {
        if (this.pnlDescription == null) {
            boolean affectation = ConnexionSettings.getInstance().isAjoutable("VEHICLE_AFFECTATION");
            boolean body = ConnexionSettings.getInstance().isAjoutable("BODY");
            boolean model = ConnexionSettings.getInstance().isAjoutable("VEHICLE_MODEL");
            boolean type = ConnexionSettings.getInstance().isAjoutable("VEHICLE_TYPE");
            boolean analyticCode = ConnexionSettings.getInstance().isAjoutable("VEHICLE_ANALYTIC_CODE");
            GridBagConstraints gcbDesign = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.2, 0.0, -1, -1, null);
            GridBagConstraints gcbTxtDesign = Fonctions.getGridBagConstraints(1, 0, 1, 2, 1.0, 0.2, 2, -1, null);
            GridBagConstraints gcbImmat = Fonctions.getGridBagConstraints(3, 0, 1, 1, 0.2, 0.0, -1, -1, null);
            GridBagConstraints gcbTxtImmat = Fonctions.getGridBagConstraints(4, 0, 1, 2, 0.0, 0.0, 2, -1, null);
            GridBagConstraints gcbIdent = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, -1, -1, null);
            GridBagConstraints gcbTxtIdent = Fonctions.getGridBagConstraints(1, 1, 1, 2, 1.0, 0.2, 2, -1, null);
            GridBagConstraints gcbGuarantee = Fonctions.getGridBagConstraints(3, 1, 1, 1, 0.0, 0.0, -1, -1, null);
            GridBagConstraints gcbTxtGuarantee = Fonctions.getGridBagConstraints(4, 1, 1, 2, 0.0, 0.0, 2, -1, null);
            GridBagConstraints gcbBuy = Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, -1, -1, null);
            GridBagConstraints gcbTxtEntry = Fonctions.getGridBagConstraints(1, 3, 1, 2, 1.0, 0.2, 2, -1, null);
            GridBagConstraints gcbOut = Fonctions.getGridBagConstraints(3, 3, 1, 1, 0.0, 0.0, -1, -1, null);
            GridBagConstraints gcbTxtOut = Fonctions.getGridBagConstraints(4, 3, 1, 2, 1.0, 0.0, 2, -1, null);
            GridBagConstraints gcbBrand = Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.2, 0.0, -1, -1, null);
            GridBagConstraints gcbTxtBrand = Fonctions.getGridBagConstraints(1, 2, 1, 2, 1.0, 0.2, 2, -1, null);
            GridBagConstraints gcbFamily = Fonctions.getGridBagConstraints(3, 2, 1, 1, 0.0, 0.2, -1, -1, null);
            GridBagConstraints gcbTxtFamily = Fonctions.getGridBagConstraints(4, 2, 1, 2, 1.0, 0.0, 2, -1, null);
            GridBagConstraints gcbLblAgence = Fonctions.getGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, -1, -1, null);
            GridBagConstraints gcbTxtAgence = Fonctions.getGridBagConstraints(1, 4, 1, 2, 1.0, 0.0, 2, -1, null);
            GridBagConstraints gcbLblAffect = Fonctions.getGridBagConstraints(3, 4, 1, 1, 0.0, 0.2, -1, -1, null);
            GridBagConstraints gcbTxtAffect = Fonctions.getGridBagConstraints(4, 4, 1, 1, 1.0, 0.0, 2, -1, null);
            GridBagConstraints gcbBtnAffect = Fonctions.getGridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 0, -1, null);
            GridBagConstraints gcbLblType = Fonctions.getGridBagConstraints(0, 5, 1, 1, 0.0, 0.2, -1, -1, null);
            GridBagConstraints gcbTxtType = Fonctions.getGridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 2, -1, null);
            GridBagConstraints gcbBtnType = Fonctions.getGridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 0, -1, null);
            GridBagConstraints gcbLblBody = Fonctions.getGridBagConstraints(3, 5, 1, 1, 0.2, 0.0, -1, -1, null);
            GridBagConstraints gcbTxtBody = Fonctions.getGridBagConstraints(4, 5, 1, 1, 1.0, 0.2, 2, -1, null);
            GridBagConstraints gcbBtnBody = Fonctions.getGridBagConstraints(5, 5, 1, 1, 0.0, 0.0, 0, -1, null);
            GridBagConstraints gcbLblModel = Fonctions.getGridBagConstraints(0, 6, 1, 1, 0.0, 0.2, -1, -1, null);
            GridBagConstraints gcbTxtModel = Fonctions.getGridBagConstraints(1, 6, 1, model ? 1 : 2, 1.0, 0.0, 2, -1, null);
            GridBagConstraints gcbBtnModel = Fonctions.getGridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 0, -1, null);
            GridBagConstraints gcbLblAnaCode = Fonctions.getGridBagConstraints(3, 6, 1, 1, 0.0, 0.2, -1, -1, null);
            GridBagConstraints gcbTxtAnaCode = Fonctions.getGridBagConstraints(4, 6, 1, model ? 1 : 2, 1.0, 0.0, 2, -1, null);
            GridBagConstraints gcbBtnAnaCode = Fonctions.getGridBagConstraints(5, 6, 1, 1, 0.0, 0.0, 0, -1, null);
            GridBagConstraints gcbPnlLoc = Fonctions.getGridBagConstraints(0, 7, 1, 6, 1.0, 1.0, 1, -1, null);
            this.lblFamille = new JLabel(LanguageTranslator.getString("vehicle.category"));
            this.lblMarque = new JLabel(LanguageTranslator.getString("vehicle.brand"));
            this.lblImmatriculation = new JLabel(LanguageTranslator.getString("vehicle.registrationNumber"));
            this.lblDesignation = new JLabel(LanguageTranslator.getString("generics.designation"));
            this.lblGuarantee = new JLabel(LanguageTranslator.getString("generics.guarantee"));
            this.lblIdentification = new JLabel(LanguageTranslator.getString("vehicle.identificationNumber"));
            this.lblSortie = new JLabel(LanguageTranslator.getString("user.exitDate"));
            this.lblAchat = new JLabel(LanguageTranslator.getString("user.enterDate"));
            this.lblAgence = new JLabel(LanguageTranslator.getString("generics.agency"));
            this.lblBody = new JLabel(LanguageTranslator.getString("generics.body"));
            this.lblAffectation = new JLabel(LanguageTranslator.getString("generics.affectation"));
            this.lblType = new JLabel(LanguageTranslator.getString("generics.type"));
            this.lblModel = new JLabel(LanguageTranslator.getString("vehicle.model"));
            this.lblAnalyticCode = new JLabel(LanguageTranslator.getString("generics.analyticCode"));
            this.pnlDescription = new JPanel();
            this.pnlDescription.setLayout(new GridBagLayout());
            this.pnlDescription.add((Component)this.lblDesignation, gcbDesign);
            this.pnlDescription.add((Component)this.getTxtDesignation(), gcbTxtDesign);
            this.pnlDescription.add((Component)this.lblImmatriculation, gcbImmat);
            this.pnlDescription.add((Component)this.getTxtImmatriculation(), gcbTxtImmat);
            this.pnlDescription.add((Component)this.lblIdentification, gcbIdent);
            this.pnlDescription.add((Component)this.getTxtIdentificationNumber(), gcbTxtIdent);
            this.pnlDescription.add((Component)this.lblGuarantee, gcbGuarantee);
            this.pnlDescription.add((Component)this.getTxtGuarantee(), gcbTxtGuarantee);
            this.pnlDescription.add((Component)this.lblAchat, gcbBuy);
            this.pnlDescription.add((Component)this.getTxtEntree(), gcbTxtEntry);
            this.pnlDescription.add((Component)this.lblSortie, gcbOut);
            this.pnlDescription.add((Component)this.getTxtSortie(), gcbTxtOut);
            this.pnlDescription.add((Component)this.lblMarque, gcbBrand);
            this.pnlDescription.add((Component)this.getTxtMarque(), gcbTxtBrand);
            this.pnlDescription.add((Component)this.lblFamille, gcbFamily);
            this.pnlDescription.add((Component)this.getTxtFamille(), gcbTxtFamily);
            this.pnlDescription.add((Component)this.lblAgence, gcbLblAgence);
            this.pnlDescription.add((Component)this.getCbAgence(), gcbTxtAgence);
            this.pnlDescription.add((Component)this.lblAffectation, gcbLblAffect);
            this.pnlDescription.add((Component)this.getCbAffectation(), gcbTxtAffect);
            if (affectation) {
                this.pnlDescription.add((Component)this.getBtnAddAffectation(), gcbBtnAffect);
            }
            this.pnlDescription.add((Component)this.lblType, gcbLblType);
            this.pnlDescription.add((Component)this.getCbType(), gcbTxtType);
            if (type) {
                this.pnlDescription.add((Component)this.getBtnAddType(), gcbBtnType);
            }
            this.pnlDescription.add((Component)this.lblBody, gcbLblBody);
            this.pnlDescription.add((Component)this.getCbBody(), gcbTxtBody);
            if (body) {
                this.pnlDescription.add((Component)this.getBtnAddBody(), gcbBtnBody);
            }
            this.pnlDescription.add((Component)this.lblModel, gcbLblModel);
            this.pnlDescription.add((Component)this.getCbModel(), gcbTxtModel);
            if (model) {
                this.pnlDescription.add((Component)this.getBtnAddModel(), gcbBtnModel);
            }
            this.pnlDescription.add((Component)this.lblAnalyticCode, gcbLblModel);
            this.pnlDescription.add((Component)this.getCbAnalyticCode(), gcbTxtModel);
            if (model) {
                this.pnlDescription.add((Component)this.getBtnAddModel(), gcbBtnModel);
            }
            this.pnlDescription.add((Component)this.lblAnalyticCode, gcbLblAnaCode);
            this.pnlDescription.add((Component)this.getCbAnalyticCode(), gcbTxtAnaCode);
            if (analyticCode) {
                this.pnlDescription.add((Component)this.getBtnAddAnalyticCode(), gcbBtnAnaCode);
            }
            this.pnlDescription.add((Component)this.getPnlLocation(), gcbPnlLoc);
        }
        return this.pnlDescription;
    }

    private JFittedComboBox getCbBody() {
        if (this.cbBody == null) {
            this.cbBody = new JFittedComboBox();
            this.cbBody.setModel(new ComboBoxModel(VehicleBody.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbBody;
    }

    private JButton getBtnAddBody() {
        if (this.btnAddBody == null) {
            this.btnAddBody = new JButton();
            this.btnAddBody.setIcon(this.getImgAdd());
            this.btnAddBody.setPreferredSize(new Dimension(25, 25));
            this.btnAddBody.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Fonctions.define(VehicleBody.class);
                }
            });
        }
        return this.btnAddBody;
    }

    private JFittedComboBox getCbAffectation() {
        if (this.cbAffectation == null) {
            this.cbAffectation = new JFittedComboBox();
            this.cbAffectation.setModel(new ComboBoxModel(VehicleAffectation.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbAffectation;
    }

    private JButton getBtnAddAffectation() {
        if (this.btnAddAffectation == null) {
            this.btnAddAffectation = new JButton();
            this.btnAddAffectation.setIcon(this.getImgAdd());
            this.btnAddAffectation.setPreferredSize(new Dimension(25, 25));
            this.btnAddAffectation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Fonctions.define(VehicleAffectation.class);
                }
            });
        }
        return this.btnAddAffectation;
    }

    private JFittedComboBox getCbType() {
        if (this.cbType == null) {
            this.cbType = new JFittedComboBox();
            this.cbType.setModel(new ComboBoxModel(VehicleType.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbType;
    }

    private JButton getBtnAddType() {
        if (this.btnAddType == null) {
            this.btnAddType = new JButton();
            this.btnAddType.setIcon(this.getImgAdd());
            this.btnAddType.setPreferredSize(new Dimension(25, 25));
            this.btnAddType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Fonctions.define(VehicleType.class);
                }
            });
        }
        return this.btnAddType;
    }

    private JFittedComboBox getCbModel() {
        if (this.cbModel == null) {
            this.cbModel = new JFittedComboBox();
            this.cbModel.setModel(new ComboBoxModel(VehicleModel.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbModel;
    }

    private JFittedComboBox getCbAnalyticCode() {
        if (this.cbAnalyticCode == null) {
            this.cbAnalyticCode = new JFittedComboBox();
            this.cbAnalyticCode.setModel(new ComboBoxModel(VehicleAnalyticCode.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbAnalyticCode;
    }

    private JButton getBtnAddModel() {
        if (this.btnAddModel == null) {
            this.btnAddModel = new JButton();
            this.btnAddModel.setIcon(this.getImgAdd());
            this.btnAddModel.setPreferredSize(new Dimension(25, 25));
            this.btnAddModel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Fonctions.define(VehicleModel.class);
                }
            });
        }
        return this.btnAddModel;
    }

    private JButton getBtnAddAnalyticCode() {
        if (this.btnAddAnalyticCode == null) {
            this.btnAddAnalyticCode = new JButton();
            this.btnAddAnalyticCode.setIcon(this.getImgAdd());
            this.btnAddAnalyticCode.setPreferredSize(new Dimension(25, 25));
            this.btnAddAnalyticCode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Fonctions.define(VehicleAnalyticCode.class);
                }
            });
        }
        return this.btnAddAnalyticCode;
    }

    private JTextField getTxtIdentificationNumber() {
        if (this.txtIdentificationNumber == null) {
            this.txtIdentificationNumber = new JTextField();
            if (this.toCreate != null) {
                this.txtIdentificationNumber.setText(this.toCreate.getIdentificationNumber());
            }
        }
        return this.txtIdentificationNumber;
    }

    private void create() {
        if (this.toCreate == null) {
            this.toCreate = new Vehicule();
        }
        this.toCreate.setRegistrationNumber(this.getTxtImmatriculation().getText());
        this.toCreate.setDesignation(this.getTxtDesignation().getText());
        this.toCreate.setAgencyId(((ComboBoxModel)this.getCbAgence().getModel()).getSelectedCle());
        this.toCreate.setBrand(this.getTxtMarque().getText());
        this.toCreate.setCategory(this.getTxtFamille().getText());
        this.toCreate.setDateEntree(ConversionTime.dateFromFranceToBDD(this.getTxtEntree().getText(), false));
        this.toCreate.setDateSortie(ConversionTime.dateFromFranceToBDD(this.getTxtSortie().getText(), false));
        this.toCreate.setComment(this.getTxtCommentaire().getText());
        this.toCreate.setIdentificationNumber(this.getTxtIdentificationNumber().getText());
        this.toCreate.setGuarantee(ConversionTime.stringToDate(this.getTxtGuarantee().getText(), "dd/MM/yyyy"));
        this.toCreate.setTypeId(((ComboBoxModel)this.getCbType().getModel()).getSelectedCle());
        this.toCreate.setAffectationId(((ComboBoxModel)this.getCbAffectation().getModel()).getSelectedCle());
        this.toCreate.setBodyId(((ComboBoxModel)this.getCbBody().getModel()).getSelectedCle());
        this.toCreate.setModelId(((ComboBoxModel)this.getCbModel().getModel()).getSelectedCle());
        this.toCreate.setAnalyticCodeId(((ComboBoxModel)this.getCbAnalyticCode().getModel()).getSelectedCle());
        if (!this.getTxtSortie().getText().equals("")) {
            this.toCreate.setArchive(ConversionTime.stringToDate(this.getTxtSortie().getText(), "dd/MM/yyyy").before(new Date()));
        }
        if (this.getCbLocation().isSelected()) {
            this.toCreate.setOwner(this.getTxtOwner().getText());
            this.toCreate.setLocationLimit(ConversionTime.stringToDate(this.getTxtLocationLimit().getText(), "dd/MM/yyyy"));
            this.toCreate.setLocationKm(!this.getTxtKm().getText().equals("") ? Integer.parseInt(this.getTxtKm().getText()) : 0);
            this.toCreate.setLocationPrice(!this.getTxtLocationPrice().getText().equals("") ? Float.parseFloat(this.getTxtLocationPrice().getText()) : 0.0f);
        }
        if (this.toCreate.insert()) {
            this.enregistrement = true;
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveSucceed"), LanguageTranslator.getString("message.done"), 1);
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveError"), LanguageTranslator.getString("message.saveError"), 0);
        }
    }

    private JTextField getTxtGuarantee() {
        if (this.txtGuarantee == null) {
            this.txtGuarantee = new JTextField();
            this.txtGuarantee.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogCreationVehicule.this.getTxtGuarantee());
                }
            });
        }
        return this.txtGuarantee;
    }

    private JPanel getPnlLocation() {
        if (this.pnlLocation == null) {
            GridBagConstraints gcLblOwner = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, 17, new Insets(0, 5, 0, 5));
            GridBagConstraints gcTxtOwner = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 2, 10, new Insets(2, 0, 2, 5));
            GridBagConstraints gcLblLength = Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 2, 17, new Insets(0, 5, 0, 5));
            GridBagConstraints gcTxtLength = Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 2, 10, new Insets(2, 0, 2, 5));
            GridBagConstraints gcLblKmMaxi = Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 2, 17, new Insets(0, 5, 0, 5));
            GridBagConstraints gcTxtKmMaxi = Fonctions.getGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 2, 10, new Insets(2, 0, 2, 5));
            GridBagConstraints gcLblLocPrice = Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 2, 17, new Insets(0, 5, 0, 5));
            GridBagConstraints gcTxtLocPrice = Fonctions.getGridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 2, 10, new Insets(2, 0, 2, 5));
            this.lblKmMaxi = new JLabel();
            this.lblKmMaxi.setText(LanguageTranslator.getString("vehicle.locationKm"));
            this.lblKmMaxi.setEnabled(false);
            this.lblOwner = new JLabel();
            this.lblOwner.setText(LanguageTranslator.getString("generics.owner"));
            this.lblOwner.setEnabled(false);
            this.lblLength = new JLabel();
            this.lblLength.setText(LanguageTranslator.getString("vehicle.locationLimit"));
            this.lblLength.setEnabled(false);
            this.lblLocationPrice = new JLabel();
            this.lblLocationPrice.setText(LanguageTranslator.getString("vehicle.locationPrice"));
            this.lblLocationPrice.setEnabled(false);
            this.pnlLocation = new JPanel();
            this.pnlLocation.setLayout(new GridBagLayout());
            this.pnlLocation.setBorder(new CheckBoxBorder(this.getCbLocation(), this.pnlLocation, BorderFactory.createLineBorder(SystemColor.activeCaption, 1)));
            this.pnlLocation.add((Component)this.lblOwner, gcLblOwner);
            this.pnlLocation.add((Component)this.getTxtOwner(), gcTxtOwner);
            this.pnlLocation.add((Component)this.lblLength, gcLblLength);
            this.pnlLocation.add((Component)this.getTxtLocationLimit(), gcTxtLength);
            this.pnlLocation.add((Component)this.lblKmMaxi, gcLblKmMaxi);
            this.pnlLocation.add((Component)this.getTxtKm(), gcTxtKmMaxi);
            this.pnlLocation.add((Component)this.lblLocationPrice, gcLblLocPrice);
            this.pnlLocation.add((Component)this.getTxtLocationPrice(), gcTxtLocPrice);
        }
        return this.pnlLocation;
    }

    private JCheckBox getCbLocation() {
        if (this.cbLocation == null) {
            this.cbLocation = new JCheckBox();
            this.cbLocation.setText(LanguageTranslator.getString("generics.location"));
            this.cbLocation.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean enable = DialogCreationVehicule.this.getCbLocation().isSelected();
                    Fonctions.setEnabled(DialogCreationVehicule.this.getPnlLocation(), enable);
                    DialogCreationVehicule.this.getPnlLocation().repaint();
                }
            });
        }
        return this.cbLocation;
    }

    private JTextField getTxtLocationPrice() {
        if (this.txtLocationPrice == null) {
            this.txtLocationPrice = new JTextField();
            this.txtLocationPrice.setEnabled(false);
        }
        return this.txtLocationPrice;
    }

    private JTextField getTxtOwner() {
        if (this.txtOwner == null) {
            this.txtOwner = new JTextField();
            this.txtOwner.setEnabled(false);
        }
        return this.txtOwner;
    }

    private JTextField getTxtLocationLimit() {
        if (this.txtLocationLimit == null) {
            this.txtLocationLimit = new JTextField();
            this.txtLocationLimit.setEnabled(false);
            this.txtLocationLimit.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogCreationVehicule.this.getTxtLocationLimit());
                }
            });
        }
        return this.txtLocationLimit;
    }

    private JTextField getTxtKm() {
        if (this.txtKm == null) {
            this.txtKm = new JTextField();
            this.txtKm.setEnabled(false);
        }
        return this.txtKm;
    }
}

